
-- Change for db_upgrade_base 20190805_16130 
SET search_path = fast, pg_catalog;

CREATE OR REPLACE FUNCTION pat_strips__parse() RETURNS trigger
 LANGUAGE plpgsql
AS $_$
	DECLARE
		i 		int;
		bytes 	bytea	:= new.values;
		length	int 	:= octet_length(new.values);
		tmpLen 	int 	:= 0;
		suBytes bytea;
	begin
		-- Return if not layer 4		
		IF NEW.layer <> 4 THEN 
			RETURN NEW;
		END IF;
		
		-- Walk through the offsets and build all binary substring from 'values'
		FOR i IN REVERSE length..1
		LOOP
			IF NEW.offsets[i] + 1 != NEW.offsets[i+1] THEN
				tmpLen :=1;
			ELSE
				tmpLen := tmpLen + 1;
			END IF;
			suBytes := substring(bytes from i for tmpLen);

			-- Enter binary substring to pat_payload_search
	        BEGIN
			    INSERT INTO fast.pat_payload_search(pat_strip_id, word)
			      VALUES(NEW.pat_strip_id, suBytes);
			-- Duplicates are prevented by the table constrains
			-- Embrace the rejection
        	EXCEPTION WHEN unique_violation THEN
 		       -- hb prevent logging -- RAISE NOTICE '{%, %} already exists in table. Skipping...', NEW.pat_strip_id, suBytes;
            	-- Do nothing, and skip this duplicate data.
        	END;

 		END LOOP;
		
		return NEW;

	end
$_$;