-- New flood.snapshot  table

DO LANGUAGE plpgsql $$
		BEGIN
		
		SET search_path = public, pg_catalog; 
		
		-- drop old table
		DROP TABLE IF EXISTS flood.snapshots cascade;
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'flood'
		        AND c.relname = 'snapshot'
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN
		
		       -- create types in public schema
		       DROP TYPE IF EXISTS snapshot_type ;
		       DROP TYPE IF EXISTS format_type ;
               CREATE TYPE snapshot_type AS ENUM ('detect', 'trafficAnalyzer') ;
               CREATE TYPE format_type AS ENUM ('custom', 'json') ;
			   ALTER TYPE snapshot_type OWNER TO nms;
			   ALTER TYPE format_type OWNER TO nms;
			   
			   
			   CREATE TABLE flood.snapshot (
                id SERIAL NOT NULL ,
                cluster_id integer NOT NULL,
                group_id integer NOT NULL,
                type snapshot_type NOT NULL,
                version integer,
                format format_type  NOT NULL,
                since timestamp NOT NULL DEFAULT now(),     
                data bytea NOT NULL,
				constraint pk_snapshot primary key(id)
               );

             ALTER TABLE flood.snapshot OWNER TO nms;
             GRANT ALL ON TABLE flood.snapshot TO nms;
			 GRANT ALL ON TABLE flood.snapshot TO PUBLIC;
             GRANT ALL ON TABLE flood.snapshot TO ndbadm;

			 CREATE INDEX snapshot_cluster_group ON flood.snapshot(cluster_id,group_id) ;
			 CREATE INDEX snapshot_since ON flood.snapshot(since) ;
			 
			 INSERT INTO public.PARAM (NAME,SUBNAME,INT_VAL,DESCRIPTION) VALUES ('Purge','snapshot_history', 14,'Snapshot data aging in days(default)'); 
			 INSERT INTO public.PARAM (NAME,SUBNAME,INT_VAL,DESCRIPTION) VALUES ('Snapshot','time_interval', 10,'Minutes period to run snapshot(default 10 min)');
			   	   
			 END IF ;
	   
		
		END;
$$;  		

\i /opt/allot/DB/sql/all_purge_proc.sql 