-- New auth.ldap  table

DO LANGUAGE plpgsql $$
		BEGIN
		
		SET search_path = auth, pg_catalog; 
		
		PERFORM 1
		    FROM
		        pg_catalog.pg_class c
		        JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
		    WHERE
		        n.nspname = 'auth'
		        AND c.relname = 'ldap'
		        AND c.relkind = 'r';
		        
		    IF NOT FOUND THEN

			CREATE TABLE ldap (
				id SERIAL NOT NULL, 
				host text NOT NULL, 
				port integer NOT NULL, 
				start_tls boolean DEFAULT true NOT NULL, 
				base_dn text NOT NULL, 
				user_dn text NOT NULL, 
				password varchar(64) NOT NULL,
				PRIMARY KEY (id)
			);
				
			ALTER TABLE auth.ldap OWNER TO postgres;	

			REVOKE ALL ON TABLE ldap FROM PUBLIC;
			REVOKE ALL ON TABLE ldap FROM postgres;
			GRANT ALL ON TABLE ldap TO postgres;
			GRANT ALL ON TABLE ldap TO nms;
			GRANT SELECT, USAGE ON SEQUENCE ldap_id_seq TO nms;
			GRANT ALL ON SEQUENCE ldap_id_seq TO postgres;
			
		END IF ;
	   
		
	END;
$$;
