
\i /opt/allot/DB/sql/add_audit_log_tables.sql

DO LANGUAGE plpgsql $$
 DECLARE
  	syslog_type_id_var INTEGER;
	target_tab_id_var INTEGER;
	syslog_tab_id INTEGER;
	addr_var TEXT;
	name_var      TEXT;
	port_var INTEGER;
	ip_text_var TEXT;
	facility_var TEXT;
 BEGIN    

    select  into syslog_type_id_var target_type_id from public.post_target_types where name='syslog';
	
	-- Delete not complited records
	delete from notify.targets where target_type_id= syslog_type_id_var and complete=false; 
	
	-- Update for local hosts records in notify.targets
	update notify.targets  set addr='1' where target_type_id= syslog_type_id_var and ( addr like '%localhost%'  or addr like '%127.0.0.1%' or addr like '%::1%');
	
	--Delete no IP records
	delete from notify.targets where target_type_id= syslog_type_id_var and  addr <> '1' and length(split_part(reverse(split_part(addr,'@',2)),':',2)) =0;
	
	FOR target_tab_id_var, name_var,addr_var, facility_var, ip_text_var, port_var IN
	  select target_id,name, addr,
	  split_part(addr,'@',1), -- facility,
	  substr(split_part(addr,'@',2),1,length(split_part(addr,'@',2))-length(split_part(reverse(split_part(addr,'@',2)),':',1))-1) , -- ip_test,
	  substr(split_part(addr,'@',2),length(split_part(addr,'@',2))-length(split_part(reverse(split_part(addr,'@',2)),':',1))+1)  -- port_test
	  from notify.targets 
	  where target_type_id= syslog_type_id_var 
	    and addr<>'1'
	 LOOP  
	 
	 select into syslog_type_id_var pg_catalog.nextval('syslog_target_id_seq');
	 
	 
	 insert into public.syslog_target(id,name,ip,port,facility) 
                values(syslog_type_id_var, name_var,ip_text_var,cast (port_var as integer),facility_var);
	 
	 update notify.targets  set addr=cast (syslog_type_id_var as TEXT) where target_id=target_tab_id_var;
	 
	 -- RAISE NOTICE '%:  added to table public.syslog_target with id - % ', addr_var,syslog_type_id_var; 
   
   END LOOP;
   
 END $$;  
