drop view if exists flood.mtg_reqs_log;

create view flood.mtg_reqs_log
            (flood_id, orig_pattern_id, pattern_id, filter_id, uid, action, action_expire, action_flood_only, req_since,
             req_until) as
SELECT mtg_reqs_log_past.flood_id,
       mtg_reqs_log_past.orig_pattern_id,
       mtg_reqs_log_past.pattern_id,
       mtg_reqs_log_past.filter_id,
       mtg_reqs_log_past.uid,
       mtg_reqs_log_past.action,
       mtg_reqs_log_past.action_expire,
       mtg_reqs_log_past.action_flood_only,
       mtg_reqs_log_past.req_since,
       mtg_reqs_log_past.req_until
FROM flood.mtg_reqs_log_past
UNION ALL
SELECT r.flood_id,
       r.orig_pattern_id,
       r.pattern_id,
       r.filter_id,
       r.uid,
       r.action,
       r.action_expire,
       r.action_flood_only,
       GREATEST((SELECT max(p.req_until) AS max
           FROM flood.mtg_reqs_log_past p
           WHERE p.flood_id = r.flood_id), r.action_since) AS req_since,
        COALESCE(r.action_expire, 'infinity'::timestamp with time zone)                      AS req_until
        FROM flood.mtg_reqs r;
		
ALTER TABLE flood.mtg_reqs_log
    OWNER TO ndbadm;

COMMENT ON VIEW flood.mtg_reqs_log
    IS 'Evolution of mitigation requests';		

GRANT ALL ON TABLE flood.mtg_reqs_log TO ndbadm;	
GRANT SELECT ON TABLE flood.mtg_reqs_log TO ndb_readers;
GRANT ALL ON TABLE flood.mtg_reqs_log TO ndb_writers;	
		



