<!DOCTYPE html>
	<html dir="ltr">  
		<body>
		<p>
		<br><a>http://${(eventInfo.webUiServerIp)!"localhost"}/webui/floodreport#flood=${eventInfo.floodDetails.id?c}</a></br>
		<br/> 
		<table> 
			<tr>
				<td>Status:</td>
				<td>${eventInfo.floodDetails.status.status}</td>
			</tr> 
			<tr>
				<td>Duration:</td>
				<td>${eventInfo.floodDetails.duration}</td>
			</tr>
			<tr>
				<td>Importance:</td>
				<td>${eventInfo.floodDetails.importance.name()}</td>
			</tr>
			<tr>
				<td>Shape severity:</td><td>${(eventInfo.floodDetails.shapeSeverity)!""}</td>
			</tr> 
		</table> 
		<br>
			<#list eventInfo.blockInfoList>
				<table> 
				    <#items as blockInfo>
				      <tr><td>Blocked: <#if blockInfo.blockSuccess??>OK<#else>ERROR</#if> (${blockInfo.blockState})</td></tr>
					  <tr><td>pattern ${blockInfo.blockPatternId}, 
						  <#if blockInfo.explicit == false>
						  via flood ${blockInfo.floodId}
						  <#else>
							  <#if blockInfo.actionFloodOnly == true>while_flood_lasts
							  <#elseif (blockInfo.blockDuration > 0)>
								<#if blockInfo.blockDuration == 1800>for 30 minutes
								<#elseif blockInfo.blockDuration == 3600>for 60 minutes
								<#elseif blockInfo.blockDuration == 7200>for 2 hours
								<#else>NA
								</#if>
							  <#else>indefinitely
							  </#if>, by 
							  <#if blockInfo.blockPolicy??>policy ${blockInfo.blockPolicy}
							  <#else>user ${blockInfo.blockUser}
							  </#if>
						  </#if></td></tr>
					  <tr><td>${doubleFormatter(blockInfo.blockedTrafficBps)}bps, ${doubleFormatter(blockInfo.blockedTrafficPps)}pps</td></tr>
				    </#items>
			    </table> 
			</#list>
		</br>
		<table border="1"> 
			<tr>
				<th>Traffic:</th><th>deviation</th><th>observed</th><th>expected</th></tr>
			<tr>
				<td>percent:</td><td>${eventInfo.floodDetails.devPacketPercent} % packets</td>
				<td>${eventInfo.floodDetails.devBitPercent} % bits</td>
				<td></td>
			</tr> 
			<tr>
				<td>count:</td>
				<td>${doubleFormatter(eventInfo.floodDetails.devPacketCount)} packets</td>
				<td>${doubleFormatter(eventInfo.floodDetails.obsPktCount)} packets</td>
				<td>${doubleFormatter(eventInfo.floodDetails.expPktCount)} packets</td>
			</tr> 
            <tr>
				<td></td>
				<td>${doubleFormatter(eventInfo.floodDetails.devByteCount)} B</td>
				<td>${doubleFormatter(eventInfo.floodDetails.obsByteCount)} B</td>
				<td>${doubleFormatter(eventInfo.floodDetails.expByteCount)} B</td>
			</tr> 
			<tr>
				<td>rate:</td>
				<td>${doubleFormatter(eventInfo.floodDetails.devPacketRate)} pps</td>
				<td>${doubleFormatter(eventInfo.floodDetails.obsPktRate)} pps</td>
				<td>${doubleFormatter(eventInfo.floodDetails.expPktRate)} pps</td>
			</tr> 
			<tr>
				<td></td>
				<td>${doubleFormatter(eventInfo.floodDetails.devBitRate)} bps</td>
				<td>${doubleFormatter(eventInfo.floodDetails.obsBitRate)} bps</td>
				<td>${doubleFormatter(eventInfo.floodDetails.expBitRate)} bps</td>
			</tr>  
		</table> 
		<br/> 
		<table>
			<tr>
				<td>Last update:</td>
				<td>${(eventInfo.floodDetails.modifiedDate?string["yyyy-MM-dd HH:mm:ssZZZ"])!""}</td>
			</tr> 
			<tr>
				<td>Started:</td>
				<td>${(eventInfo.floodDetails.startDate?string["yyyy-MM-dd HH:mm:ssZZZ"])!""}</td>
			</tr> 
			<tr>
				<td>Stopped:</td>
				<td>${(eventInfo.floodDetails.stopDate?string["yyyy-MM-dd HH:mm:ssZZZ"])!""}</td>
			</tr> 
			<tr>
				<td>Stop details:</td>
				<td>${(eventInfo.floodDetails.stopDetails)!""}</td>
			</tr> 
		</table>  
		<br/>
		<table>
			<tr>
				<td>Sensor:</td>
				<td>${eventInfo.floodDetails.host}</td>
			</tr> 
			<tr>
				<td>Group:</td>
				<td>${eventInfo.floodDetails.groupName} (${(eventInfo.floodDetails.groupDescription)!""})</td>
			</tr> 
			<tr>
				<td>Type:</td>
				<td>${eventInfo.floodDetails.type} (${(eventInfo.floodDetails.typeDescr)!""})</td>
			</tr> 
			<tr>
				<td>ID:</td>
				<td>${eventInfo.floodDetails.id}</td>
			</tr> 
		</table> 
		<br>Reported by: `detect` at ${(eventInfo.floodDetails.host)!""}</br> 
		<br>Matched policy: ${(policyEventInfo.policyDescriptor.fullName)!""}</br>
		<br>Patterns: ${eventInfo.patternsCount}</br> 
 		</p>
	</body> 
</html>