<?xml version="1.0" encoding="UTF-8"?>
<mitigationRequest id="${data.getPlanId()}">
<#list data.mitigationPlanPatterns as pattern>
 <#if pattern.metadata.l3Type.name() == "IPV4">
  <pattern id="${pattern.id}">
    <metadata>
      <l3Type>IPV4</l3Type>
    </metadata>
    <fixed>
    <#if pattern.fixedLovs?has_content>
     <#list pattern.fixedLovs as lov>
    	<lov layer="${lov.layer.layerNum}" offset="${lov.offset}" value="${lov.value?string.@hexOctet}"/>
     </#list>  
    </#if>
    </fixed>
    <#if pattern.variable?has_content>
    <variable>
     <${pattern.variable.name}>
      <#list pattern.variable.operands as operand>
       <${operand.name}>
        <#list operand.operands as fixedoperand>
         <#list fixedoperand.getLOVs() as fixedLov>
          <lov layer="${fixedLov.layer.layerNum}" offset="${fixedLov.offset}" value="${fixedLov.value?string.@hexOctet}"/>
         </#list>
         </#list>
        </${operand.name}>
     	</#list>
     </${pattern.variable.name}>
    </variable>
    </#if>
  </pattern>
  </#if>
  </#list>
</mitigationRequest>
