<?xml version="1.0" encoding="UTF-8"?>
<mitigationRequest id="${data.getPlanId()}">
    <metadata>
        <statefulness>${data.metadata.stateful}</statefulness>
    </metadata>
<#list data.mitigationPlanPatterns as pattern>
  <pattern id="${pattern.id}">
    <metadata>
        <l3Type>${pattern.metadata.l3Type.name()}</l3Type>
        <#if pattern.metadata.dataSources?has_content>
        <context>
            <#list pattern.metadata.dataSources as data>
                <dataSource groupId="${data.groupId}" directionId="${data.directionId}" signalId="${data.signalId}"/>
            </#list>
        </context>
        </#if>
    </metadata>
    <fixed>
    <#if pattern.fixedLovs?has_content>
     <#list pattern.fixedLovs as lov>
    	<lov layer="${lov.layer.layerNum}" offset="${lov.offset}" value="${lov.value?string.@hexOctet}"/>
     </#list>  
    </#if>
    </fixed>
    <#if pattern.variable?has_content>
    <variable>
     <${pattern.variable.name}>
      <#list pattern.variable.operands as operand>
       <${operand.name}>
        <#list operand.operands as fixedoperand>
         <#list fixedoperand.getLOVs() as fixedLov>
          <lov layer="${fixedLov.layer.layerNum}" offset="${fixedLov.offset}" value="${fixedLov.value?string.@hexOctet}"/>
         </#list>
         </#list>
        </${operand.name}>
     	</#list>
     </${pattern.variable.name}>
    </variable>
    </#if>
  </pattern>
  </#list>
</mitigationRequest>
