/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary3.jobs.impl;

import asam.d.MCDAccessKey;
import asam.d.MCDControlPrimitive;
import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDataPrimitives;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDErrors;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDParameter;
import asam.d.MCDProtocolParameterSet;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDService;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDStartCommunication;
import asam.d.MCDStopCommunication;
import asam.d.MCDValue;
import com.audi.mcd.SharedData;
import com.audi.mcd.joblibrary3.constants.value.DefaultValue;
import com.audi.mcd.joblibrary3.jobs.AbstractJob;
import com.audi.mcd.joblibrary3.jobs.impl.AbstractSingleEcuJobImpl;
import com.audi.mcd.joblibrary3.jobs.impl.MCD3_PreDataSet;
import com.audi.mcd.joblibrary3.util.Conversions;
import com.audi.mcd.joblibrary3.util.McdEnumDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class MCD3_PostDataSet
extends AbstractSingleEcuJobImpl {
    private static final String REVISION = "1.0.20141103";
    protected static final int CONTROL_DTC_SETTING_ON_DELAY_TIME = 500;
    protected static final String[] REQUIRED_DIAG_COMMS = new String[]{"DiagnServi_CommuContrEnablRxAndDisabTxNormaCommuMessa", "DiagnServi_CommuContrEnablRxAndTxNormaCommuMessa", "DiagnServi_ContrDTCSetti", "DiagnServi_DiagnSessiContr", "DiagnServi_ECUResetKeyOffOnReset", "DiagnServi_WriteDataByIdentECUIdent"};
    private static Vector instances = null;
    protected boolean isModifyTimingEnabled = false;
    protected boolean isFunctionalAddressingDisabled = false;
    protected boolean isNormalCommunicationReEnabled = true;
    protected byte[] vehicleEquipmentCodeAndPrNumberCombination = null;
    protected String vwDataSetNumberOrEcuDataContainerNumber = null;
    protected String vwDataSetVersionNumber = null;
    protected boolean isWritingOfVwEolConfigurationEnabled = true;
    protected String hardwareAssemblyGroup = null;
    protected String hardwareTypeCode = null;
    protected String softwareAssemblyGroup = null;
    protected String softwareTypeCode = null;
    protected String softwareTypeVariant = null;
    protected long savedNumberOfErrorRepetitions = 0L;
    protected long savedStandTiminP2Serve = 0L;
    protected long savedExtenTiminP2Serve = 0L;
    protected long savedP3CanClientPhys = 0L;
    protected long savedP3CanClientFunc = 0L;
    protected long savedCanTransmissionTime = 0L;
    protected long savedStMinOverride = 0L;
    protected long savedRequestTime = 0L;
    protected MCDService currentService = null;
    protected MCDControlPrimitive controlPrimitive = null;
    protected MCDProtocolParameterSet protocolParameterSet = null;
    protected MCDRequestParameters protocolParameters = null;
    protected long maxStandTiminP2Serve = 0L;
    protected long maxExtenTiminP2Serve = 0L;

    public MCD3_PostDataSet() {
        this(REVISION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MCD3_PostDataSet(String pRevision) {
        super(pRevision);
        Class clazz = MCD3_PostDataSet.class;
        synchronized (clazz) {
            instances.addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Class clazz = MCD3_PreDataSet.class;
        synchronized (clazz) {
            instances.remove(this);
        }
        super.finalize();
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        this.logger.trace("Entering execute(...).");
        this.jobStatus = this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, pSingleEcuJob);
        if (this.jobStatus == AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS) {
            throw new NullPointerException("At least one of the call parameters of the job is null!");
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("prepareJob successful - executing job logic...");
            this.jobStatus = this.executeJobLogicGuarded();
        }
        this.finalizeJobGuarded();
        this.logger.trace("Leaving execute(...).");
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters) {
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus prepareJobGuarded(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        try {
            currentJobStatus = this.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pSingleEcuJob);
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in prepareJob() method.");
            this.logger.logThrowable(e);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in prepareJob() method.");
            this.logger.logThrowable(t);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareJob(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        this.jobStatus = super.prepareJob(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.jobStatus = this.readInputParameters(pRequestParameters, null);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.jobStatus = this.checkRequiredDiagComms(REQUIRED_DIAG_COMMS);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.logger.debug("Preparing protocol parameter set.");
        this.jobStatus = this.prepareProtocolParameterSet();
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        if (!this.isPduApiUsed) {
            this.logger.debug("Preparing global control primitives.");
            try {
                this.stopCommunication = this.stopCommunication(this.logicalLink);
                this.startCommunication = this.startCommunication(this.logicalLink);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating MCDStop/StartCommunication.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Reading ODX FLASH container.");
            if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
                this.logger.debug("Error reading ODX FLASH container.");
            }
        }
        Thread.currentThread().setPriority(10);
        this.logger.trace("Leaving prepareJob(...).");
        return this.jobStatus;
    }

    protected AbstractJob.JobStatus executeJobLogicGuarded() {
        AbstractJob.JobStatus currentJobCompletionStatus = null;
        try {
            currentJobCompletionStatus = this.executeJobLogic();
        }
        catch (MCDException mcde) {
            this.logger.debug("Caught MCDException in executeJobLogic() method.");
            this.logger.logThrowable(mcde);
            currentJobCompletionStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in executeJobLogic() method.");
            this.logger.logThrowable(e);
            currentJobCompletionStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in executeJobLogic() method.");
            this.logger.logThrowable(t);
            currentJobCompletionStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobCompletionStatus;
    }

    protected AbstractJob.JobStatus executeJobLogic() throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        AbstractJob.JobStatus currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
        JobStep currentJobStep = JobStep.values[0];
        this.setJobProgress(1L);
        if (!SharedData.isDataSetsWrittenSuccessfully()) {
            this.logger.warn("WARNING: Skipping writing of identification data due to previous errors!");
            this.setJobInfo("WARNING: Skipping writing of identification data due to previous errors!");
        } else {
            while (currentJobStep.compareTo(JobStep.POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY) < 0 && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
                this.logger.debug("Current job step  : " + currentJobStep);
                this.logger.debug("Current job status: " + currentJobStatus);
                if (currentJobStep == JobStep.WRITE_VW_DATA_SET_NUMBER_OR_ECU_DATA_CONTAINER_NUMBER) {
                    this.currentService = this.writeDataByIdentifier(this.logicalLink, "VW Data Set Number Or ECU Data Container Number");
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                    this.setJobProgress(10L);
                    currentJobStep = JobStep.WRITE_VW_DATA_SET_VERSION_NUMBER;
                    continue;
                }
                if (currentJobStep == JobStep.WRITE_VW_DATA_SET_VERSION_NUMBER) {
                    this.currentService = this.writeDataByIdentifier(this.logicalLink, "VW Data Set Version Number");
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                    this.setJobProgress(20L);
                    currentJobStep = JobStep.WRITE_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION;
                    continue;
                }
                if (currentJobStep == JobStep.WRITE_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION) {
                    this.currentService = this.writeDataByIdentifier(this.logicalLink, "Vehicle Equipment Code And PR Number Combination");
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                    this.setJobProgress(30L);
                    currentJobStep = JobStep.WRITE_VW_EOL_CONFIGURATION;
                    continue;
                }
                if (currentJobStep == JobStep.WRITE_VW_EOL_CONFIGURATION) {
                    this.currentService = this.writeDataByIdentifier(this.logicalLink, "VW EOL Configuration");
                    if (this.currentService == null) {
                        this.logger.info("Writing of \"VW EOL Configuration\" is not supported by this ECU.");
                    } else {
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                            this.logger.info("Ignoring write failure for \"VW EOL Configuration\" since it is optional.");
                            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                        }
                    }
                    this.setJobProgress(40L);
                    currentJobStep = JobStep.POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY;
                    continue;
                }
                if (currentJobStep == JobStep.DONE) continue;
                this.logger.error("*** UNKNOWN job step ***: " + currentJobStep);
                this.jobStatus = AbstractJob.JobStatus.ERROR;
            }
            this.jobStatus = currentJobStatus;
        }
        currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
        if (currentJobStep != JobStep.POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY && currentJobStep != JobStep.DONE) {
            currentJobStep = JobStep.POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY;
        }
        while (currentJobStep.compareTo(JobStep.DONE) < 0 && currentJobStatusPostProgramming == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            if (currentJobStep == JobStep.POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY) {
                if (!this.isFunctionalAddressingDisabled) {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Functional");
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                    }
                }
                this.currentService = this.diagnosticSessionControl(this.logicalLink, !this.isFunctionalAddressingDisabled, "Extended Diagnostic Session", true);
                currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                    currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(45L);
                currentJobStep = JobStep.POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF;
                continue;
            }
            if (currentJobStep == JobStep.POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF) {
                this.currentService = this.controlDtcSetting(this.logicalLink, !this.isFunctionalAddressingDisabled, "Off");
                currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                    currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(50L);
                currentJobStep = JobStep.POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX;
                continue;
            }
            if (currentJobStep == JobStep.POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX) {
                this.currentService = this.communicationControl(this.logicalLink, !this.isFunctionalAddressingDisabled, "Enable Rx And Disable Tx", "Normal Communication Messages", "All Networks");
                currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                    currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(55L);
                if (this.isNormalCommunicationReEnabled) {
                    currentJobStep = JobStep.POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX;
                    continue;
                }
                currentJobStep = JobStep.ECU_RESET;
                continue;
            }
            if (currentJobStep == JobStep.POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX) {
                this.currentService = this.communicationControl(this.logicalLink, !this.isFunctionalAddressingDisabled, "Enable Rx And Tx", "Normal Communication Messages", "All Networks");
                if (!this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "RequestTime", 500L);
                }
                if ((currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true)) == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                    currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(60L);
                currentJobStep = JobStep.POSTPROGRAMMING_CONTROL_DTC_SETTING_ON;
                continue;
            }
            if (currentJobStep == JobStep.POSTPROGRAMMING_CONTROL_DTC_SETTING_ON) {
                this.currentService = this.controlDtcSetting(this.logicalLink, !this.isFunctionalAddressingDisabled, "On");
                if (!this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "RequestTime", this.savedRequestTime);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_P3Func", 500000L);
                }
                currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                    currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(65L);
                currentJobStep = JobStep.ECU_RESET;
                continue;
            }
            if (currentJobStep == JobStep.ECU_RESET) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_P3Func", this.savedP3CanClientFunc);
                }
                if (!this.isFunctionalAddressingDisabled && this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                }
                this.currentService = this.ecuReset(this.logicalLink, Boolean.FALSE, "Key Off On Reset");
                currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NO_ERROR) {
                    currentJobStep = JobStep.SLEEP_ECU_SOFTWARE_RESET_DURATION;
                } else {
                    if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                        currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                    }
                    currentJobStep = JobStep.RESTORE_PROTOCOL_PARAMETERS;
                }
                this.setJobProgress(70L);
                continue;
            }
            if (currentJobStep == JobStep.SLEEP_ECU_SOFTWARE_RESET_DURATION) {
                this.logger.debug("Sleeping for 2000 milliseconds...");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    this.logger.error("Sleeping thread was interrupted unexpectedly!");
                }
                this.setJobProgress(80L);
                currentJobStep = JobStep.RESTORE_PROTOCOL_PARAMETERS;
                continue;
            }
            if (currentJobStep == JobStep.RESTORE_PROTOCOL_PARAMETERS) {
                if (this.isPduApiUsed) {
                    this.logger.debug("Resetting CP_StMinOverride to value " + this.savedStMinOverride + " us.");
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_StMinOverride", this.savedStMinOverride);
                }
                if (!this.isFunctionalAddressingDisabled) {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                    }
                }
                currentJobStep = JobStep.DONE;
                this.setJobProgress(90L);
                continue;
            }
            if (currentJobStep == JobStep.DONE) continue;
            this.logger.error("*** UNKNOWN job step ***: " + currentJobStep);
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.debug("Final job status: " + currentJobStatus);
        this.setJobProgress(99L);
        return currentJobStatus;
    }

    protected void finalizeJobGuarded() {
        try {
            this.finalizeJob();
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in finalizeJob() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in finalizeJob() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
    }

    protected void finalizeJob() {
        this.logger.trace("Entering finalizeJob(...).");
        super.finalizeJob();
        this.finalizeLogging();
    }

    protected void finalizeLogging() {
        this.logger.finalize(this.getCurrentJobRuntimeAsString());
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters, String pShortNameOfWrappingParameter) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfInputParameters = 0L;
        MCDRequestParameter inputParameter = null;
        MCDRequestParameters nestedParameters = null;
        String inputParameterName = null;
        this.logger.trace("Entering readInputParameters(...).");
        try {
            numberOfInputParameters = pRequestParameters.getCount();
        }
        catch (MCDException mcde) {
            if (pShortNameOfWrappingParameter == null) {
                this.logger.fatal("Error determining number of job input parameters.");
            } else {
                this.logger.fatal("Error determining number of parameters for structured INPUT-PARAM \"" + pShortNameOfWrappingParameter + "\".");
            }
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pShortNameOfWrappingParameter == null) {
            this.logger.info("Number of INPUT-PARAMETERS to read: " + numberOfInputParameters);
        } else {
            this.logger.info("Number of PARAMS to read for INPUT-PARAM \"" + pShortNameOfWrappingParameter + "\": " + numberOfInputParameters);
        }
        for (long i = 0L; i < numberOfInputParameters; ++i) {
            try {
                inputParameter = pRequestParameters.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                inputParameterName = inputParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting SHORT-NAME of job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (inputParameterName.equals("IPA_Refer")) {
                try {
                    this.vehicleEquipmentCodeAndPrNumberCombination = this.getParameterValueBytefield((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + Conversions.byteArray2String(this.vehicleEquipmentCodeAndPrNumberCombination));
                }
                catch (Exception e) {
                    this.vehicleEquipmentCodeAndPrNumberCombination = DefaultValue.PostDataSet.REFERENZ;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + DefaultValue.PostDataSet.REFERENZ + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_ZDCIdent")) {
                try {
                    this.vwDataSetNumberOrEcuDataContainerNumber = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.vwDataSetNumberOrEcuDataContainerNumber);
                }
                catch (Exception e) {
                    this.vwDataSetNumberOrEcuDataContainerNumber = "-----------";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + "-----------" + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_ZDCVersi")) {
                try {
                    this.vwDataSetVersionNumber = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.vwDataSetVersionNumber);
                    }
                }
                catch (Exception e) {
                    this.vwDataSetVersionNumber = "----";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + "----" + ".");
                    this.logger.logThrowable(e);
                }
                if (!this.vwDataSetVersionNumber.equals("FAIL")) continue;
                SharedData.setDataSetsWrittenSuccessfully(false);
                continue;
            }
            if (inputParameterName.equals("IPA_WriteVWEOLConfi")) {
                try {
                    this.isWritingOfVwEolConfigurationEnabled = Boolean.valueOf(this.getParameterValueAsString((MCDParameter)inputParameter));
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + String.valueOf(this.isWritingOfVwEolConfigurationEnabled));
                }
                catch (Exception e) {
                    this.isWritingOfVwEolConfigurationEnabled = Boolean.valueOf("TRUE");
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + "TRUE" + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_VWEOLConfi")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_HardwAssemGroup")) {
                try {
                    this.hardwareAssemblyGroup = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.hardwareAssemblyGroup);
                }
                catch (Exception e) {
                    this.hardwareAssemblyGroup = "---";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.hardwareAssemblyGroup + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_HardwTypeCode")) {
                try {
                    this.hardwareTypeCode = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.hardwareTypeCode);
                }
                catch (Exception e) {
                    this.hardwareTypeCode = "----";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.hardwareTypeCode + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_SoftwAssemGroup")) {
                try {
                    this.softwareAssemblyGroup = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.softwareAssemblyGroup);
                }
                catch (Exception e) {
                    this.softwareAssemblyGroup = "---";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.softwareAssemblyGroup + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_SoftwTypeCode")) {
                try {
                    this.softwareTypeCode = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.softwareTypeCode);
                }
                catch (Exception e) {
                    this.softwareTypeCode = "----";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.softwareTypeCode + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_SoftwTypeVaria")) {
                try {
                    this.softwareTypeVariant = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.softwareTypeVariant);
                }
                catch (Exception e) {
                    this.softwareTypeVariant = "----";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.softwareTypeVariant + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            return AbstractJob.JobStatus.ERROR;
        }
        if (this.vwDataSetNumberOrEcuDataContainerNumber.length() > 11) {
            this.logger.error("The length of the input parameter \"IPA_ZDCIdent\" (" + this.vwDataSetNumberOrEcuDataContainerNumber.length() + ") exceeds the maximum length!");
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        } else if (this.vwDataSetNumberOrEcuDataContainerNumber.length() < 9) {
            this.logger.error("The length of the input parameter \"IPA_ZDCIdent\" (" + this.vwDataSetNumberOrEcuDataContainerNumber.length() + ") is lower than the minimum length (excl. trailing spaces)!");
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        } else if (this.vwDataSetNumberOrEcuDataContainerNumber.length() < 11) {
            this.logger.warn("The length of the input parameter \"IPA_ZDCIdent\" (" + this.vwDataSetNumberOrEcuDataContainerNumber.length() + ") does NOT match the expected length!");
            this.logger.info("Padding input parameter \"IPA_ZDCIdent\" with value \"" + this.vwDataSetNumberOrEcuDataContainerNumber + "\" with trailing spaces...");
            while (this.vwDataSetNumberOrEcuDataContainerNumber.length() < 11) {
                this.vwDataSetNumberOrEcuDataContainerNumber = this.vwDataSetNumberOrEcuDataContainerNumber + " ";
            }
            this.logger.info("... new value incl. padding is: \"" + this.vwDataSetNumberOrEcuDataContainerNumber + "\".");
        }
        this.logger.trace("Leaving readInputParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus addOutputParameters(MCDResponse pResponse) {
        MCDResponseParameter respParam_outParam = null;
        MCDValue value_outParam = null;
        if (pResponse == null) {
            this.logger.error("addOutputParameters() called with null argument!");
        } else {
            this.logger.debug("Retrieving response parameters.");
            try {
                respParam_outParam = pResponse.getResponseParameters().getItemByName("OPA_OutParam");
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_OutParam\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Retrieving values.");
            try {
                value_outParam = this.jobApi.createValue(11);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting value of job output parameter with SHORT-NAME \"OPA_OutParam\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Setting values.");
            this.logger.debug("Setting result: " + this.jobStatus);
            this.setJobInfo("Job result: " + this.jobStatus);
            try {
                value_outParam.setUint32((long)this.jobStatus.intValue());
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting value of job output parameter with SHORT-NAME \"OPA_OutParam\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Setting output parameters.");
            try {
                respParam_outParam.setValue(value_outParam);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting parameter value of job output parameter with SHORT-NAME \"OPA_Resul\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus prepareProtocolParameterSet() {
        MCDRequest protocolParameterSetRequest = null;
        MCDRequestParameter comParam = null;
        MCDValue paramValue = null;
        String modifyTiming = null;
        this.logger.trace("Entering prepareProtocolParameterSet(...).");
        try {
            this.protocolParameterSet = (MCDProtocolParameterSet)this.logicalLink.createDiagComPrimitiveByType(1193);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating ProtocolParameterSet!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            this.protocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error fetching COMPARAM values from interface!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            protocolParameterSetRequest = this.protocolParameterSet.getRequest();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting request of ProtocolParameterSet!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            this.protocolParameters = protocolParameterSetRequest.getRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting COMPARAMs from ProtocolParameterSet request!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            comParam = this.protocolParameters.getItemByName("CP_ModifyTiming");
            this.isPduApiUsed = true;
            this.logger.info("Using PDU-API firmware with ISO 22900-2 COMPARAMs.");
            paramValue = comParam.getValue();
            modifyTiming = paramValue.getValueAsString();
            this.isModifyTimingEnabled = modifyTiming.equals("Enabled");
        }
        catch (MCDException mcde) {
            this.isPduApiUsed = false;
            this.logger.info("Using Softing EIDBSS firmware with proprietary COMPARAMs.");
        }
        this.logger.debug("Saving initial COMPARAM values.");
        try {
            if (this.isPduApiUsed) {
                this.savedCanTransmissionTime = this.getProtocolParameterUint32(this.protocolParameterSet, this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime);
                this.savedP3CanClientPhys = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P3Phys");
                this.savedP3CanClientFunc = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P3Func");
                this.savedStMinOverride = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_StMinOverride");
                this.savedStMinOverride &= 0xFFFFFFFFL;
                this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_RepeatReqCountApp");
                this.savedStandTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
                this.savedExtenTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
            } else {
                this.savedCanTransmissionTime = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_CANTransTime");
                this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "NumberOfErrorRepetitions");
                this.savedStandTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "ResponseTimeout");
                this.savedExtenTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "RC78ResponseTimeout");
                this.savedP3CanClientPhys = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_P3CANClienPhys");
                this.savedP3CanClientFunc = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_P3CANClienFunc");
                this.savedRequestTime = this.getProtocolParameterUint32(this.protocolParameterSet, "RequestTime");
            }
            this.logger.debug("CP_P2Max /CP_P6Max : " + this.savedStandTiminP2Serve);
            this.logger.debug("CP_P2Star/CP_P6Star: " + this.savedExtenTiminP2Serve);
            this.logger.debug("CP_StMinOverride   : " + this.savedStMinOverride);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error saving initial COMPARAM values!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving prepareProtocolParameterSet(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected void logProtocolParameterSet(MCDProtocolParameterSet pProtocolParameterSet) throws MCDException {
        MCDRequestParameters comParams = null;
        long numberOfComParams = 0L;
        MCDRequestParameter comParam = null;
        MCDValue paramValue = null;
        this.logger.trace("Entering logProtocolParameterSet(...).");
        pProtocolParameterSet.fetchValuesFromInterface();
        comParams = pProtocolParameterSet.getRequest().getRequestParameters();
        numberOfComParams = comParams.getCount();
        this.logger.debug("Found " + numberOfComParams + " protocolParameters - current values are:");
        block5: for (long i = 0L; i < numberOfComParams; ++i) {
            comParam = comParams.getItemByIndex(i);
            paramValue = comParam.getValue();
            this.logMessage = "- " + comParam.getShortName() + ": ";
            switch (paramValue.getDataType()) {
                case 11: {
                    this.logMessage = this.logMessage + String.valueOf(paramValue.getUint32());
                    this.logger.debug(this.logMessage);
                    continue block5;
                }
                case 1: 
                case 14: {
                    this.logMessage = this.logMessage + paramValue.getValueAsString();
                    this.logger.debug(this.logMessage);
                    continue block5;
                }
                case 3: {
                    this.logMessage = this.logMessage + paramValue.getValueAsString();
                    this.logger.debug(this.logMessage);
                    continue block5;
                }
                default: {
                    this.logMessage = this.logMessage + "Data type of " + comParam.getShortName() + " is not ( yet) interpreted!";
                    this.logger.debug(this.logMessage);
                }
            }
        }
        this.logger.trace("Leaving logProtocolParameterSet(...).");
    }

    protected MCDStartCommunication startCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStartCommunication startCommunicationTmp = null;
        this.logger.trace("Entering startCommunication(...).");
        startCommunicationTmp = (MCDStartCommunication)pLogicalLink.createDiagComPrimitiveByType(1201);
        this.logger.trace("Leaving startCommunication(...).");
        return startCommunicationTmp;
    }

    protected MCDStopCommunication stopCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStopCommunication stopCommunicationTmp = null;
        this.logger.trace("Entering stopCommunication(...).");
        stopCommunicationTmp = (MCDStopCommunication)pLogicalLink.createDiagComPrimitiveByType(1202);
        this.logger.trace("Leaving stopCommunication(...).");
        return stopCommunicationTmp;
    }

    protected MCDService createService(MCDLogicalLink pLogicalLink, String pServiceShortName) throws MCDException {
        MCDService service = null;
        try {
            service = (MCDService)pLogicalLink.createDiagComPrimitiveByName(pServiceShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating service with SHORT-NAME: " + pServiceShortName);
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            throw mcde;
        }
        return service;
    }

    protected MCDService diagnosticSessionControl(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pDiagnosticSessionType, boolean pUseFunctionalAddressing) throws MCDException {
        MCDService diagnosticSessionControl = null;
        this.logger.trace("Entering diagnosticSessionControl(...).");
        diagnosticSessionControl = pUseFunctionalAddressing ? this.createService(pLogicalLink, "DiagnServi_DiagnSessiContrFUNCT") : this.createService(pLogicalLink, "DiagnServi_DiagnSessiContr");
        this.setSuppressPosRspMsgIndicationBit(diagnosticSessionControl, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)diagnosticSessionControl, "Param_DiagnSessiType", pDiagnosticSessionType);
        this.logger.trace("Leaving diagnosticSessionControl(...).");
        return diagnosticSessionControl;
    }

    protected MCDService communicationControl(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pControlType, String pCommunicationType, String pSubnetNumber) throws MCDException {
        MCDService communicationControl = null;
        this.logger.trace("Entering communicationControl(...).");
        if (pControlType.equalsIgnoreCase("Enable Rx And Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrEnablRxAndTxNormaCommuMessa");
        } else if (pControlType.equalsIgnoreCase("Enable Rx And Disable Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrEnablRxAndDisabTxNormaCommuMessa");
        } else if (pControlType.equalsIgnoreCase("Disable Rx And Enable Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrDisabRxAndEnablTxNormaCommuMessa");
        } else if (pControlType.equalsIgnoreCase("Disable Rx And Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrDisabRxAndTxNormaCommuMessa");
        } else {
            throw new IllegalArgumentException("Invalid controlType.");
        }
        this.setSuppressPosRspMsgIndicationBit(communicationControl, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_CommuTypeBits0To1", pCommunicationType);
        this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_CommuTypeBits4To7", pSubnetNumber);
        this.logger.trace("Leaving communicationControl(...).");
        return communicationControl;
    }

    protected MCDService controlDtcSetting(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pDtcSettingType) throws MCDException {
        MCDService controlDtcSetting = null;
        this.logger.trace("Entering controlDtcSetting(...).");
        controlDtcSetting = this.createService(pLogicalLink, "DiagnServi_ContrDTCSetti");
        this.setSuppressPosRspMsgIndicationBit(controlDtcSetting, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)controlDtcSetting, "Param_DTCSettiType", pDtcSettingType);
        this.logger.trace("Leaving controlDtcSetting(...).");
        return controlDtcSetting;
    }

    protected MCDService ecuReset(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pResetType) throws MCDException {
        MCDService ecuReset = null;
        this.logger.trace("Entering ecuReset(...).");
        if (pResetType.equals("Hard Reset")) {
            ecuReset = this.createService(pLogicalLink, "DiagnServi_ECUResetHardReset");
        } else if (pResetType.equals("Key Off On Reset")) {
            ecuReset = this.createService(pLogicalLink, "DiagnServi_ECUResetKeyOffOnReset");
        } else if (pResetType.equals("Soft Reset")) {
            ecuReset = this.createService(pLogicalLink, "DiagnServi_ECUResetSoftReset");
        } else {
            throw new IllegalArgumentException("Invalid resetType.");
        }
        pSuppressResponse.hashCode();
        this.logger.trace("Leaving ecuReset(...).");
        return ecuReset;
    }

    protected void setSuppressPosRspMsgIndicationBit(MCDService pService, Boolean pValue) throws MCDException {
        this.logger.trace("Entering setSuppressPosRspMsgIndicationBit(...).");
        this.setRequestParameterString((MCDDiagComPrimitive)pService, "Param_SupprPositRespoMessaIndicBit", pValue.toString().toUpperCase());
        if (pValue == Boolean.TRUE && this.isMcd300Interface) {
            this.logger.debug("Setting SPR flag.");
            this.vendorSpecific.setSuppressPositiveResponseUnchecked(pService);
        }
        this.logger.trace("Leaving setSuppressPosRspMsgIndicationBit(...).");
    }

    protected void setRequestParameterUint32(MCDRequestParameters pRequestParameters, String pRequestParameterName, long pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterUint32(...).");
        requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        value = requestParameter.createValue();
        value.setUint32(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterUint32(...).");
    }

    protected void setRequestParameterUint32(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, long pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterUint32(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        value.setUint32(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterUint32(...).");
    }

    protected void setRequestParameterString(MCDRequestParameters pRequestParameters, String pRequestParameterName, String pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterString(...).");
        requestParameter = this.getRequestParameter(pRequestParameters, pRequestParameterName);
        value = requestParameter.createValue();
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected void setRequestParameterString(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, String pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterString(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        this.logger.debug("Setting parameter to: " + pValue);
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected void setRequestParameterBytefield(MCDRequestParameters pRequestParameters, String pRequestParameterName, byte[] pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterBytefield(...).");
        requestParameter = this.getRequestParameter(pRequestParameters, pRequestParameterName);
        value = requestParameter.createValue();
        value.setBytefield(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterBytefield(...).");
    }

    protected void setRequestParameterBytefield(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, byte[] pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterBytefield(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        value.setBytefield(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterBytefield(...).");
    }

    protected MCDRequestParameter getRequestParameter(MCDRequestParameters pRequestParameters, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = null;
        MCDRequestParameter currentRequestParameter = null;
        MCDRequestParameters requestSubParameters = null;
        long numberOfRequestParameters = 0L;
        this.logger.debug("Getting request parameter: " + pRequestParameterName);
        try {
            requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        }
        catch (MCDException mcde) {
            if (mcde.getError().getCode() != 49184 && mcde.getError().getCode() != 49177) {
                this.logger.debug("Error getting request parameter with SHORT-NAME \"" + pRequestParameterName + "\"!");
                this.logger.logThrowable(mcde);
            }
            numberOfRequestParameters = pRequestParameters.getCount();
            for (long i = 0L; i < numberOfRequestParameters && requestParameter == null; ++i) {
                currentRequestParameter = pRequestParameters.getItemByIndex(i);
                if (currentRequestParameter.getType() != 17) continue;
                requestSubParameters = currentRequestParameter.getParameters();
                requestParameter = this.getRequestParameter(requestSubParameters, pRequestParameterName);
            }
        }
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected MCDRequestParameter getRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive.getRequest().getRequestParameters(), pRequestParameterName);
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected void updateProtocolParameters(MCDProtocolParameterSet pProtocolParameterSet) {
        MCDResult result = null;
        int diagComprimitiveState = 0;
        this.logger.trace("Entering updateProtocolParameters(...).");
        try {
            result = pProtocolParameterSet.executeSync();
        }
        catch (MCDException mcde) {
            this.logger.error("Error executing MCDProtocolParameterSet.");
            this.logger.logThrowable(mcde);
            return;
        }
        try {
            diagComprimitiveState = pProtocolParameterSet.getState();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining comprimitive state of protocol parameter set.");
            this.logger.logThrowable(mcde);
            return;
        }
        this.logger.info("Current state of protocol parameter set is: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComprimitiveState));
        if (result != null) {
            boolean resultHasError = true;
            try {
                resultHasError = result.hasError();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining if result has an error.");
                this.logger.logThrowable(mcde);
                return;
            }
            if (resultHasError) {
                MCDError error = null;
                this.logger.debug("Error updating protocol parameters: Result has error.");
                try {
                    error = result.getError();
                }
                catch (Exception e) {
                    this.logger.error("Error getting error from result.");
                    this.logger.logThrowable(e);
                    return;
                }
                this.logger.logMcdError(error);
            } else {
                int executionState = -1;
                try {
                    executionState = result.getResultState().getExecutionState();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting execution state from result state.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.debug("Success updating protocol parameters.");
                this.logger.debug("ResultState of MCDProtocolParameterSet: " + McdEnumDecoder.decodeMcdExecutionState(executionState));
            }
        } else {
            MCDErrors errors = null;
            long numberOfErrors = 0L;
            MCDError error = null;
            this.logger.debug("Error updating protocol parameters: Result is null. This is caused by a DTS bug.");
            try {
                errors = pProtocolParameterSet.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting errors from MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            try {
                numberOfErrors = errors.getCount();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining number of errors of MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = errors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + " from MCDProtocolParameterSet.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving updateProtocolParameters(...).");
    }

    protected AbstractJob.JobStatus updateSessionTimings(MCDProtocolParameterSet pProtocolParameterSet, long pStandTiminP2Serve, long pExtenTiminP2Serve) throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int canTransmissionTime = 0;
        int p2CanServer = 0;
        int p2StarCanServer = 0;
        this.logger.trace("Entering updateSessionTimings(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.isPduApiUsed) {
            if (!this.isModifyTimingEnabled) {
                canTransmissionTime = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime);
                p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
                p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
                this.logger.debug("Setting P2_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ") from " + p2CanServer + " \u00b5s to " + (pStandTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max, pStandTiminP2Serve * 1000L + (long)canTransmissionTime);
                this.logger.debug("Setting P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") from " + p2StarCanServer + " \u00b5s to " + (pExtenTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star, pExtenTiminP2Serve * 1000L + (long)canTransmissionTime);
            }
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
            this.logger.debug("P2_CAN_Server  (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ")  is now set to " + p2CanServer + " \u00b5s.");
            this.logger.debug("P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") is now set to " + p2StarCanServer + " \u00b5s.");
        } else {
            canTransmissionTime = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ComPar_CANTransTime");
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("Setting P2_CAN_Server (ResponseTimeout) from " + p2CanServer + " ms to " + (pStandTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "ResponseTimeout", pStandTiminP2Serve + (long)canTransmissionTime);
            this.logger.debug("Setting P2*_CAN_Server (RC78ResponseTimeout) from " + p2StarCanServer + " ms to " + (pExtenTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "RC78ResponseTimeout", pExtenTiminP2Serve + (long)canTransmissionTime);
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("P2_CAN_Server  (ResponseTimeout)     is now set to " + p2CanServer + " ms.");
            this.logger.debug("P2*_CAN_Server (RC78ResponseTimeout) is now set to " + p2StarCanServer + " ms.");
        }
        this.logger.trace("Leaving updateSessionTimings(...).");
        return currentJobStatus;
    }

    protected void setRepeatRequestCounter(long pNumberOfRepetitions) throws MCDException {
        this.logger.trace("Entering setRepeatRequestCounter(...).");
        try {
            if (this.isPduApiUsed) {
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", pNumberOfRepetitions);
            } else {
                this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", pNumberOfRepetitions);
            }
        }
        catch (MCDException mcde) {
            this.logger.error("Error updating the repetition counter!");
            throw mcde;
        }
        this.logger.debug("RepeatRequestCounter set to: " + pNumberOfRepetitions);
        this.logger.trace("Leaving setRepeatRequestCounter(...).");
    }

    protected AbstractJob.JobStatus executeDiagComPrimitiveSync(MCDLogicalLink pLogicalLink, MCDDiagComPrimitive pDiagComPrimitive, int pMaxNumberOfRepetitions, boolean pRemoveDiagComPrimitive) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResult result = null;
        int diagComPrimitiveType = -1;
        int transmissionMode = -1;
        String diagComPrimitiveName = null;
        MCDValue requestPdu = null;
        String requestPduAsString = null;
        int diagComPrimitiveState = -1;
        MCDErrors errors = null;
        long startTime = 0L;
        this.logger.trace("Entering executeDiagComPrimitiveSync(...).");
        try {
            diagComPrimitiveType = pDiagComPrimitive.getObjectType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining type of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Type of diagComPrimitive: " + McdEnumDecoder.decodeMcdObjectType(diagComPrimitiveType));
        try {
            transmissionMode = pDiagComPrimitive.getDbObject().getTransmissionMode();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining transmission mode of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Transmission mode of diagComPrimitive: " + McdEnumDecoder.decodeMcdTransmissionMode(transmissionMode));
        try {
            diagComPrimitiveName = pDiagComPrimitive.getDbObject().getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Name of diagComPrimitive: " + diagComPrimitiveName);
        if (this.logger.getLogLevel() > 0 && (diagComPrimitiveType == 1190 || diagComPrimitiveType == 1198)) {
            try {
                requestPdu = pDiagComPrimitive.getRequest().getPDU();
                requestPduAsString = this.vendorSpecific.pduValue2String(requestPdu);
                if (requestPduAsString.length() > 256) {
                    requestPduAsString = requestPduAsString.substring(0, 256) + " ... (truncated for logging)";
                }
                this.logger.debug("Request PDU of diagComPrimitive: " + requestPduAsString);
                if (this.logger.getLogLevel() >= 6) {
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " -> [   ".substring(0, 8 - Integer.toHexString(requestPdu.getBytefield().length).length()) + Integer.toHexString(requestPdu.getBytefield().length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(requestPdu));
                }
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request PDU of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        int repetitions = pMaxNumberOfRepetitions;
        block24: do {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
            this.logger.debug("Executing diagComPrimitive '" + diagComPrimitiveName + "'.");
            try {
                --repetitions;
                startTime = System.currentTimeMillis();
                result = pDiagComPrimitive.executeSync();
                this.logger.debug("Execution time of diagComPrimitive \"" + diagComPrimitiveName + "\": " + (System.currentTimeMillis() - startTime) + " ms");
            }
            catch (MCDException mcde) {
                this.logger.debug("Error executing diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Getting errors.");
            try {
                errors = pDiagComPrimitive.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting errors of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            if (errors == null) {
                this.logger.error("MCDDiagComPrimitive.getErrors() returned null.");
            } else {
                this.logger.debug("Handling errors.");
                currentJobStatus = this.handleErrors(errors);
            }
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                // empty if block
            }
            this.logger.debug("Determining state of diagComPrimitive.");
            try {
                diagComPrimitiveState = pDiagComPrimitive.getState();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining state of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("State of diagComPrimitive: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComPrimitiveState));
            switch (diagComPrimitiveState) {
                case 25090: {
                    try {
                        pDiagComPrimitive.cancel();
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error cancelling diagComPrimitive.");
                        this.logger.logThrowable(mcde);
                        currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        break;
                    }
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                case 25089: {
                    if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR || diagComPrimitiveType == 1201 || diagComPrimitiveType == 1202) continue block24;
                    currentJobStatus = this.handleResult(pDiagComPrimitive, diagComPrimitiveType, result);
                    this.logger.debug("job status after handleResult(): " + currentJobStatus);
                    if (currentJobStatus != AbstractJob.JobStatus.WRONG_UBATT_DETECTED) continue block24;
                    this.logger.debug("Cancelling repetitions due to detection of wrong battery voltage.");
                    repetitions = 0;
                    break;
                }
                default: {
                    this.logger.error("*** UNKNOWN MCDDiagComPrimitiveState ***: " + diagComPrimitiveState);
                }
            }
        } while (repetitions > 0 && currentJobStatus != AbstractJob.JobStatus.NO_ERROR);
        this.logger.debug("Releasing result.");
        try {
            this.job.releaseResult(result);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error releasing result.");
            this.logger.logThrowable(mcde);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pRemoveDiagComPrimitive) {
            try {
                pLogicalLink.removeDiagComPrimitive(pDiagComPrimitive);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving executeDiagComPrimitiveSync(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResult(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, MCDResult pResult) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        boolean resultHasError = false;
        this.logger.trace("Entering handleResult(...).");
        if (pDiagComPrimitiveType == 1198 || pDiagComPrimitiveType == 1190) {
            try {
                request = pDiagComPrimitive.getRequest();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request from diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                requestParameters = request.getRequestParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request parameters from request.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        try {
            resultHasError = pResult.hasError();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining if result has an error.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (resultHasError) {
            MCDError error = null;
            this.logger.debug("Result has error.");
            try {
                error = pResult.getError();
            }
            catch (Exception e) {
                this.logger.debug("Error getting error from result.");
                this.logger.logThrowable(e);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53392 && error.getVendorCode() == 259 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 5074 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53315 && error.getVendorCode() == 20480 || pDiagComPrimitiveType == 1198 && !this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 19) {
                this.logger.debug("Ignoring P2 timeout since positive response has been suppressed.");
            } else if (error.getCode() == 53327 && error.getVendorCode() == 257) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 20) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && (error.getVendorCode() == 17 || error.getVendorCode() == 25 || error.getVendorCode() == 26 || error.getVendorCode() == 42 || error.getVendorCode() == 47)) {
                this.logger.warn("Wrong battery voltage detected - probably due to an interruption of clamp 30 or 15!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.WRONG_UBATT_DETECTED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 27) {
                this.logger.warn("EDIC interface deadlock error detected - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 16 || error.getCode() == 53315 && error.getVendorCode() == 16) {
                this.logger.warn("Command refused by EDIC interface - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 58644 || error.getCode() == 53327 && (this.isPduApiUsed && error.getCode() == 262 || !this.isPduApiUsed && error.getCode() == 13)) {
                this.logger.warn("Communication to VCI lost (possibly due to voltage drop) - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_TO_VCI_LOST_OR_DISTURBED;
            } else {
                this.logger.logMcdError(error);
                if (error.getCode() != 49152) {
                    if (this.isPduApiUsed && error.getCode() == 53327 && error.getVendorCode() == 5076) {
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        this.setJobInfo("ERROR: No result received from called job!");
                    } else if (error.getCode() != 49192) {
                        currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
                    } else {
                        String serviceShortName = null;
                        int resultType = -1;
                        MCDResponses responses = null;
                        try {
                            serviceShortName = pResult.getServiceShortName();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining service SHORT-NAME of result.");
                            this.logger.logThrowable(mcde);
                            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        }
                        this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
                        try {
                            resultType = pResult.getType();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining type of result.");
                            this.logger.logThrowable(mcde);
                            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        }
                        this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
                        if (resultType == 1793) {
                            this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
                        } else {
                            try {
                                responses = pResult.getResponses();
                            }
                            catch (MCDException mcde) {
                                this.logger.debug("Error getting responses from result.");
                                this.logger.logThrowable(mcde);
                                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                            }
                            currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, requestParameters, responses);
                            this.logger.debug("job status after handleResponses(): " + currentJobStatus);
                        }
                    }
                }
            }
            if (!this.isPduApiUsed) {
                this.logger.debug("Restarting communication after timeout.");
                if (error.getCode() != 49152) {
                    this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.stopCommunication, 1, false);
                    this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.startCommunication, 1, false);
                }
            }
        } else {
            String serviceShortName = null;
            int resultType = -1;
            MCDResponses responses = null;
            try {
                serviceShortName = pResult.getServiceShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining service SHORT-NAME of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
            try {
                resultType = pResult.getType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining type of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
            if (resultType == 1793) {
                this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
            } else {
                try {
                    responses = pResult.getResponses();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting responses from result.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, requestParameters, responses);
                this.logger.debug("job status after handleResponses(): " + currentJobStatus);
            }
        }
        this.logger.trace("Leaving handleResult(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResponses(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponses pResponses) {
        AbstractJob.JobStatus currentJobStatus = null;
        long responseCount = 0L;
        MCDResponse response = null;
        AbstractJob.JobStatus currentStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handleResponses(...).");
        try {
            responseCount = pResponses.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of responses.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of responses: " + responseCount);
        if (!this.isPositiveResponseSuppressed(pDiagComPrimitiveType, pRequestParameters)) {
            currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
        } else if (responseCount == 0L) {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        for (long i = 0L; i < responseCount; ++i) {
            try {
                response = pResponses.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            currentStatus = this.handleResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, response);
            if (this.responseLocationAccessKey.equals(this.dbLocationAccessKey) || this.responseLocationAccessKey.equals(this.dbLocationAccessKeyBaseVariant)) {
                currentJobStatus = currentStatus;
                continue;
            }
            this.logger.debug("dbLocation of response    : " + this.responseLocationAccessKey);
            this.logger.debug("dbLocation of BASE-VARIANT: " + this.dbLocationAccessKeyBaseVariant);
            this.logger.debug("dbLocation of LOGICAL-LINK: " + this.dbLocationAccessKey);
        }
        this.logger.trace("Leaving handleResponses(...).");
        return currentJobStatus;
    }

    protected boolean isPositiveResponseSuppressed(int pDiagComPrimitiveType, MCDRequestParameters pRequestParameters) {
        MCDRequestParameter param_suppressPositiveResponseMessageIndicationBit = null;
        String suppressPositiveResponseMessageIndicationBit = null;
        this.logger.trace("Entering isPositiveResponseSuppressed(...).");
        switch (pDiagComPrimitiveType) {
            case 1198: {
                try {
                    param_suppressPositiveResponseMessageIndicationBit = pRequestParameters.getItemByName("Param_SupprPositRespoMessaIndicBit");
                    this.logger.info("Found Param_SupprPositRespoMessaIndicBit in request.");
                    try {
                        suppressPositiveResponseMessageIndicationBit = param_suppressPositiveResponseMessageIndicationBit.getValue().getValueAsString();
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting value of Param_SupprPositRespoMessaIndicBit from request.");
                        this.logger.logThrowable(mcde);
                        suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                    }
                }
                catch (MCDException mcde) {
                    this.logger.info("No Param_SupprPositRespoMessaIndicBit found in request.");
                    suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                }
                break;
            }
            case 1190: 
            case 1192: 
            case 1197: 
            case 1200: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                break;
            }
            default: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
            }
        }
        if (suppressPositiveResponseMessageIndicationBit.equalsIgnoreCase(Boolean.TRUE.toString())) {
            this.logger.debug("Response has been suppressed.");
        } else {
            this.logger.debug("Response has not been suppressed.");
        }
        this.logger.trace("Leaving isPositiveResponseSuppressed(...).");
        return Boolean.valueOf(suppressPositiveResponseMessageIndicationBit);
    }

    protected AbstractJob.JobStatus handleResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDAccessKey accessKeyOfLocation = null;
        int responseState = -1;
        this.logger.trace("Entering handleResponse(...).");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    accessKeyOfLocation = pResponse.getAccessKeyOfLocation();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (accessKeyOfLocation == null) {
                    this.logger.debug("MCDResponse.getAccessKeyOfLocation() returned null!");
                    return AbstractJob.JobStatus.ERROR;
                }
                try {
                    this.responseLocationAccessKey = accessKeyOfLocation.getString();
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting string for access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1192: 
            case 1197: 
            case 1200: {
                this.responseLocationAccessKey = this.dbLocationAccessKey;
                break;
            }
        }
        this.logger.debug("DbLocation of response: " + this.responseLocationAccessKey);
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " <- [   ".substring(0, 8 - Integer.toHexString(pResponse.getResponseMessage().getBytefield().length).length()) + Integer.toHexString(pResponse.getResponseMessage().getBytefield().length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting response message by getValueAsString().");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1200: {
                if (pServiceShortName.equals("SinglJob_SecurAcces")) {
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace("");
                    this.logger.busTrace("See MCD3_SecurAcces_*.asc for trace of SinglJob_SecurAcces.");
                    this.logger.busTrace("");
                    break;
                }
                if (pServiceShortName.equals("SinglJob_WriteFinge")) {
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace("");
                    this.logger.busTrace("See MCD3_WriteFinge_*.asc for trace of SinglJob_WriteFinge.");
                    this.logger.busTrace("");
                    break;
                }
                if (this.logger.getLogLevel() < 6) break;
                this.logger.busTrace("");
                this.logger.busTrace("No trace available for SinglJob_SecurAcces - messages might be missing.");
                this.logger.busTrace("");
                break;
            }
            case 1192: 
            case 1197: {
                break;
            }
        }
        try {
            responseState = pResponse.getState();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining response state.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (responseState) {
            case 26625: {
                currentJobStatus = this.handlePositiveResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 26626: {
                currentJobStatus = this.handleNegativeResponse(pRequestParameters, pResponse);
                break;
            }
            default: {
                this.logger.error("Invalid MCDResponseState: " + responseState);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handleResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveResponse(...).");
        this.logger.debug("Response is positive.");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                currentJobStatus = this.handlePositiveServiceResponse(pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 1192: 
            case 1197: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
            case 1200: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
        }
        this.logger.trace("Leaving handlePositiveResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveJobResponse(String pJobShortName, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveJobResponse(...).");
        this.logger.debug("*** UNKNOWN job ***: " + pJobShortName);
        currentJobStatus = AbstractJob.JobStatus.ERROR;
        this.logger.trace("Leaving handlePositiveJobResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveServiceResponse(String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        byte responseServiceIdentifier = 0;
        byte requestServiceIdentifier = 0;
        this.logger.trace("Entering handlePositiveServiceResponse(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
            responseMessageString = pResponse.getResponseMessage().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length < 1) {
            this.logger.error("Error getting response service id from response with length of " + responseMessage.length + " bytes.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        responseServiceIdentifier = responseMessage[0];
        if ((responseServiceIdentifier & 0x40 & 0xFF) == 0) {
            this.logger.error("The extracted response service id (0x" + Integer.toHexString(responseServiceIdentifier & 0xFF).toUpperCase() + ") is not a positive response service identifier!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        requestServiceIdentifier = (byte)(responseServiceIdentifier - 64);
        try {
            numberOfResponseParameters = pResponse.getResponseParameters().getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.warn("Ignoring response since it is not covered by a database response: " + responseMessageString);
        } else {
            switch (requestServiceIdentifier) {
                case 16: {
                    currentJobStatus = this.handlePositiveResponseDiagnosticSessionControl(pRequestParameters, pResponse);
                    break;
                }
                case 17: {
                    currentJobStatus = this.handlePositiveResponseEcuReset(pRequestParameters, pResponse);
                    break;
                }
                case 40: {
                    currentJobStatus = this.handlePositiveResponseCommunicationControl(pRequestParameters, pResponse);
                    break;
                }
                case 46: {
                    currentJobStatus = this.handlePositiveResponseWriteDataByIdentifier(pRequestParameters, pResponse);
                    break;
                }
                case -123: {
                    currentJobStatus = this.handlePositiveResponseControlDTCSetting(pRequestParameters, pResponse);
                    break;
                }
                default: {
                    this.logger.debug("*** UNKNOWN service ***: " + pServiceShortName);
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                }
            }
        }
        this.logger.trace("Leaving handlePositiveServiceResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseDiagnosticSessionControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String diagnosticSessionTypeRequest = null;
        String diagnosticSessionTypeResponse = null;
        MCDResponseParameters responseParameters = null;
        long p2CanServer = 0L;
        long p2StarCanServer = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseDiagnosticSessionControl(...).");
        try {
            diagnosticSessionTypeRequest = pRequestParameters.getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of request (Param_DiagnSessiType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            diagnosticSessionTypeResponse = pResponse.getResponseParameters().getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of response (Param_DiagnSessiType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!diagnosticSessionTypeResponse.equals(diagnosticSessionTypeRequest)) {
            this.logger.error("diagnosticSessionType of response does NOT match request: " + diagnosticSessionTypeRequest + " / " + diagnosticSessionTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            p2CanServer = responseParameters.getItemByName("Param_StandTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_StandTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
            this.logger.warn("Leaving session timings untouched since new timings could not be extracted from response!");
            return AbstractJob.JobStatus.NO_ERROR;
        }
        this.logger.info("Current value of P2_CAN_Server is: " + p2CanServer + " ms.");
        try {
            p2StarCanServer = responseParameters.getItemByName("Param_ExtenTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_ExtenTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
            this.logger.warn("Leaving session timings untouched since new timings could not be extracted from response!");
            return AbstractJob.JobStatus.NO_ERROR;
        }
        this.logger.info("Current value of P2*_CAN_Server is: " + p2StarCanServer + " ms.");
        if (!this.isPduApiUsed && p2StarCanServer > 65500L - this.savedCanTransmissionTime) {
            this.logger.warn("Provided value of P2*_CAN_Server exceeds maximum timeout supported by Softing EIDBSS firmware (" + (65500L - this.savedCanTransmissionTime) + " ms)...");
            this.logger.warn("... limiting P2*_CAN_Server to maximum supported value.");
            p2StarCanServer = (int)(65500L - this.savedCanTransmissionTime);
            this.logger.info("Current value of P2*_CAN_Server is now: " + p2StarCanServer + " ms.");
        }
        try {
            currentJobStatus = this.updateSessionTimings(this.protocolParameterSet, p2CanServer, p2StarCanServer);
        }
        catch (MCDException mcde) {
            this.logger.error("Error updating session timings.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return currentJobStatus;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 6) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseDiagnosticSessionControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseEcuReset(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String resetTypeRequest = null;
        String resetTypeResponse = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseEcuReset(...).");
        try {
            resetTypeRequest = pRequestParameters.getItemByName("Param_ResetType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting reset type of request (Param_ResetType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            resetTypeResponse = pResponse.getResponseParameters().getItemByName("Param_ResetType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting reset type of response (Param_ResetType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!resetTypeResponse.equals(resetTypeRequest)) {
            this.logger.error("resetType of response does NOT match request: " + resetTypeRequest + " / " + resetTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseEcuReset(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseCommunicationControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseCommunicationControl(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseCommunicationControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseControlDTCSetting(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseControlDTCSetting(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseControlDTCSetting(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseWriteDataByIdentifier(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int recordDataIdentifierDataType = -1;
        String recordDataIdentifierRequest = null;
        String recordDataIdentifierResponse = null;
        int recordDataIdentifierRequestRawValue = -1;
        int recordDataIdentifierResponseRawValue = -1;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseWriteDataByIdentifier(...).");
        try {
            recordDataIdentifierDataType = pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getDataType();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting data type of record data identifier of request (Param_RecorDataIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (recordDataIdentifierDataType) {
            case 1: 
            case 14: {
                try {
                    recordDataIdentifierRequest = pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getValueAsString();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting record data identifier of request (Param_RecorDataIdent).");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    recordDataIdentifierResponse = pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getValueAsString();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting record data identifier of response (Param_RecorDataIdent).");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (recordDataIdentifierResponse.equals(recordDataIdentifierRequest)) break;
                this.logger.error("recordDataIdentifier of response does NOT match request: " + recordDataIdentifierRequest + " / " + recordDataIdentifierResponse);
                return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
            }
            case 11: {
                try {
                    recordDataIdentifierRequestRawValue = (short)pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getUint32();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting record data identifier of request (Param_RecorDataIdent).");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    recordDataIdentifierResponseRawValue = (short)pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getUint32();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting record data identifier of response (Param_RecorDataIdent).");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (recordDataIdentifierResponseRawValue == recordDataIdentifierRequestRawValue) break;
                this.logger.error("recordDataIdentifier of response does NOT match request: 0x" + Integer.toHexString(recordDataIdentifierRequestRawValue).toUpperCase() + " / 0x" + Integer.toHexString(recordDataIdentifierResponseRawValue).toUpperCase());
                return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
            }
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 3) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseWriteDataByIdentifier(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleNegativeResponse(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte requestServiceIdentifierRequest = 0;
        byte requestServiceIdentifierResponse = 0;
        String negativeResponseCode = null;
        byte nrc = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        this.logger.trace("Entering handleNegativeResponse(...).");
        this.logger.debug("Response is negative.");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length == 3) {
            long i;
            block29: {
                try {
                    for (i = 0L; i < pRequestParameters.getCount(); ++i) {
                        if (!pRequestParameters.getItemByIndex(i).getShortName().endsWith("RequeServiId")) continue;
                        requestServiceIdentifierRequest = (byte)pRequestParameters.getItemByIndex(i).getValue().getUint32();
                        break;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting request service identifier from request.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    responseParameters = pResponse.getResponseParameters();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting response parameters from response!");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                    this.logger.debug("Number of response parameters: " + numberOfResponseParameters);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (numberOfResponseParameters < 4L) {
                    requestServiceIdentifierResponse = requestServiceIdentifierRequest;
                } else {
                    try {
                        this.logger.debug("Datatype of request SID: " + McdEnumDecoder.decodeMcdDataType(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getDataType()));
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 3) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getBytefield()[0] & 0xFF);
                            break block29;
                        }
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 14 || responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 1) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseMessage().getBytefield()[1] & 0xFF);
                            break block29;
                        }
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        requestServiceIdentifierResponse = 0;
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        this.logger.logThrowable(mcde);
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                }
            }
            try {
                for (i = 0L; i < numberOfResponseParameters; ++i) {
                    if (!responseParameters.getItemByIndex(i).getShortName().equals("Param_NegatRespoCode")) continue;
                    negativeResponseCode = responseParameters.getItemByIndex(i).getValue().getValueAsString();
                    break;
                }
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code (Param_NegatRespoCode) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                nrc = pResponse.getResponseMessage().getBytefield()[2];
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code (byte 2) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("- Service ID: 0x" + Integer.toHexString(requestServiceIdentifierResponse & 0xFF).toUpperCase());
            this.logger.debug("- NRC       : 0x" + Integer.toHexString(nrc).toUpperCase() + " (" + negativeResponseCode + ")");
            if (requestServiceIdentifierResponse != requestServiceIdentifierRequest) {
                this.logger.error("Request service identifier of response does NOT match request: 0x" + Integer.toHexString(requestServiceIdentifierRequest) + " / " + Integer.toHexString(requestServiceIdentifierResponse));
            }
        } else {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (responseMessage.length < 3) {
                this.logger.debug("Negative response has invalid length of " + responseMessage.length + " bytes: " + responseMessageString);
            } else if (responseMessage.length > 3) {
                this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
            }
        }
        currentJobStatus = AbstractJob.JobStatus.NEGATIVE_RESPONSE;
        this.logger.trace("Leaving handleNegativeResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleErrors(MCDErrors pErrors) {
        long numberOfErrors = 0L;
        MCDError error = null;
        this.logger.trace("Entering handleErrors(...).");
        try {
            numberOfErrors = pErrors.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of errors.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("diagComPrimitive has " + numberOfErrors + " errors.");
        if (numberOfErrors == 0L) {
            this.logger.debug("Collection of errors is empty - NO errors occured.");
        } else {
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = pErrors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + ".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving handleErrors(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected String getProtocolParameterString(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) throws MCDException {
        MCDValue mcdValue = null;
        String value = null;
        this.logger.trace("Entering getProtocolParameterString(...).");
        try {
            mcdValue = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCDValue of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            value = mcdValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UNICODE2STRING value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.trace("Leaving getProtocolParameterString(...).");
        return value;
    }

    protected long getProtocolParameterUint32(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) throws MCDException {
        MCDValue mcdValue = null;
        long value = -1L;
        this.logger.trace("Entering getProtocolParameterUint32(...).");
        try {
            mcdValue = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCDValue of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            value = mcdValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UINT32 value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.trace("Leaving getProtocolParameterUint32(...).");
        return value;
    }

    protected MCDValue getProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) throws MCDException {
        MCDValue comParamValue = null;
        MCDRequestParameter comParam = null;
        this.logger.trace("Entering getProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error fetching protocol parameter with SHORT-NAME \"" + pComParamName + "\" from interface.");
            throw mcde;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCDValue of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.trace("Leaving getProtocolParameterValue(...).");
        return comParamValue;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, String pValue) throws MCDException {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        String currentValue = null;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter with SHORT-NAME \"" + pComParamName + "\" from interface!");
            this.logger.logThrowable(mcde);
            throw mcde;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            throw mcde;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            currentValue = comParamValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setValueAsString(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            throw mcde;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        if (this.logger.getLogLevel() >= 5) {
            try {
                pProtocolParameterSet.fetchValueFromInterface(pComParamName);
            }
            catch (MCDException mcde) {
                this.logger.error("Error fetching new protocol parameter value of \"" + pComParamName + "\" from interface!");
                throw mcde;
            }
            try {
                this.logger.debug("New value of \"" + pComParamName + "\" is " + this.protocolParameters.getItemByName(pComParamName).getValue().getValueAsString());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting new value of \"" + pComParamName + "\".");
                throw mcde;
            }
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, long pValue) throws MCDException {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        long currentValue = -1L;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            throw mcde;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            currentValue = comParamValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setUint32(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            throw mcde;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected AbstractJob.JobStatus checkRequiredDiagComms(String[] pRequiredDiagComms) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        MCDDbDataPrimitives dbDataPrimitives = null;
        long dbDataPrimitiveCount = 0L;
        MCDDbDataPrimitive dbDataPrimitive = null;
        String dbDataPrimitiveShortName = null;
        boolean isDiagCommAvailable = false;
        try {
            dbDataPrimitives = this.dbLocationOfLogicalLink.getDbDataPrimitives();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            dbDataPrimitiveCount = dbDataPrimitives.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (int i = 0; i < pRequiredDiagComms.length; ++i) {
            this.logMessage = "Checking availability of DIAG-COMM \"" + pRequiredDiagComms[i] + "\"... ";
            isDiagCommAvailable = false;
            for (long j = 0L; j < dbDataPrimitiveCount; ++j) {
                try {
                    dbDataPrimitive = dbDataPrimitives.getItemByIndex(j);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    dbDataPrimitiveShortName = dbDataPrimitive.getShortName();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting SHORT-NAME of data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (!dbDataPrimitiveShortName.equals(pRequiredDiagComms[i])) continue;
                isDiagCommAvailable = true;
                this.logMessage = this.logMessage + "OK.";
                this.logger.debug(this.logMessage);
            }
            if (isDiagCommAvailable) continue;
            this.logMessage = this.logMessage + "*** MISSING ***.";
            this.logger.fatal(this.logMessage);
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        return currentJobStatus;
    }

    private MCDValue getParameterValue(MCDParameter pParameter) throws MCDException, NullPointerException {
        String shortName = null;
        MCDValue value = null;
        this.logger.trace("Entering getParameterValue(...).");
        if (this.logger.getLogLevel() >= 5) {
            try {
                shortName = pParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting SHORT-NAME of parameter.");
                this.logger.logThrowable(mcde);
            }
            this.logger.debug("Getting value of parameter: " + shortName);
        }
        try {
            value = pParameter.getValue();
        }
        catch (MCDException mcde) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.error("Error getting value of parameter \"" + shortName + "\".");
            } else {
                this.logger.error("Error getting value of parameter.");
            }
            throw mcde;
        }
        if (value == null) {
            this.logger.error("MCDParameter.getValue() returned null!");
            throw new NullPointerException("MCDParameter.getValue() returned null!");
        }
        this.logger.trace("Leaving getParameterValue(...).");
        return value;
    }

    protected byte[] getParameterValueBytefield(MCDParameter pParameter) throws MCDException, NullPointerException {
        MCDValue mcdValue = null;
        byte[] value = null;
        this.logger.trace("Entering getParameterValueBytefield(...).");
        mcdValue = this.getParameterValue(pParameter);
        try {
            value = mcdValue.getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting A_BYTEFIELD value from MCDValue.");
            throw mcde;
        }
        this.logger.trace("Leaving getParameterValueBytefield(...).");
        return value;
    }

    protected long getParameterValueUint32(MCDParameter pParameter) throws MCDException, NullPointerException {
        MCDValue mcdValue = null;
        long value = 0L;
        this.logger.trace("Entering getParameterValueUint32(...).");
        mcdValue = this.getParameterValue(pParameter);
        try {
            value = mcdValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting A_UINT32 value from MCDValue.");
            throw mcde;
        }
        this.logger.trace("Leaving getParameterValueUint32(...).");
        return value;
    }

    protected int getParameterValueUint32AsInteger(MCDParameter pParameter) throws IllegalArgumentException, MCDException, NullPointerException {
        long longValue = 0L;
        int value = 0;
        this.logger.trace("Entering getParameterValueUint32AsInteger(...).");
        longValue = this.getParameterValueUint32(pParameter);
        if (longValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The value " + longValue + " exceeds the maximum 'int' value of " + Integer.MAX_VALUE + "!");
        }
        value = (int)longValue;
        this.logger.trace("Leaving getParameterValueUint32AsInteger(...).");
        return value;
    }

    protected short getParameterValueUint32AsShort(MCDParameter pParameter) throws IllegalArgumentException, MCDException, NullPointerException {
        long longValue = 0L;
        short value = 0;
        this.logger.trace("Entering getParameterValueUint32AsShort(...).");
        longValue = this.getParameterValueUint32(pParameter);
        if (longValue > 32767L) {
            throw new IllegalArgumentException("The value " + longValue + " exceeds the maximum 'short' value of " + Short.MAX_VALUE + "!");
        }
        value = (short)longValue;
        this.logger.trace("Leaving getParameterValueUint32AsShort(...).");
        return value;
    }

    protected byte getParameterValueUint32AsByte(MCDParameter pParameter) throws IllegalArgumentException, MCDException, NullPointerException {
        long longValue = 0L;
        byte value = 0;
        this.logger.trace("Entering getParameterValueUint32AsByte(...).");
        longValue = this.getParameterValueUint32(pParameter);
        if (longValue > 127L) {
            throw new IllegalArgumentException("The value " + longValue + " exceeds the maximum 'byte' value of " + 127 + "!");
        }
        value = (byte)longValue;
        this.logger.trace("Leaving getParameterValueUint32AsByte(...).");
        return value;
    }

    protected String getParameterValueAsString(MCDParameter pParameter) throws MCDException, NullPointerException {
        MCDValue mcdValue = null;
        String value = null;
        this.logger.trace("Entering getParameterValueAsString(...).");
        mcdValue = this.getParameterValue(pParameter);
        try {
            value = mcdValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting A_UNICODE2STRING value from MCDValue.");
            throw mcde;
        }
        if (value == null) {
            this.logger.error("MCDValue.getValueAsString() returned null!");
            throw new NullPointerException("MCDValue.getValueAsString() returned null!");
        }
        this.logger.trace("Leaving getParameterValueAsString(...).");
        return value;
    }

    protected MCDService writeDataByIdentifier(MCDLogicalLink pLogicalLink, String pDataIdentifier) throws MCDException {
        MCDService writeDataByIdentifier = null;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        MCDRequestParameter param_recordDataIdentifer = null;
        MCDValue value_recordDataIdentifier = null;
        MCDRequestParameter param_dataRecord = null;
        MCDRequestParameters params_dataRecord = null;
        this.logger.trace("Entering writeDataByIdentifier(...).");
        writeDataByIdentifier = this.createService(pLogicalLink, "DiagnServi_WriteDataByIdentECUIdent");
        if (writeDataByIdentifier == null) {
            return writeDataByIdentifier;
        }
        try {
            request = writeDataByIdentifier.getRequest();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting request of service \"DiagnServi_WriteDataByIdentECUIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            requestParameters = request.getRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting request parameters of service \"DiagnServi_WriteDataByIdentECUIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            param_recordDataIdentifer = requestParameters.getItemByName("Param_RecorDataIdent");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting parameter with SHORT-NAME \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            value_recordDataIdentifier = param_recordDataIdentifer.createValue();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error creating parameter value for \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            value_recordDataIdentifier.setValueAsString(pDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value to parameter \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            param_recordDataIdentifer.setValue(value_recordDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameter value of \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            param_dataRecord = this.vendorSpecific.getTableStructParameterByTableKeyValue(requestParameters, "Param_DataRecor", pDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting parameter with SHORT-NAME \"Param_DataRecor\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            params_dataRecord = param_dataRecord.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting parameters of \"Param_DataRecor\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            this.setDataRecordParameters(pDataIdentifier, params_dataRecord);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameters of \"Param_DataRecor\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        this.logger.trace("Leaving writeDataByIdentifier(...).");
        return writeDataByIdentifier;
    }

    protected MCDService writeDataByIdentifier(MCDLogicalLink pLogicalLink, int pDataIdentifier, byte[] pDataRecord) throws MCDException {
        MCDService writeDataByIdentifier = null;
        this.logger.trace("Entering writeDataByIdentifier(...).");
        writeDataByIdentifier = this.createService(pLogicalLink, "DiagnServi_WriteDataByIdentGenerServi");
        if (writeDataByIdentifier == null) {
            writeDataByIdentifier = this.createService(pLogicalLink, "DiagnServi_WriteDataByIdent");
        }
        if (writeDataByIdentifier == null) {
            return writeDataByIdentifier;
        }
        this.logger.debug("Setting DID: 0x" + Integer.toHexString(pDataIdentifier).toUpperCase());
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeDataByIdentifier, "Param_RecorDataIdent", (long)pDataIdentifier);
        this.setRequestParameterBytefield((MCDDiagComPrimitive)writeDataByIdentifier, "Param_DataRecor", pDataRecord);
        this.logger.trace("Leaving writeDataByIdentifier(...).");
        return writeDataByIdentifier;
    }

    protected void setDataRecordParameters(String pRecordDataIdentifier, MCDRequestParameters pDataRecordParameters) throws MCDException {
        this.logger.trace("Entering setDataRecordParameters(...).");
        if (pRecordDataIdentifier.equals("Vehicle Equipment Code And PR Number Combination")) {
            this.setRequestParameterBytefield(pDataRecordParameters, "Param_VehicEquipCodeAndPRNumbeCombi", this.vehicleEquipmentCodeAndPrNumberCombination);
        } else if (pRecordDataIdentifier.equals("VW Data Set Number Or ECU Data Container Number")) {
            this.setRequestParameterString(pDataRecordParameters, "Param_VWDataSetNumbeOrECUDataContaNumbe", this.vwDataSetNumberOrEcuDataContainerNumber);
        } else if (pRecordDataIdentifier.equals("VW Data Set Version Number")) {
            this.setRequestParameterString(pDataRecordParameters, "Param_VWDataSetVersiNumbe", this.vwDataSetVersionNumber);
        } else if (pRecordDataIdentifier.equals("VW EOL Configuration")) {
            this.setRequestParameterString(pDataRecordParameters, "Param_HardwAssemGroup", this.hardwareAssemblyGroup);
            this.setRequestParameterString(pDataRecordParameters, "Param_HardwTypeCode", this.hardwareTypeCode);
            this.setRequestParameterString(pDataRecordParameters, "Param_SoftwAssemGroup", this.softwareAssemblyGroup);
            this.setRequestParameterString(pDataRecordParameters, "Param_SoftwTypeCode", this.softwareTypeCode);
            this.setRequestParameterString(pDataRecordParameters, "Param_SoftwTypeVaria", this.softwareTypeVariant);
        } else {
            throw new IllegalArgumentException("Unexpected recordDataIdentifier: " + pRecordDataIdentifier);
        }
        this.logger.trace("Leaving setDataRecordParameters(...).");
    }

    protected void setVwEolConfiguration(MCDRequestParameters pVwEolConfigurationParameters, String pHardwareAssemblyGroup, String pHardwareTypeCode, String pSoftwareAssemblyGroup, String pSoftwareTypeCode, String pSoftwareTypeVariant) throws MCDException {
        this.logger.trace("Entering setVwEolConfiguration(...).");
        this.logger.trace("Leaving setVwEolConfiguration(...).");
    }

    static {
        instances = new Vector();
    }

    public static final class JobStep
    implements Comparable {
        public static final JobStep WRITE_VW_DATA_SET_NUMBER_OR_ECU_DATA_CONTAINER_NUMBER = new JobStep("WRITE_VW_DATA_SET_NUMBER_OR_ECU_DATA_CONTAINER_NUMBER");
        public static final JobStep WRITE_VW_DATA_SET_VERSION_NUMBER = new JobStep("WRITE_VW_DATA_SET_VERSION_NUMBER");
        public static final JobStep WRITE_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION = new JobStep("WRITE_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION");
        public static final JobStep WRITE_VW_EOL_CONFIGURATION = new JobStep("WRITE_VW_EOL_CONFIGURATION");
        public static final JobStep POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY = new JobStep("POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY");
        public static final JobStep POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF = new JobStep("POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF");
        public static final JobStep POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX = new JobStep("POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX");
        public static final JobStep POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX = new JobStep("POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX");
        public static final JobStep POSTPROGRAMMING_CONTROL_DTC_SETTING_ON = new JobStep("POSTPROGRAMMING_CONTROL_DTC_SETTING_ON");
        public static final JobStep ECU_RESET = new JobStep("ECU_RESET");
        public static final JobStep SLEEP_ECU_SOFTWARE_RESET_DURATION = new JobStep("SLEEP_ECU_SOFTWARE_RESET_DURATION");
        public static final JobStep RESTORE_PROTOCOL_PARAMETERS = new JobStep("RESTORE_PROTOCOL_PARAMETERS");
        public static final JobStep DONE = new JobStep("DONE");
        private static int nextOrdinal = 0;
        static final JobStep[] values = new JobStep[]{WRITE_VW_DATA_SET_NUMBER_OR_ECU_DATA_CONTAINER_NUMBER, WRITE_VW_DATA_SET_VERSION_NUMBER, WRITE_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION, WRITE_VW_EOL_CONFIGURATION, POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY, POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF, POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX, POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX, POSTPROGRAMMING_CONTROL_DTC_SETTING_ON, ECU_RESET, SLEEP_ECU_SOFTWARE_RESET_DURATION, RESTORE_PROTOCOL_PARAMETERS, DONE};
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
        private final int ordinal = nextOrdinal++;
        private final String name;

        private JobStep(String pName) {
            this.name = pName;
        }

        public static final JobStep valueOf(String pName) throws IllegalArgumentException {
            JobStep jobStep = null;
            Iterator jobStepIterator = VALUES.iterator();
            while (jobStepIterator.hasNext()) {
                jobStep = (JobStep)jobStepIterator.next();
                if (!pName.equals(jobStep.toString())) continue;
                return jobStep;
            }
            throw new IllegalArgumentException("Cannot parse '" + pName + "' into an element of JobStep!");
        }

        public final int compareTo(Object pObject) {
            return this.ordinal - ((JobStep)pObject).ordinal;
        }

        public final boolean equals(Object pObject) {
            return super.equals(pObject);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final int intValue() {
            return this.ordinal;
        }

        public final String toString() {
            return this.name;
        }
    }
}

