/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary3.util.parsers.fds.impl;

import com.audi.mcd.joblibrary3.util.Conversions;
import com.audi.mcd.joblibrary3.util.logging.Logger;
import com.audi.mcd.joblibrary3.util.parsers.fds.FDS;
import com.audi.mcd.joblibrary3.util.parsers.fds.FdsProject;
import com.audi.mcd.joblibrary3.util.parsers.fds.FdsProjectsParser;
import com.audi.mcd.joblibrary3.util.parsers.fds.FdsSignature;
import com.audi.mcd.joblibrary3.util.parsers.fds.FdsSignatures;
import com.audi.mcd.joblibrary3.util.parsers.fds.impl.FDSImpl;
import com.audi.mcd.joblibrary3.util.parsers.fds.impl.FdsProjectImpl;
import com.audi.mcd.joblibrary3.util.parsers.fds.impl.FdsSignatureImpl;
import com.audi.mcd.joblibrary3.util.parsers.fds.impl.FdsSignaturesImpl;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FdsProjectsParserImpl
implements FdsProjectsParser {
    private Logger logger = null;
    private String fileName = null;
    private FDS fds = null;
    private boolean isElementContentParsed = false;
    private StringBuffer contentOfCurrentlyParsedElement = null;
    private FdsProject currentFdsProject = null;
    private FdsSignatures currentFdsSignatures = null;
    private String currentDataBlockShortName = null;
    private byte[] currentFwSignature = null;

    public FdsProjectsParserImpl(Logger pLogger, FDS pFDS) {
        this.logger = pLogger;
        this.fds = pFDS;
    }

    public final boolean readXML(String pFileName) {
        this.logger.debug("Reading XML file \"" + pFileName + "\"...");
        FileReader fileReader = null;
        InputSource inputSource = null;
        XMLReader xmlReader = null;
        this.fileName = pFileName;
        try {
            fileReader = new FileReader(this.fileName);
        }
        catch (FileNotFoundException fne) {
            this.logger.debug("Error opening file: " + this.fileName);
            this.logger.logThrowable(fne);
            return false;
        }
        inputSource = new InputSource(fileReader);
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException se) {
            this.logger.warn("Error creating XML reader using defaults! (" + se.getLocalizedMessage() + ")");
            this.logger.debug("Trying Crimson XML reader...");
            try {
                xmlReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            }
            catch (SAXException se2) {
                this.logger.fatal("Error creating Crimson XML reader!");
                this.logger.logThrowable(se2);
                return false;
            }
        }
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        if (this.fds == null) {
            this.fds = new FDSImpl();
        }
        try {
            xmlReader.parse(inputSource);
        }
        catch (Exception e) {
            this.logger.debug("Error parsing " + this.fileName + "!");
            this.logger.logThrowable(e);
            return false;
        }
        this.dumpFds();
        this.logger.debug(this.fileName + " read successfully.");
        return true;
    }

    public FDS getFDS() {
        return this.fds;
    }

    public void error(SAXParseException pException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FDS-PROJECTS] Exception (error) while parsing " + this.fileName);
        stringBuffer.append(" at line " + pException.getLineNumber());
        stringBuffer.append(" / column " + pException.getColumnNumber());
        this.logger.debug(stringBuffer.toString());
        this.logger.debug("[FDS-PROJECTS] " + pException.getLocalizedMessage());
    }

    public void fatalError(SAXParseException pException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FDS-PROJECTS] Exception (fatal error) while parsing " + this.fileName);
        stringBuffer.append(" at line " + pException.getLineNumber());
        stringBuffer.append(" / column " + pException.getColumnNumber());
        this.logger.debug(stringBuffer.toString());
        this.logger.debug("[FDS-PROJECTS] " + pException.getLocalizedMessage());
    }

    public void warning(SAXParseException pException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FDS-PROJECTS] Exception (warning) while parsing " + this.fileName);
        stringBuffer.append(" at line " + pException.getLineNumber());
        stringBuffer.append(" / column " + pException.getColumnNumber());
        this.logger.debug(stringBuffer.toString());
        this.logger.debug("[FDS-PROJECTS] " + pException.getLocalizedMessage());
    }

    public void characters(char[] pCh, int pStart, int pLength) {
        if (this.isElementContentParsed && pLength > 0) {
            this.contentOfCurrentlyParsedElement.append(pCh, pStart, pLength);
        }
    }

    public void endDocument() {
        this.logger.debug("[FDS-PROJECTS] EndDocument");
    }

    public void endElement(String pNamespaceURI, String pLocalName, String pName) {
        String content = null;
        if (this.isElementContentParsed) {
            content = this.contentOfCurrentlyParsedElement.toString();
            content = content.trim();
            if (pLocalName.equals("FW-SIGNATURE")) {
                this.logger.debug("[FDS-PROJECTS] - FW-SIGNATURE             : " + content);
                content = content.trim();
                this.currentFwSignature = Conversions.hexString2ByteArray(content);
                this.isElementContentParsed = false;
            } else if (pLocalName.equals("DATABLOCK-SNREF")) {
                this.logger.debug("[FDS-PROJECTS] - DATABLOCK-SNREF          : " + content);
                this.currentDataBlockShortName = content;
                this.isElementContentParsed = false;
            }
        } else if (pLocalName.equals("FDS-SIGNATURE")) {
            if (this.currentFdsSignatures.getFdsSignatures().containsKey(this.currentDataBlockShortName)) {
                throw new RuntimeException("ERROR adding FW-SIGNATURE due to duplicate DATABLOCK-SNREF!");
            }
            FdsSignatureImpl fdsSignature = new FdsSignatureImpl(this.currentDataBlockShortName, this.currentFwSignature);
            this.currentFdsSignatures.addFdsSignature(this.currentDataBlockShortName, fdsSignature);
        }
        this.logger.debug("[FDS-PROJECTS] EndElement: " + pLocalName);
    }

    public void endPrefixMapping(String pPrefix) {
    }

    public void ignorableWhitespace(char[] pCh, int pStart, int pLength) {
    }

    public void processingInstruction(String pTarget, String pData) {
    }

    public void setDocumentLocator(Locator pLocator) {
    }

    public void skippedEntity(String pName) {
    }

    public void startDocument() {
        this.logger.debug("[FDS-PROJECTS] StartDocument");
    }

    public void startElement(String pNamespaceURI, String pLocalName, String pName, Attributes pAttributes) {
        this.logger.debug("[FDS-PROJECTS] StartElement: " + pLocalName);
        if (pLocalName.equals("FDS-PROJECTS")) {
            if (!this.startElementFdsProjects(pAttributes)) {
                throw new RuntimeException("Error parsing FDS-PROJECTS!");
            }
        } else if (pLocalName.equals("FDS-PROJECT")) {
            if (!this.startElementFdsProject(pAttributes)) {
                throw new RuntimeException("Error parsing FDS-PROJECT!");
            }
        } else if (pLocalName.equals("FDS-SIGNATURES")) {
            if (!this.startElementFdsSignatures(pAttributes)) {
                throw new RuntimeException("Error parsing FDS-SIGNATURES!");
            }
        } else if (!pLocalName.equals("FDS-SIGNATURE") && (pLocalName.equals("DATABLOCK-SNREF") || pLocalName.equals("FW-SIGNATURE"))) {
            this.isElementContentParsed = true;
            this.contentOfCurrentlyParsedElement = new StringBuffer();
        }
    }

    private final boolean startElementFdsProjects(Attributes pAttributes) {
        String version = null;
        version = pAttributes.getValue("VERSION");
        if (!version.equalsIgnoreCase("3.0.0")) {
            this.logger.error("VERSION of FDS-PROJECTS is not \"3.0.0\"!");
            return false;
        }
        return true;
    }

    private final boolean startElementFdsProject(Attributes pAttributes) {
        long maxValue;
        String idAsString = null;
        long id = 0L;
        String encryptionAlgorithm = null;
        String hashAlgorithm = null;
        String regex = "[0-9]{1,10}";
        idAsString = pAttributes.getValue("ID");
        if (!idAsString.matches(regex)) {
            this.logger.error("ID of FDS-PROJECT does not match the regular expression \"" + regex + "\"!");
            return false;
        }
        id = Long.parseLong(idAsString);
        if (id > (maxValue = 0xFFFFFFFFL)) {
            this.logger.error("ID of FDS-PROJECT exceeds the maximum value " + maxValue + "!");
            return false;
        }
        this.logger.debug("[FDS-PROJECTS] - ID (string): " + idAsString);
        this.logger.debug("[FDS-PROJECTS] - ID (value ): " + id);
        encryptionAlgorithm = pAttributes.getValue("ENCRYPTALG");
        if (!encryptionAlgorithm.equalsIgnoreCase("RSA")) {
            this.logger.error("ENCRYPTALG of FDS-PROJECT is not \"RSA\"!");
            return false;
        }
        this.logger.debug("[FDS-PROJECTS] - ENCRYPTALG (string): " + encryptionAlgorithm);
        hashAlgorithm = pAttributes.getValue("HASHALG");
        if (!hashAlgorithm.equalsIgnoreCase("SHA1")) {
            this.logger.error("HASHALG of FDS-PROJECT is not \"SHA1\"!");
            return false;
        }
        this.logger.debug("[FDS-PROJECTS] - HASHALG (string): " + hashAlgorithm);
        if (this.fds.getFdsProjects().containsKey(new Long(id))) {
            this.currentFdsProject = this.fds.getFdsProjectById(id);
        } else {
            this.currentFdsProject = new FdsProjectImpl(id, encryptionAlgorithm, hashAlgorithm);
            this.fds.addFdsProject(id, this.currentFdsProject);
        }
        return true;
    }

    private final boolean startElementFdsSignatures(Attributes pAttributes) {
        String sessionShortName = null;
        String sessionDescShortName = null;
        String type = null;
        sessionShortName = pAttributes.getValue("SESSION-SNREF");
        this.logger.debug("[FDS-PROJECTS] - SESSION-SNREF (string): " + sessionShortName);
        sessionDescShortName = pAttributes.getValue("SESSION-DESC-SNREF");
        this.logger.debug("[FDS-PROJECTS] - SESSION-DESC-SNREF (string): " + sessionDescShortName);
        type = pAttributes.getValue("TYPE");
        if (!type.equals("E") && !type.equals("S")) {
            this.logger.error("TYPE of FDS-SIGNATURES is not valid!");
            return false;
        }
        this.logger.debug("[FDS-PROJECTS] - TYPE (string): " + type);
        if (this.currentFdsProject.hasFdsSignaturesForSessionDescShortNameAndType(sessionDescShortName, type)) {
            this.currentFdsSignatures = this.currentFdsProject.getFdsSignaturesBySessionDescShortNameAndType(sessionDescShortName, type);
        } else {
            this.currentFdsSignatures = new FdsSignaturesImpl(type, sessionShortName, sessionDescShortName);
            this.currentFdsProject.addFdsSignatures(sessionDescShortName, type, this.currentFdsSignatures);
        }
        return true;
    }

    public void startPrefixMapping(String pPrefix, String pUri) {
    }

    private void dumpFds() {
        FdsProject fdsProject = null;
        FdsSignatures fdsSignatures = null;
        FdsSignature fdsSignature = null;
        this.logger.debug("Dumping FDS...");
        Iterator fdsProjectsIteraror = this.fds.getFdsProjects().values().iterator();
        while (fdsProjectsIteraror.hasNext()) {
            fdsProject = (FdsProject)fdsProjectsIteraror.next();
            this.logger.debug("- FDS-PROJECT: " + fdsProject.getId() + " / " + fdsProject.getEncryptionAlgorithm() + " / " + fdsProject.getHashAlgorithm());
            Iterator fdsSignaturesIterator = fdsProject.getFdsSignatures().entrySet().iterator();
            while (fdsSignaturesIterator.hasNext()) {
                Map.Entry currentEntry = fdsSignaturesIterator.next();
                fdsSignatures = (FdsSignatures)currentEntry.getValue();
                this.logger.debug("   - FDS-SIGNATURES: " + fdsSignatures.getSessionShortName() + " / " + fdsSignatures.getSessionDescShortName() + " / " + fdsSignatures.getType());
                Iterator fdsSignatureIterator = fdsSignatures.getFdsSignatures().entrySet().iterator();
                while (fdsSignatureIterator.hasNext()) {
                    Map.Entry currentEntry2 = fdsSignatureIterator.next();
                    fdsSignature = (FdsSignature)currentEntry2.getValue();
                    this.logger.debug("     - FDS-SIGNATURE: " + fdsSignature.getDataBlockShortName() + " / " + Conversions.byteArray2String(fdsSignature.getFwSignature()));
                }
            }
        }
    }
}

