/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary3.jobs.impl;

import asam.d.MCDAccessKey;
import asam.d.MCDControlPrimitive;
import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDataPrimitives;
import asam.d.MCDDbDiagService;
import asam.d.MCDDbFlashSession;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDErrors;
import asam.d.MCDException;
import asam.d.MCDFlashJob;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDParameter;
import asam.d.MCDProtocolParameterSet;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDService;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDStartCommunication;
import asam.d.MCDStopCommunication;
import asam.d.MCDTextTableElement;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import com.audi.mcd.SharedData;
import com.audi.mcd.joblibrary3.constants.value.DefaultValue;
import com.audi.mcd.joblibrary3.jobs.AbstractJob;
import com.audi.mcd.joblibrary3.jobs.impl.AbstractSingleEcuJobImpl;
import com.audi.mcd.joblibrary3.util.Conversions;
import com.audi.mcd.joblibrary3.util.DateTime;
import com.audi.mcd.joblibrary3.util.McdEnumDecoder;
import com.audi.mcd.joblibrary3.util.dserver.DServerVendor;
import com.audi.mcd.joblibrary3.util.dserver.VendorSpecific;
import com.audi.mcd.joblibrary3.util.dserver.VendorSpecificMCD20002;
import com.audi.mcd.joblibrary3.util.parsers.fds.FDS;
import com.audi.mcd.joblibrary3.util.parsers.fds.SignatureFileNameFilter;
import com.audi.mcd.joblibrary3.util.parsers.fds.impl.FDSImpl;
import com.audi.mcd.joblibrary3.util.parsers.fds.impl.FdsProjectsParserImpl;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.ParameterDataApplication;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.ParameterDataApplicationGen1;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.ParameterDataApplicationGen2;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.ParameterDataBootloader;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.TargetEcu;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.XmlMsg;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.impl.XmlMsgParserImpl;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class MCD3_PreDataSet
extends AbstractSingleEcuJobImpl {
    private static final String REVISION = "1.1.20141103";
    protected static final int CONTROL_DTC_SETTING_ON_DELAY_TIME = 500;
    protected static final String[] REQUIRED_DIAG_COMMS = new String[]{"DiagnServi_CommuContrEnablRxAndDisabTxNormaCommuMessa", "DiagnServi_CommuContrEnablRxAndTxNormaCommuMessa", "DiagnServi_ContrDTCSetti", "DiagnServi_DiagnSessiContr", "DiagnServi_DiagnSessiContrFUNCT", "DiagnServi_ECUResetHardReset", "DiagnServi_RequeDownl", "DiagnServi_RequeTransExit", "DiagnServi_RoutiContrCheckMemor", "DiagnServi_RoutiContrCheckProgrDepen", "DiagnServi_RoutiContrCheckProgrPreco", "DiagnServi_RoutiContrEraseMemor", "DiagnServi_TransData", "SinglJob_SecurAcces", "DiagnServi_SecurAccesRequeSeed", "DiagnServi_SecurAccesSendKey", "SinglJob_StartCommu", "SinglJob_WriteFinge", "DiagnServi_WriteDataByIdentECUIdent", "DiagnServi_WriteDataByIdentGenerServi"};
    private static Vector instances = null;
    protected String dbFlashSessionName = null;
    protected boolean isModifyTimingEnabled = false;
    protected boolean isFunctionalAddressingDisabled = false;
    protected boolean isNormalCommunicationReEnabled = true;
    protected String xmlMsgFileName = null;
    protected short expectedDiagnosticAddress = 0;
    protected long login = 0L;
    protected int vwDeviceNumber = 0x1FFFFF;
    protected short importerNumber = (short)1023;
    protected int workshopNumber = 99999;
    protected byte[] vehicleEquipmentCodeAndPrNumberCombination = null;
    protected String vwDataSetNumberOrEcuDataContainerNumber = null;
    protected String vwDataSetVersionNumber = null;
    protected boolean isWritingOfVwEolConfigurationEnabled = false;
    protected String hardwareAssemblyGroup = null;
    protected String hardwareTypeCode = null;
    protected String softwareAssemblyGroup = null;
    protected String softwareTypeCode = null;
    protected String softwareTypeVariant = null;
    protected long savedNumberOfErrorRepetitions = 0L;
    protected long savedStandTiminP2Serve = 0L;
    protected long savedExtenTiminP2Serve = 0L;
    protected long savedP3CanClientPhys = 0L;
    protected long savedP3CanClientFunc = 0L;
    protected long savedCanTransmissionTime = 0L;
    protected long savedStMinOverride = 0L;
    protected long savedRequestTime = 0L;
    protected MCDService currentService = null;
    protected MCDControlPrimitive controlPrimitive = null;
    protected MCDJob securityAccess = null;
    protected MCDJob writeFingerprint = null;
    protected MCDJob dataSet = null;
    protected MCDJob postDataSet = null;
    protected MCDFlashJob flashJob = null;
    protected MCDJob jobStartCommunication = null;
    protected int totalNumberOfBytesToTransfer = 0;
    protected int totalNumberOfBytesTransferred = 0;
    protected MCDProtocolParameterSet protocolParameterSet = null;
    protected MCDRequestParameters protocolParameters = null;
    protected Set availableRoutines = null;
    protected boolean isStandAloneMode = false;
    protected short lengthOfVehicleEquipmentCodeAndPrNumberCombination = (short)-1;
    protected TargetEcu targetEcu = null;
    protected XmlMsg.DataSetDownloadType dataSetDownloadType = null;
    protected Vector applicationDataSets = null;
    protected Vector bootloaderDataSets = null;
    protected long fdsProjectIdEcu = 0L;
    protected String fdsKeyTypeEcu = null;
    protected FDS fds = null;
    protected long maximumBlockSizeTransportLayer = 0L;
    protected int maximumNumberOfTransferDataRepetitions = 0;
    protected long maxStandTiminP2Serve = 0L;
    protected long maxExtenTiminP2Serve = 0L;
    protected int numberOfDataChunks = 0;
    protected int currentApplicationDataSet = 0;
    protected int currentBootloaderDataSet = 0;
    protected int numberOfInitialRepetitions = 0;
    protected int numberOfTotalRepetitions = 0;
    protected int numberOfTransferDataRepetitions = 0;
    protected int numberOfRepetitionsWithCurrentSTmin = 0;
    protected int maximumNumberOfRepetitionsWithCurrentSTmin = 10;
    protected boolean initialRepetition = true;

    public MCD3_PreDataSet() {
        this(REVISION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MCD3_PreDataSet(String pRevision) {
        super(pRevision);
        Class clazz = MCD3_PreDataSet.class;
        synchronized (clazz) {
            instances.addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Class clazz = MCD3_PreDataSet.class;
        synchronized (clazz) {
            instances.remove(this);
        }
        super.finalize();
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        this.logger.trace("Entering execute(...).");
        this.jobStatus = this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, pSingleEcuJob);
        if (this.jobStatus == AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS) {
            throw new NullPointerException("At least one of the call parameters of the job is null!");
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("prepareJob successful - executing job logic...");
            this.jobStatus = this.executeJobLogicGuarded();
        }
        this.finalizeJobGuarded();
        this.logger.trace("Leaving execute(...).");
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters) {
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus prepareJobGuarded(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        try {
            currentJobStatus = this.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pSingleEcuJob);
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in prepareJob() method.");
            this.logger.logThrowable(e);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in prepareJob() method.");
            this.logger.logThrowable(t);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareJob(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        this.jobStatus = super.prepareJob(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.jobStatus = this.readInputParameters(pRequestParameters, null);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.jobStatus = this.checkRequiredDiagComms(REQUIRED_DIAG_COMMS);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        try {
            this.availableRoutines = this.getAvailableRoutines("DiagnServi_RoutiContrStartRoutiDataSet");
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determinig available routines.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Preparing protocol parameter set.");
        this.jobStatus = this.prepareProtocolParameterSet();
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        if (!this.isPduApiUsed) {
            this.logger.debug("Preparing global control primitives.");
            try {
                this.stopCommunication = this.stopCommunication(this.logicalLink);
                this.startCommunication = this.startCommunication(this.logicalLink);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating MCDStop/StartCommunication.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        Thread.currentThread().setPriority(10);
        this.logger.trace("Leaving prepareJob(...).");
        return this.jobStatus;
    }

    protected AbstractJob.JobStatus executeJobLogicGuarded() {
        AbstractJob.JobStatus currentJobCompletionStatus = null;
        try {
            currentJobCompletionStatus = this.executeJobLogic();
        }
        catch (MCDException mcde) {
            this.logger.debug("Caught MCDException in executeJobLogic() method.");
            this.logger.logThrowable(mcde);
            currentJobCompletionStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in executeJobLogic() method.");
            this.logger.logThrowable(e);
            currentJobCompletionStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in executeJobLogic() method.");
            this.logger.logThrowable(t);
            currentJobCompletionStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobCompletionStatus;
    }

    protected AbstractJob.JobStatus executeJobLogic() throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        AbstractJob.JobStatus currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
        JobStep currentJobStep = JobStep.values[0];
        this.setJobProgress(1L);
        SharedData.setDataSetsWrittenSuccessfully(true);
        while (currentJobStep.compareTo(JobStep.POST_DATA_SET) < 0 && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            if (currentJobStep == JobStep.READ_XMLMSG) {
                if (this.xmlMsgFileName.equals("empty")) {
                    this.logger.info("No XMLMSG provided... assuming stand-alone mode and type of data set download is " + XmlMsg.DataSetDownloadType.GENERATION_1);
                    this.isStandAloneMode = true;
                    this.dataSetDownloadType = XmlMsg.DataSetDownloadType.GENERATION_1;
                    currentJobStep = JobStep.PREPARE_SUB_JOBS;
                    continue;
                }
                currentJobStatus = this.readXmlMsg(this.xmlMsgFileName);
                if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                    currentJobStep = JobStep.DONE;
                    continue;
                }
                currentJobStep = JobStep.PREPARE_SUB_JOBS;
                continue;
            }
            if (currentJobStep == JobStep.PREPARE_SUB_JOBS) {
                this.securityAccess = this.securityAccess(this.logicalLink, this.logger.getLogLevel(), "Login", this.login);
                this.writeFingerprint = this.writeFingerprint(this.logicalLink, this.logger.getLogLevel(), "F199/F198 programming date and repair shop code", this.vwDeviceNumber, this.importerNumber, this.workshopNumber, (byte)(DateTime.calendar.get(1) % 100), (byte)(DateTime.calendar.get(2) + 1), (byte)DateTime.calendar.get(5));
                this.jobStartCommunication = this.startCommunication(this.logicalLink, this.logger.getLogLevel(), this.vwDeviceNumber, this.importerNumber, this.workshopNumber, (byte)(DateTime.calendar.get(1) % 100), (byte)(DateTime.calendar.get(2) + 1), (byte)DateTime.calendar.get(5));
                if (this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_1) {
                    if (this.isStandAloneMode) {
                        currentJobStep = JobStep.PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY;
                        continue;
                    }
                    currentJobStep = JobStep.DETERMINE_LENGTH_OF_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION;
                    continue;
                }
                if (this.targetEcu.isFlashDataSecurityRequired()) {
                    currentJobStep = JobStep.READ_FDS_PROJECT_ID;
                    continue;
                }
                currentJobStep = JobStep.PREPROGRAMMING_SWITCH_TO_END_OF_LINE_SESSION_PHYSICALLY;
                continue;
            }
            if (currentJobStep == JobStep.READ_FDS_PROJECT_ID) {
                this.currentService = this.readDataByIdentifierEcuIdentification(this.logicalLink, "FDS_project_data");
                if (this.currentService == null) {
                    if (this.targetEcu.isUsingExternalSignatures()) {
                        this.logger.error("The ECU identification \"FDS_project_data\" is NOT supported by this ECU while external FW-SIGNATURES are used!");
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        currentJobStep = JobStep.DONE;
                        continue;
                    }
                    currentJobStep = JobStep.PREPROGRAMMING_SWITCH_TO_END_OF_LINE_SESSION_PHYSICALLY;
                    continue;
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                SharedData.setFdsProjectId(this.fdsProjectIdEcu);
                SharedData.setFdsKeyType(this.fdsKeyTypeEcu);
                this.setJobProgress(3L);
                if (this.targetEcu.isUsingExternalSignatures()) {
                    currentJobStep = JobStep.READ_EXTERNAL_SIGNATURES;
                    continue;
                }
                currentJobStep = JobStep.PREPROGRAMMING_SWITCH_TO_END_OF_LINE_SESSION_PHYSICALLY;
                continue;
            }
            if (currentJobStep == JobStep.READ_EXTERNAL_SIGNATURES) {
                this.fds = new FDSImpl();
                Iterator iterator = this.bootloaderDataSets.iterator();
                ParameterDataBootloader currentParameterDataBootloader = null;
                String signatureDirectoryPath = null;
                File signatureDirectory = null;
                String[] sigExtensions = new String[]{".sig"};
                String fileNamePrefix = null;
                File[] signatureFiles = null;
                File currentSignatureFile = null;
                String currentSignatureFileName = null;
                String currentSignatureFilePath = null;
                String currentSessionName = null;
                String expectedSignatureFileName = null;
                String expectedSignatureFilePath = null;
                FdsProjectsParserImpl fdsProjectsParser = null;
                while (iterator.hasNext() && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
                    currentParameterDataBootloader = (ParameterDataBootloader)iterator.next();
                    signatureDirectoryPath = currentParameterDataBootloader.getFileName().substring(0, currentParameterDataBootloader.getFileName().lastIndexOf(File.separator) + 1);
                    currentSessionName = currentParameterDataBootloader.getSessionName();
                    if (currentSessionName.startsWith("SESD_")) {
                        expectedSignatureFileName = currentSessionName.replaceFirst("SESD_", "DB_");
                    } else if (currentSessionName.startsWith("SES_")) {
                        expectedSignatureFileName = currentSessionName.replaceFirst("SES_", "DB_");
                    }
                    fileNamePrefix = expectedSignatureFileName + "_";
                    expectedSignatureFileName = fileNamePrefix + this.fdsProjectIdEcu + sigExtensions[0];
                    this.logger.debug("SHORT-NAME of flash session: " + currentSessionName);
                    this.logger.debug("Expected signature file name: " + expectedSignatureFileName);
                    expectedSignatureFilePath = signatureDirectoryPath + expectedSignatureFileName;
                    currentSignatureFile = new File(expectedSignatureFilePath);
                    if (!currentSignatureFile.exists()) {
                        this.logger.error("ERROR: The expected signature file \"" + expectedSignatureFilePath + "\" does NOT exist!");
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        this.logger.debug("Listing available signature files in \"" + signatureDirectoryPath + "\" with prefix \"" + fileNamePrefix + "\"...");
                        signatureDirectory = new File(signatureDirectoryPath);
                        signatureFiles = signatureDirectory.listFiles(new SignatureFileNameFilter(fileNamePrefix, sigExtensions));
                        this.logger.debug("Found " + signatureFiles.length + " signature file(s).");
                        for (int i = 0; i < signatureFiles.length; ++i) {
                            currentSignatureFile = signatureFiles[i];
                            currentSignatureFileName = currentSignatureFile.getName();
                            this.logger.debug("Name of available signature file [" + i + "]: " + currentSignatureFileName);
                            if (!currentSignatureFileName.equalsIgnoreCase(expectedSignatureFileName)) continue;
                            this.logger.debug("File name is matching case-insensitively... using " + currentSignatureFileName + ".");
                            currentSignatureFilePath = signatureDirectoryPath + currentSignatureFileName;
                            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                        }
                        break;
                    }
                    currentSignatureFilePath = expectedSignatureFilePath;
                    if (!currentSignatureFile.isFile()) {
                        this.logger.error("ERROR: The expected signature file \"" + currentSignatureFilePath + "\" is NOT a regular file!");
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        break;
                    }
                    if (!currentSignatureFile.canRead()) {
                        this.logger.error("ERROR: The expected signature file \"" + currentSignatureFilePath + "\" is NOT readable!");
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        break;
                    }
                    fdsProjectsParser = new FdsProjectsParserImpl(this.logger, this.fds);
                    if (fdsProjectsParser.readXML(currentSignatureFile.getAbsolutePath())) continue;
                    this.logger.error("ERROR: Error parsing signature file \"" + currentSignatureFilePath + "\"!");
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                    currentJobStep = JobStep.DONE;
                    continue;
                }
                SharedData.setFDS(this.fds);
                this.setJobProgress(3L);
                currentJobStep = JobStep.PREPROGRAMMING_SWITCH_TO_END_OF_LINE_SESSION_PHYSICALLY;
                continue;
            }
            if (currentJobStep == JobStep.DETERMINE_LENGTH_OF_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION) {
                try {
                    this.lengthOfVehicleEquipmentCodeAndPrNumberCombination = this.determineLengthOfPrIndex();
                }
                catch (Exception e) {
                    currentJobStatus = AbstractJob.JobStatus.LENGTH_OF_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION_INDETERMINABLE;
                    this.logger.debug("Error determining length of 'Vehicle Equipment Code And PR Number Combination' -> aborting!");
                    this.logger.logThrowable(e);
                }
                if (this.vehicleEquipmentCodeAndPrNumberCombination.length == 0) {
                    this.vehicleEquipmentCodeAndPrNumberCombination = new byte[this.lengthOfVehicleEquipmentCodeAndPrNumberCombination];
                    System.arraycopy(DefaultValue.PostDataSet.REFERENZ, DefaultValue.PostDataSet.REFERENZ.length - this.lengthOfVehicleEquipmentCodeAndPrNumberCombination, this.vehicleEquipmentCodeAndPrNumberCombination, 0, this.vehicleEquipmentCodeAndPrNumberCombination.length);
                    this.logger.debug("Replacement value of 'Vehicle Equipment Code And PR Number Combination': " + Conversions.byteArray2String(this.vehicleEquipmentCodeAndPrNumberCombination));
                } else if (this.vehicleEquipmentCodeAndPrNumberCombination.length > 0 && this.vehicleEquipmentCodeAndPrNumberCombination.length < this.lengthOfVehicleEquipmentCodeAndPrNumberCombination) {
                    byte[] zeroPaddedVehicleEquipmentCodeAndPrNumberCombination = new byte[this.lengthOfVehicleEquipmentCodeAndPrNumberCombination];
                    System.arraycopy(this.vehicleEquipmentCodeAndPrNumberCombination, 0, zeroPaddedVehicleEquipmentCodeAndPrNumberCombination, this.lengthOfVehicleEquipmentCodeAndPrNumberCombination - this.vehicleEquipmentCodeAndPrNumberCombination.length, this.vehicleEquipmentCodeAndPrNumberCombination.length);
                    this.vehicleEquipmentCodeAndPrNumberCombination = zeroPaddedVehicleEquipmentCodeAndPrNumberCombination;
                    this.logger.debug("Zero padded value of 'Vehicle Equipment Code And PR Number Combination': " + Conversions.byteArray2String(this.vehicleEquipmentCodeAndPrNumberCombination));
                }
                currentJobStep = JobStep.PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY;
                continue;
            }
            if (currentJobStep == JobStep.PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Functional");
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                }
                this.currentService = this.diagnosticSessionControl(this.logicalLink, Boolean.TRUE, "Extended Diagnostic Session", true);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                }
                if (currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                    this.logger.debug("Got negative response.");
                    currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(2L);
                currentJobStep = JobStep.PREPROGRAMMING_SWITCH_TO_END_OF_LINE_SESSION_PHYSICALLY;
                continue;
            }
            if (currentJobStep == JobStep.PREPROGRAMMING_SWITCH_TO_END_OF_LINE_SESSION_PHYSICALLY) {
                this.currentService = this.diagnosticSessionControl(this.logicalLink, Boolean.FALSE, "VW End Of Line (EoL)-Session", false);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                this.setJobProgress(3L);
                if (this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_1) {
                    currentJobStep = JobStep.PREPROGRAMMING_CONTROL_DTC_SETTING_OFF;
                    continue;
                }
                currentJobStep = JobStep.SECURITY_ACCESS;
                continue;
            }
            if (currentJobStep == JobStep.PREPROGRAMMING_CONTROL_DTC_SETTING_OFF) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Functional");
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                }
                this.currentService = this.controlDtcSetting(this.logicalLink, !this.isFunctionalAddressingDisabled, "Off");
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                if (currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                    currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(5L);
                currentJobStep = JobStep.PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX;
                continue;
            }
            if (currentJobStep == JobStep.PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX) {
                this.currentService = this.communicationControl(this.logicalLink, !this.isFunctionalAddressingDisabled, "Enable Rx And Disable Tx", "Normal Communication Messages", "All Networks");
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                }
                if (currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                    currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(6L);
                currentJobStep = JobStep.SECURITY_ACCESS;
                continue;
            }
            if (currentJobStep == JobStep.SECURITY_ACCESS) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.securityAccess, 1, true);
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                }
                this.setJobProgress(8L);
                currentJobStep = JobStep.WRITE_FINGERPRINT;
                continue;
            }
            if (currentJobStep == JobStep.WRITE_FINGERPRINT) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.writeFingerprint, 1, true);
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                }
                this.setJobProgress(9L);
                if (this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_1) {
                    currentJobStep = JobStep.START_ROUTINE_ERASE_VW_MEMORY;
                    continue;
                }
                currentJobStep = JobStep.WRITE_VW_DATA_SET_NUMBER_OR_ECU_DATA_CONTAINER_NUMBER;
                continue;
            }
            if (currentJobStep == JobStep.WRITE_VW_DATA_SET_NUMBER_OR_ECU_DATA_CONTAINER_NUMBER) {
                this.currentService = this.writeDataByIdentifier(this.logicalLink, "VW Data Set Number Or ECU Data Container Number");
                if (this.currentService == null) {
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    continue;
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                this.setJobProgress(50L);
                currentJobStep = JobStep.WRITE_VW_DATA_SET_VERSION_NUMBER;
                continue;
            }
            if (currentJobStep == JobStep.WRITE_VW_DATA_SET_VERSION_NUMBER) {
                this.currentService = this.writeDataByIdentifier(this.logicalLink, "VW Data Set Version Number");
                if (this.currentService == null) {
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    continue;
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                this.setJobProgress(60L);
                currentJobStep = JobStep.WRITE_APPLICATION_DATA_SETS;
                continue;
            }
            if (currentJobStep == JobStep.START_ROUTINE_ERASE_VW_MEMORY) {
                if (!this.availableRoutines.contains("Erase VW memory")) {
                    this.logger.debug("Skipping RoutineControl/EraseVWMemory since the routine is not supported in ODX.");
                    if (this.isStandAloneMode) {
                        currentJobStep = JobStep.RESTORE_PROTOCOL_PARAMETERS;
                        continue;
                    }
                    currentJobStep = JobStep.WRITE_APPLICATION_DATA_SETS;
                    continue;
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.routineControlStartRoutineDataSet(this.logicalLink, "Erase VW memory", "VW Calibration and Application Data #0"), 1, true);
                this.setJobProgress(10L);
                if (currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                    this.logger.debug("Ignoring negative response since EraseVWMemory is optional.");
                    currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                    if (this.isStandAloneMode) {
                        currentJobStep = JobStep.RESTORE_PROTOCOL_PARAMETERS;
                        continue;
                    }
                    currentJobStep = JobStep.WRITE_APPLICATION_DATA_SETS;
                    continue;
                }
                currentJobStep = JobStep.REQUEST_ROUTINE_RESULTS_ERASE_VW_MEMORY;
                continue;
            }
            if (currentJobStep == JobStep.REQUEST_ROUTINE_RESULTS_ERASE_VW_MEMORY) {
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.routineControlRequestRoutineResultsDataSet(this.logicalLink, "Erase VW memory"), 1, true);
                this.setJobProgress(10L);
                if (this.isStandAloneMode) {
                    currentJobStep = JobStep.RESTORE_PROTOCOL_PARAMETERS;
                    continue;
                }
                currentJobStep = JobStep.WRITE_APPLICATION_DATA_SETS;
                continue;
            }
            if (currentJobStep == JobStep.WRITE_APPLICATION_DATA_SETS) {
                if (this.applicationDataSets.size() == 0) {
                    this.logger.debug("No application data sets to download.");
                    currentJobStep = JobStep.WRITE_BOOTLOADER_DATA_SETS;
                } else {
                    this.logger.debug("Current application data set: " + this.currentApplicationDataSet);
                    if (this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_2) {
                        ParameterDataApplicationGen2 currentApplicationDataSetGen2 = (ParameterDataApplicationGen2)this.applicationDataSets.get(this.currentApplicationDataSet);
                        int currentDataSetIdentifier = currentApplicationDataSetGen2.getDataSetIdentifier();
                        byte[] currentData = currentApplicationDataSetGen2.getData();
                        this.currentService = this.writeDataByIdentifier(this.logicalLink, currentDataSetIdentifier, currentData);
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                    } else {
                        ParameterDataApplicationGen1 currentApplicationDataSetGen1 = (ParameterDataApplicationGen1)this.applicationDataSets.get(this.currentApplicationDataSet);
                        byte[] currentData = currentApplicationDataSetGen1.getData();
                        long currentLength = currentData.length;
                        byte[] currentStartAddress = Conversions.long2ByteArray(currentApplicationDataSetGen1.getStartAddress(), 4);
                        this.dataSet = this.dataSet(this.logicalLink, currentData, currentLength, currentStartAddress);
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.dataSet, 1, true);
                    }
                    if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
                        if (this.currentApplicationDataSet < this.applicationDataSets.size() - 1) {
                            ++this.currentApplicationDataSet;
                        } else {
                            currentJobStep = this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_2 ? JobStep.WRITE_BOOTLOADER_DATA_SETS : JobStep.POST_DATA_SET;
                        }
                    }
                }
                this.setJobProgress(60L);
                continue;
            }
            if (currentJobStep == JobStep.WRITE_BOOTLOADER_DATA_SETS) {
                if (this.bootloaderDataSets.size() == 0) {
                    this.logger.debug("No bootloader data sets to download.");
                    currentJobStep = JobStep.ECU_RESET;
                } else {
                    this.logger.debug("Current bootloader data set: " + this.currentBootloaderDataSet);
                    ParameterDataBootloader bootloaderDataSet = (ParameterDataBootloader)this.bootloaderDataSets.get(this.currentBootloaderDataSet);
                    MCDDbFlashSession currentDbFlashSession = bootloaderDataSet.getDbFlashSession();
                    int logLevel = this.determineFlashJobLogLevel();
                    this.flashJob = this.flashJob(this.logicalLink, currentDbFlashSession, logLevel, "FALSE", this.vwDeviceNumber, this.importerNumber, this.workshopNumber);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.flashJob, 1, true);
                    if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
                        if (this.currentBootloaderDataSet < this.bootloaderDataSets.size() - 1) {
                            ++this.currentBootloaderDataSet;
                        } else {
                            currentJobStep = JobStep.RESTORE_PROTOCOL_PARAMETERS;
                        }
                    }
                }
                this.setJobProgress(60L);
                continue;
            }
            if (currentJobStep == JobStep.DONE) continue;
            this.logger.error("*** UNKNOWN job step ***: " + currentJobStep);
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.jobStatus = currentJobStatus;
        currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
        if (currentJobStep != JobStep.ECU_RESET && currentJobStep != JobStep.RESTORE_PROTOCOL_PARAMETERS && currentJobStep != JobStep.DONE) {
            currentJobStep = this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_2 ? JobStep.ECU_RESET : JobStep.POST_DATA_SET;
        }
        if (this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_1 && currentJobStatus != AbstractJob.JobStatus.NO_ERROR && SharedData.isDataSetsWrittenSuccessfully()) {
            SharedData.setDataSetsWrittenSuccessfully(false);
            this.logger.warn("WARNING: Suppressing writing of identification data due to errors within the pre-sequence!");
            this.setJobInfo("WARNING: Suppressing writing of identification data due to errors within the pre-sequence!");
        }
        while (currentJobStep.compareTo(JobStep.DONE) < 0 && currentJobStatusPostProgramming == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            if (currentJobStep == JobStep.POST_DATA_SET) {
                this.postDataSet = this.postDataSet(this.logicalLink, this.vehicleEquipmentCodeAndPrNumberCombination, this.vwDataSetNumberOrEcuDataContainerNumber, this.vwDataSetVersionNumber, this.hardwareAssemblyGroup, this.hardwareTypeCode, this.softwareAssemblyGroup, this.softwareTypeCode, this.softwareTypeVariant);
                currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.postDataSet, 1, true);
                if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR && currentJobStatusPostProgramming != AbstractJob.JobStatus.NO_ERROR) {
                    currentJobStatus = currentJobStatusPostProgramming;
                }
                currentJobStep = JobStep.POSTPROGRAMMING_START_COMMUNICATION;
                this.setJobProgress(60L);
                continue;
            }
            if (currentJobStep == JobStep.ECU_RESET) {
                if (!this.isFunctionalAddressingDisabled && this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                }
                this.currentService = this.ecuReset(this.logicalLink, Boolean.FALSE, "Key Off On Reset");
                currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NO_ERROR) {
                    currentJobStep = JobStep.SLEEP_ECU_SOFTWARE_RESET_DURATION;
                } else {
                    if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                        currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                    }
                    currentJobStep = JobStep.POSTPROGRAMMING_START_COMMUNICATION;
                }
                this.setJobProgress(91L);
                continue;
            }
            if (currentJobStep == JobStep.SLEEP_ECU_SOFTWARE_RESET_DURATION) {
                this.logger.debug("Sleeping for 2000 milliseconds...");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    this.logger.error("Sleeping thread was interrupted unexpectedly!");
                }
                this.setJobProgress(91L);
                currentJobStep = JobStep.POSTPROGRAMMING_START_COMMUNICATION;
                continue;
            }
            if (currentJobStep == JobStep.POSTPROGRAMMING_START_COMMUNICATION) {
                currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.jobStartCommunication, 1, true);
                if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED || currentJobStatusPostProgramming == AbstractJob.JobStatus.ERROR) {
                    currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(98L);
                currentJobStep = JobStep.RESTORE_PROTOCOL_PARAMETERS;
                continue;
            }
            if (currentJobStep != JobStep.RESTORE_PROTOCOL_PARAMETERS) continue;
            if (this.isPduApiUsed) {
                // empty if block
            }
            currentJobStep = JobStep.DONE;
        }
        this.logger.debug("Final job status: " + currentJobStatus);
        this.setJobProgress(99L);
        if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        return currentJobStatus;
    }

    protected void finalizeJobGuarded() {
        try {
            this.finalizeJob();
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in finalizeJob() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in finalizeJob() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
    }

    protected void finalizeJob() {
        this.logger.trace("Entering finalizeJob(...).");
        super.finalizeJob();
        this.finalizeLogging();
    }

    protected void finalizeLogging() {
        this.logger.finalize(this.getCurrentJobRuntimeAsString());
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters, String pShortNameOfWrappingParameter) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfInputParameters = 0L;
        MCDRequestParameter inputParameter = null;
        MCDRequestParameters nestedParameters = null;
        String inputParameterName = null;
        this.logger.trace("Entering readInputParameters(...).");
        try {
            numberOfInputParameters = pRequestParameters.getCount();
        }
        catch (MCDException mcde) {
            if (pShortNameOfWrappingParameter == null) {
                this.logger.fatal("Error determining number of job input parameters.");
            } else {
                this.logger.fatal("Error determining number of parameters for structured INPUT-PARAM \"" + pShortNameOfWrappingParameter + "\".");
            }
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pShortNameOfWrappingParameter == null) {
            this.logger.info("Number of INPUT-PARAMETERS to read: " + numberOfInputParameters);
        } else {
            this.logger.info("Number of PARAMS to read for INPUT-PARAM \"" + pShortNameOfWrappingParameter + "\": " + numberOfInputParameters);
        }
        for (long i = 0L; i < numberOfInputParameters; ++i) {
            try {
                inputParameter = pRequestParameters.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                inputParameterName = inputParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting SHORT-NAME of job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (inputParameterName.equals("IPA_FileName")) {
                try {
                    this.xmlMsgFileName = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.xmlMsgFileName);
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting value of job input parameter \"" + inputParameterName + "\"!");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_DiagnAddre")) {
                try {
                    this.expectedDiagnosticAddress = this.getParameterValueUint32AsShort((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.expectedDiagnosticAddress);
                }
                catch (Exception e) {
                    this.expectedDiagnosticAddress = 0;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.expectedDiagnosticAddress + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_Login")) {
                try {
                    this.login = this.getParameterValueUint32((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.login);
                }
                catch (Exception e) {
                    this.login = 0L;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.login + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_VWDevicNumbe")) {
                try {
                    this.vwDeviceNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.vwDeviceNumber);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("Error getting value of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_ImporNumbe")) {
                try {
                    this.importerNumber = this.getParameterValueUint32AsShort((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.importerNumber);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("Error getting value of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_WorksNumbe")) {
                try {
                    this.workshopNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.workshopNumber);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("Error getting value of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_WriteVWEOLConfi")) {
                try {
                    this.isWritingOfVwEolConfigurationEnabled = Boolean.valueOf(this.getParameterValueAsString((MCDParameter)inputParameter));
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + String.valueOf(this.isWritingOfVwEolConfigurationEnabled));
                }
                catch (Exception e) {
                    this.isWritingOfVwEolConfigurationEnabled = Boolean.valueOf("TRUE");
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + "TRUE" + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_VWEOLConfi")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_HardwAssemGroup")) {
                try {
                    this.hardwareAssemblyGroup = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.hardwareAssemblyGroup);
                }
                catch (Exception e) {
                    this.hardwareAssemblyGroup = "---";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.hardwareAssemblyGroup + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_HardwTypeCode")) {
                try {
                    this.hardwareTypeCode = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.hardwareTypeCode);
                }
                catch (Exception e) {
                    this.hardwareTypeCode = "----";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.hardwareTypeCode + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_SoftwAssemGroup")) {
                try {
                    this.softwareAssemblyGroup = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.softwareAssemblyGroup);
                }
                catch (Exception e) {
                    this.softwareAssemblyGroup = "---";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.softwareAssemblyGroup + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_SoftwTypeCode")) {
                try {
                    this.softwareTypeCode = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.softwareTypeCode);
                }
                catch (Exception e) {
                    this.softwareTypeCode = "----";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.softwareTypeCode + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_SoftwTypeVaria")) {
                try {
                    this.softwareTypeVariant = this.getParameterValueAsString((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.softwareTypeVariant);
                }
                catch (Exception e) {
                    this.softwareTypeVariant = "----";
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.softwareTypeVariant + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            return AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving readInputParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus addOutputParameters(MCDResponse pResponse) {
        MCDResponseParameter respParam_result = null;
        MCDValue value_result = null;
        if (pResponse == null) {
            this.logger.error("addOutputParameters() called with null argument!");
        } else {
            this.logger.debug("Retrieving response parameters.");
            try {
                respParam_result = pResponse.getResponseParameters().getItemByName("OPA_Resul");
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_Resul\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Retrieving values.");
            try {
                value_result = this.jobApi.createValue(11);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting value of job output parameter with SHORT-NAME \"OPA_Resul\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Setting values.");
            this.logger.debug("Setting result: " + this.jobStatus);
            this.setJobInfo("Job result: " + this.jobStatus);
            try {
                value_result.setUint32((long)this.jobStatus.intValue());
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting value of job output parameter with SHORT-NAME \"OPA_Resul\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Setting output parameters.");
            try {
                respParam_result.setValue(value_result);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting parameter value of job output parameter with SHORT-NAME \"OPA_Resul\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected boolean readEcuMem(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readEcuMem(...).");
        if (!this.readMem(pDbFlashSession)) {
            this.logger.debug("Error reading MEM.");
            return false;
        }
        if (!this.readPhysMem(pDbFlashSession)) {
            this.logger.debug("Error reading PHYS-MEM.");
            return false;
        }
        this.logger.trace("Leaving readEcuMem(...).");
        return true;
    }

    protected boolean readMem(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readMem(...).");
        if (!this.readSession(pDbFlashSession)) {
            this.logger.debug("Error reading SESSION.");
            return false;
        }
        this.logger.trace("Leaving readMem(...).");
        return true;
    }

    protected boolean readPhysMem(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readPhysMem(...).");
        pDbFlashSession.hashCode();
        this.logger.trace("Leaving readPhysMem(...).");
        return true;
    }

    protected boolean readSession(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readSession(...).");
        if (!this.isMcd20002Interface) {
            this.logger.warn("Skipping all SDGS in ODX FLASH due to detected MCD3D 2.00.xx interface prior to 2.00.02!");
        }
        this.logger.trace("Leaving readSession(...).");
        return true;
    }

    protected AbstractJob.JobStatus prepareProtocolParameterSet() {
        block15: {
            MCDRequest protocolParameterSetRequest = null;
            MCDRequestParameter comParam = null;
            MCDValue paramValue = null;
            String modifyTiming = null;
            this.logger.trace("Entering prepareProtocolParameterSet(...).");
            try {
                this.protocolParameterSet = (MCDProtocolParameterSet)this.logicalLink.createDiagComPrimitiveByType(1193);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating ProtocolParameterSet!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                this.protocolParameterSet.fetchValuesFromInterface();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error fetching COMPARAM values from interface!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                protocolParameterSetRequest = this.protocolParameterSet.getRequest();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request of ProtocolParameterSet!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                this.protocolParameters = protocolParameterSetRequest.getRequestParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting COMPARAMs from ProtocolParameterSet request!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                comParam = this.protocolParameters.getItemByName("CP_ModifyTiming");
                this.isPduApiUsed = true;
                this.logger.info("Using PDU-API firmware with ISO 22900-2 COMPARAMs.");
                paramValue = comParam.getValue();
                modifyTiming = paramValue.getValueAsString();
                this.isModifyTimingEnabled = modifyTiming.equals("Enabled");
            }
            catch (MCDException mcde) {
                this.isPduApiUsed = false;
                this.logger.info("Using Softing EIDBSS firmware with proprietary COMPARAMs.");
                if (this.maximumBlockSizeTransportLayer <= 1012L) break block15;
                if (this.logger.getLogLevel() >= 4) {
                    this.logger.info("maximumBlockSizeTransportLayer (" + this.maximumBlockSizeTransportLayer + ") exceeds buffer limit of EDIC hardware with EIDBSS firmware (" + 1012 + " bytes)!");
                    this.logger.info("Limiting maximumBlockSizeTransportLayer to 1012 bytes.");
                }
                this.maximumBlockSizeTransportLayer = 1012L;
            }
        }
        this.logger.debug("Saving initial COMPARAM values.");
        try {
            if (this.isPduApiUsed) {
                this.savedCanTransmissionTime = this.getProtocolParameterUint32(this.protocolParameterSet, this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime);
                this.savedP3CanClientPhys = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P3Phys");
                this.savedP3CanClientFunc = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P3Func");
                this.savedStMinOverride = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_StMinOverride");
                this.savedStMinOverride &= 0xFFFFFFFFL;
                this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_RepeatReqCountApp");
                this.savedStandTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
                this.savedExtenTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
            } else {
                this.savedCanTransmissionTime = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_CANTransTime");
                this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "NumberOfErrorRepetitions");
                this.savedStandTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "ResponseTimeout");
                this.savedExtenTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "RC78ResponseTimeout");
                this.savedP3CanClientPhys = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_P3CANClienPhys");
                this.savedP3CanClientFunc = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_P3CANClienFunc");
                this.savedRequestTime = this.getProtocolParameterUint32(this.protocolParameterSet, "RequestTime");
            }
            this.logger.debug("CP_P2Max /CP_P6Max : " + this.savedStandTiminP2Serve);
            this.logger.debug("CP_P2Star/CP_P6Star: " + this.savedExtenTiminP2Serve);
            this.logger.debug("CP_StMinOverride   : " + this.savedStMinOverride);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error saving initial COMPARAM values!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving prepareProtocolParameterSet(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected void logProtocolParameterSet(MCDProtocolParameterSet pProtocolParameterSet) throws MCDException {
        MCDRequestParameters comParams = null;
        long numberOfComParams = 0L;
        MCDRequestParameter comParam = null;
        MCDValue paramValue = null;
        this.logger.trace("Entering logProtocolParameterSet(...).");
        pProtocolParameterSet.fetchValuesFromInterface();
        comParams = pProtocolParameterSet.getRequest().getRequestParameters();
        numberOfComParams = comParams.getCount();
        this.logger.debug("Found " + numberOfComParams + " protocolParameters - current values are:");
        block5: for (long i = 0L; i < numberOfComParams; ++i) {
            comParam = comParams.getItemByIndex(i);
            paramValue = comParam.getValue();
            this.logMessage = "- " + comParam.getShortName() + ": ";
            switch (paramValue.getDataType()) {
                case 11: {
                    this.logMessage = this.logMessage + String.valueOf(paramValue.getUint32());
                    this.logger.debug(this.logMessage);
                    continue block5;
                }
                case 1: 
                case 14: {
                    this.logMessage = this.logMessage + paramValue.getValueAsString();
                    this.logger.debug(this.logMessage);
                    continue block5;
                }
                case 3: {
                    this.logMessage = this.logMessage + paramValue.getValueAsString();
                    this.logger.debug(this.logMessage);
                    continue block5;
                }
                default: {
                    this.logMessage = this.logMessage + "Data type of " + comParam.getShortName() + " is not ( yet) interpreted!";
                    this.logger.debug(this.logMessage);
                }
            }
        }
        this.logger.trace("Leaving logProtocolParameterSet(...).");
    }

    protected MCDStartCommunication startCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStartCommunication startCommunicationTmp = null;
        this.logger.trace("Entering startCommunication(...).");
        startCommunicationTmp = (MCDStartCommunication)pLogicalLink.createDiagComPrimitiveByType(1201);
        this.logger.trace("Leaving startCommunication(...).");
        return startCommunicationTmp;
    }

    protected MCDStopCommunication stopCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStopCommunication stopCommunicationTmp = null;
        this.logger.trace("Entering stopCommunication(...).");
        stopCommunicationTmp = (MCDStopCommunication)pLogicalLink.createDiagComPrimitiveByType(1202);
        this.logger.trace("Leaving stopCommunication(...).");
        return stopCommunicationTmp;
    }

    protected MCDService createService(MCDLogicalLink pLogicalLink, String pServiceShortName) throws MCDException {
        MCDService service = null;
        try {
            service = (MCDService)pLogicalLink.createDiagComPrimitiveByName(pServiceShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating service with SHORT-NAME: " + pServiceShortName);
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            throw mcde;
        }
        return service;
    }

    protected MCDSingleEcuJob createJob(MCDLogicalLink pLogicalLink, String pJobShortName) {
        MCDSingleEcuJob singleEcuJob = null;
        try {
            singleEcuJob = (MCDSingleEcuJob)pLogicalLink.createDiagComPrimitiveByName(pJobShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating single ECU job with SHORT-NAME: " + pJobShortName);
            this.logger.logThrowable(mcde);
        }
        return singleEcuJob;
    }

    protected MCDFlashJob createFlashJob(MCDLogicalLink pLogicalLink, String pJobShortName) {
        MCDFlashJob flashJobTmp = null;
        try {
            flashJobTmp = (MCDFlashJob)pLogicalLink.createDiagComPrimitiveByName(pJobShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating flash job with SHORT-NAME: " + pJobShortName);
            this.logger.logThrowable(mcde);
        }
        return flashJobTmp;
    }

    protected MCDService readDataByIdentifierEcuIdentification(MCDLogicalLink pLogicalLink, String pDataIdentifier) throws MCDException {
        MCDService readDataByIdentifierEcuIdentification = null;
        MCDRequestParameter param_recordDataIdentifer = null;
        MCDValue value_recordDataIdentifier = null;
        this.logger.trace("Entering readDataByIdentifierEcuIdentification(...).");
        readDataByIdentifierEcuIdentification = this.createService(pLogicalLink, "DiagnServi_ReadDataByIdentECUIdent");
        if (readDataByIdentifierEcuIdentification == null) {
            return readDataByIdentifierEcuIdentification;
        }
        try {
            param_recordDataIdentifer = readDataByIdentifierEcuIdentification.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting parameter with SHORT-NAME \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)readDataByIdentifierEcuIdentification);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            value_recordDataIdentifier = param_recordDataIdentifer.createValue();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error creating parameter value for \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)readDataByIdentifierEcuIdentification);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            value_recordDataIdentifier.setValueAsString(pDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value to parameter \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)readDataByIdentifierEcuIdentification);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            param_recordDataIdentifer.setValue(value_recordDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameter value of \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)readDataByIdentifierEcuIdentification);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        this.logger.trace("Leaving readDataByIdentifierEcuIdentification(...).");
        return readDataByIdentifierEcuIdentification;
    }

    protected MCDService diagnosticSessionControl(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pDiagnosticSessionType, boolean pUseFunctionalAddressing) throws MCDException {
        MCDService diagnosticSessionControl = null;
        this.logger.trace("Entering diagnosticSessionControl(...).");
        diagnosticSessionControl = pUseFunctionalAddressing ? this.createService(pLogicalLink, "DiagnServi_DiagnSessiContrFUNCT") : this.createService(pLogicalLink, "DiagnServi_DiagnSessiContr");
        this.setSuppressPosRspMsgIndicationBit(diagnosticSessionControl, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)diagnosticSessionControl, "Param_DiagnSessiType", pDiagnosticSessionType);
        this.logger.trace("Leaving diagnosticSessionControl(...).");
        return diagnosticSessionControl;
    }

    protected MCDService communicationControl(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pControlType, String pCommunicationType, String pSubnetNumber) throws MCDException {
        MCDService communicationControl = null;
        this.logger.trace("Entering communicationControl(...).");
        if (pControlType.equalsIgnoreCase("Enable Rx And Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrEnablRxAndTxNormaCommuMessa");
        } else if (pControlType.equalsIgnoreCase("Enable Rx And Disable Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrEnablRxAndDisabTxNormaCommuMessa");
        } else if (pControlType.equalsIgnoreCase("Disable Rx And Enable Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrDisabRxAndEnablTxNormaCommuMessa");
        } else if (pControlType.equalsIgnoreCase("Disable Rx And Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrDisabRxAndTxNormaCommuMessa");
        } else {
            throw new IllegalArgumentException("Invalid controlType.");
        }
        this.setSuppressPosRspMsgIndicationBit(communicationControl, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_CommuTypeBits0To1", pCommunicationType);
        this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_CommuTypeBits4To7", pSubnetNumber);
        this.logger.trace("Leaving communicationControl(...).");
        return communicationControl;
    }

    protected MCDService controlDtcSetting(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pDtcSettingType) throws MCDException {
        MCDService controlDtcSetting = null;
        this.logger.trace("Entering controlDtcSetting(...).");
        controlDtcSetting = this.createService(pLogicalLink, "DiagnServi_ContrDTCSetti");
        this.setSuppressPosRspMsgIndicationBit(controlDtcSetting, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)controlDtcSetting, "Param_DTCSettiType", pDtcSettingType);
        this.logger.trace("Leaving controlDtcSetting(...).");
        return controlDtcSetting;
    }

    protected MCDSingleEcuJob flashPostProgramming(MCDLogicalLink pLogicalLink, int pLogLevel) throws MCDException {
        MCDSingleEcuJob flashPostProgrammingTmp = null;
        this.logger.trace("Entering flashPostProgramming(...).");
        flashPostProgrammingTmp = this.createJob(pLogicalLink, "SinglJob_FlashPostProgr");
        this.setRequestParameterUint32((MCDDiagComPrimitive)flashPostProgrammingTmp, "IPA_LogLevel", (long)pLogLevel);
        this.logger.trace("Leaving flashPostProgramming(...).");
        return flashPostProgrammingTmp;
    }

    protected MCDSingleEcuJob flashPreProgramming(MCDLogicalLink pLogicalLink, int pLogLevel) throws MCDException {
        MCDSingleEcuJob flashPreProgrammingTmp = null;
        this.logger.trace("Entering flashPreProgramming(...).");
        flashPreProgrammingTmp = this.createJob(pLogicalLink, "SinglJob_FlashPreProgr");
        this.setRequestParameterUint32((MCDDiagComPrimitive)flashPreProgrammingTmp, "IPA_LogLevel", (long)pLogLevel);
        this.logger.trace("Leaving flashPreProgramming(...).");
        return flashPreProgrammingTmp;
    }

    protected MCDSingleEcuJob securityAccess(MCDLogicalLink pLogicalLink, int pLogLevel, String pSecurityMethod, long pSecurityCode) throws MCDException {
        MCDSingleEcuJob securityAccessTmp = null;
        this.logger.trace("Entering securityAccess(...).");
        securityAccessTmp = this.createJob(pLogicalLink, "SinglJob_SecurAcces");
        this.setRequestParameterUint32((MCDDiagComPrimitive)securityAccessTmp, "IPA_LogLevel", (long)pLogLevel);
        this.setRequestParameterString((MCDDiagComPrimitive)securityAccessTmp, "IPA_SecurMetho", pSecurityMethod);
        this.setRequestParameterUint32((MCDDiagComPrimitive)securityAccessTmp, "IPA_SecurCode", pSecurityCode);
        this.logger.trace("Leaving securityAccess(...).");
        return securityAccessTmp;
    }

    protected MCDSingleEcuJob writeFingerprint(MCDLogicalLink pLogicalLink, int pLogLevel, String pFingerprintType, long pVwDeviceNumber, short pImporterNumber, long pWorkshopNumber, byte pYear, byte pMonth, byte pDay) throws MCDException {
        MCDSingleEcuJob writeFingerprintTmp = null;
        this.logger.trace("Entering writeFingerprint(...).");
        writeFingerprintTmp = this.createJob(pLogicalLink, "SinglJob_WriteFinge");
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "IPA_LogLevel", (long)pLogLevel);
        this.setRequestParameterString((MCDDiagComPrimitive)writeFingerprintTmp, "IPA_FingeType", pFingerprintType);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_VWDevicNumbe", pVwDeviceNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_ImporNumbe", (long)pImporterNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_WorksNumbe", pWorkshopNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_Year", (long)pYear);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_Month", (long)pMonth);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_Day", (long)pDay);
        this.logger.trace("Leaving writeFingerprint(...).");
        return writeFingerprintTmp;
    }

    protected MCDSingleEcuJob dataSet(MCDLogicalLink pLogicalLink, byte[] pData, long pLength, byte[] pStartAddress) throws MCDException {
        MCDSingleEcuJob dataSetTmp = null;
        this.logger.trace("Entering dataSet(...).");
        dataSetTmp = this.createJob(pLogicalLink, "SinglJob_DataSet");
        this.setRequestParameterBytefield((MCDDiagComPrimitive)dataSetTmp, "IPA_Data", pData);
        this.setRequestParameterUint32((MCDDiagComPrimitive)dataSetTmp, "IPA_Lengt", pLength);
        this.setRequestParameterBytefield((MCDDiagComPrimitive)dataSetTmp, "IPA_StartAddre", pStartAddress);
        this.logger.trace("Leaving dataSet(...).");
        return dataSetTmp;
    }

    protected MCDSingleEcuJob postDataSet(MCDLogicalLink pLogicalLink, byte[] pVehicleEquipmentCodeAndPrNumberCombination, String pVwDataSetNumberOrEcuDataContainerNumber, String pVwDataSetVersionNumber, String pHardwareAssemblyGroup, String pHardwareTypeCode, String pSoftwareAssemblyGroup, String pSoftwareTypeCode, String pSoftwareTypeVariant) throws MCDException {
        MCDSingleEcuJob postDataSetTmp = null;
        this.logger.trace("Entering postDataSet(...).");
        postDataSetTmp = this.createJob(pLogicalLink, "SinglJob_PostDataSet");
        this.setRequestParameterBytefield((MCDDiagComPrimitive)postDataSetTmp, "IPA_Refer", pVehicleEquipmentCodeAndPrNumberCombination);
        this.setRequestParameterString((MCDDiagComPrimitive)postDataSetTmp, "IPA_ZDCIdent", pVwDataSetNumberOrEcuDataContainerNumber);
        this.setRequestParameterString((MCDDiagComPrimitive)postDataSetTmp, "IPA_ZDCVersi", pVwDataSetVersionNumber);
        this.setRequestParameterString((MCDDiagComPrimitive)postDataSetTmp, "Param_HardwAssemGroup", pHardwareAssemblyGroup);
        this.setRequestParameterString((MCDDiagComPrimitive)postDataSetTmp, "Param_HardwTypeCode", pHardwareTypeCode);
        this.setRequestParameterString((MCDDiagComPrimitive)postDataSetTmp, "Param_SoftwAssemGroup", pSoftwareAssemblyGroup);
        this.setRequestParameterString((MCDDiagComPrimitive)postDataSetTmp, "Param_SoftwTypeCode", pSoftwareTypeCode);
        this.setRequestParameterString((MCDDiagComPrimitive)postDataSetTmp, "Param_SoftwTypeVaria", pSoftwareTypeVariant);
        this.logger.trace("Leaving postDataSet(...).");
        return postDataSetTmp;
    }

    protected MCDFlashJob flashJob(MCDLogicalLink pLogicalLink, MCDDbFlashSession pDbFlashSession, int pLogLevel, String pIsPartialFlashProgrammingEnabled, long pVwDeviceNumber, short pImporterNumber, long pWorkshopNumber) throws MCDException {
        MCDFlashJob flashJobTmp = null;
        this.logger.trace("Entering flashJob(...).");
        flashJobTmp = this.createFlashJob(pLogicalLink, "SinglJob_FlashJobUDS");
        flashJobTmp.setSession(pDbFlashSession);
        this.setRequestParameterUint32((MCDDiagComPrimitive)flashJobTmp, "IPA_LogLevel", (long)pLogLevel);
        this.setRequestParameterString((MCDDiagComPrimitive)flashJobTmp, "IPA_PFLEnabl", pIsPartialFlashProgrammingEnabled);
        this.setRequestParameterUint32((MCDDiagComPrimitive)flashJobTmp, "Param_VWDevicNumbe", pVwDeviceNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)flashJobTmp, "Param_ImporNumbe", (long)pImporterNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)flashJobTmp, "Param_WorksNumbe", pWorkshopNumber);
        this.logger.trace("Leaving flashJob(...).");
        return flashJobTmp;
    }

    protected MCDSingleEcuJob startCommunication(MCDLogicalLink pLogicalLink, int pLogLevel, long pVwDeviceNumber, short pImporterNumber, long pWorkshopNumber, byte pYear, byte pMonth, byte pDay) throws MCDException {
        MCDSingleEcuJob startCommunicationTmp = null;
        this.logger.trace("Entering startCommunication(...).");
        startCommunicationTmp = this.createJob(pLogicalLink, "SinglJob_StartCommu");
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "IPA_LogLevel", (long)pLogLevel);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_VWDevicNumbe", pVwDeviceNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_ImporNumbe", (long)pImporterNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_WorksNumbe", pWorkshopNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_Year", (long)pYear);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_Month", (long)pMonth);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_Day", (long)pDay);
        this.logger.trace("Leaving startCommunication(...).");
        return startCommunicationTmp;
    }

    protected MCDService routineControlStartRoutineDataSet(MCDLogicalLink pLogicalLink, String pRoutineIdentifier, String pVwCalibrationAndApplicationData) throws MCDException {
        MCDService routineControl = null;
        this.logger.trace("Entering routineControlStartRoutineDataSet(...).");
        routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrStartRoutiDataSet");
        this.setRequestParameterString((MCDDiagComPrimitive)routineControl, "Param_RoutiIdent", pRoutineIdentifier);
        this.setRequestParameterString((MCDDiagComPrimitive)routineControl, "Param_VWCalibAndAppliData", pVwCalibrationAndApplicationData);
        this.logger.trace("Leaving routineControlStartRoutineDataSet(...).");
        return routineControl;
    }

    protected MCDService routineControlRequestRoutineResultsDataSet(MCDLogicalLink pLogicalLink, String pRoutineIdentifier) throws MCDException {
        MCDService routineControl = null;
        this.logger.trace("Entering routineControlRequestRoutineResultsDataSet(...).");
        routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrRequeRoutiResulDataSet");
        this.setRequestParameterString((MCDDiagComPrimitive)routineControl, "Param_RoutiIdent", pRoutineIdentifier);
        this.logger.trace("Leaving routineControlRequestRoutineResultsDataSet(...).");
        return routineControl;
    }

    protected MCDService requestDownload(MCDLogicalLink pLogicalLink, String pCompressionMethod, String pEncryptionMethod, byte pLengthFormatIdentifier, byte pAddressFormatIdentifier, long pMemoryAddress, long pMemorySize) throws MCDException {
        MCDService requestDownload = null;
        this.logger.trace("Entering requestDownload(...).");
        if (this.isMcd20002Interface) {
            requestDownload = this.createService(pLogicalLink, "DiagnServi_RequeDownl");
        } else {
            try {
                requestDownload = this.createService(pLogicalLink, "DiagnServi_RequeDownlMCD20001");
            }
            catch (MCDException mcde) {
                requestDownload = this.createService(pLogicalLink, "DiagnServi_RequeDownl");
            }
        }
        if (pCompressionMethod != null) {
            this.setRequestParameterString((MCDDiagComPrimitive)requestDownload, "Param_ComprMetho", pCompressionMethod);
        }
        if (pEncryptionMethod != null) {
            this.setRequestParameterString((MCDDiagComPrimitive)requestDownload, "Param_EncryMetho", pEncryptionMethod);
        }
        if (this.isMcd20002Interface) {
            this.setLengthFormatIdentifier(requestDownload, (byte)(pLengthFormatIdentifier * 8));
        } else {
            this.setLengthFormatIdentifier(requestDownload, pLengthFormatIdentifier);
        }
        if (this.isMcd20002Interface) {
            this.setAddressFormatIdentifier(requestDownload, (byte)(pAddressFormatIdentifier * 8));
        } else {
            this.setAddressFormatIdentifier(requestDownload, pAddressFormatIdentifier);
        }
        if (pAddressFormatIdentifier > 0) {
            this.setMemoryAddress(requestDownload, Conversions.long2ByteArray(pMemoryAddress, pAddressFormatIdentifier));
        }
        if (pLengthFormatIdentifier > 0) {
            this.setMemorySize(requestDownload, Conversions.long2ByteArray(pMemorySize, pLengthFormatIdentifier));
        }
        this.logger.trace("Leaving requestDownload(...).");
        return requestDownload;
    }

    protected MCDService transferData(MCDLogicalLink pLogicalLink, byte pBlockSequenceCounter, byte[] pTransferRequestParameterRecord) throws MCDException {
        this.logger.trace("Entering transferData(...).");
        MCDService transferData = this.createService(pLogicalLink, "DiagnServi_TransData");
        this.setBlockSequenceCounter(transferData, pBlockSequenceCounter);
        this.setTransferRequestParameterRecord(transferData, pTransferRequestParameterRecord);
        this.logger.trace("Leaving transferData(...).");
        return transferData;
    }

    protected MCDService requestTransferExit(MCDLogicalLink pLogicalLink) throws MCDException {
        this.logger.trace("Entering requestTransferExit(...).");
        MCDService requestTransferExit = this.createService(pLogicalLink, "DiagnServi_RequeTransExit");
        this.logger.trace("Leaving requestTransferExit(...).");
        return requestTransferExit;
    }

    protected MCDService ecuReset(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pResetType) throws MCDException {
        MCDService ecuReset = null;
        this.logger.trace("Entering ecuReset(...).");
        if (pResetType.equals("Hard Reset")) {
            ecuReset = this.createService(pLogicalLink, "DiagnServi_ECUResetHardReset");
        } else if (pResetType.equals("Key Off On Reset")) {
            ecuReset = this.createService(pLogicalLink, "DiagnServi_ECUResetKeyOffOnReset");
        } else if (pResetType.equals("Soft Reset")) {
            ecuReset = this.createService(pLogicalLink, "DiagnServi_ECUResetSoftReset");
        } else {
            throw new IllegalArgumentException("Invalid resetType.");
        }
        pSuppressResponse.hashCode();
        this.logger.trace("Leaving ecuReset(...).");
        return ecuReset;
    }

    protected void setSuppressPosRspMsgIndicationBit(MCDService pService, Boolean pValue) throws MCDException {
        this.logger.trace("Entering setSuppressPosRspMsgIndicationBit(...).");
        this.setRequestParameterString((MCDDiagComPrimitive)pService, "Param_SupprPositRespoMessaIndicBit", pValue.toString().toUpperCase());
        if (pValue == Boolean.TRUE && this.isMcd300Interface) {
            this.logger.debug("Setting SPR flag.");
            this.vendorSpecific.setSuppressPositiveResponseUnchecked(pService);
        }
        this.logger.trace("Leaving setSuppressPosRspMsgIndicationBit(...).");
    }

    protected void setAddressFormatIdentifier(MCDService pService, byte pAddressFormatIdentifier) throws MCDException {
        this.logger.trace("Entering setAddressFormatIdentifier(...).");
        this.setRequestParameterUint32((MCDDiagComPrimitive)pService, "Param_AddreFormaIdent", (long)pAddressFormatIdentifier);
        this.logger.trace("Leaving setAddressFormatIdentifier(...).");
    }

    protected void setLengthFormatIdentifier(MCDService pService, byte pLengthFormatIdentifier) throws MCDException {
        this.logger.trace("Entering setLengthFormatIdentifier(...).");
        this.setRequestParameterUint32((MCDDiagComPrimitive)pService, "Param_LengtFormaIdent", (long)pLengthFormatIdentifier);
        this.logger.trace("Leaving setLengthFormatIdentifier(...).");
    }

    protected void setMemoryAddress(MCDService pService, byte[] pMemoryAddress) throws MCDException {
        byte[] memoryAddressToSet = null;
        this.logger.trace("Entering setMemoryAddress(...).");
        memoryAddressToSet = pMemoryAddress;
        MCDRequestParameter param_memoryAddress = pService.getRequest().getRequestParameters().getItemByName("Param_MemorAddre");
        MCDValue memoryAddress = param_memoryAddress.createValue();
        memoryAddress.setBytefield(memoryAddressToSet);
        param_memoryAddress.setValue(memoryAddress);
        this.logger.trace("Leaving setMemoryAddress(...).");
    }

    protected void setMemorySize(MCDService pService, byte[] pMemorySize) throws MCDException {
        byte[] memorySizeToSet = null;
        this.logger.trace("Entering setMemorySize(...).");
        memorySizeToSet = pMemorySize;
        MCDRequestParameter param_memorySize = pService.getRequest().getRequestParameters().getItemByName("Param_MemorSize");
        MCDValue memorySize = param_memorySize.createValue();
        memorySize.setBytefield(memorySizeToSet);
        param_memorySize.setValue(memorySize);
        this.logger.trace("Leaving setMemorySize(...).");
    }

    protected void setBlockSequenceCounter(MCDService pService, byte pBlockSequenceCounter) throws MCDException {
        this.logger.trace("Entering setBlockSequenceCounter(...).");
        this.setRequestParameterUint32((MCDDiagComPrimitive)pService, "Param_BlockSequeCount", (long)(pBlockSequenceCounter & 0xFF));
        this.logger.trace("Leaving setBlockSequenceCounter(...).");
    }

    protected void setTransferRequestParameterRecord(MCDService pService, byte[] pTransferRequestParameterRecord) throws MCDException {
        this.logger.trace("Entering setTransferRequestParameterRecord(...).");
        this.setRequestParameterBytefield((MCDDiagComPrimitive)pService, "Param_TransRequeParamRecor", pTransferRequestParameterRecord);
        this.logger.trace("Leaving setTransferRequestParameterRecord(...).");
    }

    protected void setRequestParameterUint32(MCDRequestParameters pRequestParameters, String pRequestParameterName, long pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterUint32(...).");
        requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        value = requestParameter.createValue();
        value.setUint32(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterUint32(...).");
    }

    protected void setRequestParameterUint32(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, long pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterUint32(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        value.setUint32(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterUint32(...).");
    }

    protected void setRequestParameterString(MCDRequestParameters pRequestParameters, String pRequestParameterName, String pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterString(...).");
        requestParameter = this.getRequestParameter(pRequestParameters, pRequestParameterName);
        value = requestParameter.createValue();
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected void setRequestParameterString(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, String pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterString(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        this.logger.debug("Setting parameter to: " + pValue);
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected void setRequestParameterBytefield(MCDRequestParameters pRequestParameters, String pRequestParameterName, byte[] pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterBytefield(...).");
        requestParameter = this.getRequestParameter(pRequestParameters, pRequestParameterName);
        value = requestParameter.createValue();
        value.setBytefield(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterBytefield(...).");
    }

    protected void setRequestParameterBytefield(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, byte[] pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterBytefield(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        value.setBytefield(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterBytefield(...).");
    }

    protected MCDRequestParameter getRequestParameter(MCDRequestParameters pRequestParameters, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = null;
        MCDRequestParameter currentRequestParameter = null;
        MCDRequestParameters requestSubParameters = null;
        long numberOfRequestParameters = 0L;
        this.logger.debug("Getting request parameter: " + pRequestParameterName);
        try {
            requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        }
        catch (MCDException mcde) {
            if (mcde.getError().getCode() != 49184 && mcde.getError().getCode() != 49177) {
                this.logger.debug("Error getting request parameter with SHORT-NAME \"" + pRequestParameterName + "\"!");
                this.logger.logThrowable(mcde);
            }
            numberOfRequestParameters = pRequestParameters.getCount();
            for (long i = 0L; i < numberOfRequestParameters && requestParameter == null; ++i) {
                currentRequestParameter = pRequestParameters.getItemByIndex(i);
                if (currentRequestParameter.getType() != 17) continue;
                requestSubParameters = currentRequestParameter.getParameters();
                requestParameter = this.getRequestParameter(requestSubParameters, pRequestParameterName);
            }
        }
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected MCDRequestParameter getRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive.getRequest().getRequestParameters(), pRequestParameterName);
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected void updateProtocolParameters(MCDProtocolParameterSet pProtocolParameterSet) {
        MCDResult result = null;
        int diagComprimitiveState = 0;
        this.logger.trace("Entering updateProtocolParameters(...).");
        try {
            result = pProtocolParameterSet.executeSync();
        }
        catch (MCDException mcde) {
            this.logger.error("Error executing MCDProtocolParameterSet.");
            this.logger.logThrowable(mcde);
            return;
        }
        try {
            diagComprimitiveState = pProtocolParameterSet.getState();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining comprimitive state of protocol parameter set.");
            this.logger.logThrowable(mcde);
            return;
        }
        this.logger.info("Current state of protocol parameter set is: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComprimitiveState));
        if (result != null) {
            boolean resultHasError = true;
            try {
                resultHasError = result.hasError();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining if result has an error.");
                this.logger.logThrowable(mcde);
                return;
            }
            if (resultHasError) {
                MCDError error = null;
                this.logger.debug("Error updating protocol parameters: Result has error.");
                try {
                    error = result.getError();
                }
                catch (Exception e) {
                    this.logger.error("Error getting error from result.");
                    this.logger.logThrowable(e);
                    return;
                }
                this.logger.logMcdError(error);
            } else {
                int executionState = -1;
                try {
                    executionState = result.getResultState().getExecutionState();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting execution state from result state.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.debug("Success updating protocol parameters.");
                this.logger.debug("ResultState of MCDProtocolParameterSet: " + McdEnumDecoder.decodeMcdExecutionState(executionState));
            }
        } else {
            MCDErrors errors = null;
            long numberOfErrors = 0L;
            MCDError error = null;
            this.logger.debug("Error updating protocol parameters: Result is null. This is caused by a DTS bug.");
            try {
                errors = pProtocolParameterSet.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting errors from MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            try {
                numberOfErrors = errors.getCount();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining number of errors of MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = errors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + " from MCDProtocolParameterSet.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving updateProtocolParameters(...).");
    }

    protected AbstractJob.JobStatus updateSessionTimings(MCDProtocolParameterSet pProtocolParameterSet, long pStandTiminP2Serve, long pExtenTiminP2Serve) throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int canTransmissionTime = 0;
        int p2CanServer = 0;
        int p2StarCanServer = 0;
        this.logger.trace("Entering updateSessionTimings(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.isPduApiUsed) {
            if (!this.isModifyTimingEnabled) {
                canTransmissionTime = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime);
                p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
                p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
                this.logger.debug("Setting P2_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ") from " + p2CanServer + " \u00b5s to " + (pStandTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max, pStandTiminP2Serve * 1000L + (long)canTransmissionTime);
                this.logger.debug("Setting P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") from " + p2StarCanServer + " \u00b5s to " + (pExtenTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star, pExtenTiminP2Serve * 1000L + (long)canTransmissionTime);
            }
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
            this.logger.debug("P2_CAN_Server  (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ")  is now set to " + p2CanServer + " \u00b5s.");
            this.logger.debug("P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") is now set to " + p2StarCanServer + " \u00b5s.");
        } else {
            canTransmissionTime = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ComPar_CANTransTime");
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("Setting P2_CAN_Server (ResponseTimeout) from " + p2CanServer + " ms to " + (pStandTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "ResponseTimeout", pStandTiminP2Serve + (long)canTransmissionTime);
            this.logger.debug("Setting P2*_CAN_Server (RC78ResponseTimeout) from " + p2StarCanServer + " ms to " + (pExtenTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "RC78ResponseTimeout", pExtenTiminP2Serve + (long)canTransmissionTime);
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("P2_CAN_Server  (ResponseTimeout)     is now set to " + p2CanServer + " ms.");
            this.logger.debug("P2*_CAN_Server (RC78ResponseTimeout) is now set to " + p2StarCanServer + " ms.");
        }
        this.logger.trace("Leaving updateSessionTimings(...).");
        return currentJobStatus;
    }

    protected void setRepeatRequestCounter(long pNumberOfRepetitions) throws MCDException {
        this.logger.trace("Entering setRepeatRequestCounter(...).");
        try {
            if (this.isPduApiUsed) {
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", pNumberOfRepetitions);
            } else {
                this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", pNumberOfRepetitions);
            }
        }
        catch (MCDException mcde) {
            this.logger.error("Error updating the repetition counter!");
            throw mcde;
        }
        this.logger.debug("RepeatRequestCounter set to: " + pNumberOfRepetitions);
        this.logger.trace("Leaving setRepeatRequestCounter(...).");
    }

    protected AbstractJob.JobStatus executeDiagComPrimitiveSync(MCDLogicalLink pLogicalLink, MCDDiagComPrimitive pDiagComPrimitive, int pMaxNumberOfRepetitions, boolean pRemoveDiagComPrimitive) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResult result = null;
        int diagComPrimitiveType = -1;
        int transmissionMode = -1;
        String diagComPrimitiveName = null;
        MCDValue requestPdu = null;
        String requestPduAsString = null;
        int diagComPrimitiveState = -1;
        MCDErrors errors = null;
        long startTime = 0L;
        this.logger.trace("Entering executeDiagComPrimitiveSync(...).");
        try {
            diagComPrimitiveType = pDiagComPrimitive.getObjectType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining type of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Type of diagComPrimitive: " + McdEnumDecoder.decodeMcdObjectType(diagComPrimitiveType));
        try {
            transmissionMode = pDiagComPrimitive.getDbObject().getTransmissionMode();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining transmission mode of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Transmission mode of diagComPrimitive: " + McdEnumDecoder.decodeMcdTransmissionMode(transmissionMode));
        try {
            diagComPrimitiveName = pDiagComPrimitive.getDbObject().getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Name of diagComPrimitive: " + diagComPrimitiveName);
        if (this.logger.getLogLevel() > 0 && (diagComPrimitiveType == 1190 || diagComPrimitiveType == 1198)) {
            try {
                requestPdu = pDiagComPrimitive.getRequest().getPDU();
                requestPduAsString = this.vendorSpecific.pduValue2String(requestPdu);
                if (requestPduAsString.length() > 256) {
                    requestPduAsString = requestPduAsString.substring(0, 256) + " ... (truncated for logging)";
                }
                this.logger.debug("Request PDU of diagComPrimitive: " + requestPduAsString);
                if (this.logger.getLogLevel() >= 6) {
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " -> [   ".substring(0, 8 - Integer.toHexString(requestPdu.getBytefield().length).length()) + Integer.toHexString(requestPdu.getBytefield().length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(requestPdu));
                }
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request PDU of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        int repetitions = pMaxNumberOfRepetitions;
        block24: do {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
            this.logger.debug("Executing diagComPrimitive '" + diagComPrimitiveName + "'.");
            try {
                --repetitions;
                startTime = System.currentTimeMillis();
                result = pDiagComPrimitive.executeSync();
                this.logger.debug("Execution time of diagComPrimitive \"" + diagComPrimitiveName + "\": " + (System.currentTimeMillis() - startTime) + " ms");
            }
            catch (MCDException mcde) {
                this.logger.debug("Error executing diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Getting errors.");
            try {
                errors = pDiagComPrimitive.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting errors of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            if (errors == null) {
                this.logger.error("MCDDiagComPrimitive.getErrors() returned null.");
            } else {
                this.logger.debug("Handling errors.");
                currentJobStatus = this.handleErrors(errors);
            }
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                // empty if block
            }
            this.logger.debug("Determining state of diagComPrimitive.");
            try {
                diagComPrimitiveState = pDiagComPrimitive.getState();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining state of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("State of diagComPrimitive: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComPrimitiveState));
            switch (diagComPrimitiveState) {
                case 25090: {
                    try {
                        pDiagComPrimitive.cancel();
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error cancelling diagComPrimitive.");
                        this.logger.logThrowable(mcde);
                        currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        break;
                    }
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                case 25089: {
                    if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR || diagComPrimitiveType == 1201 || diagComPrimitiveType == 1202) continue block24;
                    currentJobStatus = this.handleResult(pDiagComPrimitive, diagComPrimitiveType, result);
                    this.logger.debug("job status after handleResult(): " + currentJobStatus);
                    if (currentJobStatus != AbstractJob.JobStatus.WRONG_UBATT_DETECTED) continue block24;
                    this.logger.debug("Cancelling repetitions due to detection of wrong battery voltage.");
                    repetitions = 0;
                    break;
                }
                default: {
                    this.logger.error("*** UNKNOWN MCDDiagComPrimitiveState ***: " + diagComPrimitiveState);
                }
            }
        } while (repetitions > 0 && currentJobStatus != AbstractJob.JobStatus.NO_ERROR);
        this.logger.debug("Releasing result.");
        try {
            this.job.releaseResult(result);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error releasing result.");
            this.logger.logThrowable(mcde);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pRemoveDiagComPrimitive) {
            try {
                pLogicalLink.removeDiagComPrimitive(pDiagComPrimitive);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving executeDiagComPrimitiveSync(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResult(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, MCDResult pResult) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        boolean resultHasError = false;
        this.logger.trace("Entering handleResult(...).");
        if (pDiagComPrimitiveType == 1198 || pDiagComPrimitiveType == 1190) {
            try {
                request = pDiagComPrimitive.getRequest();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request from diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                requestParameters = request.getRequestParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request parameters from request.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        try {
            resultHasError = pResult.hasError();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining if result has an error.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (resultHasError) {
            MCDError error = null;
            this.logger.debug("Result has error.");
            try {
                error = pResult.getError();
            }
            catch (Exception e) {
                this.logger.debug("Error getting error from result.");
                this.logger.logThrowable(e);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53392 && error.getVendorCode() == 259 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 5074 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53315 && error.getVendorCode() == 20480 || pDiagComPrimitiveType == 1198 && !this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 19) {
                this.logger.debug("Ignoring P2 timeout since positive response has been suppressed.");
            } else if (error.getCode() == 53327 && error.getVendorCode() == 257) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 20) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && (error.getVendorCode() == 17 || error.getVendorCode() == 25 || error.getVendorCode() == 26 || error.getVendorCode() == 42 || error.getVendorCode() == 47)) {
                this.logger.warn("Wrong battery voltage detected - probably due to an interruption of clamp 30 or 15!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.WRONG_UBATT_DETECTED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 27) {
                this.logger.warn("EDIC interface deadlock error detected - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 16 || error.getCode() == 53315 && error.getVendorCode() == 16) {
                this.logger.warn("Command refused by EDIC interface - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 58644 || error.getCode() == 53327 && (this.isPduApiUsed && error.getCode() == 262 || !this.isPduApiUsed && error.getCode() == 13)) {
                this.logger.warn("Communication to VCI lost (possibly due to voltage drop) - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_TO_VCI_LOST_OR_DISTURBED;
            } else {
                this.logger.logMcdError(error);
                if (error.getCode() != 49152) {
                    if (this.isPduApiUsed && error.getCode() == 53327 && error.getVendorCode() == 5076) {
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        this.setJobInfo("ERROR: No result received from called job!");
                    } else if (VendorSpecific.getServerVendor() == DServerVendor.SOFTING && error.getCode() != 49192 || VendorSpecific.getServerVendor() == DServerVendor.DSA && error.getCode() != 53315 && error.getVendorCode() != 6230) {
                        currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
                    } else {
                        String serviceShortName = null;
                        int resultType = -1;
                        MCDResponses responses = null;
                        try {
                            serviceShortName = pResult.getServiceShortName();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining service SHORT-NAME of result.");
                            this.logger.logThrowable(mcde);
                            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        }
                        this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
                        try {
                            resultType = pResult.getType();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining type of result.");
                            this.logger.logThrowable(mcde);
                            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        }
                        this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
                        if (resultType == 1793) {
                            this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
                        } else {
                            try {
                                responses = pResult.getResponses();
                            }
                            catch (MCDException mcde) {
                                this.logger.debug("Error getting responses from result.");
                                this.logger.logThrowable(mcde);
                                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                            }
                            currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, requestParameters, responses);
                            this.logger.debug("job status after handleResponses(): " + currentJobStatus);
                        }
                    }
                }
            }
            if (!this.isPduApiUsed) {
                this.logger.debug("Restarting communication after timeout.");
                if (error.getCode() != 49152) {
                    this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.stopCommunication, 1, false);
                    this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.startCommunication, 1, false);
                }
            }
        } else {
            String serviceShortName = null;
            int resultType = -1;
            MCDResponses responses = null;
            try {
                serviceShortName = pResult.getServiceShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining service SHORT-NAME of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
            try {
                resultType = pResult.getType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining type of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
            if (resultType == 1793) {
                this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
            } else {
                try {
                    responses = pResult.getResponses();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting responses from result.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, requestParameters, responses);
                this.logger.debug("job status after handleResponses(): " + currentJobStatus);
            }
        }
        this.logger.trace("Leaving handleResult(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResponses(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponses pResponses) {
        AbstractJob.JobStatus currentJobStatus = null;
        long responseCount = 0L;
        MCDResponse response = null;
        AbstractJob.JobStatus currentStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handleResponses(...).");
        try {
            responseCount = pResponses.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of responses.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of responses: " + responseCount);
        if (!this.isPositiveResponseSuppressed(pDiagComPrimitiveType, pRequestParameters)) {
            currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
        } else if (responseCount == 0L) {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        for (long i = 0L; i < responseCount; ++i) {
            try {
                response = pResponses.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            currentStatus = this.handleResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, response);
            if (this.responseLocationAccessKey.equals(this.dbLocationAccessKey) || this.responseLocationAccessKey.equals(this.dbLocationAccessKeyBaseVariant)) {
                currentJobStatus = currentStatus;
                continue;
            }
            this.logger.debug("dbLocation of response    : " + this.responseLocationAccessKey);
            this.logger.debug("dbLocation of BASE-VARIANT: " + this.dbLocationAccessKeyBaseVariant);
            this.logger.debug("dbLocation of LOGICAL-LINK: " + this.dbLocationAccessKey);
        }
        this.logger.trace("Leaving handleResponses(...).");
        return currentJobStatus;
    }

    protected boolean isPositiveResponseSuppressed(int pDiagComPrimitiveType, MCDRequestParameters pRequestParameters) {
        MCDRequestParameter param_suppressPositiveResponseMessageIndicationBit = null;
        String suppressPositiveResponseMessageIndicationBit = null;
        this.logger.trace("Entering isPositiveResponseSuppressed(...).");
        switch (pDiagComPrimitiveType) {
            case 1198: {
                try {
                    param_suppressPositiveResponseMessageIndicationBit = pRequestParameters.getItemByName("Param_SupprPositRespoMessaIndicBit");
                    this.logger.info("Found Param_SupprPositRespoMessaIndicBit in request.");
                    try {
                        suppressPositiveResponseMessageIndicationBit = param_suppressPositiveResponseMessageIndicationBit.getValue().getValueAsString();
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting value of Param_SupprPositRespoMessaIndicBit from request.");
                        this.logger.logThrowable(mcde);
                        suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                    }
                }
                catch (MCDException mcde) {
                    this.logger.info("No Param_SupprPositRespoMessaIndicBit found in request.");
                    suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                }
                break;
            }
            case 1190: 
            case 1192: 
            case 1197: 
            case 1200: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                break;
            }
            default: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
            }
        }
        if (suppressPositiveResponseMessageIndicationBit.equalsIgnoreCase(Boolean.TRUE.toString())) {
            this.logger.debug("Response has been suppressed.");
        } else {
            this.logger.debug("Response has not been suppressed.");
        }
        this.logger.trace("Leaving isPositiveResponseSuppressed(...).");
        return Boolean.valueOf(suppressPositiveResponseMessageIndicationBit);
    }

    protected AbstractJob.JobStatus handleResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDAccessKey accessKeyOfLocation = null;
        int responseState = -1;
        this.logger.trace("Entering handleResponse(...).");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    accessKeyOfLocation = pResponse.getAccessKeyOfLocation();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (accessKeyOfLocation == null) {
                    this.logger.debug("MCDResponse.getAccessKeyOfLocation() returned null!");
                    return AbstractJob.JobStatus.ERROR;
                }
                try {
                    this.responseLocationAccessKey = accessKeyOfLocation.getString();
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting string for access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1192: 
            case 1197: 
            case 1200: {
                this.responseLocationAccessKey = this.dbLocationAccessKey;
                break;
            }
        }
        this.logger.debug("DbLocation of response: " + this.responseLocationAccessKey);
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " <- [   ".substring(0, 8 - Integer.toHexString(pResponse.getResponseMessage().getBytefield().length).length()) + Integer.toHexString(pResponse.getResponseMessage().getBytefield().length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting response message by getValueAsString().");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1200: {
                if (pServiceShortName.equals("SinglJob_SecurAcces")) {
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace("");
                    this.logger.busTrace("See MCD3_SecurAcces_*.asc for trace of SinglJob_SecurAcces.");
                    this.logger.busTrace("");
                    break;
                }
                if (pServiceShortName.equals("SinglJob_WriteFinge")) {
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace("");
                    this.logger.busTrace("See MCD3_WriteFinge_*.asc for trace of SinglJob_WriteFinge.");
                    this.logger.busTrace("");
                    break;
                }
                if (this.logger.getLogLevel() < 6) break;
                this.logger.busTrace("");
                this.logger.busTrace("No trace available for SinglJob_SecurAcces - messages might be missing.");
                this.logger.busTrace("");
                break;
            }
            case 1192: 
            case 1197: {
                break;
            }
        }
        try {
            responseState = pResponse.getState();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining response state.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (responseState) {
            case 26625: {
                currentJobStatus = this.handlePositiveResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 26626: {
                currentJobStatus = this.handleNegativeResponse(pRequestParameters, pResponse);
                break;
            }
            default: {
                this.logger.error("Invalid MCDResponseState: " + responseState);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handleResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveResponse(...).");
        this.logger.debug("Response is positive.");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                currentJobStatus = this.handlePositiveServiceResponse(pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 1192: 
            case 1197: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
            case 1200: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
        }
        this.logger.trace("Leaving handlePositiveResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveJobResponse(String pJobShortName, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveJobResponse(...).");
        if (pJobShortName.equals("SinglJob_SecurAcces")) {
            currentJobStatus = this.handlePositiveResponseSecurityAccess(pResponse);
        } else if (pJobShortName.equals("SinglJob_WriteFinge")) {
            currentJobStatus = this.handlePositiveResponseWriteFingerprint(pResponse);
        } else if (pJobShortName.equals("SinglJob_FlashJobUDS")) {
            currentJobStatus = this.handlePositiveResponseFlashJobUDS(pResponse);
        } else if (pJobShortName.equals("SinglJob_DataSet")) {
            currentJobStatus = this.handlePositiveResponseDataSet(pResponse);
        } else if (pJobShortName.equals("SinglJob_PostDataSet")) {
            currentJobStatus = this.handlePositiveResponsePostDataSet(pResponse);
        } else if (pJobShortName.equals("SinglJob_StartCommu")) {
            currentJobStatus = this.handlePositiveResponseStartCommunication(pResponse);
        } else {
            this.logger.debug("*** UNKNOWN job ***: " + pJobShortName);
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving handlePositiveJobResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveServiceResponse(String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        byte responseServiceIdentifier = 0;
        byte requestServiceIdentifier = 0;
        this.logger.trace("Entering handlePositiveServiceResponse(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
            responseMessageString = pResponse.getResponseMessage().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length < 1) {
            this.logger.error("Error getting response service id from response with length of " + responseMessage.length + " bytes.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        responseServiceIdentifier = responseMessage[0];
        if ((responseServiceIdentifier & 0x40 & 0xFF) == 0) {
            this.logger.error("The extracted response service id (0x" + Integer.toHexString(responseServiceIdentifier & 0xFF).toUpperCase() + ") is not a positive response service identifier!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        requestServiceIdentifier = (byte)(responseServiceIdentifier - 64);
        try {
            numberOfResponseParameters = pResponse.getResponseParameters().getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.warn("Ignoring response since it is not covered by a database response: " + responseMessageString);
        } else {
            switch (requestServiceIdentifier) {
                case 16: {
                    currentJobStatus = this.handlePositiveResponseDiagnosticSessionControl(pRequestParameters, pResponse);
                    break;
                }
                case 17: {
                    currentJobStatus = this.handlePositiveResponseEcuReset(pRequestParameters, pResponse);
                    break;
                }
                case 34: {
                    currentJobStatus = this.handlePositiveResponseReadDataByIdentifierEcuIdentification(pRequestParameters, pResponse);
                    break;
                }
                case 40: {
                    currentJobStatus = this.handlePositiveResponseCommunicationControl(pRequestParameters, pResponse);
                    break;
                }
                case 46: {
                    currentJobStatus = this.handlePositiveResponseWriteDataByIdentifier(pRequestParameters, pResponse);
                    break;
                }
                case 49: {
                    currentJobStatus = this.handlePositiveResponseRoutineControl(pRequestParameters, pResponse);
                    break;
                }
                case -123: {
                    currentJobStatus = this.handlePositiveResponseControlDTCSetting(pRequestParameters, pResponse);
                    break;
                }
                default: {
                    this.logger.debug("*** UNKNOWN service ***: " + pServiceShortName);
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                }
            }
        }
        this.logger.trace("Leaving handlePositiveServiceResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseReadDataByIdentifierEcuIdentification(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResponseParameters responseParameters = null;
        String dataIdentifierRequest = null;
        String dataIdentifierResponse = null;
        MCDResponseParameter param_dataRecord = null;
        MCDResponseParameters params_tableRow = null;
        this.logger.trace("Entering handlePositiveResponseReadDataByIdentifierEcuIdentification(...).");
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            dataIdentifierRequest = pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting data identifier of request (Param_RecorDataIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            dataIdentifierResponse = responseParameters.getItemByName("Param_RecorDataIdent").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting data identifier of response (Param_RecorDataIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!dataIdentifierResponse.equals(dataIdentifierRequest)) {
            this.logger.error("data of response does NOT match request: " + dataIdentifierRequest + " / " + dataIdentifierResponse);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            param_dataRecord = this.vendorSpecific.getTableStructParameterByTableKeyValue(responseParameters, "Param_DataRecor", dataIdentifierResponse);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting data record of response (Param_DataRecor).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            params_tableRow = param_dataRecord.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting parameters of data record.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (dataIdentifierResponse.equals("FDS_project_data")) {
            currentJobStatus = this.handleDataRecordEcuIdentificationFdsProjecData(params_tableRow);
        } else {
            this.logger.error("*** UNKNOWN dataIdentifier ***: " + dataIdentifierResponse);
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving handlePositiveResponseReadDataByIdentifierEcuIdentification(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleDataRecordEcuIdentificationFdsProjecData(MCDResponseParameters pResponseParametersDataRecord) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] tmpFdsProjectId = null;
        String keyType = null;
        this.logger.trace("Entering handleDataRecordEcuIdentificationFdsProjecData(...).");
        try {
            tmpFdsProjectId = pResponseParametersDataRecord.getItemByName("Param_FDSProjeID").getValue().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting FDS project ID (Param_FDSProjeID).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.fdsProjectIdEcu = Conversions.byteArray2Long(tmpFdsProjectId);
        this.logger.info("FDS project ID (dec): " + this.fdsProjectIdEcu);
        try {
            keyType = pResponseParametersDataRecord.getItemByName("Param_KeyType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting key type (Param_KeyType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (keyType.equals("development")) {
            this.fdsKeyTypeEcu = "E";
        } else if (keyType.equals("production")) {
            this.fdsKeyTypeEcu = "S";
        } else {
            this.logger.error("*** UNKNOWN key type ***: " + keyType);
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.info("FDS key type: " + this.fdsKeyTypeEcu);
        this.logger.trace("Leaving handleDataRecordEcuIdentificationFdsProjecData(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseDiagnosticSessionControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String diagnosticSessionTypeRequest = null;
        String diagnosticSessionTypeResponse = null;
        MCDResponseParameters responseParameters = null;
        long p2CanServer = 0L;
        long p2StarCanServer = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseDiagnosticSessionControl(...).");
        try {
            diagnosticSessionTypeRequest = pRequestParameters.getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of request (Param_DiagnSessiType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            diagnosticSessionTypeResponse = pResponse.getResponseParameters().getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of response (Param_DiagnSessiType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!diagnosticSessionTypeResponse.equals(diagnosticSessionTypeRequest)) {
            this.logger.error("diagnosticSessionType of response does NOT match request: " + diagnosticSessionTypeRequest + " / " + diagnosticSessionTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            p2CanServer = responseParameters.getItemByName("Param_StandTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_StandTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
            this.logger.warn("Leaving session timings untouched since new timings could not be extracted from response!");
            return AbstractJob.JobStatus.NO_ERROR;
        }
        this.logger.info("Current value of P2_CAN_Server is: " + p2CanServer + " ms.");
        try {
            p2StarCanServer = responseParameters.getItemByName("Param_ExtenTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_ExtenTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
            this.logger.warn("Leaving session timings untouched since new timings could not be extracted from response!");
            return AbstractJob.JobStatus.NO_ERROR;
        }
        this.logger.info("Current value of P2*_CAN_Server is: " + p2StarCanServer + " ms.");
        if (!this.isPduApiUsed && p2StarCanServer > 65500L - this.savedCanTransmissionTime) {
            this.logger.warn("Provided value of P2*_CAN_Server exceeds maximum timeout supported by Softing EIDBSS firmware (" + (65500L - this.savedCanTransmissionTime) + " ms)...");
            this.logger.warn("... limiting P2*_CAN_Server to maximum supported value.");
            p2StarCanServer = (int)(65500L - this.savedCanTransmissionTime);
            this.logger.info("Current value of P2*_CAN_Server is now: " + p2StarCanServer + " ms.");
        }
        try {
            currentJobStatus = this.updateSessionTimings(this.protocolParameterSet, p2CanServer, p2StarCanServer);
        }
        catch (MCDException mcde) {
            this.logger.error("Error updating session timings.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return currentJobStatus;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 6) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseDiagnosticSessionControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseEcuReset(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String resetTypeRequest = null;
        String resetTypeResponse = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseEcuReset(...).");
        try {
            resetTypeRequest = pRequestParameters.getItemByName("Param_ResetType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting reset type of request (Param_ResetType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            resetTypeResponse = pResponse.getResponseParameters().getItemByName("Param_ResetType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting reset type of response (Param_ResetType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!resetTypeResponse.equals(resetTypeRequest)) {
            this.logger.error("resetType of response does NOT match request: " + resetTypeRequest + " / " + resetTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseEcuReset(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseWriteDataByIdentifier(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int recordDataIdentifierDataType = -1;
        String recordDataIdentifierRequest = null;
        String recordDataIdentifierResponse = null;
        int recordDataIdentifierRequestRawValue = -1;
        int recordDataIdentifierResponseRawValue = -1;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseWriteDataByIdentifier(...).");
        try {
            recordDataIdentifierDataType = pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getDataType();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting data type of record data identifier of request (Param_RecorDataIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (recordDataIdentifierDataType) {
            case 1: 
            case 14: {
                try {
                    recordDataIdentifierRequest = pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getValueAsString();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting record data identifier of request (Param_RecorDataIdent).");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    recordDataIdentifierResponse = pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getValueAsString();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting record data identifier of response (Param_RecorDataIdent).");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (recordDataIdentifierResponse.equals(recordDataIdentifierRequest)) break;
                this.logger.error("recordDataIdentifier of response does NOT match request: " + recordDataIdentifierRequest + " / " + recordDataIdentifierResponse);
                return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
            }
            case 11: {
                try {
                    recordDataIdentifierRequestRawValue = (short)pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getUint32();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting record data identifier of request (Param_RecorDataIdent).");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    recordDataIdentifierResponseRawValue = (short)pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getUint32();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting record data identifier of response (Param_RecorDataIdent).");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (recordDataIdentifierResponseRawValue == recordDataIdentifierRequestRawValue) break;
                this.logger.error("recordDataIdentifier of response does NOT match request: 0x" + Integer.toHexString(recordDataIdentifierRequestRawValue).toUpperCase() + " / 0x" + Integer.toHexString(recordDataIdentifierResponseRawValue).toUpperCase());
                return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
            }
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 3) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseWriteDataByIdentifier(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseWriteDataByIdentifierGeneric(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        short recordDataIdentifierRequest = 0;
        short recordDataIdentifierResponse = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseWriteDataByIdentifierGeneric(...).");
        try {
            recordDataIdentifierRequest = (short)pRequestParameters.getItemByName("Param_RecorDataIdent").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting record data identifier of request (Param_RecorDataIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            recordDataIdentifierResponse = (short)pResponse.getResponseParameters().getItemByName("Param_RecorDataIdent").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting record data identifier of response (Param_RecorDataIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (recordDataIdentifierResponse != recordDataIdentifierRequest) {
            this.logger.error("recordDataIdentifier of response does NOT match request: 0x" + Integer.toHexString(recordDataIdentifierRequest).toUpperCase() + " / " + Integer.toHexString(recordDataIdentifierResponse).toUpperCase());
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 3) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseWriteDataByIdentifierGeneric(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseSecurityAccess(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusSecurityAccess = null;
        this.logger.trace("Entering handlePositiveResponseSecurityAccess(...).");
        try {
            jobCompletionStatusSecurityAccess = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status (OPA_JobComplStatu).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of security access is: " + jobCompletionStatusSecurityAccess + ".");
        currentJobStatus = jobCompletionStatusSecurityAccess.equals("Job completed successfully") || jobCompletionStatusSecurityAccess.equals("Job completed with warnings") ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.SECURITY_ACCESS_FAILED;
        this.logger.trace("Leaving handlePositiveResponseSecurityAccess(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseWriteFingerprint(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusWriteFingerprint = null;
        this.logger.trace("Entering handlePositiveResponseWriteFingerprint(...).");
        try {
            jobCompletionStatusWriteFingerprint = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status (OPA_JobComplStatu).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of writing fingerprint is: " + jobCompletionStatusWriteFingerprint + ".");
        currentJobStatus = jobCompletionStatusWriteFingerprint.equals("Job completed successfully") || jobCompletionStatusWriteFingerprint.equals("Job completed with warnings") ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.ERROR_WRITING_FINGERPRINT;
        this.logger.trace("Leaving handlePositiveResponseWriteFingerprint(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseFlashJobUDS(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusFlashJob = null;
        this.logger.trace("Entering handlePositiveResponseFlashJobUDS(...).");
        try {
            jobCompletionStatusFlashJob = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status (OPA_JobComplStatu).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of flash job is: " + jobCompletionStatusFlashJob + ".");
        currentJobStatus = jobCompletionStatusFlashJob.equals("Job completed successfully") || jobCompletionStatusFlashJob.equals("Job completed with warnings") ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.ERROR;
        this.logger.trace("Leaving handlePositiveResponseFlashJobUDS(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseDataSet(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long resultOfDataSet = 0L;
        this.logger.trace("Entering handlePositiveResponseDataSet(...).");
        try {
            resultOfDataSet = pResponse.getResponseParameters().getItemByName("OPA_Resul").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job result (OPA_Resul).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Result of Data Set is: " + resultOfDataSet + ".");
        currentJobStatus = resultOfDataSet == 0L ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.ERROR;
        this.logger.trace("Leaving handlePositiveResponseDataSet(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponsePostDataSet(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long resultOfPostDataSet = 0L;
        this.logger.trace("Entering handlePositiveResponseDataSet(...).");
        try {
            resultOfPostDataSet = pResponse.getResponseParameters().getItemByName("OPA_OutParam").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job result (OPA_OutParam).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Result of Post Data Set is: " + resultOfPostDataSet + ".");
        currentJobStatus = resultOfPostDataSet == 0L ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.ERROR;
        this.logger.trace("Leaving handlePositiveResponseDataSet(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseStartCommunication(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusStartCommunication = null;
        this.logger.trace("Entering handlePositiveResponseStartCommunication(...).");
        try {
            jobCompletionStatusStartCommunication = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status (OPA_JobComplStatu).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of (re)starting communication is: " + jobCompletionStatusStartCommunication + ".");
        currentJobStatus = jobCompletionStatusStartCommunication.equals("Job completed successfully") || jobCompletionStatusStartCommunication.equals("Job completed with warnings") ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.ERROR;
        this.logger.trace("Leaving handlePositiveResponseStartCommunication(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseCommunicationControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseCommunicationControl(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseCommunicationControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseRoutineControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String routineControlTypeRequest = null;
        String routineControlTypeResponse = null;
        String routineIdentifierRequest = null;
        MCDResponseParameters responseParameters = null;
        this.logger.trace("Entering handlePositiveResponseRoutineControl(...).");
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            routineControlTypeRequest = pRequestParameters.getItemByName("Param_RoutiContrType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine control type of request (Param_RoutiContrType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            routineControlTypeResponse = responseParameters.getItemByName("Param_RoutiContrType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine control type of response (Param_RoutiContrType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!routineControlTypeResponse.equals(routineControlTypeRequest)) {
            this.logger.error("routineControlType of response does NOT match request: " + routineControlTypeRequest + " / " + routineControlTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            routineIdentifierRequest = pRequestParameters.getItemByName("Param_RoutiIdent").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine identifier of request (Param_RoutiIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (routineControlTypeResponse.equals("Start Routine")) {
            if (!routineIdentifierRequest.equals("Erase VW memory") && !routineIdentifierRequest.equals("Calculate checksum")) {
                this.logger.error("*** UNKNOWN routineIdentifier ***: " + routineIdentifierRequest);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        } else if (routineControlTypeResponse.equals("Request Routine Results")) {
            if (routineIdentifierRequest.equals("Erase VW memory") || routineIdentifierRequest.equals("Calculate checksum")) {
                currentJobStatus = this.handleRoutineStatusRequestRoutineResultsDataSet(pResponse, responseParameters, routineIdentifierRequest);
            } else {
                this.logger.error("*** UNKNOWN routineIdentifier ***: " + routineIdentifierRequest);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        } else {
            this.logger.error("*** UNKNOWN routineControlType ***: " + routineControlTypeResponse);
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving handlePositiveResponseRoutineControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleRoutineStatusRequestRoutineResultsDataSet(MCDResponse pResponse, MCDResponseParameters pResponseParameters, String pRoutineIdentifier) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResponseParameter responseParameterRoutineStatusRecord = null;
        MCDResponseParameters responseParametersRoutineStatusRecord = null;
        MCDResponseParameter responseParameterRoutineResult = null;
        MCDValue valueRoutineResult = null;
        String routineResult = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handleRoutineStatusRequestRoutineResultsDataSet(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length >= 4 && responseMessage.length < 7) {
            this.logger.warn("Response PDU is too short! Assuming CorrectResults-EraseVWMemory/CalculateChecksum.");
            routineResult = "CorrectResults-EraseVWMemory/CalculateChecksum";
        } else {
            try {
                responseParameterRoutineStatusRecord = pResponseParameters.getItemByName("Param_RoutiStatuRecor");
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response parameter (Param_RoutiStatuRecor).");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                responseParametersRoutineStatusRecord = responseParameterRoutineStatusRecord.getParameters();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response parameters of Param_RoutiStatuRecor!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                responseParameterRoutineResult = responseParametersRoutineStatusRecord.getItemByName("Param_RoutiResul");
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response parameter (Param_RoutiResul).");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                valueRoutineResult = responseParameterRoutineResult.getValue();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting value of Param_RoutiResul!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                routineResult = valueRoutineResult.getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting routine result (Param_RoutiResul).");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Routine result is: " + routineResult);
        }
        if (!routineResult.equals("CorrectResults-EraseVWMemory/CalculateChecksum")) {
            this.logger.error("The routine could NOT be executed successfully: " + routineResult);
            if (pRoutineIdentifier.equals("Erase VW memory")) {
                currentJobStatus = AbstractJob.JobStatus.ERASE_ERROR;
            } else if (pRoutineIdentifier.equals("Calculate checksum")) {
                currentJobStatus = AbstractJob.JobStatus.CHECKSUM_ERROR;
            } else {
                this.logger.error("*** UNKNOWN routineIdentifier ***: " + pRoutineIdentifier);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        if (responseMessage.length > 7) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handleRoutineStatusRequestRoutineResultsDataSet(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseControlDTCSetting(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseControlDTCSetting(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseControlDTCSetting(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleNegativeResponse(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte requestServiceIdentifierRequest = 0;
        byte requestServiceIdentifierResponse = 0;
        String negativeResponseCode = null;
        byte nrc = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        this.logger.trace("Entering handleNegativeResponse(...).");
        this.logger.debug("Response is negative.");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length == 3) {
            long i;
            block29: {
                try {
                    for (i = 0L; i < pRequestParameters.getCount(); ++i) {
                        if (!pRequestParameters.getItemByIndex(i).getShortName().endsWith("RequeServiId")) continue;
                        requestServiceIdentifierRequest = (byte)pRequestParameters.getItemByIndex(i).getValue().getUint32();
                        break;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting request service identifier from request.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    responseParameters = pResponse.getResponseParameters();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting response parameters from response!");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                    this.logger.debug("Number of response parameters: " + numberOfResponseParameters);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (numberOfResponseParameters < 4L) {
                    requestServiceIdentifierResponse = requestServiceIdentifierRequest;
                } else {
                    try {
                        this.logger.debug("Datatype of request SID: " + McdEnumDecoder.decodeMcdDataType(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getDataType()));
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 3) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getBytefield()[0] & 0xFF);
                            break block29;
                        }
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 14 || responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 1) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseMessage().getBytefield()[1] & 0xFF);
                            break block29;
                        }
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        requestServiceIdentifierResponse = 0;
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        this.logger.logThrowable(mcde);
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                }
            }
            try {
                for (i = 0L; i < numberOfResponseParameters; ++i) {
                    if (!responseParameters.getItemByIndex(i).getShortName().equals("Param_NegatRespoCode")) continue;
                    negativeResponseCode = responseParameters.getItemByIndex(i).getValue().getValueAsString();
                    break;
                }
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code (Param_NegatRespoCode) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                nrc = pResponse.getResponseMessage().getBytefield()[2];
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code (byte 2) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("- Service ID: 0x" + Integer.toHexString(requestServiceIdentifierResponse & 0xFF).toUpperCase());
            this.logger.debug("- NRC       : 0x" + Integer.toHexString(nrc).toUpperCase() + " (" + negativeResponseCode + ")");
            if (requestServiceIdentifierResponse != requestServiceIdentifierRequest) {
                this.logger.error("Request service identifier of response does NOT match request: 0x" + Integer.toHexString(requestServiceIdentifierRequest) + " / " + Integer.toHexString(requestServiceIdentifierResponse));
            }
        } else {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (responseMessage.length < 3) {
                this.logger.debug("Negative response has invalid length of " + responseMessage.length + " bytes: " + responseMessageString);
            } else if (responseMessage.length > 3) {
                this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
            }
        }
        currentJobStatus = AbstractJob.JobStatus.NEGATIVE_RESPONSE;
        this.logger.trace("Leaving handleNegativeResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleErrors(MCDErrors pErrors) {
        long numberOfErrors = 0L;
        MCDError error = null;
        this.logger.trace("Entering handleErrors(...).");
        try {
            numberOfErrors = pErrors.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of errors.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("diagComPrimitive has " + numberOfErrors + " errors.");
        if (numberOfErrors == 0L) {
            this.logger.debug("Collection of errors is empty - NO errors occured.");
        } else {
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = pErrors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + ".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving handleErrors(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected String getProtocolParameterString(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) throws MCDException {
        MCDValue mcdValue = null;
        String value = null;
        this.logger.trace("Entering getProtocolParameterString(...).");
        try {
            mcdValue = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCDValue of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            value = mcdValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UNICODE2STRING value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.trace("Leaving getProtocolParameterString(...).");
        return value;
    }

    protected long getProtocolParameterUint32(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) throws MCDException {
        MCDValue mcdValue = null;
        long value = -1L;
        this.logger.trace("Entering getProtocolParameterUint32(...).");
        try {
            mcdValue = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCDValue of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            value = mcdValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UINT32 value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.trace("Leaving getProtocolParameterUint32(...).");
        return value;
    }

    protected MCDValue getProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) throws MCDException {
        MCDValue comParamValue = null;
        MCDRequestParameter comParam = null;
        this.logger.trace("Entering getProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error fetching protocol parameter with SHORT-NAME \"" + pComParamName + "\" from interface.");
            throw mcde;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCDValue of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.trace("Leaving getProtocolParameterValue(...).");
        return comParamValue;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, String pValue) throws MCDException {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        String currentValue = null;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter with SHORT-NAME \"" + pComParamName + "\" from interface!");
            this.logger.logThrowable(mcde);
            throw mcde;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            throw mcde;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            currentValue = comParamValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setValueAsString(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            throw mcde;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        if (this.logger.getLogLevel() >= 5) {
            try {
                pProtocolParameterSet.fetchValueFromInterface(pComParamName);
            }
            catch (MCDException mcde) {
                this.logger.error("Error fetching new protocol parameter value of \"" + pComParamName + "\" from interface!");
                throw mcde;
            }
            try {
                this.logger.debug("New value of \"" + pComParamName + "\" is " + this.protocolParameters.getItemByName(pComParamName).getValue().getValueAsString());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting new value of \"" + pComParamName + "\".");
                throw mcde;
            }
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, long pValue) throws MCDException {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        long currentValue = -1L;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            throw mcde;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            currentValue = comParamValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setUint32(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            throw mcde;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected AbstractJob.JobStatus checkRequiredDiagComms(String[] pRequiredDiagComms) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        MCDDbDataPrimitives dbDataPrimitives = null;
        long dbDataPrimitiveCount = 0L;
        MCDDbDataPrimitive dbDataPrimitive = null;
        String dbDataPrimitiveShortName = null;
        boolean isDiagCommAvailable = false;
        try {
            dbDataPrimitives = this.dbLocationOfLogicalLink.getDbDataPrimitives();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            dbDataPrimitiveCount = dbDataPrimitives.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (int i = 0; i < pRequiredDiagComms.length; ++i) {
            this.logMessage = "Checking availability of DIAG-COMM \"" + pRequiredDiagComms[i] + "\"... ";
            isDiagCommAvailable = false;
            for (long j = 0L; j < dbDataPrimitiveCount; ++j) {
                try {
                    dbDataPrimitive = dbDataPrimitives.getItemByIndex(j);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    dbDataPrimitiveShortName = dbDataPrimitive.getShortName();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting SHORT-NAME of data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (!dbDataPrimitiveShortName.equals(pRequiredDiagComms[i])) continue;
                isDiagCommAvailable = true;
                this.logMessage = this.logMessage + "OK.";
                this.logger.debug(this.logMessage);
            }
            if (isDiagCommAvailable) continue;
            this.logMessage = this.logMessage + "*** MISSING ***.";
            this.logger.fatal(this.logMessage);
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        return currentJobStatus;
    }

    private MCDValue getParameterValue(MCDParameter pParameter) throws MCDException, NullPointerException {
        String shortName = null;
        MCDValue value = null;
        this.logger.trace("Entering getParameterValue(...).");
        if (this.logger.getLogLevel() >= 5) {
            try {
                shortName = pParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting SHORT-NAME of parameter.");
                this.logger.logThrowable(mcde);
            }
            this.logger.debug("Getting value of parameter: " + shortName);
        }
        try {
            value = pParameter.getValue();
        }
        catch (MCDException mcde) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.error("Error getting value of parameter \"" + shortName + "\".");
            } else {
                this.logger.error("Error getting value of parameter.");
            }
            throw mcde;
        }
        if (value == null) {
            this.logger.error("MCDParameter.getValue() returned null!");
            throw new NullPointerException("MCDParameter.getValue() returned null!");
        }
        this.logger.trace("Leaving getParameterValue(...).");
        return value;
    }

    protected long getParameterValueUint32(MCDParameter pParameter) throws MCDException, NullPointerException {
        MCDValue mcdValue = null;
        long value = 0L;
        this.logger.trace("Entering getParameterValueUint32(...).");
        mcdValue = this.getParameterValue(pParameter);
        try {
            value = mcdValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting A_UINT32 value from MCDValue.");
            throw mcde;
        }
        this.logger.trace("Leaving getParameterValueUint32(...).");
        return value;
    }

    protected int getParameterValueUint32AsInteger(MCDParameter pParameter) throws IllegalArgumentException, MCDException, NullPointerException {
        long longValue = 0L;
        int value = 0;
        this.logger.trace("Entering getParameterValueUint32AsInteger(...).");
        longValue = this.getParameterValueUint32(pParameter);
        if (longValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The value " + longValue + " exceeds the maximum 'int' value of " + Integer.MAX_VALUE + "!");
        }
        value = (int)longValue;
        this.logger.trace("Leaving getParameterValueUint32AsInteger(...).");
        return value;
    }

    protected short getParameterValueUint32AsShort(MCDParameter pParameter) throws IllegalArgumentException, MCDException, NullPointerException {
        long longValue = 0L;
        short value = 0;
        this.logger.trace("Entering getParameterValueUint32AsShort(...).");
        longValue = this.getParameterValueUint32(pParameter);
        if (longValue > 32767L) {
            throw new IllegalArgumentException("The value " + longValue + " exceeds the maximum 'short' value of " + Short.MAX_VALUE + "!");
        }
        value = (short)longValue;
        this.logger.trace("Leaving getParameterValueUint32AsShort(...).");
        return value;
    }

    protected byte getParameterValueUint32AsByte(MCDParameter pParameter) throws IllegalArgumentException, MCDException, NullPointerException {
        long longValue = 0L;
        byte value = 0;
        this.logger.trace("Entering getParameterValueUint32AsByte(...).");
        longValue = this.getParameterValueUint32(pParameter);
        if (longValue > 127L) {
            throw new IllegalArgumentException("The value " + longValue + " exceeds the maximum 'byte' value of " + 127 + "!");
        }
        value = (byte)longValue;
        this.logger.trace("Leaving getParameterValueUint32AsByte(...).");
        return value;
    }

    protected String getParameterValueAsString(MCDParameter pParameter) throws MCDException, NullPointerException {
        MCDValue mcdValue = null;
        String value = null;
        this.logger.trace("Entering getParameterValueAsString(...).");
        mcdValue = this.getParameterValue(pParameter);
        try {
            value = mcdValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting A_UNICODE2STRING value from MCDValue.");
            throw mcde;
        }
        if (value == null) {
            this.logger.error("MCDValue.getValueAsString() returned null!");
            throw new NullPointerException("MCDValue.getValueAsString() returned null!");
        }
        this.logger.trace("Leaving getParameterValueAsString(...).");
        return value;
    }

    protected AbstractJob.JobStatus readXmlMsg(String pFileName) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        XmlMsgParserImpl xmlMsgParser = null;
        boolean xmlReadSuccessfully = false;
        XmlMsg xmlMsg = null;
        Vector targetEcus = null;
        this.logger.trace("Entering readXmlMsg(...).");
        xmlMsgParser = new XmlMsgParserImpl(this.logger, (VendorSpecificMCD20002)((Object)this.vendorSpecific), this.dbLocationOfLogicalLink, this.expectedDiagnosticAddress);
        try {
            xmlReadSuccessfully = xmlMsgParser.readXML(pFileName);
        }
        catch (Exception e) {
            this.logger.error("Error reading XMLMSG.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!xmlReadSuccessfully) {
            this.logger.error("Error reading XMLMSG.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        xmlMsg = xmlMsgParser.getXmlMsg();
        if (this.expectedDiagnosticAddress == 0) {
            this.logger.warn("No DIAGNOSTIC_ADDRESS provided! Getting PARAMETER_DATA for any DIAGNOSTIC_ADDRESS...");
            targetEcus = xmlMsg.getTargetEcus();
            if (targetEcus.size() == 0) {
                this.logger.error("ERROR: No valid data set was found for any diagnostic address!");
                currentJobStatus = AbstractJob.JobStatus.ERROR_DATABASE_NO_DATA;
            } else if (targetEcus.size() == 1) {
                this.targetEcu = (TargetEcu)targetEcus.get(0);
                this.logger.info("Found data sets for exactly one diagnostic address: 0x" + Integer.toHexString(this.targetEcu.getDiagnosticAddress()).toUpperCase());
            } else if (targetEcus.size() > 1) {
                Iterator targetEcuIterator = xmlMsg.getTargetEcus().iterator();
                TreeSet<Short> diagnosticAddresses = new TreeSet<Short>();
                StringBuffer diagnosticAddressesAsString = new StringBuffer();
                while (targetEcuIterator.hasNext()) {
                    TargetEcu currentTargetEcu = (TargetEcu)targetEcuIterator.next();
                    Short currentDiagnosticAddress = new Short(currentTargetEcu.getDiagnosticAddress());
                    if (diagnosticAddresses.contains(currentDiagnosticAddress)) continue;
                    if (!diagnosticAddresses.isEmpty()) {
                        diagnosticAddressesAsString.append(", ");
                    }
                    diagnosticAddressesAsString.append("0x" + Integer.toHexString(currentDiagnosticAddress.intValue()));
                    diagnosticAddresses.add(currentDiagnosticAddress);
                }
                if (diagnosticAddresses.size() > 1) {
                    this.logger.error("ERROR: " + this.xmlMsgFileName + " contains PARAMETER_DATA for multiple diagnostic addresses (" + diagnosticAddressesAsString + ") while no target diagnostic address has been provided!");
                    this.logger.error("Make sure the interface of SinglJob_PreDataSet (probably overridden in BASE-VARIANT or ECU-VARIANT) is matching the current interface in PR_UDSOnCAN, i.e.");
                    this.logger.error("- the INPUT-PARAM \"IPA_DiagnAddre\" is present");
                    this.logger.error("- the PHYSICAL-DEFAULT-VALUE of Param_SoftTypeVaria in STRUC_DataRecorVWEOLConfi is set to \"----\"");
                    currentJobStatus = AbstractJob.JobStatus.ERROR_DATABASE_AMBIGUOUS_DIAGNOSTIC_ADDRESS;
                }
            }
        } else {
            this.targetEcu = xmlMsg.getTargetEcuByDiagnosticAddress(this.expectedDiagnosticAddress);
            if (this.targetEcu == null) {
                this.logger.error("ERROR: No valid data set was found for the provided diagnostic address \"0x" + Integer.toHexString(this.expectedDiagnosticAddress) + "\"!");
                this.logger.error("Make sure the interface of SinglJob_PreDataSet (probably overridden in BASE-VARIANT or ECU-VARIANT) is matching the current interface in PR_UDSOnCAN, i.e.");
                this.logger.error("- the INPUT-PARAM \"IPA_DiagnAddre\" is present");
                this.logger.error("- the PHYSICAL-DEFAULT-VALUE of Param_SoftTypeVaria in STRUC_DataRecorVWEOLConfi is set to \"----\"");
                currentJobStatus = AbstractJob.JobStatus.ERROR_DATABASE_NO_DATA;
            }
        }
        if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.vehicleEquipmentCodeAndPrNumberCombination = this.targetEcu.getPrIdx();
            this.vwDataSetNumberOrEcuDataContainerNumber = this.targetEcu.getZdcName();
            this.vwDataSetVersionNumber = this.targetEcu.getZdcVersion();
            if (this.targetEcu.getLogin() == 0L) {
                this.logger.info("\"LOGIN is NOT present been in XMLMSG... using value from input parameter \"IPA_Login\".");
            } else {
                this.login = this.targetEcu.getLogin();
            }
            this.dataSetDownloadType = this.targetEcu.getDataSetDownloadType();
            this.applicationDataSets = this.targetEcu.getApplicationDataSets();
            if (this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_2) {
                this.bootloaderDataSets = this.targetEcu.getBootloaderDataSets();
            }
            if (this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_2 && this.applicationDataSets.size() == 0 && this.bootloaderDataSets.size() == 0 || this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_1 && this.applicationDataSets.size() == 0) {
                this.logger.error("ERROR: No valid data set was found for the provided diagnostic address \"0x" + Integer.toHexString(this.expectedDiagnosticAddress).toUpperCase() + "\"!");
                this.logger.error("Make sure the interface of SinglJob_PreDataSet (probably overridden in BASE-VARIANT or ECU-VARIANT) is matching the current interface in PR_UDSOnCAN, i.e.");
                this.logger.error("- the INPUT-PARAM \"IPA_DiagnAddre\" is present");
                this.logger.error("- the PHYSICAL-DEFAULT-VALUE of Param_SoftTypeVaria in STRUC_DataRecorVWEOLConfi is set to \"----\"");
                currentJobStatus = AbstractJob.JobStatus.ERROR_DATABASE_NO_DATA;
            }
        }
        if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            int i;
            for (i = 0; i < this.applicationDataSets.size(); ++i) {
                this.totalNumberOfBytesToTransfer += ((ParameterDataApplication)this.applicationDataSets.get(i)).getDataSize();
            }
            if (this.dataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_2) {
                for (i = 0; i < this.bootloaderDataSets.size(); ++i) {
                    this.totalNumberOfBytesToTransfer += ((ParameterDataBootloader)this.bootloaderDataSets.get(i)).getDataSize();
                }
            }
            this.logger.debug("Total number of bytes to transfer: " + this.totalNumberOfBytesToTransfer);
            this.setJobInfo("Total number of bytes to transfer: " + this.totalNumberOfBytesToTransfer);
        }
        this.logger.trace("Leaving readXmlMsg(...).");
        return currentJobStatus;
    }

    protected short determineLengthOfPrIndex() throws Exception {
        short length = -1;
        this.logger.debug("Trying to determine length of 'Vehicle Equipment Code And PR Number Combination'...");
        try {
            length = this.determineLengthOfPrIndexFromOdxRequestParameter();
        }
        catch (Exception e) {
            this.logger.debug("Caught exception while determining length of 'Vehicle Equipment Code And PR Number Combination' from ODX!");
            this.logger.logThrowable(e);
        }
        if (length < 1) {
            try {
                length = this.determineLengthOfPrIndexFromEcuResponse();
            }
            catch (Exception e) {
                length = -1;
                this.logger.debug("Caught exception while determining length of 'Vehicle Equipment Code And PR Number Combination' via 'DiagnServi_ReadDataByIdentECUIdent'!");
                this.logger.logThrowable(e);
            }
        }
        if (length < 1) {
            try {
                length = this.determineLengthOfPrIndexFromEcuResponseGeneric();
            }
            catch (Exception e) {
                length = -1;
                this.logger.debug("Caught exception while determining length of 'Vehicle Equipment Code And PR Number Combination' via 'DiagnServi_ReadDataByIdentGenerServi'!");
                this.logger.logThrowable(e);
            }
        }
        if (length < 1) {
            throw new Exception("The length of 'Vehicle Equipment Code And PR Number Combination' could not be determined!");
        }
        return length;
    }

    protected short determineLengthOfPrIndexFromOdxRequestParameter() throws MCDException {
        short length = 0;
        MCDService writeDataByIdentEcuIdent = null;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        MCDRequestParameter recordDataIdentifier = null;
        MCDRequestParameter dataRecord = null;
        MCDValue mcdValue = null;
        MCDRequestParameters tableRows = null;
        MCDRequestParameter tableStruct = null;
        MCDRequestParameters tableStructParameters = null;
        MCDRequestParameter param_vehicleEquipmentCodeAndPrNumberCombination = null;
        this.logger.debug("Trying to determine length of 'Vehicle Equipment Code And PR Number Combination' from ODX...");
        writeDataByIdentEcuIdent = (MCDService)this.logicalLink.createDiagComPrimitiveByName("DiagnServi_WriteDataByIdentECUIdent");
        request = writeDataByIdentEcuIdent.getRequest();
        requestParameters = request.getRequestParameters();
        recordDataIdentifier = requestParameters.getItemByName("Param_RecorDataIdent");
        mcdValue = recordDataIdentifier.createValue();
        mcdValue.setValueAsString("Vehicle Equipment Code And PR Number Combination");
        recordDataIdentifier.setValue(mcdValue);
        dataRecord = requestParameters.getItemByName("Param_DataRecor");
        if (dataRecord.getType() == 17) {
            tableRows = dataRecord.getParameters();
            tableStruct = tableRows.getItemByName(Conversions.longName2ShortName("TABROW_", "Vehicle Equipment Code And PR Number Combination"));
        } else {
            tableStruct = dataRecord;
        }
        tableStructParameters = tableStruct.getParameters();
        param_vehicleEquipmentCodeAndPrNumberCombination = tableStructParameters.getItemByName(Conversions.longName2ShortName("Param_", "Vehicle Equipment Code And PR Number Combination"));
        mcdValue = param_vehicleEquipmentCodeAndPrNumberCombination.createValue();
        length = (short)mcdValue.getLength();
        this.logicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentEcuIdent);
        this.logger.debug("Length of 'Vehicle Equipment Code And PR Number Combination' from ODX: " + length);
        return length;
    }

    protected short determineLengthOfPrIndexFromEcuResponse() throws MCDException {
        short length = -1;
        MCDService readDataByIdentEcuIdent = null;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        MCDRequestParameter recordDataIdentifier = null;
        MCDValue mcdValue = null;
        MCDResult result = null;
        int resultType = -1;
        MCDResponses responses = null;
        long numberOfResponses = -1L;
        MCDResponse response = null;
        String responseMessage = null;
        int responseState = -1;
        MCDResponseParameters responseParameters = null;
        MCDResponseParameter dataRecord = null;
        MCDResponseParameters tableStructParameters = null;
        MCDResponseParameter param_vehicleEquipmentCodeAndPrNumberCombination = null;
        this.logger.debug("Trying to determine length of 'Vehicle Equipment Code And PR Number Combination' via 'DiagnServi_ReadDataByIdentECUIdent'...");
        readDataByIdentEcuIdent = (MCDService)this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentECUIdent");
        request = readDataByIdentEcuIdent.getRequest();
        requestParameters = request.getRequestParameters();
        recordDataIdentifier = requestParameters.getItemByName("Param_RecorDataIdent");
        mcdValue = recordDataIdentifier.createValue();
        mcdValue.setValueAsString("Vehicle Equipment Code And PR Number Combination");
        recordDataIdentifier.setValue(mcdValue);
        result = readDataByIdentEcuIdent.executeSync();
        if (result.hasError()) {
            this.logger.debug("Result has error... trying to evaluate response anyway.");
        }
        resultType = result.getType();
        switch (resultType) {
            case 1794: 
            case 1795: {
                responses = result.getResponses();
                break;
            }
            default: {
                this.logger.debug("ResultType of result is not (REQUEST_AND_)RESPONSE!");
                return -1;
            }
        }
        numberOfResponses = responses.getCount();
        if (numberOfResponses != 1L) {
            this.logger.debug("Number of responses != 1");
            return -1;
        }
        response = responses.getItemByIndex(0L);
        if (response.hasError()) {
            this.logger.debug("Response has error... trying to evaluate response parameter anyway.");
        }
        responseMessage = this.vendorSpecific.pduValue2String(response.getResponseMessage());
        responseState = response.getState();
        if (responseState == 26626) {
            this.logger.debug("Error: Response is negative ( " + responseMessage + " )... unable to extract length.");
            return -1;
        }
        this.logger.debug("Response is positive: " + responseMessage);
        responseParameters = response.getResponseParameters();
        dataRecord = responseParameters.getItemByName("Param_DataRecor");
        tableStructParameters = dataRecord.getParameters();
        param_vehicleEquipmentCodeAndPrNumberCombination = tableStructParameters.getItemByName(Conversions.longName2ShortName("Param_", "Vehicle Equipment Code And PR Number Combination"));
        if (param_vehicleEquipmentCodeAndPrNumberCombination.hasError()) {
            this.logger.debug("Response parameter has error... trying to evaluate value anyway.");
        }
        mcdValue = param_vehicleEquipmentCodeAndPrNumberCombination.getValue();
        length = (short)mcdValue.getLength();
        this.logicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)readDataByIdentEcuIdent);
        this.logger.debug("Length of 'Vehicle Equipment Code And PR Number Combination' from response of 'DiagnServi_ReadDataByIdentECUIdent': " + length);
        return length;
    }

    protected short determineLengthOfPrIndexFromEcuResponseGeneric() throws MCDException {
        short length = 0;
        MCDService readDataByIdentGenerServi = null;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        MCDRequestParameter recordDataIdentifier = null;
        MCDValue mcdValue = null;
        MCDResult result = null;
        int resultType = -1;
        MCDResponses responses = null;
        long numberOfResponses = -1L;
        MCDResponse response = null;
        String responseMessage = null;
        int responseState = -1;
        MCDResponseParameters responseParameters = null;
        MCDResponseParameter dataRecord = null;
        this.logger.debug("Trying to determine length of 'Vehicle Equipment Code And PR Number Combination' via 'DiagnServi_ReadDataByIdentGenerServi'...");
        readDataByIdentGenerServi = (MCDService)this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentGenerServi");
        request = readDataByIdentGenerServi.getRequest();
        requestParameters = request.getRequestParameters();
        recordDataIdentifier = requestParameters.getItemByName("Param_RecorDataIdent");
        mcdValue = recordDataIdentifier.createValue();
        mcdValue.setUint32(61860L);
        recordDataIdentifier.setValue(mcdValue);
        result = readDataByIdentGenerServi.executeSync();
        if (result.hasError()) {
            this.logger.debug("Result has error... trying to evaluate response anyway.");
        }
        resultType = result.getType();
        switch (resultType) {
            case 1794: 
            case 1795: {
                responses = result.getResponses();
                break;
            }
            default: {
                this.logger.debug("Error: Result has no response.");
                return -1;
            }
        }
        numberOfResponses = responses.getCount();
        if (numberOfResponses != 1L) {
            this.logger.debug("Error: Result has " + numberOfResponses + " responses.");
            return -1;
        }
        response = responses.getItemByIndex(0L);
        responseState = response.getState();
        if (response.hasError()) {
            this.logger.debug("Response has error... trying to evaluate response parameter anyway.");
        }
        responseMessage = this.vendorSpecific.pduValue2String(response.getResponseMessage());
        if (responseState == 26626) {
            this.logger.debug("Error: Response is negative ( " + responseMessage + " )... unable to extract length.");
            return -1;
        }
        this.logger.debug("Response is positive: " + responseMessage);
        responseParameters = response.getResponseParameters();
        dataRecord = responseParameters.getItemByName("Param_DataRecor");
        if (dataRecord.hasError()) {
            this.logger.debug("Response parameter has error... trying to evaluate value anyway.");
        }
        mcdValue = dataRecord.getValue();
        length = (short)mcdValue.getLength();
        this.logicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)readDataByIdentGenerServi);
        this.logger.debug("Length of 'Vehicle Equipment Code And PR Number Combination' from response of 'DiagnServi_ReadDataByIdentGenerServi': " + length);
        return length;
    }

    protected MCDService writeDataByIdentifier(MCDLogicalLink pLogicalLink, String pDataIdentifier) throws MCDException {
        MCDService writeDataByIdentifier = null;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        MCDRequestParameter param_recordDataIdentifer = null;
        MCDValue value_recordDataIdentifier = null;
        MCDRequestParameter param_dataRecord = null;
        MCDRequestParameters params_dataRecord = null;
        this.logger.trace("Entering writeDataByIdentifier(...).");
        writeDataByIdentifier = this.createService(pLogicalLink, "DiagnServi_WriteDataByIdentECUIdent");
        if (writeDataByIdentifier == null) {
            return writeDataByIdentifier;
        }
        try {
            request = writeDataByIdentifier.getRequest();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting request of service \"DiagnServi_WriteDataByIdentECUIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            requestParameters = request.getRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting request parameters of service \"DiagnServi_WriteDataByIdentECUIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            param_recordDataIdentifer = requestParameters.getItemByName("Param_RecorDataIdent");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting parameter with SHORT-NAME \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            value_recordDataIdentifier = param_recordDataIdentifer.createValue();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error creating parameter value for \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            value_recordDataIdentifier.setValueAsString(pDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value to parameter \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            param_recordDataIdentifer.setValue(value_recordDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameter value of \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            param_dataRecord = this.vendorSpecific.getTableStructParameterByTableKeyValue(requestParameters, "Param_DataRecor", pDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting parameter with SHORT-NAME \"Param_DataRecor\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            params_dataRecord = param_dataRecord.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting parameters of \"Param_DataRecor\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            this.setDataRecordParameters(pDataIdentifier, params_dataRecord);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameters of \"Param_DataRecor\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifier);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        this.logger.trace("Leaving writeDataByIdentifier(...).");
        return writeDataByIdentifier;
    }

    protected MCDService writeDataByIdentifier(MCDLogicalLink pLogicalLink, int pDataIdentifier, byte[] pDataRecord) throws MCDException {
        MCDService writeDataByIdentifier = null;
        this.logger.trace("Entering writeDataByIdentifier(...).");
        writeDataByIdentifier = this.createService(pLogicalLink, "DiagnServi_WriteDataByIdentGenerServi");
        if (writeDataByIdentifier == null) {
            writeDataByIdentifier = this.createService(pLogicalLink, "DiagnServi_WriteDataByIdent");
        }
        if (writeDataByIdentifier == null) {
            return writeDataByIdentifier;
        }
        this.logger.debug("Setting DID: 0x" + Integer.toHexString(pDataIdentifier).toUpperCase());
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeDataByIdentifier, "Param_RecorDataIdent", (long)pDataIdentifier);
        this.setRequestParameterBytefield((MCDDiagComPrimitive)writeDataByIdentifier, "Param_DataRecor", pDataRecord);
        this.logger.trace("Leaving writeDataByIdentifier(...).");
        return writeDataByIdentifier;
    }

    protected void setDataRecordParameters(String pRecordDataIdentifier, MCDRequestParameters pDataRecordParameters) throws MCDException {
        this.logger.trace("Entering setDataRecordParameters(...).");
        if (pRecordDataIdentifier.equals("Vehicle Equipment Code And PR Number Combination")) {
            this.setRequestParameterBytefield(pDataRecordParameters, "Param_VehicEquipCodeAndPRNumbeCombi", this.vehicleEquipmentCodeAndPrNumberCombination);
        } else if (pRecordDataIdentifier.equals("VW Data Set Number Or ECU Data Container Number")) {
            this.setRequestParameterString(pDataRecordParameters, "Param_VWDataSetNumbeOrECUDataContaNumbe", this.vwDataSetNumberOrEcuDataContainerNumber);
        } else if (pRecordDataIdentifier.equals("VW Data Set Version Number")) {
            this.setRequestParameterString(pDataRecordParameters, "Param_VWDataSetVersiNumbe", this.vwDataSetVersionNumber);
        } else if (pRecordDataIdentifier.equals("VW EOL Configuration")) {
            this.setRequestParameterString(pDataRecordParameters, "Param_HardwAssemGroup", this.hardwareAssemblyGroup);
            this.setRequestParameterString(pDataRecordParameters, "Param_HardwTypeCode", this.hardwareTypeCode);
            this.setRequestParameterString(pDataRecordParameters, "Param_SoftwAssemGroup", this.softwareAssemblyGroup);
            this.setRequestParameterString(pDataRecordParameters, "Param_SoftwTypeCode", this.softwareTypeCode);
            this.setRequestParameterString(pDataRecordParameters, "Param_SoftwTypeVaria", this.softwareTypeVariant);
        } else {
            throw new IllegalArgumentException("Unexpected recordDataIdentifier: " + pRecordDataIdentifier);
        }
        this.logger.trace("Leaving setDataRecordParameters(...).");
    }

    protected void setVwEolConfiguration(MCDRequestParameters pVwEolConfigurationParameters, String pHardwareAssemblyGroup, String pHardwareTypeCode, String pSoftwareAssemblyGroup, String pSoftwareTypeCode, String pSoftwareTypeVariant) throws MCDException {
        this.logger.trace("Entering setVwEolConfiguration(...).");
        this.logger.trace("Leaving setVwEolConfiguration(...).");
    }

    protected int determineFlashJobLogLevel() {
        int logLevel = 0;
        logLevel = this.logger.getLogLevel();
        if (this.bootloaderDataSets.size() > 0) {
            if (this.currentBootloaderDataSet > 0) {
                logLevel |= 0x20;
            }
            if (this.currentBootloaderDataSet < this.bootloaderDataSets.size() - 1) {
                logLevel |= 0x10;
            }
        }
        return logLevel;
    }

    private Set getAvailableRoutines(String pServiceShortName) throws MCDException {
        TreeSet<String> availableRoutinesTmp = null;
        MCDDbDiagService dbDiagService = null;
        MCDTextTableElements texttableElements = null;
        MCDTextTableElement currentTexttableElement = null;
        String currentLongName = null;
        availableRoutinesTmp = new TreeSet<String>();
        try {
            dbDiagService = this.dbLocationOfLogicalLink.getDbDiagServices().getItemByName(pServiceShortName);
            texttableElements = dbDiagService.getDbRequest().getDbRequestParameters().getItemByName("Param_RoutiIdent").getTextTableElements();
        }
        catch (MCDException mcde) {
            this.logger.debug("The DbDiagService \"" + pServiceShortName + "\" is not available.");
            return availableRoutinesTmp;
        }
        for (long i = 0L; i < texttableElements.getCount(); ++i) {
            currentTexttableElement = texttableElements.getItemByIndex(i);
            try {
                currentTexttableElement.getInterval();
                currentLongName = currentTexttableElement.getLongName();
                availableRoutinesTmp.add(currentLongName);
                continue;
            }
            catch (MCDException mcde) {
                // empty catch block
            }
        }
        return availableRoutinesTmp;
    }

    static {
        instances = new Vector();
    }

    public static final class JobStep
    implements Comparable {
        public static final JobStep READ_XMLMSG = new JobStep("READ_XMLMSG");
        public static final JobStep PREPARE_SUB_JOBS = new JobStep("PREPARE_SUB_JOBS");
        public static final JobStep READ_FDS_PROJECT_ID = new JobStep("READ_FDS_PROJECT_ID");
        public static final JobStep READ_EXTERNAL_SIGNATURES = new JobStep("READ_EXTERNAL_SIGNATURES");
        public static final JobStep DETERMINE_LENGTH_OF_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION = new JobStep("DETERMINE_LENGTH_OF_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION");
        public static final JobStep PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY = new JobStep("PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY");
        public static final JobStep PREPROGRAMMING_SWITCH_TO_END_OF_LINE_SESSION_PHYSICALLY = new JobStep("PREPROGRAMMING_SWITCH_TO_END_OF_LINE_SESSION_PHYSICALLY");
        public static final JobStep PREPROGRAMMING_CONTROL_DTC_SETTING_OFF = new JobStep("PREPROGRAMMING_CONTROL_DTC_SETTING_OFF");
        public static final JobStep PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX = new JobStep("PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX");
        public static final JobStep SECURITY_ACCESS = new JobStep("SECURITY_ACCESS");
        public static final JobStep WRITE_FINGERPRINT = new JobStep("WRITE_FINGERPRINT");
        public static final JobStep WRITE_VW_DATA_SET_NUMBER_OR_ECU_DATA_CONTAINER_NUMBER = new JobStep("WRITE_VW_DATA_SET_NUMBER_OR_ECU_DATA_CONTAINER_NUMBER");
        public static final JobStep WRITE_VW_DATA_SET_VERSION_NUMBER = new JobStep("WRITE_VW_DATA_SET_VERSION_NUMBER");
        public static final JobStep START_ROUTINE_ERASE_VW_MEMORY = new JobStep("START_ROUTINE_ERASE_VW_MEMORY");
        public static final JobStep REQUEST_ROUTINE_RESULTS_ERASE_VW_MEMORY = new JobStep("REQUEST_ROUTINE_RESULTS_ERASE_VW_MEMORY");
        public static final JobStep WRITE_APPLICATION_DATA_SETS = new JobStep("WRITE_APPLICATION_DATA_SETS");
        public static final JobStep WRITE_BOOTLOADER_DATA_SETS = new JobStep("WRITE_BOOTLOADER_DATA_SETS");
        public static final JobStep POST_DATA_SET = new JobStep("POST_DATA_SET");
        public static final JobStep ECU_RESET = new JobStep("ECU_RESET");
        public static final JobStep SLEEP_ECU_SOFTWARE_RESET_DURATION = new JobStep("SLEEP_ECU_SOFTWARE_RESET_DURATION");
        public static final JobStep POSTPROGRAMMING_START_COMMUNICATION = new JobStep("POSTPROGRAMMING_START_COMMUNICATION");
        public static final JobStep RESTORE_PROTOCOL_PARAMETERS = new JobStep("RESTORE_PROTOCOL_PARAMETERS");
        public static final JobStep DONE = new JobStep("DONE");
        private static int nextOrdinal = 0;
        static final JobStep[] values = new JobStep[]{READ_XMLMSG, PREPARE_SUB_JOBS, READ_FDS_PROJECT_ID, READ_EXTERNAL_SIGNATURES, DETERMINE_LENGTH_OF_VEHICLE_EQUIPMENT_CODE_AND_PR_NUMBER_COMBINATION, PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY, PREPROGRAMMING_SWITCH_TO_END_OF_LINE_SESSION_PHYSICALLY, PREPROGRAMMING_CONTROL_DTC_SETTING_OFF, PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX, SECURITY_ACCESS, WRITE_FINGERPRINT, WRITE_VW_DATA_SET_NUMBER_OR_ECU_DATA_CONTAINER_NUMBER, WRITE_VW_DATA_SET_VERSION_NUMBER, START_ROUTINE_ERASE_VW_MEMORY, REQUEST_ROUTINE_RESULTS_ERASE_VW_MEMORY, WRITE_APPLICATION_DATA_SETS, WRITE_BOOTLOADER_DATA_SETS, POST_DATA_SET, ECU_RESET, SLEEP_ECU_SOFTWARE_RESET_DURATION, POSTPROGRAMMING_START_COMMUNICATION, RESTORE_PROTOCOL_PARAMETERS, DONE};
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
        private final int ordinal = nextOrdinal++;
        private final String name;

        private JobStep(String pName) {
            this.name = pName;
        }

        public static final JobStep valueOf(String pName) throws IllegalArgumentException {
            JobStep jobStep = null;
            Iterator jobStepIterator = VALUES.iterator();
            while (jobStepIterator.hasNext()) {
                jobStep = (JobStep)jobStepIterator.next();
                if (!pName.equals(jobStep.toString())) continue;
                return jobStep;
            }
            throw new IllegalArgumentException("Cannot parse '" + pName + "' into an element of JobStep!");
        }

        public final int compareTo(Object pObject) {
            return this.ordinal - ((JobStep)pObject).ordinal;
        }

        public final boolean equals(Object pObject) {
            return super.equals(pObject);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final int intValue() {
            return this.ordinal;
        }

        public final String toString() {
            return this.name;
        }
    }
}

