/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDbParameter;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;
import com.audi.mcd.joblibrary.util.dserver.DServerVendor;
import com.audi.mcd.joblibrary.util.dserver.VendorSpecific;

public class MCD3_StandECUCodinRead
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20141103";

    public MCD3_StandECUCodinRead() {
        super(REVISION, OutputParameterValue.StandECUCodinRead.JobStatusCode.class, OutputParameterValue.StandECUCodinRead.JobStatusInformation.class);
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        try {
            MCDValue codingValue;
            this.jobStatus = 0;
            this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
            MCDResult jobResult = this.createFinalResult();
            MCDResponse jobResponse = this.addResponse(jobResult, true);
            MCDResponseParameter jobResponseParam = jobResponse.getResponseParameters().getItemByName("OPA_JobResul");
            try {
                this.logger.debug("Main 1: read VWCodinRepaiShop-CodeOrSeriaNumbe");
                this.readTesterSerialNumber(pLogicalLink, jobResponseParam.getParameters().getItemByName("Param_VWCodinRepaiShopCodeOrTesteSeriaNumbe"));
            }
            catch (Exception e) {
                this.jobStatus = 5;
                this.logger.logThrowable(e);
            }
            try {
                this.logger.debug("Main 2: read VWCodinValue");
                this.readOutServiceData("DiagnServi_ReadDataByIdentVariaCodin", "VW Coding Value", "Resp_ReadDataByIdentVariaCodin", new Object[]{"Param_VWCodinValueRAW", "Param_RawData"}, pLogicalLink, jobResponseParam.getParameters().getItemByName("Param_VWCodinValue"));
            }
            catch (Exception e) {
                this.logger.error("Error reading coding value! Setting dummy value 00 00 00...");
                try {
                    codingValue = this.jobApi.createValue(3);
                    codingValue.setBytefield(new byte[]{0, 0, 0});
                    jobResponseParam.getParameters().getItemByName("Param_VWCodinValue").setValue(codingValue);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error setting dummy value for coding date!");
                    this.logger.logThrowable(mcde);
                }
                this.jobStatus = 6;
                this.logger.logThrowable(e);
            }
            if (VendorSpecific.getServerVendor() == DServerVendor.SOFTING) {
                this.logger.debug("[Softing-MCD] Checking for VW Coding Value violating MIN limit of MIN-MAX-LENGTH-TYPE parameter.");
                try {
                    MCDResponseParameter param_vwCodingValue = null;
                    MCDDbParameter dbParam_vwCodingValue = null;
                    MCDValue mcdVwCodingValue = null;
                    byte[] vwCodingValueTmp = null;
                    int vwCodingValueMinLength = 0;
                    int vwCodingValueMaxLength = 0;
                    byte[] vwCodingValueNew = null;
                    param_vwCodingValue = jobResponseParam.getParameters().getItemByName("Param_VWCodinValue");
                    dbParam_vwCodingValue = param_vwCodingValue.getDbObject();
                    vwCodingValueMinLength = dbParam_vwCodingValue.getMinLength();
                    vwCodingValueMaxLength = dbParam_vwCodingValue.getMaxLength();
                    mcdVwCodingValue = param_vwCodingValue.getValue();
                    vwCodingValueTmp = mcdVwCodingValue.getBytefield();
                    if (vwCodingValueTmp.length < vwCodingValueMinLength) {
                        int i;
                        this.logger.debug("VW Coding Value violates MIN limit of MIN-MAX-LENGTH-TYPE parameter!");
                        vwCodingValueNew = new byte[vwCodingValueMinLength];
                        for (i = 0; i < vwCodingValueTmp.length; ++i) {
                            vwCodingValueNew[i] = vwCodingValueTmp[i];
                        }
                        for (i = vwCodingValueTmp.length; i < vwCodingValueNew.length; ++i) {
                            vwCodingValueNew[i] = 0;
                        }
                        mcdVwCodingValue.setBytefield(vwCodingValueNew);
                        param_vwCodingValue.setValue(mcdVwCodingValue);
                        this.jobStatus = 9;
                    } else if (vwCodingValueTmp.length > vwCodingValueMaxLength) {
                        this.logger.warn("VW Coding Value violates MAX limit of MIN-MAX-LENGTH-TYPE parameter... check corresponding ODX data!");
                    }
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error replacing erroneous VW Coding Value!");
                }
            }
            try {
                this.logger.debug("Main 3: read CodinDate");
                this.readOutServiceData("DiagnServi_ReadDataByIdentECUIdent", "VW Coding Date", "Resp_ReadDataByIdentECUIdent", new Object[]{"Param_Date"}, pLogicalLink, jobResponseParam.getParameters().getItemByName("Param_CodinDate"));
            }
            catch (Exception e) {
                if (!(e instanceof MCDException && (VendorSpecific.getServerVendor() == DServerVendor.SOFTING && ((MCDException)((Object)e)).getError().getCode() == 49172 || VendorSpecific.getServerVendor() == DServerVendor.DSA && ((MCDException)((Object)e)).getError().getCode() == 58649 && ((MCDException)((Object)e)).getError().getVendorCode() == 26898))) {
                    this.logger.logThrowable(e);
                    this.jobStatus = 7;
                }
                try {
                    codingValue = this.jobApi.createValue(3);
                    codingValue.setBytefield(new byte[]{0, 1, 1});
                    jobResponseParam.getParameters().getItemByName("Param_CodinDate").setValue(codingValue);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error setting dummy value for coding date!");
                }
            }
            this.setStatus(jobResponse, this.jobStatus);
            this.dumpAndSendFinalResult(jobResult);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
            return;
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
        }
    }

    protected int readInputParameters(MCDRequestParameters pRequestParameters) {
        return 0;
    }

    private void readTesterSerialNumber(MCDLogicalLink mCDLogicalLink, MCDResponseParameter targetParam) throws Exception {
        byte[] byteValue;
        boolean fieldValues;
        MCDValue value = null;
        MCDResponseParameters targetParams = targetParam.getParameters();
        long[] values = new long[]{0L, 0L, 0L};
        value = this.jobApi.createValue(11);
        value.setUint32(values[0]);
        targetParams.getItemByName("Param_VWDevicNumbe").setValue(value);
        value = this.jobApi.createValue(11);
        value.setUint32(values[1]);
        targetParams.getItemByName("Param_ImporNumbe").setValue(value);
        value = this.jobApi.createValue(11);
        value.setUint32(values[2]);
        targetParams.getItemByName("Param_WorksNumbe").setValue(value);
        try {
            value = this.jobApi.createValue(3);
            value.setBytefield(new byte[]{0, 0, 0, 0, 0, 0});
            targetParams.getItemByName("Param_RepaiShopCodeOrTesteSeriaNumbe").setValue(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        MCDDiagComPrimitive service = mCDLogicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentECUIdent");
        MCDRequestParameter tableKeyParam = service.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
        value = tableKeyParam.createValue();
        value.setValueAsString("VW Coding Repair Shop Code Or Serial Number");
        tableKeyParam.setValue(value);
        this.printRequest(service);
        MCDResult result = service.executeSync();
        try {
            if (result.hasError()) {
                throw new IllegalArgumentException();
            }
            result.getResponses().getItemByName("Resp_ReadDataByIdentECUIdent");
        }
        catch (Exception e) {
            this.printMCDResult(result);
            throw new IllegalArgumentException("Error received on result ");
        }
        this.logger.debug("Read 3");
        MCDResponseParameter responseParam = result.getResponses().getItemByName("Resp_ReadDataByIdentECUIdent").getResponseParameters().getItemByName("Param_DataRecor");
        try {
            responseParam = responseParam.getParameters().getItemByName("Param_RepaiShopCodeOrTesteSeriaNumbe");
        }
        catch (Exception e) {
            this.logger.debug("Param_RepaiShopCodeOrTesteSeriaNumbe not found, expect new DataSet..");
        }
        try {
            fieldValues = responseParam.getValue().getDataType() == 3;
        }
        catch (Exception e) {
            fieldValues = false;
        }
        MCDResponseParameters responseParams = responseParam.getParameters();
        if (fieldValues) {
            byteValue = responseParam.getValue().getBytefield();
            values = this.getTesterValues(byteValue);
        } else {
            values = new long[]{responseParams.getItemByName("Param_VWDevicNumbe").getValue().getUint32(), responseParams.getItemByName("Param_ImporNumbe").getValue().getUint32(), responseParams.getItemByName("Param_WorksNumbe").getValue().getUint32()};
            byteValue = this.getTesterByteValue(values);
        }
        MCDResponseParameter tempParam = targetParams.getItemByName("Param_VWDevicNumbe");
        value = tempParam.getValue();
        value.setUint32(values[0]);
        tempParam.setValue(value);
        tempParam = targetParams.getItemByName("Param_ImporNumbe");
        value = tempParam.getValue();
        value.setUint32(values[1]);
        tempParam.setValue(value);
        tempParam = targetParams.getItemByName("Param_WorksNumbe");
        value = tempParam.getValue();
        value.setUint32(values[2]);
        tempParam.setValue(value);
        try {
            tempParam = targetParams.getItemByName("Param_RepaiShopCodeOrTesteSeriaNumbe");
            value = tempParam.getValue();
            value.setBytefield(byteValue);
            tempParam.setValue(value);
        }
        catch (Exception e) {
            this.logger.debug("Job OutputParam Param_RepaiShopCodeOrTesteSeriaNumbe not found.. NO ERROR");
        }
    }

    private long[] getTesterValues(byte[] byteValue) {
        long[] longValue = new long[byteValue.length];
        for (int i = 0; i < longValue.length; ++i) {
            longValue[i] = byteValue[i] & 0xFF;
        }
        long device = longValue[0] << 13 | longValue[1] << 5 | longValue[2] >>> 3;
        long importNo = (longValue[2] & 7L) << 7 | longValue[3] >>> 1;
        long works = (longValue[3] & 1L) << 16 | longValue[4] << 8 | longValue[5];
        this.logger.debug("device: 0x" + Long.toHexString(device) + " import: 0x" + Long.toHexString(importNo) + " works: 0x" + Long.toHexString(works));
        return new long[]{device, importNo, works};
    }

    private byte[] getTesterByteValue(long[] values) {
        byte[] result = new byte[]{0, 0, 0, 0, 0, 0};
        long device = values[0];
        long importNo = values[1];
        long works = values[2];
        result[0] = (byte)(device >>> 13);
        result[1] = (byte)(device >>> 5 & 0xFFL);
        long temp = device & 0x1FL;
        result[2] = (byte)(temp << 3 | importNo >>> 7);
        temp = importNo & 0x7FL;
        result[3] = (byte)(temp << 1 | works >>> 16 & 1L);
        result[4] = (byte)(works >>> 8 & 0xFFL);
        result[5] = (byte)(works & 0xFFL);
        this.logger.debug("bytes: " + (Long.toHexString(result[0] & 0xFF) + " " + Long.toHexString(result[1] & 0xFF) + " " + Long.toHexString(result[2] & 0xFF) + " " + Long.toHexString(result[3] & 0xFF) + " " + Long.toHexString(result[4] & 0xFF) + " " + Long.toHexString(result[5] & 0xFF) + " ").toUpperCase());
        return result;
    }

    private void readOutServiceData(String serviceName, String key, String responseName, Object[] responsePath, MCDLogicalLink mCDLogicalLink, MCDResponseParameter targetParam) throws MCDException {
        MCDValue value = null;
        this.logger.debug("Read " + key + " 1");
        MCDDiagComPrimitive service = mCDLogicalLink.createDiagComPrimitiveByName(serviceName);
        MCDRequestParameter tableKeyParam = service.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
        if (tableKeyParam.getDbObject().isConstant()) {
            value = tableKeyParam.getValue();
        } else {
            try {
                value = tableKeyParam.createValue();
                value.setValueAsString(key);
                tableKeyParam.setValue(value);
            }
            catch (MCDException mcde) {
                if (VendorSpecific.getServerVendor() == DServerVendor.SOFTING && mcde.getError().getCode() == 49172 || VendorSpecific.getServerVendor() == DServerVendor.DSA && mcde.getError().getCode() == 58649 && mcde.getError().getVendorCode() == 26898) {
                    this.logger.warn("The identification \"" + key + "\" is not supported by this ECU!");
                    if (this.logger.getLogLevel() >= 6) {
                        this.logger.logThrowable(mcde);
                    }
                } else {
                    this.logger.logThrowable(mcde);
                }
                throw mcde;
            }
        }
        this.logger.debug("Read " + key + " 2 inputDataType: " + value.getDataType() + " name: " + tableKeyParam.getShortName());
        this.logger.debug("Read " + key + " 2b ID:" + value.getValueAsString());
        this.printRequest(service);
        MCDResult result = service.executeSync();
        this.logger.debug("Read " + key + " 2");
        try {
            if (result.hasError()) {
                if (serviceName.equals("DiagnServi_ReadDataByIdentVariaCodin")) {
                    MCDResponses responses = result.getResponses();
                    if (responses == null) {
                        throw new IllegalArgumentException();
                    }
                    long numberOfResponses = responses.getCount();
                    if (numberOfResponses == 0L) {
                        throw new IllegalArgumentException();
                    }
                    MCDResponse response = responses.getItemByIndex(0L);
                    if (response == null) {
                        throw new IllegalArgumentException();
                    }
                    MCDResponseParameters responseParameters = response.getResponseParameters();
                    if (responseParameters == null) {
                        throw new IllegalArgumentException();
                    }
                    MCDResponseParameter dataRecord = responseParameters.getItemByName("Param_DataRecor");
                    if (dataRecord == null) {
                        throw new IllegalArgumentException();
                    }
                    responseParameters = dataRecord.getParameters();
                    if (responseParameters == null) {
                        throw new IllegalArgumentException();
                    }
                    MCDResponseParameter vwCodinValueRaw = responseParameters.getItemByName("Param_VWCodinValueRAW");
                    if (vwCodinValueRaw == null) {
                        throw new IllegalArgumentException();
                    }
                    responseParameters = vwCodinValueRaw.getParameters();
                    if (responseParameters == null) {
                        throw new IllegalArgumentException();
                    }
                    MCDResponseParameter rawData = responseParameters.getItemByName("Param_RawData");
                    if (rawData == null) {
                        throw new IllegalArgumentException();
                    }
                    if (rawData.hasError()) {
                        throw new IllegalArgumentException();
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            result.getResponses().getItemByName(responseName);
        }
        catch (Exception e) {
            this.logger.debug("Error received on result: " + key);
            this.printMCDResult(result);
            throw new IllegalArgumentException("Error received on result: " + key);
        }
        this.logger.debug("Read " + key + " 3");
        this.logger.debug("Response: " + this.vendorSpecific.pduValue2String(result.getResponses().getItemByIndex(0L).getResponseMessage()));
        MCDResponseParameter responseParam = result.getResponses().getItemByName(responseName).getResponseParameters().getItemByName("Param_DataRecor");
        if (responsePath != null) {
            for (int i = 0; i < responsePath.length; ++i) {
                if (responsePath[i] instanceof String) {
                    responseParam = responseParam.getParameters().getItemByName((String)responsePath[i]);
                    continue;
                }
                if (!(responsePath[i] instanceof Integer)) continue;
                responseParam = responseParam.getParameters().getItemByIndex(((Integer)responsePath[i]).longValue());
            }
        }
        value = this.jobApi.createValue(3);
        this.logger.debug("Read " + key + " 3a: " + responseParam.getType());
        if (responseParam.getType() == 17) {
            value.setBytefield(MCD3_StandECUCodinRead.getBytefield(responseParam));
        } else {
            value.setBytefield(responseParam.getValue().getBytefield());
        }
        this.logger.debug("Read " + key + " 3e");
        targetParam.setValue(value);
        this.logger.debug("Read " + key + " 4");
    }

    private static byte[] getBytefield(MCDResponseParameter responseParam) throws MCDException {
        MCDResponseParameters params = responseParam.getParameters();
        byte[] result = new byte[(int)params.getCount()];
        for (long i = 0L; i < params.getCount(); ++i) {
            result[(int)i] = Integer.decode("0x" + params.getItemByIndex(i).getValue().getUint32()).byteValue();
        }
        return result;
    }

    private void setStatus(MCDResponse jobResponse, int pJobStatus) {
        MCDResponseParameters params = null;
        try {
            params = jobResponse.getResponseParameters();
            MCDResponseParameter param = params.getItemByName("OPA_JobStatuInfor");
            MCDValue value = this.jobApi.createValue(14);
            value.setValueAsString(this.getJobStatusInformation());
            param.setValue(value);
            try {
                param = params.getItemByName("OPA_JobStatuCode");
                value = this.jobApi.createValue(11);
                value.setUint32((long)pJobStatus);
                param.setValue(value);
                this.logger.debug("Set Code " + pJobStatus + " = " + param.getValue().getUint32());
            }
            catch (Exception e) {
                this.logger.debug("Set Status Code failed!");
                this.logger.logThrowable(e);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Status failed!");
            this.logger.logThrowable(e);
        }
        try {
            if (this.mcdError != null) {
                ((MCDResult)((MCDResponses)jobResponse.getParent()).getParent()).setError(this.mcdError);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Error Object failed!");
            this.logger.logThrowable(e);
        }
    }

    protected int addOutputParameters(MCDResponse pResponse) {
        return 0;
    }
}

