/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary2.util.dserver.impl;

import asam.d.MCDDbSpecialData;
import asam.d.MCDDbSpecialDataElement;
import asam.d.MCDDbSpecialDataGroup;
import asam.d.MCDDbSpecialDataGroupCaption;
import asam.d.MCDDbSpecialDataGroups;
import asam.d.MCDException;
import com.audi.mcd.joblibrary2.util.dserver.SpecialDataGroupHelper;
import com.audi.mcd.joblibrary2.util.dserver.VendorSpecificMCD20002;
import com.audi.mcd.joblibrary2.util.logging.Logger;
import java.util.Map;

public class SpecialDataGroupHelperImpl
implements SpecialDataGroupHelper {
    protected Logger logger = null;
    protected VendorSpecificMCD20002 vendorSpecific = null;

    public SpecialDataGroupHelperImpl(Logger pLogger, VendorSpecificMCD20002 pVendorSpecific) {
        this.logger = pLogger;
        this.vendorSpecific = pVendorSpecific;
    }

    public boolean getSpecialDataElementsFromSpecialDataGroupsByCaption(MCDDbSpecialDataGroups pDbSpecialDataGroups, String pSdgCaption, Map pSpecialDataElements) {
        long numberOfSpecialDataGroups = 0L;
        MCDDbSpecialDataGroup dbSpecialDataGroup = null;
        MCDDbSpecialDataGroupCaption dbSpecialDataGroupCaption = null;
        String dbSpecialDataGroupCaptionShortName = null;
        long numberOfSpecialData = 0L;
        MCDDbSpecialData dbSpecialData = null;
        MCDDbSpecialDataElement dbSpecialDataElement = null;
        String semanticInformation = null;
        String content = null;
        this.logger.trace("Entering getSpecialDataElementsFromSpecialDataGroupsByCaption(...).");
        try {
            numberOfSpecialDataGroups = pDbSpecialDataGroups.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of SDGS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        this.logger.debug("Found " + numberOfSpecialDataGroups + " SDG(s).");
        for (long i = 0L; i < numberOfSpecialDataGroups; ++i) {
            try {
                dbSpecialDataGroup = pDbSpecialDataGroups.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting SDG with index " + i + "!");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (dbSpecialDataGroup == null) {
                this.logger.debug("Error getting SDG with index " + i + "... skipping current SDG.");
                continue;
            }
            dbSpecialDataGroupCaption = null;
            dbSpecialDataGroupCaption = this.vendorSpecific.getSpecialDataGroupCaption(dbSpecialDataGroup);
            if (dbSpecialDataGroupCaption == null) continue;
            try {
                dbSpecialDataGroupCaptionShortName = dbSpecialDataGroupCaption.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting SHORT-NAME of SDG-CAPTION of SDG with index " + i + "!");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (!dbSpecialDataGroupCaptionShortName.equals(pSdgCaption)) {
                this.logger.debug("Skipping SDG with SDG-CAPTION '" + dbSpecialDataGroupCaptionShortName + "' while searching for SDG-CAPTION '" + pSdgCaption + "'...");
                continue;
            }
            this.logger.debug("Found SDG with matching SDG-CAPTION '" + pSdgCaption + "'.");
            try {
                numberOfSpecialData = dbSpecialDataGroup.getCount();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining number of SDs.");
                this.logger.logThrowable(mcde);
                return false;
            }
            this.logger.debug("Found " + numberOfSpecialData + " SD(s).");
            for (long j = 0L; j < numberOfSpecialData; ++j) {
                try {
                    dbSpecialData = dbSpecialDataGroup.getItemByIndex(j);
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting SD with index " + j + "!");
                    this.logger.logThrowable(mcde);
                    return false;
                }
                if (dbSpecialData instanceof MCDDbSpecialDataGroup) {
                    this.logger.debug("Ignoring nested SDG at index " + j + ".");
                    continue;
                }
                if (!(dbSpecialData instanceof MCDDbSpecialDataElement)) continue;
                dbSpecialDataElement = (MCDDbSpecialDataElement)dbSpecialData;
                try {
                    semanticInformation = dbSpecialDataElement.getSemanticInformation();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting SI from SD with index " + j + "!");
                    this.logger.logThrowable(mcde);
                    return false;
                }
                try {
                    content = dbSpecialDataElement.getContent();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting content from SD with index " + j + "!");
                    this.logger.logThrowable(mcde);
                    return false;
                }
                this.logger.debug("SDG with SI='" + semanticInformation + "' has value: " + content);
                pSpecialDataElements.put(semanticInformation, content);
            }
        }
        this.logger.trace("Leaving getSpecialDataElementsFromSpecialDataGroupsByCaption(...).");
        return true;
    }
}

