/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDProtocolParameterSet;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;

public class MCD3_ChangDiagnSessi
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20141103";

    public MCD3_ChangDiagnSessi() {
        super(REVISION, OutputParameterValue.ChangDiagnSessi.JobStatusCode.class, OutputParameterValue.ChangDiagnSessi.JobStatusInformation.class);
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        MCDValue diagnosticSessionType = null;
        MCDDiagComPrimitive diagnosticSessionControl = null;
        MCDRequestParameters requestParameters = null;
        MCDResult result = null;
        MCDResponse response = null;
        MCDValue p2MaxServer = null;
        MCDValue p2StarServer = null;
        try {
            block14: {
                this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
                this.logger.debug("Main 1");
                try {
                    this.logger.debug("Main 2 get InputParam session Type");
                    try {
                        diagnosticSessionType = pRequestParameters.getItemByName("IPA_DiagnSessiType").getParameters().getItemByName("Param_DiagnSessiTypes").getValue();
                        this.logger.debug("Main 3 create DiagCom");
                    }
                    catch (MCDException mcde) {
                        this.logger.logThrowable(mcde);
                        this.jobStatus = 2;
                        throw new IllegalAccessException(this.getJobStatusInformation());
                    }
                    try {
                        diagnosticSessionControl = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_DiagnSessiContr");
                    }
                    catch (MCDException mcde) {
                        this.jobStatus = 6;
                        this.finalizeJob();
                        this.logger.finalize(this.getCurrentJobRuntimeAsString());
                        this.logger.exit();
                        return;
                    }
                    requestParameters = diagnosticSessionControl.getRequest().getRequestParameters();
                    this.logger.debug("Main 4 set request params");
                    try {
                        requestParameters.getItemByName("Param_DiagnSessiType").setValue(diagnosticSessionType);
                    }
                    catch (MCDException mcde) {
                        this.jobStatus = 1;
                        this.finalizeJob();
                        this.logger.finalize(this.getCurrentJobRuntimeAsString());
                        this.logger.exit();
                        return;
                    }
                    this.logger.debug("Main 5 execute service");
                    this.printRequest(diagnosticSessionControl);
                    result = diagnosticSessionControl.executeSync();
                    this.printMCDResult(result);
                    this.logger.debug("Main 6 analyze response");
                    try {
                        response = result.getResponses().getItemByName("Resp_DiagnSessiContr");
                    }
                    catch (Exception e) {
                        this.logger.debug("Error: Negative Response!");
                        this.printMCDResult(result);
                        this.jobStatus = 1;
                        throw new IllegalAccessException(this.getJobStatusInformation());
                    }
                    if (this.isMcd20002Interface) break block14;
                    this.logger.debug("Main 7 get timing params");
                    try {
                        p2MaxServer = response.getResponseParameters().getItemByName("Param_StandTiminP2Serve").getValue();
                        this.logger.debug("Param_StandTiminP2Serve: [" + p2MaxServer.getUint32() + "]");
                        p2StarServer = response.getResponseParameters().getItemByName("Param_ExtenTiminP2Serve").getValue();
                        this.logger.debug("Param_ExtenTiminP2Serve: [" + p2StarServer.getUint32() + "]");
                    }
                    catch (MCDException mcde) {
                        this.logger.logThrowable(mcde);
                        this.jobStatus = 5;
                        throw new IllegalAccessException(this.getJobStatusInformation());
                    }
                    this.setComparams(new String[]{"ResponseTimeout", "RC78ResponseTimeout"}, new long[]{p2MaxServer.getUint32(), p2StarServer.getUint32()});
                }
                catch (IllegalAccessException iae) {
                    // empty catch block
                }
            }
            this.finalizeJob();
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
            return;
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.finalizeJob();
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
            return;
        }
    }

    protected void setComparams(String[] strings, long[] values) throws IllegalAccessException, MCDException {
        MCDProtocolParameterSet parameterSet;
        boolean isoFlag = false;
        long canTransmissionTime = 0L;
        try {
            this.logger.debug("Main 8 create comparams");
            parameterSet = (MCDProtocolParameterSet)this.logicalLink.createDiagComPrimitiveByType(1193);
            parameterSet.fetchValuesFromInterface();
            MCDRequestParameters requestParams = parameterSet.getRequest().getRequestParameters();
            this.logger.debug("Main 9 set comparams");
            try {
                if (requestParams.getItemByName("CP_ModifyTiming") != null) {
                    isoFlag = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (isoFlag) {
                return;
            }
            this.logger.debug("Main 9 ISOTEst: No iso CP Found execute comparams..");
            canTransmissionTime = requestParams.getItemByName("ComPar_CANTransTime").getValue().getUint32();
            this.logger.debug("ComPar_CANTransTime: [" + canTransmissionTime + "]");
            for (int i = 0; i < strings.length; ++i) {
                MCDRequestParameter timingValue = requestParams.getItemByName(strings[i]);
                MCDValue mcdValue = timingValue.getValue();
                try {
                    this.logger.debug(" old: " + mcdValue.getUint32() + " new: " + values[i] + canTransmissionTime);
                }
                catch (Exception e) {
                    // empty catch block
                }
                mcdValue.setUint32(values[i] + canTransmissionTime);
                timingValue.setValue(mcdValue);
                this.logger.debug("ControlPrint: " + timingValue.getValue().getUint32());
            }
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
            this.jobStatus = 3;
            throw new IllegalAccessException(this.getJobStatusInformation());
        }
        this.logger.debug("Main 10 execute comparams");
        MCDResult comparamResult = parameterSet.executeSync();
        if (comparamResult != null) {
            try {
                if (comparamResult.hasError() && comparamResult.getError().getCode() == 53332) {
                    this.jobStatus = 4;
                    throw new IllegalAccessException(this.getJobStatusInformation());
                }
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
            }
        }
    }
}

