/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.util.dserver.impl;

import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDiagTroubleCode;
import asam.d.MCDDbFlashJob;
import asam.d.MCDDbFlashSession;
import asam.d.MCDDbIdentDescription;
import asam.d.MCDDbLocation;
import asam.d.MCDDbParameter;
import asam.d.MCDDbRequestParameter;
import asam.d.MCDDbResponseParameter;
import asam.d.MCDDbSpecialDataGroup;
import asam.d.MCDDbSpecialDataGroupCaption;
import asam.d.MCDError;
import asam.d.MCDException;
import asam.d.MCDInterval;
import asam.d.MCDParameter;
import asam.d.MCDRequestParameter;
import asam.d.MCDResponseParameter;
import asam.d.MCDService;
import asam.d.MCDTextTableElement;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import asam.d.imp.MCDDbDiagTroubleCodeImp;
import asam.d.imp.MCDDbFlashSessionImp;
import asam.d.imp.MCDDbIdentDescriptionImp;
import asam.d.imp.MCDDbRequestParameterImp;
import asam.d.imp.MCDDbResponseParameterImp;
import asam.d.imp.MCDDbSpecialDataGroupImp;
import asam.d.imp.MCDDbUnitImp;
import asam.d.imp.MCDIntervalImp;
import asam.d.imp.MCDRequestParameterImp;
import asam.d.imp.MCDResponseParameterImp;
import asam.d.imp.MCDServiceImp;
import com.audi.mcd.joblibrary.util.Conversions;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import com.audi.mcd.joblibrary.util.dserver.impl.VendorSpecificMCD20002Impl;
import com.audi.mcd.joblibrary.util.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class VendorSpecificDsaProdisMcdImpl
extends VendorSpecificMCD20002Impl {
    private boolean isMcd300Interface = false;
    protected Method getDbDataPrimitiveMethod = null;
    protected Method getDbResponseParameterMethod = null;
    protected Method getLowerLimitMethod = null;
    protected Method getLowerLimitIntervalTypeMethod = null;
    protected Method getUpperLimitMethod = null;
    protected Method getUpperLimitIntervalTypeMethod = null;
    protected Method setSuppressPositiveResponseUncheckedNSFMethod = null;

    public VendorSpecificDsaProdisMcdImpl(Logger pLogger) {
        super(pLogger);
        this.determineDbIdentDescriptionMethods();
        if (this.isMcd300Interface) {
            this.determineSetSuppressPositiveResponseUncheckedNSFMethod();
        }
        if (!this.isMcd300Interface) {
            this.determineIntervalMethods();
        }
    }

    public MCDDbDataPrimitive getDbDataPrimitiveOfDbIdentDescription(MCDDbIdentDescription pDbIdentDescription, MCDDbLocation pDbLocation) {
        MCDDbIdentDescriptionImp dbIdentDescription = null;
        MCDDbDataPrimitive dbDataPrimitive = null;
        this.logger.trace("Entering getDbDataPrimitiveOfDbIdentDescription(...).");
        try {
            dbIdentDescription = (MCDDbIdentDescriptionImp)pDbIdentDescription;
        }
        catch (ClassCastException cce) {
            this.logger.debug("Error casting MCDDbIdentDescription to MCDDbIdentDescriptionImp!");
            this.logger.logThrowable(cce);
            return null;
        }
        try {
            try {
                dbDataPrimitive = (MCDDbDataPrimitive)this.getDbDataPrimitiveMethod.invoke((Object)dbIdentDescription, pDbLocation);
            }
            catch (InvocationTargetException ite) {
                this.logger.error("Error getting dbDataPrimitive from dbIdentDescription.");
                this.logger.logThrowable(ite);
            }
            catch (IllegalArgumentException iare) {
                this.logger.error("Error getting dbDataPrimitive from dbIdentDescription.");
                this.logger.logThrowable(iare);
            }
            catch (IllegalAccessException iace) {
                this.logger.error("Error getting dbDataPrimitive from dbIdentDescription.");
                this.logger.logThrowable(iace);
            }
        }
        catch (Exception e) {
            this.logger.debug("Error determining the DIAG-COMM referenced by the IDENT-DESC of the OWN-IDENT!");
            this.logger.logThrowable(e);
            return null;
        }
        this.logger.trace("Leaving getDbDataPrimitiveOfDbIdentDescription(...).");
        return dbDataPrimitive;
    }

    public MCDDbResponseParameter getDbResponseParameterOfDbIdentDescription(MCDDbIdentDescription pDbIdentDescription, MCDDbLocation pDbLocation) {
        MCDDbResponseParameter dbResponseParameter;
        block9: {
            MCDDbIdentDescriptionImp dbIdentDescription = null;
            dbResponseParameter = null;
            this.logger.trace("Entering getDbResponseParameterOfDbIdentDescription(...).");
            try {
                dbIdentDescription = (MCDDbIdentDescriptionImp)pDbIdentDescription;
            }
            catch (ClassCastException cce) {
                this.logger.debug("Error casting MCDDbIdentDescription to MCDDbIdentDescriptionImp!");
                this.logger.logThrowable(cce);
                return null;
            }
            try {
                try {
                    if (this.isMcd300Interface) {
                        dbResponseParameter = (MCDDbResponseParameter)this.getDbResponseParameterMethod.invoke((Object)dbIdentDescription, new Object[0]);
                        break block9;
                    }
                    dbResponseParameter = (MCDDbResponseParameter)this.getDbResponseParameterMethod.invoke((Object)dbIdentDescription, pDbLocation);
                }
                catch (InvocationTargetException ite) {
                    this.logger.error("Error getting dbResponseParameter from dbIdentDescription.");
                    this.logger.logThrowable(ite);
                }
                catch (IllegalArgumentException iare) {
                    this.logger.error("Error getting dbResponseParameter from dbIdentDescription.");
                    this.logger.logThrowable(iare);
                }
                catch (IllegalAccessException iace) {
                    this.logger.error("Error getting dbResponseParameter from dbIdentDescription.");
                    this.logger.logThrowable(iace);
                }
            }
            catch (Exception e) {
                this.logger.debug("Error determining the PARAM referenced by the IDENT-DESC of the OWN-IDENT!");
                this.logger.logThrowable(e);
                return null;
            }
        }
        this.logger.trace("Leaving getDbResponseParameterOfDbIdentDescription(...).");
        return dbResponseParameter;
    }

    public String getLongNameIDOfDbDiagTroubleCode(MCDDbDiagTroubleCode pDbDiagTroubleCode) {
        String ti = null;
        MCDDbDiagTroubleCodeImp dbDiagTroubleCode = null;
        this.logger.trace("Entering getLongNameIDOfDbDiagTroubleCode(...).");
        dbDiagTroubleCode = (MCDDbDiagTroubleCodeImp)pDbDiagTroubleCode;
        ti = dbDiagTroubleCode.getDiagTroubleCodeTextID();
        this.logger.trace("Leaving getLongNameIDOfDbDiagTroubleCode(...).");
        return ti;
    }

    public String getLongNameIDOfDbUnitOfDbParameter(MCDDbParameter pDbParameter) {
        Class dbParameterClass = null;
        Method getDbUnit = null;
        MCDDbUnitImp dbUnit = null;
        String longNameID = null;
        this.logger.trace("Entering getLongNameIDOfDbUnitOfDbParameter(...).");
        if (pDbParameter instanceof MCDDbRequestParameter) {
            try {
                dbParameterClass = MCDDbRequestParameterImp.class;
            }
            catch (Exception e) {
                this.logger.debug("Error getting class of dbRequestParameter!");
                this.logger.logThrowable(e);
            }
        } else if (pDbParameter instanceof MCDDbResponseParameter) {
            try {
                dbParameterClass = MCDDbResponseParameterImp.class;
            }
            catch (Exception e) {
                this.logger.debug("Error getting class of dbResponseParameter!");
                this.logger.logThrowable(e);
            }
        }
        if (dbParameterClass != null) {
            try {
                getDbUnit = dbParameterClass.getMethod("getDbUnit", null);
            }
            catch (SecurityException se) {
                this.logger.error("Error determining getDbUnit() method for MCDDbParameter.");
                this.logger.logThrowable(se);
                return null;
            }
            catch (NoSuchMethodException nsme) {
                this.logger.error("Error determining getDbUnit() method for MCDDbParameter.");
                this.logger.logThrowable(nsme);
                return null;
            }
            try {
                dbUnit = (MCDDbUnitImp)getDbUnit.invoke((Object)pDbParameter, null);
            }
            catch (InvocationTargetException ite) {
                this.logger.error("Error getting dbUnit of dbParameter.");
                this.logger.logThrowable(ite);
                return null;
            }
            catch (IllegalArgumentException iare) {
                this.logger.error("Error getting dbUnit of dbParameter.");
                this.logger.logThrowable(iare);
                return null;
            }
            catch (IllegalAccessException iace) {
                this.logger.error("Error getting dbUnit of dbParameter.");
                this.logger.logThrowable(iace);
                return null;
            }
            try {
                longNameID = dbUnit.getLongNameID();
            }
            catch (Exception e) {
                this.logger.debug("Error getting TI of to of unit of dbParameter!");
                this.logger.logThrowable(e);
                return null;
            }
        }
        this.logger.trace("Leaving getLongNameIDOfDbUnitOfDbParameter(...).");
        return longNameID;
    }

    public MCDValue getLowerLimitFromInterval(MCDInterval pInterval) throws MCDException {
        MCDIntervalImp interval = null;
        MCDValue lowerLimit = null;
        this.logger.trace("Entering getLowerLimitFromInterval(...).");
        if (this.isMcd300Interface) {
            lowerLimit = pInterval.getLowerLimit();
        } else {
            try {
                interval = (MCDIntervalImp)pInterval;
            }
            catch (ClassCastException cce) {
                this.logger.debug("Error casting MCDInterval to MCDIntervalImp!");
                this.logger.logThrowable(cce);
                return null;
            }
            try {
                try {
                    lowerLimit = (MCDValue)this.getLowerLimitMethod.invoke((Object)interval, null);
                }
                catch (InvocationTargetException ite) {
                    this.logger.error("Error getting lower limit from interval.");
                    this.logger.logThrowable(ite);
                }
                catch (IllegalArgumentException iare) {
                    this.logger.error("Error getting lower limit from interval.");
                    this.logger.logThrowable(iare);
                }
                catch (IllegalAccessException iace) {
                    this.logger.error("Error getting lower limit from interval.");
                    this.logger.logThrowable(iace);
                }
            }
            catch (Exception e) {
                this.logger.debug("Error determining the lower limit of the interval !");
                this.logger.logThrowable(e);
                lowerLimit = null;
            }
        }
        this.logger.trace("Leaving getLowerLimitFromInterval(...).");
        return lowerLimit;
    }

    public int getLowerLimitIntervalTypeFromInterval(MCDInterval pInterval) throws MCDException {
        MCDIntervalImp interval = null;
        int lowerLimitIntervalType = -1;
        this.logger.trace("Entering getLowerLimitIntervalTypeFromInterval(...).");
        if (this.isMcd300Interface) {
            lowerLimitIntervalType = pInterval.getLowerLimitIntervalType();
        } else {
            try {
                interval = (MCDIntervalImp)pInterval;
            }
            catch (ClassCastException cce) {
                this.logger.debug("Error casting MCDInterval to MCDIntervalImp!");
                this.logger.logThrowable(cce);
                return lowerLimitIntervalType;
            }
            try {
                try {
                    lowerLimitIntervalType = (Integer)this.getLowerLimitIntervalTypeMethod.invoke((Object)interval, null);
                }
                catch (InvocationTargetException ite) {
                    this.logger.error("Error getting interval type of lower limit from interval.");
                    this.logger.logThrowable(ite);
                }
                catch (IllegalArgumentException iare) {
                    this.logger.error("Error getting interval type of lower limit from interval.");
                    this.logger.logThrowable(iare);
                }
                catch (IllegalAccessException iace) {
                    this.logger.error("Error getting interval type of lower limit from interval.");
                    this.logger.logThrowable(iace);
                }
            }
            catch (Exception e) {
                this.logger.debug("Error determining the interval type of the lower limit!");
                this.logger.logThrowable(e);
                lowerLimitIntervalType = -1;
            }
        }
        this.logger.trace("Leaving getLowerLimitIntervalTypeFromInterval(...).");
        return lowerLimitIntervalType;
    }

    public MCDValue getUpperLimitFromInterval(MCDInterval pInterval) throws MCDException {
        MCDIntervalImp interval = null;
        MCDValue upperLimit = null;
        this.logger.trace("Entering getUpperLimitFromInterval(...).");
        if (this.isMcd300Interface) {
            upperLimit = pInterval.getUpperLimit();
        } else {
            try {
                interval = (MCDIntervalImp)pInterval;
            }
            catch (ClassCastException cce) {
                this.logger.debug("Error casting MCDInterval to MCDIntervalImp!");
                this.logger.logThrowable(cce);
                return null;
            }
            try {
                try {
                    upperLimit = (MCDValue)this.getUpperLimitMethod.invoke((Object)interval, null);
                }
                catch (InvocationTargetException ite) {
                    this.logger.error("Error getting upper limit from interval.");
                    this.logger.logThrowable(ite);
                }
                catch (IllegalArgumentException iare) {
                    this.logger.error("Error getting upper limit from interval.");
                    this.logger.logThrowable(iare);
                }
                catch (IllegalAccessException iace) {
                    this.logger.error("Error getting upper limit from interval.");
                    this.logger.logThrowable(iace);
                }
            }
            catch (Exception e) {
                this.logger.debug("Error determining the upper limit of the interval !");
                this.logger.logThrowable(e);
                upperLimit = null;
            }
        }
        this.logger.trace("Leaving getUpperLimitFromInterval(...).");
        return upperLimit;
    }

    public int getUpperLimitIntervalTypeFromInterval(MCDInterval pInterval) throws MCDException {
        MCDIntervalImp interval = null;
        int upperLimitIntervalType = -1;
        this.logger.trace("Entering getUpperLimitIntervalTypeFromInterval(...).");
        if (this.isMcd300Interface) {
            upperLimitIntervalType = pInterval.getUpperLimitIntervalType();
        } else {
            try {
                interval = (MCDIntervalImp)pInterval;
            }
            catch (ClassCastException cce) {
                this.logger.debug("Error casting MCDInterval to MCDIntervalImp!");
                this.logger.logThrowable(cce);
                return upperLimitIntervalType;
            }
            try {
                try {
                    upperLimitIntervalType = (Integer)this.getUpperLimitIntervalTypeMethod.invoke((Object)interval, null);
                }
                catch (InvocationTargetException ite) {
                    this.logger.error("Error getting interval type of upper limit from interval.");
                    this.logger.logThrowable(ite);
                }
                catch (IllegalArgumentException iare) {
                    this.logger.error("Error getting interval type of upper limit from interval.");
                    this.logger.logThrowable(iare);
                }
                catch (IllegalAccessException iace) {
                    this.logger.error("Error getting interval type of upper limit from interval.");
                    this.logger.logThrowable(iace);
                }
            }
            catch (Exception e) {
                this.logger.debug("Error determining the interval type of the upper limit!");
                this.logger.logThrowable(e);
                upperLimitIntervalType = -1;
            }
        }
        this.logger.trace("Leaving getUpperLimitIntervalTypeFromInterval(...).");
        return upperLimitIntervalType;
    }

    public MCDDbSpecialDataGroupCaption getSpecialDataGroupCaption(MCDDbSpecialDataGroup pDbSpecialDataGroup) {
        MCDDbSpecialDataGroupImp dbSpecialDataGroup = null;
        MCDDbSpecialDataGroupCaption dbSpecialDataGroupCaption = null;
        this.logger.trace("Entering getSpecialDataGroupCaption(...).");
        dbSpecialDataGroup = (MCDDbSpecialDataGroupImp)pDbSpecialDataGroup;
        try {
            if (!dbSpecialDataGroup.hasCaption()) {
                this.logger.debug("Skipping unexpected SDG without SDG-CAPTION.");
                return null;
            }
        }
        catch (Exception e) {
            this.logger.debug("Error getting SDG-CAPTION of SDG... skipping current SDG.");
            this.logger.logThrowable(e);
            return null;
        }
        try {
            dbSpecialDataGroupCaption = dbSpecialDataGroup.getCaption();
        }
        catch (Exception e) {
            this.logger.debug("Error getting SDG-CAPTION of SDG... skipping current SDG.");
            this.logger.logThrowable(e);
            return null;
        }
        if (dbSpecialDataGroupCaption == null) {
            this.logger.debug("Error getting SDG-CAPTION of SDG with index... skipping current SDG.");
            return null;
        }
        this.logger.trace("Leaving getSpecialDataGroupCaption(...).");
        return dbSpecialDataGroupCaption;
    }

    public MCDDbFlashJob getDbFlashJobOfDbFlashSession(MCDDbFlashSession pDbFlashSession, MCDDbLocation pDbLocation) {
        MCDDbFlashSessionImp dbFlashSession = null;
        dbFlashSession = (MCDDbFlashSessionImp)pDbFlashSession;
        return dbFlashSession.getDbFlashJob(pDbLocation);
    }

    public MCDTextTableElement getTextTableElementByCodedValueUint32(MCDTextTableElements pTextTableElements, long pCodedValueUint32) {
        long numberOfTextTableElements = 0L;
        MCDTextTableElement textTableElement = null;
        MCDTextTableElement textTableElementOfCompuDefaultValue = null;
        MCDInterval interval = null;
        int lowerLimitIntervalType = -1;
        int upperLimitIntervalType = -1;
        MCDValue value_lowerLimit = null;
        MCDValue value_upperLimit = null;
        int lowerLimitDataType = -1;
        int upperLimitDataType = -1;
        long lowerLimit = 0L;
        long upperLimit = 0L;
        boolean foundMatch = false;
        this.logger.trace("Entering getTextTableElementByCodedValueUint32(...).");
        if (pTextTableElements == null) {
            return null;
        }
        try {
            numberOfTextTableElements = pTextTableElements.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of text table elements of database parameter.");
            this.logger.logThrowable(mcde);
            return null;
        }
        int i = 0;
        while ((long)i < numberOfTextTableElements) {
            block32: {
                block34: {
                    block33: {
                        try {
                            textTableElement = pTextTableElements.getItemByIndex((long)i);
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                            break block32;
                        }
                        try {
                            interval = textTableElement.getInterval();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting interval of text table element with index " + i + " (probably the COMPU-DEFAULT-VALUE).");
                            if (mcde.getError().getCode() != 57362) {
                                this.logger.logThrowable(mcde);
                            }
                            textTableElementOfCompuDefaultValue = textTableElement;
                            break block32;
                        }
                        try {
                            lowerLimitIntervalType = this.getLowerLimitIntervalTypeFromInterval(interval);
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting INTERVAL-TYPE of LOWER-LIMIT of text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                            break block32;
                        }
                        try {
                            upperLimitIntervalType = this.getUpperLimitIntervalTypeFromInterval(interval);
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting INTERVAL-TYPE of UPPER-LIMIT  of text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                            break block32;
                        }
                        try {
                            value_lowerLimit = this.getLowerLimitFromInterval(interval);
                            if (lowerLimitDataType == -1) {
                                try {
                                    lowerLimitDataType = value_lowerLimit.getDataType();
                                }
                                catch (MCDException mcde) {
                                    this.logger.debug("Error getting data type of value of LOWER-LIMIT of text table element with index " + i + ".");
                                    this.logger.logThrowable(mcde);
                                    break block32;
                                }
                                if (lowerLimitDataType != 11) {
                                    this.logger.error("The data type of value of LOWER-LIMIT (" + McdEnumDecoder.decodeMcdDataType(lowerLimitDataType) + ") of the text table element with index " + i + " does not match the expected data type " + McdEnumDecoder.decodeMcdDataType(11) + "!");
                                    return null;
                                }
                            }
                            if (value_lowerLimit == null) break block33;
                            try {
                                lowerLimit = value_lowerLimit.getUint32();
                                break block33;
                            }
                            catch (MCDException mcde) {
                                this.logger.debug("Error getting UINT32 value of LOWER-LIMIT of text table element with index " + i + ".");
                                this.logger.logThrowable(mcde);
                            }
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting value of LOWER-LIMIT of text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                        }
                        break block32;
                    }
                    try {
                        value_upperLimit = this.getUpperLimitFromInterval(interval);
                        if (upperLimitDataType == -1) {
                            try {
                                upperLimitDataType = value_upperLimit.getDataType();
                            }
                            catch (MCDException mcde) {
                                this.logger.debug("Error getting data type of value of UPPER-LIMIT of text table element with index " + i + ".");
                                this.logger.logThrowable(mcde);
                                break block32;
                            }
                            if (upperLimitDataType != 11) {
                                this.logger.error("The data type of value of UPPER-LIMIT (" + McdEnumDecoder.decodeMcdDataType(upperLimitDataType) + ") of the text table element with index " + i + " does not match the expected data type " + McdEnumDecoder.decodeMcdDataType(11) + "!");
                                return null;
                            }
                        }
                        if (value_upperLimit == null) break block34;
                        try {
                            upperLimit = value_upperLimit.getUint32();
                            break block34;
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting UINT32 value of UPPER-LIMIT of text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                        }
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error getting value of UPPER-LIMIT of text table element with index " + i + ".");
                        this.logger.logThrowable(mcde);
                    }
                    break block32;
                }
                if ((lowerLimitIntervalType == 27907 || lowerLimitIntervalType == 27905 && pCodedValueUint32 > lowerLimit || lowerLimitIntervalType == 27906 && pCodedValueUint32 >= lowerLimit) && (upperLimitIntervalType == 27907 || upperLimitIntervalType == 27905 && pCodedValueUint32 < upperLimit || upperLimitIntervalType == 27906 && pCodedValueUint32 <= upperLimit)) {
                    foundMatch = true;
                    break;
                }
            }
            ++i;
        }
        if (!foundMatch) {
            if (textTableElementOfCompuDefaultValue != null) {
                this.logger.debug("No match found... returning COMPU-DEFAULT-VALUE.");
                return textTableElementOfCompuDefaultValue;
            }
            return null;
        }
        this.logger.trace("Leaving getTextTableElementByCodedValueUint32(...).");
        return textTableElement;
    }

    public MCDTextTableElement getTextTableElementOfParameterByLongName(MCDParameter pParameter, String pLongName) {
        MCDTextTableElement textTableElement;
        block13: {
            int parameterType = 0;
            MCDRequestParameterImp requestParameter = null;
            MCDResponseParameterImp responseParameter = null;
            textTableElement = null;
            this.logger.trace("Entering getTextTableElementOfParameterByLongName(...).");
            try {
                parameterType = pParameter.getType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting type of parameter.");
                this.logger.logThrowable(mcde);
                return null;
            }
            if (parameterType != 18 && parameterType != 25 && parameterType != 14) {
                throw new IllegalArgumentException("getTextTableElementOfParameterByLongName() may only be called or parameters of type eTEXTTABLE/eKEY/eA_UNICODE2STRING!");
            }
            try {
                if (pParameter instanceof MCDRequestParameter) {
                    requestParameter = (MCDRequestParameterImp)pParameter;
                    try {
                        textTableElement = requestParameter.getTextTableElement();
                        break block13;
                    }
                    catch (Exception e) {
                        this.logger.debug("Error getting text table element of parameter.");
                        this.logger.logThrowable(e);
                        return null;
                    }
                }
                if (!(pParameter instanceof MCDResponseParameter)) break block13;
                responseParameter = (MCDResponseParameterImp)pParameter;
                try {
                    textTableElement = responseParameter.getTextTableElement();
                }
                catch (Exception e) {
                    this.logger.debug("Error getting text table element of parameter.");
                    if (e instanceof MCDException) {
                        MCDException mcde = (MCDException)((Object)e);
                        MCDError error = mcde.getError();
                        if (error.getCode() != 57362) {
                            this.logger.logThrowable(e);
                        }
                    } else {
                        this.logger.logThrowable(e);
                    }
                    return null;
                }
            }
            catch (ClassCastException cce) {
                this.logger.debug("Error casting parameter to implementation class!");
                this.logger.logThrowable(cce);
                return null;
            }
        }
        this.logger.trace("Leaving getTextTableElementOfParameterByLongName(...).");
        return textTableElement;
    }

    public MCDTextTableElements getTextTableElementsOfDbResponseParameter(MCDDbResponseParameter pDbResponseParameter) {
        MCDDbResponseParameterImp dbResponseParameter = null;
        MCDTextTableElements textTableElements = null;
        this.logger.trace("Entering getTextTableElementsOfDbResponseParameter(...).");
        try {
            dbResponseParameter = (MCDDbResponseParameterImp)pDbResponseParameter;
        }
        catch (ClassCastException cce) {
            this.logger.debug("Error casting parameter to implementation class!");
            this.logger.logThrowable(cce);
            return null;
        }
        try {
            textTableElements = dbResponseParameter.getTextTableElements();
        }
        catch (Exception e) {
            this.logger.debug("Error getting text table elements of data base parameter!");
            this.logger.logThrowable(e);
        }
        this.logger.trace("Leaving getTextTableElementsOfDbResponseParameter(...).");
        return textTableElements;
    }

    public String pduValue2String(MCDValue pPduValue) throws MCDException {
        return Conversions.byteArray2String(pPduValue.getBytefield());
    }

    protected final boolean determineDbIdentDescriptionMethods() {
        this.logger.trace("Entering determineDbIdentDescriptionMethods()...");
        try {
            this.getDbDataPrimitiveMethod = MCDDbIdentDescription.class.getMethod("getDbDataPrimitiveByLocation", MCDDbLocation.class);
            this.logger.debug("Found MCDDbIdentDescription.getDbDataPrimitiveByLocation( MCDDbLocation ) matching the MCD3D 3.0.0 interface.");
            if (!this.getDbDataPrimitiveMethod.isAccessible()) {
                this.logger.debug("MCDDbIdentDescription.getDbDataPrimitiveByLocation( MCDDbLocation ) is not accessible - enabling access...");
                this.getDbDataPrimitiveMethod.setAccessible(true);
            }
            this.isMcd300Interface = true;
        }
        catch (NoSuchMethodException nsme) {
            this.logger.debug("MCDDbIdentDescription.getDbDataPrimitiveByLocation( MCDDbLocation ) was not found => MCD version must be 2.00.xx.");
            try {
                this.getDbDataPrimitiveMethod = MCDDbIdentDescriptionImp.class.getMethod("getDbDataPrimitive", MCDDbLocation.class);
                this.logger.debug("Found MCDDbIdentDescriptionImp.getDbDataPrimitive( MCDDbLocation ) matching the proprietary MCD3D 2.00.02 interface of PRODIS.MCD 2.x.x.");
                if (!this.getDbDataPrimitiveMethod.isAccessible()) {
                    this.logger.debug("MCDDbIdentDescriptionImp.getDbDataPrimitive( MCDDbLocation ) is not accessible - enabling access...");
                    this.getDbDataPrimitiveMethod.setAccessible(true);
                }
            }
            catch (NoSuchMethodException nsme2) {
                this.logger.logThrowable(nsme2);
                this.logger.fatal("MCD interface is inconsistent!");
                return false;
            }
        }
        try {
            this.getDbResponseParameterMethod = MCDDbIdentDescription.class.getMethod("getDbResponseParameter", new Class[0]);
            this.logger.debug("Found MCDDbIdentDescription.getDbResponseParameter() matching the MCD3D 3.0.0 interface.");
            if (!this.getDbResponseParameterMethod.isAccessible()) {
                this.logger.debug("MCDDbIdentDescription.getDbResponseParameter() is not accessible - enabling access...");
                this.getDbResponseParameterMethod.setAccessible(true);
            }
        }
        catch (NoSuchMethodException nsme) {
            this.logger.debug("MCDDbIdentDescription.getDbResponseParameter() was not found => MCD version must be 2.00.xx.");
            try {
                this.getDbResponseParameterMethod = MCDDbIdentDescriptionImp.class.getMethod("getDbResponseParameter", MCDDbLocation.class);
                this.logger.debug("Found MCDDbIdentDescriptionImp.getDbResponseParameter( MCDDbLocation ) matching the proprietary MCD3D 2.00.02 interface of PRODIS.MCD 2.x.x.");
                if (!this.getDbDataPrimitiveMethod.isAccessible()) {
                    this.logger.debug("MCDDbIdentDescriptionImp.getDbResponseParameter( MCDDbLocation ) is not accessible - enabling access...");
                    this.getDbResponseParameterMethod.setAccessible(true);
                }
            }
            catch (NoSuchMethodException nsme2) {
                this.logger.logThrowable(nsme2);
                this.logger.fatal("MCD interface is inconsistent!");
                return false;
            }
        }
        this.logger.trace("Leaving determineDbIdentDescriptionMethods()...");
        return true;
    }

    protected final boolean determineIntervalMethods() {
        this.logger.trace("Entering determineIntervalMethods()...");
        try {
            this.getLowerLimitMethod = MCDIntervalImp.class.getMethod("getLowerLimitAsCodedValue", null);
            this.logger.debug("Found MCDInterval.getLowerLimitAsCodedValue() matching the proprietary MCD3D 2.00.02 interface of PRODIS.MCD 2.x.x.");
            if (!this.getLowerLimitMethod.isAccessible()) {
                this.logger.debug("MCDInterval.getLowerLimitAsCodedValue() is not accessible - enabling access...");
                this.getLowerLimitMethod.setAccessible(true);
            }
        }
        catch (NoSuchMethodException nsme) {
            this.logger.debug("MCDInterval.getLowerLimitAsCodedValue() was not found => MCD version must be 2.00.xx or 3.0.0.");
            this.logger.error("MCD interface is inconsistent!");
            return false;
        }
        try {
            this.getLowerLimitIntervalTypeMethod = MCDIntervalImp.class.getMethod("getCodedLowerLimitIntervalType", null);
            this.logger.debug("Found MCDInterval.getCodedLowerLimitIntervalType() matching the proprietary MCD3D 2.00.02 interface of PRODIS.MCD 2.x.x.");
            if (!this.getLowerLimitIntervalTypeMethod.isAccessible()) {
                this.logger.debug("MCDInterval.getCodedLowerLimitIntervalType() is not accessible - enabling access...");
                this.getLowerLimitIntervalTypeMethod.setAccessible(true);
            }
        }
        catch (NoSuchMethodException nsme) {
            this.logger.debug("MCDInterval.getCodedLowerLimitIntervalType() was not found => MCD version must be 2.00.xx or 3.0.0.");
            this.logger.error("MCD interface is inconsistent!");
            return false;
        }
        try {
            this.getUpperLimitMethod = MCDIntervalImp.class.getMethod("getUpperLimitAsCodedValue", null);
            this.logger.debug("Found MCDInterval.getUpperLimitAsCodedValue() matching the proprietary MCD3D 2.00.02 interface of PRODIS.MCD 2.x.x.");
            if (!this.getUpperLimitMethod.isAccessible()) {
                this.logger.debug("MCDInterval.getUpperLimitAsCodedValue() is not accessible - enabling access...");
                this.getUpperLimitMethod.setAccessible(true);
            }
        }
        catch (NoSuchMethodException nsme) {
            this.logger.debug("MCDInterval.getUpperLimitAsCodedValue() was not found => MCD version must be 2.00.xx or 3.0.0.");
            this.logger.error("MCD interface is inconsistent!");
            return false;
        }
        try {
            this.getUpperLimitIntervalTypeMethod = MCDIntervalImp.class.getMethod("getCodedUpperLimitIntervalType", null);
            this.logger.debug("Found MCDInterval.getCodedUpperLimitIntervalType() matching the proprietary MCD3D 2.00.02 interface of PRODIS.MCD 2.x.x.");
            if (!this.getUpperLimitIntervalTypeMethod.isAccessible()) {
                this.logger.debug("MCDInterval.getCodedUpperLimitIntervalType() is not accessible - enabling access...");
                this.getUpperLimitIntervalTypeMethod.setAccessible(true);
            }
        }
        catch (NoSuchMethodException nsme) {
            this.logger.debug("MCDInterval.getCodedUpperLimitIntervalType() was not found => MCD version must be 2.00.xx or 3.0.0.");
            this.logger.error("MCD interface is inconsistent!");
            return false;
        }
        this.logger.trace("Leaving determineIntervalMethods()...");
        return true;
    }

    protected final boolean determineSetSuppressPositiveResponseUncheckedNSFMethod() {
        this.logger.trace("Entering determineSetSuppressPositiveResponseUncheckedNSFMethod()...");
        try {
            this.setSuppressPositiveResponseUncheckedNSFMethod = MCDServiceImp.class.getMethod("setSuppressPositiveResponseUnchecked_NSF", Boolean.TYPE);
            this.logger.debug("Found MCDService.setSuppressPositiveResponseUnchecked_NSF(...) matching the proprietary MCD3D 3.00.00 interface of VW-MCD.");
            if (!this.setSuppressPositiveResponseUncheckedNSFMethod.isAccessible()) {
                this.logger.debug("MCDService.setSuppressPositiveResponseUnchecked_NSF(...) is not accessible - enabling access...");
                this.setSuppressPositiveResponseUncheckedNSFMethod.setAccessible(true);
            }
        }
        catch (NoSuchMethodException nsme) {
            this.logger.debug("MCDService.setSuppressPositiveResponseUnchecked_NSF(...) was not found => MCD version must be 2.00.xx.");
            return false;
        }
        this.logger.trace("Leaving determineSetSuppressPositiveResponseUncheckedNSFMethod()...");
        return true;
    }

    public void setSuppressPositiveResponseUnchecked(MCDService pMCDService) {
        this.logger.trace("Entering setSuppressPositiveResponseUnchecked(...)");
        if (!this.supportsSetSuppressPositiveResponseUnchecked()) {
            super.setSuppressPositiveResponseUnchecked(pMCDService);
        } else {
            MCDServiceImp service = null;
            try {
                service = (MCDServiceImp)pMCDService;
            }
            catch (ClassCastException cce) {
                this.logger.debug("Error casting MCDService to MCDServiceImp!");
                this.logger.logThrowable(cce);
                throw (UnsupportedOperationException)new UnsupportedOperationException("Error setting the SPR flag!").initCause(cce);
            }
            try {
                try {
                    this.setSuppressPositiveResponseUncheckedNSFMethod.invoke((Object)service, Boolean.TRUE);
                }
                catch (InvocationTargetException ite) {
                    this.logger.error("Error setting SPR flag for service.");
                    this.logger.logThrowable(ite);
                    throw (UnsupportedOperationException)new UnsupportedOperationException("Error setting the SPR flag!").initCause(ite);
                }
                catch (IllegalArgumentException iare) {
                    this.logger.error("Error setting SPR flag for service.");
                    this.logger.logThrowable(iare);
                    throw (UnsupportedOperationException)new UnsupportedOperationException("Error setting the SPR flag!").initCause(iare);
                }
                catch (IllegalAccessException iace) {
                    this.logger.error("Error setting SPR flag for service.");
                    this.logger.logThrowable(iace);
                    throw (UnsupportedOperationException)new UnsupportedOperationException("Error setting the SPR flag!").initCause(iace);
                }
            }
            catch (Exception e) {
                this.logger.error("Error setting SPR flag for service.");
                this.logger.logThrowable(e);
                throw (UnsupportedOperationException)new UnsupportedOperationException("Error setting the SPR flag!").initCause(e);
            }
        }
        this.logger.trace("Leaving setSuppressPositiveResponseUnchecked(...)");
    }

    public boolean supportsSetSuppressPositiveResponseUnchecked() {
        this.logger.trace("Entering supportsSetSuppressPositiveResponseUnchecked()");
        if (!this.isMcd300Interface) {
            return false;
        }
        if (this.setSuppressPositiveResponseUncheckedNSFMethod == null) {
            return false;
        }
        this.logger.trace("Leaving supportsSetSuppressPositiveResponseUnchecked()");
        return true;
    }
}

