/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.uds.jobs.mcd201;

import asam.d.MCDAccessKey;
import asam.d.MCDControlPrimitive;
import asam.d.MCDDataPrimitive;
import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDataPrimitives;
import asam.d.MCDDbDiagService;
import asam.d.MCDDbDiagServices;
import asam.d.MCDDbEcuBaseVariant;
import asam.d.MCDDbEcuBaseVariants;
import asam.d.MCDDbFunctionalGroup;
import asam.d.MCDDbLocations;
import asam.d.MCDDbRequest;
import asam.d.MCDDbRequestParameter;
import asam.d.MCDDbRequestParameters;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDErrors;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDProtocolParameterSet;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDService;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDStartCommunication;
import asam.d.MCDStopCommunication;
import asam.d.MCDTextTableElement;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary2.jobs.AbstractJob;
import com.audi.mcd.joblibrary2.jobs.impl.AbstractSingleEcuJobImpl;
import com.audi.mcd.joblibrary2.util.Conversions;
import com.audi.mcd.joblibrary2.util.DateTime;
import com.audi.mcd.joblibrary2.util.McdEnumDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MCD3_StartCommu
extends AbstractSingleEcuJobImpl {
    private static final String REVISION = "1.0.20141103";
    protected static final String[] REQUIRED_DIAG_COMMS = new String[]{"SinglJob_WriteFinge"};
    protected static int instances = 0;
    protected static int nextInstance = 0;
    protected int instance;
    protected String jobResult = null;
    protected String jobCompletionStatus = null;
    protected boolean isModifyTimingEnabled = false;
    protected boolean isSubSystemSupportingCommunicationControl = false;
    protected MCDDataPrimitive currentDataPrimitive = null;
    protected MCDService currentService = null;
    protected MCDControlPrimitive controlPrimitive = null;
    protected MCDJob writeFingerprint = null;
    protected long savedNumberOfErrorRepetitions = 0L;
    protected MCDProtocolParameterSet protocolParameterSet = null;
    protected String startCommunicationServiceShortName = null;
    protected String[] startCommunicationRequestParameterNames = null;
    protected String[] startCommunicationRequestParameterValues = null;
    protected String fingerprintType = null;
    protected int vwDeviceNumber = 0x1FFFFF;
    protected short importerNumber = (short)1023;
    protected int workshopNumber = 99999;
    protected byte year = 0;
    protected byte month = 0;
    protected byte day = 0;
    protected String dbLogicalLinkShortName = null;
    protected boolean targetEcuIsBdm = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCD3_StartCommu() {
        super(REVISION);
        Class clazz = MCD3_StartCommu.class;
        synchronized (clazz) {
            this.instance = nextInstance++;
            ++instances;
        }
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        this.jobStatus = this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, pJob);
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("prepareJob successful - executing job logic...");
            this.jobCompletionStatus = this.executeJobLogicGuarded();
        }
        if (this.jobStatus == AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS) {
            throw new NullPointerException("At least one of the call parameters of the job is null!");
        }
        this.finalizeJobGuarded();
        this.logger.trace("Leaving execute(...).");
    }

    protected AbstractJob.JobStatus prepareJobGuarded(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        try {
            currentJobStatus = this.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pJob);
        }
        catch (Exception e) {
            this.logger.debug("Caught exception in prepareJob() method.");
            this.logger.logThrowable(e);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught throwable in prepareJob() method.");
            this.logger.logThrowable(t);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareJob(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) throws MCDException {
        this.jobStatus = super.prepareJob(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pJob);
        this.jobResult = "FALSE";
        this.jobCompletionStatus = "Job aborted due to fatal errors";
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        if (this.dbEcuName.startsWith("BV_BatteDiagnModul") && !this.dbEcuName.startsWith("BV_BatteDiagnModulIdent")) {
            this.targetEcuIsBdm = true;
        }
        try {
            this.dbLogicalLinkShortName = this.logicalLink.getDbObject().getShortName();
            this.logger.debug("SHORT-NAME of dbLogicalLink: " + this.dbLogicalLinkShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of LOGICAL-LINK.");
        }
        this.jobStatus = this.readInputParameters(pRequestParameters);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        if (this.dbLocationTypeOfLogicalLink == 1162) {
            this.logger.info("The database location " + this.dbLocationAccessKey + " is a FUNCTIONAL-GROUP.");
            if (this.fingerprintType != "no fingerprint") {
                this.logger.warn("No fingerprint will be written since functional addressing does NOT support segmented messages!");
                this.fingerprintType = "no fingerprint";
            }
            MCDDbFunctionalGroup dbFunctionalGroup = (MCDDbFunctionalGroup)this.dbLocationOfLogicalLink.getDbECU();
            MCDDbEcuBaseVariants baseVariants = dbFunctionalGroup.getGroupMembers();
            this.logger.debug("The FUNCTIONAL-GROUP \"" + dbFunctionalGroup.getShortName() + "\" has " + baseVariants.getCount() + " members.");
            int i = 0;
            while ((long)i < baseVariants.getCount()) {
                MCDDbEcuBaseVariant dbEcubaseVariant = baseVariants.getItemByIndex((long)i);
                MCDDbLocations dbLocations = dbEcubaseVariant.getDbLocations();
                this.logger.debug("The BASE-VARIANT " + dbEcubaseVariant.getShortName() + " has " + dbLocations.getCount() + " database locations.");
                int j = 0;
                while ((long)j < dbLocations.getCount()) {
                    String accessKey = dbLocations.getItemByIndex((long)j).getAccessKey().getString();
                    this.logger.debug("- " + accessKey);
                    ++j;
                }
                ++i;
            }
        }
        this.jobStatus = this.checkRequiredDiagComms(REQUIRED_DIAG_COMMS);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.jobStatus = this.checkRequiredDiagComms(new String[]{this.startCommunicationServiceShortName});
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        if (!this.fingerprintType.equals("no fingerprint")) {
            try {
                this.dbLocationOfLogicalLink.getDbJobs().getItemByName("SinglJob_WriteFinge");
            }
            catch (MCDException mcde) {
                this.fingerprintType = "no fingerprint";
            }
        }
        this.isSubSystemSupportingCommunicationControl = this.isSubSystemSupportingCommunicationControl();
        if (this.isSubSystemSupportingCommunicationControl) {
            this.fingerprintType = "no fingerprint";
        }
        this.logger.debug("Preparing protocol parameter set.");
        try {
            this.jobStatus = this.prepareProtocolParameterSet();
            if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
                return this.jobStatus;
            }
        }
        catch (MCDException mcde) {
            this.logger.debug("Error preparing protocol parameter set.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.ERROR;
        }
        if (!this.isPduApiUsed) {
            this.logger.debug("Preparing global control primitives.");
            try {
                this.stopCommunication = this.stopCommunication(this.logicalLink);
                this.startCommunication = this.startCommunication(this.logicalLink);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating MCDStop/StartCommunication.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving prepareJob(...).");
        return this.jobStatus;
    }

    protected String executeJobLogicGuarded() {
        String currentJobCompletionStatus = null;
        this.logger.trace("Entering executeJobLogicGuarded(...).");
        try {
            currentJobCompletionStatus = !this.targetEcuIsBdm ? this.executeJobLogic() : this.executeJobLogicBdm();
        }
        catch (MCDException mcde) {
            this.logger.debug("Caught MCD exception in executeJobLogic() method.");
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Exception e) {
            this.logger.debug("Caught exception in executeJobLogic() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Throwable t) {
            this.logger.debug("Caught throwable in executeJobLogic() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        this.logger.trace("Leaving executeJobLogicGuarded(...).");
        return currentJobCompletionStatus;
    }

    protected String executeJobLogic() throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        JobStep currentJobStep = JobStep.values[0];
        this.logger.trace("Entering executeJobLogic(...).");
        while (currentJobStep.compareTo(JobStep.DONE) < 0 && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            if (currentJobStep == JobStep.SWITCH_TO_FUNCTIONAL_ADDRESSING) {
                if (this.isSubSystemSupportingCommunicationControl) {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Functional");
                    }
                    currentJobStep = JobStep.EXECUTE_START_COMMUNICATION_PRIMITIVE;
                    continue;
                }
                currentJobStep = JobStep.PREPARE_JOBS;
                continue;
            }
            if (currentJobStep == JobStep.PREPARE_JOBS) {
                if (!this.fingerprintType.equals("no fingerprint")) {
                    this.writeFingerprint = this.writeFingerprint(this.logicalLink, this.logger.getLogLevel(), this.fingerprintType, this.vwDeviceNumber, this.importerNumber, this.workshopNumber, this.year, this.month, this.day);
                }
                currentJobStep = JobStep.EXECUTE_START_COMMUNICATION_PRIMITIVE;
                continue;
            }
            if (currentJobStep == JobStep.EXECUTE_START_COMMUNICATION_PRIMITIVE) {
                this.logger.debug("SHORT-NAME of dbEcu: " + this.dbEcuName);
                this.currentDataPrimitive = this.isSubSystemSupportingCommunicationControl() ? this.diagnosticSessionControl(this.logicalLink, Boolean.TRUE, "Extended Diagnostic Session", true) : this.startCommunicationDataPrimitive(this.logicalLink, this.startCommunicationRequestParameterNames, this.startCommunicationRequestParameterValues);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentDataPrimitive, 1, true);
                this.setJobProgress(50L);
                currentJobStep = JobStep.WRITE_FINGERPRINT;
                continue;
            }
            if (currentJobStep == JobStep.WRITE_FINGERPRINT) {
                if (!this.fingerprintType.equals("no fingerprint")) {
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.writeFingerprint, 1, true);
                }
                this.setJobProgress(80L);
                currentJobStep = JobStep.ENABLE_SUBNET_ROUTING;
                continue;
            }
            if (currentJobStep == JobStep.ENABLE_SUBNET_ROUTING) {
                if (this.isSubSystemSupportingCommunicationControl) {
                    this.currentService = this.communicationControl(this.logicalLink, Boolean.TRUE, "Enable Subnet Routing", "Normal Communication Messages", "Main Network", null);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                }
                this.setJobProgress(85L);
                currentJobStep = JobStep.ENABLE_RX_AND_DISABLE_TX_WITH_ENHANCED_ADDRESS_INFORMATION;
                continue;
            }
            if (currentJobStep == JobStep.ENABLE_RX_AND_DISABLE_TX_WITH_ENHANCED_ADDRESS_INFORMATION) {
                if (this.isSubSystemSupportingCommunicationControl) {
                    this.currentService = this.communicationControl(this.logicalLink, Boolean.TRUE, "Enable Rx And Disable Tx With Enhanced Address Information", "Normal Communication Messages", "Main Network", null);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                }
                this.setJobProgress(90L);
                currentJobStep = JobStep.SWITCH_TO_PHYSICAL_ADDRESSING;
                continue;
            }
            if (currentJobStep == JobStep.SWITCH_TO_PHYSICAL_ADDRESSING) {
                if (this.isSubSystemSupportingCommunicationControl && this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                }
                currentJobStep = JobStep.DONE;
                continue;
            }
            if (currentJobStep == JobStep.DONE) continue;
            this.logger.error("*** UNKNOWN job step ***: " + currentJobStep);
        }
        this.logger.debug("Final job status: " + currentJobStatus);
        this.jobStatus = currentJobStatus;
        this.setJobProgress(100L);
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobResult = "TRUE";
            this.jobCompletionStatus = "Job completed successfully";
        } else if (this.jobStatus == AbstractJob.JobStatus.ERROR_WRITING_FINGERPRINT) {
            this.jobResult = "TRUE";
            this.jobCompletionStatus = "Job completed with warnings";
        }
        this.logger.trace("Leaving executeJobLogic(...).");
        return this.jobCompletionStatus;
    }

    protected String executeJobLogicBdm() throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        JobStep currentJobStep = JobStep.values[0];
        this.logger.trace("Entering executeJobLogicBdm(...).");
        while (currentJobStep.compareTo(JobStep.DONE) < 0 && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            if (currentJobStep == JobStep.PREPARE_JOBS) {
                if (!this.fingerprintType.equals("no fingerprint")) {
                    this.writeFingerprint = this.writeFingerprint(this.logicalLink, this.logger.getLogLevel(), this.fingerprintType, this.vwDeviceNumber, this.importerNumber, this.workshopNumber, this.year, this.month, this.day);
                }
                currentJobStep = JobStep.SWITCH_GATEWAY_TO_EXTENDED_SESSION;
                continue;
            }
            if (currentJobStep == JobStep.SWITCH_GATEWAY_TO_EXTENDED_SESSION) {
                if (this.isPduApiUsed) {
                    if (this.dbLogicalLinkShortName.indexOf("Ident") == -1) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanPhysReqFormat", "normal segmented 11-bit transmit with FC");
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanRespUSDTFormat", "normal segmented 11-bit receive with FC");
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanPhysReqId", 1808L);
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanRespUSDTId", 1914L);
                    }
                    this.currentDataPrimitive = this.diagnosticSessionControl(this.logicalLink, Boolean.FALSE, "Extended Diagnostic Session", false);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentDataPrimitive, 1, true);
                    if (currentJobStatus == AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION) {
                        currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                        if (this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_TesterPresentHandling", "Disabled");
                        } else {
                            this.setProtocolParameterValue(this.protocolParameterSet, "TesterPresentHandling", "no TesterPresentMessage");
                        }
                        currentJobStep = JobStep.SWITCH_ADDRESSING_INFORMATION_TO_BDM;
                    } else {
                        currentJobStep = JobStep.WRITE_FINGERPRINT;
                    }
                } else {
                    currentJobStep = JobStep.WRITE_FINGERPRINT;
                }
                this.setJobProgress(20L);
                continue;
            }
            if (currentJobStep == JobStep.WRITE_FINGERPRINT) {
                if (this.isPduApiUsed && !this.fingerprintType.equals("no fingerprint")) {
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.writeFingerprint, 1, true);
                }
                this.setJobProgress(40L);
                currentJobStep = JobStep.ENABLE_SUBNET_ROUTING;
                continue;
            }
            if (currentJobStep == JobStep.ENABLE_SUBNET_ROUTING) {
                if (this.isPduApiUsed) {
                    this.currentDataPrimitive = this.writeDataByIdentifierCalibrationData(this.logicalLink, "switch lin flash mode");
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentDataPrimitive, 1, true);
                }
                this.setJobProgress(60L);
                currentJobStep = JobStep.SWITCH_ADDRESSING_INFORMATION_TO_BDM;
                continue;
            }
            if (currentJobStep == JobStep.SWITCH_ADDRESSING_INFORMATION_TO_BDM) {
                if (this.dbLogicalLinkShortName.indexOf("Ident") == -1) {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanPhysReqFormat", "extended segmented 11-bit transmit w/o FC");
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanRespUSDTFormat", "extended segmented 11-bit receive w/o FC");
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanPhysReqId", 1832L);
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanRespUSDTId", 1938L);
                    }
                    currentJobStep = JobStep.EXECUTE_START_COMMUNICATION_PRIMITIVE;
                } else {
                    currentJobStep = JobStep.DONE;
                }
                this.setJobProgress(80L);
                continue;
            }
            if (currentJobStep == JobStep.EXECUTE_START_COMMUNICATION_PRIMITIVE) {
                this.currentDataPrimitive = this.startCommunicationDataPrimitive(this.logicalLink, this.startCommunicationRequestParameterNames, this.startCommunicationRequestParameterValues);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentDataPrimitive, 1, true);
                this.setJobProgress(90L);
                currentJobStep = JobStep.DONE;
                continue;
            }
            if (currentJobStep == JobStep.DONE) continue;
            this.logger.error("*** UNKNOWN job step ***: " + currentJobStep);
        }
        this.logger.debug("Final job status: " + currentJobStatus);
        this.jobStatus = currentJobStatus;
        this.setJobProgress(100L);
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobResult = "TRUE";
            this.jobCompletionStatus = "Job completed successfully";
        } else if (this.jobStatus == AbstractJob.JobStatus.ERROR_WRITING_FINGERPRINT) {
            this.jobResult = "TRUE";
            this.jobCompletionStatus = "Job completed with warnings";
        }
        this.logger.trace("Leaving executeJobLogicBdm(...).");
        return this.jobCompletionStatus;
    }

    protected void finalizeJobGuarded() {
        this.logger.trace("Entering finalizeJobGuarded(...).");
        try {
            this.finalizeJob();
        }
        catch (Exception e) {
            this.logger.debug("Caught exception in finalizeJob() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught throwable in finalizeJob() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving finalizeJobGuarded(...).");
    }

    protected void finalizeJob() {
        this.logger.trace("Entering finalizeJob(...).");
        if (this.jobResult.equalsIgnoreCase("TRUE")) {
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        } else if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        super.finalizeJob();
        this.logger.finalize(this.getCurrentJobRuntimeAsString());
    }

    protected void addOutputParameters(MCDResponse pResponse, Map pOutputParameters) {
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        this.logger.trace("Entering addOutputParameters(...).");
        if (pResponse == null) {
            this.logger.error("addResponse() called with null argument!");
        } else {
            try {
                responseParameters = pResponse.getResponseParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response parameters from response.");
                this.logger.logThrowable(mcde);
            }
            if (responseParameters != null) {
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                }
                if (!pOutputParameters.keySet().isEmpty()) {
                    for (long l = 0L; l < numberOfResponseParameters; ++l) {
                    }
                }
            }
        }
        this.logger.trace("Leaving addOutputParameters(...).");
    }

    protected void sendFinalResult(MCDResult pResult) {
        this.logger.trace("Entering sendFinalResult(...).");
        if (pResult == null) {
            this.logger.error("sendResult() called with null argument!");
        } else {
            this.logger.debug("Sending final job result.");
            try {
                this.jobApi.sendFinalResult(pResult);
            }
            catch (MCDException mcde) {
                this.logger.error("Error sending final job result.");
                this.logger.logThrowable(mcde);
            }
        }
        this.logger.trace("Leaving sendFinalResult(...).");
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int numberOfInputParameters = 0;
        int numberOfRequestParameters = 0;
        MCDRequestParameter inputParameter = null;
        MCDRequestParameters nestedParameters = null;
        String inputParameterName = null;
        int logLevel = -1;
        this.logger.trace("Entering readInputParameters(...).");
        try {
            numberOfInputParameters = (int)pRequestParameters.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining number of job input parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Number of INPUT-PARAMETERS to read: " + numberOfInputParameters);
        for (long i = 0L; i < (long)numberOfInputParameters; ++i) {
            try {
                inputParameter = pRequestParameters.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                inputParameterName = inputParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting SHORT-NAME of job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (inputParameterName.equals("IPA_LogLevel")) {
                try {
                    logLevel = (int)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"IPA_LogLevel\" - defaulting to LOG_TRACE.");
                    this.logger.logThrowable(mcde);
                    logLevel = 0;
                }
                logLevel &= 7;
                if (this.logger.isConfiguredByPropertiesFile()) {
                    this.logger.debug("Ignoring " + inputParameterName + " since logger has already been configured by properties file.");
                    continue;
                }
                if (logLevel <= 0) continue;
                this.logger.init(this.dbEcuName, logLevel);
                continue;
            }
            if (inputParameterName.equals("IPA_StartCommuDIAGCOMM")) {
                try {
                    this.startCommunicationServiceShortName = inputParameter.getValue().getValueAsString();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getValueAsString());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"IPA_StartCommuDIAGCOMM\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_RequeParam")) {
                try {
                    numberOfRequestParameters = (int)inputParameter.getParameters().getCount();
                    if (numberOfRequestParameters > 0) {
                        this.startCommunicationRequestParameterNames = new String[numberOfRequestParameters];
                        this.startCommunicationRequestParameterValues = new String[numberOfRequestParameters];
                    }
                    for (int j = 0; j < numberOfRequestParameters; ++j) {
                        this.startCommunicationRequestParameterNames[j] = inputParameter.getParameters().getItemByIndex((long)j).getShortName();
                        this.startCommunicationRequestParameterValues[j] = inputParameter.getParameters().getItemByIndex((long)j).getValue().getValueAsString();
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\"[" + j + "] has request parameter name \"" + this.startCommunicationRequestParameterNames[j] + "\" and value: \"" + this.startCommunicationRequestParameterValues[j] + "\".");
                    }
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting values of job input parameter \"IPA_StartCommuDIAGCOMM\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_FingeType")) {
                try {
                    this.fingerprintType = inputParameter.getValue().getValueAsString();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getValueAsString());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"IPA_FingeType\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_RepaiShopCodeOrTesteSeriaNumbe")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"IPA_RepaiShopCodeOrTesteSeriaNumbe\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters);
                continue;
            }
            if (inputParameterName.equals("IPA_ProgrDate")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"IPA_ProgrDate\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters);
                continue;
            }
            if (inputParameterName.equals("Param_VWDevicNumbe")) {
                if (this.vwDeviceNumber != 0x1FFFFF) continue;
                try {
                    this.vwDeviceNumber = (int)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"Param_VWDevicNumbe\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_ImporNumbe")) {
                if (this.importerNumber != 1023) continue;
                try {
                    this.importerNumber = (short)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"Param_ImporNumbe\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_WorksNumbe")) {
                if (this.workshopNumber != 99999) continue;
                try {
                    this.workshopNumber = (int)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"Param_WorksNumbe\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RepaiShopCodeOrTesteSeriaNumbe")) continue;
            if (inputParameterName.equals("Param_Year")) {
                if (this.year != 0) continue;
                try {
                    this.year = (byte)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting value of job input parameter \"Param_Year\".");
                    this.logger.logThrowable(mcde);
                    this.logger.warn("Using value from current system date for setting \"Param_Year\".");
                    this.year = (byte)(DateTime.calendar.get(1) % 100);
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has been set to: " + this.year);
                }
                continue;
            }
            if (inputParameterName.equals("Param_Month")) {
                if (this.month != 0) continue;
                try {
                    this.month = (byte)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting value of job input parameter \"Param_Month\".");
                    this.logger.logThrowable(mcde);
                    this.logger.warn("Using value from current system date for setting \"Param_Month\".");
                    this.month = (byte)(1 + DateTime.calendar.get(2));
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has been set to: " + this.month);
                }
                continue;
            }
            if (inputParameterName.equals("Param_Day")) {
                if (this.day != 0) continue;
                try {
                    this.day = (byte)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting value of job input parameter \"Param_Day\".");
                    this.logger.logThrowable(mcde);
                    this.logger.warn("Using value from current system date for setting \"Param_Day\".");
                    this.day = (byte)DateTime.calendar.get(5);
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has been set to: " + this.day);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_VWDevicNumbe")) {
                if (this.vwDeviceNumber != 0x1FFFFF) continue;
                try {
                    this.vwDeviceNumber = (int)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"Param_VWDevicNumbe\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_ImporNumbe")) {
                if (this.importerNumber != 1023) continue;
                try {
                    this.importerNumber = (short)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"Param_ImporNumbe\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_WorksNumbe")) {
                if (this.workshopNumber != 99999) continue;
                try {
                    this.workshopNumber = (int)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"Param_WorksNumbe\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_Year")) {
                if (this.year != 0) continue;
                try {
                    this.year = (byte)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting value of job input parameter \"Param_Year\".");
                    this.logger.logThrowable(mcde);
                    this.logger.warn("Using value from current system date for setting \"Param_Year\".");
                    this.year = (byte)(DateTime.calendar.get(1) % 100);
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has been set to: " + this.year);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_Month")) {
                if (this.month != 0) continue;
                try {
                    this.month = (byte)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting value of job input parameter \"Param_Month\".");
                    this.logger.logThrowable(mcde);
                    this.logger.warn("Using value from current system date for setting \"Param_Month\".");
                    this.month = (byte)(1 + DateTime.calendar.get(2));
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has been set to: " + this.month);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_Day")) {
                if (this.day != 0) continue;
                try {
                    this.day = (byte)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting value of job input parameter \"Param_Day\".");
                    this.logger.logThrowable(mcde);
                    this.logger.warn("Using value from current system date for setting \"Param_Day\".");
                    this.day = (byte)DateTime.calendar.get(5);
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has been set to: " + this.day);
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown job input parameter: " + inputParameterName);
        }
        this.logger.trace("Leaving readInputParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus addOutputParameters(MCDResponse pResponse) {
        MCDResponseParameter respParam_jobResult = null;
        MCDResponseParameter respParam_jobCompletionStatus = null;
        MCDResponseParameter respParam_jobMessages = null;
        MCDValue value_jobResult = null;
        MCDValue value_jobCompletionStatus = null;
        this.logger.trace("Entering addOutputParameters(...).");
        this.logger.debug("Retrieving response parameters.");
        try {
            respParam_jobResult = pResponse.getResponseParameters().getItemByName("OPA_CommuStartSucce");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_CommuStartSucce\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobCompletionStatus = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobMessages = pResponse.getResponseParameters().getItemByName("OPA_JobMessa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobMessa\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Retrieving values.");
        try {
            value_jobResult = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting value of job output parameter with SHORT-NAME \"OPA_CommuStartSucce\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_jobCompletionStatus = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting value of job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Setting values.");
        try {
            value_jobResult.setValueAsString(this.jobResult);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of job out parameter with SHORT-NAME \"OPA_CommuStartSucce\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_jobCompletionStatus.setValueAsString(this.jobCompletionStatus);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU did not respond within the timeout period.");
        } else if (this.jobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU returned a negative response.");
        } else if (this.jobStatus == AbstractJob.JobStatus.WRONG_UBATT_DETECTED) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "The voltage on terminal 30 is invalid.");
        } else if (this.jobStatus == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "Communication disturbed (error frames on bus).");
        } else {
            this.addJobMessage(respParam_jobMessages, "static", "Communication started successfully");
        }
        this.addJobMessage(respParam_jobMessages, "dynamic", "Job runtime: " + this.getCurrentJobRuntimeAsString());
        this.logger.debug("Setting output parameters.");
        try {
            respParam_jobResult.setValue(value_jobResult);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameter value of job out parameter with SHORT-NAME \"OPA_CommuStartSucce\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobCompletionStatus.setValue(value_jobCompletionStatus);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameter value of job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving addOutputParameters(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus addJobMessage(MCDResponseParameter pJobMessages, String pMessageType, String pMessage) {
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter respParam_jobMessage = null;
        MCDResponseParameters respParams_messageMuxBranchElements = null;
        MCDResponseParameters respParams_messageMux = null;
        MCDResponseParameter muxBranch = null;
        MCDResponseParameter respParam_messageType = null;
        MCDResponseParameter respParam_message = null;
        MCDValue value_messageType = null;
        MCDValue value_message = null;
        int messageDataType = 255;
        try {
            fieldElements = pJobMessages.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobMessage = fieldElements.addElement();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding job message to collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType = this.getLastResponseParameterOfFieldByName(respParam_jobMessage, "Param_MessaType");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting of nested output parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType.setValueAsString(pMessageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType.setValue(value_messageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = this.getLastResponseParameterOfFieldByName(pJobMessages, "Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMux = respParam_message.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            muxBranch = respParams_messageMux.addMuxBranch(Conversions.longName2ShortName("Case_", pMessageType));
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding branch to multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMuxBranchElements = muxBranch.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer branch of Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = respParams_messageMuxBranchElements.getItemByName("Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameter Param_Messa from multiplexer branch.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_message = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            messageDataType = respParam_message.getType();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining MCD data type of nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("MCDDataType of message: " + McdEnumDecoder.decodeMcdDataType(messageDataType));
        try {
            value_message.setValueAsString(pMessage);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message.setValue(value_message);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected MCDSingleEcuJob writeFingerprint(MCDLogicalLink pLogicalLink, int pLogLevel, String pFingerprintType, long pVwDeviceNumber, short pImporterNumber, long pWorkshopNumber, byte pYear, byte pMonth, byte pDay) throws MCDException {
        MCDSingleEcuJob writeFingerprintTmp = null;
        this.logger.trace("Entering writeFingerprint(...).");
        writeFingerprintTmp = this.createJob(pLogicalLink, "SinglJob_WriteFinge");
        this.setRequestParameter((MCDDiagComPrimitive)writeFingerprintTmp, "IPA_LogLevel", pLogLevel);
        this.setRequestParameter((MCDDiagComPrimitive)writeFingerprintTmp, "IPA_FingeType", pFingerprintType);
        this.setRequestParameter((MCDDiagComPrimitive)writeFingerprintTmp, "Param_VWDevicNumbe", pVwDeviceNumber);
        this.setRequestParameter((MCDDiagComPrimitive)writeFingerprintTmp, "Param_ImporNumbe", pImporterNumber);
        this.setRequestParameter((MCDDiagComPrimitive)writeFingerprintTmp, "Param_WorksNumbe", pWorkshopNumber);
        this.setRequestParameter((MCDDiagComPrimitive)writeFingerprintTmp, "Param_Year", pYear);
        this.setRequestParameter((MCDDiagComPrimitive)writeFingerprintTmp, "Param_Month", pMonth);
        this.setRequestParameter((MCDDiagComPrimitive)writeFingerprintTmp, "Param_Day", pDay);
        this.logger.trace("Leaving writeFingerprint(...).");
        return writeFingerprintTmp;
    }

    protected void setRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, byte pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setRequestParameter(..., byte).");
        this.setRequestParameter(pDiagComPrimitive, pRequestParameterName, new Byte(pValue));
        this.logger.trace("Leaving setRequestParameter(..., byte).");
    }

    protected void setRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, short pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setRequestParameter(..., short).");
        this.setRequestParameter(pDiagComPrimitive, pRequestParameterName, new Short(pValue));
        this.logger.trace("Leaving setRequestParameter(..., short).");
    }

    protected void setRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, int pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setRequestParameter(..., int).");
        this.setRequestParameter(pDiagComPrimitive, pRequestParameterName, new Integer(pValue));
        this.logger.trace("Leaving setRequestParameter(..., int).");
    }

    protected void setRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, long pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setRequestParameter(..., long).");
        this.setRequestParameter(pDiagComPrimitive, pRequestParameterName, new Long(pValue));
        this.logger.trace("Leaving setRequestParameter(..., long).");
    }

    protected void setRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setRequestParameter(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        MCDValue value = requestParameter.createValue();
        switch (value.getDataType()) {
            case 1: 
            case 14: {
                this.setValueString(value, pValue);
                break;
            }
            case 2: {
                this.setValueBitField(value, pValue);
                break;
            }
            case 19: {
                this.setValueBoolean(value, pValue);
                break;
            }
            case 3: {
                this.setValueByteField(value, pValue);
                break;
            }
            case 4: {
                this.setValueFloat32(value, pValue);
                break;
            }
            case 5: {
                this.setValueFloat64(value, pValue);
                break;
            }
            case 7: {
                this.setValueInt32(value, pValue);
                break;
            }
            case 11: {
                this.setValueUint32(value, pValue);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                throw new IllegalArgumentException("Parameter of MCDDataType \"" + McdEnumDecoder.decodeMcdDataType(value.getDataType()) + "\" is not usable in ODX!");
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 255: {
                throw new IllegalArgumentException("Parameter of MCDDataType \"" + McdEnumDecoder.decodeMcdDataType(value.getDataType()) + "\" is not directly assignable!");
            }
            default: {
                throw new IllegalArgumentException("Parameter has unknown MCDDataType: 0x" + Integer.toHexString(value.getDataType()).toUpperCase());
            }
        }
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameter(...).");
    }

    protected void setRequestParameterFromString(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, String pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setRequestParameterFromString(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        MCDValue value = requestParameter.createValue();
        switch (value.getDataType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                value.setValueAsString(pValue);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 255: {
                throw new IllegalArgumentException("Parameter of MCDDataType \"" + McdEnumDecoder.decodeMcdDataType(value.getDataType()) + "\" is not directly assignable!");
            }
            default: {
                throw new IllegalArgumentException("Parameter has unknown MCDDataType: 0x" + Integer.toHexString(value.getDataType()).toUpperCase());
            }
        }
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterFromString(...).");
    }

    private void setValueBitField(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueBitField(...).");
        if (pValue instanceof byte[]) {
            pMcdValue.setBitfield((byte[])pValue);
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_BITFIELD assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueBitField(...).");
    }

    private void setValueBoolean(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueBoolean(...).");
        if (pValue instanceof Boolean) {
            pMcdValue.setBoolean(((Boolean)pValue).booleanValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_BOOLEAN assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueBoolean(...).");
    }

    private void setValueByteField(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueByteField(...).");
        if (pValue instanceof byte[]) {
            pMcdValue.setBytefield((byte[])pValue);
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_BYTEFIELD assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueByteField(...).");
    }

    private void setValueFloat32(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueFloat32(...).");
        if (pValue instanceof Float) {
            pMcdValue.setFloat32(((Float)pValue).floatValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setFloat32(((Double)pValue).floatValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setFloat32(((Long)pValue).floatValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setFloat32(((Integer)pValue).floatValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setFloat32(((Short)pValue).floatValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setFloat32(((Byte)pValue).floatValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_FLOAT32 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueFloat32(...).");
    }

    private void setValueFloat64(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueFloat64(...).");
        if (pValue instanceof Double) {
            pMcdValue.setFloat64(((Double)pValue).doubleValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setFloat64(((Float)pValue).doubleValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setFloat64(((Long)pValue).doubleValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setFloat64(((Integer)pValue).doubleValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setFloat64(((Short)pValue).doubleValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setFloat64(((Byte)pValue).doubleValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_FLOAT64 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueFloat64(...).");
    }

    private void setValueInt32(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueInt32(...).");
        if (pValue instanceof Integer) {
            pMcdValue.setInt32(((Integer)pValue).intValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setInt32(((Byte)pValue).intValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setInt32(((Short)pValue).intValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setInt32(((Long)pValue).intValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setInt32(((Float)pValue).intValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setInt32(((Double)pValue).intValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_INT32 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueInt32(...).");
    }

    private void setValueUint32(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueUint32(...).");
        if (pValue instanceof Long) {
            pMcdValue.setUint32(((Long)pValue).longValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setUint32(((Integer)pValue).longValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setUint32(((Short)pValue).longValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setUint32(((Byte)pValue).longValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setUint32(((Float)pValue).longValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setUint32(((Double)pValue).longValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_UINT32 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueUint32(...).");
    }

    private void setValueString(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueString(...).");
        if (!(pValue instanceof String)) {
            throw new IllegalArgumentException("Invalid object type for eA_UNICODE2STRING assignment: " + pValue.getClass().getName());
        }
        pMcdValue.setValueAsString((String)pValue);
        this.logger.trace("Leaving setValueString(...).");
    }

    protected MCDRequestParameter getRequestParameter(MCDRequestParameters pRequestParameters, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = null;
        MCDError error = null;
        MCDRequestParameter currentRequestParameter = null;
        MCDRequestParameters requestSubParameters = null;
        long numberOfRequestParameters = 0L;
        this.logger.debug("Getting request parameter: " + pRequestParameterName);
        try {
            requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        }
        catch (MCDException mcde) {
            error = mcde.getError();
            if (error.getCode() != 49184 && error.getCode() != 49177) {
                this.logger.debug("Error getting request parameter with SHORT-NAME \"" + pRequestParameterName + "\"!");
                this.logger.logThrowable(mcde);
            }
            numberOfRequestParameters = pRequestParameters.getCount();
            for (long i = 0L; i < numberOfRequestParameters && requestParameter == null; ++i) {
                currentRequestParameter = pRequestParameters.getItemByIndex(i);
                if (currentRequestParameter.getType() != 17) continue;
                requestSubParameters = currentRequestParameter.getParameters();
                requestParameter = this.getRequestParameter(requestSubParameters, pRequestParameterName);
            }
        }
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected MCDRequestParameter getRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive.getRequest().getRequestParameters(), pRequestParameterName);
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected MCDResponseParameter getResponseParameter(MCDResponseParameters pResponseParameters, String pResponseParameterName) throws MCDException {
        this.logger.trace("Entering getResponseParameter(...).");
        MCDResponseParameter responseParameter = null;
        MCDResponseParameter currentResponseParameter = null;
        MCDResponseParameters responseSubParameters = null;
        long numberOfResponseParameters = 0L;
        try {
            responseParameter = pResponseParameters.getItemByName(pResponseParameterName);
        }
        catch (MCDException mcde) {
            if (mcde.getError().getCode() != 49184 && mcde.getError().getCode() != 49177) {
                this.logger.debug("Error getting response parameter with SHORT-NAME \"" + pResponseParameterName + "\"!");
                this.logger.logThrowable(mcde);
            }
            numberOfResponseParameters = pResponseParameters.getCount();
            for (long i = 0L; i < numberOfResponseParameters && responseParameter == null; ++i) {
                currentResponseParameter = pResponseParameters.getItemByIndex(i);
                if (currentResponseParameter.getType() != 17) continue;
                responseSubParameters = currentResponseParameter.getParameters();
                responseParameter = this.getResponseParameter(responseSubParameters, pResponseParameterName);
            }
        }
        this.logger.trace("Leaving getResponseParameter(...).");
        return responseParameter;
    }

    protected MCDResponseParameter getResponseParameter(MCDResponse pResponse, String pResponseParameterName) throws MCDException {
        this.logger.trace("Entering getResponseParameter(...).");
        MCDResponseParameter responseParameter = this.getResponseParameter(pResponse.getResponseParameters(), pResponseParameterName);
        this.logger.trace("Leaving getResponseParameter(...).");
        return responseParameter;
    }

    protected MCDValue getResponseParameterValue(MCDResponse pResponse, String pResponseParameterName) throws MCDException {
        MCDResponseParameter responseParameter = null;
        MCDValue responseParameterValue = null;
        this.logger.trace("Entering getResponseParameterValue(...).");
        responseParameter = this.getResponseParameter(pResponse.getResponseParameters(), pResponseParameterName);
        responseParameterValue = responseParameter.getValue();
        this.logger.trace("Leaving getResponseParameterValue(...).");
        return responseParameterValue;
    }

    protected void updateProtocolParameters(MCDProtocolParameterSet pProtocolParameterSet) {
        MCDResult result = null;
        int diagComprimitiveState = 0;
        this.logger.trace("Entering updateProtocolParameters(...).");
        try {
            result = pProtocolParameterSet.executeSync();
        }
        catch (MCDException mcde) {
            this.logger.error("Error executing MCDProtocolParameterSet.");
            this.logger.logThrowable(mcde);
            return;
        }
        try {
            diagComprimitiveState = pProtocolParameterSet.getState();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining comprimitive state of protocol parameter set.");
            this.logger.logThrowable(mcde);
            return;
        }
        this.logger.info("Current state of protocol parameter set is: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComprimitiveState));
        if (result != null) {
            boolean resultHasError = true;
            try {
                resultHasError = result.hasError();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining if result has an error.");
                this.logger.logThrowable(mcde);
                return;
            }
            if (resultHasError) {
                MCDError error = null;
                this.logger.debug("Error updating protocol parameters: Result has error.");
                try {
                    error = result.getError();
                }
                catch (Exception e) {
                    this.logger.error("Error getting error from result.");
                    this.logger.logThrowable(e);
                    return;
                }
                this.logger.logMcdError(error);
            } else {
                int executionState = -1;
                try {
                    executionState = result.getResultState().getExecutionState();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting execution state from result state.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.debug("Success updating protocol parameters.");
                this.logger.debug("ResultState of MCDProtocolParameterSet: " + McdEnumDecoder.decodeMcdExecutionState(executionState));
            }
        } else {
            MCDErrors errors = null;
            long numberOfErrors = 0L;
            MCDError error = null;
            this.logger.debug("Error updating protocol parameters: Result is null. This is caused by a DTS bug.");
            try {
                errors = pProtocolParameterSet.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting errors from MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            try {
                numberOfErrors = errors.getCount();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining number of errors of MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = errors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + " from MCDProtocolParameterSet.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving updateProtocolParameters(...).");
    }

    protected AbstractJob.JobStatus updateSessionTimings(MCDProtocolParameterSet pProtocolParameterSet, long pStandTiminP2Serve, long pExtenTiminP2Serve) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int canTransmissionTime = 0;
        int p2CanServer = 0;
        int p2StarCanServer = 0;
        this.logger.trace("Entering updateSessionTimings(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.isPduApiUsed) {
            if (!this.isModifyTimingEnabled) {
                canTransmissionTime = this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime != null ? (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime) : 150000;
                p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
                p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
                this.logger.debug("Setting P2_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ") from " + p2CanServer + " \u00b5s to " + (pStandTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max, pStandTiminP2Serve * 1000L + (long)canTransmissionTime);
                this.logger.debug("Setting P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") from " + p2StarCanServer + " \u00b5s to " + (pExtenTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star, pExtenTiminP2Serve * 1000L + (long)canTransmissionTime);
            }
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
            this.logger.debug("P2_CAN_Server  (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ")  is now set to " + p2CanServer + " \u00b5s.");
            this.logger.debug("P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") is now set to " + p2StarCanServer + " \u00b5s.");
        } else {
            canTransmissionTime = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ComPar_CANTransTime");
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("Setting P2_CAN_Server (ResponseTimeout) from " + p2CanServer + " ms to " + (pStandTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "ResponseTimeout", pStandTiminP2Serve + (long)canTransmissionTime);
            this.logger.debug("Setting P2*_CAN_Server (RC78ResponseTimeout) from " + p2StarCanServer + " ms to " + (pExtenTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "RC78ResponseTimeout", pExtenTiminP2Serve + (long)canTransmissionTime);
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("P2_CAN_Server  (ResponseTimeout)     is now set to " + p2CanServer + " ms.");
            this.logger.debug("P2*_CAN_Server (RC78ResponseTimeout) is now set to " + p2StarCanServer + " ms.");
        }
        this.logger.trace("Leaving updateSessionTimings(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareProtocolParameterSet() throws MCDException {
        MCDRequestParameter reqParam = null;
        MCDValue paramValue = null;
        String modifyTiming = null;
        this.logger.trace("Entering prepareProtocolParameterSet(...).");
        this.protocolParameterSet = (MCDProtocolParameterSet)this.logicalLink.createDiagComPrimitiveByType(1193);
        this.protocolParameterSet.fetchValuesFromInterface();
        try {
            reqParam = this.protocolParameterSet.getRequest().getRequestParameters().getItemByName("CP_ModifyTiming");
            this.isPduApiUsed = true;
            this.logger.info("Using PDU-API firmware with ISO 22900-2 COMPARAMs.");
            paramValue = reqParam.getValue();
            modifyTiming = paramValue.getValueAsString();
            this.logMessage = "CP_ModifyTiming is set to " + modifyTiming + ": ";
            if (modifyTiming.equals("Enabled")) {
                this.isModifyTimingEnabled = true;
                this.logMessage = this.logMessage + "session timings will be modified automatically by the PDUAPI firmware.";
                this.logger.info(this.logMessage);
            } else {
                this.isModifyTimingEnabled = false;
                this.logMessage = this.logMessage + "session timings will NOT be modified automatically by the PDUAPI firmware.";
                this.logger.info(this.logMessage);
            }
        }
        catch (MCDException mcde) {
            this.isPduApiUsed = false;
            this.logger.info("Using Softing EIDBSS firmware with proprietary COMPARAMs.");
            this.logger.info("Session timings will NOT be modified automatically by the firmware.");
        }
        this.logger.debug("Saving initial COMPARAM values.");
        this.savedNumberOfErrorRepetitions = this.isPduApiUsed ? this.getProtocolParameterUint32(this.protocolParameterSet, "CP_RepeatReqCountApp") : this.getProtocolParameterUint32(this.protocolParameterSet, "NumberOfErrorRepetitions");
        if (this.savedNumberOfErrorRepetitions == -1L) {
            this.logger.debug("Error saving initial COMPARAM values!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving prepareProtocolParameterSet(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus executeDiagComPrimitiveSync(MCDLogicalLink pLogicalLink, MCDDiagComPrimitive pDiagComPrimitive, int pMaxNumberOfRepetitions, boolean pRemoveDiagComPrimitive) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResult result = null;
        int diagComPrimitiveType = -1;
        String diagComPrimitiveName = null;
        MCDValue requestPdu = null;
        int diagComPrimitiveState = -1;
        MCDErrors errors = null;
        this.logger.trace("Entering executeDiagComPrimitiveSync(...).");
        try {
            diagComPrimitiveType = pDiagComPrimitive.getObjectType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining type of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Type of diagComPrimitive: " + McdEnumDecoder.decodeMcdObjectType(diagComPrimitiveType));
        try {
            diagComPrimitiveName = pDiagComPrimitive.getDbObject().getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Name of diagComPrimitive: " + diagComPrimitiveName);
        if (this.logger.getLogLevel() > 0 && (diagComPrimitiveType == 1190 || diagComPrimitiveType == 1198)) {
            try {
                requestPdu = pDiagComPrimitive.getRequest().getPDU();
                this.logger.debug("Request PDU of diagComPrimitive: " + this.vendorSpecific.pduValue2String(requestPdu));
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request PDU of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        int repetitions = pMaxNumberOfRepetitions;
        block22: do {
            this.logger.debug("Executing diagComPrimitive.");
            try {
                --repetitions;
                result = pDiagComPrimitive.executeSync();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error executing diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Getting errors.");
            try {
                errors = pDiagComPrimitive.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting errors of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Handling errors.");
            if (errors == null) {
                this.logger.error("MCDDiagComPrimitive.getErrors() returned null.");
            } else {
                currentJobStatus = this.handleErrors(errors);
            }
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                // empty if block
            }
            this.logger.debug("Determining state of diagComPrimitive.");
            try {
                diagComPrimitiveState = pDiagComPrimitive.getState();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining state of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("State of diagComPrimitive: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComPrimitiveState));
            switch (diagComPrimitiveState) {
                case 25090: {
                    try {
                        pDiagComPrimitive.cancel();
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error cancelling diagComPrimitive.");
                        this.logger.logThrowable(mcde);
                        currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        break;
                    }
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                case 25089: {
                    if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR || diagComPrimitiveType == 1201 || diagComPrimitiveType == 1202) continue block22;
                    currentJobStatus = this.handleResult(pDiagComPrimitive, diagComPrimitiveType, result);
                    this.logger.debug("job status after handleResult(): " + currentJobStatus);
                    if (currentJobStatus != AbstractJob.JobStatus.WRONG_UBATT_DETECTED) continue block22;
                    this.logger.debug("Cancelling repetitions due to detection of wrong battery voltage.");
                    repetitions = 0;
                    break;
                }
                default: {
                    this.logger.error("*** UNKNOWN MCDDiagComPrimitiveState ***: " + diagComPrimitiveState);
                }
            }
        } while (repetitions > 0 && currentJobStatus != AbstractJob.JobStatus.NO_ERROR);
        this.logger.debug("Releasing result.");
        try {
            this.job.releaseResult(result);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error releasing result.");
            this.logger.logThrowable(mcde);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pRemoveDiagComPrimitive) {
            try {
                pLogicalLink.removeDiagComPrimitive(pDiagComPrimitive);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error removing diagComPrimitive form logical link.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving executeDiagComPrimitiveSync(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResult(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, MCDResult pResult) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        boolean resultHasError = false;
        this.logger.trace("Entering handleResult(...).");
        if (pDiagComPrimitiveType == 1198) {
            try {
                request = pDiagComPrimitive.getRequest();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request from diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                requestParameters = request.getRequestParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request parameters from request.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        try {
            resultHasError = pResult.hasError();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining if result has an error.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (resultHasError) {
            MCDError error = null;
            this.logger.debug("Result has error.");
            try {
                error = pResult.getError();
            }
            catch (Exception e) {
                this.logger.debug("Error getting error from result.");
                this.logger.logThrowable(e);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53392 && error.getVendorCode() == 259 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 5074 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53315 && error.getVendorCode() == 20480 || pDiagComPrimitiveType == 1198 && !this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 19) {
                this.logger.debug("Ignoring P2 timeout since positive response has been suppressed.");
            } else if (error.getCode() == 53327 && error.getVendorCode() == 20) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && (error.getVendorCode() == 17 || error.getVendorCode() == 25 || error.getVendorCode() == 26 || error.getVendorCode() == 42 || error.getVendorCode() == 47)) {
                this.logger.warn("Wrong battery voltage detected - probably due to an interruption of clamp 30 or 15!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.WRONG_UBATT_DETECTED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 27) {
                this.logger.warn("EDIC interface deadlock error detected - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 16 || error.getCode() == 53315 && error.getVendorCode() == 16) {
                this.logger.warn("Command refused by EDIC interface - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 58644 || error.getCode() == 53327 && (this.isPduApiUsed && error.getCode() == 262 || !this.isPduApiUsed && error.getCode() == 13)) {
                this.logger.warn("Communication to VCI lost (possibly due to voltage drop) - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_TO_VCI_LOST_OR_DISTURBED;
            } else {
                this.logger.logMcdError(error);
                if (error.getCode() != 49152) {
                    if (this.isPduApiUsed && error.getCode() == 53327 && error.getVendorCode() == 5076) {
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        this.setJobInfo("ERROR: No result received from called job!");
                    } else {
                        currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
                    }
                }
            }
            if (!this.isPduApiUsed) {
                this.logger.debug("Restarting communication after timeout.");
                this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.stopCommunication, 1, false);
                this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.startCommunication, 1, false);
            }
        } else {
            String serviceShortName = null;
            int resultType = -1;
            MCDResponses responses = null;
            try {
                serviceShortName = pResult.getServiceShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining service SHORT-NAME of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
            try {
                resultType = pResult.getType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining type of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
            if (resultType == 1793) {
                this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
            } else {
                try {
                    responses = pResult.getResponses();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting responses from result.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, requestParameters, responses);
                this.logger.debug("job status after handleResponses(): " + currentJobStatus);
            }
        }
        this.logger.trace("Leaving handleResult(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResponses(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponses pResponses) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long responseCount = 0L;
        MCDResponse response = null;
        AbstractJob.JobStatus currentStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handleResponses(...).");
        try {
            responseCount = pResponses.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of responses.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of responses: " + responseCount);
        if (!this.isPositiveResponseSuppressed(pDiagComPrimitiveType, pRequestParameters)) {
            currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
        } else if (responseCount == 0L) {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        for (long i = 0L; i < responseCount; ++i) {
            try {
                response = pResponses.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            currentStatus = this.handleResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, response);
            if (this.responseLocationAccessKey.equals(this.dbLocationAccessKey) || this.dbLocationTypeOfLogicalLink == 1162 && this.responseLocationAccessKey.startsWith(this.dbLocationAccessKeyFunctionalGroup) || this.dbLocationTypeOfLogicalLink == 1158 && this.responseLocationAccessKey.startsWith(this.dbLocationAccessKeyBaseVariant)) {
                currentJobStatus = currentStatus;
                continue;
            }
            this.logger.debug("dbLocationOfLogicalLink of response        : " + this.responseLocationAccessKey);
            this.logger.debug("dbLocationOfLogicalLink of FUNCTIONAL-GROUP: " + this.dbLocationAccessKeyFunctionalGroup);
            this.logger.debug("dbLocationOfLogicalLink of LOGICAL-LINK    : " + this.dbLocationAccessKey);
        }
        this.logger.trace("Leaving handleResponses(...).");
        return currentJobStatus;
    }

    protected boolean isPositiveResponseSuppressed(int pDiagComPrimitiveType, MCDRequestParameters pRequestParameters) {
        MCDRequestParameter param_suppressPositiveResponseMessageIndicationBit = null;
        String suppressPositiveResponseMessageIndicationBit = null;
        this.logger.trace("Entering isPositiveResponseSuppressed(...).");
        switch (pDiagComPrimitiveType) {
            case 1198: {
                try {
                    param_suppressPositiveResponseMessageIndicationBit = pRequestParameters.getItemByName("Param_SupprPositRespoMessaIndicBit");
                    this.logger.info("Found Param_SupprPositRespoMessaIndicBit in request.");
                    try {
                        suppressPositiveResponseMessageIndicationBit = param_suppressPositiveResponseMessageIndicationBit.getValue().getValueAsString();
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting value of Param_SupprPositRespoMessaIndicBit from request.");
                        this.logger.logThrowable(mcde);
                        suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                    }
                }
                catch (MCDException mcde) {
                    this.logger.info("No Param_SupprPositRespoMessaIndicBit found in request.");
                    suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                }
                break;
            }
            case 1190: 
            case 1192: 
            case 1197: 
            case 1200: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                break;
            }
            default: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
            }
        }
        if (suppressPositiveResponseMessageIndicationBit.equalsIgnoreCase(Boolean.TRUE.toString())) {
            this.logger.debug("Response has been suppressed.");
        } else {
            this.logger.debug("Response has not been suppressed.");
        }
        this.logger.trace("Leaving isPositiveResponseSuppressed(...).");
        return Boolean.valueOf(suppressPositiveResponseMessageIndicationBit);
    }

    protected AbstractJob.JobStatus handleResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDAccessKey accessKeyOfLocation = null;
        int responseState = -1;
        this.logger.trace("Entering handleResponse(...).");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    accessKeyOfLocation = pResponse.getAccessKeyOfLocation();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (accessKeyOfLocation == null) {
                    this.logger.debug("MCDResponse.getAccessKeyOfLocation() returned null!");
                    return AbstractJob.JobStatus.ERROR;
                }
                try {
                    this.responseLocationAccessKey = accessKeyOfLocation.getString();
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting string for access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1192: 
            case 1197: 
            case 1200: {
                this.responseLocationAccessKey = this.dbLocationAccessKey;
                break;
            }
        }
        this.logger.debug("DbLocation of response: " + this.responseLocationAccessKey);
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting response message by getValueAsString().");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1200: {
                break;
            }
            case 1192: 
            case 1197: {
                break;
            }
        }
        try {
            responseState = pResponse.getState();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining response state.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (responseState) {
            case 26625: {
                currentJobStatus = this.handlePositiveResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 26626: {
                currentJobStatus = this.handleNegativeResponse(pRequestParameters, pResponse);
                break;
            }
            default: {
                this.logger.error("Invalid MCDResponseState: " + responseState);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handleResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveResponse(...).");
        this.logger.debug("Response is positive.");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                currentJobStatus = this.handlePositiveServiceResponse(pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 1192: 
            case 1197: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
            case 1200: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
        }
        this.logger.trace("Leaving handlePositiveResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveJobResponse(String pJobShortName, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveJobResponse(...).");
        if (pJobShortName.equals("SinglJob_WriteFinge")) {
            currentJobStatus = this.handlePositiveResponseWriteFingerprint(pResponse);
        } else {
            this.logger.debug("*** UNKNOWN job ***: " + pJobShortName);
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving handlePositiveJobResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveServiceResponse(String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        byte responseServiceIdentifier = 0;
        byte requestServiceIdentifier = 0;
        this.logger.trace("Entering handlePositiveServiceResponse(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
            responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length < 1) {
            this.logger.error("Error getting response service id from response with length of " + responseMessage.length + " bytes.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        responseServiceIdentifier = responseMessage[0];
        if ((responseServiceIdentifier & 0x40 & 0xFF) == 0) {
            this.logger.error("The extracted response service id ( 0x" + Integer.toHexString(responseServiceIdentifier & 0xFF).toUpperCase() + " ) is not a positive response service identifier!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        requestServiceIdentifier = (byte)(responseServiceIdentifier - 64);
        try {
            numberOfResponseParameters = pResponse.getResponseParameters().getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.warn("Ignoring response since it is not covered by a database response: " + responseMessageString);
        } else {
            switch (requestServiceIdentifier) {
                case 16: {
                    currentJobStatus = this.handlePositiveResponseDiagnosticSessionControl(pRequestParameters, pResponse);
                    break;
                }
                case -78: {
                    currentJobStatus = this.handlePositiveResponseReadByIdentifier(pRequestParameters, pResponse);
                    break;
                }
                case 46: {
                    currentJobStatus = this.handlePositiveResponseWriteDataByIdentifier(pRequestParameters, pResponse);
                    break;
                }
                default: {
                    this.logger.debug("*** UNKNOWN service ***: " + pServiceShortName);
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                }
            }
        }
        this.logger.trace("Leaving handlePositiveServiceResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseDiagnosticSessionControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String diagnosticSessionTypeRequest = null;
        String diagnosticSessionTypeResponse = null;
        MCDResponseParameters responseParameters = null;
        int p2CanServer = 0;
        int p2StarCanServer = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseDiagnosticSessionControl(...).");
        try {
            diagnosticSessionTypeRequest = pRequestParameters.getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of request ( Param_DiagnSessiType ).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            diagnosticSessionTypeResponse = pResponse.getResponseParameters().getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine control type of response ( Param_DiagnSessiType ).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!diagnosticSessionTypeResponse.equals(diagnosticSessionTypeRequest)) {
            this.logger.error("diagnosticSessionType of response does NOT match request: " + diagnosticSessionTypeRequest + " / " + diagnosticSessionTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            p2CanServer = (int)responseParameters.getItemByName("Param_StandTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_StandTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
        }
        this.logger.info("Current value of P2_CAN_Server is: " + p2CanServer + " ms.");
        try {
            p2StarCanServer = (int)responseParameters.getItemByName("Param_ExtenTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_ExtenTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
        }
        if (p2StarCanServer > 65500) {
            this.logger.warn("Received P2*_CAN_Server is: " + p2StarCanServer + " ms.");
            this.logger.warn("Limiting P2*_CAN_Server to maximum of value supported by EIDBSS firmware: 65500 ms.");
            p2StarCanServer = 65500;
        } else {
            this.logger.info("Current value of P2*_CAN_Server is: " + p2StarCanServer + " ms.");
        }
        currentJobStatus = this.updateSessionTimings(this.protocolParameterSet, p2CanServer, p2StarCanServer);
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 6) {
            try {
                responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseDiagnosticSessionControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseReadByIdentifier(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseReadByIdentifier(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 6) {
            try {
                responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseReadByIdentifier(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseWriteDataByIdentifier(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseWriteDataByIdentifier(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 4) {
            try {
                responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseWriteDataByIdentifier(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseWriteFingerprint(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusWriteFingerprint = null;
        this.logger.trace("Entering handlePositiveResponseWriteFingerprint(...).");
        try {
            jobCompletionStatusWriteFingerprint = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status ( OPA_JobComplStatu ).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of writing fingerprint is: " + jobCompletionStatusWriteFingerprint + ".");
        currentJobStatus = jobCompletionStatusWriteFingerprint.equals("Job completed successfully") ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.ERROR_WRITING_FINGERPRINT;
        this.logger.trace("Leaving handlePositiveResponseWriteFingerprint(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleNegativeResponse(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte requestServiceIdentifierRequest = 0;
        byte requestServiceIdentifierResponse = 0;
        String negativeResponseCode = null;
        byte nrc = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        this.logger.trace("Entering handleNegativeResponse(...).");
        this.logger.debug("Response is negative.");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length == 3) {
            long i;
            block29: {
                try {
                    for (i = 0L; i < pRequestParameters.getCount(); ++i) {
                        if (!pRequestParameters.getItemByIndex(i).getShortName().endsWith("RequeServiId")) continue;
                        requestServiceIdentifierRequest = (byte)pRequestParameters.getItemByIndex(i).getValue().getUint32();
                        break;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting request service identifier from request.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    responseParameters = pResponse.getResponseParameters();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting response parameters from response!");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                    this.logger.debug("Number of response parameters: " + numberOfResponseParameters);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (numberOfResponseParameters < 4L) {
                    requestServiceIdentifierResponse = requestServiceIdentifierRequest;
                } else {
                    try {
                        this.logger.debug("Datatype of request SID: " + McdEnumDecoder.decodeMcdDataType(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getDataType()));
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 3) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getBytefield()[0] & 0xFF);
                            break block29;
                        }
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 14 || responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 1) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseMessage().getBytefield()[1] & 0xFF);
                            break block29;
                        }
                        this.logger.error("Error getting request service identifier ( Param_RequeServiIdent ) from response.");
                        requestServiceIdentifierResponse = 0;
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting request service identifier ( Param_RequeServiIdent ) from response.");
                        this.logger.logThrowable(mcde);
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                }
            }
            try {
                for (i = 0L; i < numberOfResponseParameters; ++i) {
                    if (!responseParameters.getItemByIndex(i).getShortName().equals("Param_NegatRespoCode")) continue;
                    negativeResponseCode = responseParameters.getItemByIndex(i).getValue().getValueAsString();
                    break;
                }
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code ( Param_NegatRespoCode ) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                nrc = pResponse.getResponseMessage().getBytefield()[2];
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code ( byte 2 ) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("- Service ID: 0x" + Integer.toHexString(requestServiceIdentifierResponse).toUpperCase());
            this.logger.debug("- NRC       : 0x" + Integer.toHexString(nrc).toUpperCase() + " ( " + negativeResponseCode + " )");
            if (requestServiceIdentifierResponse != requestServiceIdentifierRequest) {
                this.logger.error("Request service identifier of response does NOT match request: 0x" + Integer.toHexString(requestServiceIdentifierRequest) + " / " + Integer.toHexString(requestServiceIdentifierResponse));
            }
        } else {
            try {
                responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (responseMessage.length < 3) {
                this.logger.debug("Negative response has invalid length of " + responseMessage.length + " bytes: " + responseMessageString);
            } else if (responseMessage.length > 3) {
                this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
            }
        }
        currentJobStatus = AbstractJob.JobStatus.NEGATIVE_RESPONSE;
        this.logger.trace("Leaving handleNegativeResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleErrors(MCDErrors pErrors) {
        long numberOfErrors = 0L;
        MCDError error = null;
        this.logger.trace("Entering handleErrors(...).");
        try {
            numberOfErrors = pErrors.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of errors.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (long i = 0L; i < numberOfErrors; ++i) {
            try {
                error = pErrors.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting error wirh index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.logMcdError(error);
        }
        this.logger.trace("Leaving handleErrors(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected String getProtocolParameterString(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        String value = null;
        this.logger.trace("Entering getProtocolParameterString(...).");
        try {
            value = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName).getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UNICODE2STRING value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterString(...).");
        return value;
    }

    protected long getProtocolParameterUint32(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        long value = -1L;
        this.logger.trace("Entering getProtocolParameterUint32(...).");
        try {
            value = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName).getUint32();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UINT32 value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterUint32(...).");
        return value;
    }

    protected MCDValue getProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        MCDValue comParamValue = null;
        this.logger.trace("Entering getProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error fetching protocol parameters from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName).getValue();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterValue(...).");
        return comParamValue;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, String pValue) {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        String currentValue = null;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            currentValue = comParamValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setValueAsString(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching new protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
        }
        try {
            this.logger.debug("New value of \"" + pComParamName + "\" is " + pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName).getValue().getValueAsString());
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting new value of \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, long pValue) {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        long currentValue = -1L;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            currentValue = comParamValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setUint32(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching new protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDStartCommunication startCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStartCommunication startCommunicationTmp = null;
        this.logger.trace("Entering startCommunication(...).");
        startCommunicationTmp = (MCDStartCommunication)pLogicalLink.createDiagComPrimitiveByType(1201);
        this.logger.trace("Leaving startCommunication(...).");
        return startCommunicationTmp;
    }

    protected MCDStopCommunication stopCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStopCommunication stopCommunicationTmp = null;
        this.logger.trace("Entering stopCommunication(...).");
        stopCommunicationTmp = (MCDStopCommunication)pLogicalLink.createDiagComPrimitiveByType(1202);
        this.logger.trace("Leaving stopCommunication(...).");
        return stopCommunicationTmp;
    }

    protected MCDDataPrimitive createDataPrimitive(MCDLogicalLink pLogicalLink, String pDataPrimitiveShortName) {
        MCDDataPrimitive dataPrimitive = null;
        try {
            dataPrimitive = (MCDDataPrimitive)pLogicalLink.createDiagComPrimitiveByName(pDataPrimitiveShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating data primitive with SHORT-NAME: " + pDataPrimitiveShortName);
            this.logger.logThrowable(mcde);
        }
        return dataPrimitive;
    }

    protected MCDService createService(MCDLogicalLink pLogicalLink, String pServiceShortName) {
        MCDService service = null;
        try {
            service = (MCDService)pLogicalLink.createDiagComPrimitiveByName(pServiceShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating service with SHORT-NAME: " + pServiceShortName);
            this.logger.logThrowable(mcde);
        }
        return service;
    }

    protected MCDSingleEcuJob createJob(MCDLogicalLink pLogicalLink, String pJobShortName) {
        MCDSingleEcuJob singleEcuJob = null;
        try {
            singleEcuJob = (MCDSingleEcuJob)pLogicalLink.createDiagComPrimitiveByName(pJobShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating single ECU job with SHORT-NAME: " + pJobShortName);
            this.logger.logThrowable(mcde);
        }
        return singleEcuJob;
    }

    protected MCDDataPrimitive startCommunicationDataPrimitive(MCDLogicalLink pLogicalLink, String[] pRequestParameterNames, String[] pRequestParameterValues) throws MCDException {
        MCDService startCommunicationDataPrimitive = null;
        this.logger.trace("Entering startCommunicationDataPrimitive(...).");
        startCommunicationDataPrimitive = this.createService(pLogicalLink, this.startCommunicationServiceShortName);
        for (int i = 0; i < pRequestParameterNames.length; ++i) {
            this.setRequestParameterString((MCDDiagComPrimitive)startCommunicationDataPrimitive, pRequestParameterNames[i], pRequestParameterValues[i]);
        }
        this.logger.trace("Leaving startCommunicationDataPrimitive(...).");
        return startCommunicationDataPrimitive;
    }

    protected MCDService diagnosticSessionControl(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pDiagnosticSessionType, boolean pUseFunctionalAddressing) throws MCDException {
        MCDService diagnosticSessionControl = null;
        this.logger.trace("Entering diagnosticSessionControl(...).");
        diagnosticSessionControl = pUseFunctionalAddressing ? this.createService(pLogicalLink, "DiagnServi_DiagnSessiContrFUNCT") : this.createService(pLogicalLink, "DiagnServi_DiagnSessiContr");
        this.setSuppressPosRspMsgIndicationBit(diagnosticSessionControl, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)diagnosticSessionControl, "Param_DiagnSessiType", pDiagnosticSessionType);
        this.logger.trace("Leaving diagnosticSessionControl(...).");
        return diagnosticSessionControl;
    }

    protected MCDService communicationControl(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pControlType, String pCommunicationType, String pSubnetNumber, String pNodeIdentificationNumber) throws MCDException {
        MCDService communicationControl = null;
        this.logger.trace("Entering communicationControl(...).");
        communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContr");
        this.setSuppressPosRspMsgIndicationBit(communicationControl, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_ContrType", pControlType);
        this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_CommuTypeBits0To1", pCommunicationType);
        this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_CommuTypeBits4To7", pSubnetNumber);
        if (pNodeIdentificationNumber != null) {
            this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_NodeIdentNumbe", pNodeIdentificationNumber);
        }
        this.logger.trace("Leaving communicationControl(...).");
        return communicationControl;
    }

    protected MCDService writeDataByIdentifierCalibrationData(MCDLogicalLink pLogicalLink, String pDataIdentifier) {
        MCDRequestParameters params_tableRow;
        MCDRequestParameter param_dataRecord;
        MCDValue recordDataIdentifier;
        MCDRequestParameter param_recordDataIdentifer;
        MCDService writeDataByIdentifierCalibrationData = null;
        this.logger.trace("Entering writeDataByIdentifierCalibrationData(...).");
        writeDataByIdentifierCalibrationData = this.createService(pLogicalLink, "DiagnServi_WriteDataByIdentCalibData");
        if (writeDataByIdentifierCalibrationData == null) {
            return writeDataByIdentifierCalibrationData;
        }
        try {
            param_recordDataIdentifer = writeDataByIdentifierCalibrationData.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting parameter with SHORT-NAME \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifierCalibrationData);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            recordDataIdentifier = param_recordDataIdentifer.createValue();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error creating parameter value for \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifierCalibrationData);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            recordDataIdentifier.setValueAsString(pDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value to parameter \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifierCalibrationData);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            param_recordDataIdentifer.setValue(recordDataIdentifier);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameter value of \"Param_RecorDataIdent\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifierCalibrationData);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        String tableRow = Conversions.longName2ShortName("TABROW_", pDataIdentifier);
        try {
            param_dataRecord = writeDataByIdentifierCalibrationData.getRequest().getRequestParameters().getItemByName("Param_DataRecor");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting parameter with SHORT-NAME \"Param_DataRecor\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifierCalibrationData);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            params_tableRow = param_dataRecord.getParameters().getItemByName(tableRow).getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting TABLE-ROW parameters of \"Param_DataRecor\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifierCalibrationData);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            this.setDataRecordParameters(params_tableRow);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameters of \"Param_DataRecor\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)writeDataByIdentifierCalibrationData);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        this.logger.trace("Leaving writeDataByIdentifier(...).");
        return writeDataByIdentifierCalibrationData;
    }

    protected void setDataRecordParameters(MCDRequestParameters pDataRecordParameters) throws MCDException {
        MCDRequestParameter param = null;
        this.logger.trace("Entering setDataRecordParameters(...).");
        for (long i = 0L; i < pDataRecordParameters.getCount(); ++i) {
            param = pDataRecordParameters.getItemByIndex(i);
            if (param.getShortName().equals("Param_SwitcLinFlashMode")) {
                if (this.dbLogicalLinkShortName.indexOf("Ident") != -1) {
                    this.setLinFlashMode(pDataRecordParameters, "normalmode");
                    continue;
                }
                if (this.dbLogicalLinkShortName.indexOf("2") == -1) {
                    this.setLinFlashMode(pDataRecordParameters, "Flash_programming_state_LIN");
                    continue;
                }
                this.setLinFlashMode(pDataRecordParameters, "Flash_programming_state_LIN_2");
                continue;
            }
            throw new IllegalArgumentException("Unexpected dataRecord with short name: " + param.getShortName());
        }
        this.logger.trace("Leaving setDataRecordParameters(...).");
    }

    protected void setLinFlashMode(MCDRequestParameters pDataRecordParameters, String pLinFlashMode) throws MCDException {
        this.logger.trace("Entering setLinFlashMode(...).");
        this.setRequestParameterString(pDataRecordParameters, "Param_SwitcLinFlashMode", pLinFlashMode);
        this.logger.trace("Leaving setLinFlashMode(...).");
    }

    protected void setSuppressPosRspMsgIndicationBit(MCDService pService, Boolean pValue) throws MCDException {
        this.logger.trace("Entering setSuppressPosRspMsgIndicationBit(...).");
        this.setRequestParameterString((MCDDiagComPrimitive)pService, "Param_SupprPositRespoMessaIndicBit", pValue.toString().toUpperCase());
        if (pValue == Boolean.TRUE && this.isMcd300Interface) {
            this.logger.debug("Setting SPR flag.");
            this.vendorSpecific.setSuppressPositiveResponseUnchecked(pService);
        }
        this.logger.trace("Leaving setSuppressPosRspMsgIndicationBit(...).");
    }

    protected void setRequestParameterString(MCDRequestParameters pRequestParameters, String pRequestParameterName, String pValue) throws MCDException {
        this.logger.trace("Entering setRequestParameterString(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pRequestParameters, pRequestParameterName);
        MCDValue value = requestParameter.createValue();
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected void setRequestParameterString(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, String pValue) throws MCDException {
        this.logger.trace("Entering setRequestParameterString(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        MCDValue value = requestParameter.createValue();
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected static MCDService bdmAssignNAD(MCDLogicalLink pLogicalLink, String pLinSupplierId, String pLinFunctionId, byte pNewNAD) throws MCDException {
        MCDService assignNAD = null;
        assignNAD = (MCDService)pLogicalLink.createDiagComPrimitiveByName("DiagnServi_AssigNAD");
        if (pLinSupplierId != null) {
            MCDRequestParameter param_linSupplierId = assignNAD.getRequest().getRequestParameters().getItemByName("Param_LINSupplID");
            MCDValue linSupplierId = param_linSupplierId.createValue();
            linSupplierId.setValueAsString(pLinSupplierId);
            param_linSupplierId.setValue(linSupplierId);
        }
        if (pLinFunctionId != null) {
            MCDRequestParameter requestParamLinFunctionId = assignNAD.getRequest().getRequestParameters().getItemByName("Param_LINFunctID");
            MCDRequestParameters outerStructParams = requestParamLinFunctionId.getParameters();
            MCDRequestParameter outerStructParamLinFunctionId = outerStructParams.getItemByIndex(0L);
            MCDRequestParameters innerStructParams = outerStructParamLinFunctionId.getParameters();
            MCDRequestParameter param_linFunctionId = innerStructParams.getItemByName("Param_LINFunctID");
            MCDValue linFunctionId = param_linFunctionId.createValue();
            linFunctionId.setValueAsString(pLinFunctionId);
            param_linFunctionId.setValue(linFunctionId);
        }
        if (pNewNAD != 0) {
            MCDRequestParameter param_newNAD = assignNAD.getRequest().getRequestParameters().getItemByName("Param_NewNAD");
            MCDValue newNAD = param_newNAD.createValue();
            newNAD.setUint32((long)pNewNAD);
            param_newNAD.setValue(newNAD);
        }
        return assignNAD;
    }

    protected AbstractJob.JobStatus checkRequiredDiagComms(String[] pRequiredDiagComms) throws MCDException {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        MCDDbDataPrimitives dbDataPrimitives = null;
        int dbDataPrimitiveCount = 0;
        MCDDbDataPrimitive dbDataPrimitive = null;
        String dbDataPrimitiveShortName = null;
        boolean isDiagCommAvailable = false;
        try {
            dbDataPrimitives = this.dbLocationOfLogicalLink.getDbDataPrimitives();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            dbDataPrimitiveCount = (int)dbDataPrimitives.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (int i = 0; i < pRequiredDiagComms.length; ++i) {
            MCDException mcdException;
            this.logger.debug("Checking availibility of DIAG-COMM \"" + pRequiredDiagComms[i] + "\".");
            isDiagCommAvailable = false;
            for (int j = 0; j < dbDataPrimitiveCount; ++j) {
                try {
                    dbDataPrimitive = dbDataPrimitives.getItemByIndex((long)j);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    dbDataPrimitiveShortName = dbDataPrimitive.getShortName();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting SHORT-NAME of data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (!dbDataPrimitiveShortName.equals(pRequiredDiagComms[i])) continue;
                isDiagCommAvailable = true;
            }
            if (isDiagCommAvailable) continue;
            if (pRequiredDiagComms[i].equals("SinglJob_WriteFinge")) {
                if (this.fingerprintType.equals("no fingerprint")) continue;
                this.logger.warn("SinglJob_WriteFinge is NOT available! No fingerprint will be written!");
                this.fingerprintType = "no fingerprint";
                continue;
            }
            this.jobStatus = AbstractJob.JobStatus.ERROR;
            try {
                mcdException = this.jobApi.createException(1029, 57363, "eDB_OBJECT_NOT_FOUND", 1, "AUDI-xxxx: The required DIAG-COMM with SHORT-NAME '" + pRequiredDiagComms[i] + "' is not available!", 2052);
            }
            catch (MCDException mcde) {
                this.logger.error("Error creating MCDException for unavailable DIAG-COMM \"" + pRequiredDiagComms[i] + "\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            throw mcdException;
        }
        return currentJobStatus;
    }

    private MCDResponseParameter getLastResponseParameterOfFieldByName(MCDResponseParameter pResponseParameter, String pShortName) throws MCDException {
        long numberFieldElements = 0L;
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter responseParameter = null;
        MCDResponseParameter currentResponseParameter = null;
        String responseParameterName = null;
        this.logger.trace("Entering getLastResponseParameterOfFieldByName()...");
        try {
            fieldElements = pResponseParameter.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting elements of field.");
            throw mcde;
        }
        try {
            numberFieldElements = fieldElements.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting number of response parameters in field.");
            throw mcde;
        }
        int i = 0;
        while ((long)i < numberFieldElements) {
            block12: {
                try {
                    currentResponseParameter = fieldElements.getItemByIndex((long)i);
                    if (currentResponseParameter.getType() == 17) {
                        responseParameter = fieldElements.getItemByIndex(numberFieldElements - 1L).getParameters().getItemByName(pShortName);
                        break block12;
                    }
                    try {
                        responseParameterName = currentResponseParameter.getShortName();
                        if (responseParameterName.startsWith("#RtGen_")) {
                            responseParameterName = responseParameterName.replaceFirst("#RtGen_", "");
                            responseParameterName = responseParameterName.substring(0, responseParameterName.lastIndexOf("_"));
                        }
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error getting SHORT-NAME of response parameter with index " + i + ".");
                        throw mcde;
                    }
                    if (responseParameterName != null && responseParameterName.equals(pShortName)) {
                        responseParameter = currentResponseParameter;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting response parameter with index " + i + " from field.");
                    throw mcde;
                }
            }
            ++i;
        }
        this.logger.trace("Leaving getLastResponseParameterOfFieldByName()...");
        return responseParameter;
    }

    private boolean isSubSystemSupportingCommunicationControl() {
        MCDDbDiagServices dbDiagServices = null;
        MCDDbDiagService communicationControl = null;
        MCDDbRequest communicationControlRequest = null;
        MCDDbRequestParameters dbRequestParameters = null;
        MCDDbRequestParameter controlType = null;
        MCDTextTableElements controlTypes = null;
        long numberOfControlTypes = -1L;
        MCDTextTableElement currentControlType = null;
        String controlTypeVt = null;
        this.logger.trace("Entering isSubSystemSupportingCommunicationControl()");
        try {
            dbDiagServices = this.dbLocationOfLogicalLink.getDbDiagServices();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting DbDiagServices for " + this.dbLocationAccessKey + " ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            communicationControl = dbDiagServices.getItemByName("DiagnServi_CommuContr");
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting DbDiagService with SHORT-NAME \"DiagnServi_CommuContr\" from " + this.dbLocationAccessKey + " ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (communicationControl == null) {
            this.logger.warn("DbDiagService \"DiagnServi_CommuContr\" seems to be eliminated on " + this.dbLocationAccessKey + " ...assuming false!");
            return false;
        }
        try {
            communicationControlRequest = communicationControl.getDbRequest();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting request of DbDiagService \"DiagnServi_CommuContr\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            dbRequestParameters = communicationControlRequest.getDbRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting request parameters of DbDiagService \"DiagnServi_CommuContr\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            controlType = dbRequestParameters.getItemByName("Param_ContrType");
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting request parameter with SHORT-NAME \"Param_ContrType\" of DbDiagService \"DiagnServi_CommuContr\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (controlType == null) {
            this.logger.warn("DbDiagService \"DiagnServi_CommuContr\" does NOT contain a request parameter with SHORT-NAME \"Param_ContrType\" ...assuming false!");
            return false;
        }
        try {
            controlTypes = controlType.getTextTableElements();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting text table elements of request parameter \"Param_ContrType\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            numberOfControlTypes = controlTypes.getCount();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting number of text table elements of request parameter \"Param_ContrType\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        int i = 0;
        while ((long)i < numberOfControlTypes) {
            try {
                currentControlType = controlTypes.getItemByIndex((long)i);
            }
            catch (MCDException mcde) {
                this.logger.warn("Error getting text table element with index " + i + " of request parameter \"" + "Param_ContrType" + "\" ...assuming false!");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                controlTypeVt = currentControlType.getLongName();
            }
            catch (MCDException mcde) {
                this.logger.warn("Error getting VT of text table element with index " + i + " of request parameter \"" + "Param_ContrType" + "\" ...assuming false!");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (controlTypeVt.equals("Enable Rx And Tx With Enhanced Address Information") || controlTypeVt.equals("Enable Subnet Routing")) {
                this.logger.debug("Found controlType: " + controlTypeVt);
                return true;
            }
            ++i;
        }
        this.logger.trace("Leaving isSubSystemSupportingCommunicationControl()");
        return false;
    }

    public static final class JobStep
    implements Comparable {
        public static final JobStep SWITCH_TO_FUNCTIONAL_ADDRESSING = new JobStep("SWITCH_TO_FUNCTIONAL_ADDRESSING");
        public static final JobStep PREPARE_JOBS = new JobStep("PREPARE_JOBS");
        public static final JobStep EXECUTE_START_COMMUNICATION_PRIMITIVE = new JobStep("EXECUTE_START_COMMUNICATION_PRIMITIVE");
        public static final JobStep WRITE_FINGERPRINT = new JobStep("WRITE_FINGERPRINT");
        public static final JobStep ENABLE_SUBNET_ROUTING = new JobStep("ENABLE_SUBNET_ROUTING");
        public static final JobStep ENABLE_RX_AND_DISABLE_TX_WITH_ENHANCED_ADDRESS_INFORMATION = new JobStep("ENABLE_RX_AND_DISABLE_TX_WITH_ENHANCED_ADDRESS_INFORMATION");
        public static final JobStep SWITCH_TO_PHYSICAL_ADDRESSING = new JobStep("SWITCH_TO_PHYSICAL_ADDRESSING");
        public static final JobStep SWITCH_GATEWAY_TO_EXTENDED_SESSION = new JobStep("SWITCH_GATEWAY_TO_EXTENDED_SESSION");
        public static final JobStep SWITCH_ADDRESSING_INFORMATION_TO_BDM = new JobStep("SWITCH_ADDRESSING_INFORMATION_TO_BDM");
        public static final JobStep DONE = new JobStep("DONE");
        private static int nextOrdinal = 0;
        static final JobStep[] values = new JobStep[]{SWITCH_TO_FUNCTIONAL_ADDRESSING, PREPARE_JOBS, EXECUTE_START_COMMUNICATION_PRIMITIVE, WRITE_FINGERPRINT, ENABLE_SUBNET_ROUTING, SWITCH_TO_PHYSICAL_ADDRESSING, SWITCH_GATEWAY_TO_EXTENDED_SESSION, SWITCH_ADDRESSING_INFORMATION_TO_BDM, DONE};
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
        private final int ordinal = nextOrdinal++;
        private final String name;

        private JobStep(String pName) {
            this.name = pName;
        }

        public static final JobStep valueOf(String pName) throws IllegalArgumentException {
            JobStep jobStep = null;
            Iterator jobStepIterator = VALUES.iterator();
            while (jobStepIterator.hasNext()) {
                jobStep = (JobStep)jobStepIterator.next();
                if (!pName.equals(jobStep.toString())) continue;
                return jobStep;
            }
            throw new IllegalArgumentException("Cannot parse '" + pName + "' into an element of JobStep!");
        }

        public final int compareTo(Object pObject) {
            return this.ordinal - ((JobStep)pObject).ordinal;
        }

        public final boolean equals(Object pObject) {
            return super.equals(pObject);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final int intValue() {
            return this.ordinal;
        }

        public final String toString() {
            return this.name;
        }
    }
}

