/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.uds.jobs.mcd;

import asam.d.MCDAccessKey;
import asam.d.MCDDataPrimitive;
import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDataPrimitives;
import asam.d.MCDDbEcuBaseVariant;
import asam.d.MCDDbEcuBaseVariants;
import asam.d.MCDDbFunctionalGroup;
import asam.d.MCDDbLocations;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDErrors;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDProtocolParameterSet;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDService;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDStartCommunication;
import asam.d.MCDStopCommunication;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary2.jobs.AbstractJob;
import com.audi.mcd.joblibrary2.jobs.impl.AbstractSingleEcuJobImpl;
import com.audi.mcd.joblibrary2.util.Conversions;
import com.audi.mcd.joblibrary2.util.McdEnumDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MCD3_ChangBaudRate
extends AbstractSingleEcuJobImpl {
    private static final String REVISION = "1.0.20140826";
    private static final String[] REQUIRED_DIAG_COMMS = new String[]{"DiagnServi_DiagnSessiContr", "DiagnServi_LinkContr"};
    protected static int instances = 0;
    protected static int nextInstance = 0;
    protected int instance;
    protected String jobResult = null;
    protected String jobCompletionStatus = null;
    protected boolean isModifyTimingEnabled = false;
    protected MCDDataPrimitive currentDataPrimitive = null;
    protected long savedNumberOfErrorRepetitions = 0L;
    protected long savedP3CanClientFunc = 0L;
    protected MCDProtocolParameterSet protocolParameterSet = null;
    protected String targetBaudrateIdentifier = null;
    protected long targetBaudrate = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCD3_ChangBaudRate() {
        super(REVISION);
        Class clazz = MCD3_ChangBaudRate.class;
        synchronized (clazz) {
            this.instance = nextInstance++;
            ++instances;
        }
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        this.jobStatus = this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, pJob);
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("prepareJob successful - executing job logic...");
            this.jobCompletionStatus = this.executeJobLogicGuarded();
        }
        if (this.jobStatus == AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS) {
            throw new NullPointerException("At least one of the call parameters of the job is null!");
        }
        this.finalizeJobGuarded();
        this.logger.trace("Leaving execute(...).");
    }

    protected AbstractJob.JobStatus prepareJobGuarded(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        try {
            currentJobStatus = this.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pJob);
        }
        catch (Exception e) {
            this.logger.debug("Caught exception in prepareJob() method.");
            this.logger.logThrowable(e);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught throwable in prepareJob() method.");
            this.logger.logThrowable(t);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareJob(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) throws MCDException {
        this.jobStatus = super.prepareJob(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pJob);
        this.jobResult = "FALSE";
        this.jobCompletionStatus = "Job aborted due to fatal errors";
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.jobStatus = this.readInputParameters(pRequestParameters);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        if (this.dbLocationTypeOfLogicalLink == 1162) {
            this.logger.info("The database location " + this.dbLocationAccessKey + " is a FUNCTIONAL-GROUP.");
            MCDDbFunctionalGroup dbFunctionalGroup = (MCDDbFunctionalGroup)this.dbLocationOfLogicalLink.getDbECU();
            MCDDbEcuBaseVariants baseVariants = dbFunctionalGroup.getGroupMembers();
            this.logger.debug("The FUNCTIONAL-GROUP \"" + dbFunctionalGroup.getShortName() + "\" has " + baseVariants.getCount() + " members.");
            int i = 0;
            while ((long)i < baseVariants.getCount()) {
                MCDDbEcuBaseVariant dbEcubaseVariant = baseVariants.getItemByIndex((long)i);
                MCDDbLocations dbLocations = dbEcubaseVariant.getDbLocations();
                this.logger.debug("The BASE-VARIANT " + dbEcubaseVariant.getShortName() + " has " + dbLocations.getCount() + " database locations.");
                int j = 0;
                while ((long)j < dbLocations.getCount()) {
                    String accessKey = dbLocations.getItemByIndex((long)j).getAccessKey().getString();
                    this.logger.debug("- " + accessKey);
                    ++j;
                }
                ++i;
            }
        }
        this.jobStatus = this.checkRequiredDiagComms(REQUIRED_DIAG_COMMS);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.logger.debug("Preparing protocol parameter set.");
        try {
            this.jobStatus = this.prepareProtocolParameterSet();
            if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
                return this.jobStatus;
            }
        }
        catch (MCDException mcde) {
            this.logger.debug("Error preparing protocol parameter set.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.ERROR;
        }
        if (!this.isPduApiUsed) {
            this.logger.debug("Preparing global control primitives.");
            try {
                this.stopCommunication = this.stopCommunication(this.logicalLink);
                this.startCommunication = this.startCommunication(this.logicalLink);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating MCDStop/StartCommunication.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving prepareJob(...).");
        return this.jobStatus;
    }

    protected String executeJobLogicGuarded() {
        String currentJobCompletionStatus = null;
        this.logger.trace("Entering executeJobLogicGuarded(...).");
        try {
            currentJobCompletionStatus = this.executeJobLogic();
        }
        catch (MCDException mcde) {
            this.logger.debug("Caught MCD exception in executeJobLogic() method.");
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Exception e) {
            this.logger.debug("Caught exception in executeJobLogic() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Throwable t) {
            this.logger.debug("Caught throwable in executeJobLogic() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        this.logger.trace("Leaving executeJobLogicGuarded(...).");
        return currentJobCompletionStatus;
    }

    protected String executeJobLogic() throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        JobStep currentJobStep = JobStep.values[0];
        long currentComParamBaudrate = 0L;
        byte[] changeSpeedMessage = null;
        this.logger.trace("Entering executeJobLogic(...).");
        while (currentJobStep.compareTo(JobStep.DONE) < 0 && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            if (currentJobStep == JobStep.CHECK_DATABASE_LOCATION) {
                this.logger.debug("dbEcuName: " + this.dbEcuName);
                this.logger.debug("dbLocationAccessKeyBaseVariant: " + this.dbLocationAccessKeyBaseVariant);
                if (this.dbLocationAccessKeyBaseVariant.indexOf("BV_GatewUDS") == -1 && this.dbLocationAccessKeyBaseVariant.indexOf("BV_EnginContrModul1UDS") == -1 && this.dbLocationAccessKeyBaseVariant.indexOf("BV_EnginContrModul2UDS") == -1) {
                    this.logger.error("wrong dbEcuName: " + this.dbEcuName);
                    currentJobStep = JobStep.DONE;
                    continue;
                }
                currentJobStep = JobStep.GET_TARGET_BAUDRATE;
                continue;
            }
            if (currentJobStep == JobStep.GET_TARGET_BAUDRATE) {
                try {
                    this.targetBaudrate = this.getBaudRateFromBaudrateIdentifier(this.targetBaudrateIdentifier);
                    currentComParamBaudrate = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_Baudrate");
                    this.logger.debug("Target  baud rate: " + this.targetBaudrate + " bps");
                    this.logger.debug("Current baud rate: " + currentComParamBaudrate + " bps");
                    if (currentComParamBaudrate == this.targetBaudrate) {
                        currentJobStep = JobStep.DONE;
                        continue;
                    }
                    this.setJobProgress(30L);
                    currentJobStep = JobStep.VERIFY_BAUDRATE_TRANSITION;
                }
                catch (IllegalAccessException iae) {
                    this.logger.error("Error getting target baud rate from baudrateIdentifier \"" + this.targetBaudrateIdentifier + "\"!");
                    this.logger.logThrowable(iae);
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    currentJobStep = JobStep.DONE;
                }
                continue;
            }
            if (currentJobStep == JobStep.VERIFY_BAUDRATE_TRANSITION) {
                this.currentDataPrimitive = this.linkControl(this.logicalLink, Boolean.FALSE, "Verify Mode Transition With Fixed Parameter", this.targetBaudrateIdentifier);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentDataPrimitive, 1, true);
                if (currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                    currentJobStep = JobStep.DONE;
                    continue;
                }
                this.setJobProgress(40L);
                currentJobStep = JobStep.SAVE_CHANGE_SPEED_MESSAGE;
                continue;
            }
            if (currentJobStep == JobStep.SAVE_CHANGE_SPEED_MESSAGE) {
                this.currentDataPrimitive = this.linkControl(this.logicalLink, Boolean.TRUE, "Transition Mode", this.targetBaudrateIdentifier);
                try {
                    changeSpeedMessage = this.getChangeSpeedMessageFromServiceRequest((MCDService)this.currentDataPrimitive);
                    currentJobStep = JobStep.SET_UP_CHANGE_SPEED_COMPARAMS;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting request PDU from LinkControl service.");
                    currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    currentJobStep = JobStep.DONE;
                }
                continue;
            }
            if (currentJobStep == JobStep.SET_UP_CHANGE_SPEED_COMPARAMS) {
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_ChangeSpeedMessage", changeSpeedMessage);
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_ChangeSpeedRate", this.targetBaudrate);
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_ChangeSpeedTxDelay", this.savedP3CanClientFunc);
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_ChangeSpeedCtrl", "Enabled");
                if (currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                    currentJobStep = JobStep.DONE;
                    continue;
                }
                this.setJobProgress(50L);
                currentJobStep = JobStep.TRANSITION_BAUDRATE;
                continue;
            }
            if (currentJobStep == JobStep.TRANSITION_BAUDRATE) {
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentDataPrimitive, 1, true);
                currentJobStep = currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE ? JobStep.VERIFY_BAUDRATE : JobStep.VERIFY_BAUDRATE;
                this.setJobProgress(60L);
                continue;
            }
            if (currentJobStep == JobStep.VERIFY_BAUDRATE) {
                currentComParamBaudrate = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_Baudrate");
                if (currentComParamBaudrate != this.targetBaudrate) {
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                }
                this.setJobProgress(70L);
                currentJobStep = JobStep.DISABLE_CHANGE_SPEED_CONTROL;
                continue;
            }
            if (currentJobStep == JobStep.DISABLE_CHANGE_SPEED_CONTROL) {
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_ChangeSpeedCtrl", "Disabled");
                this.setJobProgress(80L);
                currentJobStep = JobStep.TESTER_PRESENT;
                continue;
            }
            if (currentJobStep == JobStep.TESTER_PRESENT) {
                this.currentDataPrimitive = this.testerPresent(this.logicalLink, Boolean.FALSE);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentDataPrimitive, 1, true);
                this.setJobProgress(90L);
                currentJobStep = JobStep.DONE;
                continue;
            }
            if (currentJobStep == JobStep.DONE) continue;
            this.logger.error("*** UNKNOWN job step ***: " + currentJobStep);
        }
        this.logger.debug("Final job status: " + currentJobStatus);
        this.jobStatus = currentJobStatus;
        this.setJobProgress(100L);
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobResult = "TRUE";
            this.jobCompletionStatus = "Job completed successfully";
        }
        this.logger.trace("Leaving executeJobLogic(...).");
        return this.jobCompletionStatus;
    }

    protected void finalizeJobGuarded() {
        this.logger.trace("Entering finalizeJobGuarded(...).");
        try {
            this.finalizeJob();
        }
        catch (Exception e) {
            this.logger.debug("Caught exception in finalizeJob() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught throwable in finalizeJob() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving finalizeJobGuarded(...).");
    }

    protected void finalizeJob() {
        this.logger.trace("Entering finalizeJob(...).");
        if (this.jobResult.equalsIgnoreCase("TRUE")) {
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        } else if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        super.finalizeJob();
        this.logger.finalize(this.getCurrentJobRuntimeAsString());
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int numberOfInputParameters = 0;
        MCDRequestParameter inputParameter = null;
        String inputParameterName = null;
        int logLevel = -1;
        this.logger.trace("Entering readInputParameters(...).");
        try {
            numberOfInputParameters = (int)pRequestParameters.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining number of job input parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Number of INPUT-PARAMETERS to read: " + numberOfInputParameters);
        for (long i = 0L; i < (long)numberOfInputParameters; ++i) {
            try {
                inputParameter = pRequestParameters.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                inputParameterName = inputParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting SHORT-NAME of job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (inputParameterName.equals("IPA_LogLevel")) {
                try {
                    logLevel = (int)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"IPA_LogLevel\" - defaulting to LOG_TRACE.");
                    this.logger.logThrowable(mcde);
                    logLevel = 0;
                }
                logLevel &= 7;
                if (this.logger.isConfiguredByPropertiesFile()) {
                    this.logger.debug("Ignoring " + inputParameterName + " since logger has already been configured by properties file.");
                    continue;
                }
                if (logLevel <= 0) continue;
                this.logger.init(this.dbEcuName, logLevel);
                continue;
            }
            if (inputParameterName.equals("IPA_TargeBaudRate")) {
                try {
                    this.targetBaudrateIdentifier = inputParameter.getValue().getValueAsString();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getValueAsString());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"IPA_TargeBaudRate\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            throw new IllegalArgumentException("Unknown job input parameter: " + inputParameterName);
        }
        this.logger.trace("Leaving readInputParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus addOutputParameters(MCDResponse pResponse) {
        MCDResponseParameter respParam_jobResult = null;
        MCDResponseParameter respParam_jobCompletionStatus = null;
        MCDResponseParameter respParam_jobMessages = null;
        MCDValue value_jobResult = null;
        MCDValue value_jobCompletionStatus = null;
        this.logger.trace("Entering addOutputParameters(...).");
        this.logger.debug("Retrieving response parameters.");
        try {
            respParam_jobResult = pResponse.getResponseParameters().getItemByName("OPA_BaudRateChangSucce");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_BaudRateChangSucce\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobCompletionStatus = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobMessages = pResponse.getResponseParameters().getItemByName("OPA_JobMessa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobMessa\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Retrieving values.");
        try {
            value_jobResult = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting value of job output parameter with SHORT-NAME \"OPA_BaudRateChangSucce\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_jobCompletionStatus = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting value of job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Setting values.");
        try {
            value_jobResult.setValueAsString(this.jobResult);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of job out parameter with SHORT-NAME \"OPA_BaudRateChangSucce\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_jobCompletionStatus.setValueAsString(this.jobCompletionStatus);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU did not respond within the timeout period.");
        } else if (this.jobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU returned a negative response.");
        } else if (this.jobStatus == AbstractJob.JobStatus.WRONG_UBATT_DETECTED) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "The voltage on terminal 30 is invalid.");
        } else if (this.jobStatus == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "Communication disturbed (error frames on bus).");
        } else {
            this.addJobMessage(respParam_jobMessages, "static", "Baud rate changed successfully");
        }
        this.addJobMessage(respParam_jobMessages, "dynamic", "Job runtime: " + this.getCurrentJobRuntimeAsString());
        this.logger.debug("Setting output parameters.");
        try {
            respParam_jobResult.setValue(value_jobResult);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameter value of job out parameter with SHORT-NAME \"OPA_BaudRateChangSucce\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobCompletionStatus.setValue(value_jobCompletionStatus);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameter value of job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving addOutputParameters(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus addJobMessage(MCDResponseParameter pJobMessages, String pMessageType, String pMessage) {
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter respParam_jobMessage = null;
        MCDResponseParameters respParams_messageMuxBranchElements = null;
        MCDResponseParameters respParams_messageMux = null;
        MCDResponseParameter muxBranch = null;
        MCDResponseParameter respParam_messageType = null;
        MCDResponseParameter respParam_message = null;
        MCDValue value_messageType = null;
        MCDValue value_message = null;
        int messageDataType = 255;
        try {
            fieldElements = pJobMessages.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobMessage = fieldElements.addElement();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding job message to collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType = this.getLastResponseParameterOfFieldByName(respParam_jobMessage, "Param_MessaType");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting of nested output parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType.setValueAsString(pMessageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType.setValue(value_messageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = this.getLastResponseParameterOfFieldByName(pJobMessages, "Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMux = respParam_message.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            muxBranch = respParams_messageMux.addMuxBranch(Conversions.longName2ShortName("Case_", pMessageType));
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding branch to multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMuxBranchElements = muxBranch.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer branch of Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = respParams_messageMuxBranchElements.getItemByName("Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameter Param_Messa from multiplexer branch.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_message = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            messageDataType = respParam_message.getType();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining MCD data type of nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("MCDDataType of message: " + McdEnumDecoder.decodeMcdDataType(messageDataType));
        try {
            value_message.setValueAsString(pMessage);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message.setValue(value_message);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected MCDRequestParameter getRequestParameter(MCDRequestParameters pRequestParameters, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = null;
        MCDError error = null;
        MCDRequestParameter currentRequestParameter = null;
        MCDRequestParameters requestSubParameters = null;
        long numberOfRequestParameters = 0L;
        this.logger.debug("Getting request parameter: " + pRequestParameterName);
        try {
            requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        }
        catch (MCDException mcde) {
            error = mcde.getError();
            if (error.getCode() != 49184 && error.getCode() != 49177) {
                this.logger.debug("Error getting request parameter with SHORT-NAME \"" + pRequestParameterName + "\"!");
                this.logger.logThrowable(mcde);
            }
            numberOfRequestParameters = pRequestParameters.getCount();
            for (long i = 0L; i < numberOfRequestParameters && requestParameter == null; ++i) {
                currentRequestParameter = pRequestParameters.getItemByIndex(i);
                if (currentRequestParameter.getType() != 17) continue;
                requestSubParameters = currentRequestParameter.getParameters();
                requestParameter = this.getRequestParameter(requestSubParameters, pRequestParameterName);
            }
        }
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected MCDRequestParameter getRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive.getRequest().getRequestParameters(), pRequestParameterName);
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected void updateProtocolParameters(MCDProtocolParameterSet pProtocolParameterSet) {
        MCDResult result = null;
        int diagComprimitiveState = 0;
        this.logger.trace("Entering updateProtocolParameters(...).");
        try {
            result = pProtocolParameterSet.executeSync();
        }
        catch (MCDException mcde) {
            this.logger.error("Error executing MCDProtocolParameterSet.");
            this.logger.logThrowable(mcde);
            return;
        }
        try {
            diagComprimitiveState = pProtocolParameterSet.getState();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining comprimitive state of protocol parameter set.");
            this.logger.logThrowable(mcde);
            return;
        }
        this.logger.info("Current state of protocol parameter set is: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComprimitiveState));
        if (result != null) {
            boolean resultHasError = true;
            try {
                resultHasError = result.hasError();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining if result has an error.");
                this.logger.logThrowable(mcde);
                return;
            }
            if (resultHasError) {
                MCDError error = null;
                this.logger.debug("Error updating protocol parameters: Result has error.");
                try {
                    error = result.getError();
                }
                catch (Exception e) {
                    this.logger.error("Error getting error from result.");
                    this.logger.logThrowable(e);
                    return;
                }
                this.logger.logMcdError(error);
            } else {
                int executionState = -1;
                try {
                    executionState = result.getResultState().getExecutionState();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting execution state from result state.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.debug("Success updating protocol parameters.");
                this.logger.debug("ResultState of MCDProtocolParameterSet: " + McdEnumDecoder.decodeMcdExecutionState(executionState));
            }
        } else {
            MCDErrors errors = null;
            long numberOfErrors = 0L;
            MCDError error = null;
            this.logger.debug("Error updating protocol parameters: Result is null. This is caused by a DTS bug.");
            try {
                errors = pProtocolParameterSet.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting errors from MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            try {
                numberOfErrors = errors.getCount();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining number of errors of MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = errors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + " from MCDProtocolParameterSet.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving updateProtocolParameters(...).");
    }

    protected AbstractJob.JobStatus updateSessionTimings(MCDProtocolParameterSet pProtocolParameterSet, long pStandTiminP2Serve, long pExtenTiminP2Serve) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int canTransmissionTime = 0;
        int p2CanServer = 0;
        int p2StarCanServer = 0;
        this.logger.trace("Entering updateSessionTimings(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.isPduApiUsed) {
            if (!this.isModifyTimingEnabled) {
                canTransmissionTime = this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime != null ? (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime) : 150000;
                p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
                p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
                this.logger.debug("Setting P2_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ") from " + p2CanServer + " \u00b5s to " + (pStandTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max, pStandTiminP2Serve * 1000L + (long)canTransmissionTime);
                this.logger.debug("Setting P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") from " + p2StarCanServer + " \u00b5s to " + (pExtenTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star, pExtenTiminP2Serve * 1000L + (long)canTransmissionTime);
            }
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
            this.logger.debug("P2_CAN_Server  (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ")  is now set to " + p2CanServer + " \u00b5s.");
            this.logger.debug("P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") is now set to " + p2StarCanServer + " \u00b5s.");
        } else {
            canTransmissionTime = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ComPar_CANTransTime");
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("Setting P2_CAN_Server (ResponseTimeout) from " + p2CanServer + " ms to " + (pStandTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "ResponseTimeout", pStandTiminP2Serve + (long)canTransmissionTime);
            this.logger.debug("Setting P2*_CAN_Server (RC78ResponseTimeout) from " + p2StarCanServer + " ms to " + (pExtenTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "RC78ResponseTimeout", pExtenTiminP2Serve + (long)canTransmissionTime);
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("P2_CAN_Server  (ResponseTimeout)     is now set to " + p2CanServer + " ms.");
            this.logger.debug("P2*_CAN_Server (RC78ResponseTimeout) is now set to " + p2StarCanServer + " ms.");
        }
        this.logger.trace("Leaving updateSessionTimings(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareProtocolParameterSet() throws MCDException {
        MCDRequestParameter reqParam = null;
        MCDValue paramValue = null;
        String modifyTiming = null;
        this.logger.trace("Entering prepareProtocolParameterSet(...).");
        this.protocolParameterSet = (MCDProtocolParameterSet)this.logicalLink.createDiagComPrimitiveByType(1193);
        this.protocolParameterSet.fetchValuesFromInterface();
        try {
            reqParam = this.protocolParameterSet.getRequest().getRequestParameters().getItemByName("CP_ModifyTiming");
            this.isPduApiUsed = true;
            this.logger.info("Using PDU-API firmware with ISO 22900-2 COMPARAMs.");
            paramValue = reqParam.getValue();
            modifyTiming = paramValue.getValueAsString();
            this.logMessage = "CP_ModifyTiming is set to " + modifyTiming + ": ";
            if (modifyTiming.equals("Enabled")) {
                this.isModifyTimingEnabled = true;
                this.logMessage = this.logMessage + "session timings will be modified automatically by the PDUAPI firmware.";
                this.logger.info(this.logMessage);
            } else {
                this.isModifyTimingEnabled = false;
                this.logMessage = this.logMessage + "session timings will NOT be modified automatically by the PDUAPI firmware.";
                this.logger.info(this.logMessage);
            }
        }
        catch (MCDException mcde) {
            this.isPduApiUsed = false;
            this.logger.info("Using Softing EIDBSS firmware with proprietary COMPARAMs.");
            this.logger.info("Session timings will NOT be modified automatically by the firmware.");
        }
        this.logger.debug("Saving initial COMPARAM values.");
        if (this.isPduApiUsed) {
            this.savedP3CanClientFunc = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P3Func");
            this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_RepeatReqCountApp");
        } else {
            this.savedP3CanClientFunc = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_P3CANClienFunc");
            this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "NumberOfErrorRepetitions");
        }
        if (this.savedNumberOfErrorRepetitions == -1L) {
            this.logger.debug("Error saving initial COMPARAM values!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving prepareProtocolParameterSet(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus executeDiagComPrimitiveSync(MCDLogicalLink pLogicalLink, MCDDiagComPrimitive pDiagComPrimitive, int pMaxNumberOfRepetitions, boolean pRemoveDiagComPrimitive) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResult result = null;
        int diagComPrimitiveType = -1;
        String diagComPrimitiveName = null;
        MCDValue requestPdu = null;
        int diagComPrimitiveState = -1;
        MCDErrors errors = null;
        this.logger.trace("Entering executeDiagComPrimitiveSync(...).");
        try {
            diagComPrimitiveType = pDiagComPrimitive.getObjectType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining type of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Type of diagComPrimitive: " + McdEnumDecoder.decodeMcdObjectType(diagComPrimitiveType));
        try {
            diagComPrimitiveName = pDiagComPrimitive.getDbObject().getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Name of diagComPrimitive: " + diagComPrimitiveName);
        if (this.logger.getLogLevel() > 0 && (diagComPrimitiveType == 1190 || diagComPrimitiveType == 1198)) {
            try {
                requestPdu = pDiagComPrimitive.getRequest().getPDU();
                this.logger.debug("Request PDU of diagComPrimitive: " + this.vendorSpecific.pduValue2String(requestPdu));
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request PDU of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        int repetitions = pMaxNumberOfRepetitions;
        block22: do {
            this.logger.debug("Executing diagComPrimitive.");
            try {
                --repetitions;
                result = pDiagComPrimitive.executeSync();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error executing diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Getting errors.");
            try {
                errors = pDiagComPrimitive.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting errors of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Handling errors.");
            if (errors == null) {
                this.logger.error("MCDDiagComPrimitive.getErrors() returned null.");
            } else {
                currentJobStatus = this.handleErrors(errors);
            }
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                // empty if block
            }
            this.logger.debug("Determining state of diagComPrimitive.");
            try {
                diagComPrimitiveState = pDiagComPrimitive.getState();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining state of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("State of diagComPrimitive: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComPrimitiveState));
            switch (diagComPrimitiveState) {
                case 25090: {
                    try {
                        pDiagComPrimitive.cancel();
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error cancelling diagComPrimitive.");
                        this.logger.logThrowable(mcde);
                        currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        break;
                    }
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                case 25089: {
                    if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR || diagComPrimitiveType == 1201 || diagComPrimitiveType == 1202) continue block22;
                    currentJobStatus = this.handleResult(pDiagComPrimitive, diagComPrimitiveType, result);
                    this.logger.debug("job status after handleResult(): " + currentJobStatus);
                    if (currentJobStatus != AbstractJob.JobStatus.WRONG_UBATT_DETECTED) continue block22;
                    this.logger.debug("Cancelling repetitions due to detection of wrong battery voltage.");
                    repetitions = 0;
                    break;
                }
                default: {
                    this.logger.error("*** UNKNOWN MCDDiagComPrimitiveState ***: " + diagComPrimitiveState);
                }
            }
        } while (repetitions > 0 && currentJobStatus != AbstractJob.JobStatus.NO_ERROR);
        this.logger.debug("Releasing result.");
        try {
            this.job.releaseResult(result);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error releasing result.");
            this.logger.logThrowable(mcde);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pRemoveDiagComPrimitive) {
            try {
                pLogicalLink.removeDiagComPrimitive(pDiagComPrimitive);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error removing diagComPrimitive form logical link.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving executeDiagComPrimitiveSync(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResult(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, MCDResult pResult) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        boolean resultHasError = false;
        this.logger.trace("Entering handleResult(...).");
        if (pDiagComPrimitiveType == 1198) {
            try {
                request = pDiagComPrimitive.getRequest();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request from diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                requestParameters = request.getRequestParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request parameters from request.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        try {
            resultHasError = pResult.hasError();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining if result has an error.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (resultHasError) {
            MCDError error = null;
            this.logger.debug("Result has error.");
            try {
                error = pResult.getError();
            }
            catch (Exception e) {
                this.logger.debug("Error getting error from result.");
                this.logger.logThrowable(e);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53392 && error.getVendorCode() == 259 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 5074 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53315 && error.getVendorCode() == 20480 || pDiagComPrimitiveType == 1198 && !this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 19) {
                this.logger.debug("Ignoring P2 timeout since positive response has been suppressed.");
            } else if (error.getCode() == 53327 && error.getVendorCode() == 20) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && (error.getVendorCode() == 17 || error.getVendorCode() == 25 || error.getVendorCode() == 26 || error.getVendorCode() == 42 || error.getVendorCode() == 47)) {
                this.logger.warn("Wrong battery voltage detected - probably due to an interruption of clamp 30 or 15!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.WRONG_UBATT_DETECTED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 27) {
                this.logger.warn("EDIC interface deadlock error detected - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 16 || error.getCode() == 53315 && error.getVendorCode() == 16) {
                this.logger.warn("Command refused by EDIC interface - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 58644 || error.getCode() == 53327 && (this.isPduApiUsed && error.getCode() == 262 || !this.isPduApiUsed && error.getCode() == 13)) {
                this.logger.warn("Communication to VCI lost (possibly due to voltage drop) - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_TO_VCI_LOST_OR_DISTURBED;
            } else {
                this.logger.logMcdError(error);
                if (error.getCode() != 49152) {
                    if (this.isPduApiUsed && error.getCode() == 53327 && error.getVendorCode() == 5076) {
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        this.setJobInfo("ERROR: No result received from called job!");
                    } else {
                        currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
                    }
                }
            }
            if (!this.isPduApiUsed) {
                this.logger.debug("Restarting communication after timeout.");
                this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.stopCommunication, 1, false);
                this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.startCommunication, 1, false);
            }
        } else {
            String serviceShortName = null;
            int resultType = -1;
            MCDResponses responses = null;
            try {
                serviceShortName = pResult.getServiceShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining service SHORT-NAME of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
            try {
                resultType = pResult.getType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining type of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
            if (resultType == 1793) {
                this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
            } else {
                try {
                    responses = pResult.getResponses();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting responses from result.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, requestParameters, responses);
                this.logger.debug("job status after handleResponses(): " + currentJobStatus);
            }
        }
        this.logger.trace("Leaving handleResult(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResponses(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponses pResponses) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long responseCount = 0L;
        MCDResponse response = null;
        AbstractJob.JobStatus currentStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handleResponses(...).");
        try {
            responseCount = pResponses.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of responses.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of responses: " + responseCount);
        if (!this.isPositiveResponseSuppressed(pDiagComPrimitiveType, pRequestParameters)) {
            currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
        } else if (responseCount == 0L) {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        for (long i = 0L; i < responseCount; ++i) {
            try {
                response = pResponses.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            currentStatus = this.handleResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, response);
            if (this.responseLocationAccessKey.equals(this.dbLocationAccessKey) || this.dbLocationTypeOfLogicalLink == 1162 && this.responseLocationAccessKey.startsWith(this.dbLocationAccessKeyFunctionalGroup) || this.dbLocationTypeOfLogicalLink == 1158 && this.responseLocationAccessKey.startsWith(this.dbLocationAccessKeyBaseVariant)) {
                currentJobStatus = currentStatus;
                continue;
            }
            this.logger.debug("dbLocationOfLogicalLink of response        : " + this.responseLocationAccessKey);
            this.logger.debug("dbLocationOfLogicalLink of FUNCTIONAL-GROUP: " + this.dbLocationAccessKeyFunctionalGroup);
            this.logger.debug("dbLocationOfLogicalLink of LOGICAL-LINK    : " + this.dbLocationAccessKey);
        }
        this.logger.trace("Leaving handleResponses(...).");
        return currentJobStatus;
    }

    protected boolean isPositiveResponseSuppressed(int pDiagComPrimitiveType, MCDRequestParameters pRequestParameters) {
        MCDRequestParameter param_suppressPositiveResponseMessageIndicationBit = null;
        String suppressPositiveResponseMessageIndicationBit = null;
        this.logger.trace("Entering isPositiveResponseSuppressed(...).");
        switch (pDiagComPrimitiveType) {
            case 1198: {
                try {
                    param_suppressPositiveResponseMessageIndicationBit = pRequestParameters.getItemByName("Param_SupprPositRespoMessaIndicBit");
                    this.logger.info("Found Param_SupprPositRespoMessaIndicBit in request.");
                    try {
                        suppressPositiveResponseMessageIndicationBit = param_suppressPositiveResponseMessageIndicationBit.getValue().getValueAsString();
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting value of Param_SupprPositRespoMessaIndicBit from request.");
                        this.logger.logThrowable(mcde);
                        suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                    }
                }
                catch (MCDException mcde) {
                    this.logger.info("No Param_SupprPositRespoMessaIndicBit found in request.");
                    suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                }
                break;
            }
            case 1190: 
            case 1192: 
            case 1197: 
            case 1200: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                break;
            }
            default: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
            }
        }
        if (suppressPositiveResponseMessageIndicationBit.equalsIgnoreCase(Boolean.TRUE.toString())) {
            this.logger.debug("Response has been suppressed.");
        } else {
            this.logger.debug("Response has not been suppressed.");
        }
        this.logger.trace("Leaving isPositiveResponseSuppressed(...).");
        return Boolean.valueOf(suppressPositiveResponseMessageIndicationBit);
    }

    protected AbstractJob.JobStatus handleResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDAccessKey accessKeyOfLocation = null;
        int responseState = -1;
        this.logger.trace("Entering handleResponse(...).");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    accessKeyOfLocation = pResponse.getAccessKeyOfLocation();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (accessKeyOfLocation == null) {
                    this.logger.debug("MCDResponse.getAccessKeyOfLocation() returned null!");
                    return AbstractJob.JobStatus.ERROR;
                }
                try {
                    this.responseLocationAccessKey = accessKeyOfLocation.getString();
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting string for access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1192: 
            case 1197: 
            case 1200: {
                this.responseLocationAccessKey = this.dbLocationAccessKey;
                break;
            }
        }
        this.logger.debug("DbLocation of response: " + this.responseLocationAccessKey);
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting response message by getValueAsString().");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1200: {
                break;
            }
            case 1192: 
            case 1197: {
                break;
            }
        }
        try {
            responseState = pResponse.getState();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining response state.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (responseState) {
            case 26625: {
                currentJobStatus = this.handlePositiveResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 26626: {
                currentJobStatus = this.handleNegativeResponse(pRequestParameters, pResponse);
                break;
            }
            default: {
                this.logger.error("Invalid MCDResponseState: " + responseState);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handleResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveResponse(...).");
        this.logger.debug("Response is positive.");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                currentJobStatus = this.handlePositiveServiceResponse(pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 1192: 
            case 1197: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
            case 1200: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
        }
        this.logger.trace("Leaving handlePositiveResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveJobResponse(String pJobShortName, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveJobResponse(...).");
        this.logger.debug("*** UNKNOWN job ***: " + pJobShortName);
        currentJobStatus = AbstractJob.JobStatus.ERROR;
        this.logger.trace("Leaving handlePositiveJobResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveServiceResponse(String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        byte responseServiceIdentifier = 0;
        byte requestServiceIdentifier = 0;
        this.logger.trace("Entering handlePositiveServiceResponse(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
            responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length < 1) {
            this.logger.error("Error getting response service id from response with length of " + responseMessage.length + " bytes.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        responseServiceIdentifier = responseMessage[0];
        if ((responseServiceIdentifier & 0x40 & 0xFF) == 0) {
            this.logger.error("The extracted response service id ( 0x" + Integer.toHexString(responseServiceIdentifier & 0xFF).toUpperCase() + " ) is not a positive response service identifier!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        requestServiceIdentifier = (byte)(responseServiceIdentifier - 64);
        try {
            numberOfResponseParameters = pResponse.getResponseParameters().getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.warn("Ignoring response since it is not covered by a database response: " + responseMessageString);
        } else {
            switch (requestServiceIdentifier) {
                case 16: {
                    currentJobStatus = this.handlePositiveResponseDiagnosticSessionControl(pRequestParameters, pResponse);
                    break;
                }
                case 62: {
                    currentJobStatus = this.handlePositiveResponseTesterPresent(pRequestParameters, pResponse);
                    break;
                }
                case -121: {
                    currentJobStatus = this.handlePositiveResponseLinkControl(pRequestParameters, pResponse);
                    break;
                }
                default: {
                    this.logger.debug("*** UNKNOWN service ***: " + pServiceShortName);
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                }
            }
        }
        this.logger.trace("Leaving handlePositiveServiceResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseDiagnosticSessionControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String diagnosticSessionTypeRequest = null;
        String diagnosticSessionTypeResponse = null;
        MCDResponseParameters responseParameters = null;
        int p2CanServer = 0;
        int p2StarCanServer = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseDiagnosticSessionControl(...).");
        try {
            diagnosticSessionTypeRequest = pRequestParameters.getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of request ( Param_DiagnSessiType ).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            diagnosticSessionTypeResponse = pResponse.getResponseParameters().getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine control type of response ( Param_DiagnSessiType ).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!diagnosticSessionTypeResponse.equals(diagnosticSessionTypeRequest)) {
            this.logger.error("diagnosticSessionType of response does NOT match request: " + diagnosticSessionTypeRequest + " / " + diagnosticSessionTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            p2CanServer = (int)responseParameters.getItemByName("Param_StandTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_StandTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
        }
        this.logger.info("Current value of P2_CAN_Server is: " + p2CanServer + " ms.");
        try {
            p2StarCanServer = (int)responseParameters.getItemByName("Param_ExtenTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_ExtenTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
        }
        if (p2StarCanServer > 65500) {
            this.logger.warn("Received P2*_CAN_Server is: " + p2StarCanServer + " ms.");
            this.logger.warn("Limiting P2*_CAN_Server to maximum of value supported by EIDBSS firmware: 65500 ms.");
            p2StarCanServer = 65500;
        } else {
            this.logger.info("Current value of P2*_CAN_Server is: " + p2StarCanServer + " ms.");
        }
        currentJobStatus = this.updateSessionTimings(this.protocolParameterSet, p2CanServer, p2StarCanServer);
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 6) {
            try {
                responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseDiagnosticSessionControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseLinkControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String linkControlTypeRequest = null;
        String linkControlTypeResponse = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseLinkControl(...).");
        try {
            linkControlTypeRequest = pRequestParameters.getItemByName("Param_LinkContrType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting link control type of request ( Param_LinkContrType ).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            linkControlTypeResponse = pResponse.getResponseParameters().getItemByName("Param_LinkContrType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine control type of response ( Param_LinkContrType ).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!linkControlTypeResponse.equals(linkControlTypeRequest)) {
            this.logger.error("linkControlType of response does NOT match request: " + linkControlTypeRequest + " / " + linkControlTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 6) {
            try {
                responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseLinkControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseTesterPresent(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String zeroSubfunctionRequest = null;
        String zeroSubfunctionResponse = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseTesterPresent(...).");
        try {
            zeroSubfunctionRequest = pRequestParameters.getItemByName("Param_ZeroSubFunct").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting zero sub function of request ( Param_ZeroSubFunct ).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            zeroSubfunctionResponse = pResponse.getResponseParameters().getItemByName("Param_ZeroSubFunct").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine control type of response ( Param_ZeroSubFunct ).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!zeroSubfunctionResponse.equals(zeroSubfunctionRequest)) {
            this.logger.error("zeroSubFunction of response does NOT match request: " + zeroSubfunctionRequest + " / " + zeroSubfunctionResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseTesterPresent(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleNegativeResponse(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte requestServiceIdentifierRequest = 0;
        byte requestServiceIdentifierResponse = 0;
        String negativeResponseCode = null;
        byte nrc = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        this.logger.trace("Entering handleNegativeResponse(...).");
        this.logger.debug("Response is negative.");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length == 3) {
            long i;
            block29: {
                try {
                    for (i = 0L; i < pRequestParameters.getCount(); ++i) {
                        if (!pRequestParameters.getItemByIndex(i).getShortName().endsWith("RequeServiId")) continue;
                        requestServiceIdentifierRequest = (byte)pRequestParameters.getItemByIndex(i).getValue().getUint32();
                        break;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting request service identifier from request.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    responseParameters = pResponse.getResponseParameters();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting response parameters from response!");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                    this.logger.debug("Number of response parameters: " + numberOfResponseParameters);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (numberOfResponseParameters < 4L) {
                    requestServiceIdentifierResponse = requestServiceIdentifierRequest;
                } else {
                    try {
                        this.logger.debug("Datatype of request SID: " + McdEnumDecoder.decodeMcdDataType(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getDataType()));
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 3) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getBytefield()[0] & 0xFF);
                            break block29;
                        }
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 14 || responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 1) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseMessage().getBytefield()[1] & 0xFF);
                            break block29;
                        }
                        this.logger.error("Error getting request service identifier ( Param_RequeServiIdent ) from response.");
                        requestServiceIdentifierResponse = 0;
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting request service identifier ( Param_RequeServiIdent ) from response.");
                        this.logger.logThrowable(mcde);
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                }
            }
            try {
                for (i = 0L; i < numberOfResponseParameters; ++i) {
                    if (!responseParameters.getItemByIndex(i).getShortName().equals("Param_NegatRespoCode")) continue;
                    negativeResponseCode = responseParameters.getItemByIndex(i).getValue().getValueAsString();
                    break;
                }
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code ( Param_NegatRespoCode ) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                nrc = pResponse.getResponseMessage().getBytefield()[2];
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code ( byte 2 ) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("- Service ID: 0x" + Integer.toHexString(requestServiceIdentifierResponse).toUpperCase());
            this.logger.debug("- NRC       : 0x" + Integer.toHexString(nrc).toUpperCase() + " ( " + negativeResponseCode + " )");
            if (requestServiceIdentifierResponse != requestServiceIdentifierRequest) {
                this.logger.error("Request service identifier of response does NOT match request: 0x" + Integer.toHexString(requestServiceIdentifierRequest) + " / " + Integer.toHexString(requestServiceIdentifierResponse));
            }
        } else {
            try {
                responseMessageString = this.vendorSpecific.pduValue2String(pResponse.getResponseMessage());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (responseMessage.length < 3) {
                this.logger.debug("Negative response has invalid length of " + responseMessage.length + " bytes: " + responseMessageString);
            } else if (responseMessage.length > 3) {
                this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
            }
        }
        currentJobStatus = AbstractJob.JobStatus.NEGATIVE_RESPONSE;
        this.logger.trace("Leaving handleNegativeResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleErrors(MCDErrors pErrors) {
        long numberOfErrors = 0L;
        MCDError error = null;
        this.logger.trace("Entering handleErrors(...).");
        try {
            numberOfErrors = pErrors.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of errors.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (long i = 0L; i < numberOfErrors; ++i) {
            try {
                error = pErrors.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting error wirh index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.logMcdError(error);
        }
        this.logger.trace("Leaving handleErrors(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected long getProtocolParameterUint32(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        long value = -1L;
        this.logger.trace("Entering getProtocolParameterUint32(...).");
        try {
            value = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName).getUint32();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UINT32 value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterUint32(...).");
        return value;
    }

    protected MCDValue getProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        MCDValue comParamValue = null;
        this.logger.trace("Entering getProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error fetching protocol parameters from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName).getValue();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterValue(...).");
        return comParamValue;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, byte[] pValue) {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        byte[] currentValue = null;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            currentValue = comParamValue.getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + Conversions.byteArray2String(currentValue) + " to " + Conversions.byteArray2String(pValue) + ".");
        try {
            comParamValue.setBytefield(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + Conversions.byteArray2String(pValue) + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching new protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, String pValue) {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        String currentValue = null;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            currentValue = comParamValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setValueAsString(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching new protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
        }
        try {
            this.logger.debug("New value of \"" + pComParamName + "\" is " + pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName).getValue().getValueAsString());
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting new value of \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, long pValue) {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        long currentValue = -1L;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            currentValue = comParamValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setUint32(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching new protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDStartCommunication startCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStartCommunication startCommunicationTmp = null;
        this.logger.trace("Entering startCommunication(...).");
        startCommunicationTmp = (MCDStartCommunication)pLogicalLink.createDiagComPrimitiveByType(1201);
        this.logger.trace("Leaving startCommunication(...).");
        return startCommunicationTmp;
    }

    protected MCDStopCommunication stopCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStopCommunication stopCommunicationTmp = null;
        this.logger.trace("Entering stopCommunication(...).");
        stopCommunicationTmp = (MCDStopCommunication)pLogicalLink.createDiagComPrimitiveByType(1202);
        this.logger.trace("Leaving stopCommunication(...).");
        return stopCommunicationTmp;
    }

    protected MCDService createService(MCDLogicalLink pLogicalLink, String pServiceShortName) {
        MCDService service = null;
        try {
            service = (MCDService)pLogicalLink.createDiagComPrimitiveByName(pServiceShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating service with SHORT-NAME: " + pServiceShortName);
            this.logger.logThrowable(mcde);
        }
        return service;
    }

    protected MCDService linkControl(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pLinkControlType, String pLinkControlModeIdentifier) throws MCDException {
        MCDService linkControl = null;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        MCDRequestParameter param_linkRecordTableStruct = null;
        MCDRequestParameters params_linkRecord = null;
        MCDRequestParameter param_linkControlModifierOptional = null;
        MCDRequestParameter param_linkControlModeIdentifier = null;
        MCDValue value_linkControlModeIdentifier = null;
        this.logger.trace("Entering linkControl(...).");
        linkControl = this.createService(pLogicalLink, "DiagnServi_LinkContr");
        try {
            request = linkControl.getRequest();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting request of service \"DiagnServi_LinkContr\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)linkControl);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        try {
            requestParameters = request.getRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting request parameters of service \"DiagnServi_LinkContr\".");
            this.logger.logThrowable(mcde);
            try {
                pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)linkControl);
            }
            catch (MCDException mcde1) {
                this.logger.fatal("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde1);
            }
            return null;
        }
        this.setSuppressPosRspMsgIndicationBit(linkControl, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)linkControl, "Param_LinkContrType", pLinkControlType);
        if (pLinkControlModeIdentifier != null) {
            try {
                param_linkRecordTableStruct = this.vendorSpecific.getTableStructParameterByTableKeyValue(requestParameters, "Param_LinkRecor", pLinkControlType);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting parameter with SHORT-NAME \"Param_LinkRecor\".");
                this.logger.logThrowable(mcde);
                try {
                    pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)linkControl);
                }
                catch (MCDException mcde1) {
                    this.logger.fatal("Error removing diagComPrimitive from logical link.");
                    this.logger.logThrowable(mcde1);
                }
                return null;
            }
            try {
                params_linkRecord = param_linkRecordTableStruct.getParameters();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting parameters of \"Param_LinkRecor\".");
                this.logger.logThrowable(mcde);
                try {
                    pLogicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)linkControl);
                }
                catch (MCDException mcde1) {
                    this.logger.fatal("Error removing diagComPrimitive from logical link.");
                    this.logger.logThrowable(mcde1);
                }
                return null;
            }
            if (params_linkRecord.getCount() == 1L) {
                if (params_linkRecord.getItemByIndex(0L).getShortName().equals("Param_LinkContrModeIdent")) {
                    param_linkControlModeIdentifier = params_linkRecord.getItemByName("Param_LinkContrModeIdent");
                    value_linkControlModeIdentifier = this.jobApi.createValue(14);
                    value_linkControlModeIdentifier.setValueAsString(pLinkControlModeIdentifier);
                    param_linkControlModeIdentifier.setValue(value_linkControlModeIdentifier);
                } else {
                    try {
                        param_linkControlModifierOptional = params_linkRecord.getItemByName("Param_LinkContrModeIdentOptio");
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error getting request parameter with SHORT-NAME \"Param_LinkRecor\"!");
                        this.logger.logThrowable(mcde);
                        return null;
                    }
                    try {
                        param_linkControlModifierOptional.addParameters(1L);
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error adding link record parameter.");
                        this.logger.logThrowable(mcde);
                        return null;
                    }
                    try {
                        param_linkControlModeIdentifier = this.getLastRequestParameterOfFieldByName(param_linkControlModifierOptional, "Param_LinkContrModeIdent");
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error getting nested request parameter Param_LinkContrModeIdent.");
                        this.logger.logThrowable(mcde);
                        return null;
                    }
                    try {
                        value_linkControlModeIdentifier = this.jobApi.createValue(14);
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error creating MCD value for nested parameter Param_LinkContrModeIdent.");
                        this.logger.logThrowable(mcde);
                        return null;
                    }
                    try {
                        value_linkControlModeIdentifier.setValueAsString(pLinkControlModeIdentifier);
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error setting MCD value for nested parameter Param_LinkContrModeIdent.");
                        this.logger.logThrowable(mcde);
                        return null;
                    }
                    try {
                        param_linkControlModeIdentifier.setValue(value_linkControlModeIdentifier);
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error setting nested parameter Param_LinkContrModeIdent.");
                        this.logger.logThrowable(mcde);
                        return null;
                    }
                }
            }
        }
        this.logger.trace("Leaving linkControl(...).");
        return linkControl;
    }

    protected MCDService testerPresent(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse) throws MCDException {
        MCDService testerPresent = null;
        this.logger.trace("Entering testerPresent(...).");
        testerPresent = this.createService(pLogicalLink, "DiagnServi_TestePrese");
        this.setSuppressPosRspMsgIndicationBit(testerPresent, pSuppressResponse);
        this.logger.trace("Leaving testerPresent(...).");
        return testerPresent;
    }

    protected void setSuppressPosRspMsgIndicationBit(MCDService pService, Boolean pValue) throws MCDException {
        this.logger.trace("Entering setSuppressPosRspMsgIndicationBit(...).");
        this.setRequestParameterString((MCDDiagComPrimitive)pService, "Param_SupprPositRespoMessaIndicBit", pValue.toString().toUpperCase());
        if (pValue == Boolean.TRUE && this.isMcd300Interface) {
            this.logger.debug("Setting SPR flag.");
            this.vendorSpecific.setSuppressPositiveResponseUnchecked(pService);
        }
        this.logger.trace("Leaving setSuppressPosRspMsgIndicationBit(...).");
    }

    protected void setRequestParameterString(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, String pValue) throws MCDException {
        this.logger.trace("Entering setRequestParameterString(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        MCDValue value = requestParameter.createValue();
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected AbstractJob.JobStatus checkRequiredDiagComms(String[] pRequiredDiagComms) throws MCDException {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        MCDDbDataPrimitives dbDataPrimitives = null;
        int dbDataPrimitiveCount = 0;
        MCDDbDataPrimitive dbDataPrimitive = null;
        String dbDataPrimitiveShortName = null;
        boolean isDiagCommAvailable = false;
        try {
            dbDataPrimitives = this.dbLocationOfLogicalLink.getDbDataPrimitives();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            dbDataPrimitiveCount = (int)dbDataPrimitives.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (int i = 0; i < pRequiredDiagComms.length; ++i) {
            MCDException mcdException;
            this.logger.debug("Checking availibility of DIAG-COMM \"" + pRequiredDiagComms[i] + "\".");
            isDiagCommAvailable = false;
            for (int j = 0; j < dbDataPrimitiveCount; ++j) {
                try {
                    dbDataPrimitive = dbDataPrimitives.getItemByIndex((long)j);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    dbDataPrimitiveShortName = dbDataPrimitive.getShortName();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting SHORT-NAME of data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (!dbDataPrimitiveShortName.equals(pRequiredDiagComms[i])) continue;
                isDiagCommAvailable = true;
            }
            if (isDiagCommAvailable) continue;
            this.jobStatus = AbstractJob.JobStatus.ERROR;
            try {
                mcdException = this.jobApi.createException(1029, 57363, "eDB_OBJECT_NOT_FOUND", 1, "AUDI-xxxx: The required DIAG-COMM with SHORT-NAME '" + pRequiredDiagComms[i] + "' is not available!", 2052);
            }
            catch (MCDException mcde) {
                this.logger.error("Error creating MCDException for unavailable DIAG-COMM \"" + pRequiredDiagComms[i] + "\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            throw mcdException;
        }
        return currentJobStatus;
    }

    private MCDRequestParameter getLastRequestParameterOfFieldByName(MCDRequestParameter pRequestParameter, String pShortName) throws MCDException {
        long numberOfFieldElements = 0L;
        MCDRequestParameters fieldElements = null;
        MCDRequestParameter requestParameter = null;
        MCDRequestParameter currentRequestParameter = null;
        String requestParameterName = null;
        this.logger.trace("Entering getLastRequestParameterOfFieldByName()...");
        try {
            fieldElements = pRequestParameter.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting elements of field.");
            throw mcde;
        }
        try {
            numberOfFieldElements = fieldElements.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting number of request parameters in field.");
            throw mcde;
        }
        int i = 0;
        while ((long)i < numberOfFieldElements) {
            block12: {
                try {
                    currentRequestParameter = fieldElements.getItemByIndex((long)i);
                    if (currentRequestParameter.getType() == 17) {
                        requestParameter = fieldElements.getItemByIndex(numberOfFieldElements - 1L).getParameters().getItemByName(pShortName);
                        break block12;
                    }
                    try {
                        requestParameterName = currentRequestParameter.getShortName();
                        if (requestParameterName.startsWith("#RtGen_")) {
                            requestParameterName = requestParameterName.replaceFirst("#RtGen_", "");
                            requestParameterName = requestParameterName.substring(0, requestParameterName.lastIndexOf("_"));
                        }
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting SHORT-NAME of request parameter with index " + i + ".");
                        throw mcde;
                    }
                    if (requestParameterName != null && requestParameterName.equals(pShortName)) {
                        requestParameter = currentRequestParameter;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting request parameter with index " + i + " from field.");
                    throw mcde;
                }
            }
            ++i;
        }
        this.logger.trace("Leaving getLastRequestParameterOfFieldByName()...");
        return requestParameter;
    }

    private MCDResponseParameter getLastResponseParameterOfFieldByName(MCDResponseParameter pResponseParameter, String pShortName) throws MCDException {
        long numberOfFieldElements = 0L;
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter responseParameter = null;
        MCDResponseParameter currentResponseParameter = null;
        String responseParameterName = null;
        this.logger.trace("Entering getLastResponseParameterOfFieldByName()...");
        try {
            fieldElements = pResponseParameter.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting elements of field.");
            throw mcde;
        }
        try {
            numberOfFieldElements = fieldElements.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting number of response parameters in field.");
            throw mcde;
        }
        int i = 0;
        while ((long)i < numberOfFieldElements) {
            block12: {
                try {
                    currentResponseParameter = fieldElements.getItemByIndex((long)i);
                    if (currentResponseParameter.getType() == 17) {
                        responseParameter = fieldElements.getItemByIndex(numberOfFieldElements - 1L).getParameters().getItemByName(pShortName);
                        break block12;
                    }
                    try {
                        responseParameterName = currentResponseParameter.getShortName();
                        if (responseParameterName.startsWith("#RtGen_")) {
                            responseParameterName = responseParameterName.replaceFirst("#RtGen_", "");
                            responseParameterName = responseParameterName.substring(0, responseParameterName.lastIndexOf("_"));
                        }
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting SHORT-NAME of response parameter with index " + i + ".");
                        throw mcde;
                    }
                    if (responseParameterName != null && responseParameterName.equals(pShortName)) {
                        responseParameter = currentResponseParameter;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting response parameter with index " + i + " from field.");
                    throw mcde;
                }
            }
            ++i;
        }
        this.logger.trace("Leaving getLastResponseParameterOfFieldByName()...");
        return responseParameter;
    }

    protected byte[] getChangeSpeedMessageFromServiceRequest(MCDService pService) throws MCDException {
        MCDRequest request = null;
        MCDValue value = null;
        byte[] changeSpeedMessage = null;
        byte[] requestPdu = null;
        this.logger.trace("Entering getChangeSpeedMessageFromServiceRequest()...");
        try {
            request = pService.getRequest();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting request from service.");
            throw mcde;
        }
        try {
            value = request.getPDU();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting PDU value from request.");
            throw mcde;
        }
        try {
            changeSpeedMessage = value.getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting PDU from MCD value.");
            throw mcde;
        }
        if (!this.isMcd20002Interface) {
            requestPdu = changeSpeedMessage;
            changeSpeedMessage = new byte[1 + requestPdu.length];
            changeSpeedMessage[0] = -121;
            System.arraycopy(requestPdu, 0, changeSpeedMessage, 1, requestPdu.length);
        }
        this.logger.trace("Leaving getChangeSpeedMessageFromServiceRequest()...");
        return changeSpeedMessage;
    }

    protected long getBaudRateFromBaudrateIdentifier(String pBaudrateIdentifier) throws IllegalAccessException {
        long baudRate = 0L;
        this.logger.trace("Entering getBaudRateFromBaudrateIdentifier(...)...");
        if (pBaudrateIdentifier.equals("CAN 1000000 Baud")) {
            baudRate = 1000000L;
        } else if (pBaudrateIdentifier.equals("CAN 500000 Baud")) {
            baudRate = 500000L;
        } else {
            throw new IllegalArgumentException("Unknown baudrateIdentifier: " + pBaudrateIdentifier);
        }
        this.logger.trace("Leaving getBaudRateFromBaudrateIdentifier(...)...");
        return baudRate;
    }

    public static final class JobStep
    implements Comparable {
        public static final JobStep CHECK_DATABASE_LOCATION = new JobStep("CHECK_DATABASE_LOCATION");
        public static final JobStep GET_TARGET_BAUDRATE = new JobStep("GET_TARGET_BAUDRATE");
        public static final JobStep VERIFY_BAUDRATE_TRANSITION = new JobStep("VERIFY_BAUDRATE_TRANSITION");
        public static final JobStep SAVE_CHANGE_SPEED_MESSAGE = new JobStep("SAVE_CHANGE_SPEED_MESSAGE");
        public static final JobStep SET_UP_CHANGE_SPEED_COMPARAMS = new JobStep("SET_UP_CHANGE_SPEED_COMPARAMS");
        public static final JobStep TRANSITION_BAUDRATE = new JobStep("TRANSITION_BAUDRATE");
        public static final JobStep VERIFY_BAUDRATE = new JobStep("VERIFY_BAUDRATE");
        public static final JobStep DISABLE_CHANGE_SPEED_CONTROL = new JobStep("DISABLE_CHANGE_SPEED_CONTROL");
        public static final JobStep TESTER_PRESENT = new JobStep("TESTER_PRESENT");
        public static final JobStep DONE = new JobStep("DONE");
        private static int nextOrdinal = 0;
        static final JobStep[] values = new JobStep[]{CHECK_DATABASE_LOCATION, GET_TARGET_BAUDRATE, VERIFY_BAUDRATE_TRANSITION, SAVE_CHANGE_SPEED_MESSAGE, SET_UP_CHANGE_SPEED_COMPARAMS, TRANSITION_BAUDRATE, VERIFY_BAUDRATE, DISABLE_CHANGE_SPEED_CONTROL, TESTER_PRESENT, DONE};
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
        private final int ordinal = nextOrdinal++;
        private final String name;

        private JobStep(String pName) {
            this.name = pName;
        }

        public static final JobStep valueOf(String pName) throws IllegalArgumentException {
            JobStep jobStep = null;
            Iterator jobStepIterator = VALUES.iterator();
            while (jobStepIterator.hasNext()) {
                jobStep = (JobStep)jobStepIterator.next();
                if (!pName.equals(jobStep.toString())) continue;
                return jobStep;
            }
            throw new IllegalArgumentException("Cannot parse '" + pName + "' into an element of JobStep!");
        }

        public final int compareTo(Object pObject) {
            return this.ordinal - ((JobStep)pObject).ordinal;
        }

        public final boolean equals(Object pObject) {
            return super.equals(pObject);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final int intValue() {
            return this.ordinal;
        }

        public final String toString() {
            return this.name;
        }
    }
}

