/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary3.util;

import asam.d.MCDActivityState;
import asam.d.MCDAddressingMode;
import asam.d.MCDClampState;
import asam.d.MCDDataType;
import asam.d.MCDDiagComPrimitiveState;
import asam.d.MCDDiagVarType;
import asam.d.MCDErrorCodes;
import asam.d.MCDExecutionState;
import asam.d.MCDFlashDataFormat;
import asam.d.MCDGatewayMode;
import asam.d.MCDLimitType;
import asam.d.MCDLocationType;
import asam.d.MCDLockState;
import asam.d.MCDLogicalLinkState;
import asam.d.MCDLogicalLinkType;
import asam.d.MCDObjectType;
import asam.d.MCDQueueErrorMode;
import asam.d.MCDRangeInfo;
import asam.d.MCDRepetitionMode;
import asam.d.MCDRepetitionState;
import asam.d.MCDResponseState;
import asam.d.MCDResponseType;
import asam.d.MCDResultType;
import asam.d.MCDRuntimeMode;
import asam.d.MCDServerType;
import asam.d.MCDSeverity;
import asam.d.MCDSystemState;
import asam.d.MCDTransmissionMode;

public abstract class McdEnumDecoder {
    public static final String decodeMcdActivityState(int pMcdActivityState) {
        switch (pMcdActivityState) {
            case 25857: {
                return "ACTIVITY_IDLE";
            }
            case 25858: {
                return "ACTIVITY_RUNNING";
            }
            case 25859: {
                return "ACTIVITY_SUSPENDED";
            }
        }
        return "*** UNKNOWN " + MCDActivityState.class.getName() + " ***: 0x" + Integer.toHexString(pMcdActivityState).toUpperCase();
    }

    public static final String decodeMcdAddressingMode(int pMcdAddressingMode) {
        switch (pMcdAddressingMode) {
            case 24577: {
                return "UNDEFINED";
            }
            case 24578: {
                return "PHYSICAL";
            }
            case 24579: {
                return "FUNCTIONAL";
            }
            case 24580: {
                return "FUNCTIONAL_OR_PHYSICAL";
            }
        }
        return "*** UNKNOWN " + MCDAddressingMode.class.getName() + " ***: 0x" + Integer.toHexString(pMcdAddressingMode).toUpperCase();
    }

    public static final String decodeMcdClampState(int pClampState) {
        switch (pClampState) {
            case 24833: {
                return "CLAMP_ON";
            }
            case 24834: {
                return "CLAMP_OFF";
            }
        }
        return "*** UNKNOWN " + MCDClampState.class.getName() + " ***: 0x" + Integer.toHexString(pClampState).toUpperCase();
    }

    public static final String decodeMcdDataType(int pMcdDataType) {
        switch (pMcdDataType) {
            case 1: {
                return "A_ASCIISTRING";
            }
            case 2: {
                return "A_BITFIELD";
            }
            case 3: {
                return "A_BYTEFIELD";
            }
            case 4: {
                return "A_FLOAT32";
            }
            case 5: {
                return "A_FLOAT64";
            }
            case 6: {
                return "A_INT16";
            }
            case 7: {
                return "A_INT32";
            }
            case 8: {
                return "A_INT64";
            }
            case 9: {
                return "A_INT8";
            }
            case 10: {
                return "A_UINT16";
            }
            case 11: {
                return "A_UINT32";
            }
            case 12: {
                return "A_UINT64";
            }
            case 13: {
                return "A_UINT8";
            }
            case 14: {
                return "A_UNICODE2STRING";
            }
            case 15: {
                return "FIELD";
            }
            case 16: {
                return "MULTIPLEXER";
            }
            case 17: {
                return "STRUCTURE";
            }
            case 18: {
                return "TEXTTABLE";
            }
            case 19: {
                return "A_BOOLEAN";
            }
            case 20: {
                return "DTC";
            }
            case 21: {
                return "ENVDATA";
            }
            case 22: {
                return "END_OF_PDU";
            }
            case 23: {
                return "TABLE";
            }
            case 24: {
                return "ENVDATADESC";
            }
            case 25: {
                return "KEY";
            }
            case 26: {
                return "LENGTHKEY / TABLE_ROW";
            }
            case 255: {
                return "NO_TYPE";
            }
        }
        return "*** UNKNOWN " + MCDDataType.class.getName() + " ***: 0x" + Integer.toHexString(pMcdDataType).toUpperCase();
    }

    public static final String decodeMcdDiagComPrimitiveState(int pMcdDiagComPrimitiveState) {
        switch (pMcdDiagComPrimitiveState) {
            case 25089: {
                return "IDLE";
            }
            case 25090: {
                return "PENDING";
            }
            case 25091: {
                return "REPEATING";
            }
            case 25092: {
                return "NOT_EXECUTABLE";
            }
        }
        return "*** UNKNOWN " + MCDDiagComPrimitiveState.class.getName() + " ***: 0x" + Integer.toHexString(pMcdDiagComPrimitiveState).toUpperCase();
    }

    public static final String decodeMcdDiagVarType(int pMcdDiagVarType) {
        switch (pMcdDiagVarType) {
            case 27649: {
                return "CURRENT";
            }
            case 27650: {
                return "STORED";
            }
            case 27651: {
                return "STATIC";
            }
            case 27652: {
                return "SUBSTITUTE";
            }
        }
        return "*** UNKNOWN " + MCDDiagVarType.class.getName() + " ***: 0x" + Integer.toHexString(pMcdDiagVarType).toUpperCase();
    }

    public static final String decodeMcdErrorCodes(int pMcdErrorCodes) {
        switch (pMcdErrorCodes) {
            case 0: {
                return "NO_ERROR";
            }
            case 49152: {
                return "NO_ERROR";
            }
            case 49168: {
                return "PAR_INVALID_TYPE";
            }
            case 49169: {
                return "PAR_INVALID_OBJECTTYPE";
            }
            case 49170: {
                return "PAR_INVALID_OBJECTTYPE_FOR_DIAGCOMPRIMITIVES";
            }
            case 49171: {
                return "PAR_INVALID_DB_OBJECT";
            }
            case 49172: {
                return "PAR_VALUE_OUT_OF_RANGE";
            }
            case 49173: {
                return "PAR_COL_WRONG_BUFFER_ID";
            }
            case 49174: {
                return "PAR_COL_WRONG_FORMAT_IDENTIFIER";
            }
            case 49175: {
                return "PAR_COL_WRONG_STORAGE_TYPE";
            }
            case 49176: {
                return "PAR_COL_WRONG_TIMER_RESOLUTION";
            }
            case 49177: {
                return "PAR_SHORTNAME_INVALID";
            }
            case 49178: {
                return "PAR_DIAGCOMPRIMITIVE_TYPE_INVALID";
            }
            case 49179: {
                return "PAR_WRONG_MEM_PAGE";
            }
            case 49180: {
                return "PAR_REP_TYPE_ECU_NOT_SUPPORTED";
            }
            case 49181: {
                return "PAR_CHAR_INDEX_OUT_OF_RANGE";
            }
            case 49182: {
                return "PAR_INCONSISTENT_VALUE_LIST";
            }
            case 49183: {
                return "PAR_INDEX_OUT_OF_RANGE";
            }
            case 49184: {
                return "PAR_ITEM_NOT_FOUND";
            }
            case 49185: {
                return "PAR_DB_INVALID_ACCESSKEY / PAR_INVALID_ACCESSKEY";
            }
            case 49186: {
                return "PAR_INVALID_PROTOCOL_IN_ACCESSKEY";
            }
            case 49187: {
                return "PAR_INVALID_FUNCTIONAL_GROUP_IN_ACCESSKEY";
            }
            case 49188: {
                return "PAR_INVALID_BASE_VARIANT_IN_ACCESSKEY";
            }
            case 49189: {
                return "PAR_INVALID_VARIANT_IN_ACCESSKEY";
            }
            case 49190: {
                return "PAR_INVALID_MULTIPLE_ECU_JOB_IN_ACCESSKEY";
            }
            case 49191: {
                return "PAR_INCONSISTENT_PARAMETERS";
            }
            case 49200: {
                return "PAR_MCD_NO_DYNAMIC_FIELD";
            }
            case 49201: {
                return "PAR_STRING_CONVERSION_ERROR";
            }
            case 49202: {
                return "PAR_INCOMPLETE_PARAMETERIZATION";
            }
            case 49203: {
                return "PAR_INVALID_VALUE";
            }
            case 49204: {
                return "PAR_NO_SIMPLE_DOP";
            }
            case 49205: {
                return "PAR_INVALID_BOUNDERIES";
            }
            case 49206: {
                return "PAR_PDU_CALCULATION_IMPOSSIBLE";
            }
            case 49207: {
                return "PAR_OBJECT_NOT_FOUND";
            }
            case 49208: {
                return "PAR_RESPONSEPARAMETER_MISMATCH";
            }
            case 49209: {
                return "PAR_NO_ECU_CONFIG_SERVICE";
            }
            case 51728: {
                return "JOB_INCONSISTENT_PARAMETERS";
            }
            case 51729: {
                return "JOB_UNEXPECTED_ENVIRONMENT";
            }
            case 51730: {
                return "JOB_CRITICAL_ABORT";
            }
            case 51731: {
                return "JOB_UNEXPECTED_ERROR_OCCURED";
            }
            case 53264: {
                return "RT_NOT_ALLOWED_IN_STATE_INITIALIZED";
            }
            case 53265: {
                return "RT_NOT_ALLOWED_IN_STATE_PROJECT_SELECTED";
            }
            case 53266: {
                return "RT_NOT_ALLOWED_IN_STATE_LOGICALLY_CONNECTED";
            }
            case 53267: {
                return "RT_NOT_ALLOWED_IN_STATE_DBPROJECT_CONFIGURATION";
            }
            case 53268: {
                return "RT_PRJ_CREATION_FAILED";
            }
            case 53269: {
                return "RT_LL_CREATION_FAILED";
            }
            case 53270: {
                return "RT_LL_QUEUE_FULL";
            }
            case 53271: {
                return "RT_DELETION_NOT_POSSIBLE_SUBOBJECTS_IN_USE";
            }
            case 53272: {
                return "eRT_NOT_ALLOWED_IN_THIS_OBJECT_STATE (RT_NOT_ALLOWED_IN_LL_STATE_CREATED)";
            }
            case 53273: {
                return "RT_NOT_ALLOWED_IN_LL_STATE_OFFLINE";
            }
            case 53274: {
                return "RT_NOT_ALLOWED_IN_LL_STATE_ONLINE";
            }
            case 53275: {
                return "RT_NOT_ALLOWED_IN_LL_STATE_COMMUNICATION";
            }
            case 53277: {
                return "RT_NOT_ALLOWED_IN_SERVICE_STATE_IDLE";
            }
            case 53278: {
                return "RT_NOT_ALLOWED_IN_SERVICE_STATE_PENDING";
            }
            case 53279: {
                return "RT_NOT_ALLOWED_IN_SERVICE_STATE_NOT_REPEATING";
            }
            case 53280: {
                return "RT_NOT_ALLOWED_IN_SERVICE_STATE_REPEATING";
            }
            case 53281: {
                return "RT_COL_CREATION_FAILED";
            }
            case 53282: {
                return "RT_COL_COLLECTED_OBJECT_CREATION_FAILED";
            }
            case 53283: {
                return "RT_COL_BUFFER_OVERFLOW";
            }
            case 53284: {
                return "RT_COL_CHECK_FAILED";
            }
            case 53285: {
                return "RT_COL_ACTIVATE_FAILED";
            }
            case 53286: {
                return "RT_COL_START_FAILED";
            }
            case 53287: {
                return "RT_COL_STOP_FAILED";
            }
            case 53288: {
                return "RT_COL_DEACTIVATE_FAILED";
            }
            case 53289: {
                return "RT_COL_CHANGE_FAILED";
            }
            case 53290: {
                return "RT_COL_DELETE_FAILED";
            }
            case 53291: {
                return "RT_COL_CHAR_NOT_SUPPORTED";
            }
            case 53292: {
                return "RT_COL_CURVE_MAP_NOT_SUPPORTED";
            }
            case 53293: {
                return "RT_OBJECT_IS_MEMBER";
            }
            case 53294: {
                return "RT_ONLY_ALLOWED_IN_COL_STATE_ACTIVATED";
            }
            case 53295: {
                return "RT_ONLY_ALLOWED_IN_COL_STATE_CONFIGURED";
            }
            case 53296: {
                return "RT_ONLY_ALLOWED_IN_COL_STATE_STARTED";
            }
            case 53297: {
                return "RT_NOT_ALLOWED_IN_COL_STATE_ACTIVATED";
            }
            case 53298: {
                return "RT_NOT_ALLOWED_IN_COL_STATE_CONFIGURED";
            }
            case 53299: {
                return "RT_NOT_ALLOWED_IN_COL_STATE_STARTED";
            }
            case 53300: {
                return "RT_CHAR_CREATION_FAILED";
            }
            case 53301: {
                return "RT_CHAR_NOT_SUPPORTED";
            }
            case 53302: {
                return "RT_CHAR_READ_FAILED";
            }
            case 53303: {
                return "RT_CHAR_WRITE_FAILED";
            }
            case 53304: {
                return "RT_SERVICE_SYNC_NOT_ALLOWED";
            }
            case 53305: {
                return "RT_SERVICE_ASYNC_NOT_ALLOWED";
            }
            case 53306: {
                return "RT_SERVICE_REPEATED_NOT_ALLOWED";
            }
            case 53307: {
                return "RT_SERVICE_REPEATED_NOT_STOPPED";
            }
            case 53308: {
                return "RT_SERVICE_NOT_CANCELED";
            }
            case 53309: {
                return "RT_NO_RESPONSE_PARAMETER_AVAILABLE";
            }
            case 53310: {
                return "RT_NO_REQUEST_PARAMETER_AVAILABLE";
            }
            case 53311: {
                return "RT_MODULE_IS_OFFLINE";
            }
            case 53312: {
                return "RT_INVALID_PARENT";
            }
            case 53313: {
                return "RT_NO_ACTIVE_OBJECT";
            }
            case 53314: {
                return "RT_OBJECT_DISCONNECTED";
            }
            case 53315: {
                return "RT_INTERNAL_ERROR";
            }
            case 53316: {
                return "RT_NO_DYNAMIC_MODE";
            }
            case 53317: {
                return "RT_NO_FILTER_MODE";
            }
            case 53318: {
                return "RT_NO_UNIQUE_SEMANTIC_ATTRIBUTE";
            }
            case 53319: {
                return "RT_NO_EXTERNAL_ACCESS_METHOD";
            }
            case 53320: {
                return "RT_NO_DATA_COM_PRIMITIVE";
            }
            case 53322: {
                return "RT_NOT_ALLOWED_IN_ACTIVITY_STATE_IDLE";
            }
            case 53323: {
                return "RT_NOT_ALLOWED_IN_ACTIVITY_STATE_RUNNING";
            }
            case 53324: {
                return "RT_NOT_ALLOWED_IN_ACTIVITIY_STATE_SUSPENDED";
            }
            case 53325: {
                return "RT_INVALID_TRANSMISSION_MODE";
            }
            case 53326: {
                return "RT_INVALID_RUNTIME_MODE";
            }
            case 53327: {
                return "RT_SERVICE_EXECUTION_FAILED";
            }
            case 53328: {
                return "RT_RESULT_INCOMPLETE";
            }
            case 53329: {
                return "RT_COL_STOP_REQUIRED";
            }
            case 53330: {
                return "RT_NO_UNIQUE_ELEMENT";
            }
            case 53331: {
                return "RT_SERVICE_RUNNING";
            }
            case 53332: {
                return "RT_PROTOCOLPARAMETERSET_FAILED";
            }
            case 53333: {
                return "RT_WRONG_SEQUENCE";
            }
            case 53334: {
                return "RT_FLASHJOB_REPEATED_NOT_ALLOWED";
            }
            case 53335: {
                return "RT_VALUE_OUT_OF_RANGE";
            }
            case 53336: {
                return "RT_INVALID_RESPONSE";
            }
            case 53337: {
                return "RT_ELEMENT_NOT_AVAILABLE";
            }
            case 53338: {
                return "RT_INVALID_OPERATION";
            }
            case 53339: {
                return "RT_DYNID_ALREADY_USED";
            }
            case 53340: {
                return "RT_NOT_ALLOWED_FOR_ACTIVE_PROJECT";
            }
            case 53341: {
                return "RT_PDU_NOT_AVAILABLE";
            }
            case 53342: {
                return "RT_ELEMENT_ALREADY_EXISTS";
            }
            case 53343: {
                return "RT_FEATURE_NOT_AVAILABLE";
            }
            case 53344: {
                return "RT_UNEXPECTED_RESPONSE";
            }
            case 53345: {
                return "RT_VALUE_NOT_INITIALIZED";
            }
            case 53346: {
                return "RT_MALFORMED_JOB_CODE";
            }
            case 53347: {
                return "RT_CANNOT_CALCULATE_SYSTEM_PARAMETER";
            }
            case 53348: {
                return "RT_INSUFFICIENT_RIGHTS";
            }
            case 53349: {
                return "RT_INVALID_OBJECT";
            }
            case 53350: {
                return "RT_NO_LATE_BOUND_DATA_FILE";
            }
            case 53351: {
                return "RT_FILENAME_MISMATCH";
            }
            case 53352: {
                return "RT_FILE_NOT_FOUND";
            }
            case 53353: {
                return "RT_DB_FLASH_SEGMENTS_AVAILABLE";
            }
            case 53360: {
                return "RT_NOT_ALLOWED_IN_DOWNLOAD_SESSION";
            }
            case 53361: {
                return "RT_WATCHER_ACTIVATION_FAILED";
            }
            case 53362: {
                return "RT_NO_VARIANT_IDENTIFIED";
            }
            case 53363: {
                return "RT_METHOD_NOT_SUPPORTED_FOR_PARAMETER_TYPE";
            }
            case 53364: {
                return "RT_UNSUPPORTED_HASH_ALGORITHM";
            }
            case 53365: {
                return "RT_WRONG_HASH_VALUE";
            }
            case 53366: {
                return "RT_UNSUPPORTED_ENCRYPTION_ALGORITHM";
            }
            case 53367: {
                return "RT_NO_VIT_SELECTED";
            }
            case 53369: {
                return "RT_OBJECT_IS_LOCKED";
            }
            case 53376: {
                return "RT_LOCK_FAILED";
            }
            case 53377: {
                return "RT_OBJECT_IS_UNLOCKED";
            }
            case 53378: {
                return "RT_SUBOBJECT_IS_LOCKED";
            }
            case 53379: {
                return "RT_INVALID_DEPENDENT_STATES";
            }
            case 53380: {
                return "RT_PARENT_OBJECT_IS_LOCKED";
            }
            case 53381: {
                return "RT_INVALID_FILENAME";
            }
            case 53382: {
                return "RT_FILE_IN_USE";
            }
            case 53383: {
                return "RT_UNSUPPORTED_FILE_FORMAT";
            }
            case 53384: {
                return "RT_FILE_CORRUPTED";
            }
            case 53385: {
                return "RT_INTERFACE_NOT_CONNECTED";
            }
            case 53392: {
                return "RT_PDU_API_CALL_FAILED";
            }
            case 53393: {
                return "RT_PDU_API_NOT_SUPPORTED";
            }
            case 53394: {
                return "RT_CYCLIC_CASCADE";
            }
            case 53395: {
                return "RT_VALUE_NOT_AVAILABLE";
            }
            case 53396: {
                return "RT_INSTRUCTION_QUEUE_NOT_EMPTY";
            }
            case 53397: {
                return "RT_METHOD_NOT_SUPPORTED_FOR_DATA_TYPE";
            }
            case 53398: {
                return "RT_SERVICE_VIS_NOT_EXECUTED";
            }
            case 53399: {
                return "RT_VALUE_OF_DIFFERENT_TYPE";
            }
            case 53400: {
                return "RT_MAXIMUM_NUMBER_OF_CLIENTS_REACHED";
            }
            case 53401: {
                return "RT_NOT_ALLOWED_IN_DBPROJECT_CONFIGURATION";
            }
            case 53408: {
                return "RT_REPEATED_SERVICE_RUNNING";
            }
            case 53409: {
                return "RT_NO_TEXTTABLE";
            }
            case 53410: {
                return "RT_NO_COMMUNICATION_TO_GATEWAY";
            }
            case 53411: {
                return "RT_PROHIBITED_BY_AUDIENCE_FILTER";
            }
            case 53412: {
                return "RT_PRECONDITION_NOT_MET";
            }
            case 53413: {
                return "RT_BASE_VARIANT_IDENTIFICATION_ABORTED";
            }
            case 53414: {
                return "RT_NO_BASE_VARIANT_IDENTIFIED";
            }
            case 53415: {
                return "RT_MALFORMED_COMPUCODE";
            }
            case 53416: {
                return "RT_INVALID_COMPUCODE_RESULT";
            }
            case 53417: {
                return "RT_DIFFERENT_ECU_GROUP_MEMBER_IDENTIFIED";
            }
            case 53418: {
                return "RT_COL_BUFFER_INVALID";
            }
            case 53419: {
                return "RT_JOB_CANCELLATION_TIMEOUT_REACHED";
            }
            case 53420: {
                return "RT_CONFIGRECORD_INVALID";
            }
            case 53421: {
                return "RT_COMPUCODE_FAILED";
            }
            case 53422: {
                return "RT_OPERATION_NOT_ALLOWED";
            }
            case 53423: {
                return "RT_VCI_ACCESS_LAYER_NOT_PREPARED";
            }
            case 53424: {
                return "RT_COMMUNICATION_ERROR";
            }
            case 53425: {
                return "RT_VCI_ACCESS_LAYER_ALREADY_PREPARED";
            }
            case 57360: {
                return "DB_MCD2_DATA_ACCESS_IMPOSSIBLE";
            }
            case 57361: {
                return "DB_PARSE_ERROR";
            }
            case 57362: {
                return "DB_ELEMENT_NOT_AVAILABLE";
            }
            case 57363: {
                return "DB_OBJECT_NOT_FOUND";
            }
            case 57364: {
                return "DB_NO_LENGTH_INFORMATION";
            }
            case 57365: {
                return "DB_NO_MIN_OR_MAX_VALUE";
            }
            case 57366: {
                return "DB_NO_DEFAULT_VALUE";
            }
            case 57367: {
                return "DB_INCONSISTENT_DATABASE";
            }
            case 57368: {
                return "DB_END_OF_FLASH_FILE";
            }
            case 57369: {
                return "DB_INVALID_PROPERTY_FORMAT";
            }
            case 57376: {
                return "DB_MALFORMED_BINARY_DATA";
            }
            case 57377: {
                return "DB_DATAFORMAT_INVALID";
            }
            case 57378: {
                return "DB_WRONG_DATATYPE";
            }
            case 58640: {
                return "SYSTEM_RESOURCE_OVERLOAD";
            }
            case 58641: {
                return "SYSTEM_NO_MULTI_CLIENT";
            }
            case 58642: {
                return "SYSTEM_INTERFACE_NOT_SUPPORTED";
            }
            case 58643: {
                return "SYSTEM_METHOD_NOT_SUPPORTED";
            }
            case 58644: {
                return "SYSTEM_TIMEOUT";
            }
            case 58645: {
                return "SYSTEM_VALUE_OUT_OF_RANGE";
            }
            case 58646: {
                return "SYSTEM_OVERFLOW";
            }
            case 58647: {
                return "SYSTEM_DIVISION_BY_ZERO";
            }
            case 58648: {
                return "SYSTEM_INTERNAL_VALUE_OUT_OF_RANGE";
            }
            case 58649: {
                return "SYSTEM_COMPU_METHOD_FAILED";
            }
            case 58650: {
                return "SYSTEM_INTERNAL_ERROR";
            }
            case 58651: {
                return "SYSTEM_SUBSYSTEM_FUNCTION_CALL_FAILED";
            }
            case 58652: {
                return "SYSTEM_NOT_ALLOWED_IN_MULTI_CLIENT_MODE";
            }
            case 59920: {
                return "COM_NO_CONNECTION";
            }
            case 59921: {
                return "COM_CONNECTION_INTERRUPTED";
            }
            case 59922: {
                return "COM_CONNECTION_FAILED";
            }
            case 59923: {
                return "COM_DISCONNECTION_FAILED";
            }
            case 59924: {
                return "COM_BUS_ERROR";
            }
            case 59925: {
                return "COM_RX_TIMEOUT";
            }
            case 59926: {
                return "COM_COMPARAM_NOT_SUPPORTED";
            }
            case 59927: {
                return "COM_COMPARAM_LOCKED";
            }
            case 59928: {
                return "COM_INVALID_PARAMETERS";
            }
            case 61456: {
                return "SHARE_SYSTEM_LOCKED_BY_ANOTHER_OBJECT";
            }
            case 61457: {
                return "SHARE_LL_LOCKED_BY_ANOTHER_OBJECT";
            }
            case 61458: {
                return "SHARE_LL_LOCKED_BY_THIS_OBJECT";
            }
            case 61459: {
                return "SHARE_LL_UNLOCKED";
            }
            case 61460: {
                return "SHARE_SYSTEM_LOCKED_BY_THIS_OBJECT";
            }
            case 61461: {
                return "SHARE_SYSTEM_UNLOCKED";
            }
        }
        return "*** UNKNOWN " + MCDErrorCodes.class.getName() + " ***: 0x" + Integer.toHexString(pMcdErrorCodes).toUpperCase();
    }

    public static final String decodeMcdExecutionState(int pMcdExecutionState) {
        switch (pMcdExecutionState) {
            case 25345: {
                return "OK";
            }
            case 25346: {
                return "CANCELED_FROM_QUEUE";
            }
            case 25347: {
                return "CANCELED_DURING_EXECUTION";
            }
            case 25348: {
                return "FAILED";
            }
            case 25349: {
                return "REJECTED";
            }
            case 25350: {
                return "ALL_FAILED";
            }
            case 25351: {
                return "INVALID_RESPONSE";
            }
            case 25352: {
                return "ALL_INVALID_RESPONSE";
            }
            case 25353: {
                return "ALL_POSITIVE";
            }
            case 25354: {
                return "NEGATIVE";
            }
            case 25355: {
                return "ALL_NEGATIVE";
            }
        }
        return "*** UNKNOWN " + MCDExecutionState.class.getName() + " ***: 0x" + Integer.toHexString(pMcdExecutionState).toUpperCase();
    }

    public static final String decodeMcdFlashDataFormat(int pMcdFlashDataFormat) {
        switch (pMcdFlashDataFormat) {
            case 27393: {
                return "BINARY";
            }
            case 27394: {
                return "INTEL_HEX";
            }
            case 27395: {
                return "MOTOROLA_S";
            }
            case 27396: {
                return "USER_DEFINED";
            }
        }
        return "*** UNKNOWN " + MCDFlashDataFormat.class.getName() + " ***: 0x" + Integer.toHexString(pMcdFlashDataFormat).toUpperCase();
    }

    public static final String decodeMcdGatewayMode(int pMcdGatewayMode) {
        switch (pMcdGatewayMode) {
            case 28161: {
                return "TRANSPARENT_GATEWAY";
            }
            case 28162: {
                return "VISIBLE_GATEWAY";
            }
            case 28163: {
                return "NO_GATEWAY";
            }
        }
        return "*** UNKNOWN " + MCDGatewayMode.class.getName() + " ***: 0x" + Integer.toHexString(pMcdGatewayMode).toUpperCase();
    }

    public static final String decodeMcdLimitType(int pMcdLimitType) {
        switch (pMcdLimitType) {
            case 27905: {
                return "LIMIT_OPEN";
            }
            case 27906: {
                return "LIMIT_CLOSED";
            }
            case 27907: {
                return "LIMIT_INFINITE";
            }
        }
        return "*** UNKNOWN " + MCDLimitType.class.getName() + " ***: 0x" + Integer.toHexString(pMcdLimitType).toUpperCase();
    }

    public static final String decodeMcdLocationType(int pMcdLocationType) {
        switch (pMcdLocationType) {
            case 257: {
                return "ECU_BASE_VARIANT";
            }
            case 258: {
                return "ECU_VARIANT";
            }
            case 259: {
                return "FUNCTIONAL_GROUP";
            }
            case 260: {
                return "MULTIPLE_ECU_JOB";
            }
            case 261: {
                return "PROTOCOL";
            }
            case 262: {
                return "MODULE";
            }
        }
        return "*** UNKNOWN " + MCDLocationType.class.getName() + " ***: 0x" + Integer.toHexString(pMcdLocationType).toUpperCase();
    }

    public static final String decodeMcdLockState(int pMcdLockState) {
        switch (pMcdLockState) {
            case 512: {
                return "LS_LOCKED_BY_THIS_CLIENT";
            }
            case 513: {
                return "UNLOCKED";
            }
            case 514: {
                return "LOCKED_BY_THIS_OBJECT";
            }
            case 515: {
                return "LOCKED_BY_ANOTHER_OBJECT";
            }
            case 516: {
                return "LS_UNLOCKED";
            }
        }
        return "*** UNKNOWN " + MCDLockState.class.getName() + " ***: 0x" + Integer.toHexString(pMcdLockState).toUpperCase();
    }

    public static final String decodeMcdLogicalLinkState(int pMcdLogicalLinkState) {
        switch (pMcdLogicalLinkState) {
            case 769: {
                return "CREATED";
            }
            case 770: {
                return "OFFLINE";
            }
            case 771: {
                return "ONLINE";
            }
            case 772: {
                return "COMMUNICATION";
            }
        }
        return "*** UNKNOWN " + MCDLogicalLinkState.class.getName() + " ***: 0x" + Integer.toHexString(pMcdLogicalLinkState).toUpperCase();
    }

    public static final String decodeMcdLogicalLinkType(int pMcdLogicalLinkType) {
        switch (pMcdLogicalLinkType) {
            case 2817: {
                return "LLTYPE_COLLECTION_CONTROLLED";
            }
            case 2818: {
                return "LLTYPE_CLIENT_CONTROLLED";
            }
        }
        return "*** UNKNOWN " + MCDLogicalLinkType.class.getName() + " ***: 0x" + Integer.toHexString(pMcdLogicalLinkType).toUpperCase();
    }

    public static final String decodeMcdObjectType(int pMcdObjectType) {
        switch (pMcdObjectType) {
            case 1026: {
                return "MCDOBJECTFACTORY";
            }
            case 1027: {
                return "MCDCOLLECTION";
            }
            case 1028: {
                return "MCDCOMMUNICATIONEXCEPTION";
            }
            case 1029: {
                return "MCDDATABASEEXCEPTION";
            }
            case 1030: {
                return "MCDDBLOCATION";
            }
            case 1031: {
                return "MCDDBLOCATIONS";
            }
            case 1032: {
                return "MCDDBLOGICALLINK";
            }
            case 1033: {
                return "MCDDBLOGICALLINKS";
            }
            case 1034: {
                return "MCDDBPHYSICALVEHICLELINKORINTERFACE";
            }
            case 1035: {
                return "MCDDBPHYSICALVEHICLELINKORINTERFACES";
            }
            case 1036: {
                return "MCDDBPROJECT";
            }
            case 1037: {
                return "MCDDBPROJECTDESCRIPTION";
            }
            case 1038: {
                return "MCDDBPROJECTDESCRIPTIONS";
            }
            case 1040: {
                return "MCDDBVEHICLEINFORMATION";
            }
            case 1041: {
                return "MCDDBVEHICLEINFORMATIONS";
            }
            case 1042: {
                return "MCDERROR";
            }
            case 1043: {
                return "MCDEXCEPTION";
            }
            case 1044: {
                return "MCDLOGICALLINK";
            }
            case 1047: {
                return "MCDNAMEDCOLLECTION";
            }
            case 1048: {
                return "MCDNAMEDOBJECT";
            }
            case 1051: {
                return "MCDPARAMETERIZATIONEXCEPTION";
            }
            case 1052: {
                return "MCDPROGRAMVIOLATIONEXCEPTION";
            }
            case 1053: {
                return "MCDPROJECT";
            }
            case 1054: {
                return "MCDRESPONSE";
            }
            case 1055: {
                return "MCDRESPONSEPARAMETER";
            }
            case 1056: {
                return "MCDRESPONSEPARAMETERS";
            }
            case 1057: {
                return "MCDRESPONSES";
            }
            case 1058: {
                return "MCDRESULT";
            }
            case 1059: {
                return "MCDRESULTS";
            }
            case 1060: {
                return "MCDSHAREEXCEPTION";
            }
            case 1061: {
                return "MCDSYSTEM";
            }
            case 1063: {
                return "MCDSYSTEMEXCEPTION";
            }
            case 1064: {
                return "MCDVALUE";
            }
            case 1065: {
                return "MCDVALUES";
            }
            case 1066: {
                return "MCDVERSION";
            }
            case 1067: {
                return "MCDDBPROJECTCONFIGURATION";
            }
            case 1068: {
                return "MCDOBJECT";
            }
            case 1069: {
                return "MCDDBOBJECT";
            }
            case 1070: {
                return "MCDPARAMETER";
            }
            case 1088: {
                return "MCDBUFFER";
            }
            case 1090: {
                return "MCDCOLLECTEDOBJECT";
            }
            case 1091: {
                return "MCDCOLLECTEDOBJECTS";
            }
            case 1092: {
                return "MCDCOLLECTOR";
            }
            case 1093: {
                return "MCDCOLLECTORDESCRIPTION";
            }
            case 1095: {
                return "MCDCOLLECTORS";
            }
            case 1098: {
                return "MCDDBMEASUREMENT";
            }
            case 1099: {
                return "MCDDBMEASUREMENTS";
            }
            case 1101: {
                return "MCDSCALARCOLLECTORDESCRIPTION";
            }
            case 1102: {
                return "MCDSTORAGE";
            }
            case 1103: {
                return "MCDSTORAGEAUSY";
            }
            case 1104: {
                return "MCDSTORAGEFILE";
            }
            case 1105: {
                return "MCDCURVECOLLECTORDESCRIPTION";
            }
            case 1106: {
                return "MCDMAPCOLLECTORDESCRIPTION";
            }
            case 1107: {
                return "eMCDRECORDERS";
            }
            case 1108: {
                return "eMCDWRITEREADRECORDER";
            }
            case 1109: {
                return "eMCDREADRECORDER";
            }
            case 1110: {
                return "eMCDWRITEREADRECORDERCOLLECTORS";
            }
            case 1111: {
                return "eMCDREADRECORDERCOLLECTORS";
            }
            case 1112: {
                return "eMCDWRITEREADRECORDERCOLLECTOR";
            }
            case 1113: {
                return "eMCDREADRECORDERCOLLECTOR";
            }
            case 1114: {
                return "eMCDBASEEVENTTRIGGERSOURCE";
            }
            case 1115: {
                return "eMCDBASETIMETRIGGERSOURCE";
            }
            case 1116: {
                return "eMCDBASETRIGGER";
            }
            case 1117: {
                return "eMCDBASETRIGGERSOURCE";
            }
            case 1118: {
                return "eMCDBASEVALUETRIGGERSOURCE";
            }
            case 1120: {
                return "MCDCHARACTERISTIC";
            }
            case 1122: {
                return "MCDCHARACTERISTICS";
            }
            case 1123: {
                return "MCDCURVECHARACTERISTIC";
            }
            case 1124: {
                return "MCDDBAXISDESCRIPTION";
            }
            case 1126: {
                return "MCDDBAXISPOINTS";
            }
            case 1127: {
                return "MCDDBAXISPTS";
            }
            case 1128: {
                return "MCDDBCHARACTERISTIC";
            }
            case 1130: {
                return "MCDDBMAPCHARACTERISTIC";
            }
            case 1131: {
                return "MCDDBCHARACTERISTICS";
            }
            case 1132: {
                return "MCDDBSCALARCHARACTERISTIC";
            }
            case 1133: {
                return "MCDDBCURVECHARACTERISTIC";
            }
            case 1134: {
                return "MCDMAPCHARACTERISTIC";
            }
            case 1135: {
                return "MCDMATRIXCHARACTERISTIC";
            }
            case 1136: {
                return "MCDSCALARCHARACTERISTIC";
            }
            case 1137: {
                return "MCDVECTORCHARACTERISTIC";
            }
            case 1138: {
                return "MCDVALUEARRAY";
            }
            case 1139: {
                return "MCDVALUEMATRIX";
            }
            case 1140: {
                return "MCDVALUECURVE";
            }
            case 1141: {
                return "MCDVALUEMAP";
            }
            case 1142: {
                return "eMCDDBVALUEBLOCKCHARACTERISTIC";
            }
            case 1143: {
                return "eMCDVALUEBLOCKCHARACTERISTIC";
            }
            case 1144: {
                return "eMCDASCIICHARACTERISTIC";
            }
            case 1145: {
                return "eMCDDBASCIICHARACTERISTIC";
            }
            case 1152: {
                return "MCDDBPARAMETERS";
            }
            case 1153: {
                return "eMCDDBODXFILE";
            }
            case 1154: {
                return "MCDDBDIAGCOMPRIMITIVES";
            }
            case 1155: {
                return "eMCDDBODXFILES";
            }
            case 1156: {
                return "MCDDBECUBASEVARIANT";
            }
            case 1157: {
                return "MCDDBECUBASEVARIANTS";
            }
            case 1158: {
                return "MCDDBECUVARIANT";
            }
            case 1159: {
                return "MCDDBECUVARIANTS";
            }
            case 1160: {
                return "MCDDBFUNCTIONALCLASS";
            }
            case 1161: {
                return "MCDDBFUNCTIONALCLASSES";
            }
            case 1162: {
                return "MCDDBFUNCTIONALGROUP";
            }
            case 1163: {
                return "MCDDBFUNCTIONALGROUPS";
            }
            case 1164: {
                return "eMCDDBDLOGICALLINK";
            }
            case 1165: {
                return "eMCDDBENVDATADESC";
            }
            case 1166: {
                return "eMCDDBENVDATADESCS";
            }
            case 1167: {
                return "MCDDBHEXSERVICE";
            }
            case 1168: {
                return "MCDDBMULTIPLEECUJOB";
            }
            case 1169: {
                return "eMCDDBINFOCOMPONENTSET";
            }
            case 1170: {
                return "MCDDBPROTOCOLPARAMETER";
            }
            case 1171: {
                return "MCDDBPROTOCOLPARAMETERSET";
            }
            case 1172: {
                return "MCDDBREQUESTPARAMETER";
            }
            case 1173: {
                return "MCDDBRESPONSE";
            }
            case 1174: {
                return "MCDDBRESPONSEPARAMETER";
            }
            case 1175: {
                return "MCDDBRESPONSEPARAMETERS";
            }
            case 1176: {
                return "MCDDBRESPONSES";
            }
            case 1177: {
                return "MCDDBSERVICE";
            }
            case 1178: {
                return "MCDDBSERVICES";
            }
            case 1179: {
                return "MCDDBSINGLEECUJOB";
            }
            case 1180: {
                return "MCDDBSTARTCOMMUNICATION";
            }
            case 1181: {
                return "MCDDBSTOPCOMMUNICATION";
            }
            case 1182: {
                return "MCDDBVARIANTIDENTIFICATION";
            }
            case 1183: {
                return "MCDDBVARIANTIDENTIFICATIONANDSELECTION";
            }
            case 1184: {
                return "MCDDBVEHICLECONNECTOR";
            }
            case 1185: {
                return "MCDDBVEHICLECONNECTORPIN";
            }
            case 1186: {
                return "MCDDBVEHICLECONNECTORPINS";
            }
            case 1187: {
                return "eMCDDBFLASHSESSIONDESC";
            }
            case 1188: {
                return "eMCDDBFLASHSESSIONDESCS";
            }
            case 1189: {
                return "eMCDVERSIONS";
            }
            case 1190: {
                return "MCDHEXSERVICE";
            }
            case 1191: {
                return "MCDJOBAPI";
            }
            case 1192: {
                return "MCDMULTIPLEECUJOB";
            }
            case 1193: {
                return "MCDPROTOCOLPARAMETERSET";
            }
            case 1194: {
                return "MCDREQUESTPARAMETER";
            }
            case 1195: {
                return "MCDREQUESTPARAMETERS";
            }
            case 1196: {
                return "MCDRESULTSTATE";
            }
            case 1197: {
                return "MCDFLASHJOB";
            }
            case 1198: {
                return "MCDSERVICE";
            }
            case 1199: {
                return "eMCDJOBEXCEPTION";
            }
            case 1200: {
                return "MCDSINGLEECUJOB";
            }
            case 1201: {
                return "MCDSTARTCOMMUNICATION";
            }
            case 1202: {
                return "MCDSTOPCOMMUNICATION";
            }
            case 1203: {
                return "MCDTEXTTABLEELEMENT";
            }
            case 1204: {
                return "MCDTEXTTABLEELEMENTS";
            }
            case 1205: {
                return "MCDVARIANTIDENTIFICATION";
            }
            case 1206: {
                return "MCDVARIANTIDENTIFICATIONANDSELECTION";
            }
            case 1207: {
                return "MCDDBFLASHCHECKSUM";
            }
            case 1208: {
                return "MCDDBFLASHCHECKSUMS";
            }
            case 1209: {
                return "MCDDBFLASHDATA";
            }
            case 1210: {
                return "MCDDBFLASHDATABLOCK";
            }
            case 1211: {
                return "MCDDBFLASHDATABLOCKS";
            }
            case 1212: {
                return "MCDDBFLASHFILTER";
            }
            case 1213: {
                return "MCDDBFLASHFILTERS";
            }
            case 1214: {
                return "MCDDBFLASHIDENT";
            }
            case 1215: {
                return "MCDDBFLASHIDENTS";
            }
            case 1216: {
                return "MCDDBFLASHJOB";
            }
            case 1217: {
                return "MCDDBFLASHSECURITIES";
            }
            case 1218: {
                return "MCDDBFLASHSECURITY";
            }
            case 1219: {
                return "MCDDBFLASHSEGMENT";
            }
            case 1220: {
                return "MCDDBFLASHSEGMENTS";
            }
            case 1221: {
                return "MCDDBFLASHSESSION";
            }
            case 1222: {
                return "MCDDBFLASHSESSIONCLASS";
            }
            case 1223: {
                return "MCDDBFLASHSESSIONCLASSES";
            }
            case 1224: {
                return "MCDDBFLASHSESSIONS";
            }
            case 1225: {
                return "MCDDBVEHICLECONNECTORS";
            }
            case 1226: {
                return "MCDACCESSKEY";
            }
            case 1227: {
                return "MCDACCESSKEYS";
            }
            case 1228: {
                return "MCDDBDIAGTROUBLECODE";
            }
            case 1229: {
                return "MCDDBDIAGTROUBLECODES";
            }
            case 1230: {
                return "MCDERRORS";
            }
            case 1232: {
                return "MCDDBBINARIES";
            }
            case 1233: {
                return "MCDDBBINARY";
            }
            case 1234: {
                return "MCDDBCOMPUMETHOD";
            }
            case 1235: {
                return "MCDDBCOMPUMETHODS";
            }
            case 1236: {
                return "MCDDBCOMPUTAB";
            }
            case 1237: {
                return "MCDDBCOMPUTABS";
            }
            case 1238: {
                return "MCDDBCOMPUVTAB";
            }
            case 1239: {
                return "MCDDBCOMPUVTABRANGE";
            }
            case 1240: {
                return "MCDDBCOMPUVTABRANGES";
            }
            case 1241: {
                return "MCDDBCOMPUVTABS";
            }
            case 1242: {
                return "MCDDBFUNCTION";
            }
            case 1243: {
                return "MCDDBFUNCTIONS";
            }
            case 1244: {
                return "MCDDBGROUP";
            }
            case 1245: {
                return "MCDDBGROUPS";
            }
            case 1246: {
                return "MCDDBMODPAR";
            }
            case 1247: {
                return "MCDRATEINFO";
            }
            case 1248: {
                return "MCDRATEINFOS";
            }
            case 1249: {
                return "MCDDBTAB";
            }
            case 1250: {
                return "MCDDBTABS";
            }
            case 1251: {
                return "MCDDBUNIT";
            }
            case 1252: {
                return "MCDDBUNITS";
            }
            case 1253: {
                return "MCDDBVTAB";
            }
            case 1254: {
                return "MCDDBVTABRANGE";
            }
            case 1255: {
                return "MCDDBVTABRANGES";
            }
            case 1256: {
                return "MCDDBVTABS";
            }
            case 1258: {
                return "MCDLOGICALLINKS";
            }
            case 1260: {
                return "MCDTIMEDELAY";
            }
            case 1263: {
                return "MCDDBCOMPUTABBASE";
            }
            case 3200: {
                return "MCDDATAPRIMITIVE";
            }
            case 3201: {
                return "MCDDIAGSERVICE";
            }
            case 3202: {
                return "MCDDBDATAPRIMITIVE";
            }
            case 3203: {
                return "MCDDBDIAGSERVICE";
            }
            case 3204: {
                return "MCDCONTROLPRIMITIVE";
            }
            case 3205: {
                return "MCDDBCONTROLPRIMITIVE";
            }
            case 3206: {
                return "MCDDBDIAGVARIABLE";
            }
            case 3207: {
                return "MCDDBDIAGVARIABLES";
            }
            case 3209: {
                return "MCDDBREQUEST";
            }
            case 3210: {
                return "MCDREQUEST";
            }
            case 3211: {
                return "MCDDBECUMEM";
            }
            case 3212: {
                return "MCDDBECUMEMS";
            }
            case 3213: {
                return "MCDDBACCESSLEVEL";
            }
            case 3214: {
                return "MCDDBREQUESTPARAMETERS";
            }
            case 3215: {
                return "MCDDBDYNIDDEFINECOMPRIMITIVE";
            }
            case 3216: {
                return "MCDDBDYNIDREADCOMPRIMITIVE";
            }
            case 3217: {
                return "MCDDYNIDDEFINECOMPRIMITIVE";
            }
            case 3218: {
                return "MCDDYNIDREADCOMPRIMITIVE";
            }
            case 3220: {
                return "MCDDBDIAGSERVICES";
            }
            case 3221: {
                return "MCDDBCONTROLPRIMITIVES";
            }
            case 3222: {
                return "MCDDIAGCOMPRIMITIVES";
            }
            case 3223: {
                return "MCDINTERVAL";
            }
            case 3224: {
                return "MCDDBIDENTDESCRIPTION";
            }
            case 3225: {
                return "MCDDBPHYSICALMEMORY";
            }
            case 3226: {
                return "MCDDBPHYSICALMEMORIES";
            }
            case 3227: {
                return "MCDDBPHYSICALSEGMENT";
            }
            case 3228: {
                return "MCDDBPHYSICALSEGMENTS";
            }
            case 3229: {
                return "MCDDBJOBS";
            }
            case 3230: {
                return "MCDDBJOB";
            }
            case 3231: {
                return "MCDDBUNITGROUPS";
            }
            case 3232: {
                return "MCDDBUNITGROUP";
            }
            case 3233: {
                return "MCDJOB";
            }
            case 3234: {
                return "MCDDBDATAPRIMITIVES";
            }
            case 3235: {
                return "MCDDBECU";
            }
            case 3236: {
                return "A_ASCIISTRINGS";
            }
            case 3237: {
                return "MCDDBDYNIDCLEARCOMPRIMITIVE";
            }
            case 3238: {
                return "MCDDYNIDCLEARCOMPRIMITIVE";
            }
            case 3239: {
                return "MCDDBSPECIALDATAGROUPS";
            }
            case 3240: {
                return "MCDDBSPECIALDATAGROUP";
            }
            case 3241: {
                return "MCDDBSPECIALDATA";
            }
            case 3242: {
                return "MCDDBSPECIALDATAELEMENT";
            }
            case 3243: {
                return "MCDDBSPECIALDATAGROUPCAPTION";
            }
            case 3244: {
                return "MCDDIAGCOMPRIMITIVE";
            }
            case 3245: {
                return "MCDDBDIAGCOMPRIMITIVE";
            }
            case 3246: {
                return "MCDDBPARAMETER";
            }
            case 3247: {
                return "eMCDDBCODEINFORMATION";
            }
            case 3248: {
                return "eMCDDBCODEINFORMATIONS";
            }
            case 3249: {
                return "eMCDDBSECURITYACCESSJOB";
            }
            case 3250: {
                return "eMCDSECURITYACCESSJOB";
            }
            case 3251: {
                return "eMCDDBFAULTMEMORIES";
            }
            case 3252: {
                return "eMCDDBFAULTMEMORY";
            }
            case 3255: {
                return "eMCDDLOGICALLINK";
            }
            case 3257: {
                return "eMCDDBPROTOCOLPARAMETERS";
            }
            case 3258: {
                return "eMCDFLASHDATABLOCK";
            }
            case 3259: {
                return "eMCDFLASHDATABLOCKS";
            }
            case 3260: {
                return "eMCDFLASHSEGMENT";
            }
            case 3261: {
                return "eMCDFLASHSEGMENTITERATOR";
            }
            case 3262: {
                return "eMCDFLASHSEGMENTS";
            }
            case 3263: {
                return "eMCDFLASHSESSION";
            }
            case 3264: {
                return "eMCDFLASHSESSIONDESC";
            }
            case 3265: {
                return "eMCDFLASHSESSIONDESCS";
            }
            case 3267: {
                return "eMCDPROTOCOLPARAMETERS";
            }
            case 3268: {
                return "eMCDPROTOCOLPARAMETER";
            }
            case 3269: {
                return "eMCDDBDELAY";
            }
            case 3270: {
                return "eMCDDELAY";
            }
            case 3271: {
                return "eMCDDBPHYSICALVEHICLELINK";
            }
            case 3272: {
                return "eMCDDBPHYSICALINTERFACELINK";
            }
            case 3273: {
                return "eMCDDBPHYSICALVEHICLELINKS";
            }
            case 3274: {
                return "eMCDDBPHYSICALINTERFACELINKS";
            }
            case 3275: {
                return "eMCDDBINTERFACECONNECTORPIN";
            }
            case 3276: {
                return "eMCDDBINTERFACECONNECTORPINS";
            }
            case 3277: {
                return "eMCDPHYSICALINTERFACELINK";
            }
            case 3278: {
                return "eMCDPHYSICALINTERFACELINKS";
            }
            case 3279: {
                return "eMCDINTERFACE";
            }
            case 3280: {
                return "MCDGLOBAL";
            }
            case 3281: {
                return "eMCDMCLOGICALLINK";
            }
            case 3282: {
                return "eMCDDBMCLOGICALLINK";
            }
            case 3283: {
                return "eMCDWATCHER";
            }
            case 3284: {
                return "eMCDWATCHERS";
            }
            case 3285: {
                return "eMCDTRIGGERFACTORY";
            }
            case 3286: {
                return "eMCDTRIGGERSOURCEFACTORY";
            }
            case 3287: {
                return "eMCDCONSTANTVALUETRIGGERSOURCE";
            }
            case 3288: {
                return "eMCDSCALARVALUETRIGGERSOURCE";
            }
            case 3290: {
                return "eMCDVECTORVALUETRIGGERSOURCE";
            }
            case 3291: {
                return "eMCDMATRIXVALUETRIGGERSOURCE";
            }
            case 3292: {
                return "eMCDRELATIVETIMETRIGGERSOURCE";
            }
            case 3293: {
                return "eMCDABSOLUTETIMETRIGGERSOURCE";
            }
            case 3294: {
                return "eMCDCONSTANTTIMETRIGGERSOURCE";
            }
            case 3312: {
                return "eMCDUNARYTRIGGER";
            }
            case 3313: {
                return "eMCDBINARYTRIGGER";
            }
            case 3314: {
                return "eMCDGRADIENTTRIGGER";
            }
            case 3315: {
                return "eMCDOFFSETTRIGGER";
            }
            case 3316: {
                return "eMCDEMPTYTRIGGER";
            }
            case 3317: {
                return "eMCDGLOBALEVENTTRIGGERSOURCE";
            }
            case 3318: {
                return "eMCDLOGICALLINKEVENTTRIGGERSOURCE";
            }
            case 3319: {
                return "eMCDSYSTEMEVENTTRIGGERSOURCE";
            }
            case 3320: {
                return "eMCDASCIICOLLECTORDESCRIPTION";
            }
            case 3321: {
                return "eMCDVALUEBLOCKCOLLECTORDESCRIPTION";
            }
            case 3322: {
                return "eMCDREADCOLLECTEDOBJECTS";
            }
            case 3456: {
                return "eMCDINTERFACERESOURCE";
            }
            case 3457: {
                return "eMCDINTERFACERESOURCES";
            }
            case 3458: {
                return "eMCDINTERFACES";
            }
            case 3459: {
                return "eMCDDBPROTOCOLSTACKS";
            }
            case 3460: {
                return "eMCDDBPROTOCOLSTACK";
            }
            case 3461: {
                return "eMCDDBTABLEPARAMETER";
            }
            case 3462: {
                return "eMCDDBTABLEPARAMETERS";
            }
            case 3463: {
                return "eMCDDBTABLE";
            }
            case 3464: {
                return "eMCDDBTABLES";
            }
            case 3465: {
                return "eMCDDBMATCHINGPATTERNS";
            }
            case 3466: {
                return "eMCDDBMATCHINGPATTERN";
            }
            case 3467: {
                return "eMCDDBMATCHINGPARAMETERS";
            }
            case 3468: {
                return "eMCDDBMATCHINGPARAMETER";
            }
            case 3469: {
                return "eMCDCONSTRAINT";
            }
            case 3470: {
                return "eMCDSCALECONSTRAINT";
            }
            case 3471: {
                return "eMCDSCALECONSTRAINTS";
            }
            case 3472: {
                return "eMCDDBCONFIGURATIONDATA";
            }
            case 3473: {
                return "eMCDDBCONFIGURATIONDATAS";
            }
            case 3474: {
                return "eMCDDBCONFIGURATIONRECORD";
            }
            case 3475: {
                return "eMCDDBCONFIGURATIONRECORDS";
            }
            case 3476: {
                return "eMCDDBDATARECORDS";
            }
            case 3477: {
                return "eMCDDBDATARECORD";
            }
            case 3478: {
                return "eMCDDBCODINGDATA";
            }
            case 3479: {
                return "eMCDDBCONFIGURATIONITEM";
            }
            case 3480: {
                return "eMCDDBSYSTEMITEM";
            }
            case 3481: {
                return "eMCDDBCONFIGURATIONIDITEM";
            }
            case 3482: {
                return "eMCDDBDATAIDITEM";
            }
            case 3483: {
                return "eMCDDBOPTIONITEM";
            }
            case 3484: {
                return "eMCDDBSYSTEMITEMS";
            }
            case 3485: {
                return "eMCDDBOPTIONITEMS";
            }
            case 3486: {
                return "eMCDDBITEMVALUE";
            }
            case 3487: {
                return "eMCDDBITEMVALUES";
            }
            case 3488: {
                return "eMCDCONFIGURATIONRECORDS";
            }
            case 3489: {
                return "eMCDCONFIGURATIONRECORD";
            }
            case 3490: {
                return "eMCDCONFIGURATIONITEM";
            }
            case 3491: {
                return "eMCDOPTIONITEM";
            }
            case 3492: {
                return "eMCDCONFIGURATIONIDITEM";
            }
            case 3493: {
                return "eMCDDATAIDITEM";
            }
            case 3494: {
                return "eMCDSYSTEMITEM";
            }
            case 3495: {
                return "eMCDWRITEDIAGCOMPRIMITIVES";
            }
            case 3496: {
                return "eMCDREADDIAGCOMPRIMITIVES";
            }
            case 3497: {
                return "eMCDOPTIONITEMS";
            }
            case 3498: {
                return "eMCDSYSTEMITEMS";
            }
            case 3499: {
                return "eMCDDBPHYSICALDIMENSION";
            }
            case 3500: {
                return "eMCDAUDIENCE";
            }
            case 3501: {
                return "eMCDDBADDITIONALAUDIENCE";
            }
            case 3502: {
                return "eMCDDBADDITIONALAUDIENCES";
            }
            case 3503: {
                return "eMCDDBINTERFACECABLE";
            }
            case 3504: {
                return "eMCDDBINTERFACECABLES";
            }
            case 3505: {
                return "eMCDCONFIGURATIONRECORDEVENTHANDLER";
            }
            case 3506: {
                return "eMCDDBECUSTATE";
            }
            case 3507: {
                return "eMCDDBECUSTATES";
            }
            case 3508: {
                return "eMCDDBECUSTATECHART";
            }
            case 3509: {
                return "eMCDDBECUSTATECHARTS";
            }
            case 3510: {
                return "eMCDDBECUSTATETRANSITIONACTION";
            }
            case 3511: {
                return "eMCDDBPRECONDITIONDEFINITION";
            }
            case 3512: {
                return "eMCDDBECUSTATETRANSITIONACTIONS";
            }
            case 3513: {
                return "eMCDDBPRECONDITIONDEFINITIONS";
            }
            case 3514: {
                return "eMCDDBECUSTATETRANSITION";
            }
            case 3515: {
                return "eMCDDBECUSTATETRANSITIONS";
            }
            case 3516: {
                return "eMCDDBFUNCTIONDICTIONARIES";
            }
            case 3517: {
                return "eMCDDBFUNCTIONDICTIONARY";
            }
            case 3519: {
                return "eMCDDBBASEFUNCTIONNODE";
            }
            case 3522: {
                return "eMCDDBFUNCTIONINPARAMETERS";
            }
            case 3523: {
                return "eMCDDBFUNCTIONINPARAMETER";
            }
            case 3524: {
                return "eMCDDBFUNCTIONOUTPARAMETERS";
            }
            case 3525: {
                return "eMCDDBFUNCTIONOUTPARAMETER";
            }
            case 3527: {
                return "eMCDDBDIAGOBJECTCONNECTOR";
            }
            case 3528: {
                return "eMCDDBDIAGTROUBLECODECONNECTORS";
            }
            case 3529: {
                return "eMCDDBDIAGTROUBLECODECONNECTOR";
            }
            case 3530: {
                return "eMCDDBENVDATACONNECTORS";
            }
            case 3531: {
                return "eMCDDBENVDATACONNECTOR";
            }
            case 3532: {
                return "eMCDDBTABLEROWCONNECTOR";
            }
            case 3533: {
                return "eMCDDBTABLEROWCONNECTORS";
            }
            case 3534: {
                return "eMCDDBFUNCTIONDIAGCOMCONNECTORS";
            }
            case 3535: {
                return "eMCDDBFUNCTIONDIAGCOMCONNECTOR";
            }
            case 3536: {
                return "eMCDDBMULTIPLEECUJOBS";
            }
            case 3537: {
                return "eMCDDBFUNCTIONNODE";
            }
            case 3538: {
                return "eMCDDBFUNCTIONNODEGROUP";
            }
            case 3539: {
                return "eMCDDBCOMPONENTCONNECTORS";
            }
            case 3540: {
                return "eMCDDBCOMPONENTCONNECTOR";
            }
            case 3541: {
                return "eMCDDBSUBCOMPONENTS";
            }
            case 3542: {
                return "eMCDDBSUBCOMPONENTPARAMCONNECTOR";
            }
            case 3543: {
                return "eMCDDBFUNCTIONNODES";
            }
            case 3544: {
                return "eMCDDBFUNCTIONNODEGROUPS";
            }
            case 3545: {
                return "eMCDDBSUBCOMPONENTPARAMCONNECTORS";
            }
            case 3546: {
                return "eMCDMONITORINGLINKS";
            }
            case 3547: {
                return "eMCDMONITORINGLINK";
            }
            case 3548: {
                return "eMCDMESSAGEFILTERS";
            }
            case 3549: {
                return "eMCDMESSAGEFILTERVALUES";
            }
            case 3550: {
                return "eMCDDBECUGROUPS";
            }
            case 3551: {
                return "eMCDDBECUGROUP";
            }
            case 3552: {
                return "eMCDBASEVARIANTIDENTIFICATOR";
            }
            case 3553: {
                return "eMCDBASEVARIANTIDENTIFICATIONRESULT";
            }
            case 3554: {
                return "eMCDDBEXTERNALACCESSMETHOD";
            }
            case 3555: {
                return "eMCDDBSUBCOMPONENT";
            }
            case 3556: {
                return "eMCDMESSAGEFILTER";
            }
        }
        return "*** UNKNOWN " + MCDObjectType.class.getName() + " ***: 0x" + Integer.toHexString(pMcdObjectType).toUpperCase();
    }

    public static final String decodeMcdPhysicalLinkOrInterfaceType(int pMcdPhysicalLinkOrInterfaceType) {
        switch (pMcdPhysicalLinkOrInterfaceType) {
            case 1281: {
                return "CAN";
            }
            case 1282: {
                return "KLINE";
            }
            case 1283: {
                return "MOST";
            }
            case 1284: {
                return "UART";
            }
            case 1285: {
                return "J1850";
            }
            case 1312: {
                return "ETK";
            }
            case 1313: {
                return "KWP2000";
            }
            case 1314: {
                return "MCMESS";
            }
            case 1344: {
                return "CCD";
            }
            case 1345: {
                return "CCP";
            }
            case 1346: {
                return "LIN";
            }
            case 1347: {
                return "SCI";
            }
            case 1535: {
                return "GENERIC";
            }
        }
        return "*** UNKNOWN MCDPhysicalLinkOrInterfaceType ***: 0x" + Integer.toHexString(pMcdPhysicalLinkOrInterfaceType).toUpperCase();
    }

    public static final String decodeMcdQueueErrorMode(int pMcdQueueErrorMode) {
        switch (pMcdQueueErrorMode) {
            case 25601: {
                return "QUEUE_BREAK_ON_ERROR";
            }
            case 25602: {
                return "QUEUE_IGNORE_ERRORS";
            }
        }
        return "*** UNKNOWN " + MCDQueueErrorMode.class.getName() + " ***: 0x" + Integer.toHexString(pMcdQueueErrorMode).toUpperCase();
    }

    public static final String decodeMcdRangeInfo(int pMcdRangeInfo) {
        switch (pMcdRangeInfo) {
            case 1538: {
                return "VALUE_VALID";
            }
            case 1539: {
                return "VALUE_NOT_DEFINED";
            }
            case 1540: {
                return "VALUE_NOT_AVAILABLE";
            }
            case 1541: {
                return "VALUE_NOT_VALID";
            }
            case 1542: {
                return "VALUE_NOT_INITIALIZED";
            }
            case 1543: {
                return "VALUE_CODED_TO_PHYSICAL_FAILED";
            }
        }
        return "*** UNKNOWN " + MCDRangeInfo.class.getName() + " ***: 0x" + Integer.toHexString(pMcdRangeInfo).toUpperCase();
    }

    public static final String decodeMcdRepetitionMode(int pMcdRepetitionMode) {
        switch (pMcdRepetitionMode) {
            case 26113: {
                return "SINGLE";
            }
            case 26114: {
                return "REPEATED";
            }
        }
        return "*** UNKNOWN " + MCDRepetitionMode.class.getName() + " ***: 0x" + Integer.toHexString(pMcdRepetitionMode).toUpperCase();
    }

    public static final String decodeMcdRepetitionState(int pMcdRepetitionState) {
        switch (pMcdRepetitionState) {
            case 26369: {
                return "NOT_REPEATING";
            }
            case 26370: {
                return "REPEATING";
            }
        }
        return "*** UNKNOWN " + MCDRepetitionState.class.getName() + " ***: 0x" + Integer.toHexString(pMcdRepetitionState).toUpperCase();
    }

    public static final String decodeMcdResponseState(int pMcdResponseState) {
        switch (pMcdResponseState) {
            case 26625: {
                return "ACKNOWLEDGED";
            }
            case 26626: {
                return "NOT_ACKNOWLEDGED";
            }
        }
        return "*** UNKNOWN " + MCDResponseState.class.getName() + " ***: 0x" + Integer.toHexString(pMcdResponseState).toUpperCase();
    }

    public static final String decodeMcdResponseType(int pMcdResponseType) {
        switch (pMcdResponseType) {
            case 28417: {
                return "POSITIVE_RESPONSE";
            }
            case 28418: {
                return "LOCAL_NEG_RESPONSE";
            }
            case 28419: {
                return "GLOBAL_NEG_RESPONSE";
            }
        }
        return "*** UNKNOWN " + MCDResponseType.class.getName() + " ***: 0x" + Integer.toHexString(pMcdResponseType).toUpperCase();
    }

    public static final String decodeMcdResultType(int pMcdResultType) {
        switch (pMcdResultType) {
            case 1793: {
                return "REQUEST";
            }
            case 1794: {
                return "REQUEST_AND_RESPONSE";
            }
            case 1795: {
                return "RESPONSE";
            }
        }
        return "*** UNKNOWN " + MCDResultType.class.getName() + " ***: 0x" + Integer.toHexString(pMcdResultType).toUpperCase();
    }

    public static final String decodeMcdRuntimeMode(int pMcdRuntimeMode) {
        switch (pMcdRuntimeMode) {
            case 26881: {
                return "NONCYCLIC";
            }
            case 26882: {
                return "CYCLIC";
            }
        }
        return "*** UNKNOWN " + MCDRuntimeMode.class.getName() + " ***: 0x" + Integer.toHexString(pMcdRuntimeMode).toUpperCase();
    }

    public static final String decodeMcdServerType(int pMcdServerType) {
        switch (pMcdServerType) {
            case 2561: {
                return "MCD";
            }
            case 2562: {
                return "MC";
            }
            case 2563: {
                return "MD";
            }
            case 2564: {
                return "CD";
            }
            case 2565: {
                return "M";
            }
            case 2566: {
                return "C";
            }
            case 2567: {
                return "D";
            }
        }
        return "*** UNKNOWN " + MCDServerType.class.getName() + " ***: 0x" + Integer.toHexString(pMcdServerType).toUpperCase();
    }

    public static final String decodeMcdSeverity(int pMcdSeverity) {
        switch (pMcdSeverity) {
            case 2049: {
                return "MESSAGE";
            }
            case 2050: {
                return "WARNING";
            }
            case 2051: {
                return "ERROR";
            }
            case 2052: {
                return "FATAL_ERROR";
            }
            case 2053: {
                return "TERMINATE";
            }
        }
        return "*** UNKNOWN " + MCDSeverity.class.getName() + " ***: 0x" + Integer.toHexString(pMcdSeverity).toUpperCase();
    }

    public static final String decodeMcdSystemParameter(int pMcdSystemParameter) {
        switch (pMcdSystemParameter) {
            case 3329: {
                return "TIMEZONE";
            }
            case 3330: {
                return "YEAR";
            }
            case 3331: {
                return "MONTH";
            }
            case 3332: {
                return "DAY";
            }
            case 3333: {
                return "HOUR";
            }
            case 3334: {
                return "MINUTE";
            }
            case 3335: {
                return "SECOND";
            }
            case 3336: {
                return "TESTERID";
            }
            case 3337: {
                return "USERID";
            }
        }
        return "*** UNKNOWN MCDSystemParameter ***: 0x" + Integer.toHexString(pMcdSystemParameter).toUpperCase();
    }

    public static final String decodeMcdSystemState(int pMcdSystemState) {
        switch (pMcdSystemState) {
            case 2305: {
                return "INITIALIZED";
            }
            case 2306: {
                return "PROJECT_SELECTED";
            }
            case 2307: {
                return "DBPROJECT_CONFIGURATION";
            }
            case 2308: {
                return "LOGICALLY_CONNECTED";
            }
            case 2309: {
                return "eVIT_SELECTED";
            }
        }
        return "*** UNKNOWN " + MCDSystemState.class.getName() + " ***: 0x" + Integer.toHexString(pMcdSystemState).toUpperCase();
    }

    public static final String decodeMcdTransmissionMode(int pMcdTransmissionMode) {
        switch (pMcdTransmissionMode) {
            case 27137: {
                return "NO_TRANSMISSION";
            }
            case 27138: {
                return "RECEIVE";
            }
            case 27139: {
                return "SEND";
            }
            case 27140: {
                return "SEND_AND_RECEIVE";
            }
            case 27141: {
                return "SEND_OR_RECEIVE";
            }
        }
        return "*** UNKNOWN " + MCDTransmissionMode.class.getName() + " ***: 0x" + Integer.toHexString(pMcdTransmissionMode).toUpperCase();
    }
}

