/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDParameter;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import java.util.ArrayList;
import java.util.Iterator;

public class MCD3_CompoListRead
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20140915-D4C7TNF";
    private static final String[] PROTOCOL_DEFAULT_STRINGS = new String[]{"yes", "yes", "no", "no", "no"};
    private static final String UNKNOWN_ECU = "unknown ECU";
    private static final String UNKNOWN_ECU_TI = "MAS03634";
    protected ArrayList allocation = null;
    protected MCDValue[][] protocols = null;
    protected MCDValue[] componentList = null;
    protected MCDValue[] componentPresent = null;
    protected MCDValue[] componentDtcs = null;
    protected MCDValue[] componentSingleWire = null;

    public MCD3_CompoListRead() {
        super(REVISION, OutputParameterValue.CompoListRead.JobStatusCode.class, OutputParameterValue.CompoListRead.JobStatusInformation.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        MCDResult jobResult = null;
        MCDResponse jobResponse = null;
        MCDResponseParameter output = null;
        boolean listFlag = false;
        boolean presentFlag = false;
        boolean dtcsFlag = false;
        boolean protFlag = false;
        boolean swireFlag = false;
        this.jobStatus = 0;
        try {
            this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
            jobResult = this.createFinalResult();
            jobResponse = this.addResponse(jobResult, true);
            output = jobResponse.getResponseParameters().getItemByName("OPA_CompoListOutpu").getParameters().getItemByName("Param_CompoListECUResul");
            this.logger.debug("Catch Inputs..");
            listFlag = this.getBooleanInput(pRequestParameters, "IPA_ReadCompoList", true);
            presentFlag = this.getBooleanInput(pRequestParameters, "IPA_ReadCompoListPrese", true);
            dtcsFlag = this.getBooleanInput(pRequestParameters, "IPA_ReadCompoListDtcs", true);
            protFlag = this.getBooleanInput(pRequestParameters, "IPA_ReadCompoListDiagP", true);
            swireFlag = this.getBooleanInput(pRequestParameters, "IPA_ReadCompoListSingl", true);
            this.logger.debug("Flags:");
            this.logger.debug("- listFlag   : " + listFlag);
            this.logger.debug("- presentFlag: " + presentFlag);
            this.logger.debug("- dtcsFlag   : " + dtcsFlag);
            this.logger.debug("- protFlag   : " + protFlag);
            this.logger.debug("- swireFlag  : " + swireFlag);
            if (listFlag) {
                this.readData(output, listFlag, presentFlag, dtcsFlag, protFlag, swireFlag);
                this.logger.debug("success!");
                this.jobStatus = 0;
            } else {
                this.logger.error("Aborting due to IPA_ReadCompoList = \"no\"...this does NOT make any sense!");
                this.jobStatus = 1;
            }
        }
        catch (IllegalAccessException iae) {
        }
        catch (Exception e) {
            this.jobStatus = 2;
            this.logger.logThrowable(e);
        }
        finally {
            this.finalizeJob();
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
        }
    }

    private ArrayList readAllocationList(String allocationDID) throws IllegalAccessException {
        MCDResult result = null;
        ArrayList<Object[]> dataSet = null;
        try {
            this.logger.debug("Start reading allocation list: " + allocationDID);
            result = this.executeComponentList(allocationDID, 4, false);
            MCDResponseParameters params = result.getResponses().getItemByIndex(0L).getResponseParameters().getItemByName("Param_DataRecor").getParameters().getItemByName("Param_ECUIDs").getParameters();
            dataSet = new ArrayList<Object[]>((int)params.getCount());
            long size = params.getCount();
            for (long k = 0L; k < size; ++k) {
                String ti;
                MCDResponseParameter param = params.getItemByIndex(k);
                MCDResponseParameters temps = param.getParameters();
                MCDResponseParameter nameParam = temps.getItemByName("Param_ECUName");
                MCDValue name = nameParam.getValue();
                MCDValue id = temps.getItemByName("Param_ECUID").getValue();
                try {
                    ti = this.vendorSpecific.getLongNameIDOfTextTableParameterValue((MCDParameter)nameParam, name.getValueAsString());
                }
                catch (Exception e) {
                    this.logger.debug("Failed to access TI from \"Param_ECUName\"! " + name.getValueAsString());
                    ti = "";
                }
                dataSet.add(new Object[]{id, name, ti});
            }
            return dataSet;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.jobStatus = 6;
            throw new IllegalAccessException();
        }
    }

    private void readProtocols(MCDValue[][] dataSet, MCDValue[] protocolDefaultValues) throws IllegalAccessException {
        MCDResult result = null;
        try {
            this.logger.debug("Start reading Protocol data..");
            result = this.executeComponentList("Gateway Component List DiagProt", 14, true);
        }
        catch (UnsupportedOperationException uoe) {
            this.logger.debug(" missing Service, using Default Protocol Values..");
            for (int i = 0; i < dataSet.length; ++i) {
                dataSet[i] = protocolDefaultValues;
            }
            return;
        }
        catch (IllegalStateException ise) {
            this.logger.debug(" negative response received, using Default Protocol Values..");
            for (int i = 0; i < dataSet.length; ++i) {
                dataSet[i] = protocolDefaultValues;
            }
            return;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        try {
            MCDResponseParameters params = result.getResponses().getItemByIndex(0L).getResponseParameters().getItemByName("Param_DataRecor").getParameters().getItemByName("Param_ECUsDiagP").getParameters();
            long size = params.getCount();
            for (long count = 0L; count < size; ++count) {
                MCDResponseParameter param = params.getItemByIndex(count);
                MCDResponseParameters temps = param.getParameters();
                this.logger.debug(" read Protocol bit " + count + ":" + temps.getItemByName("Param_ISOTP").getValue().getValueAsString() + ", " + temps.getItemByName("Param_TP20").getValue().getValueAsString() + ", " + temps.getItemByName("Param_TP16").getValue().getValueAsString() + ", " + temps.getItemByName("Param_KLine").getValue().getValueAsString() + ", " + temps.getItemByName("Param_Ether").getValue().getValueAsString());
                dataSet[(int)count] = new MCDValue[]{temps.getItemByName("Param_ISOTP").getValue(), temps.getItemByName("Param_TP20").getValue(), temps.getItemByName("Param_TP16").getValue(), temps.getItemByName("Param_KLine").getValue(), temps.getItemByName("Param_Ether").getValue()};
                if (count + 1L < (long)dataSet.length) continue;
                return;
            }
            for (int i = (int)count; i < dataSet.length; ++i) {
                dataSet[i] = protocolDefaultValues;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.jobStatus = 14;
            throw new IllegalAccessException();
        }
    }

    private void readData(MCDResponseParameter output, boolean listFlag, boolean presentFlag, boolean dtcsFlag, boolean protFlag, boolean swireFlag) throws IllegalAccessException {
        MCDValue unknown = this.createMCDValueUnicode2String("unknown");
        MCDValue[] protocolDefaultValues = this.getProtocolDefaultValues(PROTOCOL_DEFAULT_STRINGS);
        this.logger.debug("Start reading component data..");
        this.allocation = this.readAllocationList("Gateway Component List allocation");
        if (listFlag) {
            this.componentList = new MCDValue[this.allocation.size()];
            this.readComponentValue("Gateway Component List", "Param_ECUCoded", new String[]{"Param_ECUCodedBit7", "Param_ECUCodedBit6", "Param_ECUCodedBit5", "Param_ECUCodedBit4", "Param_ECUCodedBit3", "Param_ECUCodedBit2", "Param_ECUCodedBit1", "Param_ECUCodedBit0"}, this.componentList, 1, null, null, unknown);
        } else {
            this.componentList = MCD3_CompoListRead.fillStringArray(this.allocation.size(), unknown);
        }
        if (presentFlag) {
            this.componentPresent = new MCDValue[this.allocation.size()];
            this.readComponentValue("Gateway Component List present", "Param_ECUsPrese", new String[]{"Param_ECUPreseBit7", "Param_ECUPreseBit6", "Param_ECUPreseBit5", "Param_ECUPreseBit4", "Param_ECUPreseBit3", "Param_ECUPreseBit2", "Param_ECUPreseBit1", "Param_ECUPreseBit0"}, this.componentPresent, 7, null, null, unknown);
        } else {
            this.componentPresent = MCD3_CompoListRead.fillStringArray(this.allocation.size(), unknown);
        }
        if (dtcsFlag) {
            this.componentDtcs = new MCDValue[this.allocation.size()];
            this.readComponentValue("Gateway Component List dtc", "Param_ECUDtcs", new String[]{"Param_ECUDtcBit7", "Param_ECUDtcBit6", "Param_ECUDtcBit5", "Param_ECUDtcBit4", "Param_ECUDtcBit3", "Param_ECUDtcBit2", "Param_ECUDtcBit1", "Param_ECUDtcBit0"}, this.componentDtcs, 3, unknown, unknown, unknown);
        } else {
            this.componentDtcs = MCD3_CompoListRead.fillStringArray(this.allocation.size(), unknown);
        }
        if (protFlag) {
            this.protocols = new MCDValue[this.allocation.size()][PROTOCOL_DEFAULT_STRINGS.length];
            this.readProtocols(this.protocols, protocolDefaultValues);
        } else {
            this.protocols = new MCDValue[this.allocation.size()][PROTOCOL_DEFAULT_STRINGS.length];
            for (int i = 0; i < this.protocols.length; ++i) {
                this.protocols[i] = protocolDefaultValues;
            }
        }
        if (swireFlag) {
            this.componentSingleWire = new MCDValue[this.allocation.size()];
            this.readComponentValue("Gateway Component List singlewire", "Param_ECUsSingl", new String[]{"Param_ECUSinglBit7", "Param_ECUSinglBit6", "Param_ECUSinglBit5", "Param_ECUSinglBit4", "Param_ECUSinglBit3", "Param_ECUSinglBit2", "Param_ECUSinglBit1", "Param_ECUSinglBit0"}, this.componentSingleWire, 15, unknown, unknown, unknown);
        } else {
            this.componentSingleWire = MCD3_CompoListRead.fillStringArray(this.allocation.size(), unknown);
        }
        this.setDataToJobOutput(output);
    }

    private MCDValue[] getProtocolDefaultValues(String[] pProtocolDefaults) throws IllegalAccessException {
        MCDValue[] list = new MCDValue[pProtocolDefaults.length];
        for (int i = 0; i < pProtocolDefaults.length; ++i) {
            list[i] = this.createMCDValueUnicode2String(pProtocolDefaults[i]);
        }
        return list;
    }

    private MCDValue createMCDValueUnicode2String(String text) throws IllegalAccessException {
        try {
            MCDValue value = this.jobApi.createValue(14);
            value.setValueAsString(text);
            return value;
        }
        catch (MCDException mcde) {
            this.logger.debug("Failed to create MCDValue from jobApi! " + mcde.getLocalizedMessage());
            this.logger.logThrowable(mcde);
            this.jobStatus = 6;
            throw new IllegalAccessException();
        }
    }

    private void setDataToJobOutput(MCDResponseParameter output) throws IllegalAccessException {
        MCDResponseParameter param_ecuName = null;
        int count = 0;
        this.logger.debug("Commit data to JobOutput");
        Iterator iterator = this.allocation.iterator();
        while (iterator.hasNext()) {
            Object[] set = (Object[])iterator.next();
            try {
                MCDValue id = (MCDValue)set[0];
                MCDValue name = (MCDValue)set[1];
                String ti = (String)set[2];
                this.logger.debug("   " + count + ": " + name.getValueAsString() + " (0x" + Long.toHexString(id.getUint32()).toUpperCase() + "), " + ti);
                MCDResponseParameter current = output.getParameters().addElement();
                this.logger.debug("Type of current: " + McdEnumDecoder.decodeMcdDataType(current.getType()));
                MCDResponseParameters params = current.getType() == 22 ? current.getParameters().getItemByIndex(current.getParameters().getCount() - 1L).getParameters() : current.getParameters();
                param_ecuName = params.getItemByName("Param_ECUName");
                try {
                    param_ecuName.setValue(name);
                    this.tryToSetNameTi(params, ti);
                }
                catch (MCDException mcde) {
                    this.logger.debug("Unresolved ECU name \"" + name.getValueAsString() + "\"... replaced by \"" + UNKNOWN_ECU + "\".");
                    MCDValue value_ecuName = this.jobApi.createValue(14);
                    value_ecuName.setValueAsString(UNKNOWN_ECU);
                    param_ecuName.setValue(value_ecuName);
                    this.tryToSetNameTi(params, UNKNOWN_ECU_TI);
                }
                params.getItemByName("Param_ECUID").setValue(id);
                this.set(params.getItemByName("Param_ECUCoded"), this.componentList[count]);
                this.set(params.getItemByName("Param_ECUPrese"), this.componentPresent[count]);
                this.set(params.getItemByName("Param_ECUDtcs"), this.componentDtcs[count]);
                this.set(params.getItemByName("Param_ECUSingl"), this.componentSingleWire[count]);
                MCDValue[] protoSet = this.protocols[count];
                MCDResponseParameters protocolParams = params.getItemByName("Param_ECUDiagP").getParameters();
                this.logger.debug("   protocolList: " + protoSet[0].getValueAsString() + "," + protoSet[1].getValueAsString() + "," + protoSet[2].getValueAsString() + "," + protoSet[3].getValueAsString() + "," + protoSet[4].getValueAsString());
                this.set(protocolParams.getItemByName("Param_ISOTP"), protoSet[0]);
                this.set(protocolParams.getItemByName("Param_TP20"), protoSet[1]);
                this.set(protocolParams.getItemByName("Param_TP16"), protoSet[2]);
                this.set(protocolParams.getItemByName("Param_KLine"), protoSet[3]);
                this.set(protocolParams.getItemByName("Param_Ether"), protoSet[4]);
                ++count;
            }
            catch (MCDException mcde) {
                this.logger.debug("Failed to obmit current dataSet! ");
                this.logger.logThrowable(mcde);
                this.jobStatus = 10;
                throw new IllegalAccessException();
            }
        }
    }

    private void tryToSetNameTi(MCDResponseParameters params, String ti) {
        MCDResponseParameter param;
        try {
            param = params.getItemByName("Param_ECUNameTI");
        }
        catch (MCDException mcde) {
            this.logger.debug("Failed to store TI to JobOutput, missing \"Param_ECUNameTI\"! \"" + ti + "\"");
            return;
        }
        try {
            MCDValue target = this.jobApi.createValue(14);
            target.setValueAsString(ti);
            param.setValue(target);
        }
        catch (MCDException mcde) {
            this.logger.debug("Failed to store TI to JobOutput! \"" + ti + "\"");
            this.logger.logThrowable(mcde);
        }
    }

    private void set(MCDResponseParameter param, MCDValue mcdValue) throws MCDException {
        MCDValue target = null;
        target = this.jobApi.createValue(mcdValue.getDataType());
        target.setValueAsString(mcdValue.getValueAsString());
        param.setValue(target);
    }

    private static MCDValue[] fillStringArray(int size, MCDValue defaultValue) {
        MCDValue[] result = new MCDValue[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = defaultValue;
        }
        return result;
    }

    private void readComponentValue(String didName, String resultParam, String[] fieldParamNames, MCDValue[] target, int failureState, MCDValue missingService, MCDValue negativeService, MCDValue unknown) throws IllegalAccessException {
        boolean noAccessException;
        MCDResult result = null;
        int count = 0;
        try {
            noAccessException = missingService != null && negativeService != null;
            result = this.executeComponentList(didName, failureState, noAccessException);
        }
        catch (UnsupportedOperationException uoe) {
            for (int currentTarget = 0; currentTarget < target.length; ++currentTarget) {
                target[currentTarget] = missingService;
            }
            try {
                if (missingService != null) {
                    this.logger.debug("Error occured missing service: default value will be used: " + missingService.getValueAsString());
                } else {
                    this.logger.debug("Error occured missing service: default value will be used: null!");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        catch (IllegalStateException ise) {
            for (int currentTarget = 0; currentTarget < target.length; ++currentTarget) {
                target[currentTarget] = negativeService;
            }
            try {
                this.logger.debug("Error occured negative response: defaultvalue will be used: " + negativeService.getValueAsString());
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        try {
            MCDResponseParameters params = result.getResponses().getItemByIndex(0L).getResponseParameters().getItemByName("Param_DataRecor").getParameters().getItemByName(resultParam).getParameters();
            long numberOfFieldElements = params.getCount();
            for (long currentFieldElement = 0L; currentFieldElement < numberOfFieldElements; ++currentFieldElement) {
                MCDResponseParameters temps = params.getItemByIndex(currentFieldElement).getParameters();
                for (int currentFieldElementParameter = 0; currentFieldElementParameter < fieldParamNames.length; ++currentFieldElementParameter) {
                    MCDResponseParameter temp = temps.getItemByName(fieldParamNames[currentFieldElementParameter]);
                    target[count++] = temp.getValue();
                    try {
                        this.logger.debug(currentFieldElement + " " + fieldParamNames[currentFieldElementParameter] + ": " + temp.getValue().getValueAsString());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (count < target.length) continue;
                    return;
                }
            }
            for (int currentTarget = count; currentTarget < target.length; ++currentTarget) {
                target[currentTarget] = noAccessException ? negativeService : unknown;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.jobStatus = failureState;
            if (noAccessException) {
                for (int currentTarget = count; currentTarget < target.length; ++currentTarget) {
                    target[currentTarget] = negativeService;
                }
            }
            throw new IllegalAccessException();
        }
    }

    private MCDResult executeComponentList(String didValue, int errorState, boolean externalError) throws IllegalAccessException {
        MCDDiagComPrimitive readList;
        MCDResult result = null;
        try {
            this.logger.debug("Execute DiagnServi_ReadDataByIdentGatewCompoList with " + didValue);
            readList = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentGatewCompoList");
        }
        catch (MCDException mcde) {
            if (externalError) {
                throw new UnsupportedOperationException();
            }
            this.logger.logThrowable(mcde);
            this.jobStatus = errorState;
            throw new IllegalAccessException();
        }
        try {
            MCDRequestParameters requests = readList.getRequest().getRequestParameters();
            MCDRequestParameter did = requests.getItemByName("Param_RecorDataIdent");
            MCDValue value = did.createValue();
            value.setValueAsString(didValue);
            did.setValue(value);
            this.printRequest(readList);
            result = readList.executeSync();
            try {
                this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(result.getResponses().getItemByIndex(0L).getResponseMessage()));
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
            }
            if (result.hasError() || this.responseNotAcknowledged(result)) {
                this.logger.debug("DiagnServi_ReadDataByIdentGatewCompoList has negative result!");
                this.printMCDResult(result);
                if (externalError) {
                    throw new IllegalStateException();
                }
                this.jobStatus = errorState;
                throw new IllegalAccessException();
            }
            return result;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.jobStatus = errorState;
            throw new IllegalAccessException();
        }
    }

    private boolean getBooleanInput(MCDRequestParameters inputs, String inputParam, boolean defaultValue) {
        try {
            return "yes".equals(inputs.getItemByName(inputParam).getValue().getValueAsString());
        }
        catch (MCDException mcde) {
            this.logger.debug("Failed to access JobInputParameter \"" + inputParam + "\" defaultValue:" + defaultValue);
            this.logger.logThrowable(mcde);
            return defaultValue;
        }
    }

    private boolean responseNotAcknowledged(MCDResult result) {
        try {
            MCDResponse response220606;
            MCDResponses responses = result.getResponses();
            return responses == null || responses.getCount() < 1L || (response220606 = responses.getItemByIndex(0L)) == null || response220606.getState() != 26625;
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
            return true;
        }
    }

    protected int addOutputParameters(MCDResponse pResponse) {
        super.addOutputParameters(pResponse);
        try {
            this.setDataToJobOutput(pResponse.getResponseParameters().getItemByName("OPA_CompoListOutpu").getParameters().getItemByName("Param_CompoListECUResul"));
        }
        catch (Exception e) {
            this.logger.error("Error setting \"OPA_CompoListOutpu\"!");
            this.logger.logThrowable(e);
        }
        return 0;
    }
}

