/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDbLocation;
import asam.d.MCDDbParameter;
import asam.d.MCDDbResponseParameter;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDTextTableElement;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import com.audi.mcd.joblibrary.util.SubSystemHelper;
import com.audi.mcd.joblibrary.util.impl.SubSystemHelperImpl;
import java.lang.reflect.Method;

public class MCD3_SubsyIdent
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20140915";
    private static final String NOT_SUPPORTED_MESSAGE = "NOT_SUPPORTED";
    private static final String NOT_AVAILABLE_MESSAGE = "NOT_AVAILABLE";
    protected static boolean fastMode = false;
    private static final String[][] RESULT_LIST = new String[][]{{"Param_SlaveSysteName", "DiagnServi_ReadDataByIdentVWSlaveSysteName"}, {"Param_VWSlaveSparePartNumbe", "DiagnServi_ReadDataByIdentVWSlaveSparePartNumbe"}, {"Param_VWSlaveHardwNumbe", "DiagnServi_ReadDataByIdentVWSlaveHardwNumbe"}, {"Param_VWSlaveSoftwVersiNumbe", "DiagnServi_ReadDataByIdentVWSlaveSoftwVersiNumbe"}, {"Param_VWSlaveHardwVersiNumbe", "DiagnServi_ReadDataByIdentVWSlaveHardwVersiNumbe"}, {"Param_VWSlaveSeriaNumbe", "DiagnServi_ReadDataByIdentVWSlaveSeriaNumbe"}, {"Param_VWSlaveCodinValue", "DiagnServi_ReadDataByIdentVWSlaveCodinValue"}, {"Param_SlaveFAZITIdentStrin", "DiagnServi_ReadDataByIdentVWSlaveFAZITIdentStrin"}};
    private boolean dedicatedSubSystemIdsSupported = false;
    private SubSystemHelper subSystemHelper = null;
    static /* synthetic */ Class class$asam$d$MCDDbLocation;

    public MCD3_SubsyIdent() {
        super(REVISION, OutputParameterValue.ReadSubsyIdent.JobStatusCode.class, OutputParameterValue.ReadSubsyIdent.JobStatusInformation.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        block28: {
            MCDResponse jobResponse;
            MCDResult jobResult;
            int slaveSystemCounter;
            block27: {
                slaveSystemCounter = 0;
                jobResult = null;
                jobResponse = null;
                this.jobApi = pJobApi;
                this.jobStatus = 0;
                this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
                this.subSystemHelper = new SubSystemHelperImpl(this.logger, this.vendorSpecific);
                this.logger.debug("1  Init Job");
                Object[] resTemp = this.addResponse(pSingleEcuJob, this.logicalLink.getDbObject().getDbLocation());
                jobResult = (MCDResult)resTemp[0];
                jobResponse = (MCDResponse)resTemp[1];
                MCDResponseParameters slaveCollection = this.getSlaveList();
                this.logger.debug("3  Operate slaves..");
                int j = 0;
                while ((long)j < slaveCollection.getCount()) {
                    try {
                        this.operateSlaveEntry(jobResponse, slaveCollection.getItemByIndex((long)j));
                        ++slaveSystemCounter;
                    }
                    catch (UnsupportedOperationException uoe) {
                    }
                    catch (Exception e) {
                        this.logger.debug("Current Slave operation canceled!");
                        this.logger.logThrowable(e);
                    }
                    ++j;
                }
                this.jobStatus = 0;
                this.setNumberOfSlaves(jobResponse, slaveSystemCounter);
                break block27;
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
            }
            try {
                this.setStatus(jobResponse, this.jobStatus);
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
            }
            this.dumpAndSendFinalResult(jobResult);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
            break block28;
            catch (IllegalAccessException iae) {
                try {
                    this.setNumberOfSlaves(jobResponse, slaveSystemCounter);
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
                try {
                    this.setStatus(jobResponse, this.jobStatus);
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
                this.dumpAndSendFinalResult(jobResult);
                this.logger.finalize(this.getCurrentJobRuntimeAsString());
                this.logger.exit();
                break block28;
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
                break block28;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    this.setNumberOfSlaves(jobResponse, slaveSystemCounter);
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
                try {
                    this.setStatus(jobResponse, this.jobStatus);
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
                this.dumpAndSendFinalResult(jobResult);
                this.logger.finalize(this.getCurrentJobRuntimeAsString());
                this.logger.exit();
            }
        }
    }

    protected int readInputParameters(MCDRequestParameters pRequestParameters) {
        return 0;
    }

    private MCDResponseParameters getSlaveList() throws IllegalAccessException, MCDException {
        MCDResponseParameters slaveCollection;
        this.logger.debug("2  Extract SlaveCollection");
        try {
            slaveCollection = this.getSlaveSystems("Identified SubSystem Numbers", false);
        }
        catch (Exception e) {
            this.logger.debug("DID 0608 failed (Identified SubSystem Numbers)!");
            slaveCollection = this.getSlaveSystems("Identified Slave Systems", true);
        }
        if (slaveCollection != null && slaveCollection.getCount() == 0L) {
            this.jobStatus = 0;
            throw new IllegalAccessException();
        }
        return slaveCollection;
    }

    private void operateSlaveEntry(MCDResponse jobResponse, MCDResponseParameter slave) throws IllegalAccessException, UnsupportedOperationException {
        MCDResponseParameter responseParam_segmentNumber = null;
        MCDResponseParameter responseParam_subSystemPresent = null;
        MCDResponseParameter responseParam_subSystemCoded = null;
        MCDResponseParameter responseParam_reserVw8012730 = null;
        int segmentNumber = -1;
        String subSystemPresent = null;
        String subSystemCoded = null;
        byte reserVw8012730 = 0;
        boolean isVw80127V30 = false;
        MCDValue value_subSystemName = null;
        String subSystemName = null;
        MCDValue value_subSystemId = null;
        short subSystemId = 0;
        MCDDbResponseParameter dbParameterSubSystemNames = null;
        long lengthOfSubSystemNameDbParameter = 0L;
        MCDTextTableElement subSystemNameFromId = null;
        MCDResponseParameter outputParam_segmentNumber = null;
        MCDResponseParameter outputParam_subSystemPresent = null;
        MCDResponseParameter outputParam_subSystemCoded = null;
        MCDValue value_segmentNumber = null;
        MCDValue value_subSystemPresent = null;
        MCDValue value_subSystemCoded = null;
        try {
            this.logger.debug("4  Extract  Param_SlaveSyste");
            MCDResponseParameters slaveParameters = slave.getParameters();
            for (long i = 0L; i < slaveParameters.getCount(); ++i) {
                this.logger.debug("Parameter[" + i + "]: " + slaveParameters.getItemByIndex(i).getShortName());
            }
            value_subSystemName = slaveParameters.getItemByName("Param_SlaveSyste").getValue();
            subSystemName = value_subSystemName.getValueAsString();
            value_subSystemId = slaveParameters.getItemByName("Param_SlaveID").getValue();
            subSystemId = (short)value_subSystemId.getUint32();
            try {
                responseParam_reserVw8012730 = slaveParameters.getItemByName("Param_ReserVW8012730");
                reserVw8012730 = (byte)responseParam_reserVw8012730.getValue().getUint32();
                if (reserVw8012730 == 1) {
                    isVw80127V30 = true;
                    this.logger.debug("isVw80127V30 = true");
                }
            }
            catch (MCDException mcde) {
                this.logger.logThrowable(mcde);
                isVw80127V30 = false;
                this.logger.debug("isVw80127V30 = false");
            }
            if (isVw80127V30) {
                responseParam_segmentNumber = slaveParameters.getItemByName("Param_SegmeNumbe");
                responseParam_subSystemPresent = slaveParameters.getItemByName("Param_SubsyPrese");
                responseParam_subSystemCoded = slaveParameters.getItemByName("Param_SubsyCoded");
                segmentNumber = (byte)responseParam_segmentNumber.getValue().getUint32();
                subSystemPresent = responseParam_subSystemPresent.getValue().getValueAsString();
                subSystemCoded = responseParam_subSystemCoded.getValue().getValueAsString();
            } else {
                segmentNumber = -1;
                subSystemPresent = "unknown";
                subSystemCoded = "unknown";
            }
            this.logger.debug("Segment Number   : " + segmentNumber);
            this.logger.debug("subSystem present: " + subSystemPresent);
            this.logger.debug("subSystem coded  : " + subSystemCoded);
            String internalName = value_subSystemName.getValueAsString();
            boolean unknownSlave = "Slave Not Present".equals(internalName) || "unknown Slave".equals(internalName);
            this.logger.debug("Internal name: " + internalName);
            if (!isVw80127V30 && (subSystemId == 0 || "Slave Not Present".equals(internalName) || "Slave Not Coded".equals(internalName)) || isVw80127V30 && (subSystemPresent.equals("no") || subSystemId == 511 && subSystemPresent.equals("yes") && subSystemCoded.equals("yes") && segmentNumber == 15)) {
                throw new UnsupportedOperationException();
            }
            if (subSystemId != 0 && subSystemId != 65535 && subSystemId > 511) {
                this.logger.warn("The read subsystem id 0x" + Integer.toHexString(subSystemId).toUpperCase() + " exceeds the maximum value 0x" + Integer.toHexString(511).toUpperCase() + "!");
                subSystemId = (short)(subSystemId & 0x1FF);
                this.logger.warn("The subsystem id has been truncated to 0x" + Integer.toHexString(subSystemId).toUpperCase() + ".");
            }
            this.logger.debug("5  Create new ResultStructure");
            MCDResponseParameter resultStructure = jobResponse.getResponseParameters().getItemByName("OPA_JobResul").getParameters().addElement();
            MCDResponseParameters resultStructureParams = resultStructure.getType() == 22 ? resultStructure.getParameters().getItemByIndex(resultStructure.getParameters().getCount() - 1L).getParameters() : resultStructure.getParameters();
            for (long i = 0L; i < resultStructureParams.getCount(); ++i) {
                this.logger.debug("Parameter[" + i + "]: " + resultStructureParams.getItemByIndex(i).getShortName());
            }
            this.logger.debug("6  Set ID and InternalName " + (unknownSlave ? "Slave Not Present" : internalName));
            MCDResponseParameter Param_SlaveID = resultStructureParams.getItemByName("Param_SlaveID");
            value_subSystemId = this.jobApi.createValue(11);
            value_subSystemId.setUint32((long)subSystemId);
            Param_SlaveID.setValue(value_subSystemId);
            MCDResponseParameter internalNameParam = resultStructureParams.getItemByName("Param_SlaveSysteNameInter");
            dbParameterSubSystemNames = (MCDDbResponseParameter)internalNameParam.getDbObject();
            lengthOfSubSystemNameDbParameter = dbParameterSubSystemNames.getByteLength();
            if (lengthOfSubSystemNameDbParameter == 2L) {
                this.dedicatedSubSystemIdsSupported = true;
            }
            if (this.dedicatedSubSystemIdsSupported && (unknownSlave || this.vendorSpecific.getTextTableElementOfDbParameterByLongName((MCDDbParameter)dbParameterSubSystemNames, subSystemName) == null)) {
                subSystemNameFromId = this.vendorSpecific.getTextTableElementOfDbParameterByCodedValueUint32((MCDDbParameter)dbParameterSubSystemNames, subSystemId);
                if (subSystemNameFromId != null) {
                    subSystemName = subSystemNameFromId.getLongName();
                    value_subSystemName.setValueAsString(subSystemName);
                    this.logger.debug("Replacing subsystem name with \"" + subSystemName + "\" derived from subsystem id 0x" + Integer.toHexString(subSystemId).toUpperCase() + ".");
                    unknownSlave = false;
                } else {
                    this.logger.debug("Unable to determine subsystem name with from subsystem id 0x" + Integer.toHexString(subSystemId).toUpperCase() + ".");
                }
            }
            if (unknownSlave) {
                MCDValue value = this.jobApi.createValue(14);
                try {
                    value.setValueAsString("Slave Not Present");
                    internalNameParam.setValue(value);
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error setting 'Slave Not Present'... trying 'NOT_AVAILABLE'.");
                    value.setValueAsString(NOT_AVAILABLE_MESSAGE);
                    internalNameParam.setValue(value);
                }
            } else {
                internalNameParam.setValue(value_subSystemName);
            }
            if (isVw80127V30) {
                try {
                    outputParam_segmentNumber = resultStructureParams.getItemByName("Param_SegmeNumbe");
                    value_segmentNumber = this.jobApi.createValue(7);
                    value_segmentNumber.setInt32(segmentNumber);
                    outputParam_segmentNumber.setValue(value_segmentNumber);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error setting \"Param_SegmeNumbe\"...possible mix up of service and job interfaces?");
                }
                try {
                    outputParam_subSystemPresent = resultStructureParams.getItemByName("Param_SubsyPrese");
                    value_subSystemPresent = this.jobApi.createValue(14);
                    value_subSystemPresent.setValueAsString(subSystemPresent);
                    outputParam_subSystemPresent.setValue(value_subSystemPresent);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error setting \"Param_SubsyPrese\"...possible mix up of service and job interfaces?");
                }
                try {
                    outputParam_subSystemCoded = resultStructureParams.getItemByName("Param_SubsyCoded");
                    value_subSystemCoded = this.jobApi.createValue(14);
                    value_subSystemCoded.setValueAsString(subSystemCoded);
                    outputParam_subSystemCoded.setValue(value_subSystemCoded);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error setting \"Param_SubsyCoded\"...possible mix up of service and job interfaces?");
                }
            }
            this.executeSlaveServices(resultStructureParams, subSystemName, subSystemId, unknownSlave);
        }
        catch (Exception e) {
            this.logger.error("Failed to operateSlaveEntry!");
            this.logger.logThrowable(e);
            this.jobStatus = 4;
            throw new IllegalAccessException();
        }
    }

    private MCDResponseParameters getSlaveSystems(String did, boolean storeError) throws IllegalAccessException {
        MCDDiagComPrimitive service22060x = null;
        MCDResult result22060x = null;
        try {
            MCDResponseParameters slaveCollection;
            try {
                this.logger.debug("2 1 Create DiagnServi_ReadDataByIdentECUIdent");
                service22060x = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentECUIdent");
                MCDRequestParameter didParam = service22060x.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
                MCDValue value = didParam.createValue();
                value.setValueAsString(did);
                didParam.setValue(value);
            }
            catch (MCDException e) {
                this.logger.error("2 2 Create DiagnServi_ReadDataByIdentECUIdent (" + did + ") FAILED!");
                this.logger.logThrowable(e);
                try {
                    service22060x = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentIdentSlaveSyste");
                }
                catch (MCDException mcde) {
                    if (storeError) {
                        this.jobStatus = 5;
                    }
                    throw new IllegalAccessException();
                }
            }
            this.logger.debug("2 3 Execute Service");
            this.printRequest(service22060x);
            result22060x = service22060x.executeSync();
            if (result22060x.hasError()) {
                throw new Exception("Response of $0606 has error!");
            }
            if (this.checkNRC(result22060x, 49L)) {
                this.logger.debug("2 3b NRC 0x31 found!");
                this.printMCDResult(result22060x);
                if (storeError) {
                    this.jobStatus = 2;
                }
                throw new IllegalAccessException();
            }
            this.logger.debug("2 4 Try to get pos Response..");
            if (this.responseNotAcknowledged(result22060x)) {
                this.catchResponseInfo(result22060x, null);
                if (storeError) {
                    this.jobStatus = 4;
                }
                throw new IllegalAccessException();
            }
            MCDResponse response22060x = result22060x.getResponses().getItemByIndex(0L);
            this.mcdObjectDumper.dumpResponse(response22060x, 1, false);
            this.logger.debug("2 5 responsePDU: " + this.vendorSpecific.pduValue2String(response22060x.getResponseMessage()));
            MCDResponseParameter dataRecor = response22060x.getResponseParameters().getItemByName("Param_DataRecor");
            this.logger.debug("Data type of Data Record: " + McdEnumDecoder.decodeMcdDataType(dataRecor.getType()));
            if (dataRecor.getType() == 17) {
                this.logger.debug("Getting parameters of wrapper STRUCTURE.");
                slaveCollection = dataRecor.getParameters().getItemByIndex(0L).getParameters();
            } else {
                slaveCollection = dataRecor.getParameters();
            }
            this.logger.debug("Data type of slaveCollection: " + McdEnumDecoder.decodeMcdDataType(slaveCollection.getItemByIndex(0L).getType()));
            if (slaveCollection.getItemByIndex(0L).getType() == 22) {
                slaveCollection = slaveCollection.getItemByIndex(0L).getParameters();
            }
            this.logger.debug("2 6 Check SlaveCollection amount: " + slaveCollection.getCount());
            return slaveCollection;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.catchResponseInfo(result22060x, e);
            if (storeError) {
                this.jobStatus = 4;
            }
            throw new IllegalAccessException();
        }
    }

    private boolean responseNotAcknowledged(MCDResult result) {
        try {
            MCDResponse response;
            MCDResponses responses = result.getResponses();
            return responses == null || responses.getCount() < 1L || (response = responses.getItemByIndex(0L)) == null || response.getState() != 26625;
        }
        catch (MCDException e) {
            this.logger.logThrowable(e);
            return true;
        }
    }

    private boolean checkNRC(MCDResult result, long value) {
        try {
            this.logger.debug("Check NRC 0x" + Long.toHexString(value));
            byte[] pdu = result.getResponses().getItemByIndex(0L).getResponseMessage().getBytefield();
            return pdu.length >= 3 && pdu[0] == 127 && (long)pdu[2] == value;
        }
        catch (Exception e) {
            this.logger.debug("Check NRC " + value + " FAILED!");
            this.logger.logThrowable(e);
            return false;
        }
    }

    private void executeSlaveServices(MCDResponseParameters structureParams, String pSubSystemName, short pSubSystemId, boolean unknownSlave) {
        for (int i = 0; i < RESULT_LIST.length; ++i) {
            MCDResponseParameter targetParam = null;
            try {
                targetParam = structureParams.getItemByName(RESULT_LIST[i][0]);
                if (fastMode && RESULT_LIST[i][1].equals("DiagnServi_ReadDataByIdentVWSlaveFAZITIdentStrin")) {
                    this.setFailureStringToParam(targetParam, NOT_AVAILABLE_MESSAGE);
                    continue;
                }
                this.executeSlaveIdentDS(RESULT_LIST[i][1], pSubSystemName, pSubSystemId, targetParam, unknownSlave);
                continue;
            }
            catch (IllegalAccessException iae) {
                continue;
            }
            catch (Exception e) {
                if (targetParam != null) {
                    this.setFailureStringToParam(targetParam, NOT_AVAILABLE_MESSAGE);
                }
                this.logger.debug("Failed to execute " + RESULT_LIST[i][0]);
                this.logger.logThrowable(e);
            }
        }
    }

    private void executeSlaveIdentDS(String serviceName, String pSubSystemName, short pSubSystemId, MCDResponseParameter targetParam, boolean unknownSlave) throws IllegalAccessException {
        MCDDiagComPrimitive serviceRead_SysteName;
        if (unknownSlave) {
            this.setFailureStringToParam(targetParam, NOT_SUPPORTED_MESSAGE);
            throw new IllegalAccessException();
        }
        try {
            this.logger.debug("7  executeSubFunction " + serviceName);
            serviceRead_SysteName = this.logicalLink.createDiagComPrimitiveByName(serviceName);
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.setFailureStringToParam(targetParam, NOT_SUPPORTED_MESSAGE);
            throw new IllegalAccessException();
        }
        try {
            this.logger.debug("8  Get Service inputParameter");
            MCDRequestParameter tableKeyParam = serviceRead_SysteName.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
            this.logger.debug("9  Set Value to Parameter");
            try {
                this.logger.debug("10 sub 3b: " + pSubSystemName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.subSystemHelper.findAndSetMatchingTextTableElementWithSubSystemLongName(serviceName, tableKeyParam, pSubSystemName)) {
                this.logger.warn("Failed to find/set matching TABLE-KEY for \"" + pSubSystemName + "\"!");
                if (!this.dedicatedSubSystemIdsSupported) {
                    this.setFailureStringToParam(targetParam, NOT_SUPPORTED_MESSAGE);
                    throw new IllegalAccessException();
                }
                this.logger.debug("Trying to find/set matching TABLE-KEY for subsystem id 0x" + Integer.toHexString(pSubSystemId).toUpperCase() + "...");
                if (!this.subSystemHelper.findAndSetMatchingTextTableElementWithSubSystemId(serviceName, tableKeyParam, pSubSystemId)) {
                    this.logger.error("Failed to find/set matching TABLE-KEY for subsystem id 0x" + Integer.toHexString(pSubSystemId).toUpperCase() + "...");
                    this.setFailureStringToParam(targetParam, NOT_SUPPORTED_MESSAGE);
                    throw new IllegalAccessException();
                }
            }
            this.logger.debug("11 Execute Service");
            this.printRequest(serviceRead_SysteName);
            MCDResult resultRead_SysteName = serviceRead_SysteName.executeSync();
            this.printAllResponsePDUs(resultRead_SysteName, serviceName);
            byte[] responseByte = resultRead_SysteName.getResponses().getItemByIndex(0L).getResponseMessage().getBytefield();
            if (responseByte[0] == 127 || resultRead_SysteName.hasError()) {
                if (responseByte.length >= 3 && responseByte[2] == 49) {
                    this.setFailureStringToParam(targetParam, NOT_SUPPORTED_MESSAGE);
                } else {
                    this.setFailureStringToParam(targetParam, NOT_AVAILABLE_MESSAGE);
                }
                throw new IllegalAccessException();
            }
            this.logger.debug("12 Extract Information..");
            MCDResponseParameter data = resultRead_SysteName.getResponses().getItemByIndex(0L).getResponseParameters().getItemByName("Param_DataRecor");
            try {
                if ("Request Out Of Range".equals(data.getValue().getValueAsString())) {
                    this.setFailureStringToParam(targetParam, NOT_AVAILABLE_MESSAGE);
                    throw new IllegalAccessException();
                }
            }
            catch (IllegalAccessException iae) {
                throw iae;
            }
            catch (Exception npe) {
                // empty catch block
            }
            try {
                this.logger.debug("13 TableCount: " + data.getParameters().getCount());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.logger.debug("14 - " + data.getShortName() + " Datatype Source: " + McdEnumDecoder.decodeMcdDataType(data.getType()) + " Target: " + McdEnumDecoder.decodeMcdDataType(targetParam.getType()));
            if (!this.setAndCheckASCII(targetParam, data.getParameters())) {
                this.setFailureStringToParam(targetParam, NOT_AVAILABLE_MESSAGE);
                throw new IllegalAccessException();
            }
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.setFailureStringToParam(targetParam, NOT_AVAILABLE_MESSAGE);
            throw new IllegalAccessException();
        }
    }

    private void setFailureStringToParam(MCDResponseParameter target, String failure) {
        try {
            if (target == null) {
                this.logger.debug("Can not set Failure string to null target parameter! " + failure);
                return;
            }
            this.logger.debug("Set Defaultvalue! " + target.getShortName() + ":" + (failure != null ? failure : ""));
            MCDValue value = this.jobApi.createValue(target.getType());
            if (value.getDataType() == 1 || value.getDataType() == 14) {
                value.setValueAsString(failure);
            } else if (value.getDataType() == 3) {
                value.setBytefield(new byte[]{0});
            }
            target.setValue(value);
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
        }
    }

    private void printAllResponsePDUs(MCDResult result, String title) {
        try {
            MCDResponses responses = result.getResponses();
            for (long k = 0L; k < responses.getCount(); ++k) {
                this.logger.debug(title + " Response PDU: " + this.vendorSpecific.pduValue2String(responses.getItemByIndex(k).getResponseMessage()));
            }
        }
        catch (MCDException e) {
            e.printStackTrace();
        }
    }

    private boolean setAndCheckASCII(MCDResponseParameter target, MCDResponseParameters source) throws MCDException {
        MCDValue value;
        StringBuffer sb = new StringBuffer();
        if (target == null || source == null) {
            throw new IllegalArgumentException("Null value received!");
        }
        long size = source.getCount();
        for (long k = 0L; k < size; ++k) {
            String text;
            MCDResponseParameter param = source.getItemByIndex(k);
            value = param.getValue();
            int sourceDataType = value.getDataType();
            switch (sourceDataType) {
                case 1: 
                case 14: {
                    text = value.getValueAsString();
                    break;
                }
                case 3: {
                    if (target.getType() == 3) {
                        target.setValue(param.getValue());
                        return true;
                    }
                    try {
                        text = value.getValueAsString();
                        break;
                    }
                    catch (Exception e) {
                        target.setValue(param.getValue());
                        return true;
                    }
                }
                default: {
                    text = "NULL";
                }
            }
            char[] result = new char[text.length()];
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                result[i] = c < ' ' || c > '~' ? 63 : c;
            }
            sb.append(result);
        }
        value = this.jobApi.createValue(target.getType());
        value.setValueAsString(sb.toString());
        target.setValue(value);
        return true;
    }

    private void catchResponseInfo(MCDResult result, Exception e) {
        this.logger.logThrowable(e);
        this.printMCDResult(result);
    }

    private void setNumberOfSlaves(MCDResponse jobResponse, long count) {
        try {
            MCDResponseParameter number = jobResponse.getResponseParameters().getItemByName("OPA_NumbeOfIdentSubsy");
            MCDValue numberValue = this.jobApi.createValue(11);
            try {
                numberValue.setUint32(count);
                this.logger.debug("setNumber: " + count);
            }
            catch (MCDException mcde) {
                numberValue.setUint32(0L);
            }
            number.setValue(numberValue);
        }
        catch (MCDException mcde) {
            this.logger.debug("setNumber FAILED! ");
            this.logger.logThrowable(mcde);
        }
    }

    private void setStatus(MCDResponse jobResponse, int pJobStatus) {
        MCDResponseParameters params = null;
        try {
            params = jobResponse.getResponseParameters();
            MCDResponseParameter param = params.getItemByName("OPA_JobStatuInfor");
            MCDValue value = this.jobApi.createValue(14);
            value.setValueAsString(this.getJobStatusInformation());
            param.setValue(value);
            try {
                param = params.getItemByName("OPA_JobStatuCode");
                value = this.jobApi.createValue(11);
                value.setUint32((long)pJobStatus);
                param.setValue(value);
                this.logger.debug("Set Code " + pJobStatus + " = " + param.getValue().getUint32());
            }
            catch (Exception e) {
                this.logger.debug("Set Status Code failed!");
                this.logger.logThrowable(e);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Status failed!");
            this.logger.logThrowable(e);
        }
    }

    private Object[] addResponse(MCDSingleEcuJob singleEcuJob, MCDDbLocation dbLocation) {
        Object[] list = new Object[2];
        try {
            Method[] methods = MCDResponses.class.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                Class<?>[] classes = method.getParameterTypes();
                if (classes.length == 2 && classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_SubsyIdent.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation) && classes[1].isAssignableFrom(Boolean.TYPE)) {
                    method.setAccessible(true);
                    MCDResult result = singleEcuJob.createResult(1794, 0, "", 0, "", 0);
                    MCDResponses responses = result.getResponses();
                    list[0] = result;
                    list[1] = method.invoke((Object)responses, dbLocation, Boolean.TRUE);
                    return list;
                }
                if (classes.length != 1 || !classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_SubsyIdent.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation)) continue;
                method.setAccessible(true);
                MCDResult result = singleEcuJob.createResult(1794, 49152, "", 0, "", 0);
                MCDResponses responses = result.getResponses();
                list[0] = result;
                list[1] = method.invoke((Object)responses, dbLocation);
                return list;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            throw new IllegalArgumentException("Can not MCDResponse#add(..) method! " + e.getMessage());
        }
        throw new IllegalArgumentException("Method MCDResponse#add(..) not found!");
    }

    protected int addOutputParameters(MCDResponse pResponse) {
        return 0;
    }
}

