/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.jobs.impl.bdm;

import asam.d.MCDAccessKey;
import asam.d.MCDDbEcu;
import asam.d.MCDDbFlashDataBlock;
import asam.d.MCDDbFlashSession;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDErrors;
import asam.d.MCDException;
import asam.d.MCDFlashJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDParameter;
import asam.d.MCDProtocolParameterSet;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDService;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary2.constants.value.BDM;
import com.audi.mcd.joblibrary2.jobs.AbstractJob;
import com.audi.mcd.joblibrary2.util.DateTime;
import com.audi.mcd.joblibrary2.util.McdEnumDecoder;
import com.audi.mcd.joblibrary2.util.dserver.VendorSpecific;
import com.elektrobit.automotive.mcd.joblibrary.audi.uds.jobs.mcd201.MCD3_FlashJobUDS;

public class MCD3_FlashJobBDM
extends MCD3_FlashJobUDS {
    private static final String REVISION = "1.2.20140826";
    protected static final String[] BDM_REQUIRED_DIAG_COMMS = new String[]{"DiagnServi_DiagnSessiContr", "DiagnServi_ECUResetHardReset", "DiagnServi_RequeDownl", "DiagnServi_RoutiContrCheckMemor", "DiagnServi_RoutiContrEraseMemor", "DiagnServi_TransData", "SinglJob_SecurAcces"};
    private static int instances = 0;
    private static int nextInstance = 0;
    protected boolean responseExpected = true;
    protected boolean targetEcuIsBdm = false;
    protected byte diagnosticAddress = 0;
    protected int[] bdmFlashPageChecksums = null;
    protected int[] bdmPartialChecksums = null;
    protected boolean[] bdmPageSuccessfullyFlashed = null;
    protected short bdmNumberOfFlashPages = (short)178;
    protected short bdmCurrentFlashPage = (short)-1;
    protected byte[] bdmFlashPageState = null;
    protected boolean[] bdmFlashPageIsEmpty = null;
    protected int bdmPagesToProgram = 0;
    protected short[] bdmPartialChecksumStartPages = null;
    protected byte[] bdmPartialChecksumNumberOfPages = null;
    protected byte bdmCurrentPartialChecksum = 0;
    protected short bdmNumberOfRepeatedPages = 0;
    protected short bdmRequestSeparationTime = (short)-1;
    protected short bdmEraseDelay = (short)-1;
    protected MCDService bdmEraseMemory = null;
    protected MCDRequest bdmEraseMemoryRequest = null;
    protected MCDValue eraseMemorybdmRequestPduValue = null;
    protected byte[] bdmEraseMemoryRequestPdu = null;
    protected MCDService bdmRequestDownload = null;
    protected MCDRequest bdmRequestDownloadRequest = null;
    protected MCDValue bdmRequestDownloadRequestPduValue = null;
    protected byte[] bdmRequestDownloadRequestPdu = null;
    protected MCDService bdmTransferData = null;
    protected MCDRequest bdmTransferDataRequest = null;
    protected MCDValue bdmTransferDataRequestPduValue = null;
    protected byte[] bdmTransferDataRequestPdu = null;
    protected MCDService bdmCheckMemory = null;
    protected MCDRequestParameter bdmRequestParameterCheckMemoryIndexOfStartPage = null;
    protected MCDValue bdmCheckMemoryIndexOfStartPageValue = null;
    protected int bdmNumberOfRequestSidBytesInRequestPdu = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCD3_FlashJobBDM() {
        super(REVISION);
        Class clazz = MCD3_FlashJobBDM.class;
        synchronized (clazz) {
            this.instance = nextInstance++;
            ++instances;
        }
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDFlashJob pFlashJob, MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering execute(...).");
        this.jobStatus = this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, pFlashJob, pDbFlashSession);
        if (this.jobStatus == AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS) {
            throw new NullPointerException("At least one of the call parameters of the job is null!");
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("prepareJob successful - executing job logic...");
            this.jobCompletionStatus = this.executeJobLogicGuarded();
        }
        this.finalizeJobGuarded();
        this.logger.trace("Leaving execute(...).");
    }

    protected AbstractJob.JobStatus prepareJobGuarded(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDFlashJob pFlashJob, MCDDbFlashSession pDbFlashSession) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        try {
            currentJobStatus = this.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pFlashJob, pDbFlashSession);
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in prepareJob() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in prepareJob() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareJob(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDFlashJob pFlashJob, MCDDbFlashSession pDbFlashSession) {
        AbstractJob.JobStatus currentJobStatus;
        block31: {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
            MCDDbEcu dbEcu = null;
            if (pDbFlashSession == null) {
                return AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS;
            }
            this.dbFlashSession = pDbFlashSession;
            this.jobStartTime = System.currentTimeMillis();
            if (pRequestParameters == null || pJobApi == null || pLogicalLink == null || pFlashJob == null) {
                return AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS;
            }
            try {
                dbEcu = pLogicalLink.getDbObject().getDbLocation().getDbECU();
                this.dbEcuName = dbEcu.getShortName();
            }
            catch (MCDException mcde) {
                this.dbEcuName = "UNKNOWN";
            }
            if (this.dbEcuName == null) {
                this.dbEcuName = "";
            }
            this.logger.init(this.dbEcuName);
            this.logger.info("Running on: " + this.dbEcuName);
            this.logger.debug("Maximum available memory: " + maximumAvailableMemory / 1024L + " KiB");
            this.inputParameters = pRequestParameters;
            this.jobApi = pJobApi;
            this.logicalLink = pLogicalLink;
            this.job = pFlashJob;
            this.setJobProgress(0L);
            this.dServerVendor = VendorSpecific.getServerVendor();
            this.vendorSpecific = VendorSpecific.getInstance(this.logger, this.logicalLink);
            this.mcdObjectDumper.setVendorSpecific(this.vendorSpecific);
            currentJobStatus = this.determineMcdVersion();
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                return currentJobStatus;
            }
            currentJobStatus = this.determineAddResponseMethod();
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                return currentJobStatus;
            }
            try {
                this.dbLocationOfLogicalLink = this.logicalLink.getDbObject().getDbLocation();
                this.dbLocationAccessKey = this.dbLocationOfLogicalLink.getAccessKey().getString();
                this.dbLocationAccessKeyBaseVariant = this.dbLocationAccessKey.indexOf(".[EcuVariant]") != -1 ? this.dbLocationAccessKey.substring(0, this.dbLocationAccessKey.indexOf(".[EcuVariant]")) : this.dbLocationAccessKey;
                this.setJobInfo(this.job.getDbObject().getLongName() + " started on " + this.dbEcuName);
                this.dbLocationTypeOfLogicalLink = this.dbLocationOfLogicalLink.getDbECU().getObjectType();
                this.logMessage = "Running on ";
                switch (this.dbLocationTypeOfLogicalLink) {
                    case 1158: {
                        this.logMessage = this.logMessage + "ECU-VARIANT: ";
                        this.dbLocationAccessKeyBaseVariant = MCD3_FlashJobBDM.buildAccessKey(this.dbLocationOfLogicalLink.getAccessKey().getProtocol(), null, this.dbLocationOfLogicalLink.getAccessKey().getEcuBaseVariant(), null);
                        break;
                    }
                    case 1156: {
                        this.logMessage = this.logMessage + "BASE-VARIANT: ";
                        this.dbLocationAccessKeyBaseVariant = MCD3_FlashJobBDM.buildAccessKey(this.dbLocationOfLogicalLink.getAccessKey().getProtocol(), null, this.dbLocationOfLogicalLink.getAccessKey().getEcuBaseVariant(), null);
                        break;
                    }
                    case 1162: {
                        this.logMessage = this.logMessage + "FUNCTIONAL-GROUP: ";
                        this.dbLocationAccessKeyFunctionalGroup = MCD3_FlashJobBDM.buildAccessKey(this.dbLocationOfLogicalLink.getAccessKey().getProtocol(), this.dbLocationOfLogicalLink.getAccessKey().getFunctionalGroup(), null, null);
                        break;
                    }
                    default: {
                        this.logMessage = this.logMessage + "neither BV nor EV nor FG ?!?! ";
                    }
                }
                this.logMessage = this.logMessage + this.dbEcuName;
                this.logger.debug(this.logMessage);
                this.logger.debug("AccessKey of LOGICAL-LINK    : " + this.dbLocationAccessKey);
                this.logger.debug("AccessKey of FUNCTIONAL-GROUP: " + this.dbLocationAccessKeyFunctionalGroup);
                this.logger.debug("AccessKey of BASE-VARIANT    : " + this.dbLocationAccessKeyBaseVariant);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining current dbLocation.");
                if (this.dbEcuName != null) break block31;
                this.dbEcuName = "";
            }
        }
        if (this.logger.getLogLevel() >= 5) {
            try {
                if (this.inputParameters.getCount() > 0L) {
                    this.logger.debug("Dumping INPUT-PARAMs...");
                    this.mcdObjectDumper.dumpRequestParameters(pRequestParameters, 1);
                }
            }
            catch (MCDException mcde) {
                this.logger.debug("Error dumping input parameters!");
                this.logger.logThrowable(mcde);
            }
        }
        this.jobCompletionStatus = "Job aborted due to fatal errors";
        this.jobMessage = "Error during update programming";
        this.jobResult = "unknown Failure - Programming aborted";
        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return currentJobStatus;
        }
        currentJobStatus = this.readInputParameters(pRequestParameters, null);
        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return currentJobStatus;
        }
        if (this.isMcd20002Interface) {
            this.bdmNumberOfRequestSidBytesInRequestPdu = 1;
        }
        if ((currentJobStatus = this.checkRequiredDiagComms(BDM_REQUIRED_DIAG_COMMS)) != AbstractJob.JobStatus.NO_ERROR) {
            return currentJobStatus;
        }
        this.logger.debug("Preparing protocol parameter set.");
        currentJobStatus = this.prepareProtocolParameterSet();
        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return currentJobStatus;
        }
        if (!this.isPduApiUsed) {
            this.logger.debug("Preparing global control primitives.");
            try {
                this.stopCommunication = this.stopCommunication(this.logicalLink);
                this.startCommunication = this.startCommunication(this.logicalLink);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating MCDStop/StartCommunication.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Reading ODX FLASH container.");
            currentJobStatus = this.readFlash(this.dbFlashSession);
        }
        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Error reading ODX FLASH container.");
        } else {
            currentJobStatus = this.calculateChecksums(this.binaryData);
        }
        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Error calculating flash page checksums.");
        }
        this.bdmFlashPageState = new byte[this.bdmNumberOfFlashPages];
        this.bdmPageSuccessfullyFlashed = new boolean[this.bdmNumberOfFlashPages];
        for (int i = 0; i < this.bdmNumberOfFlashPages; ++i) {
            this.bdmPageSuccessfullyFlashed[i] = false;
        }
        Thread.currentThread().setPriority(10);
        this.logger.trace("Leaving prepareJob(...).");
        return this.jobStatus;
    }

    protected String executeJobLogicGuarded() {
        String currentJobCompletionStatus = null;
        try {
            currentJobCompletionStatus = this.executeJobLogic();
        }
        catch (MCDException mcde) {
            this.logger.debug("Caught MCDException in executeJobLogic() method.");
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in executeJobLogic() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in executeJobLogic() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        return currentJobCompletionStatus;
    }

    protected String executeJobLogic() throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        AbstractJob.JobStatus currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
        int currentCheck = 0;
        int currentDownload = 0;
        short lastDownloadPage = 0;
        this.setJobProgress(1L);
        int FLASHJOB_STEPS = 21;
        int currentJobStep = 0;
        while (currentJobStep < 21 && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            block0 : switch (currentJobStep) {
                case 0: {
                    this.prepareServices(this.logicalLink);
                    this.securityAccess = this.securityAccess(this.logicalLink, this.logger.getLogLevel(), "BDM AU48X", null);
                    switch (this.diagnosticAddress) {
                        case 71: {
                            this.logger.debug("Application active.");
                            ++currentJobStep;
                            break block0;
                        }
                        case 127: {
                            this.logger.debug("Kernel active.");
                            currentJobStep = 7;
                            break block0;
                        }
                    }
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                case 1: {
                    this.logger.debug("Switching session.");
                    this.currentService = this.diagnosticSessionControl(this.logicalLink, Boolean.FALSE, "Programming Session", false);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                    ++currentJobStep;
                    break;
                }
                case 2: {
                    this.setRepeatRequestCounter(0L);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.securityAccess, 1, true);
                    this.setRepeatRequestCounter(this.savedNumberOfErrorRepetitions);
                    ++currentJobStep;
                    break;
                }
                case 3: {
                    if (this.dbEcuName.startsWith("EV_BDMLear")) {
                        if (this.isPduApiUsed) {
                            this.setResponseExpected(true, (int)this.savedStandTiminP2Serve);
                        } else {
                            this.setResponseExpected(true, 13);
                        }
                    } else {
                        this.setResponseExpected(false, 13);
                    }
                    this.currentService = this.routineControlEraseMemory(this.logicalLink, MCD3_FlashJobBDM.getPageIndexByNumber(0), (byte)0);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                    this.logger.debug("routineControlEraseMemory done.");
                    ++currentJobStep;
                    break;
                }
                case 4: {
                    if (!this.isPduApiUsed) {
                        this.controlPrimitive = this.stopCommunication(this.logicalLink);
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.controlPrimitive, 3, true);
                        this.logger.debug("Communication stopped.");
                    }
                    currentJobStep += 2;
                    break;
                }
                case 6: {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanPhysReqExtAddr", 127L);
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanRespUSDTExtAddr", 127L);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "DiagnosticAddress", 127L);
                    }
                    if (!this.isPduApiUsed) {
                        this.controlPrimitive = this.startCommunication(this.logicalLink);
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.controlPrimitive, 3, true);
                        this.logger.debug("Communication started.");
                    }
                    ++currentJobStep;
                    break;
                }
                case 7: {
                    int i;
                    this.setResponseExpected(false, 26);
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanPhysReqExtAddr", 127L);
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanRespUSDTExtAddr", 127L);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "SupPosRspMsgHandling", "disabled");
                        this.setProtocolParameterValue(this.protocolParameterSet, "DiagnosticAddress", 127L);
                    }
                    this.currentService = MCD3_FlashJobBDM.assignNAD(this.logicalLink, "Analog Devices Inc.", "ADuC7032", (byte)71);
                    for (i = 0; i < 40; ++i) {
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                    }
                    this.logger.debug("NAD assigned.");
                    ++currentJobStep;
                    break;
                }
                case 8: {
                    if (!this.isPduApiUsed) {
                        this.controlPrimitive = this.stopCommunication(this.logicalLink);
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.controlPrimitive, 3, true);
                        this.logger.debug("Communication stopped.");
                    }
                    ++currentJobStep;
                    break;
                }
                case 9: {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanPhysReqExtAddr", 71L);
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_CanRespUSDTExtAddr", 71L);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "DiagnosticAddress", 71L);
                    }
                    if (!this.isPduApiUsed) {
                        this.controlPrimitive = this.startCommunication(this.logicalLink);
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.controlPrimitive, 3, true);
                        this.logger.debug("Communication started.");
                    }
                    this.bdmCurrentFlashPage = 0;
                    this.bdmNumberOfRepeatedPages = 0;
                    ++currentJobStep;
                    break;
                }
                case 10: {
                    this.bdmCurrentFlashPage = 0;
                    this.bdmNumberOfRepeatedPages = 0;
                    ++currentJobStep;
                    break;
                }
                case 11: {
                    int i;
                    this.setResponseExpected(false, this.bdmNumberOfFlashPages * this.bdmEraseDelay / 3);
                    this.bdmEraseMemoryRequestPdu[4 + this.bdmNumberOfRequestSidBytesInRequestPdu] = (byte)this.bdmNumberOfFlashPages;
                    this.routineControlEraseMemory(this.bdmEraseMemoryRequest, this.eraseMemorybdmRequestPduValue, this.bdmEraseMemoryRequestPdu, MCD3_FlashJobBDM.getPageIndexByNumber(0));
                    if (this.isPduApiUsed) {
                        this.bdmEraseMemory.setRuntimeTransmissionMode(27140);
                    }
                    this.bdmEraseMemory.executeSync();
                    for (i = 0; i < this.bdmNumberOfFlashPages; ++i) {
                        this.bdmFlashPageState[i] = 1;
                    }
                    this.bdmCurrentFlashPage = (short)(this.bdmNumberOfFlashPages - 1);
                    this.setResponseExpected(false, 13);
                    currentDownload = 0;
                    ++currentJobStep;
                    break;
                }
                case 12: {
                    if (this.bdmCurrentFlashPage == -1) {
                        this.logger.debug("Number of repeated pages: " + this.bdmNumberOfRepeatedPages);
                        this.bdmCurrentFlashPage = 0;
                        this.bdmCurrentPartialChecksum = 0;
                        currentJobStep += 5;
                        break;
                    }
                    this.logger.debug("flashPageState: " + this.bdmFlashPageState[this.bdmCurrentFlashPage]);
                    if (this.bdmFlashPageState[this.bdmCurrentFlashPage] != 1) {
                        this.setResponseExpected(false, this.bdmEraseDelay);
                        this.bdmEraseMemoryRequestPdu[4 + this.bdmNumberOfRequestSidBytesInRequestPdu] = 1;
                        this.routineControlEraseMemory(this.bdmEraseMemoryRequest, this.eraseMemorybdmRequestPduValue, this.bdmEraseMemoryRequestPdu, MCD3_FlashJobBDM.getPageIndexByNumber(this.bdmCurrentFlashPage));
                        this.bdmEraseMemory.executeSync();
                        this.bdmFlashPageState[this.bdmCurrentFlashPage] = 1;
                        this.setResponseExpected(false, 13);
                    } else {
                        this.logger.debug("Skipping eraseMemory");
                    }
                    currentDownload = 0;
                    ++currentJobStep;
                    break;
                }
                case 13: {
                    int i;
                    if (currentDownload == 1) {
                        ++currentJobStep;
                        break;
                    }
                    if (this.bdmFlashPageIsEmpty[this.bdmCurrentFlashPage]) {
                        this.logger.debug("Skipping empty page: " + this.bdmCurrentFlashPage);
                        currentCheck = 0;
                        lastDownloadPage = this.bdmCurrentFlashPage;
                        currentJobStep += 3;
                        break;
                    }
                    this.logger.debug("RD: bdmCurrentFlashPage: " + this.bdmCurrentFlashPage);
                    this.requestDownload(this.bdmRequestDownloadRequest, this.bdmRequestDownloadRequestPduValue, this.bdmRequestDownloadRequestPdu, MCD3_FlashJobBDM.getPageIndexByNumber(this.bdmCurrentFlashPage));
                    this.setResponseExpected(false, 13);
                    for (i = 0; i < 1; i = (int)((short)(i + 1))) {
                        this.bdmRequestDownload.executeSync();
                    }
                    ++currentDownload;
                    this.currentDataChunk = 0;
                    this.logger.debug("requestDownload done.");
                    break;
                }
                case 14: {
                    int i;
                    for (i = 0; i < this.binaryData[this.bdmCurrentFlashPage].length; i = (int)((short)(i + 1))) {
                        this.transferData(this.bdmTransferDataRequest, this.bdmTransferDataRequestPduValue, this.bdmTransferDataRequestPdu, this.binaryData[this.bdmCurrentFlashPage][i]);
                        this.bdmTransferData.executeSync();
                    }
                    lastDownloadPage = this.bdmCurrentFlashPage;
                    this.bdmFlashPageState[this.bdmCurrentFlashPage] = 2;
                    currentJobStep += 2;
                    break;
                }
                case 15: {
                    this.logger.debug("Current flash page: " + this.bdmCurrentFlashPage);
                    this.logger.debug("Current data chunk: " + this.currentDataChunk);
                    if (this.currentDataChunk < this.binaryData[this.bdmCurrentFlashPage].length) {
                        this.logger.debug("Length of current data chunk: " + this.binaryData[this.bdmCurrentFlashPage][this.currentDataChunk].length);
                        if (this.currentService == null) {
                            currentJobStatus = AbstractJob.JobStatus.ERROR;
                        } else {
                            this.currentService.resetToDefaultValues();
                        }
                        this.setTransferRequestParameterRecord(this.currentService, this.binaryData[this.bdmCurrentFlashPage][this.currentDataChunk]);
                        if (this.currentDataChunk < this.binaryData[this.bdmCurrentFlashPage].length - 1) {
                            currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, false);
                            ++this.currentDataChunk;
                            break;
                        }
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                        ++this.currentDataChunk;
                        this.bdmFlashPageState[this.bdmCurrentFlashPage] = 2;
                        break;
                    }
                    currentCheck = 0;
                    lastDownloadPage = this.bdmCurrentFlashPage;
                    ++currentJobStep;
                    break;
                }
                case 16: {
                    if (this.bdmCurrentFlashPage != lastDownloadPage || this.bdmCurrentFlashPage == lastDownloadPage && this.bdmFlashPageState[this.bdmCurrentFlashPage] != 3 && currentCheck == 1) {
                        currentCheck = 0;
                        currentJobStep -= 4;
                        break;
                    }
                    if (this.isPduApiUsed) {
                        this.setResponseExpected(true, (int)this.savedStandTiminP2Serve);
                    } else {
                        this.setResponseExpected(true, 13);
                    }
                    MCD3_FlashJobBDM.setIndexOfStartPageCheckMemory(this.bdmRequestParameterCheckMemoryIndexOfStartPage, this.bdmCheckMemoryIndexOfStartPageValue, MCD3_FlashJobBDM.getPageIndexByNumber(this.bdmCurrentFlashPage));
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.bdmCheckMemory, 1, false);
                    ++currentCheck;
                    break;
                }
                case 17: {
                    if (this.bdmCurrentPartialChecksum < BDM.PARTIAL_CHECKSUMS && this.bdmPartialChecksumNumberOfPages[this.bdmCurrentPartialChecksum] > 0) {
                        if (this.isPduApiUsed) {
                            this.setResponseExpected(true, (int)this.savedStandTiminP2Serve);
                        } else {
                            this.setResponseExpected(true, 13);
                        }
                        this.currentService = MCD3_FlashJobBDM.routineControlCheckMemory(this.logicalLink, MCD3_FlashJobBDM.getPageIndexByNumber(this.bdmPartialChecksumStartPages[this.bdmCurrentPartialChecksum]), this.bdmPartialChecksumNumberOfPages[this.bdmCurrentPartialChecksum]);
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                        if (this.jobStatus != AbstractJob.JobStatus.CHECKSUM_ERROR) break;
                        this.logger.debug("Checksum verification failed - reprogramming all pages.");
                        this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
                        currentJobStep = 10;
                        break;
                    }
                    ++currentJobStep;
                    break;
                }
                case 18: {
                    ++currentJobStep;
                    break;
                }
                case 19: {
                    this.setResponseExpected(false, 13);
                    this.currentService = this.ecuReset(this.logicalLink, Boolean.FALSE, "Hard Reset");
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                    if (this.isPduApiUsed) {
                        this.setResponseExpected(true, (int)this.savedStandTiminP2Serve);
                    } else {
                        this.setResponseExpected(true, 13);
                    }
                    this.logger.debug("ecuResetHardReset done.");
                    ++currentJobStep;
                    break;
                }
                case 20: {
                    ++currentJobStep;
                    break;
                }
            }
            if (currentJobStep != 2 || currentJobStatus != AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION) continue;
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
            currentJobStep += 2;
        }
        this.logger.debug("Final job status: " + currentJobStatus);
        this.setJobProgress(99L);
        if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            currentJobStatus = currentJobStatusPostProgramming;
        }
        if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobCompletionStatus = "Job completed successfully";
            this.jobMessage = "Update programming finished successfully";
            this.jobResult = "Programming successful finished";
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        return this.jobCompletionStatus;
    }

    protected void finalizeJobGuarded() {
        try {
            this.finalizeJob();
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in finalizeJob() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in finalizeJob() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
    }

    protected void finalizeJob() {
        this.logger.trace("Entering finalizeJob(...).");
        if (this.jobMessage.equalsIgnoreCase("Update programming finished successfully")) {
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        } else if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        super.finalizeJob();
        this.finalizeLogging();
    }

    protected void finalizeLogging() {
        this.logger.debug("Number of flash pages   : " + this.bdmNumberOfFlashPages);
        this.logger.debug("Number of repeated pages: " + this.bdmNumberOfRepeatedPages);
        this.logger.finalize(this.getCurrentJobRuntimeAsString());
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters, String pShortNameOfWrappingParameter) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfInputParameters = 0L;
        MCDRequestParameter inputParameter = null;
        MCDRequestParameters nestedParameters = null;
        String inputParameterName = null;
        int logLevel = -1;
        this.logger.trace("Entering readInputParameters(...).");
        try {
            numberOfInputParameters = pRequestParameters.getCount();
        }
        catch (MCDException mcde) {
            if (pShortNameOfWrappingParameter == null) {
                this.logger.fatal("Error determining number of job input parameters.");
            } else {
                this.logger.fatal("Error determining number of parameters for structured INPUT-PARAM \"" + pShortNameOfWrappingParameter + "\".");
            }
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pShortNameOfWrappingParameter == null) {
            this.logger.info("Number of INPUT-PARAMETERS to read: " + numberOfInputParameters);
        } else {
            this.logger.info("Number of PARAMS to read for INPUT-PARAM \"" + pShortNameOfWrappingParameter + "\": " + numberOfInputParameters);
        }
        for (long i = 0L; i < numberOfInputParameters; ++i) {
            try {
                inputParameter = pRequestParameters.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                inputParameterName = inputParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting SHORT-NAME of job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (inputParameterName.equals("IPA_LogLevel")) {
                try {
                    logLevel = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if ((logLevel & 0x80) > 0) {
                        this.isFunctionalAddressingDisabled = true;
                    }
                    if ((logLevel & 0x40) > 0) {
                        this.isNormalCommunicationReEnabled = false;
                    }
                    if ((logLevel &= 7) >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + logLevel);
                    }
                }
                catch (Exception e) {
                    logLevel = 0;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + logLevel + ".");
                    this.logger.logThrowable(e);
                }
                if (this.logger.isConfiguredByPropertiesFile()) {
                    this.logger.debug("Ignoring " + inputParameterName + " since logger has already been configured by properties file.");
                    continue;
                }
                if (logLevel <= 0) continue;
                this.logger.init(this.dbEcuName, logLevel);
                continue;
            }
            if (inputParameterName.equals("IPA_AddreAndLengtFormaIdent")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_AddreAndLengtFormaIdent")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_RoutiContrEraseMemorLengtFormaIdent") || inputParameterName.endsWith("Param_RoutiContrEraseMemorLengtFormaIdent") || inputParameterName.equals("IPA_RoutiContrEraseMemorLengtFormaIdent")) {
                try {
                    this.LFID_EM = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.LFID_EM);
                    continue;
                }
                catch (Exception e) {
                    this.LFID_EM = 0;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.LFID_EM + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RoutiContrEraseMemorAddreFormaIdent") || inputParameterName.endsWith("Param_RoutiContrEraseMemorAddreFormaIdent") || inputParameterName.equals("IPA_RoutiContrEraseMemorAddreFormaIdent")) {
                try {
                    this.AFID_EM = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.AFID_EM);
                    continue;
                }
                catch (Exception e) {
                    this.AFID_EM = 1;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.AFID_EM + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RequeDownlLengtFormaIdent") || inputParameterName.endsWith("Param_RequeDownlLengtFormaIdent") || inputParameterName.equals("IPA_RequeDownlLengtFormaIdent")) {
                try {
                    this.LFID_RD = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.LFID_RD);
                    continue;
                }
                catch (Exception e) {
                    this.LFID_RD = (byte)4;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.LFID_RD + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RequeDownlAddreFormaIdent") || inputParameterName.endsWith("Param_RequeDownlAddreFormaIdent") || inputParameterName.equals("IPA_RequeDownlAddreFormaIdent")) {
                try {
                    this.AFID_RD = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.AFID_RD);
                    continue;
                }
                catch (Exception e) {
                    this.AFID_RD = 1;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.AFID_RD + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RoutiContrCheckMemorLengtFormaIdent") || inputParameterName.endsWith("Param_RoutiContrCheckMemorLengtFormaIdent") || inputParameterName.equals("IPA_RoutiContrCheckMemorLengtFormaIdent")) {
                try {
                    this.LFID_CM = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.LFID_CM);
                    continue;
                }
                catch (Exception e) {
                    this.LFID_CM = 0;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.LFID_CM + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RoutiContrCheckMemorAddreFormaIdent") || inputParameterName.endsWith("Param_RoutiContrCheckMemorAddreFormaIdent") || inputParameterName.equals("IPA_RoutiContrCheckMemorAddreFormaIdent")) {
                try {
                    this.AFID_CM = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.AFID_CM);
                    continue;
                }
                catch (Exception e) {
                    this.AFID_CM = 1;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.AFID_CM + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_PFLEnabl")) {
                try {
                    this.partialFlashProgrammingEnabled = Boolean.valueOf(this.getParameterValueAsString((MCDParameter)inputParameter));
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + String.valueOf(this.partialFlashProgrammingEnabled));
                    continue;
                }
                catch (Exception e) {
                    this.partialFlashProgrammingEnabled = Boolean.valueOf("TRUE");
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + "TRUE" + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_RepaiShopCodeOrTesteSeriaNumbe")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
                    this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                    return this.jobStatus;
                }
                if (this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet && this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet && this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet || !this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet && !this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet && !this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet) continue;
                this.logger.fatal("RepairShopCodeOrTesterSerialNumber has been set incompletely!");
                return AbstractJob.JobStatus.ERROR;
            }
            if (inputParameterName.equals("IPA_ProgrDate")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
                    this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                    return this.jobStatus;
                }
                if (this.isInputParamProgrammingDateYearSet && this.isInputParamProgrammingDateMonthSet && this.isInputParamProgrammingDateDaySet || !this.isInputParamProgrammingDateYearSet && !this.isInputParamProgrammingDateMonthSet && !this.isInputParamProgrammingDateDaySet) continue;
                this.logger.fatal("Programming date has been set incompletely!");
                return AbstractJob.JobStatus.ERROR;
            }
            if (inputParameterName.equals("Param_VWDevicNumbe")) {
                try {
                    this.vwDeviceNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.vwDeviceNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_ImporNumbe")) {
                try {
                    this.importerNumber = this.getParameterValueUint32AsShort((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.importerNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_WorksNumbe")) {
                try {
                    this.workshopNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.workshopNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_RepaiShopCodeOrTesteSeriaNumbe")) continue;
            if (inputParameterName.equals("Param_Year")) {
                try {
                    this.year = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.year);
                    }
                    this.isInputParamProgrammingDateYearSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_Month")) {
                try {
                    this.month = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.month);
                    }
                    this.isInputParamProgrammingDateMonthSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_Day")) {
                try {
                    this.day = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.day);
                    }
                    this.isInputParamProgrammingDateDaySet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("IPA_MaximBuffeSizeTransLayer")) {
                try {
                    this.maximumBlockSizeTransportLayer = this.getParameterValueUint32((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.maximumBlockSizeTransportLayer);
                }
                catch (Exception e) {
                    this.maximumBlockSizeTransportLayer = 4095L;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.maximumBlockSizeTransportLayer + " bytes.");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_MaximNumbeOfTransDataRepet")) {
                try {
                    this.maximumNumberOfTransferDataRepetitions = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.maximumNumberOfTransferDataRepetitions);
                }
                catch (Exception e) {
                    this.maximumNumberOfTransferDataRepetitions = 50;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.maximumNumberOfTransferDataRepetitions + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_STminHandl")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_STminHandl")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_ForceSTminLowerLimitAtJobStart") || inputParameterName.endsWith("Param_ForceSTminLowerLimitAtJobStart") || inputParameterName.equals("IPA_ForceSTminLowerLimitAtJobStart")) {
                try {
                    this.forceSTminLowerLimitAtJobStart = Boolean.valueOf(this.getParameterValueAsString((MCDParameter)inputParameter));
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + String.valueOf(this.forceSTminLowerLimitAtJobStart));
                    continue;
                }
                catch (Exception e) {
                    this.forceSTminLowerLimitAtJobStart = Boolean.valueOf("FALSE");
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.forceSTminLowerLimitAtJobStart + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_STminLowerLimit") || inputParameterName.endsWith("Param_STminLowerLimit") || inputParameterName.equals("IPA_STminLowerLimit")) {
                try {
                    this.sTminLowerLimit = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.sTminLowerLimit);
                }
                catch (Exception e) {
                    this.sTminLowerLimit = 0L;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.sTminLowerLimit + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_STminUpperLimit") || inputParameterName.endsWith("Param_STminUpperLimit") || inputParameterName.equals("IPA_STminUpperLimit")) {
                try {
                    this.sTminUpperLimit = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.sTminUpperLimit);
                    continue;
                }
                catch (Exception e) {
                    this.sTminUpperLimit = 2000L;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.sTminUpperLimit + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_EraseTime")) {
                try {
                    this.bdmEraseDelay = this.getParameterValueUint32AsShort((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.bdmEraseDelay);
                }
                catch (Exception e) {
                    this.bdmEraseDelay = (short)80;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.bdmEraseDelay + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_RequeTime")) {
                try {
                    this.bdmRequestSeparationTime = this.getParameterValueUint32AsShort((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.bdmRequestSeparationTime);
                }
                catch (Exception e) {
                    this.bdmRequestSeparationTime = (short)13;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.bdmRequestSeparationTime + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_VWDevicNumbe")) {
                if (this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet) continue;
                try {
                    this.vwDeviceNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.vwDeviceNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet = true;
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_ImporNumbe")) {
                if (this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet) continue;
                try {
                    this.importerNumber = this.getParameterValueUint32AsShort((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.importerNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet = true;
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_WorksNumbe")) {
                if (this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet) continue;
                try {
                    this.workshopNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.workshopNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet = true;
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_Year")) {
                if (this.isInputParamProgrammingDateYearSet) continue;
                try {
                    this.year = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.year);
                    }
                    this.isInputParamProgrammingDateYearSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("IPA_Month")) {
                if (this.isInputParamProgrammingDateMonthSet) continue;
                try {
                    this.month = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.month);
                    }
                    this.isInputParamProgrammingDateMonthSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("IPA_Day")) {
                if (this.isInputParamProgrammingDateDaySet) continue;
                try {
                    this.day = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.day);
                    }
                    this.isInputParamProgrammingDateDaySet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            return AbstractJob.JobStatus.ERROR;
        }
        if (pShortNameOfWrappingParameter == null) {
            if (!(this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet && this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet && this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet)) {
                this.logger.fatal("RepairShopCodeOrTesterSerialNumber has been set incompletely!");
                return AbstractJob.JobStatus.ERROR;
            }
            if (!(this.isInputParamProgrammingDateYearSet && this.isInputParamProgrammingDateMonthSet && this.isInputParamProgrammingDateDaySet)) {
                this.logger.warn("Programming date has been set incompletely!");
                this.year = (byte)(DateTime.calendar.get(1) - 2000);
                this.month = (byte)(DateTime.calendar.get(2) + 1);
                this.day = (byte)DateTime.calendar.get(5);
                this.logger.warn("- Defaulting to current year : " + this.year);
                this.logger.warn("- Defaulting to current month: " + this.month);
                this.logger.warn("- Defaulting to current day  : " + this.day);
            }
            if (this.bdmEraseDelay == -1) {
                this.bdmEraseDelay = (short)80;
            }
            if (this.bdmRequestSeparationTime == -1) {
                this.bdmRequestSeparationTime = (short)13;
            }
        }
        this.logger.trace("Leaving readInputParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareProtocolParameterSet() {
        block15: {
            MCDRequest protocolParameterSetRequest = null;
            MCDRequestParameter comParam = null;
            MCDValue paramValue = null;
            String modifyTiming = null;
            this.logger.trace("Entering prepareProtocolParameterSet(...).");
            try {
                this.protocolParameterSet = (MCDProtocolParameterSet)this.logicalLink.createDiagComPrimitiveByType(1193);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating ProtocolParameterSet!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                this.protocolParameterSet.fetchValuesFromInterface();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error fetching COMPARAM values from interface!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                protocolParameterSetRequest = this.protocolParameterSet.getRequest();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request of ProtocolParameterSet!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                this.protocolParameters = protocolParameterSetRequest.getRequestParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting COMPARAMs from ProtocolParameterSet request!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                comParam = this.protocolParameters.getItemByName("CP_ModifyTiming");
                this.isPduApiUsed = true;
                this.logger.info("Using PDU-API firmware with ISO 22900-2 COMPARAMs.");
                paramValue = comParam.getValue();
                modifyTiming = paramValue.getValueAsString();
                this.isModifyTimingEnabled = modifyTiming.equals("Enabled");
            }
            catch (MCDException mcde) {
                this.isPduApiUsed = false;
                this.logger.info("Using Softing EIDBSS firmware with proprietary COMPARAMs.");
                if (this.maximumBlockSizeTransportLayer <= 1012L) break block15;
                if (this.logger.getLogLevel() >= 4) {
                    this.logger.info("maximumBlockSizeTransportLayer (" + this.maximumBlockSizeTransportLayer + ") exceeds buffer limit of EDIC hardware with EIDBSS firmware (" + 1012 + " bytes)!");
                    this.logger.info("Limiting maximumBlockSizeTransportLayer to 1012 bytes.");
                }
                this.maximumBlockSizeTransportLayer = 1012L;
            }
        }
        this.logger.debug("Saving initial COMPARAM values.");
        try {
            if (this.isPduApiUsed) {
                this.diagnosticAddress = (byte)this.getProtocolParameterUint32(this.protocolParameterSet, "CP_CanPhysReqExtAddr");
                this.savedCanTransmissionTime = 150000L;
                this.savedP3CanClientPhys = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P3Min");
                this.logger.debug("P3Min: " + this.savedP3CanClientPhys);
                this.savedP3CanClientPhys = 155000L;
                this.savedP3CanClientFunc = 160000L;
                this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_RepeatReqCountApp");
                this.savedStandTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P2Max");
                this.savedExtenTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P2Star");
            } else {
                this.diagnosticAddress = (byte)this.getProtocolParameterUint32(this.protocolParameterSet, "DiagnosticAddress");
                this.savedCanTransmissionTime = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_CANTransTime");
                this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "NumberOfErrorRepetitions");
                this.savedStandTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "ResponseTimeout");
                this.savedExtenTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "RC78ResponseTimeout");
                this.savedP3CanClientPhys = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_P3CANClienPhys");
                this.savedP3CanClientFunc = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_P3CANClienFunc");
                this.savedRequestTime = this.getProtocolParameterUint32(this.protocolParameterSet, "RequestTime");
            }
            this.logger.debug("CP_P2Max        : " + this.savedStandTiminP2Serve);
            this.logger.debug("CP_P2Star       : " + this.savedExtenTiminP2Serve);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error saving initial COMPARAM values!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving prepareProtocolParameterSet(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus updateSessionTimings(MCDProtocolParameterSet pProtocolParameterSet, long pStandTiminP2Serve, long pExtenTiminP2Serve) throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int canTransmissionTime = 0;
        int p2CanServer = 0;
        int p2StarCanServer = 0;
        this.logger.trace("Entering updateSessionTimings(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.isPduApiUsed) {
            if (!this.isModifyTimingEnabled) {
                canTransmissionTime = 150000;
                p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "CP_P2Max");
                p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "CP_P2Star");
                this.logger.debug("Setting P2_CAN_Server (CP_P2Max) from " + p2CanServer + " \u00b5s to " + (pStandTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, "CP_P2Max", pStandTiminP2Serve * 1000L + (long)canTransmissionTime);
                this.logger.debug("Setting P2*_CAN_Server (CP_P2Star) from " + p2StarCanServer + " \u00b5s to " + (pExtenTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, "CP_P2Star", pExtenTiminP2Serve * 1000L + (long)canTransmissionTime);
            }
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "CP_P2Max");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "CP_P2Star");
            this.logger.debug("P2_CAN_Server  (CP_P2Max)  is now set to " + p2CanServer + " \u00b5s.");
            this.logger.debug("P2*_CAN_Server (CP_P2Star) is now set to " + p2StarCanServer + " \u00b5s.");
        } else {
            canTransmissionTime = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ComPar_CANTransTime");
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("Setting P2_CAN_Server (ResponseTimeout) from " + p2CanServer + " ms to " + (pStandTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "ResponseTimeout", pStandTiminP2Serve + (long)canTransmissionTime);
            this.logger.debug("Setting P2*_CAN_Server (RC78ResponseTimeout) from " + p2StarCanServer + " ms to " + (pExtenTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "RC78ResponseTimeout", pExtenTiminP2Serve + (long)canTransmissionTime);
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("P2_CAN_Server  (ResponseTimeout)     is now set to " + p2CanServer + " ms.");
            this.logger.debug("P2*_CAN_Server (RC78ResponseTimeout) is now set to " + p2StarCanServer + " ms.");
        }
        this.logger.trace("Leaving updateSessionTimings(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus executeDiagComPrimitiveSync(MCDLogicalLink pLogicalLink, MCDDiagComPrimitive pDiagComPrimitive, int pMaxNumberOfRepetitions, boolean pRemoveDiagComPrimitive) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResult result = null;
        int diagComPrimitiveType = -1;
        int transmissionMode = -1;
        String diagComPrimitiveName = null;
        MCDValue requestPdu = null;
        String requestPduAsString = null;
        int diagComPrimitiveState = -1;
        MCDErrors errors = null;
        this.logger.trace("Entering executeDiagComPrimitiveSync(...).");
        try {
            diagComPrimitiveType = pDiagComPrimitive.getObjectType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining type of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Type of diagComPrimitive: " + McdEnumDecoder.decodeMcdObjectType(diagComPrimitiveType));
        try {
            transmissionMode = pDiagComPrimitive.getDbObject().getTransmissionMode();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining transmission mode of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Transmission mode of diagComPrimitive: " + McdEnumDecoder.decodeMcdTransmissionMode(transmissionMode));
        try {
            diagComPrimitiveName = pDiagComPrimitive.getDbObject().getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Name of diagComPrimitive: " + diagComPrimitiveName);
        if (this.logger.getLogLevel() > 0 && (diagComPrimitiveType == 1190 || diagComPrimitiveType == 1198)) {
            try {
                requestPdu = pDiagComPrimitive.getRequest().getPDU();
                requestPduAsString = this.vendorSpecific.pduValue2String(requestPdu);
                if (requestPduAsString.length() > 256) {
                    requestPduAsString = requestPduAsString.substring(0, 256) + " ... (truncated for logging)";
                }
                this.logger.debug("Request PDU of diagComPrimitive: " + requestPduAsString);
                if (this.logger.getLogLevel() >= 6) {
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " -> [   ".substring(0, 8 - Integer.toHexString(requestPdu.getBytefield().length).length()) + Integer.toHexString(requestPdu.getBytefield().length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(requestPdu));
                }
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request PDU of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        int repetitions = pMaxNumberOfRepetitions;
        block24: do {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
            this.logger.debug("Executing diagComPrimitive '" + diagComPrimitiveName + "'.");
            try {
                --repetitions;
                result = pDiagComPrimitive.executeSync();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error executing diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Getting errors.");
            try {
                errors = pDiagComPrimitive.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting errors of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            if (errors == null) {
                this.logger.error("MCDDiagComPrimitive.getErrors() returned null.");
            } else {
                this.logger.debug("Handling errors.");
                currentJobStatus = this.handleErrors(errors);
            }
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                // empty if block
            }
            this.logger.debug("Determining state of diagComPrimitive.");
            try {
                diagComPrimitiveState = pDiagComPrimitive.getState();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining state of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("State of diagComPrimitive: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComPrimitiveState));
            switch (diagComPrimitiveState) {
                case 25090: {
                    try {
                        pDiagComPrimitive.cancel();
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error cancelling diagComPrimitive.");
                        this.logger.logThrowable(mcde);
                        currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        break;
                    }
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                case 25089: {
                    if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR || diagComPrimitiveType == 1201 || diagComPrimitiveType == 1202) continue block24;
                    currentJobStatus = this.handleResult(pDiagComPrimitive, diagComPrimitiveType, result);
                    this.logger.debug("job status after handleResult(): " + currentJobStatus);
                    if (currentJobStatus != AbstractJob.JobStatus.WRONG_UBATT_DETECTED) continue block24;
                    this.logger.debug("Cancelling repetitions due to detection of wrong battery voltage.");
                    repetitions = 0;
                    break;
                }
                default: {
                    this.logger.error("*** UNKNOWN MCDDiagComPrimitiveState ***: " + diagComPrimitiveState);
                }
            }
        } while (repetitions > 0 && currentJobStatus != AbstractJob.JobStatus.NO_ERROR);
        this.logger.debug("Releasing result.");
        try {
            this.job.releaseResult(result);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error releasing result.");
            this.logger.logThrowable(mcde);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pRemoveDiagComPrimitive) {
            try {
                pLogicalLink.removeDiagComPrimitive(pDiagComPrimitive);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving executeDiagComPrimitiveSync(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResult(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, MCDResult pResult) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        boolean resultHasError = false;
        this.logger.trace("Entering handleResult(...).");
        if (pDiagComPrimitiveType == 1198) {
            try {
                request = pDiagComPrimitive.getRequest();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request from diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                requestParameters = request.getRequestParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request parameters from request.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        try {
            resultHasError = pResult.hasError();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining if result has an error.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (resultHasError) {
            MCDError error = null;
            this.logger.debug("Result has error.");
            try {
                error = pResult.getError();
            }
            catch (Exception e) {
                this.logger.debug("Error getting error from result.");
                this.logger.logThrowable(e);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53392 && error.getVendorCode() == 259 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 5074 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53315 && error.getVendorCode() == 20480 || pDiagComPrimitiveType == 1198 && !this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 19) {
                this.logger.debug("Ignoring P2 timeout since positive response has been suppressed.");
            } else if (!this.responseExpected && (!this.isPduApiUsed && error.getCode() == 53327 && error.getVendorCode() == 19 || this.isPduApiUsed && error.getCode() == 53392 && error.getVendorCode() == 259)) {
                this.logger.debug("Ignoring P2 timeout since no response has been expected.");
            } else if (error.getCode() == 53327 && error.getVendorCode() == 257) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 20) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && (error.getVendorCode() == 17 || error.getVendorCode() == 25 || error.getVendorCode() == 26 || error.getVendorCode() == 42 || error.getVendorCode() == 47)) {
                this.logger.warn("Wrong battery voltage detected - probably due to an interruption of clamp 30 or 15!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.WRONG_UBATT_DETECTED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 27) {
                this.logger.warn("EDIC interface deadlock error detected - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 16 || error.getCode() == 53315 && error.getVendorCode() == 16) {
                this.logger.warn("Command refused by EDIC interface - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 58644 || error.getCode() == 53327 && (this.isPduApiUsed && error.getCode() == 262 || !this.isPduApiUsed && error.getCode() == 13)) {
                this.logger.warn("Communication to VCI lost (possibly due to voltage drop) - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_TO_VCI_LOST_OR_DISTURBED;
            } else {
                this.logger.logMcdError(error);
                if (this.responseExpected) {
                    if (this.bdmCurrentFlashPage != -1) {
                        this.bdmPageSuccessfullyFlashed[this.bdmCurrentFlashPage] = false;
                    }
                    currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
                }
                if (error.getCode() != 49152) {
                    if (this.isPduApiUsed && error.getCode() == 53327 && error.getVendorCode() == 5076) {
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        this.setJobInfo("ERROR: No result received from called job!");
                    } else if (error.getCode() != 49192) {
                        currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
                    } else {
                        String serviceShortName = null;
                        int resultType = -1;
                        MCDResponses responses = null;
                        try {
                            serviceShortName = pResult.getServiceShortName();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining service SHORT-NAME of result.");
                            this.logger.logThrowable(mcde);
                            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        }
                        this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
                        try {
                            resultType = pResult.getType();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining type of result.");
                            this.logger.logThrowable(mcde);
                            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        }
                        this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
                        if (resultType == 1793) {
                            this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
                        } else {
                            try {
                                responses = pResult.getResponses();
                            }
                            catch (MCDException mcde) {
                                this.logger.debug("Error getting responses from result.");
                                this.logger.logThrowable(mcde);
                                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                            }
                            currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, request, requestParameters, responses);
                            this.logger.debug("job status after handleResponses(): " + currentJobStatus);
                        }
                    }
                }
            }
            if (this.responseExpected && !this.isPduApiUsed) {
                this.logger.debug("Restarting communication after timeout.");
                if (error.getCode() != 49152) {
                    this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.stopCommunication, 1, false);
                    this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.startCommunication, 1, false);
                }
            }
        } else {
            String serviceShortName = null;
            int resultType = -1;
            MCDResponses responses = null;
            try {
                serviceShortName = pResult.getServiceShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining service SHORT-NAME of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
            try {
                resultType = pResult.getType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining type of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
            if (resultType == 1793) {
                this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
            } else {
                try {
                    responses = pResult.getResponses();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting responses from result.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, request, requestParameters, responses);
                this.logger.debug("job status after handleResponses(): " + currentJobStatus);
            }
        }
        this.logger.trace("Leaving handleResult(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResponses(int pDiagComPrimitiveType, String pServiceShortName, MCDRequest pRequest, MCDRequestParameters pRequestParameters, MCDResponses pResponses) {
        AbstractJob.JobStatus currentJobStatus = null;
        long responseCount = 0L;
        MCDResponse response = null;
        AbstractJob.JobStatus currentStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handleResponses(...).");
        try {
            responseCount = pResponses.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of responses.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of responses: " + responseCount);
        if (!this.isPositiveResponseSuppressed(pDiagComPrimitiveType, pRequestParameters)) {
            currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
        } else if (responseCount == 0L) {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        for (long i = 0L; i < responseCount; ++i) {
            try {
                response = pResponses.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            currentStatus = this.handleResponse(pDiagComPrimitiveType, pServiceShortName, pRequest, pRequestParameters, response);
            if (this.responseLocationAccessKey.equals(this.dbLocationAccessKey) || this.responseLocationAccessKey.equals(this.dbLocationAccessKeyBaseVariant)) {
                currentJobStatus = currentStatus;
                continue;
            }
            this.logger.debug("dbLocation of response    : " + this.responseLocationAccessKey);
            this.logger.debug("dbLocation of BASE-VARIANT: " + this.dbLocationAccessKeyBaseVariant);
            this.logger.debug("dbLocation of LOGICAL-LINK: " + this.dbLocationAccessKey);
        }
        this.logger.trace("Leaving handleResponses(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequest pRequest, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDAccessKey accessKeyOfLocation = null;
        int responseState = -1;
        this.logger.trace("Entering handleResponse(...).");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    accessKeyOfLocation = pResponse.getAccessKeyOfLocation();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (accessKeyOfLocation == null) {
                    this.logger.debug("MCDResponse.getAccessKeyOfLocation() returned null!");
                    return AbstractJob.JobStatus.ERROR;
                }
                try {
                    this.responseLocationAccessKey = accessKeyOfLocation.getString();
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting string for access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1192: 
            case 1197: 
            case 1200: {
                this.responseLocationAccessKey = this.dbLocationAccessKey;
                break;
            }
        }
        this.logger.debug("DbLocation of response: " + this.responseLocationAccessKey);
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " <- [   ".substring(0, 8 - Integer.toHexString(pResponse.getResponseMessage().getBytefield().length).length()) + Integer.toHexString(pResponse.getResponseMessage().getBytefield().length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting response message by getValueAsString().");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1200: {
                if (pServiceShortName.equals("SinglJob_SecurAcces")) {
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace("");
                    this.logger.busTrace("See MCD3_SecurAcces_*.asc for trace of SinglJob_SecurAcces.");
                    this.logger.busTrace("");
                    break;
                }
                if (pServiceShortName.equals("SinglJob_WriteFinge")) {
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace("");
                    this.logger.busTrace("See MCD3_WriteFinge_*.asc for trace of SinglJob_WriteFinge.");
                    this.logger.busTrace("");
                    break;
                }
                if (this.logger.getLogLevel() < 6) break;
                this.logger.busTrace("");
                this.logger.busTrace("No trace available for SinglJob_SecurAcces - messages might be missing.");
                this.logger.busTrace("");
                break;
            }
            case 1192: 
            case 1197: {
                break;
            }
        }
        try {
            responseState = pResponse.getState();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining response state.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (responseState) {
            case 26625: {
                currentJobStatus = this.handlePositiveResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 26626: {
                currentJobStatus = this.handleNegativeResponse(pDiagComPrimitiveType, pServiceShortName, pRequest, pRequestParameters, pResponse);
                break;
            }
            default: {
                this.logger.error("Invalid MCDResponseState: " + responseState);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handleResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveResponse(...).");
        this.logger.debug("Response is positive.");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                currentJobStatus = this.handlePositiveServiceResponse(pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 1192: 
            case 1197: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
            case 1200: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
        }
        this.logger.trace("Leaving handlePositiveResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveServiceResponse(String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        byte responseServiceIdentifier = 0;
        byte requestServiceIdentifier = 0;
        this.logger.trace("Entering handlePositiveServiceResponse(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
            responseMessageString = pResponse.getResponseMessage().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length < 1) {
            this.logger.error("Error getting response service id from response with length of " + responseMessage.length + " bytes.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        responseServiceIdentifier = responseMessage[0];
        if ((responseServiceIdentifier & 0x40 & 0xFF) == 0) {
            this.logger.error("The extracted response service id (0x" + Integer.toHexString(responseServiceIdentifier & 0xFF).toUpperCase() + ") is not a positive response service identifier!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        requestServiceIdentifier = (byte)(responseServiceIdentifier - 64);
        try {
            numberOfResponseParameters = pResponse.getResponseParameters().getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.warn("Ignoring response since it is not covered by a database response: " + responseMessageString);
        } else {
            switch (requestServiceIdentifier) {
                case 16: {
                    currentJobStatus = this.handlePositiveResponseDiagnosticSessionControl(pRequestParameters, pResponse);
                    break;
                }
                case 17: {
                    currentJobStatus = this.handlePositiveResponseEcuReset(pRequestParameters, pResponse);
                    break;
                }
                case 49: {
                    currentJobStatus = this.handlePositiveResponseRoutineControl(pRequestParameters, pResponse);
                    break;
                }
                default: {
                    this.logger.debug("*** UNKNOWN service ***: " + pServiceShortName);
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                }
            }
        }
        this.logger.trace("Leaving handlePositiveServiceResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseDiagnosticSessionControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String diagnosticSessionTypeRequest = null;
        String diagnosticSessionTypeResponse = null;
        MCDResponseParameters responseParameters = null;
        long p2CanServer = 0L;
        long p2StarCanServer = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseDiagnosticSessionControl(...).");
        try {
            diagnosticSessionTypeRequest = pRequestParameters.getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of request (Param_DiagnSessiType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            diagnosticSessionTypeResponse = pResponse.getResponseParameters().getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of response (Param_DiagnSessiType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!diagnosticSessionTypeResponse.equals(diagnosticSessionTypeRequest)) {
            this.logger.error("diagnosticSessionType of response does NOT match request: " + diagnosticSessionTypeRequest + " / " + diagnosticSessionTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            p2CanServer = responseParameters.getItemByName("Param_StandTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_StandTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
            this.logger.warn("Leaving session timings untouched since new timings could not be extracted from response!");
            return AbstractJob.JobStatus.NO_ERROR;
        }
        this.logger.info("Current value of P2_CAN_Server is: " + p2CanServer + " ms.");
        try {
            p2StarCanServer = responseParameters.getItemByName("Param_ExtenTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_ExtenTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
            this.logger.warn("Leaving session timings untouched since new timings could not be extracted from response!");
            return AbstractJob.JobStatus.NO_ERROR;
        }
        this.logger.info("Current value of P2*_CAN_Server is: " + p2StarCanServer + " ms.");
        if (!this.isPduApiUsed && p2StarCanServer > 65500L - this.savedCanTransmissionTime) {
            this.logger.warn("Provided value of P2*_CAN_Server exceeds maximum timeout supported by Softing EIDBSS firmware (" + (65500L - this.savedCanTransmissionTime) + " ms)...");
            this.logger.warn("... limiting P2*_CAN_Server to maximum supported value.");
            p2StarCanServer = (int)(65500L - this.savedCanTransmissionTime);
            this.logger.info("Current value of P2*_CAN_Server is now: " + p2StarCanServer + " ms.");
        }
        try {
            currentJobStatus = this.updateSessionTimings(this.protocolParameterSet, p2CanServer, p2StarCanServer);
        }
        catch (MCDException mcde) {
            this.logger.error("Error updating session timings.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return currentJobStatus;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 6) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseDiagnosticSessionControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseRoutineControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String routineIdentifierRequest = null;
        MCDResponseParameters responseParameters = null;
        this.logger.trace("Entering handlePositiveResponseRoutineControl(...).");
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            routineIdentifierRequest = pRequestParameters.getItemByName("Param_RoutiIdent").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine identifier of request (Param_RoutiIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (routineIdentifierRequest.equals("Check Programming Dependencies")) {
            currentJobStatus = this.handleRoutineStatusCheckMemory(pRequestParameters, pResponse, responseParameters);
        } else {
            this.logger.error("*** UNKNOWN routineIdentifier ***: " + routineIdentifierRequest);
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving handlePositiveResponseRoutineControl(...).");
        return currentJobStatus;
    }

    protected void setResponseExpected(boolean pValue, int pRequestDelay) throws MCDException {
        this.logger.trace("Entering bdmSetResponseExpected(...).");
        this.responseExpected = pValue;
        try {
            if (!pValue) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_P2Max", pRequestDelay * 1000 + 500);
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "ResponseRequired", "not required");
                    this.setProtocolParameterValue(this.protocolParameterSet, "RequestTime", pRequestDelay);
                }
            } else if (this.isPduApiUsed) {
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_P2Max", this.savedStandTiminP2Serve);
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 2L);
            } else {
                this.setProtocolParameterValue(this.protocolParameterSet, "ResponseRequired", "required");
                this.setProtocolParameterValue(this.protocolParameterSet, "RequestTime", pRequestDelay);
            }
        }
        catch (MCDException mcde) {
            this.logger.error("Error updating COMPARAMs!");
            throw mcde;
        }
        this.logger.debug("Set ResponseExpected to: " + pValue + " - requestDelay = " + pRequestDelay + " ms.");
        this.logger.trace("Leaving bdmSetResponseExpected(...).");
    }

    protected AbstractJob.JobStatus readFlash(MCDDbFlashSession pDbFlashSession) {
        byte[] flashData;
        MCDDbFlashDataBlock dbFlashDataBlock;
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        try {
            dbFlashDataBlock = pDbFlashSession.getDbDataBlocks().getItemByIndex(0L);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting first (and only) DATABLOCK of SESSION.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            flashData = dbFlashDataBlock.getDbFlashSegments().getItemByIndex(0L).getBinaryData();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting binary data from DATABLOCK.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("got binary data - length = " + flashData.length);
        this.bdmNumberOfFlashPages = (short)(flashData.length / 512);
        this.logger.debug("BDM_NUMBER_OF_FLASH_PAGES: " + this.bdmNumberOfFlashPages);
        if (flashData.length % 512 != 0) {
            this.bdmNumberOfFlashPages = (short)(this.bdmNumberOfFlashPages + 1);
        }
        this.bdmPartialChecksumStartPages = new short[BDM.PARTIAL_CHECKSUMS];
        this.bdmPartialChecksumNumberOfPages = new byte[BDM.PARTIAL_CHECKSUMS];
        short numberOfFlashPagesToCheck = this.bdmNumberOfFlashPages;
        short tmpNumberOfFlashPages = this.bdmNumberOfFlashPages;
        int i = 1;
        while ((byte)Math.pow(2.0, i) <= BDM.PARTIAL_CHECKSUMS) {
            if (tmpNumberOfFlashPages % (byte)Math.pow(2.0, i) != 0) {
                tmpNumberOfFlashPages = (short)(tmpNumberOfFlashPages + (byte)Math.pow(2.0, i - 1));
            }
            this.logger.debug("tmpNumberOfFlashPages: " + tmpNumberOfFlashPages);
            ++i;
        }
        for (i = 0; i < BDM.PARTIAL_CHECKSUMS; ++i) {
            this.bdmPartialChecksumStartPages[i] = (short)(tmpNumberOfFlashPages / BDM.PARTIAL_CHECKSUMS * i);
            this.bdmPartialChecksumNumberOfPages[i] = numberOfFlashPagesToCheck >= tmpNumberOfFlashPages / BDM.PARTIAL_CHECKSUMS ? (byte)(tmpNumberOfFlashPages / BDM.PARTIAL_CHECKSUMS) : (byte)numberOfFlashPagesToCheck;
            this.logger.debug("this.bdmPartialChecksumNumberOfPages[" + i + "]: " + this.bdmPartialChecksumNumberOfPages[i]);
            numberOfFlashPagesToCheck = (short)(numberOfFlashPagesToCheck - this.bdmPartialChecksumNumberOfPages[i]);
        }
        this.logger.debug("Number of partial checksums: " + BDM.PARTIAL_CHECKSUMS);
        for (i = 0; i < BDM.PARTIAL_CHECKSUMS; ++i) {
            if (this.bdmPartialChecksumNumberOfPages[i] <= 0) continue;
            this.logger.debug("Partial checksum " + i + " checks pages " + this.bdmPartialChecksumStartPages[i] + "-" + (this.bdmPartialChecksumStartPages[i] + this.bdmPartialChecksumNumberOfPages[i] - 1));
        }
        int BDM_NUMBER_OF_TD_REQUESTS = 128;
        this.binaryData = new byte[this.bdmNumberOfFlashPages][128][4];
        this.bdmFlashPageIsEmpty = new boolean[this.bdmNumberOfFlashPages];
        this.logger.debug("created binaryData.");
        for (int i2 = 0; i2 < this.bdmNumberOfFlashPages; ++i2) {
            this.bdmFlashPageIsEmpty[i2] = true;
            for (int j = 0; j < 128; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.binaryData[i2][j][k] = flashData[i2 * 512 + j * 4 + k];
                    if (this.binaryData[i2][j][k] == -1) continue;
                    this.bdmFlashPageIsEmpty[i2] = false;
                }
            }
        }
        this.logger.debug("filled binaryData.");
        flashData = null;
        dbFlashDataBlock = null;
        this.logger.debug("split binary data.");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus calculateChecksums(byte[][][] pFlashData) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        int partialChecksum = 0;
        this.bdmFlashPageChecksums = new int[this.bdmNumberOfFlashPages];
        this.bdmPartialChecksums = new int[BDM.PARTIAL_CHECKSUMS];
        for (int currentFlashPage = 0; currentFlashPage < this.bdmNumberOfFlashPages; ++currentFlashPage) {
            this.bdmFlashPageChecksums[currentFlashPage] = 0;
            for (int j = 0; j < 128; ++j) {
                for (int k = 0; k < 4; ++k) {
                    if (k % 2 == 0) {
                        int n = currentFlashPage;
                        this.bdmFlashPageChecksums[n] = this.bdmFlashPageChecksums[n] + (pFlashData[currentFlashPage][j][k] & 0xFF);
                        continue;
                    }
                    int n = currentFlashPage;
                    this.bdmFlashPageChecksums[n] = this.bdmFlashPageChecksums[n] + (pFlashData[currentFlashPage][j][k] << 8 & 0xFF00);
                }
            }
            partialChecksum += this.bdmFlashPageChecksums[currentFlashPage];
            for (int currentPartialCheckSum = 0; currentPartialCheckSum < BDM.PARTIAL_CHECKSUMS; ++currentPartialCheckSum) {
                if (this.bdmPartialChecksumNumberOfPages[currentPartialCheckSum] <= 0 || currentFlashPage != this.bdmPartialChecksumStartPages[currentPartialCheckSum] + this.bdmPartialChecksumNumberOfPages[currentPartialCheckSum] - 1) continue;
                this.bdmPartialChecksums[currentPartialCheckSum] = partialChecksum;
                this.logger.debug("bdmPartialChecksums[" + currentPartialCheckSum + "] = 0x" + Long.toHexString(this.bdmPartialChecksums[currentPartialCheckSum]).toUpperCase());
                partialChecksum = 0;
            }
        }
        return currentJobStatus;
    }

    protected static MCDService assignNAD(MCDLogicalLink pLogicalLink, String pLinSupplierId, String pLinFunctionId, byte pNewNAD) throws MCDException {
        MCDService assignNAD = null;
        assignNAD = (MCDService)pLogicalLink.createDiagComPrimitiveByName("DiagnServi_AssigNAD");
        if (pLinSupplierId != null) {
            MCDRequestParameter param_linSupplierId = assignNAD.getRequest().getRequestParameters().getItemByName("Param_LINSupplID");
            MCDValue linSupplierId = param_linSupplierId.createValue();
            linSupplierId.setValueAsString(pLinSupplierId);
            param_linSupplierId.setValue(linSupplierId);
        }
        if (pLinFunctionId != null) {
            MCDRequestParameter requestParamLinFunctionId = assignNAD.getRequest().getRequestParameters().getItemByName("Param_LINFunctID");
            MCDRequestParameters outerStructParams = requestParamLinFunctionId.getParameters();
            MCDRequestParameter outerStructParamLinFunctionId = outerStructParams.getItemByIndex(0L);
            MCDRequestParameters innerStructParams = outerStructParamLinFunctionId.getParameters();
            MCDRequestParameter param_linFunctionId = innerStructParams.getItemByName("Param_LINFunctID");
            MCDValue linFunctionId = param_linFunctionId.createValue();
            linFunctionId.setValueAsString(pLinFunctionId);
            param_linFunctionId.setValue(linFunctionId);
        }
        if (pNewNAD != 0) {
            MCDRequestParameter param_newNAD = assignNAD.getRequest().getRequestParameters().getItemByName("Param_NewNAD");
            MCDValue newNAD = param_newNAD.createValue();
            newNAD.setUint32((long)pNewNAD);
            param_newNAD.setValue(newNAD);
        }
        return assignNAD;
    }

    protected static final short getPageIndexByNumber(int pFlashPageNumber) {
        return (short)(1024 + pFlashPageNumber);
    }

    protected MCDService routineControlEraseMemory(MCDLogicalLink pLogicalLink, short pIndexOfStartPage, byte pNumberOfPages) throws MCDException {
        MCDService routineControl = null;
        routineControl = (MCDService)pLogicalLink.createDiagComPrimitiveByName("DiagnServi_RoutiContrEraseMemor");
        MCD3_FlashJobBDM.setIndexOfStartPage(routineControl, pIndexOfStartPage);
        MCD3_FlashJobBDM.setNumberOfPages(routineControl, pNumberOfPages);
        if (pNumberOfPages == 0 && this.dbEcuName.startsWith("EV_BDMLear")) {
            MCDValue pdu = routineControl.getRequest().createValue();
            if (this.isMcd20002Interface) {
                pdu.setBytefield(new byte[]{49, 1, -1, 0});
            } else {
                pdu.setBytefield(new byte[]{1, -1, 0});
            }
            routineControl.getRequest().enterPDU(pdu);
        }
        return routineControl;
    }

    protected AbstractJob.JobStatus routineControlEraseMemory(MCDRequest pRequest, MCDValue pValueRequestPdu, byte[] pRequestPdu, short pIndexOfStartPage) {
        pRequestPdu[2 + this.bdmNumberOfRequestSidBytesInRequestPdu] = (byte)(pIndexOfStartPage & 0xFF);
        pRequestPdu[3 + this.bdmNumberOfRequestSidBytesInRequestPdu] = (byte)(pIndexOfStartPage >> 8 & 0xFF);
        this.setRequestPduHex(pRequest, pValueRequestPdu, pRequestPdu);
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus requestDownload(MCDRequest pRequest, MCDValue pValueRequestPdu, byte[] pRequestPdu, short pIndexOfStartPage) {
        pRequestPdu[0 + this.bdmNumberOfRequestSidBytesInRequestPdu] = (byte)(pIndexOfStartPage & 0xFF);
        pRequestPdu[1 + this.bdmNumberOfRequestSidBytesInRequestPdu] = (byte)(pIndexOfStartPage >> 8 & 0xFF);
        this.setRequestPduHex(pRequest, pValueRequestPdu, pRequestPdu);
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected static MCDService routineControlCheckMemory(MCDLogicalLink pLogicalLink, short pIndexOfStartPage, byte pNumberOfPages) throws MCDException {
        MCDService routineControl = null;
        routineControl = (MCDService)pLogicalLink.createDiagComPrimitiveByName("DiagnServi_RoutiContrCheckMemor");
        MCD3_FlashJobBDM.setIndexOfStartPage(routineControl, pIndexOfStartPage);
        MCD3_FlashJobBDM.setNumberOfPages(routineControl, pNumberOfPages);
        return routineControl;
    }

    protected AbstractJob.JobStatus transferData(MCDRequest pRequest, MCDValue pValueRequestPdu, byte[] pRequestPdu, byte[] pTransferRequestParameterRecord) {
        System.arraycopy(pTransferRequestParameterRecord, 0, pRequestPdu, 0 + this.bdmNumberOfRequestSidBytesInRequestPdu, pRequestPdu.length - this.bdmNumberOfRequestSidBytesInRequestPdu);
        this.setRequestPduHex(pRequest, pValueRequestPdu, pRequestPdu);
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected static void setIndexOfStartPage(MCDService pService, short pIndexOfStartPage) throws MCDException {
        MCDRequestParameter param_indexOfStartPage = pService.getRequest().getRequestParameters().getItemByName("Param_IndexOfStartPage");
        MCDValue indexOfStartPage = param_indexOfStartPage.createValue();
        indexOfStartPage.setUint32((long)pIndexOfStartPage);
        param_indexOfStartPage.setValue(indexOfStartPage);
    }

    protected static void setIndexOfStartPageCheckMemory(MCDRequestParameter parameterCheckMemoryIndexOfStartPage, MCDValue valueCheckMemoryIndexOfStartPage, short pIndexOfStartPage) throws MCDException {
        valueCheckMemoryIndexOfStartPage.setUint32((long)pIndexOfStartPage);
        parameterCheckMemoryIndexOfStartPage.setValue(valueCheckMemoryIndexOfStartPage);
    }

    protected static void setNumberOfPages(MCDService pService, byte pNumberOfPages) throws MCDException {
        MCDRequestParameter param_numberOfPages = pService.getRequest().getRequestParameters().getItemByName("Param_NumbeOfPages");
        MCDValue numberOfPages = param_numberOfPages.createValue();
        numberOfPages.setUint32((long)pNumberOfPages);
        param_numberOfPages.setValue(numberOfPages);
    }

    protected AbstractJob.JobStatus setRequestPduHex(MCDRequest pRequest, MCDValue pValueRequestPdu, byte[] pRequestPdu) {
        try {
            pValueRequestPdu.setBytefield(pRequestPdu);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting requestPdu into MCD value object.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            pRequest.enterPDU(pValueRequestPdu);
        }
        catch (MCDException mcde) {
            this.logger.error("Error entering PDU into request.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus handleRoutineStatusCheckMemory(MCDRequestParameters pRequestParameters, MCDResponse pResponse, MCDResponseParameters pResponseParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        short numberOfPages = 0;
        int calculatedChecksum = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering bdmHandleRoutineStatusCheckMemory(...).");
        try {
            numberOfPages = (short)pRequestParameters.getItemByName("Param_NumbeOfPages").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting number of pages of request (Param_NumbeOfPages).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            calculatedChecksum = (int)pResponseParameters.getItemByName("Param_Check").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting checksum (Param_Check).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfPages == 1) {
            if (calculatedChecksum != this.bdmFlashPageChecksums[this.bdmCurrentFlashPage]) {
                this.logger.fatal("The checksum verification failed (expected: 0x" + Integer.toHexString(this.bdmFlashPageChecksums[this.bdmCurrentFlashPage]).toUpperCase() + " / received: 0x" + Integer.toHexString(calculatedChecksum).toUpperCase() + ").");
                this.bdmPageSuccessfullyFlashed[this.bdmCurrentFlashPage] = false;
                this.bdmNumberOfRepeatedPages = (short)(this.bdmNumberOfRepeatedPages + 1);
            } else {
                this.logger.debug("The checksum verification succeeded (0x" + Integer.toHexString(this.bdmFlashPageChecksums[this.bdmCurrentFlashPage]).toUpperCase() + ").");
                this.bdmPageSuccessfullyFlashed[this.bdmCurrentFlashPage] = true;
                this.bdmFlashPageState[this.bdmCurrentFlashPage] = 3;
                this.bdmCurrentFlashPage = (short)(this.bdmCurrentFlashPage - 1);
            }
            this.setJobProgress((this.bdmNumberOfFlashPages - this.bdmCurrentFlashPage) * 90 / this.bdmNumberOfFlashPages + 5);
        } else if (calculatedChecksum != this.bdmPartialChecksums[this.bdmCurrentPartialChecksum]) {
            this.logger.fatal("The partial checksum verification (" + (this.bdmCurrentPartialChecksum + 1) + "/" + BDM.PARTIAL_CHECKSUMS + ") failed (expected: 0x" + Integer.toHexString(this.bdmPartialChecksums[this.bdmCurrentPartialChecksum]).toUpperCase() + " / received: 0x" + Integer.toHexString(calculatedChecksum) + ").");
            this.jobStatus = AbstractJob.JobStatus.CHECKSUM_ERROR;
        } else {
            this.logger.debug("The partial checksum verification (" + (this.bdmCurrentPartialChecksum + 1) + "/" + BDM.PARTIAL_CHECKSUMS + ") succeeded (0x" + Integer.toHexString(this.bdmPartialChecksums[this.bdmCurrentPartialChecksum]).toUpperCase() + ").");
            this.bdmCurrentPartialChecksum = (byte)(this.bdmCurrentPartialChecksum + 1);
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 5) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving bdmHandleRoutineStatusCheckMemory(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareServices(MCDLogicalLink pLogicalLink) throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.bdmEraseMemory = (MCDService)pLogicalLink.createDiagComPrimitiveByName("DiagnServi_RoutiContrEraseMemor");
        this.bdmEraseMemoryRequest = this.bdmEraseMemory.getRequest();
        this.eraseMemorybdmRequestPduValue = this.bdmEraseMemoryRequest.getPDU();
        this.bdmEraseMemoryRequestPdu = new byte[5 + this.bdmNumberOfRequestSidBytesInRequestPdu];
        if (this.isMcd20002Interface) {
            this.bdmEraseMemoryRequestPdu[0] = 49;
        }
        this.bdmEraseMemoryRequestPdu[0 + this.bdmNumberOfRequestSidBytesInRequestPdu] = -1;
        this.bdmEraseMemoryRequestPdu[1 + this.bdmNumberOfRequestSidBytesInRequestPdu] = 0;
        this.bdmEraseMemoryRequestPdu[4 + this.bdmNumberOfRequestSidBytesInRequestPdu] = (byte)this.bdmNumberOfFlashPages;
        this.bdmRequestDownload = (MCDService)pLogicalLink.createDiagComPrimitiveByName("DiagnServi_RequeDownl");
        this.bdmRequestDownloadRequest = this.bdmRequestDownload.getRequest();
        this.bdmRequestDownloadRequestPduValue = this.bdmRequestDownloadRequest.getPDU();
        this.bdmRequestDownloadRequestPdu = new byte[3 + this.bdmNumberOfRequestSidBytesInRequestPdu];
        if (this.isMcd20002Interface) {
            this.bdmRequestDownloadRequestPdu[0] = 52;
        }
        this.bdmRequestDownloadRequestPdu[2 + this.bdmNumberOfRequestSidBytesInRequestPdu] = 1;
        this.bdmTransferData = (MCDService)pLogicalLink.createDiagComPrimitiveByName("DiagnServi_TransData");
        this.bdmTransferDataRequest = this.bdmTransferData.getRequest();
        this.bdmTransferDataRequestPduValue = this.bdmTransferDataRequest.getPDU();
        this.bdmTransferDataRequestPdu = new byte[4 + this.bdmNumberOfRequestSidBytesInRequestPdu];
        if (this.isMcd20002Interface) {
            this.bdmTransferDataRequestPdu[0] = 54;
        }
        this.bdmCheckMemory = (MCDService)pLogicalLink.createDiagComPrimitiveByName("DiagnServi_RoutiContrCheckMemor");
        this.bdmRequestParameterCheckMemoryIndexOfStartPage = this.bdmCheckMemory.getRequest().getRequestParameters().getItemByName("Param_IndexOfStartPage");
        this.bdmCheckMemoryIndexOfStartPageValue = this.bdmRequestParameterCheckMemoryIndexOfStartPage.getValue();
        MCD3_FlashJobBDM.setNumberOfPages(this.bdmCheckMemory, (byte)1);
        return currentJobStatus;
    }
}

