/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.jobs.impl.bdm;

import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequestParameters;
import asam.d.MCDService;
import asam.d.MCDSingleEcuJob;
import com.audi.mcd.joblibrary2.jobs.AbstractJob;
import com.audi.mcd.joblibrary2.util.Conversions;
import com.audi.mcd.joblibrary2.util.McdEnumDecoder;
import com.elektrobit.automotive.mcd.joblibrary.audi.uds.jobs.mcd201.MCD3_SecurAcces;
import java.math.BigInteger;

public class MCD3_SecurAccesBDM
extends MCD3_SecurAcces {
    private static final String REVISION = "1.1.20140826";
    protected static int instances = 0;
    protected static int nextInstance = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCD3_SecurAccesBDM() {
        super(REVISION);
        Class clazz = MCD3_SecurAccesBDM.class;
        synchronized (clazz) {
            this.instance = nextInstance++;
            ++instances;
        }
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        this.logger.trace("Entering execute(...).");
        this.jobStatus = this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, pJob);
        if (this.jobStatus == AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS) {
            throw new NullPointerException("At least one of the call parameters of the job is null!");
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("prepareJob successful - executing job logic...");
            this.jobCompletionStatus = this.executeJobLogicGuarded();
        }
        this.finalizeJobGuarded();
        this.logger.trace("Leaving execute(...).");
    }

    protected String executeJobLogicGuarded() {
        String currentJobCompletionStatus = null;
        try {
            currentJobCompletionStatus = this.executeJobLogic();
        }
        catch (MCDException mcde) {
            this.logger.debug("Caught MCDException in executeJobLogic() method.");
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in executeJobLogic() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in executeJobLogic() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        return currentJobCompletionStatus;
    }

    protected String executeJobLogic() throws MCDException {
        MCDService diagComPrimitive = null;
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int JOB_STEPS = 3;
        int currentJobStep = 0;
        block5: while (currentJobStep < 3 && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            switch (currentJobStep) {
                case 0: {
                    if (this.savedNumberOfErrorRepetitions != 2L) {
                        if (this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 2L);
                        } else {
                            this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 2L);
                        }
                    }
                    diagComPrimitive = this.securityAccessRequestSeed(this.logicalLink, "Request Seed " + this.securityMethod);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)diagComPrimitive, 1, true);
                    if (this.jobMessage.equals("SecurityAccess granted")) {
                        this.logger.info("ECU has already been unlocked (Seed 0x00 received).");
                        this.setJobInfo("ECU has already been unlocked (Seed 0x00 received).");
                        currentJobStep = 3;
                        continue block5;
                    }
                    if (this.securitySeed == null) {
                        this.logger.error("Aborting job due to missing seed value.");
                        this.jobCompletionStatus = "Job completed with errors";
                        this.jobMessage = "SecurityAccess failed";
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        currentJobStep = 3;
                        continue block5;
                    }
                    ++currentJobStep;
                    continue block5;
                }
                case 1: {
                    this.securityKey = this.calculateSecurityKey(this.securityMethod, this.securityCode, this.securityAlgorithm, this.securitySeed);
                    this.logger.debug("securityKey: " + Conversions.byteArray2String(this.securityKey));
                    this.setJobProgress(60L);
                    if (this.securityKey == null) {
                        // empty if block
                    }
                    ++currentJobStep;
                    continue block5;
                }
                case 2: {
                    this.logger.debug("securityMethod: " + this.securityMethod);
                    this.logger.debug("securityKey: " + Conversions.byteArray2String(this.securityKey));
                    diagComPrimitive = this.securityAccessSendKey(this.logicalLink, "Send Key " + this.securityMethod, this.securityKey);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)diagComPrimitive, 1, true);
                    ++currentJobStep;
                    continue block5;
                }
            }
            this.setJobProgress(95L);
        }
        if (this.isPduApiUsed) {
            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
        } else {
            this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
        }
        this.logger.debug("Final job status: " + currentJobStatus);
        this.jobStatus = currentJobStatus;
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobCompletionStatus = "Job completed successfully";
            this.jobMessage = "SecurityAccess granted";
        }
        return this.jobCompletionStatus;
    }

    protected MCDService securityAccessRequestSeed(MCDLogicalLink pLogicalLink, String pSecurityAccessType) throws MCDException {
        String securityAccessTypeToSet = pSecurityAccessType;
        MCDService securityAccess = null;
        this.logger.trace("Entering securityAccessRequestSeed(...).");
        securityAccess = this.createService(pLogicalLink, "DiagnServi_SecurAccesRequeSeed");
        if (pSecurityAccessType.endsWith("BDM AU48X")) {
            securityAccessTypeToSet = pSecurityAccessType.replaceAll("BDM AU48X", "Bootloader");
        }
        this.setRequestParameterString((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesType", securityAccessTypeToSet);
        this.logger.trace("Leaving securityAccessRequestSeed(...).");
        return securityAccess;
    }

    protected MCDService securityAccessSendKey(MCDLogicalLink pLogicalLink, String pSecurityAccessType, byte[] pSecurityKey) throws MCDException {
        String securityAccessTypeToSet = pSecurityAccessType;
        MCDService securityAccess = null;
        int securityKeyDataType = 255;
        this.logger.trace("Entering securityAccessSendKey(...).");
        securityAccess = this.createService(pLogicalLink, "DiagnServi_SecurAccesSendKey");
        if (pSecurityAccessType.endsWith("BDM AU48X")) {
            securityAccessTypeToSet = pSecurityAccessType.replaceAll("BDM AU48X", "Bootloader");
        }
        this.setRequestParameterString((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesType", securityAccessTypeToSet);
        if (pSecurityKey != null) {
            securityKeyDataType = this.getRequestParameterType((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesKey");
            switch (securityKeyDataType) {
                case 3: {
                    this.setRequestParameterBytefield((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesKey", pSecurityKey);
                    break;
                }
                case 11: {
                    this.setRequestParameterUint32((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesKey", Conversions.byteArray2Long(pSecurityKey));
                    break;
                }
                default: {
                    this.logger.error("The security key parameter has an unexpected MCD data type: " + McdEnumDecoder.decodeMcdDataType(securityKeyDataType) + ".");
                }
            }
            this.setJobProgress(80L);
        } else {
            this.logger.debug("No security key to set - probably securityAccessType=requestSeed");
        }
        this.logger.trace("Leaving securityAccessSendKey(...).");
        return securityAccess;
    }

    protected byte[] calculateSecurityKey(String pSecurityMethod, long pSecurityCode, byte[] pSecurityAlgorithm, byte[] pSecuritySeed) {
        byte[] calculatedSecurityKey = null;
        long securitySeedValue = 0L;
        long securityKeyValue = 0L;
        this.logger.trace("Entering calculateSecurityKey(...).");
        securitySeedValue = Conversions.byteArray2Long(pSecuritySeed) & 0xFFFFFFFFL;
        this.logger.info("Seed = " + Conversions.byteArray2String(pSecuritySeed));
        this.logger.debug("Seed = 0x" + Long.toHexString(securitySeedValue).toUpperCase());
        if (pSecurityMethod.equals("Bootloader")) {
            securityKeyValue = this.calculateSecurityKeySA2(securitySeedValue, pSecurityAlgorithm);
        } else if (pSecurityMethod.equals("Login") || pSecurityMethod.equals("System Specific")) {
            securityKeyValue = this.calculateSecurityKeyPin(securitySeedValue, pSecurityCode);
        } else if (pSecurityMethod.equals("BDM AU48X")) {
            securityKeyValue = this.dbEcuName.startsWith("EV_BDMLear") ? this.calculateSecurityKeyBdmLear(securitySeedValue) : this.calculateSecurityKeyBdmBosch(securitySeedValue);
        } else {
            throw new IllegalArgumentException("Invalid securityMethod: " + pSecurityMethod);
        }
        calculatedSecurityKey = Conversions.long2ByteArray(securityKeyValue, 4);
        this.logger.trace("Leaving calculateSecurityKey(...).");
        return calculatedSecurityKey;
    }

    protected long calculateSecurityKeyBdmLear(long pSecuritySeed) {
        this.logger.trace("Entering calculateSecurityKeyBdmLear(...).");
        long keyValue = pSecuritySeed;
        for (int i = 0; i < 6; ++i) {
            this.logger.debug("keyValue: 0x" + Long.toHexString(keyValue).toUpperCase());
            this.logger.debug("1/2: 0x" + Long.toHexString(keyValue << 31 & 0x80000000L).toUpperCase());
            this.logger.debug("2/2: 0x" + Long.toHexString(keyValue >>> 1 & Integer.MAX_VALUE).toUpperCase());
            keyValue = keyValue << 31 & 0x80000000L | keyValue >>> 1 & Integer.MAX_VALUE;
            this.logger.debug("keyValue: 0x" + Long.toHexString(keyValue).toUpperCase());
            if ((keyValue & 0x80000000L) <= 0L) continue;
            keyValue = (keyValue ^ 0xA221288L) & 0xFFFFFFFFL;
        }
        this.logger.debug("keyValue: 0x" + Long.toHexString(keyValue).toUpperCase());
        this.logger.trace("Leaving calculateSecurityKeyBdmLear(...).");
        return keyValue;
    }

    protected long calculateSecurityKeyBdmBosch(long pSecuritySeed) {
        this.logger.trace("Entering calculateSecurityKeyBdmBosch(...).");
        BigInteger CONST_A = new BigInteger(Conversions.long2ByteArray(2055390451L, 5));
        BigInteger CONST_B = new BigInteger(Conversions.long2ByteArray(3677417321L, 5));
        BigInteger CONST_C = new BigInteger(Conversions.long2ByteArray(306542764L, 5));
        BigInteger FF = new BigInteger(Conversions.long2ByteArray(0xFFFFFFFFL, 5));
        BigInteger OVERFLOW = FF.subtract(CONST_A);
        BigInteger seedValue = BigInteger.valueOf(pSecuritySeed & 0xFFFFFFFFFFFFFFFFL);
        this.logger.debug("seedValue: 0x" + Long.toHexString(seedValue.longValue()).toUpperCase());
        BigInteger keyValue = seedValue.add(CONST_A);
        keyValue = keyValue.and(FF);
        keyValue = OVERFLOW.compareTo(seedValue) < 0 ? keyValue.xor(CONST_B) : keyValue.xor(CONST_C);
        keyValue = keyValue.and(FF);
        BigInteger tmpValue = keyValue.and(BigInteger.valueOf(2047L));
        tmpValue = tmpValue.shiftLeft(21);
        keyValue = keyValue.shiftRight(11);
        keyValue = keyValue.or(tmpValue);
        this.logger.debug("keyValue: 0x" + Long.toHexString(keyValue.longValue()).toUpperCase());
        this.logger.trace("Leaving calculateSecurityKeyBdmBosch(...).");
        return keyValue.intValue();
    }
}

