/*
 * Decompiled with CFR 0.152.
 */
package com.elektrobit.automotive.mcd.joblibrary.audi.uds.jobs.mcd201;

import asam.d.MCDAccessKey;
import asam.d.MCDDataPrimitive;
import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbFlashDataBlock;
import asam.d.MCDDbFlashDataBlocks;
import asam.d.MCDDbFlashIdent;
import asam.d.MCDDbFlashIdents;
import asam.d.MCDDbFlashSession;
import asam.d.MCDDbIdentDescription;
import asam.d.MCDDbResponseParameter;
import asam.d.MCDDbSpecialDataGroups;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDErrors;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDProtocolParameterSet;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDService;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDStartCommunication;
import asam.d.MCDStopCommunication;
import asam.d.MCDValue;
import asam.d.MCDValues;
import com.audi.mcd.joblibrary2.jobs.AbstractJob;
import com.audi.mcd.joblibrary2.jobs.impl.AbstractSingleEcuJobImpl;
import com.audi.mcd.joblibrary2.util.Conversions;
import com.audi.mcd.joblibrary2.util.McdEnumDecoder;
import com.audi.mcd.joblibrary2.util.dserver.DServerVendor;
import com.audi.mcd.joblibrary2.util.dserver.VendorSpecific;
import com.audi.mcd.joblibrary2.util.dserver.VendorSpecificMCD20002;
import com.audi.mcd.joblibrary2.util.dserver.impl.SpecialDataGroupHelperImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MCD3_CheckOwnIdent
extends AbstractSingleEcuJobImpl {
    private static final String REVISION = "1.0.20141002";
    private static final String VW_LOGICAL_SOFTWARE_VERSION_OF_NON_UPDATEABLE_DATA_BLOCKS = "AFFE";
    private static int instances = 0;
    private static int nextInstance = 0;
    protected int instance;
    private String dbFlashSessionName = null;
    private String jobCompletionStatus = null;
    private String jobMessage = null;
    private MCDDbFlashSession dbFlashSession = null;
    private MCDDbFlashDataBlocks dbFlashDataBlocks = null;
    private long numberOfDbFlashDataBlocks = -1L;
    private Map programmableDbFlashDataBlockShortNames = null;
    private Map programmableDbFlashDataBlockLongNames = null;
    private Map programmableDbFlashDataBlockTypes = null;
    private ArrayList programmableDbFlashDataBlockNames = null;
    private Set validLogicalSoftwareBlockNumbers = null;
    private long savedNumberOfErrorRepetitions = 0L;
    private String vw80126Version = null;
    private Map dbOwnIdents = null;
    private Map dbOwnIdentShortNames = null;
    private Map dbOwnIdentLongNames = null;
    private Map dbOwnIdentDiagComms = null;
    private Map dbOwnIdentResponseParameters = null;
    private Map dbOwnIdentResponseParametersOfDiagComms = null;
    private Map identValues = null;
    private Map readResponseParameters = null;
    private Map readValues = null;
    private Set diagComms = null;
    private MCDProtocolParameterSet protocolParameterSet = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCD3_CheckOwnIdent() {
        super(REVISION);
        Class clazz = MCD3_CheckOwnIdent.class;
        synchronized (clazz) {
            this.instance = nextInstance++;
            ++instances;
        }
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        this.logger.trace("Entering execute(...).");
        this.jobStatus = this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, pJob);
        if (this.jobStatus == AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS) {
            throw new NullPointerException("At least one of the call parameters of the job is null!");
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("prepareJob successful - executing job logic...");
            this.jobCompletionStatus = this.executeJobLogicGuarded();
        }
        this.finalizeJobGuarded();
        this.logger.trace("Leaving execute(...).");
    }

    private AbstractJob.JobStatus prepareJobGuarded(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        try {
            currentJobStatus = this.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pJob);
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in prepareJob() method.");
            this.logger.logThrowable(e);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in prepareJob() method.");
            this.logger.logThrowable(t);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobStatus;
    }

    private AbstractJob.JobStatus prepareJob(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        this.jobStatus = super.prepareJob(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pJob);
        this.jobCompletionStatus = "Job aborted due to fatal errors";
        this.jobMessage = "Error checking OWN-IDENTS";
        this.jobStatus = AbstractJob.JobStatus.ERROR;
        this.jobStatus = this.readInputParameters(pRequestParameters);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        try {
            this.dbFlashSession = this.dbLocationOfLogicalLink.getDbFlashSessions().getItemByName(this.dbFlashSessionName);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting flash session with SHORT-NAME: " + this.dbFlashSessionName);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Preparing protocol parameter set.");
        try {
            this.prepareProtocolParameterSet();
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        catch (MCDException mcde) {
            this.logger.debug("Error preparing protocol parameter set.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.ERROR;
        }
        if (!this.isPduApiUsed) {
            this.logger.debug("Preparing global control primitives.");
            try {
                this.stopCommunication = this.stopCommunication(this.logicalLink);
                this.startCommunication = this.startCommunication(this.logicalLink);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating MCDStop/StartCommunication.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            if (this.isMcd20002Interface) {
                if (!this.readSpecialDataGroupsOfSession(this.dbFlashSession)) {
                    return AbstractJob.JobStatus.ERROR;
                }
            } else {
                this.logger.warn("Skipping all SDGS in ODX FLASH due to detected MCD3D 2.00.xx interface prior to 2.00.02!");
                this.logger.warn("=> Assuming VW80126 specification version prior to 2.0.0.");
                this.vw80126Version = "1.x.x";
            }
        }
        this.logger.trace("Leaving prepareJob(...).");
        return this.jobStatus;
    }

    private String executeJobLogicGuarded() {
        String currentJobCompletionStatus = null;
        try {
            currentJobCompletionStatus = this.executeJobLogic();
        }
        catch (MCDException mcde) {
            this.logger.debug("Caught MCD exception in executeJobLogic() method.");
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Exception e) {
            this.logger.debug("Caught exception in executeJobLogic() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Throwable t) {
            this.logger.debug("Caught throwable in executeJobLogic() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        return currentJobCompletionStatus;
    }

    private String executeJobLogic() throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        JobStep currentJobStep = JobStep.values[0];
        MCDDbFlashDataBlock currentDbFlashDataBlock = null;
        String currentDbFlashDataBlockType = null;
        String currentDbFlashDataBlockShortName = null;
        Iterator dbFlashDataBlockIterator = null;
        Iterator dbDataPrimitiveIterator = null;
        String currentDbDataPrimitiveShortName = null;
        MCDService currentDataPrimitive = null;
        MCDResponseParameters responseParameters = null;
        int dataBlockNumber = -1;
        this.setJobProgress(1L);
        while (currentJobStep.compareTo(JobStep.DONE) < 0 && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            if (currentJobStep == JobStep.READ_DATA_BLOCKS) {
                if (this.isPduApiUsed) {
                    this.setRepeatRequestCounter(2L);
                } else {
                    this.setRepeatRequestCounter(2L);
                }
                this.programmableDbFlashDataBlockTypes = new HashMap();
                this.programmableDbFlashDataBlockShortNames = new HashMap();
                this.programmableDbFlashDataBlockLongNames = new HashMap();
                this.readDataBlocks(this.dbFlashSession);
                this.logger.debug("Found " + this.numberOfDbFlashDataBlocks + " data blocks for the flash session " + this.dbFlashSessionName + ".");
                if (this.numberOfDbFlashDataBlocks > Integer.MAX_VALUE) {
                    this.logger.fatal("Found " + this.numberOfDbFlashDataBlocks + " data blocks. Only " + Integer.MAX_VALUE + " are supported.");
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                } else {
                    currentJobStep = JobStep.CHECK_FOR_ZERO_DATA_BLOCKS;
                }
                this.setJobProgress(2L);
                continue;
            }
            if (currentJobStep == JobStep.CHECK_FOR_ZERO_DATA_BLOCKS) {
                if (this.numberOfDbFlashDataBlocks == 0L) {
                    this.programmableDbFlashDataBlockNames.clear();
                    currentJobStep = JobStep.CHECK_FOR_LEFT_DATA_BLOCKS_IGNORING_DRIVERS;
                } else {
                    currentJobStep = JobStep.READ_FLASH_SESSION_NAME;
                }
                this.setJobProgress(3L);
                continue;
            }
            if (currentJobStep == JobStep.READ_FLASH_SESSION_NAME) {
                currentJobStatus = this.readFlashSessionName(this.dbFlashSession);
                this.setJobProgress(4L);
                currentJobStep = JobStep.EVALUATE_PROGRAMMING_STATE_OF_LOGICAL_SOFTWARE_BLOCKS;
                continue;
            }
            if (currentJobStep == JobStep.EVALUATE_PROGRAMMING_STATE_OF_LOGICAL_SOFTWARE_BLOCKS) {
                this.readResponseParameters = new HashMap();
                if (!this.vw80126Version.equals("2.0.0")) {
                    currentDataPrimitive = this.createService(this.logicalLink, "DiagnServi_ReadDataByIdentECUIdent");
                    this.setRequestParameter((MCDDiagComPrimitive)currentDataPrimitive, "Param_RecorDataIdent", "Fingerprint And Programming Date Of Logical Software Blocks");
                    this.jobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)currentDataPrimitive, 3, true);
                    this.validLogicalSoftwareBlockNumbers = new HashSet();
                    this.evaluateProgrammingStateOfLogicalSoftwareBlocks("DiagnServi_ReadDataByIdentECUIdent");
                }
                this.setJobProgress(5L);
                currentJobStep = JobStep.READ_OWN_IDENTS;
                continue;
            }
            if (currentJobStep == JobStep.READ_OWN_IDENTS) {
                this.dbOwnIdents = new HashMap();
                this.dbOwnIdentShortNames = new HashMap();
                this.dbOwnIdentLongNames = new HashMap();
                this.dbOwnIdentDiagComms = new HashMap();
                this.dbOwnIdentResponseParameters = new HashMap();
                this.dbOwnIdentResponseParametersOfDiagComms = new HashMap();
                this.identValues = new HashMap();
                this.logger.debug("Reading OWN-IDENTS.");
                this.logger.debug("Number of data blocks: " + this.programmableDbFlashDataBlockShortNames.size());
                dataBlockNumber = -1;
                dbFlashDataBlockIterator = this.programmableDbFlashDataBlockNames.iterator();
                while (dbFlashDataBlockIterator.hasNext()) {
                    currentDbFlashDataBlockShortName = (String)dbFlashDataBlockIterator.next();
                    currentDbFlashDataBlock = (MCDDbFlashDataBlock)this.programmableDbFlashDataBlockShortNames.get(currentDbFlashDataBlockShortName);
                    currentDbFlashDataBlockType = (String)this.programmableDbFlashDataBlockTypes.get(currentDbFlashDataBlock);
                    if (!(currentDbFlashDataBlockType.equals("FLASH_DATA") || currentDbFlashDataBlockType.equals("ERASE") || currentDbFlashDataBlockType.equals("DATA"))) {
                        this.logger.debug("Skipping OWN-IDENTs for data block " + currentDbFlashDataBlockShortName + " of TYPE \"" + currentDbFlashDataBlockType + "\"!");
                        continue;
                    }
                    dataBlockNumber = MCD3_CheckOwnIdent.getDataBlockNumberFromDataBlockShortName(currentDbFlashDataBlockShortName);
                    if (dataBlockNumber == -1) {
                        this.logger.debug("Skipping OWN-IDENTs for data block " + currentDbFlashDataBlockShortName + " since data block number cannot be extracted!");
                        continue;
                    }
                    if (!this.vw80126Version.equals("2.0.0") && !this.validLogicalSoftwareBlockNumbers.contains(new Integer(dataBlockNumber))) {
                        this.logger.debug("Skipping OWN-IDENTs for invalid data block " + currentDbFlashDataBlockShortName);
                        continue;
                    }
                    this.logger.debug("Reading OWN-IDENTS for " + currentDbFlashDataBlockShortName + ".");
                    if (this.readOwnIdents(currentDbFlashDataBlock)) continue;
                }
                this.diagComms = new HashSet(this.dbOwnIdentDiagComms.values());
                dbDataPrimitiveIterator = this.diagComms.iterator();
                this.readValues = new HashMap();
                this.setJobProgress(6L);
                currentJobStep = JobStep.EXECUTE_DATA_PRIMITIVES;
                continue;
            }
            if (currentJobStep == JobStep.EXECUTE_DATA_PRIMITIVES) {
                if (dbDataPrimitiveIterator == null || !dbDataPrimitiveIterator.hasNext()) {
                    currentJobStep = JobStep.CHECK_OWN_IDENTS;
                } else {
                    currentDbDataPrimitiveShortName = (String)dbDataPrimitiveIterator.next();
                    currentDataPrimitive = this.createDataPrimitiveByShortName(this.logicalLink, currentDbDataPrimitiveShortName);
                    if (!this.readValues.containsKey(currentDbDataPrimitiveShortName)) {
                        this.readValues.put(currentDbDataPrimitiveShortName, new HashMap());
                    }
                    if ((currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)currentDataPrimitive, 3, true)) != AbstractJob.JobStatus.NO_ERROR) {
                        currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                    } else {
                        currentJobStep = JobStep.EVALUATE_RESPONSE_PARAMETERS;
                    }
                }
                this.setJobProgress(7L);
                continue;
            }
            if (currentJobStep == JobStep.EVALUATE_RESPONSE_PARAMETERS) {
                if (this.readResponseParameters.containsKey(currentDbDataPrimitiveShortName)) {
                    responseParameters = (MCDResponseParameters)this.readResponseParameters.get(currentDbDataPrimitiveShortName);
                    currentJobStatus = this.evaluateResponseParameters(currentDbDataPrimitiveShortName, responseParameters);
                }
                if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                    currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                }
                currentJobStep = JobStep.EXECUTE_DATA_PRIMITIVES;
                this.setJobProgress(8L);
                continue;
            }
            if (currentJobStep == JobStep.CHECK_OWN_IDENTS) {
                this.logger.debug("Checking OWN-IDENTS.");
                dataBlockNumber = -1;
                dbFlashDataBlockIterator = ((ArrayList)this.programmableDbFlashDataBlockNames.clone()).iterator();
                while (dbFlashDataBlockIterator.hasNext()) {
                    currentDbFlashDataBlockShortName = (String)dbFlashDataBlockIterator.next();
                    currentDbFlashDataBlock = (MCDDbFlashDataBlock)this.programmableDbFlashDataBlockShortNames.get(currentDbFlashDataBlockShortName);
                    currentDbFlashDataBlockType = (String)this.programmableDbFlashDataBlockTypes.get(currentDbFlashDataBlock);
                    if (!(currentDbFlashDataBlockType.equals("FLASH_DATA") || currentDbFlashDataBlockType.equals("ERASE") || currentDbFlashDataBlockType.equals("DATA"))) {
                        this.logger.debug("Skipping OWN-IDENT check for data block " + currentDbFlashDataBlockShortName + " of TYPE \"" + currentDbFlashDataBlockType + "\"!");
                        continue;
                    }
                    dataBlockNumber = MCD3_CheckOwnIdent.getDataBlockNumberFromDataBlockShortName(currentDbFlashDataBlockShortName);
                    if (dataBlockNumber == -1) {
                        this.logger.debug("Skipping OWN-IDENT check for data block " + currentDbFlashDataBlockShortName + " since data block number cannot be extracted!");
                        continue;
                    }
                    if (!this.vw80126Version.equals("2.0.0") && !this.validLogicalSoftwareBlockNumbers.contains(new Integer(dataBlockNumber))) {
                        this.logger.debug("Skipping OWN-IDENT check for invalid data block " + currentDbFlashDataBlockShortName);
                        continue;
                    }
                    currentDbFlashDataBlock = (MCDDbFlashDataBlock)this.programmableDbFlashDataBlockShortNames.get(currentDbFlashDataBlockShortName);
                    this.logger.debug("Checking OWN-IDENTS for DATA-BLOCK: " + currentDbFlashDataBlockShortName);
                    if (!this.checkOwnIdents(currentDbFlashDataBlock)) continue;
                    this.logger.debug("Removing DATA-BLOCK " + currentDbFlashDataBlockShortName + " from available ones since OWN-IDENTS are fulfilled!");
                    this.programmableDbFlashDataBlockNames.remove(currentDbFlashDataBlockShortName);
                }
                this.logger.debug("Number of outdated data blocks: " + this.programmableDbFlashDataBlockNames.size());
                Iterator programmableFlashDataBlockIterator = this.programmableDbFlashDataBlockNames.iterator();
                while (programmableFlashDataBlockIterator.hasNext()) {
                    String dataBlockName = (String)programmableFlashDataBlockIterator.next();
                    this.logger.debug("outdated data block: " + dataBlockName);
                }
                currentJobStep = JobStep.RESET_REPEAT_REQUEST_COUNTER_APP;
                this.setJobProgress(9L);
                continue;
            }
            if (currentJobStep == JobStep.RESET_REPEAT_REQUEST_COUNTER_APP) {
                this.setRepeatRequestCounter(this.savedNumberOfErrorRepetitions);
                currentJobStep = JobStep.CHECK_FOR_LEFT_DATA_BLOCKS_IGNORING_DRIVERS;
                continue;
            }
            if (currentJobStep == JobStep.CHECK_FOR_LEFT_DATA_BLOCKS_IGNORING_DRIVERS) {
                if (!this.isUpdateNecessary()) {
                    this.logger.debug("Only non-DATA blocks would be downloaded...");
                    this.logger.debug("... removing them from the set of outdated data blocks.");
                    this.programmableDbFlashDataBlockNames.clear();
                } else if (this.jobStatus == AbstractJob.JobStatus.INCONSISTENT_OWN_IDENTS) {
                    currentJobStatus = this.jobStatus;
                }
                currentJobStep = JobStep.DONE;
                continue;
            }
            if (currentJobStep == JobStep.DONE) continue;
            this.logger.error("*** UNKNOWN job step ***: " + currentJobStep);
        }
        this.jobStatus = currentJobStatus;
        this.logger.debug("Final job status: " + currentJobStatus);
        this.setJobProgress(99L);
        if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobCompletionStatus = "Job completed successfully";
            this.jobMessage = "OWN-IDENTS checked successfully";
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        return this.jobCompletionStatus;
    }

    private void finalizeJobGuarded() {
        try {
            this.finalizeJob();
        }
        catch (Exception e) {
            this.logger.debug("Caught exception in finalizeJob() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught throwable in finalizeJob() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
    }

    protected void finalizeJob() {
        this.logger.trace("Entering finalizeJob(...).");
        if (this.jobMessage.equalsIgnoreCase("OWN-IDENTS checked successfully")) {
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        } else if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        super.finalizeJob();
        this.logger.finalize(this.getCurrentJobRuntimeAsString());
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int numberOfInputParameters = 0;
        MCDRequestParameter inputParameter = null;
        String inputParameterName = null;
        int logLevel = -1;
        this.logger.trace("Entering readInputParameters(...).");
        try {
            numberOfInputParameters = (int)pRequestParameters.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining number of job input parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Number of INPUT-PARAMETERS to read: " + numberOfInputParameters);
        for (long i = 0L; i < (long)numberOfInputParameters; ++i) {
            try {
                inputParameter = pRequestParameters.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                inputParameterName = inputParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting SHORT-NAME of job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            MCDValue value = null;
            try {
                value = inputParameter.getValue();
            }
            catch (MCDException mcde) {
                this.logger.warn("Error getting MCD value of job input parameter \"IPA_LogLevel\" - defaulting to " + logLevel + ".");
                this.logger.logThrowable(mcde);
            }
            if (value == null) continue;
            if (inputParameterName.equals("IPA_LogLevel")) {
                try {
                    logLevel = (int)value.getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getUint32());
                }
                catch (MCDException mcde) {
                    logLevel = 0;
                    this.logger.warn("Error getting value of job input parameter \"IPA_LogLevel\" - defaulting to " + logLevel + ".");
                    this.logger.logThrowable(mcde);
                }
                logLevel &= 7;
                if (this.logger.isConfiguredByPropertiesFile()) {
                    this.logger.debug("Ignoring " + inputParameterName + " since logger has already been configured by properties file.");
                    continue;
                }
                if (logLevel <= 0) continue;
                this.logger.init(this.dbEcuName, logLevel);
                continue;
            }
            if (inputParameterName.equals("IPA_FlashSessiName")) {
                try {
                    this.dbFlashSessionName = value.getValueAsString();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getValueAsString());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"IPA_FlashSessiName\" - aborting.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            throw new IllegalArgumentException("Unknown job input parameter: " + inputParameterName);
        }
        this.logger.trace("Leaving readInputParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus addOutputParameters(MCDResponse pResponse) {
        MCDResponseParameter respParam_jobCompletionStatus = null;
        MCDResponseParameter respParam_jobMessages = null;
        MCDResponseParameter respParam_outDatedDataBlocks = null;
        MCDValue value_jobCompletionStatus = null;
        if (pResponse == null) {
            this.logger.error("addOutputParameters() called with null argument!");
        } else {
            this.logger.debug("Retrieving response parameters.");
            try {
                respParam_jobCompletionStatus = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu");
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job output parameter with SHORT-NAME \"OPA_JobComplStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                respParam_jobMessages = pResponse.getResponseParameters().getItemByName("OPA_JobMessa");
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job output parameter with SHORT-NAME \"OPA_JobMessa\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                respParam_outDatedDataBlocks = pResponse.getResponseParameters().getItemByName("OPA_OutdaDataBlock");
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job output parameter with SHORT-NAME \"OPA_OutdaDataBlock\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Retrieving values.");
            try {
                value_jobCompletionStatus = this.jobApi.createValue(14);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting value of job output parameter with SHORT-NAME \"OPA_JobComplStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Setting values.");
            this.logger.debug("Setting job completion status: " + this.jobCompletionStatus);
            try {
                value_jobCompletionStatus.setValueAsString(this.jobCompletionStatus);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting value of job output parameter with SHORT-NAME \"OPA_JobComplStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (this.jobStatus == AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION) {
                this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU did not respond within the timeout period.");
            } else if (this.jobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU returned a negative response.");
            } else if (this.jobStatus == AbstractJob.JobStatus.WRONG_UBATT_DETECTED) {
                this.addJobMessage(respParam_jobMessages, "dynamic", "The voltage on terminal 30 is invalid.");
            } else if (this.jobStatus == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                this.addJobMessage(respParam_jobMessages, "dynamic", "Communication disturbed (error frames on bus).");
            } else {
                this.addJobMessage(respParam_jobMessages, "static", this.jobMessage);
            }
            this.addJobMessage(respParam_jobMessages, "dynamic", "Job runtime: " + this.getCurrentJobRuntimeAsString());
            this.logger.debug("Adding " + this.programmableDbFlashDataBlockNames.size() + " outdated data blocks.");
            Iterator outdatedDataBlockIterator = this.programmableDbFlashDataBlockNames.iterator();
            while (outdatedDataBlockIterator.hasNext()) {
                this.addOutdatedDataBlock(respParam_outDatedDataBlocks, (String)outdatedDataBlockIterator.next());
            }
            this.logger.debug("Setting output parameters.");
            try {
                respParam_jobCompletionStatus.setValue(value_jobCompletionStatus);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting parameter value of job output parameter with SHORT-NAME \"OPA_JobComplStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    private AbstractJob.JobStatus addJobMessage(MCDResponseParameter pJobMessages, String pMessageType, String pMessage) {
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter respParam_jobMessage = null;
        MCDResponseParameters respParams_messageMuxBranchElements = null;
        MCDResponseParameters respParams_messageMux = null;
        MCDResponseParameter muxBranch = null;
        MCDResponseParameter respParam_messageType = null;
        MCDResponseParameter respParam_message = null;
        MCDValue value_messageType = null;
        MCDValue value_message = null;
        int messageDataType = 255;
        try {
            fieldElements = pJobMessages.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobMessage = fieldElements.addElement();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding job message to collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType = this.getLastResponseParameterOfFieldByName(respParam_jobMessage, "Param_MessaType");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting of nested output parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType.setValueAsString(pMessageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType.setValue(value_messageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = this.getLastResponseParameterOfFieldByName(pJobMessages, "Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMux = respParam_message.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            muxBranch = respParams_messageMux.addMuxBranch(Conversions.longName2ShortName("Case_", pMessageType));
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding branch to multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMuxBranchElements = muxBranch.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer branch of Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = respParams_messageMuxBranchElements.getItemByName("Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameter Param_Messa from multiplexer branch.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_message = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            messageDataType = respParam_message.getType();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining MCD data type of nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("MCDDataType of message: " + McdEnumDecoder.decodeMcdDataType(messageDataType));
        try {
            value_message.setValueAsString(pMessage);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message.setValue(value_message);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    private AbstractJob.JobStatus addOutdatedDataBlock(MCDResponseParameter pOutdatedDataBlocks, String pOutDatedDataBlockShortName) {
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter respParam_outdatedDataBlockShortName = null;
        MCDValue value_outdatedDataBlockShortName = null;
        try {
            fieldElements = pOutdatedDataBlocks.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            fieldElements.addElement();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding outdated data block to collection of outdated data blocks.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_outdatedDataBlockShortName = this.getLastResponseParameterOfFieldByName(pOutdatedDataBlocks, "Param_DataBlockSHORTNAME");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting of nested output parameter Param_DataBlockSHORTNAME.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_outdatedDataBlockShortName = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_DataBlockSHORTNAME.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Adding " + pOutDatedDataBlockShortName);
        try {
            value_outdatedDataBlockShortName.setValueAsString(pOutDatedDataBlockShortName);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_DataBlockSHORTNAME.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_outdatedDataBlockShortName.setValue(value_outdatedDataBlockShortName);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_DataBlockSHORTNAME.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    private AbstractJob.JobStatus readFlashSessionName(MCDDbFlashSession pDbFlashSession) {
        String dbFlashSessionShortName = null;
        String dbFlashSessionLongName = null;
        this.logger.trace("Entering readFlashSessionName(...).");
        if (pDbFlashSession == null) {
            this.logger.error("pDbFlashSession is null!");
        } else {
            try {
                dbFlashSessionShortName = pDbFlashSession.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting SHORT-NAME of SESSION.");
                this.logger.logThrowable(mcde);
            }
            if (dbFlashSessionShortName != null) {
                dbFlashSessionLongName = pDbFlashSession.getLongName();
                if (dbFlashSessionLongName == null) {
                    dbFlashSessionLongName = "";
                }
                this.logger.debug("Name of SESSION: " + dbFlashSessionShortName + " (" + dbFlashSessionLongName + ")");
                this.programmableDbFlashDataBlockLongNames.put(pDbFlashSession, dbFlashSessionLongName);
            }
        }
        this.logger.trace("Leaving readFlashSessionName(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    private boolean readSpecialDataGroupsOfSession(MCDDbFlashSession pDbFlashSession) {
        SpecialDataGroupHelperImpl sdgHelper = null;
        MCDDbSpecialDataGroups dbSpecialDataGroups = null;
        HashMap specialDataElementsVw80126Version = null;
        this.logger.trace("Entering readSpecialDataGroupsOfSession(...).");
        sdgHelper = new SpecialDataGroupHelperImpl(this.logger, (VendorSpecificMCD20002)((Object)this.vendorSpecific));
        try {
            dbSpecialDataGroups = pDbFlashSession.getDbSDGs();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SDGS of the SESSION.");
            this.logger.logThrowable(mcde);
            return false;
        }
        specialDataElementsVw80126Version = new HashMap();
        if (!sdgHelper.getSpecialDataElementsFromSpecialDataGroupsByCaption(dbSpecialDataGroups, "SDGC_VW80126", specialDataElementsVw80126Version)) {
            return false;
        }
        this.vw80126Version = specialDataElementsVw80126Version.containsKey("VW80126-VERSION") ? (String)specialDataElementsVw80126Version.get("VW80126-VERSION") : "";
        this.logger.trace("Leaving readSpecialDataGroupsOfSession(...).");
        return true;
    }

    private boolean readDataBlocks(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readDataBlocks(...).");
        try {
            this.dbFlashDataBlocks = pDbFlashSession.getDbDataBlocks();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error reading DATABLOCKS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            this.numberOfDbFlashDataBlocks = (int)this.dbFlashDataBlocks.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of DATABLOCKS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        this.programmableDbFlashDataBlockNames = new ArrayList((int)this.numberOfDbFlashDataBlocks);
        this.programmableDbFlashDataBlockTypes = new HashMap();
        int i = 0;
        while ((long)i < this.numberOfDbFlashDataBlocks) {
            this.logger.debug("Reading DATABLOCK " + i + ".");
            if (!this.readDataBlockByIndex(i)) {
                this.logger.debug("Error reading DATABLOCK with index " + i + ".");
                return false;
            }
            ++i;
        }
        this.logger.trace("Leaving readDataBlocks(...).");
        return true;
    }

    private boolean readDataBlockByIndex(int pIndex) {
        MCDDbFlashDataBlock dbDataBlock = null;
        String dbDataBlockShortName = null;
        String dbDataBlockLongName = null;
        String dbDataBlockType = null;
        this.logger.trace("Entering readDataBlockByIndex(...).");
        try {
            dbDataBlock = this.dbFlashDataBlocks.getItemByIndex((long)pIndex);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error reading DATABLOCK with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            dbDataBlockShortName = dbDataBlock.getShortName();
            this.programmableDbFlashDataBlockShortNames.put(dbDataBlockShortName, dbDataBlock);
            this.programmableDbFlashDataBlockNames.add(dbDataBlockShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting SHORT-NAME DATABLOCK with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        dbDataBlockLongName = dbDataBlock.getLongName();
        if (dbDataBlockLongName == null) {
            this.programmableDbFlashDataBlockLongNames.put(dbDataBlock, "");
            this.logger.debug("Error getting LONG-NAME DATABLOCK with index " + pIndex + ".");
        } else {
            this.programmableDbFlashDataBlockLongNames.put(dbDataBlock, dbDataBlockLongName);
        }
        try {
            dbDataBlockType = dbDataBlock.getDataBlockType();
            this.programmableDbFlashDataBlockTypes.put(dbDataBlock, dbDataBlockType);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining TYPE of DATABLOCK with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        this.logger.trace("Leaving readDataBlockByIndex(...).");
        return true;
    }

    private boolean readOwnIdents(MCDDbFlashDataBlock pDbFlashDataBlock) {
        MCDDbFlashIdents currentDbOwnIdents = null;
        long currentNumberOfOwnIdents = 0L;
        MCDDbFlashIdent currentDbOwnIdent = null;
        HashSet<MCDDbFlashIdent> ownIdentsOfCurrentDataBlock = null;
        this.logger.trace("Entering readOwnIdents(...).");
        try {
            currentDbOwnIdents = pDbFlashDataBlock.getDbOwnIdents();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining OWN-IDENTS of the DATA-BLOCK.");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (currentDbOwnIdents == null) {
            this.logger.error("MCDDbFlashDataBlock.getDbOwnIdents() returned null!");
            return false;
        }
        try {
            currentNumberOfOwnIdents = currentDbOwnIdents.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of OWN-IDENTS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        this.logger.debug("Got " + currentNumberOfOwnIdents + " OWN-IDENTS.");
        if (currentNumberOfOwnIdents == 0L) {
            this.dbOwnIdents.put(pDbFlashDataBlock, null);
            return true;
        }
        if (currentNumberOfOwnIdents > Integer.MAX_VALUE) {
            this.logger.fatal("The DATA-BLOCK contains " + currentNumberOfOwnIdents + " OWN-IDENTS. Only " + Integer.MAX_VALUE + " are supported.");
            return false;
        }
        ownIdentsOfCurrentDataBlock = new HashSet<MCDDbFlashIdent>();
        int i = 0;
        while ((long)i < currentNumberOfOwnIdents) {
            currentDbOwnIdent = this.readOwnIdent(currentDbOwnIdents, i);
            if (currentDbOwnIdent == null) {
                this.logger.debug("Error getting OWN-IDENT with index " + i + ".");
                return false;
            }
            ownIdentsOfCurrentDataBlock.add(currentDbOwnIdent);
            ++i;
        }
        this.dbOwnIdents.put(pDbFlashDataBlock, ownIdentsOfCurrentDataBlock);
        this.logger.trace("Leaving readOwnIdents(...).");
        return true;
    }

    private MCDDbFlashIdent readOwnIdent(MCDDbFlashIdents pDbFlashIdents, long pIndex) {
        MCDDbFlashIdent currentDbOwnIdent = null;
        String dbOwnIdentShortName = null;
        String dbOwnIdentLongName = null;
        this.logger.trace("Entering readOwnIdent(...).");
        this.logger.debug("Reading OWN-IDENT with index " + pIndex + ".");
        try {
            currentDbOwnIdent = pDbFlashIdents.getItemByIndex(pIndex);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting OWN-IDENT with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        if (currentDbOwnIdent == null) {
            this.logger.error("MCDDbFlashIdents.getItemByIndex() returned null!");
            return null;
        }
        try {
            dbOwnIdentShortName = currentDbOwnIdent.getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of OWN-IDENT with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            this.dbOwnIdentShortNames.put(currentDbOwnIdent, "");
        }
        if (dbOwnIdentShortName == null) {
            this.logger.error("MCDDbFlashIdent.getShortName() returned null!");
            dbOwnIdentShortName = "";
        }
        this.dbOwnIdentShortNames.put(currentDbOwnIdent, dbOwnIdentShortName);
        dbOwnIdentLongName = currentDbOwnIdent.getLongName();
        if (dbOwnIdentLongName == null) {
            dbOwnIdentLongName = "";
        }
        this.logger.debug("Name of OWN-IDENT: " + dbOwnIdentShortName + " (" + dbOwnIdentLongName + ")");
        this.dbOwnIdentLongNames.put(currentDbOwnIdent, dbOwnIdentLongName);
        this.logger.debug("Reading IDENT-DESC of " + dbOwnIdentShortName + ".");
        if (!this.readIdentDescription(currentDbOwnIdent, dbOwnIdentShortName)) {
            this.logger.debug("Error reading IDENT-DESC of " + dbOwnIdentShortName + ".");
            return null;
        }
        this.logger.debug("Reading IDENT-VALUE of " + dbOwnIdentShortName + ".");
        if (!this.readIdentValues(currentDbOwnIdent, dbOwnIdentShortName)) {
            this.logger.debug("Error reading IDENT-VALUE of " + dbOwnIdentShortName + ".");
            return null;
        }
        this.logger.trace("Leaving readOwnIdent(...).");
        return currentDbOwnIdent;
    }

    private boolean readIdentDescription(MCDDbFlashIdent pDbFlashIdent, String pDbFlashIdentShortName) {
        MCDDbIdentDescription dbIdentDescription = null;
        MCDDbDataPrimitive dbDataPrimitive = null;
        String dbDataPrimitiveShortName = null;
        MCDDbResponseParameter dbResponseParameter = null;
        String dbResponseParameterShortName = null;
        Set<String> dbRequestParametersOfDiagComm = null;
        this.logger.trace("Entering readIdentDescription(...).");
        try {
            dbIdentDescription = pDbFlashIdent.getReadDbIdentDescription();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining IDENT-DESC of OWN-IDENT with the SHORT-NAME " + pDbFlashIdentShortName + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (dbIdentDescription == null) {
            this.logger.error("MCDDbFlashIdent.getReadDbIdentDescription() returned null!");
            return false;
        }
        try {
            dbDataPrimitive = this.vendorSpecific.getDbDataPrimitiveOfDbIdentDescription(dbIdentDescription, this.dbLocationOfLogicalLink);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining the DIAG-COMM referenced by the IDENT-DESC of the OWN-IDENT with the SHORT-NAME " + pDbFlashIdentShortName + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (dbDataPrimitive == null) {
            this.logger.error("MCDDbIdentDescription.getDbDataPrimitive() returned null!");
            return false;
        }
        try {
            dbDataPrimitiveShortName = dbDataPrimitive.getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining the SHORT-NAME of the DIAG-COMM referenced by the IDENT-DESC of the OWN-IDENT with the SHORT-NAME " + pDbFlashIdentShortName + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        dbResponseParameter = this.vendorSpecific.getDbResponseParameterOfDbIdentDescription(dbIdentDescription, this.dbLocationOfLogicalLink);
        if (dbResponseParameter == null) {
            this.logger.debug("Error determining the PARAM referenced by the IDENT-DESC of the OWN-IDENT with the SHORT-NAME " + pDbFlashIdentShortName + ".");
            return false;
        }
        try {
            dbResponseParameterShortName = dbResponseParameter.getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of database object of response parameter.");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (dbResponseParameterShortName == null) {
            this.logger.error("MCDDbResponseParameter.getShortName() returned null!");
            return false;
        }
        this.dbOwnIdentDiagComms.put(pDbFlashIdent, dbDataPrimitiveShortName);
        this.dbOwnIdentResponseParameters.put(pDbFlashIdent, dbResponseParameterShortName);
        if (this.dbOwnIdentResponseParametersOfDiagComms.containsKey(dbDataPrimitiveShortName)) {
            dbRequestParametersOfDiagComm = (Set)this.dbOwnIdentResponseParametersOfDiagComms.get(dbDataPrimitiveShortName);
        } else {
            dbRequestParametersOfDiagComm = new HashSet();
            this.dbOwnIdentResponseParametersOfDiagComms.put(dbDataPrimitiveShortName, dbRequestParametersOfDiagComm);
        }
        dbRequestParametersOfDiagComm.add(dbResponseParameterShortName);
        this.logger.trace("Leaving readIdentDescription(...).");
        return true;
    }

    private boolean readIdentValues(MCDDbFlashIdent pDbFlashIdent, String pDbFlashIdentShortName) {
        MCDValues identMcdValues = null;
        long numberOfIdentValues = 0L;
        String identValue = null;
        this.logger.trace("Entering readIdentValues(...).");
        try {
            identMcdValues = pDbFlashIdent.getIdentValues();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining IDENT-VALUES of OWN-IDENT with the SHORT-NAME " + pDbFlashIdentShortName + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (identMcdValues == null) {
            this.logger.error("MCDDbFlashIdent.getIdentValues() returned null!");
            return false;
        }
        try {
            numberOfIdentValues = identMcdValues.getCount();
            this.logger.debug("Found " + numberOfIdentValues + " IDENT-VALUES.");
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of IDENT-VALUES for OWN-IDENT with the SHORT-NAME " + pDbFlashIdentShortName + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (numberOfIdentValues == 0L) {
            this.logger.warn("The OWN-IDENT with the SHORT-NAME " + pDbFlashIdentShortName + " does not contain any IDENT-VALUES!");
            return false;
        }
        if (numberOfIdentValues > 1L) {
            this.logger.error("The OWN-IDENT with the SHORT-NAME " + pDbFlashIdentShortName + "  contains " + numberOfIdentValues + " IDENT-VALUES, but OWN-IDENTs may only have a single IDENT-VALUE.");
            return false;
        }
        identValue = this.readIdentValue(identMcdValues, 0L);
        if (identValue == null) {
            this.logger.debug("Error getting String value of IDENT-VALUE with index 0.");
            return false;
        }
        this.identValues.put(pDbFlashIdent, identValue);
        this.logger.trace("Leaving readIdentValues(...).");
        return true;
    }

    private String readIdentValue(MCDValues pMcdValues, long pIndex) {
        MCDValue identMcdValue = null;
        String identValue = null;
        this.logger.trace("Entering readIdentValue(...).");
        try {
            identMcdValue = pMcdValues.getItemByIndex(pIndex);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting IDENT-VALUE with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        if (identMcdValue == null) {
            this.logger.error("MCDValues.getItemByIndex() returned null!");
            return null;
        }
        try {
            identValue = identMcdValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting String value of IDENT-VALUE with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        if (identValue == null) {
            this.logger.error("MCDValue.getValueAsString() returned null!");
        }
        this.logger.trace("Leaving readIdentValue(...).");
        return identValue;
    }

    private void prepareProtocolParameterSet() throws MCDException {
        MCDRequestParameter reqParam = null;
        MCDValue paramValue = null;
        String modifyTiming = null;
        this.logger.trace("Entering prepareProtocolParameterSet(...).");
        this.protocolParameterSet = (MCDProtocolParameterSet)this.logicalLink.createDiagComPrimitiveByType(1193);
        this.protocolParameterSet.fetchValuesFromInterface();
        try {
            reqParam = this.protocolParameterSet.getRequest().getRequestParameters().getItemByName("CP_ModifyTiming");
            this.isPduApiUsed = true;
            this.logger.info("Using PDU-API firmware with ISO 22900-2 COMPARAMs.");
            paramValue = reqParam.getValue();
            modifyTiming = paramValue.getValueAsString();
            if (modifyTiming.equals("Enabled")) {
                this.logger.info("The PDU-API firmware will modify the session timings automatically.");
            } else {
                this.logger.warn("The PDU-API firmware will NOT modify the session timings automatically.");
                this.logger.warn("They will be modified by the job.");
            }
        }
        catch (MCDException mcde) {
            this.isPduApiUsed = false;
            this.logger.info("Using Softing EIDBSS firmware with proprietary COMPARAMs.");
        }
        this.logger.debug("Saving initial COMPARAM values.");
        this.savedNumberOfErrorRepetitions = this.isPduApiUsed ? this.getProtocolParameterUint32(this.protocolParameterSet, "CP_RepeatReqCountApp") : this.getProtocolParameterUint32(this.protocolParameterSet, "NumberOfErrorRepetitions");
        this.logger.trace("Leaving prepareProtocolParameterSet(...).");
    }

    private MCDStartCommunication startCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStartCommunication startCommunicationTmp = null;
        this.logger.trace("Entering startCommunication(...).");
        startCommunicationTmp = (MCDStartCommunication)pLogicalLink.createDiagComPrimitiveByType(1201);
        this.logger.trace("Leaving startCommunication(...).");
        return startCommunicationTmp;
    }

    private MCDStopCommunication stopCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStopCommunication stopCommunicationTmp = null;
        this.logger.trace("Entering stopCommunication(...).");
        stopCommunicationTmp = (MCDStopCommunication)pLogicalLink.createDiagComPrimitiveByType(1202);
        this.logger.trace("Leaving stopCommunication(...).");
        return stopCommunicationTmp;
    }

    private MCDDataPrimitive createDataPrimitiveByShortName(MCDLogicalLink pLogicalLink, String pDbDataPrimitiveShortName) {
        MCDDataPrimitive dataPrimitive = null;
        try {
            dataPrimitive = (MCDDataPrimitive)pLogicalLink.createDiagComPrimitiveByName(pDbDataPrimitiveShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating data primitive from database object.");
            this.logger.logThrowable(mcde);
        }
        return dataPrimitive;
    }

    private MCDService createService(MCDLogicalLink pLogicalLink, String pServiceShortName) {
        MCDService service = null;
        try {
            service = (MCDService)pLogicalLink.createDiagComPrimitiveByName(pServiceShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating service with SHORT-NAME: " + pServiceShortName);
            this.logger.logThrowable(mcde);
        }
        return service;
    }

    private void setRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setRequestParameter(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        MCDValue value = requestParameter.createValue();
        switch (value.getDataType()) {
            case 1: 
            case 14: {
                this.setValueString(value, pValue);
                break;
            }
            case 2: {
                this.setValueBitField(value, pValue);
                break;
            }
            case 19: {
                this.setValueBoolean(value, pValue);
                break;
            }
            case 3: {
                this.setValueByteField(value, pValue);
                break;
            }
            case 4: {
                this.setValueFloat32(value, pValue);
                break;
            }
            case 5: {
                this.setValueFloat64(value, pValue);
                break;
            }
            case 6: {
                this.setValueInt16(value, pValue);
                break;
            }
            case 7: {
                this.setValueInt32(value, pValue);
                break;
            }
            case 8: {
                this.setValueInt64(value, pValue);
                break;
            }
            case 9: {
                this.setValueInt8(value, pValue);
                break;
            }
            case 10: {
                this.setValueUint16(value, pValue);
                break;
            }
            case 11: {
                this.setValueUint32(value, pValue);
                break;
            }
            case 12: {
                this.setValueUint64(value, pValue);
                break;
            }
            case 13: {
                this.setValueUint8(value, pValue);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 255: {
                throw new IllegalArgumentException("Parameter of MCDDataType \"" + McdEnumDecoder.decodeMcdDataType(value.getDataType()) + "\" is not directly assignable!");
            }
            default: {
                throw new IllegalArgumentException("Parameter has unknown MCDDataType: 0x" + Integer.toHexString(value.getDataType()).toUpperCase());
            }
        }
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameter(...).");
    }

    private void setValueBitField(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueBitField(...).");
        if (pValue instanceof byte[]) {
            pMcdValue.setBitfield((byte[])pValue);
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_BITFIELD assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueBitField(...).");
    }

    private void setValueBoolean(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueBoolean(...).");
        if (pValue instanceof Boolean) {
            pMcdValue.setBoolean(((Boolean)pValue).booleanValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_BOOLEAN assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueBoolean(...).");
    }

    private void setValueByteField(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueByteField(...).");
        if (pValue instanceof byte[]) {
            pMcdValue.setBytefield((byte[])pValue);
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_BYTEFIELD assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueByteField(...).");
    }

    private void setValueFloat32(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueFloat32(...).");
        if (pValue instanceof Float) {
            pMcdValue.setFloat32(((Float)pValue).floatValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setFloat32(((Double)pValue).floatValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setFloat32(((Long)pValue).floatValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setFloat32(((Integer)pValue).floatValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setFloat32(((Short)pValue).floatValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setFloat32(((Byte)pValue).floatValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_FLOAT32 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueFloat32(...).");
    }

    private void setValueFloat64(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueFloat64(...).");
        if (pValue instanceof Double) {
            pMcdValue.setFloat64(((Double)pValue).doubleValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setFloat64(((Float)pValue).doubleValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setFloat64(((Long)pValue).doubleValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setFloat64(((Integer)pValue).doubleValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setFloat64(((Short)pValue).doubleValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setFloat64(((Byte)pValue).doubleValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_FLOAT64 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueFloat64(...).");
    }

    private void setValueInt16(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueInt16(...).");
        if (pValue instanceof Short) {
            pMcdValue.setInt16(((Short)pValue).shortValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setInt16(((Byte)pValue).shortValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setInt16(((Integer)pValue).shortValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setInt16(((Long)pValue).shortValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setInt16(((Float)pValue).shortValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setInt16(((Double)pValue).shortValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_INT16 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueInt16(...).");
    }

    private void setValueInt32(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueInt32(...).");
        if (pValue instanceof Integer) {
            pMcdValue.setInt32(((Integer)pValue).intValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setInt32(((Byte)pValue).intValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setInt32(((Short)pValue).intValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setInt32(((Long)pValue).intValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setInt32(((Float)pValue).intValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setInt32(((Double)pValue).intValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_INT32 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueInt32(...).");
    }

    private void setValueInt64(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueByteField(...).");
        if (pValue instanceof Long) {
            pMcdValue.setInt64(((Long)pValue).longValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setInt64(((Integer)pValue).longValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setInt64(((Short)pValue).longValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setInt64(((Byte)pValue).longValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setInt64(((Float)pValue).longValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setInt64(((Double)pValue).longValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_INT64 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueByteField(...).");
    }

    private void setValueInt8(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueInt8(...).");
        if (pValue instanceof Byte) {
            pMcdValue.setInt8(((Byte)pValue).byteValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setInt8(((Short)pValue).byteValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setInt8(((Integer)pValue).byteValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setInt8(((Long)pValue).byteValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setInt8(((Float)pValue).byteValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setInt8(((Double)pValue).byteValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_INT8 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueInt8(...).");
    }

    private void setValueUint16(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueUint16(...).");
        if (pValue instanceof Integer) {
            pMcdValue.setUint16(((Integer)pValue).intValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setUint16(((Byte)pValue).intValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setUint16(((Short)pValue).intValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setUint16(((Long)pValue).intValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setUint16(((Float)pValue).intValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setUint16(((Double)pValue).intValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_UINT16 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueUint16(...).");
    }

    private void setValueUint32(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueUint32(...).");
        if (pValue instanceof Long) {
            pMcdValue.setUint32(((Long)pValue).longValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setUint32(((Integer)pValue).longValue());
        } else if (pValue instanceof Short) {
            pMcdValue.setUint32(((Short)pValue).longValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setUint32(((Byte)pValue).longValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setUint32(((Float)pValue).longValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setUint32(((Double)pValue).longValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_UINT32 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueUint32(...).");
    }

    private void setValueUint64(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueUint64(...).");
        if (pValue instanceof BigInteger) {
            pMcdValue.setUint64((BigInteger)pValue);
        }
        if (pValue instanceof Long) {
            pMcdValue.setUint64(BigInteger.valueOf((Long)pValue));
        } else if (pValue instanceof Integer) {
            pMcdValue.setUint64(BigInteger.valueOf(((Integer)pValue).longValue()));
        } else if (pValue instanceof Short) {
            pMcdValue.setUint64(BigInteger.valueOf(((Short)pValue).longValue()));
        } else if (pValue instanceof Byte) {
            pMcdValue.setUint64(BigInteger.valueOf(((Byte)pValue).longValue()));
        } else if (pValue instanceof Float) {
            pMcdValue.setUint64(new BigInteger(((Float)pValue).toString()));
        } else if (pValue instanceof Double) {
            pMcdValue.setUint64(new BigInteger(((Double)pValue).toString()));
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_UINT64 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueUint64(...).");
    }

    private void setValueUint8(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueUint8(...).");
        if (pValue instanceof Short) {
            pMcdValue.setUint8(((Short)pValue).shortValue());
        } else if (pValue instanceof Byte) {
            pMcdValue.setUint8(((Byte)pValue).shortValue());
        } else if (pValue instanceof Integer) {
            pMcdValue.setUint8(((Integer)pValue).shortValue());
        } else if (pValue instanceof Long) {
            pMcdValue.setUint8(((Long)pValue).shortValue());
        } else if (pValue instanceof Float) {
            pMcdValue.setUint8(((Float)pValue).shortValue());
        } else if (pValue instanceof Double) {
            pMcdValue.setUint8(((Double)pValue).shortValue());
        } else if (pValue instanceof String) {
            pMcdValue.setValueAsString((String)pValue);
        } else {
            throw new IllegalArgumentException("Invalid object type for eA_UINT8 assignment: " + pValue.getClass().getName());
        }
        this.logger.trace("Leaving setValueUint8(...).");
    }

    private void setValueString(MCDValue pMcdValue, Object pValue) throws IllegalArgumentException, MCDException {
        this.logger.trace("Entering setValueString(...).");
        if (!(pValue instanceof String)) {
            throw new IllegalArgumentException("Invalid object type for eA_UNICODE2STRING assignment: " + pValue.getClass().getName());
        }
        pMcdValue.setValueAsString((String)pValue);
        this.logger.trace("Leaving setValueString(...).");
    }

    private MCDRequestParameter getRequestParameter(MCDRequestParameters pRequestParameters, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = null;
        MCDRequestParameter currentRequestParameter = null;
        MCDRequestParameters requestSubParameters = null;
        long numberOfRequestParameters = 0L;
        try {
            requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        }
        catch (MCDException mcde) {
            if (mcde.getError().getCode() != 49184 && mcde.getError().getCode() != 49177) {
                this.logger.debug("Error getting request parameter with SHORT-NAME \"" + pRequestParameterName + "\"!");
                this.logger.logThrowable(mcde);
            }
            numberOfRequestParameters = pRequestParameters.getCount();
            for (long i = 0L; i < numberOfRequestParameters && requestParameter == null; ++i) {
                currentRequestParameter = pRequestParameters.getItemByIndex(i);
                if (currentRequestParameter.getType() != 17) continue;
                requestSubParameters = currentRequestParameter.getParameters();
                requestParameter = this.getRequestParameter(requestSubParameters, pRequestParameterName);
            }
        }
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    private MCDRequestParameter getRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive.getRequest().getRequestParameters(), pRequestParameterName);
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    private void updateProtocolParameters(MCDProtocolParameterSet pProtocolParameterSet) {
        int diagComprimitiveState;
        MCDResult result;
        MCDError error;
        long numberOfErrors;
        MCDErrors errors;
        block29: {
            errors = null;
            numberOfErrors = 0L;
            error = null;
            result = null;
            diagComprimitiveState = 0;
            this.logger.trace("Entering updateProtocolParameters(...).");
            try {
                result = pProtocolParameterSet.executeSync();
            }
            catch (MCDException mcde) {
                this.logger.error("Error executing MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            try {
                errors = pProtocolParameterSet.getErrors();
                if (errors == null) {
                    this.logger.debug("MCDProtocolParameterSet.getErrors() returned null!");
                    break block29;
                }
                try {
                    numberOfErrors = errors.getCount();
                    this.logger.debug("Protocol parameter set has " + numberOfErrors + " errors.");
                    int i = 0;
                    while ((long)i < numberOfErrors) {
                        try {
                            error = errors.getItemByIndex((long)i);
                            this.logger.logMcdError(error);
                        }
                        catch (MCDException mcde) {
                            this.logger.error("Error determining number of errors of protocol parameter set.");
                            this.logger.logThrowable(mcde);
                            return;
                        }
                        ++i;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error determining number of errors of protocol parameter set.");
                    this.logger.logThrowable(mcde);
                    return;
                }
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining errors of protocol parameter set.");
                this.logger.logThrowable(mcde);
                return;
            }
        }
        try {
            diagComprimitiveState = pProtocolParameterSet.getState();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining comprimitive state of protocol parameter set.");
            this.logger.logThrowable(mcde);
            return;
        }
        this.logger.info("Current state of protocol parameter set is: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComprimitiveState));
        if (result != null) {
            boolean resultHasError = true;
            try {
                resultHasError = result.hasError();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining if result has an error.");
                this.logger.logThrowable(mcde);
                return;
            }
            if (resultHasError) {
                error = null;
                this.logger.debug("Error updating protocol parameters: Result has error.");
                try {
                    error = result.getError();
                }
                catch (Exception e) {
                    this.logger.error("Error getting error from result.");
                    this.logger.logThrowable(e);
                    return;
                }
                this.logger.logMcdError(error);
            } else {
                int executionState = -1;
                try {
                    executionState = result.getResultState().getExecutionState();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting execution state from result state.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.debug("Success updating protocol parameters.");
                this.logger.debug("ResultState of MCDProtocolParameterSet: " + McdEnumDecoder.decodeMcdExecutionState(executionState));
            }
        } else {
            errors = null;
            numberOfErrors = 0L;
            error = null;
            this.logger.debug("Error updating protocol parameters: Result is null. This is caused by a DTS bug.");
            try {
                errors = pProtocolParameterSet.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting errors from MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            try {
                numberOfErrors = errors.getCount();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining number of errors of MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = errors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + " from MCDProtocolParameterSet.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving updateProtocolParameters(...).");
    }

    private void setRepeatRequestCounter(long pNumberOfRepetitions) {
        this.logger.trace("Entering setRepeatRequestCounter(...).");
        if (this.isPduApiUsed) {
            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", pNumberOfRepetitions);
        } else {
            this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", pNumberOfRepetitions);
        }
        this.logger.debug("RepeatRequestCounter set to: " + pNumberOfRepetitions);
        this.logger.trace("Leaving setRepeatRequestCounter(...).");
    }

    private AbstractJob.JobStatus executeDiagComPrimitiveSync(MCDLogicalLink pLogicalLink, MCDDiagComPrimitive pDiagComPrimitive, int pMaxNumberOfRepetitions, boolean pRemoveDiagComPrimitive) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResult result = null;
        int diagComPrimitiveType = -1;
        String diagComPrimitiveName = null;
        MCDValue requestPdu = null;
        int diagComPrimitiveState = -1;
        MCDErrors errors = null;
        this.logger.trace("Entering executeDiagComPrimitiveSync(...).");
        try {
            diagComPrimitiveType = pDiagComPrimitive.getObjectType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining type of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Type of diagComPrimitive: " + McdEnumDecoder.decodeMcdObjectType(diagComPrimitiveType));
        try {
            diagComPrimitiveName = pDiagComPrimitive.getDbObject().getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Name of diagComPrimitive: " + diagComPrimitiveName);
        if (this.logger.getLogLevel() > 0 && (diagComPrimitiveType == 1190 || diagComPrimitiveType == 1198)) {
            try {
                requestPdu = pDiagComPrimitive.getRequest().getPDU();
                this.logger.debug("Request PDU of diagComPrimitive: " + this.vendorSpecific.pduValue2String(requestPdu));
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request PDU of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        int repetitions = pMaxNumberOfRepetitions;
        block22: do {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
            this.logger.debug("Executing diagComPrimitive '" + diagComPrimitiveName + "'.");
            try {
                --repetitions;
                result = pDiagComPrimitive.executeSync();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error executing diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Getting errors.");
            try {
                errors = pDiagComPrimitive.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting errors of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Handling errors.");
            if (errors == null) {
                this.logger.error("MCDDiagComPrimitive.getErrors() returned null.");
            } else {
                currentJobStatus = this.handleErrors(errors);
            }
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                // empty if block
            }
            this.logger.debug("Determining state of diagComPrimitive.");
            try {
                diagComPrimitiveState = pDiagComPrimitive.getState();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining state of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("State of diagComPrimitive: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComPrimitiveState));
            switch (diagComPrimitiveState) {
                case 25090: {
                    try {
                        pDiagComPrimitive.cancel();
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error cancelling diagComPrimitive.");
                        this.logger.logThrowable(mcde);
                        currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        break;
                    }
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                case 25089: {
                    if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR || diagComPrimitiveType == 1201 || diagComPrimitiveType == 1202) continue block22;
                    currentJobStatus = this.handleResult(pDiagComPrimitive, diagComPrimitiveType, result);
                    this.logger.debug("job status after handleResult(): " + currentJobStatus);
                    if (currentJobStatus != AbstractJob.JobStatus.WRONG_UBATT_DETECTED) continue block22;
                    this.logger.debug("Cancelling repetitions due to detection of wrong battery voltage.");
                    repetitions = 0;
                    break;
                }
                default: {
                    this.logger.error("*** UNKNOWN MCDDiagComPrimitiveState ***: " + diagComPrimitiveState);
                }
            }
        } while (repetitions > 0 && currentJobStatus != AbstractJob.JobStatus.NO_ERROR);
        this.logger.debug("Releasing result.");
        try {
            this.job.releaseResult(result);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error releasing result.");
            this.logger.logThrowable(mcde);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pRemoveDiagComPrimitive) {
            try {
                pLogicalLink.removeDiagComPrimitive(pDiagComPrimitive);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error removing diagComPrimitive form logical link.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving executeDiagComPrimitiveSync(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus handleResult(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, MCDResult pResult) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        boolean resultHasError = false;
        boolean handleResponses = true;
        this.logger.trace("Entering handleResult(...).");
        try {
            request = pDiagComPrimitive.getRequest();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting request from diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            requestParameters = request.getRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting request parameters from request.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            resultHasError = pResult.hasError();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining if result has an error.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (resultHasError) {
            handleResponses = false;
            MCDError error = null;
            this.logger.debug("Result has error.");
            try {
                error = pResult.getError();
            }
            catch (Exception e) {
                this.logger.debug("Error getting error from result.");
                this.logger.logThrowable(e);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (error.getCode() == 53327 && error.getVendorCode() == 20) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && (error.getVendorCode() == 17 || error.getVendorCode() == 25 || error.getVendorCode() == 26 || error.getVendorCode() == 42 || error.getVendorCode() == 47)) {
                this.logger.warn("Wrong battery voltage detected - probably due to an interruption of clamp 30 or 15!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.WRONG_UBATT_DETECTED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 27) {
                this.logger.warn("EDIC interface deadlock error detected - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 16 || error.getCode() == 53315 && error.getVendorCode() == 16) {
                this.logger.warn("Command refused by EDIC interface - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 58644 || error.getCode() == 53327 && (this.isPduApiUsed && error.getCode() == 262 || !this.isPduApiUsed && error.getCode() == 13)) {
                this.logger.warn("Communication to VCI lost (possibly due to voltage drop) - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_TO_VCI_LOST_OR_DISTURBED;
            } else if (VendorSpecific.getServerVendor().equals(DServerVendor.SOFTING) && error.getCode() == 49192 || VendorSpecific.getServerVendor().equals(DServerVendor.DSA) && error.getCode() == 58649 || VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && error.getCode() == 53315 && error.getVendorCode() == 12378) {
                this.logger.warn("Interpretation errors occurred anywhere in the result... continuing result evaluation anyway.");
                this.logger.logMcdError(error);
                handleResponses = true;
            } else {
                this.logger.logMcdError(error);
            }
            if (!this.isPduApiUsed) {
                this.logger.debug("Restarting communication after timeout.");
                this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.stopCommunication, 1, false);
                this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.startCommunication, 1, false);
            }
        }
        if (handleResponses) {
            String serviceShortName = null;
            int resultType = -1;
            MCDResponses responses = null;
            try {
                serviceShortName = pResult.getServiceShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining service SHORT-NAME of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result for service: " + serviceShortName);
            try {
                resultType = pResult.getType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining type of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
            if (resultType == 1793) {
                this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
            } else {
                try {
                    responses = pResult.getResponses();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting responses from result.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                currentJobStatus = this.handleResponses(pDiagComPrimitive, pDiagComPrimitiveType, serviceShortName, requestParameters, responses);
                this.logger.debug("job status after handleResponses(): " + currentJobStatus);
            }
        }
        this.logger.trace("Leaving handleResult(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus handleResponses(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponses pResponses) {
        AbstractJob.JobStatus currentJobStatus = null;
        long responseCount = 0L;
        MCDResponse response = null;
        AbstractJob.JobStatus currentStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handleResponses(...).");
        try {
            responseCount = pResponses.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of responses.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of responses: " + responseCount);
        currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
        for (long i = 0L; i < responseCount; ++i) {
            try {
                response = pResponses.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            currentStatus = this.handleResponse(pDiagComPrimitive, pDiagComPrimitiveType, pServiceShortName, pRequestParameters, response);
            if (this.responseLocationAccessKey.equals(this.dbLocationAccessKey) || this.responseLocationAccessKey.equals(this.dbLocationAccessKeyBaseVariant)) {
                currentJobStatus = currentStatus;
                continue;
            }
            this.logger.debug("dbLocation of response    : " + this.responseLocationAccessKey);
            this.logger.debug("dbLocation of BASE-VARIANT: " + this.dbLocationAccessKeyBaseVariant);
            this.logger.debug("dbLocation of LOGICAL-LINK: " + this.dbLocationAccessKey);
        }
        this.logger.trace("Leaving handleResponses(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus handleResponse(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDAccessKey accessKeyOfLocation = null;
        int responseState = -1;
        this.logger.trace("Entering handleResponse(...).");
        try {
            accessKeyOfLocation = pResponse.getAccessKeyOfLocation();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining access key of response location.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (accessKeyOfLocation == null) {
            this.logger.debug("MCDResponse.getAccessKeyOfLocation() returned null!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            this.responseLocationAccessKey = accessKeyOfLocation.getString();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting string for access key of response location.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("DbLocation of response: " + this.responseLocationAccessKey);
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting response message by getValueAsString().");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1200: {
                break;
            }
            case 1192: 
            case 1197: {
                break;
            }
        }
        try {
            responseState = pResponse.getState();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining response state.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (responseState) {
            case 26625: {
                currentJobStatus = this.handlePositiveResponse(pDiagComPrimitive, pDiagComPrimitiveType, pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 26626: {
                currentJobStatus = this.handleNegativeResponse(pRequestParameters, pResponse);
                break;
            }
            default: {
                this.logger.error("Invalid MCDResponseState: " + responseState);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handleResponse(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus handlePositiveResponse(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveResponse(...).");
        this.logger.debug("Response is positive.");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                currentJobStatus = this.handlePositiveServiceResponse((MCDService)pDiagComPrimitive, pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 1192: 
            case 1197: {
                currentJobStatus = this.handlePositiveJobResponse((MCDJob)pDiagComPrimitive, pServiceShortName, pResponse);
                break;
            }
            case 1200: {
                currentJobStatus = this.handlePositiveJobResponse((MCDJob)pDiagComPrimitive, pServiceShortName, pResponse);
                break;
            }
        }
        this.logger.trace("Leaving handlePositiveResponse(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus handlePositiveJobResponse(MCDJob pJob, String pJobShortName, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveJobResponse(...).");
        this.logger.debug("*** UNKNOWN job ***: " + pJobShortName);
        currentJobStatus = AbstractJob.JobStatus.ERROR;
        this.logger.trace("Leaving handlePositiveJobResponse(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus handlePositiveServiceResponse(MCDService pService, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDDbDataPrimitive dbDataPrimitive = null;
        byte[] responseMessage = null;
        MCDResponseParameters responseParameters = null;
        byte responseServiceIdentifier = 0;
        this.logger.trace("Entering handlePositiveServiceResponse(...).");
        try {
            dbDataPrimitive = (MCDDbDataPrimitive)pService.getDbObject();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting database object of the service with the SHORT-NAME " + pServiceShortName + ".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.ERROR;
        }
        if (dbDataPrimitive == null) {
            this.logger.error("MCDService.getDbObject() returned null!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length < 1) {
            this.logger.error("Error getting response service id from response with length of " + responseMessage.length + " bytes.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        responseServiceIdentifier = responseMessage[0];
        if ((responseServiceIdentifier & 0x40 & 0xFF) == 0) {
            this.logger.error("The extracted response service id (0x" + Integer.toHexString(responseServiceIdentifier & 0xFF).toUpperCase() + ") is not a positive response service identifier!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Storing response parameters for data primitive: " + pServiceShortName);
        this.readResponseParameters.put(pServiceShortName, responseParameters);
        this.logger.trace("Leaving handlePositiveServiceResponse(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus evaluateResponseParameters(String pDbDataPrimitiveShortName, MCDResponseParameters pResponseParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        this.logger.trace("Entering evaluateResponseParameters(...).");
        try {
            numberOfResponseParameters = pResponseParameters.getCount();
            this.logger.debug("Found " + numberOfResponseParameters + " response parameters.");
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.error("Ignoring response since it is not covered by a database response.");
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.error("Ignoring response since it is not covered by a database response.");
            return AbstractJob.JobStatus.ERROR;
        }
        if (numberOfResponseParameters > Integer.MAX_VALUE) {
            this.logger.fatal("Found " + numberOfResponseParameters + " response parameters. Only " + Integer.MAX_VALUE + " are supported.");
            return AbstractJob.JobStatus.ERROR;
        }
        for (int i = 0; i < (int)numberOfResponseParameters && currentJobStatus == AbstractJob.JobStatus.NO_ERROR; ++i) {
            currentJobStatus = this.evaluateResponseParameterByIndex(pDbDataPrimitiveShortName, pResponseParameters, i);
        }
        this.logger.trace("Leaving evaluateResponseParameters(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus evaluateResponseParameterByIndex(String pDbDataPrimitiveShortName, MCDResponseParameters pResponseParameters, long pIndex) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResponseParameter responseParameter = null;
        String responseParameterShortName = null;
        String value = null;
        HashMap readValuesOfCurrentDataPrimitive = null;
        this.logger.trace("Entering evaluateResponseParameterByIndex(...).");
        try {
            responseParameter = pResponseParameters.getItemByIndex(pIndex);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting response parameter with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.ERROR;
        }
        if (responseParameter == null) {
            this.logger.error("MCDResponseParameters.getItemByIndex() returned null!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            responseParameterShortName = this.getExpectedDbResponseParameterShortNameByResponseParameter(pDbDataPrimitiveShortName, responseParameter);
            this.logger.debug("SHORT-NAME of response parameter: " + responseParameterShortName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining SHORT-NAME of response parameter with index " + pIndex + ".");
            return AbstractJob.JobStatus.ERROR;
        }
        if (responseParameterShortName != null) {
            value = this.getResponseParameterValue(responseParameter);
            if (value == null) {
                this.logger.error("Error getting value of response parameter with index " + pIndex + ".");
                return AbstractJob.JobStatus.ERROR;
            }
            this.logger.debug("The response parameter with the SHORT-NAME \"" + responseParameterShortName + "\" has the value: \"" + value + "\"");
            readValuesOfCurrentDataPrimitive = (HashMap)this.readValues.get(pDbDataPrimitiveShortName);
            this.logger.debug("Storing value " + value + " for response parameter " + responseParameterShortName);
            readValuesOfCurrentDataPrimitive.put(responseParameterShortName, value);
            this.logger.debug("Map contains " + readValuesOfCurrentDataPrimitive.size() + " values.");
            this.logger.debug("Map of read values contains " + this.readValues.size() + " maps.");
        }
        this.logger.trace("Leaving evaluateResponseParameterByIndex(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus evaluateProgrammingStateOfLogicalSoftwareBlocks(String pDataPrimitiveShortName) {
        this.logger.trace("Entering evaluateProgrammingStateOfLogicalSoftwareBlocks(...).");
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResponseParameters responseParameters = null;
        MCDResponseParameter dataRecord = null;
        MCDResponseParameters wrapperStructure = null;
        long numberOfWrappedParameters = 0L;
        MCDResponseParameters wrappedStructure = null;
        long numberOfFingerPrints = 0L;
        boolean programmingStateHasError = false;
        MCDError error = null;
        if (!this.readResponseParameters.containsKey(pDataPrimitiveShortName)) {
            this.logger.debug("Error determining database object of data primitive.");
            return AbstractJob.JobStatus.ERROR;
        }
        responseParameters = (MCDResponseParameters)this.readResponseParameters.get(pDataPrimitiveShortName);
        try {
            dataRecord = responseParameters.getItemByName("Param_DataRecor");
        }
        catch (MCDException mcde) {
            this.logger.debug("TODO.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            wrapperStructure = dataRecord.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.debug("TODO.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            numberOfWrappedParameters = wrapperStructure.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("TODO.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of wrapped parameters: " + numberOfWrappedParameters);
        if (numberOfWrappedParameters != 1L) {
            wrappedStructure = wrapperStructure;
        } else {
            try {
                wrappedStructure = wrapperStructure.getItemByIndex(0L).getType() == 17 ? wrapperStructure.getItemByIndex(0L).getParameters() : wrapperStructure;
            }
            catch (MCDException mcde) {
                this.logger.debug("TODO.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        try {
            numberOfFingerPrints = wrappedStructure.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("TODO.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Got " + numberOfFingerPrints + " fingerprints and programming states.");
        MCDResponseParameter fingerprintAndProgrammingState = null;
        String paramShortName = null;
        int i = 0;
        while ((long)i < numberOfFingerPrints) {
            try {
                fingerprintAndProgrammingState = wrappedStructure.getItemByIndex((long)i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting fingerprint and programming state for index: " + i);
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                paramShortName = fingerprintAndProgrammingState.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting parameter name of fingerprint and programming state for index: " + i);
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            MCDResponseParameters fingerprintAndProgrammingStateParameters = null;
            try {
                fingerprintAndProgrammingStateParameters = fingerprintAndProgrammingState.getParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting fingerprint and programming state parameters for: " + paramShortName);
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            MCDResponseParameter respParam_programmingState = null;
            try {
                respParam_programmingState = fingerprintAndProgrammingStateParameters.getItemByName("Param_ProgrState");
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting programming state for: " + paramShortName);
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                programmingStateHasError = respParam_programmingState.hasError();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining if " + paramShortName + "has errors!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            int dataBlockNumber = MCD3_CheckOwnIdent.getDataBlockNumberFromParamShortName(paramShortName);
            if (programmingStateHasError) {
                this.logger.error("Programming state of " + paramShortName + " has error!");
                error = respParam_programmingState.getError();
                this.logger.logMcdError(error);
                this.logger.warn("Assuming programming state of DATABLOCK " + dataBlockNumber + " to be invalid!");
            } else {
                String programmingState = null;
                programmingState = this.getResponseParameterValue(respParam_programmingState);
                if (programmingState != null) {
                    this.logger.debug("Programming state of " + paramShortName + ": " + programmingState);
                    if (programmingState.equals("Correct Result") && dataBlockNumber != -1) {
                        this.logger.debug("Adding DATABLOCK " + dataBlockNumber + " to the set of valid logical software blocks.");
                        this.validLogicalSoftwareBlockNumbers.add(new Integer(dataBlockNumber));
                    }
                }
            }
            ++i;
        }
        this.logger.trace("Leaving evaluateProgrammingStateOfLogicalSoftwareBlocks(...).");
        return currentJobStatus;
    }

    private String getExpectedDbResponseParameterShortNameByResponseParameter(String pDbDataPrimitiveShortName, MCDResponseParameter pResponseParameter) throws MCDException, NullPointerException {
        Set expectedDbParameters = null;
        String responseParameterShortName = null;
        this.logger.trace("Entering getExpectedDbResponseParameterShortNameByResponseParameter(...).");
        if (!this.dbOwnIdentResponseParametersOfDiagComms.containsKey(pDbDataPrimitiveShortName)) {
            this.logger.debug("No response parameters of the data primitive " + pDbDataPrimitiveShortName + " are expected.");
            return null;
        }
        expectedDbParameters = (Set)this.dbOwnIdentResponseParametersOfDiagComms.get(pDbDataPrimitiveShortName);
        try {
            responseParameterShortName = pResponseParameter.getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of response parameter.");
            this.logger.logThrowable(mcde);
            throw mcde;
        }
        if (responseParameterShortName == null) {
            this.logger.error("MCDResponseParameter.getShortName() returned null!");
            throw new NullPointerException("MCDResponseParameter.getShortName() returned null!");
        }
        if (expectedDbParameters.contains(responseParameterShortName)) {
            this.logger.debug("The response parameter " + responseParameterShortName + " of the data primitive " + pDbDataPrimitiveShortName + " is expected.");
            return responseParameterShortName;
        }
        this.logger.debug("The response parameter " + responseParameterShortName + " of the data primitive " + pDbDataPrimitiveShortName + " is not expected.");
        this.logger.trace("Leaving getExpectedDbResponseParameterShortNameByResponseParameter(...).");
        return null;
    }

    private String getResponseParameterValue(MCDResponseParameter pResponseParameter) {
        MCDValue mcdValue = null;
        String value = null;
        this.logger.trace("Entering getResponseParameterValue(...).");
        try {
            mcdValue = pResponseParameter.getValue();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCD value of response parameter.");
            this.logger.logThrowable(mcde);
            return null;
        }
        if (mcdValue == null) {
            this.logger.error("MCDResponseParameter.getValue() returned null!");
            return null;
        }
        try {
            value = mcdValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting value of response parameter.");
            this.logger.logThrowable(mcde);
            return null;
        }
        if (value == null) {
            this.logger.error("MCDValue.getValueAsString() returned null!");
            return null;
        }
        this.logger.trace("Leaving getResponseParameterValue(...).");
        return value;
    }

    private boolean checkOwnIdents(MCDDbFlashDataBlock pDbFlashDataBlock) {
        HashSet ownIdentsOfCurrentDataBlock = null;
        Iterator ownIdentIterator = null;
        MCDDbFlashIdent dbOwnIdent = null;
        this.logger.trace("Entering checkOwnIdents(...).");
        if (!this.dbOwnIdents.containsKey(pDbFlashDataBlock)) {
            return false;
        }
        ownIdentsOfCurrentDataBlock = (HashSet)this.dbOwnIdents.get(pDbFlashDataBlock);
        if (ownIdentsOfCurrentDataBlock == null) {
            return false;
        }
        ownIdentIterator = ownIdentsOfCurrentDataBlock.iterator();
        while (ownIdentIterator.hasNext()) {
            dbOwnIdent = (MCDDbFlashIdent)ownIdentIterator.next();
            if (this.checkOwnIdent(dbOwnIdent)) continue;
            return false;
        }
        this.logger.trace("Leaving checkOwnIdents(...).");
        return true;
    }

    private boolean checkOwnIdent(MCDDbFlashIdent pDbOwnIdent) {
        String dbDataPrimitiveShortName = null;
        String dbResponseParameterShortName = null;
        Map readValuesOfDataPrimitive = null;
        String readValue = null;
        String expectedValue = null;
        this.logger.trace("Entering checkOwnIdent(...).");
        this.logger.debug("Checking OWN-IDENT: " + (String)this.dbOwnIdentShortNames.get(pDbOwnIdent));
        if (!this.dbOwnIdentDiagComms.containsKey(pDbOwnIdent)) {
            this.logger.debug("No data primitives were found for OWN-IDENT: " + (String)this.dbOwnIdentShortNames.get(pDbOwnIdent));
            return false;
        }
        if (!this.dbOwnIdentResponseParameters.containsKey(pDbOwnIdent)) {
            this.logger.debug("No response parameters were found for OWN-IDENT: " + (String)this.dbOwnIdentShortNames.get(pDbOwnIdent));
            return false;
        }
        dbDataPrimitiveShortName = (String)this.dbOwnIdentDiagComms.get(pDbOwnIdent);
        dbResponseParameterShortName = (String)this.dbOwnIdentResponseParameters.get(pDbOwnIdent);
        this.logger.debug("dbResponseParameterShortName: " + dbResponseParameterShortName);
        if (!this.identValues.containsKey(pDbOwnIdent)) {
            this.logger.debug("No expected value was found for OWN-IDENT: " + (String)this.dbOwnIdentShortNames.get(pDbOwnIdent));
            return false;
        }
        expectedValue = (String)this.identValues.get(pDbOwnIdent);
        if (!this.readValues.containsKey(dbDataPrimitiveShortName)) {
            this.logger.debug("No read values were found for the data primitive of the OWN-IDENT: " + (String)this.dbOwnIdentShortNames.get(pDbOwnIdent));
            return false;
        }
        readValuesOfDataPrimitive = (Map)this.readValues.get(dbDataPrimitiveShortName);
        if (!readValuesOfDataPrimitive.containsKey(dbResponseParameterShortName)) {
            this.logger.debug("No read values were found for the response parameter " + dbResponseParameterShortName + " of the OWN-IDENT: " + (String)this.dbOwnIdentShortNames.get(pDbOwnIdent));
            return false;
        }
        readValue = (String)readValuesOfDataPrimitive.get(dbResponseParameterShortName);
        this.logger.debug("Comparing read value with expected value.");
        this.logger.debug("read value: \"" + readValue + "\"");
        this.logger.debug("expected value: \"" + expectedValue + "\"");
        if (dbDataPrimitiveShortName.equals("DiagnServi_ReadDataByIdentVWLogicSoftwBlockVersi") && readValue.equals(VW_LOGICAL_SOFTWARE_VERSION_OF_NON_UPDATEABLE_DATA_BLOCKS)) {
            this.logger.debug("Read value '" + readValue + "' matches special VW Logical Software Block Version for non-updateable data blocks.");
            return true;
        }
        if (readValue.equals(expectedValue)) {
            this.logger.debug("\"" + readValue + "\" matches \"" + expectedValue + "\".");
            return true;
        }
        this.logger.debug("\"" + readValue + "\" does NOT match \"" + expectedValue + "\".");
        this.logger.trace("Leaving checkOwnIdent(...).");
        return false;
    }

    private AbstractJob.JobStatus handleNegativeResponse(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte requestServiceIdentifierRequest = 0;
        byte requestServiceIdentifierResponse = 0;
        String negativeResponseCode = null;
        byte nrc = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        this.logger.trace("Entering handleNegativeResponse(...).");
        this.logger.debug("Response is negative.");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length == 3) {
            long i;
            block29: {
                try {
                    for (i = 0L; i < pRequestParameters.getCount(); ++i) {
                        if (!pRequestParameters.getItemByIndex(i).getShortName().endsWith("RequeServiId")) continue;
                        requestServiceIdentifierRequest = (byte)pRequestParameters.getItemByIndex(i).getValue().getUint32();
                        break;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting request service identifier from request.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    responseParameters = pResponse.getResponseParameters();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting response parameters from response!");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                    this.logger.debug("Number of response parameters: " + numberOfResponseParameters);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (numberOfResponseParameters < 4L) {
                    requestServiceIdentifierResponse = requestServiceIdentifierRequest;
                } else {
                    try {
                        this.logger.debug("Datatype of request SID: " + McdEnumDecoder.decodeMcdDataType(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getDataType()));
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 3) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getBytefield()[0] & 0xFF);
                            break block29;
                        }
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 14 || responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 1) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseMessage().getBytefield()[1] & 0xFF);
                            break block29;
                        }
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        requestServiceIdentifierResponse = 0;
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        this.logger.logThrowable(mcde);
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                }
            }
            try {
                for (i = 0L; i < numberOfResponseParameters; ++i) {
                    if (!responseParameters.getItemByIndex(i).getShortName().equals("Param_NegatRespoCode")) continue;
                    negativeResponseCode = responseParameters.getItemByIndex(i).getValue().getValueAsString();
                    break;
                }
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code (Param_NegatRespoCode) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                nrc = pResponse.getResponseMessage().getBytefield()[2];
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code (byte 2) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("- Service ID: 0x" + Integer.toHexString(requestServiceIdentifierResponse).toUpperCase());
            this.logger.debug("- NRC       : 0x" + Integer.toHexString(nrc).toUpperCase() + " (" + negativeResponseCode + ")");
            if (requestServiceIdentifierResponse != requestServiceIdentifierRequest) {
                this.logger.error("Request service identifier of response does NOT match request: 0x" + Integer.toHexString(requestServiceIdentifierRequest) + " / " + Integer.toHexString(requestServiceIdentifierResponse));
            }
        } else {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (responseMessage.length < 3) {
                this.logger.debug("Negative response has invalid length of " + responseMessage.length + " bytes: " + responseMessageString);
            } else if (responseMessage.length > 3) {
                this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
            }
        }
        currentJobStatus = AbstractJob.JobStatus.NEGATIVE_RESPONSE;
        this.logger.trace("Leaving handleNegativeResponse(...).");
        return currentJobStatus;
    }

    private AbstractJob.JobStatus handleErrors(MCDErrors pErrors) {
        long numberOfErrors = 0L;
        MCDError error = null;
        this.logger.trace("Entering handleErrors(...).");
        try {
            numberOfErrors = pErrors.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of errors.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (long i = 0L; i < numberOfErrors; ++i) {
            try {
                error = pErrors.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting error with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.logMcdError(error);
        }
        this.logger.trace("Leaving handleErrors(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    private long getProtocolParameterUint32(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        long value = -1L;
        this.logger.trace("Entering getProtocolParameterUint32(...).");
        try {
            value = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName).getUint32();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UINT32 value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterUint32(...).");
        return value;
    }

    private MCDValue getProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        MCDValue comParamValue = null;
        this.logger.trace("Entering getProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error fetching protocol parameters from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName).getValue();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterValue(...).");
        return comParamValue;
    }

    private MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, long pValue) {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        long currentValue = -1L;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            currentValue = comParamValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setUint32(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching new protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    private static final int getDataBlockNumberFromDataBlockShortName(String pDataBlockShortName) {
        int dataBlockNumberAsInt = -1;
        String dataBlockNumber = pDataBlockShortName.toString();
        if (dataBlockNumber.startsWith("DB_")) {
            dataBlockNumber = dataBlockNumber.substring(3);
        }
        if (dataBlockNumber.endsWith("ERASEPROGRROUTI")) {
            dataBlockNumber = dataBlockNumber.substring(0, dataBlockNumber.indexOf("ERASEPROGRROUTI"));
        }
        if (dataBlockNumber.endsWith("ERASEROUTI")) {
            dataBlockNumber = dataBlockNumber.substring(0, dataBlockNumber.indexOf("ERASEROUTI"));
        }
        if (dataBlockNumber.endsWith("PROGRROUTI")) {
            dataBlockNumber = dataBlockNumber.substring(0, dataBlockNumber.indexOf("PROGRROUTI"));
        }
        if (dataBlockNumber.endsWith("FLASHDATA")) {
            dataBlockNumber = dataBlockNumber.substring(0, dataBlockNumber.indexOf("FLASHDATA"));
        }
        if (dataBlockNumber.endsWith("DATA")) {
            dataBlockNumber = dataBlockNumber.substring(0, dataBlockNumber.indexOf("DATA"));
        }
        if (dataBlockNumber.endsWith("DRIVER")) {
            dataBlockNumber = dataBlockNumber.substring(0, dataBlockNumber.indexOf("DRIVER"));
        }
        if (dataBlockNumber.endsWith("ERASE")) {
            dataBlockNumber = dataBlockNumber.substring(0, dataBlockNumber.indexOf("ERASE"));
        }
        try {
            dataBlockNumberAsInt = Integer.parseInt(dataBlockNumber, 16);
        }
        catch (NumberFormatException nfe) {
            dataBlockNumberAsInt = -1;
        }
        return dataBlockNumberAsInt;
    }

    private static final int getDataBlockNumberFromParamShortName(String pParameterShortName) {
        int dataBlockNumberAsInt = -1;
        String dataBlockNumber = pParameterShortName.toString();
        if (dataBlockNumber.startsWith("Param_")) {
            dataBlockNumber = dataBlockNumber.substring("Param_".length());
        }
        if (dataBlockNumber.startsWith("Data")) {
            dataBlockNumber = dataBlockNumber.substring("Data".length());
        }
        if (dataBlockNumber.startsWith("Block")) {
            dataBlockNumber = dataBlockNumber.substring("Block".length());
        }
        try {
            dataBlockNumberAsInt = Integer.parseInt(dataBlockNumber, 16);
        }
        catch (NumberFormatException nfe) {
            dataBlockNumberAsInt = -1;
        }
        return dataBlockNumberAsInt;
    }

    private boolean isUpdateNecessary() {
        String currentDbFlashDataBlockShortName = null;
        MCDDbFlashDataBlock currentDbFlashDataBlock = null;
        String currentDbFlashDataBlockType = null;
        long numberOfDriverBlocks = 0L;
        long numberOfEraseBlocks = 0L;
        long numberOfDataBlocks = 0L;
        long numberOfEraseProgrammingRoutineBlocks = 0L;
        long numberOfEraseRoutineBlocks = 0L;
        long numberOfProgrammingRoutineBlocks = 0L;
        long numberOfFlashDataBlocks = 0L;
        this.logger.debug("The following " + this.programmableDbFlashDataBlockNames.size() + " data blocks are outdated:");
        Iterator programmableFlashDataBlockIterator = this.programmableDbFlashDataBlockNames.iterator();
        while (programmableFlashDataBlockIterator.hasNext()) {
            currentDbFlashDataBlockShortName = (String)programmableFlashDataBlockIterator.next();
            currentDbFlashDataBlock = (MCDDbFlashDataBlock)this.programmableDbFlashDataBlockShortNames.get(currentDbFlashDataBlockShortName);
            currentDbFlashDataBlockType = (String)this.programmableDbFlashDataBlockTypes.get(currentDbFlashDataBlock);
            if (currentDbFlashDataBlockType.equals("DRIVER")) {
                ++numberOfDriverBlocks;
            } else if (currentDbFlashDataBlockType.equals("ERASE")) {
                ++numberOfEraseBlocks;
            } else if (currentDbFlashDataBlockType.equals("DATA")) {
                ++numberOfDataBlocks;
            } else if (currentDbFlashDataBlockType.equals("ERASE_PROGRAMMING_ROUTINE")) {
                ++numberOfEraseProgrammingRoutineBlocks;
            } else if (currentDbFlashDataBlockType.equals("ERASE_ROUTINE")) {
                ++numberOfEraseRoutineBlocks;
            } else if (currentDbFlashDataBlockType.equals("PROGRAMMING_ROUTINE")) {
                ++numberOfProgrammingRoutineBlocks;
            } else if (currentDbFlashDataBlockType.equals("FLASH_DATA")) {
                ++numberOfFlashDataBlocks;
            }
            this.logger.debug("- [" + currentDbFlashDataBlockType + "] " + currentDbFlashDataBlockShortName);
        }
        if (numberOfDriverBlocks + numberOfEraseBlocks + numberOfDataBlocks > 0L) {
            this.logMessage = numberOfDriverBlocks + " " + "DRIVER" + " blocks, ";
            this.logMessage = this.logMessage + numberOfEraseBlocks + " " + "ERASE" + " blocks, and ";
            this.logMessage = this.logMessage + numberOfDataBlocks + " " + "DATA" + " blocks are outdated.";
            this.logger.debug(this.logMessage);
        } else if (numberOfEraseProgrammingRoutineBlocks + numberOfEraseRoutineBlocks + numberOfProgrammingRoutineBlocks + numberOfFlashDataBlocks > 0L) {
            this.logMessage = numberOfEraseProgrammingRoutineBlocks + " " + "ERASE_PROGRAMMING_ROUTINE" + " blocks, ";
            this.logMessage = this.logMessage + numberOfEraseRoutineBlocks + " " + "ERASE_ROUTINE" + " blocks, ";
            this.logMessage = this.logMessage + numberOfProgrammingRoutineBlocks + " " + "PROGRAMMING_ROUTINE" + " blocks, and ";
            this.logMessage = this.logMessage + numberOfFlashDataBlocks + " " + "FLASH_DATA" + " blocks are outdated.";
            this.logger.debug(this.logMessage);
        } else {
            this.logger.debug("NO data blocks are outdated.");
        }
        if (numberOfDataBlocks == 0L) {
            if (numberOfEraseBlocks != 0L) {
                this.logger.error("Downloading " + numberOfEraseBlocks + " " + "ERASE" + " blocks but 0 " + "DATA" + " blocks would probably render the ECU unusable.");
                this.logger.error("Partial Programming will be disabled for security reasons!");
                this.programmableDbFlashDataBlockNames.clear();
                this.programmableDbFlashDataBlockNames.addAll(this.programmableDbFlashDataBlockShortNames.keySet());
                this.jobStatus = AbstractJob.JobStatus.INCONSISTENT_OWN_IDENTS;
                this.jobCompletionStatus = "Job completed with errors";
                return true;
            }
            if (numberOfFlashDataBlocks == 0L) {
                return false;
            }
        }
        return true;
    }

    private MCDResponseParameter getLastResponseParameterOfFieldByName(MCDResponseParameter pResponseParameter, String pShortName) throws MCDException {
        long numberFieldElements = 0L;
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter responseParameter = null;
        MCDResponseParameter currentResponseParameter = null;
        String responseParameterName = null;
        this.logger.trace("Entering getLastResponseParameterOfFieldByName()...");
        try {
            fieldElements = pResponseParameter.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting elements of field.");
            throw mcde;
        }
        try {
            numberFieldElements = fieldElements.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting number of response parameters in field.");
            throw mcde;
        }
        int i = 0;
        while ((long)i < numberFieldElements) {
            block12: {
                try {
                    currentResponseParameter = fieldElements.getItemByIndex((long)i);
                    if (currentResponseParameter.getType() == 17) {
                        responseParameter = fieldElements.getItemByIndex(numberFieldElements - 1L).getParameters().getItemByName(pShortName);
                        break block12;
                    }
                    try {
                        responseParameterName = currentResponseParameter.getShortName();
                        if (responseParameterName.startsWith("#RtGen_")) {
                            responseParameterName = responseParameterName.replaceFirst("#RtGen_", "");
                            responseParameterName = responseParameterName.substring(0, responseParameterName.lastIndexOf("_"));
                        }
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error getting SHORT-NAME of response parameter with index " + i + ".");
                        throw mcde;
                    }
                    if (responseParameterName != null && responseParameterName.equals(pShortName)) {
                        responseParameter = currentResponseParameter;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting response parameter with index " + i + " from field.");
                    throw mcde;
                }
            }
            ++i;
        }
        this.logger.trace("Leaving getLastResponseParameterOfFieldByName()...");
        return responseParameter;
    }

    public static final class JobStep
    implements Comparable {
        public static final JobStep READ_DATA_BLOCKS = new JobStep("READ_DATA_BLOCKS");
        public static final JobStep CHECK_FOR_ZERO_DATA_BLOCKS = new JobStep("CHECK_FOR_ZERO_DATA_BLOCKS");
        public static final JobStep READ_FLASH_SESSION_NAME = new JobStep("READ_FLASH_SESSION_NAME");
        public static final JobStep EVALUATE_PROGRAMMING_STATE_OF_LOGICAL_SOFTWARE_BLOCKS = new JobStep("EVALUATE_PROGRAMMING_STATE_OF_LOGICAL_SOFTWARE_BLOCKS");
        public static final JobStep READ_OWN_IDENTS = new JobStep("READ_OWN_IDENTS");
        public static final JobStep EXECUTE_DATA_PRIMITIVES = new JobStep("EXECUTE_DATA_PRIMITIVES");
        public static final JobStep EVALUATE_RESPONSE_PARAMETERS = new JobStep("EVALUATE_RESPONSE_PARAMETERS");
        public static final JobStep CHECK_OWN_IDENTS = new JobStep("CHECK_OWN_IDENTS");
        public static final JobStep RESET_REPEAT_REQUEST_COUNTER_APP = new JobStep("RESET_REPEAT_REQUEST_COUNTER_APP");
        public static final JobStep CHECK_FOR_LEFT_DATA_BLOCKS_IGNORING_DRIVERS = new JobStep("CHECK_FOR_LEFT_DATA_BLOCKS_IGNORING_DRIVERS");
        public static final JobStep DONE = new JobStep("DONE");
        private static int nextOrdinal = 0;
        static final JobStep[] values = new JobStep[]{READ_DATA_BLOCKS, CHECK_FOR_ZERO_DATA_BLOCKS, READ_FLASH_SESSION_NAME, EVALUATE_PROGRAMMING_STATE_OF_LOGICAL_SOFTWARE_BLOCKS, READ_OWN_IDENTS, EXECUTE_DATA_PRIMITIVES, EVALUATE_RESPONSE_PARAMETERS, CHECK_OWN_IDENTS, RESET_REPEAT_REQUEST_COUNTER_APP, CHECK_FOR_LEFT_DATA_BLOCKS_IGNORING_DRIVERS, DONE};
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
        private final int ordinal = nextOrdinal++;
        private final String name;

        private JobStep(String pName) {
            this.name = pName;
        }

        public static final JobStep valueOf(String pName) throws IllegalArgumentException {
            JobStep jobStep = null;
            Iterator jobStepIterator = VALUES.iterator();
            while (jobStepIterator.hasNext()) {
                jobStep = (JobStep)jobStepIterator.next();
                if (!pName.equals(jobStep.toString())) continue;
                return jobStep;
            }
            throw new IllegalArgumentException("Cannot parse '" + pName + "' into an element of JobStep!");
        }

        public final int compareTo(Object pObject) {
            return this.ordinal - ((JobStep)pObject).ordinal;
        }

        public final boolean equals(Object pObject) {
            return super.equals(pObject);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final int intValue() {
            return this.ordinal;
        }

        public final String toString() {
            return this.name;
        }
    }
}

