/*
 * Decompiled with CFR 0.152.
 */
package com.elektrobit.automotive.mcd.joblibrary.audi.uds.jobs.mcd201;

import asam.d.MCDAccessKey;
import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDataPrimitives;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDErrors;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDProtocolParameterSet;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDService;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDStartCommunication;
import asam.d.MCDStopCommunication;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary2.jobs.AbstractJob;
import com.audi.mcd.joblibrary2.jobs.impl.AbstractSingleEcuJobImpl;
import com.audi.mcd.joblibrary2.util.Conversions;
import com.audi.mcd.joblibrary2.util.McdEnumDecoder;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MCD3_SecurAcces
extends AbstractSingleEcuJobImpl {
    private static final String REVISION = "1.1.20141002";
    protected static final int SEED_KEY_LENGTH = 4;
    private static int instances;
    private static int nextInstance;
    protected static String[] REQUIRED_DIAG_COMMS;
    protected int instance;
    protected String jobCompletionStatus = null;
    protected String jobMessage = null;
    protected String securityMethod = null;
    protected long securityCode = 0L;
    protected byte[] securityAlgorithm = null;
    protected byte[] securitySeed = null;
    protected byte[] securityKey = null;
    protected int instructionPointer = 0;
    protected long carryFlag = 0L;
    protected MCDProtocolParameterSet protocolParameterSet = null;
    private MCDRequestParameters protocolParameters = null;
    protected long savedNumberOfErrorRepetitions = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCD3_SecurAcces() {
        super(REVISION);
        Class clazz = MCD3_SecurAcces.class;
        synchronized (clazz) {
            this.instance = nextInstance++;
            ++instances;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MCD3_SecurAcces(String pRevision) {
        super(pRevision);
        Class clazz = MCD3_SecurAcces.class;
        synchronized (clazz) {
            this.instance = nextInstance++;
            ++instances;
        }
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        this.logger.trace("Entering execute(...).");
        this.jobStatus = this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, pJob);
        if (this.jobStatus == AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS) {
            throw new NullPointerException("At least one of the call parameters of the job is null!");
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("prepareJob successful - executing job logic...");
            this.jobCompletionStatus = this.executeJobLogicGuarded();
        }
        this.finalizeJobGuarded();
        this.logger.trace("Leaving execute(...).");
    }

    protected AbstractJob.JobStatus prepareJobGuarded(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        try {
            currentJobStatus = this.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pJob);
        }
        catch (Exception e) {
            this.logger.debug("Caught exception in prepareJob() method.");
            this.logger.logThrowable(e);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught throwable in prepareJob() method.");
            this.logger.logThrowable(t);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareJob(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pJob) {
        this.jobStatus = super.prepareJob(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pJob);
        this.jobCompletionStatus = "Job aborted due to fatal errors";
        this.jobMessage = "SecurityAccess failed";
        this.jobStatus = AbstractJob.JobStatus.ERROR;
        this.jobStatus = this.readInputParameters(pRequestParameters);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.jobStatus = this.checkRequiredDiagComms(REQUIRED_DIAG_COMMS);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.logger.debug("Preparing protocol parameter set.");
        this.jobStatus = this.prepareProtocolParameterSet();
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        if (!this.isPduApiUsed) {
            this.logger.debug("Preparing global control primitives.");
            try {
                this.stopCommunication = this.stopCommunication(this.logicalLink);
                this.startCommunication = this.startCommunication(this.logicalLink);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating MCDStop/StartCommunication.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        Thread.currentThread().setPriority(10);
        this.logger.trace("Leaving prepareJob(...).");
        return this.jobStatus;
    }

    protected String executeJobLogicGuarded() {
        String currentJobCompletionStatus = null;
        try {
            currentJobCompletionStatus = this.executeJobLogic();
        }
        catch (MCDException mcde) {
            this.logger.debug("Caught MCDException in executeJobLogic() method.");
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in executeJobLogic() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in executeJobLogic() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        return currentJobCompletionStatus;
    }

    protected String executeJobLogic() throws MCDException {
        MCDService diagComPrimitive = null;
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        JobStep currentJobStep = JobStep.values[0];
        while (currentJobStep.compareTo(JobStep.DONE) < 0 && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            if (currentJobStep == JobStep.SECURITY_ACCESS_REQUEST_SEED) {
                if (this.savedNumberOfErrorRepetitions != 2L) {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 2L);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 2L);
                    }
                }
                diagComPrimitive = this.securityAccessRequestSeed(this.logicalLink, "Request Seed " + this.securityMethod);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)diagComPrimitive, 1, true);
                if (this.jobMessage.equals("SecurityAccess granted")) {
                    this.logger.info("ECU has already been unlocked (Seed 0x00 received).");
                    this.setJobInfo("ECU has already been unlocked (Seed 0x00 received).");
                    currentJobStep = JobStep.DONE;
                    continue;
                }
                if (this.securitySeed == null) {
                    this.logger.error("Aborting job due to missing seed value.");
                    this.jobCompletionStatus = "Job completed with errors";
                    this.jobMessage = "SecurityAccess failed";
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    currentJobStep = JobStep.DONE;
                    continue;
                }
                currentJobStep = JobStep.CALCULATE_SECURITY_KEY;
                continue;
            }
            if (currentJobStep == JobStep.CALCULATE_SECURITY_KEY) {
                this.securityKey = this.calculateSecurityKey(this.securityMethod, this.securityCode, this.securityAlgorithm, this.securitySeed);
                this.logger.debug("securityKey: " + Conversions.byteArray2String(this.securityKey));
                this.setJobProgress(60L);
                if (this.securityKey == null) {
                    // empty if block
                }
                currentJobStep = JobStep.SECURITY_ACCESS_SEND_KEY;
                continue;
            }
            if (currentJobStep == JobStep.SECURITY_ACCESS_SEND_KEY) {
                this.logger.debug("securityMethod: " + this.securityMethod);
                this.logger.debug("securityKey: " + Conversions.byteArray2String(this.securityKey));
                diagComPrimitive = this.securityAccessSendKey(this.logicalLink, "Send Key " + this.securityMethod, this.securityKey);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)diagComPrimitive, 1, true);
                currentJobStep = JobStep.DONE;
                continue;
            }
            if (currentJobStep != JobStep.DONE) {
                this.logger.error("*** UNKNOWN job step ***: " + currentJobStep);
            }
            this.setJobProgress(95L);
        }
        if (this.isPduApiUsed) {
            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
        } else {
            this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
        }
        this.logger.debug("Final job status: " + currentJobStatus);
        this.jobStatus = currentJobStatus;
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobCompletionStatus = "Job completed successfully";
            this.jobMessage = "SecurityAccess granted";
        }
        return this.jobCompletionStatus;
    }

    protected void finalizeJobGuarded() {
        try {
            this.finalizeJob();
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in finalizeJob() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in finalizeJob() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
    }

    protected void finalizeJob() {
        this.logger.trace("Entering finalizeJob(...).");
        if (this.jobMessage.equalsIgnoreCase("SecurityAccess granted")) {
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        } else if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        super.finalizeJob();
        this.logger.finalize(this.getCurrentJobRuntimeAsString());
    }

    protected void addOutputParameters(MCDResponse pResponse, Map pOutputParameters) {
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        if (pResponse == null) {
            this.logger.error("addResponse() called with null argument!");
        } else {
            try {
                responseParameters = pResponse.getResponseParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response parameters from response.");
                this.logger.logThrowable(mcde);
            }
            if (responseParameters != null) {
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                }
                if (!pOutputParameters.keySet().isEmpty()) {
                    for (long l = 0L; l < numberOfResponseParameters; ++l) {
                    }
                }
            }
        }
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int numberOfInputParameters = 0;
        MCDRequestParameter inputParameter = null;
        String inputParameterName = null;
        int logLevel = -1;
        this.logger.trace("Entering readInputParameters(...).");
        try {
            numberOfInputParameters = (int)pRequestParameters.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining number of job input parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Number of INPUT-PARAMETERS to read: " + numberOfInputParameters);
        for (long i = 0L; i < (long)numberOfInputParameters; ++i) {
            try {
                inputParameter = pRequestParameters.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                inputParameterName = inputParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting SHORT-NAME of job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (inputParameterName.equals("IPA_LogLevel")) {
                try {
                    logLevel = (int)inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + logLevel);
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter \"IPA_LogLevel\" - defaulting to LOG_TRACE.");
                    this.logger.logThrowable(mcde);
                    logLevel = 0;
                }
                logLevel &= 7;
                if (this.logger.isConfiguredByPropertiesFile()) {
                    this.logger.debug("Ignoring " + inputParameterName + " since logger has already been configured by properties file.");
                    continue;
                }
                if (logLevel <= 0) continue;
                this.logger.init(this.dbEcuName, logLevel);
                continue;
            }
            if (inputParameterName.equals("IPA_SecurMetho")) {
                try {
                    this.securityMethod = inputParameter.getValue().getValueAsString();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.securityMethod);
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter with SHORT-NAME \"IPA_SecurMetho\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_SecurCode")) {
                try {
                    this.securityCode = inputParameter.getValue().getUint32();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + inputParameter.getValue().getValueAsString());
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter with SHORT-NAME \"IPA_SecurCode\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_SecurAlgor")) {
                try {
                    this.securityAlgorithm = inputParameter.getValue().getBytefield();
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.vendorSpecific.pduValue2String(inputParameter.getValue()));
                    continue;
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting value of job input parameter with SHORT-NAME \"IPA_SecurAlgor\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            throw new IllegalArgumentException("Unknown job input parameter: " + inputParameterName);
        }
        this.logger.trace("Leaving readInputParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus addOutputParameters(MCDResponse pResponse) {
        MCDResponseParameter respParam_jobCompletionStatus = null;
        MCDResponseParameter respParam_jobMessages = null;
        MCDValue value_jobCompletionStatus = null;
        this.logger.debug("Retrieving response parameters.");
        try {
            respParam_jobCompletionStatus = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobMessages = pResponse.getResponseParameters().getItemByName("OPA_JobMessa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobMessa\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Retrieving values.");
        try {
            value_jobCompletionStatus = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting value of job output parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Setting values.");
        this.logger.debug("Setting job completion status: " + this.jobCompletionStatus);
        try {
            value_jobCompletionStatus.setValueAsString(this.jobCompletionStatus);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of job output parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU did not respond within the timeout period.");
        } else if (this.jobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU returned a negative response.");
        } else if (this.jobStatus == AbstractJob.JobStatus.WRONG_UBATT_DETECTED) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "The voltage on terminal 30 is invalid.");
        } else if (this.jobStatus == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
            this.addJobMessage(respParam_jobMessages, "dynamic", "Communication disturbed (error frames on bus).");
        } else {
            this.addJobMessage(respParam_jobMessages, "static", this.jobMessage);
        }
        this.addJobMessage(respParam_jobMessages, "dynamic", "Job runtime: " + this.getCurrentJobRuntimeAsString());
        this.logger.debug("Setting output parameters.");
        try {
            respParam_jobCompletionStatus.setValue(value_jobCompletionStatus);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting parameter value of job output parameter with SHORT-NAME \"OPA_JobComplStatu\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus addJobMessage(MCDResponseParameter pJobMessages, String pMessageType, String pMessage) {
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter respParam_jobMessage = null;
        MCDResponseParameters respParams_messageMuxBranchElements = null;
        MCDResponseParameters respParams_messageMux = null;
        MCDResponseParameter muxBranch = null;
        MCDResponseParameter respParam_messageType = null;
        MCDResponseParameter respParam_message = null;
        MCDValue value_messageType = null;
        MCDValue value_message = null;
        int messageDataType = 255;
        try {
            fieldElements = pJobMessages.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobMessage = fieldElements.addElement();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding job message to collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType = this.getLastResponseParameterOfFieldByName(respParam_jobMessage, "Param_MessaType");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting of nested output parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType.setValueAsString(pMessageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType.setValue(value_messageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = this.getLastResponseParameterOfFieldByName(pJobMessages, "Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMux = respParam_message.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            this.logger.debug("Adding MUX branch.");
            muxBranch = respParams_messageMux.addMuxBranch(Conversions.longName2ShortName("Case_", pMessageType));
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding branch to multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMuxBranchElements = muxBranch.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer branch of Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = respParams_messageMuxBranchElements.getItemByName("Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameter Param_Messa from multiplexer branch.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_message = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            messageDataType = respParam_message.getType();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining MCD data type of nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("MCDDataType of message: " + McdEnumDecoder.decodeMcdDataType(messageDataType));
        try {
            value_message.setValueAsString(pMessage);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message.setValue(value_message);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus prepareProtocolParameterSet() {
        MCDRequest protocolParameterSetRequest = null;
        this.logger.trace("Entering prepareProtocolParameterSet(...).");
        try {
            this.protocolParameterSet = (MCDProtocolParameterSet)this.logicalLink.createDiagComPrimitiveByType(1193);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating ProtocolParameterSet!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            this.protocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error fetching COMPARAM values from interface!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            protocolParameterSetRequest = this.protocolParameterSet.getRequest();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting request of ProtocolParameterSet!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            this.protocolParameters = protocolParameterSetRequest.getRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting COMPARAMs from ProtocolParameterSet request!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            this.protocolParameters.getItemByName("CP_ModifyTiming");
            this.isPduApiUsed = true;
            this.logger.info("Using PDU-API firmware with ISO 22900-2 COMPARAMs.");
        }
        catch (MCDException mcde) {
            this.isPduApiUsed = false;
            this.logger.info("Using Softing EIDBSS firmware with proprietary COMPARAMs.");
        }
        this.logger.debug("Saving initial COMPARAM values.");
        this.savedNumberOfErrorRepetitions = this.isPduApiUsed ? this.getProtocolParameterUint32(this.protocolParameterSet, "CP_RepeatReqCountApp") : this.getProtocolParameterUint32(this.protocolParameterSet, "NumberOfErrorRepetitions");
        this.logger.trace("Leaving prepareProtocolParameterSet(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected MCDService createService(MCDLogicalLink pLogicalLink, String pServiceShortName) throws MCDException {
        MCDService service = null;
        try {
            service = (MCDService)pLogicalLink.createDiagComPrimitiveByName(pServiceShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating service with SHORT-NAME: " + pServiceShortName);
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            throw mcde;
        }
        return service;
    }

    protected MCDService securityAccessRequestSeed(MCDLogicalLink pLogicalLink, String pSecurityAccessType) throws MCDException {
        String securityAccessTypeToSet = pSecurityAccessType;
        MCDService securityAccess = null;
        this.logger.trace("Entering securityAccessRequestSeed(...).");
        securityAccess = this.createService(pLogicalLink, "DiagnServi_SecurAccesRequeSeed");
        if (pSecurityAccessType.endsWith("BDM AU48X")) {
            securityAccessTypeToSet = pSecurityAccessType.replaceAll("BDM AU48X", "Bootloader");
        }
        this.setRequestParameterString((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesType", securityAccessTypeToSet);
        this.logger.trace("Leaving securityAccessRequestSeed(...).");
        return securityAccess;
    }

    protected MCDService securityAccessSendKey(MCDLogicalLink pLogicalLink, String pSecurityAccessType, byte[] pSecurityKey) throws MCDException {
        String securityAccessTypeToSet = pSecurityAccessType;
        MCDService securityAccess = null;
        int securityKeyDataType = 255;
        this.logger.trace("Entering securityAccessSendKey(...).");
        securityAccess = this.createService(pLogicalLink, "DiagnServi_SecurAccesSendKey");
        if (pSecurityAccessType.endsWith("BDM AU48X")) {
            securityAccessTypeToSet = pSecurityAccessType.replaceAll("BDM AU48X", "Bootloader");
        }
        this.setRequestParameterString((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesType", securityAccessTypeToSet);
        if (pSecurityKey != null) {
            securityKeyDataType = this.getRequestParameterType((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesKey");
            switch (securityKeyDataType) {
                case 3: {
                    this.setRequestParameterBytefield((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesKey", pSecurityKey);
                    break;
                }
                case 11: {
                    this.setRequestParameterUint32((MCDDiagComPrimitive)securityAccess, "Param_SecurAccesKey", Conversions.byteArray2Long(pSecurityKey));
                    break;
                }
                default: {
                    this.logger.error("The security key parameter has an unexpected MCD data type: " + McdEnumDecoder.decodeMcdDataType(securityKeyDataType) + ".");
                }
            }
            this.setJobProgress(80L);
        } else {
            this.logger.debug("No security key to set - probably securityAccessType=requestSeed");
        }
        this.logger.trace("Leaving securityAccessSendKey(...).");
        return securityAccess;
    }

    protected void setRequestParameterUint32(MCDRequestParameters pRequestParameters, String pRequestParameterName, long pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterUint32(...).");
        requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        value = requestParameter.createValue();
        value.setUint32(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterUint32(...).");
    }

    protected void setRequestParameterUint32(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, long pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterUint32(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        value.setUint32(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterUint32(...).");
    }

    protected void setRequestParameterString(MCDRequestParameters pRequestParameters, String pRequestParameterName, String pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterString(...).");
        requestParameter = this.getRequestParameter(pRequestParameters, pRequestParameterName);
        value = requestParameter.createValue();
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected void setRequestParameterString(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, String pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterString(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        this.logger.debug("Setting parameter to: " + pValue);
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected void setRequestParameterBytefield(MCDRequestParameters pRequestParameters, String pRequestParameterName, byte[] pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterBytefield(...).");
        requestParameter = this.getRequestParameter(pRequestParameters, pRequestParameterName);
        value = requestParameter.createValue();
        value.setBytefield(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterBytefield(...).");
    }

    protected void setRequestParameterBytefield(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, byte[] pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterBytefield(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        value.setBytefield(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterBytefield(...).");
    }

    protected MCDRequestParameter getRequestParameter(MCDRequestParameters pRequestParameters, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected MCDRequestParameter getRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive.getRequest().getRequestParameters(), pRequestParameterName);
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected byte[] calculateSecurityKey(String pSecurityMethod, long pSecurityCode, byte[] pSecurityAlgorithm, byte[] pSecuritySeed) {
        byte[] calculatedSecurityKey = null;
        long securitySeedValue = 0L;
        long securityKeyValue = 0L;
        this.logger.trace("Entering calculateSecurityKey(...).");
        securitySeedValue = Conversions.byteArray2Long(pSecuritySeed) & 0xFFFFFFFFL;
        this.logger.info("Seed = " + Conversions.byteArray2String(pSecuritySeed));
        this.logger.debug("Seed = 0x" + Long.toHexString(securitySeedValue).toUpperCase());
        if (pSecurityMethod.equals("Bootloader")) {
            securityKeyValue = this.calculateSecurityKeySA2(securitySeedValue, pSecurityAlgorithm);
        } else if (pSecurityMethod.equals("Login") || pSecurityMethod.equals("System Specific")) {
            securityKeyValue = this.calculateSecurityKeyPin(securitySeedValue, pSecurityCode);
        } else if (pSecurityMethod.equals("BDM AU48X")) {
            securityKeyValue = this.dbEcuName.startsWith("EV_BDMLear") ? this.calculateSecurityKeyBdmLear(securitySeedValue) : this.calculateSecurityKeyBdmBosch(securitySeedValue);
        } else {
            throw new IllegalArgumentException("Invalid securityMethod: " + pSecurityMethod);
        }
        calculatedSecurityKey = Conversions.long2ByteArray(securityKeyValue, 4);
        this.logger.trace("Leaving calculateSecurityKey(...).");
        return calculatedSecurityKey;
    }

    protected long calculateSecurityKeyPin(long pSecuritySeed, long pSecurityCode) {
        long calculatedSecurityKey = 0L;
        this.logger.trace("Entering calculateSecurityPin(...).");
        calculatedSecurityKey = pSecuritySeed + pSecurityCode & 0xFFFFFFFFL;
        this.logger.trace("Leaving calculateSecurityPin(...).");
        return calculatedSecurityKey;
    }

    protected long calculateSecurityKeySA2(long pSecuritySeed, byte[] pSecurityAlgorithm) {
        long calculatedSecurityKey = 0L;
        this.logger.trace("Entering calculateSecurityKeySA2(...).");
        this.instructionPointer = 0;
        this.carryFlag = 0L;
        this.logger.debug("Starting the SA2 algorithm...");
        calculatedSecurityKey = pSecuritySeed;
        while (pSecurityAlgorithm[this.instructionPointer] != 76) {
            this.logger.debug("Executing command at IP " + Integer.toString(this.instructionPointer & 0xFF).toUpperCase());
            calculatedSecurityKey = this.sa2ExecuteCommand(calculatedSecurityKey);
        }
        this.logger.info("Key: 0x" + Long.toHexString(calculatedSecurityKey).toUpperCase());
        this.logger.trace("Leaving calculateSecurityKeySA2(...).");
        return calculatedSecurityKey;
    }

    protected long calculateSecurityKeyBdmLear(long pSecuritySeed) {
        this.logger.trace("Entering calculateSecurityKeyBdmLear(...).");
        long keyValue = pSecuritySeed;
        for (int i = 0; i < 6; ++i) {
            this.logger.debug("keyValue: 0x" + Long.toHexString(keyValue).toUpperCase());
            this.logger.debug("1/2: 0x" + Long.toHexString(keyValue << 31 & 0x80000000L).toUpperCase());
            this.logger.debug("2/2: 0x" + Long.toHexString(keyValue >>> 1 & Integer.MAX_VALUE).toUpperCase());
            keyValue = keyValue << 31 & 0x80000000L | keyValue >>> 1 & Integer.MAX_VALUE;
            this.logger.debug("keyValue: 0x" + Long.toHexString(keyValue).toUpperCase());
            if ((keyValue & 0x80000000L) <= 0L) continue;
            keyValue = (keyValue ^ 0xA221288L) & 0xFFFFFFFFL;
        }
        this.logger.debug("keyValue: 0x" + Long.toHexString(keyValue).toUpperCase());
        this.logger.trace("Leaving calculateSecurityKeyBdmLear(...).");
        return keyValue;
    }

    protected long calculateSecurityKeyBdmBosch(long pSecuritySeed) {
        this.logger.trace("Entering calculateSecurityKeyBdmBosch(...).");
        BigInteger CONST_A = new BigInteger(Conversions.long2ByteArray(2055390451L, 5));
        BigInteger CONST_B = new BigInteger(Conversions.long2ByteArray(3677417321L, 5));
        BigInteger CONST_C = new BigInteger(Conversions.long2ByteArray(306542764L, 5));
        BigInteger FF = new BigInteger(Conversions.long2ByteArray(0xFFFFFFFFL, 5));
        BigInteger OVERFLOW = FF.subtract(CONST_A);
        BigInteger seedValue = BigInteger.valueOf(pSecuritySeed & 0xFFFFFFFFFFFFFFFFL);
        this.logger.debug("seedValue: 0x" + Long.toHexString(seedValue.longValue()).toUpperCase());
        BigInteger keyValue = seedValue.add(CONST_A);
        keyValue = keyValue.and(FF);
        keyValue = OVERFLOW.compareTo(seedValue) < 0 ? keyValue.xor(CONST_B) : keyValue.xor(CONST_C);
        keyValue = keyValue.and(FF);
        BigInteger tmpValue = keyValue.and(BigInteger.valueOf(2047L));
        tmpValue = tmpValue.shiftLeft(21);
        keyValue = keyValue.shiftRight(11);
        keyValue = keyValue.or(tmpValue);
        this.logger.debug("keyValue: 0x" + Long.toHexString(keyValue.longValue()).toUpperCase());
        this.logger.trace("Leaving calculateSecurityKeyBdmBosch(...).");
        return keyValue.intValue();
    }

    protected AbstractJob.JobStatus executeDiagComPrimitiveSync(MCDLogicalLink pLogicalLink, MCDDiagComPrimitive pDiagComPrimitive, int pMaxNumberOfRepetitions, boolean pRemoveDiagComPrimitive) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResult result = null;
        int diagComPrimitiveType = -1;
        String diagComPrimitiveName = null;
        MCDValue requestPdu = null;
        int diagComPrimitiveState = -1;
        MCDErrors errors = null;
        this.logger.trace("Entering executeDiagComPrimitiveSync(...).");
        if (pDiagComPrimitive == null) {
            currentJobStatus = AbstractJob.JobStatus.ERROR;
            return currentJobStatus;
        }
        try {
            diagComPrimitiveType = pDiagComPrimitive.getObjectType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining type of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Type of diagComPrimitive: " + McdEnumDecoder.decodeMcdObjectType(diagComPrimitiveType));
        try {
            diagComPrimitiveName = pDiagComPrimitive.getDbObject().getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Name of diagComPrimitive: " + diagComPrimitiveName);
        if (this.logger.getLogLevel() > 0 && (diagComPrimitiveType == 1190 || diagComPrimitiveType == 1198)) {
            try {
                requestPdu = pDiagComPrimitive.getRequest().getPDU();
                this.logger.debug("Request PDU of diagComPrimitive: " + this.vendorSpecific.pduValue2String(requestPdu));
                if (this.logger.getLogLevel() >= 6) {
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " -> [   ".substring(0, 8 - Integer.toHexString(requestPdu.getBytefield().length).length()) + Integer.toHexString(requestPdu.getBytefield().length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(requestPdu));
                }
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request PDU of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        int repetitions = pMaxNumberOfRepetitions;
        block22: do {
            this.logger.debug("Executing diagComPrimitive.");
            try {
                --repetitions;
                result = pDiagComPrimitive.executeSync();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error executing diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Getting errors.");
            try {
                errors = pDiagComPrimitive.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting errors of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Handling errors.");
            if (errors == null) {
                this.logger.error("MCDDiagComPrimitive.getErrors() returned null.");
            } else {
                currentJobStatus = this.handleErrors(errors);
            }
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                // empty if block
            }
            this.logger.debug("Determining state of diagComPrimitive.");
            try {
                diagComPrimitiveState = pDiagComPrimitive.getState();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining state of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("State of diagComPrimitive: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComPrimitiveState));
            switch (diagComPrimitiveState) {
                case 25090: {
                    try {
                        pDiagComPrimitive.cancel();
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error cancelling diagComPrimitive.");
                        this.logger.logThrowable(mcde);
                        currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        break;
                    }
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                case 25089: {
                    if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR || diagComPrimitiveType == 1201 || diagComPrimitiveType == 1202) continue block22;
                    currentJobStatus = this.handleResult(pDiagComPrimitive, diagComPrimitiveType, result);
                    this.logger.debug("job status after handleResult(): " + currentJobStatus);
                    if (currentJobStatus != AbstractJob.JobStatus.WRONG_UBATT_DETECTED) continue block22;
                    this.logger.debug("Cancelling repetitions due to detection of wrong battery voltage.");
                    repetitions = 0;
                    break;
                }
                default: {
                    this.logger.error("*** UNKNOWN MCDDiagComPrimitiveState ***: " + diagComPrimitiveState);
                }
            }
        } while (repetitions > 0 && currentJobStatus != AbstractJob.JobStatus.NO_ERROR);
        this.logger.debug("Releasing result.");
        try {
            this.job.releaseResult(result);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error releasing result.");
            this.logger.logThrowable(mcde);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pRemoveDiagComPrimitive) {
            try {
                pLogicalLink.removeDiagComPrimitive(pDiagComPrimitive);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error removing diagComPrimitive form logical link.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving executeDiagComPrimitiveSync(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResult(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, MCDResult pResult) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        boolean resultHasError = false;
        this.logger.trace("Entering handleResult(...).");
        try {
            request = pDiagComPrimitive.getRequest();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting request from diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            requestParameters = request.getRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting request parameters from request.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            resultHasError = pResult.hasError();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining if result has an error.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (resultHasError) {
            MCDError error = null;
            this.logger.debug("Result has error.");
            try {
                error = pResult.getError();
            }
            catch (Exception e) {
                this.logger.debug("Error getting error from result.");
                this.logger.logThrowable(e);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53392 && error.getVendorCode() == 259 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 5074 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53315 && error.getVendorCode() == 20480 || pDiagComPrimitiveType == 1198 && !this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 19) {
                this.logger.debug("Ignoring P2 timeout since positive response has been suppressed.");
            } else if (error.getCode() == 53327 && error.getVendorCode() == 20) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && (error.getVendorCode() == 17 || error.getVendorCode() == 25 || error.getVendorCode() == 26 || error.getVendorCode() == 42 || error.getVendorCode() == 47)) {
                this.logger.warn("Wrong battery voltage detected - probably due to an interruption of clamp 30 or 15!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.WRONG_UBATT_DETECTED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 27) {
                this.logger.warn("EDIC interface deadlock error detected - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 16 || error.getCode() == 53315 && error.getVendorCode() == 16) {
                this.logger.warn("Command refused by EDIC interface - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 58644 || error.getCode() == 53327 && (this.isPduApiUsed && error.getCode() == 262 || !this.isPduApiUsed && error.getCode() == 13)) {
                this.logger.warn("Communication to VCI lost (possibly due to voltage drop) - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_TO_VCI_LOST_OR_DISTURBED;
            } else {
                this.logger.logMcdError(error);
            }
            if (!this.isPduApiUsed) {
                this.logger.debug("Restarting communication after timeout.");
                this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.stopCommunication, 1, false);
                this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.startCommunication, 1, false);
            }
        } else {
            String serviceShortName = null;
            int resultType = -1;
            MCDResponses responses = null;
            try {
                serviceShortName = pResult.getServiceShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining service SHORT-NAME of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result for service: " + serviceShortName);
            try {
                resultType = pResult.getType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining type of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
            if (resultType == 1793) {
                this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
            } else {
                try {
                    responses = pResult.getResponses();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting responses from result.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, requestParameters, responses);
                this.logger.debug("job status after handleResponses(): " + currentJobStatus);
            }
        }
        this.logger.trace("Leaving handleResult(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResponses(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponses pResponses) {
        AbstractJob.JobStatus currentJobStatus = null;
        long responseCount = 0L;
        MCDResponse response = null;
        AbstractJob.JobStatus currentStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handleResponses(...).");
        try {
            responseCount = pResponses.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of responses.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of responses: " + responseCount);
        if (!this.isPositiveResponseSuppressed(pDiagComPrimitiveType, pRequestParameters)) {
            currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
        } else if (responseCount == 0L) {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        for (long i = 0L; i < responseCount; ++i) {
            try {
                response = pResponses.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            currentStatus = this.handleResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, response);
            if (this.responseLocationAccessKey.equals(this.dbLocationAccessKey) || this.responseLocationAccessKey.equals(this.dbLocationAccessKeyBaseVariant)) {
                currentJobStatus = currentStatus;
                continue;
            }
            this.logger.debug("dbLocation of response    : " + this.responseLocationAccessKey);
            this.logger.debug("dbLocation of BASE-VARIANT: " + this.dbLocationAccessKeyBaseVariant);
            this.logger.debug("dbLocation of LOGICAL-LINK: " + this.dbLocationAccessKey);
        }
        this.logger.trace("Leaving handleResponses(...).");
        return currentJobStatus;
    }

    protected boolean isPositiveResponseSuppressed(int pDiagComPrimitiveType, MCDRequestParameters pRequestParameters) {
        MCDRequestParameter param_suppressPositiveResponseMessageIndicationBit = null;
        String suppressPositiveResponseMessageIndicationBit = null;
        this.logger.trace("Entering isPositiveResponseSuppressed(...).");
        switch (pDiagComPrimitiveType) {
            case 1198: {
                try {
                    param_suppressPositiveResponseMessageIndicationBit = pRequestParameters.getItemByName("Param_SupprPositRespoMessaIndicBit");
                    this.logger.info("Found Param_SupprPositRespoMessaIndicBit in request.");
                    try {
                        suppressPositiveResponseMessageIndicationBit = param_suppressPositiveResponseMessageIndicationBit.getValue().getValueAsString();
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting value of Param_SupprPositRespoMessaIndicBit from request.");
                        this.logger.logThrowable(mcde);
                        suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                    }
                }
                catch (MCDException mcde) {
                    this.logger.info("No Param_SupprPositRespoMessaIndicBit found in request.");
                    suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                }
                break;
            }
            case 1190: 
            case 1192: 
            case 1197: 
            case 1200: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                break;
            }
            default: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
            }
        }
        if (suppressPositiveResponseMessageIndicationBit.equalsIgnoreCase(Boolean.TRUE.toString())) {
            this.logger.debug("Response has been suppressed.");
        } else {
            this.logger.debug("Response has not been suppressed.");
        }
        this.logger.trace("Leaving isPositiveResponseSuppressed(...).");
        return Boolean.valueOf(suppressPositiveResponseMessageIndicationBit);
    }

    protected AbstractJob.JobStatus handleResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDAccessKey accessKeyOfLocation = null;
        int responseState = -1;
        this.logger.trace("Entering handleResponse(...).");
        try {
            accessKeyOfLocation = pResponse.getAccessKeyOfLocation();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining access key of response location.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (accessKeyOfLocation == null) {
            this.logger.debug("MCDResponse.getAccessKeyOfLocation() returned null!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            this.responseLocationAccessKey = accessKeyOfLocation.getString();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting string for access key of response location.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("DbLocation of response: " + this.responseLocationAccessKey);
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " <- [   ".substring(0, 8 - Integer.toHexString(pResponse.getResponseMessage().getBytefield().length).length()) + Integer.toHexString(pResponse.getResponseMessage().getBytefield().length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(pResponse.getResponseMessage()));
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting response message by getValueAsString().");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1200: {
                break;
            }
            case 1192: 
            case 1197: {
                break;
            }
        }
        try {
            responseState = pResponse.getState();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining response state.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (responseState) {
            case 26625: {
                currentJobStatus = this.handlePositiveResponse(pDiagComPrimitiveType, pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 26626: {
                currentJobStatus = this.handleNegativeResponse(pRequestParameters, pResponse);
                break;
            }
            default: {
                this.logger.error("Invalid MCDResponseState: " + responseState);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handleResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveResponse(...).");
        this.logger.debug("Response is positive.");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                currentJobStatus = this.handlePositiveServiceResponse(pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 1192: 
            case 1197: 
            case 1200: {
                break;
            }
        }
        this.logger.trace("Leaving handlePositiveResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveServiceResponse(String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        byte responseServiceIdentifier = 0;
        byte requestServiceIdentifier = 0;
        this.logger.trace("Entering handlePositiveServiceResponse(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
            responseMessageString = pResponse.getResponseMessage().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length < 1) {
            this.logger.error("Error getting response service id from response with length of " + responseMessage.length + " bytes.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        responseServiceIdentifier = responseMessage[0];
        if ((responseServiceIdentifier & 0x40 & 0xFF) == 0) {
            this.logger.error("The extracted response service id (0x" + Integer.toHexString(responseServiceIdentifier & 0xFF).toUpperCase() + ") is not a positive response service identifier!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        requestServiceIdentifier = (byte)(responseServiceIdentifier - 64);
        try {
            numberOfResponseParameters = pResponse.getResponseParameters().getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.warn("Ignoring response since it is not covered by a database response: " + responseMessageString);
        } else {
            switch (requestServiceIdentifier) {
                case 39: {
                    currentJobStatus = this.handlePositiveResponseSecurityAccess(pRequestParameters, pResponse);
                    break;
                }
                default: {
                    this.logger.debug("*** UNKNOWN service ***: " + pServiceShortName);
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                }
            }
        }
        this.logger.trace("Leaving handlePositiveServiceResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseSecurityAccess(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String securityAccessTypeRequest = null;
        String securityAccessTypeResponse = null;
        this.logger.trace("Entering handlePositiveResponseSecurityAccess(...).");
        try {
            securityAccessTypeRequest = pRequestParameters.getItemByName("Param_SecurAccesType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting security access type of request (Param_SecurAccesType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            securityAccessTypeResponse = pResponse.getResponseParameters().getItemByName("Param_SecurAccesType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting security access type of response (Param_SecurAccesType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!securityAccessTypeResponse.equals(securityAccessTypeRequest)) {
            this.logger.error("securityAccessType of response does NOT match request: " + securityAccessTypeRequest + " / " + securityAccessTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        if (securityAccessTypeResponse.startsWith("Request Seed")) {
            currentJobStatus = this.handlePositiveResponseSecurityAccessRequestSeed(pResponse);
        } else if (securityAccessTypeResponse.startsWith("Send Key")) {
            currentJobStatus = this.handlePositiveResponseSecurityAccessSendKey(pResponse);
        } else {
            this.logger.error("Unhandled or unknown securityAccessType: " + securityAccessTypeResponse);
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving handlePositiveResponseSecurityAccess(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseSecurityAccessRequestSeed(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResponseParameter param_securitySeed = null;
        int securitySeedDataType = 255;
        byte[] responseMessage = null;
        this.logger.trace("Entering handlePositiveResponseSecurityAccessRequestSeed(...).");
        try {
            param_securitySeed = pResponse.getResponseParameters().getItemByName("Param_SecurAccesSeed");
        }
        catch (MCDException mcde) {
            this.logger.error("Error retrieving security seed parameter from response (Param_SecurAccesSeed).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            securitySeedDataType = param_securitySeed.getType();
        }
        catch (MCDException mcde) {
            this.logger.error("Error retrieving MCD data type of security seed parameter (Param_SecurAccesSeed).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            switch (securitySeedDataType) {
                case 3: {
                    this.securitySeed = param_securitySeed.getValue().getBytefield();
                    break;
                }
                case 11: {
                    this.securitySeed = Conversions.long2ByteArray(param_securitySeed.getValue().getUint32(), 4);
                    break;
                }
                default: {
                    this.logger.error("The security seed parameter has an unexpected MCD data type: " + McdEnumDecoder.decodeMcdDataType(securitySeedDataType) + ".");
                    return AbstractJob.JobStatus.ERROR;
                }
            }
            this.setJobProgress(40L);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting security seed of request (Param_SecurAccesSeed).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.isEcuUnlocked(this.securitySeed)) {
            this.jobMessage = "SecurityAccess granted";
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 6) {
            this.logger.warn("Unexpected additional response parameters: " + Conversions.byteArray2String(responseMessage));
        }
        this.logger.trace("Leaving handlePositiveResponseSecurityAccessRequestSeed(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseSecurityAccessSendKey(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        this.logger.trace("Entering handlePositiveResponseSecurityAccessSendKey(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            this.logger.warn("Unexpected additional response parameters: " + Conversions.byteArray2String(responseMessage));
        }
        this.logger.trace("Leaving handlePositiveResponseSecurityAccessSendKey(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleNegativeResponse(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte requestServiceIdentifierRequest = 0;
        byte requestServiceIdentifierResponse = 0;
        String negativeResponseCode = null;
        byte nrc = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        this.logger.trace("Entering handleNegativeResponse(...).");
        this.logger.debug("Response is negative.");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length == 3) {
            long i;
            block29: {
                try {
                    for (i = 0L; i < pRequestParameters.getCount(); ++i) {
                        if (!pRequestParameters.getItemByIndex(i).getShortName().endsWith("RequeServiId")) continue;
                        requestServiceIdentifierRequest = (byte)pRequestParameters.getItemByIndex(i).getValue().getUint32();
                        break;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting request service identifier from request.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    responseParameters = pResponse.getResponseParameters();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting response parameters from response!");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                    this.logger.debug("Number of response parameters: " + numberOfResponseParameters);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (numberOfResponseParameters < 4L) {
                    requestServiceIdentifierResponse = requestServiceIdentifierRequest;
                } else {
                    try {
                        this.logger.debug("Datatype of request SID: " + McdEnumDecoder.decodeMcdDataType(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getDataType()));
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 3) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getBytefield()[0] & 0xFF);
                            break block29;
                        }
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 14 || responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 1) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseMessage().getBytefield()[1] & 0xFF);
                            break block29;
                        }
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        requestServiceIdentifierResponse = 0;
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        this.logger.logThrowable(mcde);
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                }
            }
            try {
                for (i = 0L; i < numberOfResponseParameters; ++i) {
                    if (!responseParameters.getItemByIndex(i).getShortName().equals("Param_NegatRespoCode")) continue;
                    negativeResponseCode = responseParameters.getItemByIndex(i).getValue().getValueAsString();
                    break;
                }
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code (Param_NegatRespoCode) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                nrc = pResponse.getResponseMessage().getBytefield()[2];
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code (byte 2) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("- Service ID: 0x" + Integer.toHexString(requestServiceIdentifierResponse));
            this.logger.debug("- NRC       : 0x" + Integer.toHexString(nrc) + " (" + negativeResponseCode + ")");
            if (requestServiceIdentifierResponse != requestServiceIdentifierRequest) {
                this.logger.error("Request service identifier of response does NOT match request: 0x" + Integer.toHexString(requestServiceIdentifierRequest) + " / " + Integer.toHexString(requestServiceIdentifierResponse));
            }
        } else {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (responseMessage.length < 3) {
                this.logger.debug("Negative response has invalid length of " + responseMessage.length + " bytes: " + responseMessageString);
            } else if (responseMessage.length > 3) {
                this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
            }
        }
        currentJobStatus = AbstractJob.JobStatus.NEGATIVE_RESPONSE;
        this.logger.trace("Leaving handleNegativeResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleErrors(MCDErrors pErrors) {
        long numberOfErrors = 0L;
        MCDError error = null;
        this.logger.trace("Entering handleErrors(...).");
        try {
            numberOfErrors = pErrors.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of errors.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (long i = 0L; i < numberOfErrors; ++i) {
            try {
                error = pErrors.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting error wirh index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.logMcdError(error);
        }
        this.logger.trace("Leaving handleNegativeResponse(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected String getProtocolParameterString(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        String value = null;
        this.logger.trace("Entering getProtocolParameterString(...).");
        try {
            value = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName).getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UNICODE2STRING value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterString(...).");
        return value;
    }

    protected long getProtocolParameterUint32(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        long value = -1L;
        this.logger.trace("Entering getProtocolParameterUint32(...).");
        try {
            value = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName).getUint32();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UINT32 value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterUint32(...).");
        return value;
    }

    protected MCDValue getProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) {
        MCDValue comParamValue = null;
        this.logger.trace("Entering getProtocolParameterValue(...).");
        if (this.isComParamVolatile(pComParamName)) {
            try {
                pProtocolParameterSet.fetchValueFromInterface(pComParamName);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error fetching protocol parameters from interface.");
                this.logger.logThrowable(mcde);
                return null;
            }
        }
        try {
            comParamValue = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName).getValue();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getProtocolParameterValue(...).");
        return comParamValue;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, String pValue) {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        String currentValue = null;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            currentValue = comParamValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setValueAsString(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        if (this.logger.getLogLevel() >= 5) {
            try {
                pProtocolParameterSet.fetchValueFromInterface(pComParamName);
            }
            catch (MCDException mcde) {
                this.logger.error("Error fetching new protocol parameter values from interface.");
                this.logger.logThrowable(mcde);
            }
            try {
                this.logger.debug("New value of \"" + pComParamName + "\" is " + pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName).getValue().getValueAsString());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting new value of \"" + pComParamName + "\".");
                this.logger.logThrowable(mcde);
            }
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, long pValue) {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        long currentValue = -1L;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        if (this.isComParamVolatile(pComParamName)) {
            try {
                pProtocolParameterSet.fetchValueFromInterface(pComParamName);
            }
            catch (MCDException mcde) {
                this.logger.error("Error fetching protocol parameter values from interface.");
                this.logger.logThrowable(mcde);
                return null;
            }
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            currentValue = comParamValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setUint32(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            this.logger.logThrowable(mcde);
            return null;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        if (this.logger.getLogLevel() >= 5) {
            try {
                pProtocolParameterSet.fetchValueFromInterface(pComParamName);
            }
            catch (MCDException mcde) {
                this.logger.error("Error fetching new protocol parameter values from interface.");
                this.logger.logThrowable(mcde);
            }
            try {
                this.logger.debug("New value of \"" + pComParamName + "\" is " + pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName).getValue().getUint32());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting new value of \"" + pComParamName + "\".");
                this.logger.logThrowable(mcde);
            }
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDStartCommunication startCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStartCommunication startCommunicationTmp = null;
        this.logger.trace("Entering startCommunication(...).");
        startCommunicationTmp = (MCDStartCommunication)pLogicalLink.createDiagComPrimitiveByType(1201);
        this.logger.trace("Leaving startCommunication(...).");
        return startCommunicationTmp;
    }

    protected MCDStopCommunication stopCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStopCommunication stopCommunicationTmp = null;
        this.logger.trace("Entering stopCommunication(...).");
        stopCommunicationTmp = (MCDStopCommunication)pLogicalLink.createDiagComPrimitiveByType(1202);
        this.logger.trace("Leaving stopCommunication(...).");
        return stopCommunicationTmp;
    }

    protected long sa2ExecuteForLoop(long operand) {
        int pointerNext;
        this.logger.debug("Execute FOR with operand = " + Long.toHexString(operand));
        long outOperand = 0L;
        if (this.securityAlgorithm[this.instructionPointer] == 104) {
            int pointerFor = this.instructionPointer;
            int countLoops = this.securityAlgorithm[this.instructionPointer + 1];
            this.logger.debug("Number of loops = " + Integer.toString(countLoops));
            outOperand = operand;
            this.instructionPointer += 2;
            pointerNext = -1;
            while (countLoops >= 1) {
                this.logger.debug("countLoops is now: " + Integer.toString(--countLoops));
                while (this.securityAlgorithm[this.instructionPointer] != 73) {
                    this.logger.debug("Executing command 0x" + Integer.toHexString(this.securityAlgorithm[this.instructionPointer] & 0xFF) + " at IP = " + Integer.toString(this.instructionPointer));
                    outOperand = this.sa2ExecuteCommand(outOperand);
                    this.logger.debug("Executed command.");
                }
                pointerNext = this.instructionPointer;
                this.instructionPointer = pointerFor + 2;
            }
            this.logger.debug("Done with loop.");
            if (pointerNext < 0) {
                throw new RuntimeException("could not find the applicable next command");
            }
        } else {
            throw new RuntimeException("instruction pointer not on a for in executeFor");
        }
        this.instructionPointer = pointerNext + 1;
        this.logger.debug("instruction pointer is now: " + Integer.toString(this.instructionPointer));
        return outOperand;
    }

    protected long sa2ExecuteCommand(long operand) {
        long outOperand = operand;
        switch (this.securityAlgorithm[this.instructionPointer]) {
            case -127: {
                outOperand = operand << 1;
                outOperand &= 0xFFFFFFFFL;
                if ((operand & 0x80000000L) != 0L) {
                    this.carryFlag = 1L;
                    outOperand |= 1L;
                } else {
                    this.carryFlag = 0L;
                }
                ++this.instructionPointer;
                break;
            }
            case -126: {
                outOperand = operand >> 1;
                outOperand &= 0xFFFFFFFFL;
                if ((operand & 1L) != 0L) {
                    this.carryFlag = 1L;
                    outOperand |= 0x80000000L;
                } else {
                    this.carryFlag = 0L;
                }
                ++this.instructionPointer;
                break;
            }
            case -109: {
                outOperand = operand + this.sa2Get4ByteOperand();
                if (outOperand > 0xFFFFFFFFL) {
                    this.carryFlag = 1L;
                    outOperand &= 0xFFFFFFFFL;
                } else {
                    this.carryFlag = 0L;
                }
                this.instructionPointer += 5;
                break;
            }
            case -124: {
                outOperand = operand - this.sa2Get4ByteOperand();
                if (outOperand < 0L) {
                    this.carryFlag = 1L;
                    outOperand &= 0xFFFFFFFFL;
                } else {
                    this.carryFlag = 0L;
                }
                this.instructionPointer += 5;
                break;
            }
            case -121: {
                outOperand = operand ^ this.sa2Get4ByteOperand();
                outOperand &= 0xFFFFFFFFL;
                this.carryFlag = 0L;
                this.instructionPointer += 5;
                break;
            }
            case 104: {
                outOperand = this.sa2ExecuteForLoop(operand);
                break;
            }
            case 73: {
                throw new RuntimeException("next without for in ip=" + new Integer(this.instructionPointer).toString());
            }
            case 74: {
                if (this.carryFlag == 0L) {
                    this.instructionPointer += this.sa2Get1ByteOperand() + 2;
                    break;
                }
                this.instructionPointer += 2;
                break;
            }
            case 107: {
                this.instructionPointer += this.sa2Get1ByteOperand() + 2;
                break;
            }
            case 76: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown SA2 command 0x" + Integer.toHexString(this.securityAlgorithm[this.instructionPointer]) + " in method executeCommand, ip=" + new Integer(this.instructionPointer).toString() + "\n");
            }
        }
        this.logger.debug("outop: 0x" + Long.toHexString(outOperand).toUpperCase());
        return outOperand;
    }

    protected long sa2Get4ByteOperand() {
        long outOperand = 0L;
        if (this.instructionPointer + 5 < this.securityAlgorithm.length) {
            outOperand = (long)this.securityAlgorithm[this.instructionPointer + 4] & 0xFFL;
            outOperand += (long)this.securityAlgorithm[this.instructionPointer + 3] << 8 & 0xFF00L;
            outOperand += (long)this.securityAlgorithm[this.instructionPointer + 2] << 16 & 0xFF0000L;
        } else {
            throw new RuntimeException("algo too short for a 4 byte operand, ip = " + new Integer(this.instructionPointer).toString());
        }
        return outOperand += (long)this.securityAlgorithm[this.instructionPointer + 1] << 24 & 0xFF000000L;
    }

    protected int sa2Get1ByteOperand() {
        int operand = 0;
        if (this.instructionPointer + 1 >= this.securityAlgorithm.length) {
            throw new RuntimeException("SA2 algorithm is too short for a 1 byte operand at IP = " + new Integer(this.instructionPointer).toString());
        }
        operand = this.securityAlgorithm[this.instructionPointer + 1] & 0xFF;
        return operand;
    }

    protected void updateProtocolParameters(MCDProtocolParameterSet pProtocolParameterSet) {
        MCDResult result = null;
        int diagComprimitiveState = 0;
        this.logger.trace("Entering updateProtocolParameters(...).");
        try {
            result = pProtocolParameterSet.executeSync();
        }
        catch (MCDException mcde) {
            this.logger.error("Error executing MCDProtocolParameterSet.");
            this.logger.logThrowable(mcde);
            return;
        }
        try {
            diagComprimitiveState = pProtocolParameterSet.getState();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining comprimitive state of protocol parameter set.");
            this.logger.logThrowable(mcde);
            return;
        }
        this.logger.info("Current state of protocol parameter set is: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComprimitiveState));
        if (result != null) {
            boolean resultHasError = true;
            try {
                resultHasError = result.hasError();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining if result has an error.");
                this.logger.logThrowable(mcde);
                return;
            }
            if (resultHasError) {
                MCDError error = null;
                this.logger.debug("Error updating protocol parameters: Result has error.");
                try {
                    error = result.getError();
                }
                catch (Exception e) {
                    this.logger.error("Error getting error from result.");
                    this.logger.logThrowable(e);
                    return;
                }
                this.logger.logMcdError(error);
            } else {
                int executionState = -1;
                try {
                    executionState = result.getResultState().getExecutionState();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting execution state from result state.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.debug("Success updating protocol parameters.");
                this.logger.debug("ResultState of MCDProtocolParameterSet: " + McdEnumDecoder.decodeMcdExecutionState(executionState));
            }
        } else {
            MCDErrors errors = null;
            long numberOfErrors = 0L;
            MCDError error = null;
            this.logger.debug("Error updating protocol parameters: Result is null. This is caused by a DTS bug.");
            try {
                errors = pProtocolParameterSet.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting errors from MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            try {
                numberOfErrors = errors.getCount();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining number of errors of MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = errors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + " from MCDProtocolParameterSet.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving updateProtocolParameters(...).");
    }

    protected boolean isEcuUnlocked(byte[] pSecuritySeed) {
        this.logger.trace("Entering isEcuUnlocked(...).");
        for (int i = 0; i < pSecuritySeed.length; ++i) {
            if (pSecuritySeed[i] == 0) continue;
            this.logger.debug("Byte " + i + " of seed is not 0x00... ECU is locked!");
            return false;
        }
        this.logger.debug("All bytes of seed are 0x00... ECU has already been unlocked!");
        this.logger.trace("Leaving isEcuUnlocked(...).");
        return true;
    }

    protected int getRequestParameterType(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName) throws MCDException {
        int requestParameterType = 255;
        this.logger.trace("Entering getRequestParameterType(...).");
        requestParameterType = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName).getType();
        this.logger.trace("Leaving getRequestParameterType(...).");
        return requestParameterType;
    }

    protected int getResponseParameterType(MCDResponse pResponse, String pResponseParameterName) throws MCDException {
        int responseParameterType = 255;
        this.logger.trace("Entering getResponseParameterType(...).");
        responseParameterType = pResponse.getResponseParameters().getItemByName(pResponseParameterName).getType();
        this.logger.trace("Leaving getResponseParameterType(...).");
        return responseParameterType;
    }

    protected AbstractJob.JobStatus checkRequiredDiagComms(String[] pRequiredDiagComms) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        MCDDbDataPrimitives dbDataPrimitives = null;
        int dbDataPrimitiveCount = 0;
        MCDDbDataPrimitive dbDataPrimitive = null;
        String dbDataPrimitiveShortName = null;
        boolean isDiagCommAvailable = false;
        try {
            dbDataPrimitives = this.dbLocationOfLogicalLink.getDbDataPrimitives();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            dbDataPrimitiveCount = (int)dbDataPrimitives.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (int i = 0; i < pRequiredDiagComms.length; ++i) {
            this.logMessage = "Checking availability of DIAG-COMM \"" + pRequiredDiagComms[i] + "\"... ";
            isDiagCommAvailable = false;
            for (int j = 0; j < dbDataPrimitiveCount; ++j) {
                try {
                    dbDataPrimitive = dbDataPrimitives.getItemByIndex((long)j);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    dbDataPrimitiveShortName = dbDataPrimitive.getShortName();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting SHORT-NAME of data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (!dbDataPrimitiveShortName.equals(pRequiredDiagComms[i])) continue;
                isDiagCommAvailable = true;
                this.logMessage = this.logMessage + "OK.";
                this.logger.debug(this.logMessage);
            }
            if (isDiagCommAvailable) continue;
            this.logMessage = this.logMessage + "*** MISSING ***.";
            this.logger.fatal(this.logMessage);
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        return currentJobStatus;
    }

    private MCDResponseParameter getLastResponseParameterOfFieldByName(MCDResponseParameter pResponseParameter, String pShortName) throws MCDException {
        long numberFieldElements = 0L;
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter responseParameter = null;
        MCDResponseParameter currentResponseParameter = null;
        String responseParameterName = null;
        this.logger.trace("Entering getLastResponseParameterOfFieldByName()...");
        try {
            fieldElements = pResponseParameter.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting elements of field.");
            throw mcde;
        }
        try {
            numberFieldElements = fieldElements.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting number of response parameters in field.");
            throw mcde;
        }
        int i = 0;
        while ((long)i < numberFieldElements) {
            block12: {
                try {
                    currentResponseParameter = fieldElements.getItemByIndex((long)i);
                    if (currentResponseParameter.getType() == 17) {
                        responseParameter = fieldElements.getItemByIndex(numberFieldElements - 1L).getParameters().getItemByName(pShortName);
                        break block12;
                    }
                    try {
                        responseParameterName = currentResponseParameter.getShortName();
                        if (responseParameterName.startsWith("#RtGen_")) {
                            responseParameterName = responseParameterName.replaceFirst("#RtGen_", "");
                            responseParameterName = responseParameterName.substring(0, responseParameterName.lastIndexOf("_"));
                        }
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error getting SHORT-NAME of response parameter with index " + i + ".");
                        throw mcde;
                    }
                    if (responseParameterName != null && responseParameterName.equals(pShortName)) {
                        responseParameter = currentResponseParameter;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting response parameter with index " + i + " from field.");
                    throw mcde;
                }
            }
            ++i;
        }
        this.logger.trace("Leaving getLastResponseParameterOfFieldByName()...");
        return responseParameter;
    }

    private final boolean isComParamVolatile(String pComParamName) {
        boolean result = true;
        this.logger.trace("Entering isComParamVolatile()...");
        result = this.isPduApiUsed ? !pComParamName.equals("CP_RepeatReqCountApp") : !pComParamName.equals("NumberOfErrorRepetitions");
        this.logger.trace("Leaving isComParamVolatile()...");
        return result;
    }

    static {
        REQUIRED_DIAG_COMMS = new String[]{"DiagnServi_SecurAccesRequeSeed", "DiagnServi_SecurAccesSendKey"};
        instances = 0;
        nextInstance = 0;
    }

    public static final class JobStep
    implements Comparable {
        public static final JobStep SECURITY_ACCESS_REQUEST_SEED = new JobStep("SECURITY_ACCESS_REQUEST_SEED");
        public static final JobStep CALCULATE_SECURITY_KEY = new JobStep("CALCULATE_SECURITY_KEY");
        public static final JobStep SECURITY_ACCESS_SEND_KEY = new JobStep("SECURITY_ACCESS_SEND_KEY");
        public static final JobStep DONE = new JobStep("DONE");
        private static int nextOrdinal = 0;
        static final JobStep[] values = new JobStep[]{SECURITY_ACCESS_REQUEST_SEED, CALCULATE_SECURITY_KEY, SECURITY_ACCESS_SEND_KEY, DONE};
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
        private final int ordinal = nextOrdinal++;
        private final String name;

        private JobStep(String pName) {
            this.name = pName;
        }

        public static final JobStep valueOf(String pName) throws IllegalArgumentException {
            JobStep jobStep = null;
            Iterator jobStepIterator = VALUES.iterator();
            while (jobStepIterator.hasNext()) {
                jobStep = (JobStep)jobStepIterator.next();
                if (!pName.equals(jobStep.toString())) continue;
                return jobStep;
            }
            throw new IllegalArgumentException("Cannot parse '" + pName + "' into an element of JobStep!");
        }

        public final int compareTo(Object pObject) {
            return this.ordinal - ((JobStep)pObject).ordinal;
        }

        public final boolean equals(Object pObject) {
            return super.equals(pObject);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final int intValue() {
            return this.ordinal;
        }

        public final String toString() {
            return this.name;
        }
    }
}

