<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!--doku.xsl Verison 009-->
 <xsl:template match="CATALOG">
  <xsl:variable name="Project">
   <xsl:value-of select="SHORT-NAME"/>
  </xsl:variable>
  <!--Pfad zum Verzeichnis der Dokumentationen (DTC, TABLE)-->
  <xsl:variable name="Path">\\AUDIINTEPro.in.audi.vwg\ProjectS\EE_Elektrik_Elektronik\Diagnose\2000_Transfer\2700_ODX_Doku</xsl:variable>
  <xsl:variable name="Project-Path">
   <xsl:value-of select="$Path"/>\<xsl:value-of select="$Project"/>
  </xsl:variable>
  <html>
   <head>
    <style type="text/css">
	  table {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  tr {border-width:0;padding:0;margin:0;text-align:left}
	  td {border-width:0;padding:0;margin:0;text-align:left}
	  span {margin-top:0pt;margin-bottom:0pt}
	  div {margin-top:0pt;margin-bottom:10pt;margin-left:16pt}
	  pre {margin-top:0pt;margin-botton:0pt;font-family:Arial;direction:ltr}
	  p {margin-top:0pt;margin-bottom:0pt}
	  .p_mini {margin-top:0pt;margin-bottom:0pt}
	  .p_small {margin-top:10pt;margin-bottom:10pt}
	  .p_big {margin-top:16pt;margin-bottom:16pt}
	  .courier_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:"Courier New";direction:ltr}
	  .default_style {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;direction:ltr}
	  .default_style_b {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .default_style_bu {margin-top:0;margin-bottom:0;font-size:10pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}
	  .default_style_big_bi {margin-top:0;margin-bottom:0;font-size:16pt;font-family:Arial;font-weight:bold;font-style:italic;direction:ltr}
	  .default_style_big_b {margin-top:0;margin-bottom:0;font-size:20pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_big {margin-top:0;margin-bottom:0;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .header_style_bigu {margin-top:0;margin-bottom:0;font-size:13pt;font-family:Arial;font-weight:bold;direction:ltr;text-decoration:underline}
	  .header_style_small {margin-top:0;margin-bottom:0;font-size:11pt;font-family:Arial;direction:ltr}
	  .small_style {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;direction:ltr}
	  .very_small_style {margin-top:0;margin-bottom:0;font-size:6pt;font-family:Arial;direction:ltr}
	  .small_style_b {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;direction:ltr}
	  .small_style_bu {margin-top:0;margin-bottom:0;font-size:8pt;font-family:Arial;font-weight:bold;text-decoration:underline;direction:ltr}

      .font_arial {font-family:Arial}
      .font_courier {font-family:"Courier New"}
      .font_header {font-family:"Courier New";font-size: 12px;}
      .font_header_underline {font-family:"Courier New";font-size: 12px; text-decoration:underline;}
      .font_sidis {font-family:SidisSymbole}
      .font_symbol {font-family:"Symbol"}
      .font_wingdings {font-family:"Wingdings"}
	  .size_small {font-size:10pt}
	  .size_big {font-size:12pt}
	  .color_black {color:#000000}
	  .color_red {color:#FF0000}
	  .color_green {color:#006400}
	  .color_blue {color:#0000FF}
	  .color_yellow {color:#FFF405}
	  .color_green2 {color:#92C027}
	  .color_blue2 {color:#6BBCE4}
	  .style_normal {font-style:normal}
	  .style_italic {font-style:italic}
	  .weight_normal {font-weight:normal}
	  .weight_bold {font-weight:bold}

	  .table_spec {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  
	  @media screen 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:100%}
	  }
	  @media print 
	  {
		body { margin-top:0;margin-bottom:0 } 
		.table_spec2 {border-width:0;border-collapse:collapse;padding:0;margin:0;width:165mm}
	  }
	</style>
    <title>
     <xsl:value-of select="SHORT-NAME"/>
    </title>
   </head>
   <body>
    <!--Header-->
    <p class="font_header">
     <br/>index.xml, Baseline: <xsl:value-of select="ADMIN-DATA/DOC-REVISIONS/DOC-REVISION/REVISION-LABEL"/>, <xsl:for-each select="ADMIN-DATA/DOC-REVISIONS/DOC-REVISION/DATE">
      <xsl:call-template name="display_timestamp">
       <xsl:with-param name="date">
        <xsl:value-of select="."/>
       </xsl:with-param>
      </xsl:call-template>
     </xsl:for-each> Uhr
				</p>
    <p class="font_header">Generated with: <xsl:value-of select="ADMIN-DATA/DOC-REVISIONS/DOC-REVISION/TOOL"/>
    </p>
	    <br />
    <a>
     <xsl:attribute name="HREF">#ENDE</xsl:attribute>
     <p class="font_header">Hinweise zum Zugriff auf die verlinkten Dateien und Verzeichnisse sind unten zu finden.
					<br/>
      <br/>
      <hr/>
      <br/>
     </p>
    </a>
    <table style="border-bottom-style=groove;border-bottom-color=black;border-bottom-width=2">
     <tr>
      <td valign="bottom" style="width:45mm;text-align:left">
       <p class="header_style_big">
        <xsl:value-of select="SHORT-NAME"/>
       </p>
      </td>
      <td valign="bottom" style="width:75mm;text-align:center">
       <p class="header_style_big">
        <xsl:text>MCD-Projekt-Inhalt</xsl:text>
       </p>
      </td>
      <td valign="bottom" style="width:45mm;text-align:right">
       <p class="header_style_small"/>
      </td>
     </tr>
    </table>
    <p>
     <br/>
    </p>
    <table style="line-height:5mm">
     <!--Zeilenhöhe in der Tabelle-->
     <tr>
      <!--Tabellenbeschriftung-->
      <td>
       <p class="default_style_bu">Datei</p>
      </td>
      <td>
       <p class="default_style_bu">Datum</p>
      </td>
      <td>
       <p class="default_style_bu">Kategorie</p>
      </td>
      <td>
       <p class="default_style_bu">DTC</p>
      </td>
      <td>
       <p class="default_style_bu">TABLE</p>
      </td>
     </tr>
     <xsl:for-each select="ABLOCKS/ABLOCK">
      <xsl:sort select="CATEGORY"/>
      <xsl:sort select="SHORT-NAME"/>
      <tr>
       <td valign="top" style="width:90mm">
        <!--1. Spalte: Dateiname-->
        <xsl:for-each select="FILES/FILE">
         <p class="default_style">
          <xsl:value-of select="."/>
         </p>
        </xsl:for-each>
       </td>
       <td valign="top" style="width:25mm">
        <!--2. Spalte: Datum-->
        <xsl:for-each select="FILES/FILE">
         <p class="default_style">
          <xsl:for-each select="@CREATION-DATE">
           <xsl:call-template name="display_date">
            <xsl:with-param name="date">
             <xsl:value-of select="."/>
            </xsl:with-param>
           </xsl:call-template>
          </xsl:for-each>
         </p>
        </xsl:for-each>
       </td>
       <td valign="top" style="width:25mm">
        <!--3. Spalte: Kategorie -->
        <p class="default_style">
         <xsl:value-of select="CATEGORY"/>
        </p>
       </td>
       <td valign="top" style="width:15mm">
        <!--4. Spalte: DisplayTroubleCode (DTC) -->
        <xsl:choose>
         <xsl:when test="CATEGORY!='ODX-DATA'"/>
         <xsl:when test="contains(FILES/FILE,'KWP2000')"/>
         <xsl:when test="contains(FILES/FILE,'KWP1281')"/>
         <xsl:when test="contains(FILES/FILE,'OBDCANISO')"/>
         <xsl:when test="substring(FILES/FILE,1,4)='ISO_' "/>
         <xsl:when test="substring(FILES/FILE,1,4)='CPS_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='VI_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='PR_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='BL_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='ES_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='FG_' "/>
         <xsl:otherwise>
          <a>
           <!--Namensgebung für Link auf Datei-->
           <xsl:attribute name="HREF"><xsl:value-of select="$Project-Path"/>\<xsl:value-of select="FILES/FILE"/>_dev_DTCs.pdf</xsl:attribute>
           <p class="default_style">DTC</p>
          </a>
         </xsl:otherwise>
        </xsl:choose>
       </td>
       <td valign="top" style="width:15mm">
        <!--5. Spalte: Table -->
        <xsl:choose>
         <xsl:when test="CATEGORY!='ODX-DATA'"/>
         <xsl:when test="contains(FILES/FILE,'KWP2000')"/>
         <xsl:when test="contains(FILES/FILE,'KWP1281')"/>
         <xsl:when test="contains(FILES/FILE,'OBDCANISO')"/>
         <xsl:when test="substring(FILES/FILE,1,4)='ISO_' "/>
         <xsl:when test="substring(FILES/FILE,1,4)='CPS_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='VI_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='PR_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='BL_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='ES_' "/>
         <xsl:when test="substring(FILES/FILE,1,3)='FG_' "/>
         <xsl:otherwise>
          <a>
           <!--Namensgebung für Link auf Datei-->
           <xsl:attribute name="HREF"><xsl:value-of select="$Project-Path"/>\<xsl:value-of select="FILES/FILE"/>_dev_TABLEs.pdf</xsl:attribute>
           <p class="default_style">TABLE</p>
          </a>
         </xsl:otherwise>
        </xsl:choose>
       </td>
      </tr>
     </xsl:for-each>
    </table>
    <p class="p_small">
     <br/>
     <hr/>
     <br/>
    </p>
    <!--Hinweis am Ende der Seite-->
    <table>
     <tr>
      <td>
       <p class="font_header_underline">Hinweise:</p>
      </td>
     </tr>
     <tr>
      <td>
       <p class="font_header">Für die Bereitstellung weiterer Informationen ist eine Zugriffsberechtigung auf folgendes Verzeichnis vorausgesetzt:</p>
      </td>
     </tr>
     <tr>
      <td>
       <a name="ENDE">
        <xsl:attribute name="HREF"><xsl:value-of select="$Path"/></xsl:attribute>
        <p class="font_header">
         <xsl:value-of select="$Path"/>
        </p>
       </a>
      </td>
     </tr>
    </table>
    <table>
     <!--Hinweisbereich für E-Mail Verteiler zum Beantragen des Zugriffrechts-->
     <tr>
      <td valign="top" style="width:100mm">
       <p class="font_header">Zugriff kann über diesen Link beantragt werden: </p>
      </td>
      <td valign="top" style="width:60mm">
       <a>
        <xsl:attribute name="HREF">
mailto:AUDI IN EE-45 ODX-Daten?subject=Zugriff auf Level 0 PDFs&amp;body=Hiermit beantrage ich im Rahmen meiner Taetigkeit fuer die AUDI AG Zugriff auf das Level 0 PDF Verzeichnis.%0A%0AGrund: 
</xsl:attribute>
        <p class="font_header">
									AUDI IN EE-45 ODX Daten
								</p>
       </a>
       <br/>
      </td>
     </tr>
    </table>
   </body>
  </html>
 </xsl:template>
 <xsl:template name="display_timestamp">
  <xsl:param name="date"/>
  <xsl:if test="$date!=''">
   <xsl:value-of select="substring($date,9,2)"/>
   <xsl:text>.</xsl:text>
   <xsl:value-of select="substring($date,6,2)"/>
   <xsl:text>.</xsl:text>
   <xsl:value-of select="substring($date,1,4)"/>
   <xsl:text>  </xsl:text>
   <xsl:value-of select="substring($date,12,5)"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="display_date">
  <xsl:param name="date"/>
  <xsl:if test="$date!=''">
   <xsl:value-of select="substring($date,9,2)"/>
   <xsl:text>.</xsl:text>
   <xsl:value-of select="substring($date,6,2)"/>
   <xsl:text>.</xsl:text>
   <xsl:value-of select="substring($date,1,4)"/>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
