/*
 * Decompiled with CFR 0.152.
 */
package com.elektrobit.automotive.mcd.joblibrary.audi.uds.jobs.mcd201;

import asam.d.MCDAccessKey;
import asam.d.MCDControlPrimitive;
import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDataPrimitives;
import asam.d.MCDDbDiagService;
import asam.d.MCDDbDiagServices;
import asam.d.MCDDbFlashData;
import asam.d.MCDDbFlashDataBlock;
import asam.d.MCDDbFlashDataBlocks;
import asam.d.MCDDbFlashFilter;
import asam.d.MCDDbFlashFilters;
import asam.d.MCDDbFlashIdent;
import asam.d.MCDDbFlashIdents;
import asam.d.MCDDbFlashSecurities;
import asam.d.MCDDbFlashSecurity;
import asam.d.MCDDbFlashSegment;
import asam.d.MCDDbFlashSegments;
import asam.d.MCDDbFlashSession;
import asam.d.MCDDbIdentDescription;
import asam.d.MCDDbParameter;
import asam.d.MCDDbRequest;
import asam.d.MCDDbRequestParameter;
import asam.d.MCDDbRequestParameters;
import asam.d.MCDDbResponse;
import asam.d.MCDDbResponseParameter;
import asam.d.MCDDbResponseParameters;
import asam.d.MCDDbService;
import asam.d.MCDDbSpecialDataGroups;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDDiagService;
import asam.d.MCDError;
import asam.d.MCDErrors;
import asam.d.MCDException;
import asam.d.MCDFlashJob;
import asam.d.MCDHexService;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDParameter;
import asam.d.MCDProtocolParameterSet;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDService;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDStartCommunication;
import asam.d.MCDStopCommunication;
import asam.d.MCDTextTableElement;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import com.audi.mcd.SharedData;
import com.audi.mcd.joblibrary2.constants.value.RequestParameterValue;
import com.audi.mcd.joblibrary2.jobs.AbstractJob;
import com.audi.mcd.joblibrary2.jobs.impl.AbstractFlashJobImpl;
import com.audi.mcd.joblibrary2.util.Conversions;
import com.audi.mcd.joblibrary2.util.DateTime;
import com.audi.mcd.joblibrary2.util.McdEnumDecoder;
import com.audi.mcd.joblibrary2.util.dserver.DServerVendor;
import com.audi.mcd.joblibrary2.util.dserver.VendorSpecific;
import com.audi.mcd.joblibrary2.util.dserver.VendorSpecificMCD20002;
import com.audi.mcd.joblibrary2.util.dserver.impl.SpecialDataGroupHelperImpl;
import com.audi.mcd.joblibrary3.util.parsers.fds.FDS;
import com.audi.mcd.joblibrary3.util.parsers.fds.FdsProject;
import com.audi.mcd.joblibrary3.util.parsers.fds.FdsSignature;
import com.audi.mcd.joblibrary3.util.parsers.fds.FdsSignatures;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MCD3_FlashJobUDS
extends AbstractFlashJobImpl {
    private static final String REVISION = "1.2.20141103";
    protected static final int CONTROL_DTC_SETTING_ON_DELAY_TIME = 500;
    protected static final String[] REQUIRED_DIAG_COMMS = new String[]{"DiagnServi_CommuContrEnablRxAndDisabTxNormaCommuMessa", "DiagnServi_CommuContrEnablRxAndTxNormaCommuMessa", "DiagnServi_ContrDTCSetti", "DiagnServi_DiagnSessiContr", "DiagnServi_DiagnSessiContrFUNCT", "DiagnServi_ECUResetHardReset", "DiagnServi_RequeDownl", "DiagnServi_RequeTransExit", "DiagnServi_RoutiContrCheckMemor", "DiagnServi_RoutiContrCheckProgrDepen", "DiagnServi_RoutiContrCheckProgrPreco", "DiagnServi_RoutiContrEraseMemor", "DiagnServi_TransData", "SinglJob_SecurAcces", "DiagnServi_SecurAccesRequeSeed", "DiagnServi_SecurAccesSendKey", "SinglJob_StartCommu", "SinglJob_WriteFinge", "DiagnServi_WriteDataByIdentECUIdent", "DiagnServi_WriteDataByIdentGenerServi"};
    private static int instances = 0;
    private static int nextInstance = 0;
    protected int instance;
    protected String jobCompletionStatus = null;
    protected String jobMessage = null;
    protected String jobResult = null;
    protected String dbFlashSessionName = null;
    protected String sessionDescShortName = null;
    protected String flashKey = null;
    protected boolean isModifyTimingEnabled = false;
    protected boolean isFunctionalAddressingDisabled = false;
    protected boolean isNormalCommunicationReEnabled = true;
    protected boolean isPreprogrammingSequenceDisabled = false;
    protected boolean isPostProgrammingSequenceDisabled = false;
    protected boolean isDownloadOfBootloaderDataSet = false;
    protected byte LFID_EM;
    protected byte AFID_EM;
    protected byte LFID_RD;
    protected byte AFID_RD;
    protected byte LFID_CM;
    protected byte AFID_CM;
    protected short LI_CM = (short)-1;
    protected boolean partialFlashProgrammingEnabled = true;
    protected int vwDeviceNumber = 0x1FFFFF;
    protected short importerNumber = (short)1023;
    protected int workshopNumber = 99999;
    protected byte year = 0;
    protected byte month = 0;
    protected byte day = 0;
    protected boolean forceSTminLowerLimitAtJobStart = false;
    protected long sTminLowerLimit = 0L;
    protected long sTminUpperLimit = 2000L;
    protected boolean isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet = false;
    protected boolean isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet = false;
    protected boolean isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet = false;
    protected boolean isInputParamProgrammingDateYearSet = false;
    protected boolean isInputParamProgrammingDateMonthSet = false;
    protected boolean isInputParamProgrammingDateDaySet = false;
    protected long cpSTminOverride = -1L;
    protected String separationTimeHandling = null;
    protected long separationTimeRequest;
    protected boolean isBaudRateChangeSupported = false;
    protected boolean isBaudRateChanged = false;
    protected long savedNumberOfErrorRepetitions = 0L;
    protected long savedStandTiminP2Serve = 0L;
    protected long savedExtenTiminP2Serve = 0L;
    protected long savedP3CanClientPhys = 0L;
    protected long savedP3CanClientFunc = 0L;
    protected long savedCanTransmissionTime = 0L;
    protected long savedStMinOverride = 0L;
    protected long savedRequestTime = 0L;
    protected MCDDiagService currentService = null;
    protected MCDControlPrimitive controlPrimitive = null;
    protected MCDJob flashPostProgramming = null;
    protected MCDJob flashPreProgramming = null;
    protected MCDJob checkOwnIdents = null;
    protected MCDJob changeBaudRate = null;
    protected MCDJob securityAccess = null;
    protected MCDJob writeFingerprint = null;
    protected MCDJob jobStartCommunication = null;
    protected byte[] m_securityAlgorithm = null;
    protected long numberOfExpectedIdents = 0L;
    protected MCDDbFlashIdents dbExpectedIdents = null;
    protected MCDDbIdentDescription[] dbExpectedIdentDescription = null;
    protected int numberOfDataBlocks = 0;
    private MCDDbFlashDataBlock[] dbDataBlocks = null;
    private Map dataBlockShortNames = null;
    protected String[] dataBlockType = null;
    protected MCDDbFlashIdents[] dbOwnIdents = null;
    protected MCDDbFlashIdent[][] dbOwnIdent = null;
    protected MCDDbIdentDescription[][] dbOwnIdentDescription = null;
    protected Map flashwareChecksums = null;
    protected Map flashwareSignatures = null;
    protected byte[][] flashwareChecksum = null;
    protected byte[][] flashwareSignature = null;
    protected MCDDbFlashFilters[] dbFlashFilters = null;
    protected MCDDbFlashFilter[][] dbFlashFilter = null;
    protected long[][] dbFlashFilterStart = null;
    protected long[][] dbFlashFilterSize = null;
    protected int[] numberOfFlashSegments = null;
    protected MCDDbFlashSegments[] dbFlashSegments = null;
    protected MCDDbFlashSegment[][] dbFlashSegment = null;
    protected byte[][] logicalBlockIndex = null;
    protected long[][] sourceStartAddress = null;
    protected long sourceStartAddressOfLogicalSoftwareBlock = 0L;
    protected byte[] logicalBlockIndexOfLogicalSoftwareBlock = null;
    protected long[][] uncompressedSize = null;
    protected long[][] compressedSize = null;
    protected MCDDbFlashData[] dbFlashData = null;
    protected int[] flashDataFormat = null;
    protected String[] compressionMethod = null;
    protected String[] encryptionMethod = null;
    protected byte[][][] binaryData = null;
    protected int[][] dbFlashSegmentSize = null;
    protected String ecuMemSpecVersion = null;
    protected String vw80126Version = null;
    protected FDS fds = null;
    protected String vw80126VersionOfRoutineControlCheckMemory = null;
    protected int totalNumberOfBytesToTransfer = 0;
    protected int totalNumberOfBytesTransferred = 0;
    protected MCDProtocolParameterSet protocolParameterSet = null;
    protected MCDRequestParameters protocolParameters = null;
    protected long maximumBlockSizeTransportLayer = 0L;
    protected int maximumNumberOfTransferDataRepetitions = 0;
    protected long maxStandTiminP2Serve = 0L;
    protected long maxExtenTiminP2Serve = 0L;
    protected int currentFlashDataBlock = 0;
    private String currentFlashDataBlockShortName = null;
    protected int currentFlashSegment = 0;
    protected ByteBuffer currentBinaryDataBuffer = null;
    protected byte[] currentBinaryDataChunk = null;
    protected long currentMaxNumberOfBlockLength = 0L;
    protected byte[][] binaryDataChunks = null;
    protected int numberOfDataChunks = 0;
    protected int currentDataChunk = 0;
    protected int lastDataChunk = 0;
    protected byte currentBlockSequenceCounter = 0;
    protected int numberOfInitialRepetitions = 0;
    protected int numberOfTotalRepetitions = 0;
    protected int numberOfTransferDataRepetitions = 0;
    protected int numberOfRepetitionsWithCurrentSTmin = 0;
    protected int maximumNumberOfRepetitionsWithCurrentSTmin = 10;
    protected boolean initialRepetition = true;
    protected Set outdatedDataBlocks = null;
    protected long fdsProjectIdEcu = 0L;
    protected String fdsKeyTypeEcu = null;

    public MCD3_FlashJobUDS() {
        this(REVISION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MCD3_FlashJobUDS(String pRevision) {
        super(pRevision);
        Class clazz = MCD3_FlashJobUDS.class;
        synchronized (clazz) {
            this.instance = nextInstance++;
            ++instances;
        }
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDFlashJob pFlashJob, MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering execute(...).");
        this.jobStatus = this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, pFlashJob, pDbFlashSession);
        if (this.jobStatus == AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS) {
            throw new NullPointerException("At least one of the call parameters of the job is null!");
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("prepareJob successful - executing job logic...");
            this.jobCompletionStatus = this.executeJobLogicGuarded();
        }
        this.finalizeJobGuarded();
        this.logger.trace("Leaving execute(...).");
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters) {
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus prepareJobGuarded(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDFlashJob pFlashJob, MCDDbFlashSession pDbFlashSession) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        try {
            currentJobStatus = this.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pFlashJob, pDbFlashSession);
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in prepareJob() method.");
            this.logger.logThrowable(e);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in prepareJob() method.");
            this.logger.logThrowable(t);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareJob(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDFlashJob pFlashJob, MCDDbFlashSession pDbFlashSession) {
        this.jobStatus = super.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pFlashJob, pDbFlashSession);
        this.jobCompletionStatus = "Job aborted due to fatal errors";
        this.jobMessage = "Error during update programming";
        this.jobResult = "unknown Failure - Programming aborted";
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.evaluateJobProperties();
        this.jobStatus = this.readInputParameters(pRequestParameters, null);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        if (VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && this.partialFlashProgrammingEnabled) {
            this.logger.info("SIDIS D server detected...disabling partial flash programming!");
            this.partialFlashProgrammingEnabled = false;
        }
        if (this.dbLocationTypeOfLogicalLink != 1158 && this.partialFlashProgrammingEnabled) {
            this.logger.info("Disabling partial flash programming since database location is " + McdEnumDecoder.decodeMcdObjectType(this.dbLocationTypeOfLogicalLink));
            this.partialFlashProgrammingEnabled = false;
        }
        this.jobStatus = this.checkRequiredDiagComms(REQUIRED_DIAG_COMMS);
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        this.logger.debug("Preparing protocol parameter set.");
        this.jobStatus = this.prepareProtocolParameterSet();
        if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return this.jobStatus;
        }
        if (!this.isPduApiUsed) {
            this.logger.debug("Preparing global control primitives.");
            try {
                this.stopCommunication = this.stopCommunication(this.logicalLink);
                this.startCommunication = this.startCommunication(this.logicalLink);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating MCDStop/StartCommunication.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.logger.debug("Reading ODX FLASH container.");
            this.jobStatus = this.readFlash(this.dbFlashSession);
            if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
                this.logger.debug("Error reading ODX FLASH container.");
            } else {
                if (!this.determineSpecificationVersionOfRoutineControlCheckMemory()) {
                    this.jobStatus = AbstractJob.JobStatus.ERROR;
                    return this.jobStatus;
                }
                if (this.dbFlashSessionName.matches("SES(D)?_[0-9A-F]{3}_71[0-9A-F]{2}_[0-9A-Z]{3}_[0-9A-Z]{4}_[0-9A-Z]{2}([0-9A-Z]{10})?(_[0-9A-Z]{1,80})?")) {
                    this.logger.info("Download of bootloader data set: " + this.dbFlashSessionName);
                    this.isDownloadOfBootloaderDataSet = true;
                    if (!this.ecuMemSpecVersion.equals("3.0.0")) {
                        this.logger.error("Detected ECU-MEM-SPEC-VERSION=\"" + this.ecuMemSpecVersion + "\" whereas bootloader data sets MUST use " + "ECU-MEM-SPEC-VERSION" + "=\"" + "3.0.0" + "\"!");
                        this.jobStatus = AbstractJob.JobStatus.ERROR;
                        return this.jobStatus;
                    }
                    if (!this.vw80126Version.equals("2.0.0")) {
                        this.logger.error("Detected VW80126-VERSION=" + this.vw80126Version + " while bootloader data sets MUST use " + "VW80126-VERSION" + "=" + "2.0.0" + "!");
                        this.jobStatus = AbstractJob.JobStatus.ERROR;
                        return this.jobStatus;
                    }
                } else if (this.isPreprogrammingSequenceDisabled || this.isPostProgrammingSequenceDisabled) {
                    this.logger.debug("Invalid combination of log level offsets for non-bootloader data set flash sequence detected!");
                    this.jobStatus = AbstractJob.JobStatus.ERROR;
                    return this.jobStatus;
                }
            }
        }
        Thread.currentThread().setPriority(10);
        this.logger.trace("Leaving prepareJob(...).");
        return this.jobStatus;
    }

    protected String executeJobLogicGuarded() {
        String currentJobCompletionStatus = null;
        try {
            currentJobCompletionStatus = this.executeJobLogic();
        }
        catch (MCDException mcde) {
            this.logger.debug("Caught MCDException in executeJobLogic() method.");
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in executeJobLogic() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in executeJobLogic() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            currentJobCompletionStatus = "Job aborted due to fatal errors";
        }
        return currentJobCompletionStatus;
    }

    protected String executeJobLogic() throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        AbstractJob.JobStatus currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
        JobStep currentJobStep = JobStep.values[0];
        this.setJobProgress(1L);
        while (currentJobStep.compareTo(JobStep.ECU_RESET) < 0 && (currentJobStatus == AbstractJob.JobStatus.NO_ERROR || currentJobStep == JobStep.TRANSFER_DATA && currentJobStatus == AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION)) {
            this.logger.debug("Current job step  : " + currentJobStep);
            this.logger.debug("Current job status: " + currentJobStatus);
            if (currentJobStep == JobStep.PREPARE_SUB_JOBS) {
                try {
                    this.checkOwnIdents = this.checkOwnIdents(this.logicalLink, this.logger.getLogLevel(), this.dbFlashSessionName);
                }
                catch (NullPointerException npe) {
                    this.logger.warn("Error creating SinglJob_CheckOwnIdent - disabling partial programming.");
                    this.partialFlashProgrammingEnabled = false;
                }
                if (this.isBaudRateChangeSupported) {
                    try {
                        this.changeBaudRate = this.changeBaudRate(this.logicalLink, this.logger.getLogLevel(), "CAN 1000000 Baud");
                    }
                    catch (NullPointerException npe) {
                        this.logger.warn("Error creating SinglJob_ChangBaudRate - disabling baud rate change.");
                        this.isBaudRateChangeSupported = false;
                    }
                }
                this.securityAccess = this.securityAccess(this.logicalLink, this.logger.getLogLevel(), "Bootloader", this.m_securityAlgorithm);
                this.writeFingerprint = this.writeFingerprint(this.logicalLink, this.logger.getLogLevel(), "F15A update programming fingerprint", this.vwDeviceNumber, this.importerNumber, this.workshopNumber, this.year, this.month, this.day);
                this.jobStartCommunication = this.startCommunication(this.logicalLink, this.logger.getLogLevel(), this.vwDeviceNumber, this.importerNumber, this.workshopNumber, this.year, this.month, this.day);
                if (this.forceSTminLowerLimitAtJobStart) {
                    this.separationTimeRequest = this.sTminLowerLimit;
                    this.logger.debug("Forcing STmin to lower limit.");
                    this.updateSeparationTimeRequest(this.protocolParameterSet, this.separationTimeRequest);
                }
                if (this.partialFlashProgrammingEnabled) {
                    this.logger.debug("Checking OWN-IDENTS.");
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.checkOwnIdents, 1, true);
                    this.logger.debug("Checked OWN-IDENTS.");
                }
                if (this.partialFlashProgrammingEnabled) {
                    if (this.outdatedDataBlocks != null && this.outdatedDataBlocks.size() == 0) {
                        this.logger.info("[PFL] All DATABLOCKs are valid and up to date - nothing to do!");
                        this.setJobInfo("[PFL] All DATABLOCKs are valid and up to date - nothing to do!");
                        currentJobStep = JobStep.ECU_RESET;
                        continue;
                    }
                    for (int i = 0; i < this.dbDataBlocks.length; ++i) {
                        if (this.dataBlockType[i].equals("ERASE") || this.outdatedDataBlocks.contains(this.dataBlockShortNames.get(this.dbDataBlocks[i]))) continue;
                        for (int j = 0; j < this.numberOfFlashSegments[i]; ++j) {
                            this.totalNumberOfBytesToTransfer -= this.dbFlashSegmentSize[i][j];
                        }
                    }
                    this.logger.info("Total number of bytes to transfer with partial programming: " + this.totalNumberOfBytesToTransfer);
                    this.setJobInfo("Total number of bytes to transfer with partial programming: " + this.totalNumberOfBytesToTransfer);
                }
                if (this.isDownloadOfBootloaderDataSet && this.isPreprogrammingSequenceDisabled) {
                    currentJobStep = JobStep.ANALYZE_CURRENT_DATA_BLOCK_AND_SEGMENT;
                } else {
                    if (!this.isFunctionalAddressingDisabled) {
                        if (this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Functional");
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                        } else {
                            this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                        }
                        this.currentService = this.diagnosticSessionControl(this.logicalLink, Boolean.TRUE, "Extended Diagnostic Session", true);
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                        if (this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                        } else {
                            this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                        }
                        if (currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                            this.logger.debug("Got negative response.");
                            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                        }
                    }
                    currentJobStep = JobStep.PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_PHYSICALLY;
                }
                this.setJobProgress(2L);
                continue;
            }
            if (currentJobStep == JobStep.PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_PHYSICALLY) {
                this.currentService = this.diagnosticSessionControl(this.logicalLink, Boolean.FALSE, "Extended Diagnostic Session", false);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                this.setJobProgress(3L);
                currentJobStep = JobStep.PREPROGRAMMING_CHECK_PROGRAMMING_PRECONDTITIONS;
                continue;
            }
            if (currentJobStep == JobStep.PREPROGRAMMING_CHECK_PROGRAMMING_PRECONDTITIONS) {
                this.currentService = this.routineControlCheckProgrammingPreconditions(this.logicalLink);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                this.setJobProgress(4L);
                currentJobStep = JobStep.PREPROGRAMMING_CONTROL_DTC_SETTING_OFF;
                continue;
            }
            if (currentJobStep == JobStep.PREPROGRAMMING_CONTROL_DTC_SETTING_OFF) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Functional");
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                }
                this.currentService = this.controlDtcSetting(this.logicalLink, Boolean.TRUE, "Off");
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                if (currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                    currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                }
                if (this.isFunctionalAddressingDisabled) {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                    }
                }
                this.setJobProgress(5L);
                currentJobStep = JobStep.PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX;
                continue;
            }
            if (currentJobStep == JobStep.PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX) {
                this.currentService = this.communicationControl(this.logicalLink, !this.isFunctionalAddressingDisabled, "Enable Rx And Disable Tx", "Normal Communication Messages", "All Networks");
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                if (!this.isFunctionalAddressingDisabled) {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                    }
                }
                if (currentJobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                    currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                }
                this.setJobProgress(6L);
                currentJobStep = JobStep.SWITCH_TO_PROGRAMMING_SESSION;
                continue;
            }
            if (currentJobStep == JobStep.SWITCH_TO_PROGRAMMING_SESSION) {
                this.currentService = this.diagnosticSessionControl(this.logicalLink, Boolean.FALSE, "Programming Session", false);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                currentJobStep = this.isBaudRateChangeSupported ? JobStep.CHANGE_BAUD_RATE : JobStep.SECURITY_ACCESS;
                this.setJobProgress(7L);
                continue;
            }
            if (currentJobStep == JobStep.CHANGE_BAUD_RATE) {
                if (this.isBaudRateChangeSupported) {
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                    }
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.changeBaudRate, 1, true);
                    if (this.isPduApiUsed) {
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                    } else {
                        this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                    }
                    if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
                        this.isBaudRateChanged = true;
                    } else {
                        this.isBaudRateChangeSupported = false;
                        currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                    }
                }
                currentJobStep = JobStep.SECURITY_ACCESS;
                this.setJobProgress(7L);
                continue;
            }
            if (currentJobStep == JobStep.SECURITY_ACCESS) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.securityAccess, 1, true);
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                }
                this.setJobProgress(8L);
                currentJobStep = JobStep.WRITE_FINGERPRINT;
                continue;
            }
            if (currentJobStep == JobStep.WRITE_FINGERPRINT) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.writeFingerprint, 1, true);
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                }
                this.setJobProgress(9L);
                currentJobStep = JobStep.ANALYZE_CURRENT_DATA_BLOCK_AND_SEGMENT;
                continue;
            }
            if (currentJobStep == JobStep.ANALYZE_CURRENT_DATA_BLOCK_AND_SEGMENT) {
                this.sourceStartAddressOfLogicalSoftwareBlock = 0L;
                if (this.currentFlashDataBlock < this.numberOfDataBlocks) {
                    this.logger.debug("Current flash data block: " + this.currentFlashDataBlock);
                    this.currentFlashDataBlockShortName = (String)this.dataBlockShortNames.get(this.dbDataBlocks[this.currentFlashDataBlock]);
                    this.logger.debug("SHORT-NAME of current flash data block: " + this.currentFlashDataBlockShortName);
                    if (this.partialFlashProgrammingEnabled && this.outdatedDataBlocks != null && !this.outdatedDataBlocks.contains(this.currentFlashDataBlockShortName)) {
                        this.logger.info("[PFL] Skipping data block " + this.currentFlashDataBlockShortName + " since it is already up to date.");
                        ++this.currentFlashDataBlock;
                        this.currentFlashSegment = 0;
                        continue;
                    }
                    if (this.currentFlashSegment < this.numberOfFlashSegments[this.currentFlashDataBlock]) {
                        this.logger.debug("Current flash segment   : " + this.currentFlashSegment);
                        if (this.dataBlockType[this.currentFlashDataBlock].equalsIgnoreCase("ERASE") || this.dataBlockType[this.currentFlashDataBlock].equalsIgnoreCase("FLASH_DATA") || this.dataBlockType[this.currentFlashDataBlock].equalsIgnoreCase("PROGRAMMING_ROUTINE")) {
                            currentJobStep = JobStep.ERASE_MEMORY;
                            continue;
                        }
                        if (!this.dataBlockType[this.currentFlashDataBlock].equalsIgnoreCase("DRIVER") && !this.dataBlockType[this.currentFlashDataBlock].equalsIgnoreCase("DATA") && !this.dataBlockType[this.currentFlashDataBlock].equalsIgnoreCase("ERASE_ROUTINE") && !this.dataBlockType[this.currentFlashDataBlock].equalsIgnoreCase("ERASE_PROGRAMMING_ROUTINE")) continue;
                        currentJobStep = JobStep.REQUEST_DOWNLOAD;
                        continue;
                    }
                    ++this.currentFlashDataBlock;
                    this.currentFlashSegment = 0;
                    continue;
                }
                if (this.isDownloadOfBootloaderDataSet && this.isPostProgrammingSequenceDisabled) {
                    this.logger.debug("Skipping RoutineControl/checkProgrammingDependencies for further bootloader data sets.");
                    currentJobStep = JobStep.DONE;
                    continue;
                }
                currentJobStep = JobStep.CHECK_PROGRAMMING_DEPENDENCIES;
                continue;
            }
            if (currentJobStep == JobStep.ERASE_MEMORY) {
                if (this.ecuMemSpecVersion.equals("3.0.0")) {
                    this.currentService = this.routineControlEraseMemory(this.logicalLink, this.LFID_EM, this.AFID_EM, this.logicalBlockIndex[this.currentFlashDataBlock]);
                } else {
                    this.currentService = this.routineControlEraseMemory(this.logicalLink, this.LFID_EM, this.AFID_EM, this.sourceStartAddress[this.currentFlashDataBlock][this.currentFlashSegment], this.uncompressedSize[this.currentFlashDataBlock][this.currentFlashSegment]);
                    if (!this.vw80126Version.equals("2.0.0")) {
                        this.sourceStartAddressOfLogicalSoftwareBlock = this.sourceStartAddress[this.currentFlashDataBlock][this.currentFlashSegment];
                    }
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                if (this.dataBlockType[this.currentFlashDataBlock].equalsIgnoreCase("ERASE")) {
                    ++this.currentFlashSegment;
                    currentJobStep = JobStep.ANALYZE_CURRENT_DATA_BLOCK_AND_SEGMENT;
                    continue;
                }
                currentJobStep = JobStep.REQUEST_DOWNLOAD;
                continue;
            }
            if (currentJobStep == JobStep.REQUEST_DOWNLOAD) {
                this.logger.debug("Current flash data block: " + this.currentFlashDataBlock);
                this.logger.debug("Current flash segment   : " + this.currentFlashSegment);
                this.currentService = this.requestDownload(this.logicalLink, this.compressionMethod[this.currentFlashDataBlock], this.encryptionMethod[this.currentFlashDataBlock], this.LFID_RD, this.AFID_RD, this.sourceStartAddress[this.currentFlashDataBlock][this.currentFlashSegment], this.uncompressedSize[this.currentFlashDataBlock][this.currentFlashSegment]);
                if (!this.vw80126Version.equals("2.0.0") && this.sourceStartAddressOfLogicalSoftwareBlock == 0L) {
                    this.sourceStartAddressOfLogicalSoftwareBlock = this.sourceStartAddress[this.currentFlashDataBlock][this.currentFlashSegment];
                }
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                currentJobStep = JobStep.TRANSFER_DATA_SETUP;
                continue;
            }
            if (currentJobStep == JobStep.TRANSFER_DATA_SETUP) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                }
                this.currentBlockSequenceCounter = 1;
                this.currentBinaryDataChunk = (long)this.currentBinaryDataBuffer.remaining() >= this.currentMaxNumberOfBlockLength ? new byte[(int)this.currentMaxNumberOfBlockLength] : new byte[this.currentBinaryDataBuffer.remaining()];
                this.currentBinaryDataBuffer.get(this.currentBinaryDataChunk);
                this.currentService = this.transferData(this.logicalLink, this.currentBlockSequenceCounter, this.currentBinaryDataChunk);
                this.lastDataChunk = this.currentDataChunk;
                this.numberOfTransferDataRepetitions = 0;
                this.initialRepetition = true;
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, false);
                currentJobStep = JobStep.TRANSFER_DATA;
                continue;
            }
            if (currentJobStep == JobStep.TRANSFER_DATA) {
                this.logger.debug("Current data chunk: " + this.currentDataChunk);
                if (this.currentDataChunk == this.lastDataChunk) {
                    if (this.initialRepetition) {
                        this.initialRepetition = false;
                        ++this.numberOfInitialRepetitions;
                    }
                    ++this.numberOfTotalRepetitions;
                    ++this.numberOfTransferDataRepetitions;
                    ++this.numberOfRepetitionsWithCurrentSTmin;
                    this.logger.debug("Repetition counter of currentDataChunk: " + this.numberOfTransferDataRepetitions);
                    if (this.numberOfTransferDataRepetitions > this.maximumNumberOfTransferDataRepetitions || this.numberOfRepetitionsWithCurrentSTmin > this.maximumNumberOfRepetitionsWithCurrentSTmin) {
                        this.logger.debug("Current/maximum STmin: " + this.separationTimeRequest + " / " + this.sTminUpperLimit + " \u00b5s");
                        if (this.separationTimeRequest == 0xFFFFFFFFL || this.separationTimeRequest < this.sTminUpperLimit) {
                            if (this.numberOfTransferDataRepetitions > this.maximumNumberOfTransferDataRepetitions) {
                                this.logger.debug("Increasing STmin due to 3 repetitions of one block.");
                                this.setJobInfo("Increasing STmin due to 3 repetitions of one block.");
                            } else {
                                this.logger.debug("Increasing STmin due to " + this.maximumNumberOfRepetitionsWithCurrentSTmin + " repetitions with current value of STmin.");
                                this.setJobInfo("Increasing STmin due to " + this.maximumNumberOfRepetitionsWithCurrentSTmin + " repetitions with current value of STmin.");
                            }
                            this.separationTimeRequest = this.increaseSeparationTimeRequest(this.separationTimeRequest);
                            this.updateSeparationTimeRequest(this.protocolParameterSet, this.separationTimeRequest);
                            this.numberOfTransferDataRepetitions = 0;
                            this.numberOfRepetitionsWithCurrentSTmin = 0;
                            this.maximumNumberOfRepetitionsWithCurrentSTmin = this.separationTimeRequest <= 1000L ? 10 : 25;
                        } else {
                            currentJobStatus = AbstractJob.JobStatus.EXCEEDED_NUMBER_OF_REPETITIONS;
                            this.logger.error("Maximum STmin value has been reached - aborting due to too many repetitions!");
                            this.setJobInfo("Maximum STmin value has been reached - aborting due to too many repetitions!");
                            currentJobStep = JobStep.ECU_RESET;
                        }
                    }
                } else {
                    this.lastDataChunk = this.currentDataChunk;
                    this.initialRepetition = true;
                    if ((long)this.currentBinaryDataBuffer.remaining() >= this.currentMaxNumberOfBlockLength) {
                        if (this.currentBinaryDataChunk == null) {
                            this.currentBinaryDataChunk = new byte[(int)this.currentMaxNumberOfBlockLength];
                        }
                    } else {
                        this.currentBinaryDataChunk = new byte[this.currentBinaryDataBuffer.remaining()];
                    }
                    this.currentBinaryDataBuffer.get(this.currentBinaryDataChunk);
                }
                if (currentJobStatus == AbstractJob.JobStatus.EXCEEDED_NUMBER_OF_REPETITIONS) continue;
                if (this.currentDataChunk < this.numberOfDataChunks) {
                    this.logger.debug("Length of current data chunk: " + this.currentBinaryDataChunk.length);
                    if (this.currentService == null) {
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                    } else {
                        this.currentService.resetToDefaultValues();
                    }
                    this.setBlockSequenceCounter(this.currentService, this.currentBlockSequenceCounter);
                    this.setTransferRequestParameterRecord(this.currentService, this.currentBinaryDataChunk);
                    if (this.currentDataChunk < this.numberOfDataChunks - 1) {
                        currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, false);
                        continue;
                    }
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, false);
                    continue;
                }
                try {
                    this.logicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)this.currentService);
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error removing TransferData DiagComprimitive from logical link.");
                    this.logger.logThrowable(mcde);
                }
                this.currentService = null;
                this.currentDataChunk = 0;
                this.currentBinaryDataBuffer = null;
                this.currentBinaryDataChunk = null;
                currentJobStep = JobStep.REQUEST_TRANSFER_EXIT;
                continue;
            }
            if (currentJobStep == JobStep.REQUEST_TRANSFER_EXIT) {
                if (this.isPduApiUsed) {
                    this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 2L);
                } else {
                    this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 2L);
                }
                this.currentService = this.requestTransferExit(this.logicalLink);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                ++this.currentFlashSegment;
                currentJobStep = JobStep.CHECK_FOR_MORE_SEGMENTS;
                continue;
            }
            if (currentJobStep == JobStep.CHECK_FOR_MORE_SEGMENTS) {
                if (this.currentFlashSegment < this.numberOfFlashSegments[this.currentFlashDataBlock]) {
                    currentJobStep = JobStep.REQUEST_DOWNLOAD;
                    continue;
                }
                currentJobStep = JobStep.CHECK_MEMORY;
                continue;
            }
            if (currentJobStep == JobStep.CHECK_MEMORY) {
                this.logger.debug("current datablock: " + this.currentFlashDataBlockShortName);
                if ((this.compressionMethod[this.currentFlashDataBlock] != "Uncompressed" || this.encryptionMethod[this.currentFlashDataBlock] != "Unencrypted") && this.flashwareChecksums.containsKey(this.currentFlashDataBlockShortName) && this.flashwareSignatures.containsKey(this.currentFlashDataBlockShortName)) {
                    byte[] signatureAndChecksum = null;
                    this.flashwareSignature[this.currentFlashDataBlock] = (byte[])this.flashwareSignatures.get(this.currentFlashDataBlockShortName);
                    signatureAndChecksum = new byte[this.flashwareSignature[this.currentFlashDataBlock].length + this.flashwareChecksum[this.currentFlashDataBlock].length];
                    System.arraycopy(this.flashwareSignature[this.currentFlashDataBlock], 0, signatureAndChecksum, 0, this.flashwareSignature[this.currentFlashDataBlock].length);
                    System.arraycopy(this.flashwareChecksum[this.currentFlashDataBlock], 0, signatureAndChecksum, this.flashwareSignature[this.currentFlashDataBlock].length, this.flashwareChecksum[this.currentFlashDataBlock].length);
                    this.logger.debug("current checksum : " + Conversions.byteArray2String(this.flashwareChecksum[this.currentFlashDataBlock]));
                    this.logger.debug("current signature: " + Conversions.byteArray2String(this.flashwareSignature[this.currentFlashDataBlock]));
                    this.logger.debug(" -> concatenated : " + Conversions.byteArray2String(signatureAndChecksum));
                    this.currentService = this.vw80126Version.equals("2.0.0") ? this.routineControlCheckMemoryVW80126v20(this.logicalLink, signatureAndChecksum) : this.routineControlCheckMemoryVW80126v1x(this.logicalLink, this.LFID_CM, this.AFID_CM, this.sourceStartAddressOfLogicalSoftwareBlock, this.uncompressedSize[this.currentFlashDataBlock][0], (short)signatureAndChecksum.length, signatureAndChecksum);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                } else if (this.flashwareSignatures.containsKey(this.currentFlashDataBlockShortName)) {
                    this.flashwareSignature[this.currentFlashDataBlock] = (byte[])this.flashwareSignatures.get(this.currentFlashDataBlockShortName);
                    this.logger.debug("current signature: " + Conversions.byteArray2String(this.flashwareSignature[this.currentFlashDataBlock]));
                    this.currentService = this.vw80126Version.equals("2.0.0") ? this.routineControlCheckMemoryVW80126v20(this.logicalLink, this.flashwareSignature[this.currentFlashDataBlock]) : this.routineControlCheckMemoryVW80126v1x(this.logicalLink, this.LFID_CM, this.AFID_CM, this.sourceStartAddressOfLogicalSoftwareBlock, this.uncompressedSize[this.currentFlashDataBlock][0], (short)this.flashwareSignature[this.currentFlashDataBlock].length, this.flashwareSignature[this.currentFlashDataBlock]);
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                } else if (this.flashwareChecksums.containsKey(this.currentFlashDataBlockShortName)) {
                    this.logger.debug("current checksum: " + Conversions.byteArray2String(this.flashwareChecksum[this.currentFlashDataBlock]));
                    this.currentService = this.LI_CM == -1 ? (this.vw80126Version.equals("2.0.0") ? this.routineControlCheckMemoryVW80126v20(this.logicalLink, this.flashwareChecksum[this.currentFlashDataBlock]) : this.routineControlCheckMemoryVW80126v1x(this.logicalLink, this.LFID_CM, this.AFID_CM, this.sourceStartAddressOfLogicalSoftwareBlock, this.uncompressedSize[this.currentFlashDataBlock][0], (short)this.flashwareChecksum[this.currentFlashDataBlock].length, this.flashwareChecksum[this.currentFlashDataBlock])) : (this.ecuMemSpecVersion.equals("3.0.0") ? this.routineControlCheckMemoryVW80126v20(this.logicalLink, this.flashwareChecksum[this.currentFlashDataBlock]) : this.routineControlCheckMemoryVW80126v1x(this.logicalLink, this.LFID_CM, this.AFID_CM, this.sourceStartAddressOfLogicalSoftwareBlock, this.uncompressedSize[this.currentFlashDataBlock][0], this.LI_CM, this.flashwareChecksum[this.currentFlashDataBlock]));
                    currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                }
                currentJobStep = JobStep.ANALYZE_CURRENT_DATA_BLOCK_AND_SEGMENT;
                continue;
            }
            if (currentJobStep == JobStep.CHECK_PROGRAMMING_DEPENDENCIES) {
                this.currentService = this.routineControlCheckProgrammingDependencies(this.logicalLink);
                currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                this.setJobProgress(90L);
                currentJobStep = JobStep.ECU_RESET;
                continue;
            }
            if (currentJobStep == JobStep.DONE) continue;
            this.logger.error("*** UNKNOWN job step ***: " + currentJobStep);
        }
        this.jobStatus = currentJobStatus;
        currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
        if (!this.partialFlashProgrammingEnabled || this.outdatedDataBlocks == null || this.outdatedDataBlocks.size() != 0) {
            if (this.isDownloadOfBootloaderDataSet && this.isPostProgrammingSequenceDisabled && currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
                this.logger.debug("Skipping post programming sequence for further bootloader data sets.");
            } else {
                if (currentJobStep != JobStep.RESTORE_BAUD_RATE) {
                    currentJobStep = JobStep.ECU_RESET;
                }
                while (currentJobStep.compareTo(JobStep.DONE) < 0 && currentJobStatusPostProgramming == AbstractJob.JobStatus.NO_ERROR) {
                    this.logger.debug("Current job step  : " + currentJobStep);
                    this.logger.debug("Current job status: " + currentJobStatus);
                    if (currentJobStep == JobStep.RESTORE_BAUD_RATE) {
                        if (!this.isFunctionalAddressingDisabled && this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                        }
                        if (this.isBaudRateChangeSupported && this.isBaudRateChanged) {
                            this.changeBaudRate = this.changeBaudRate(this.logicalLink, this.logger.getLogLevel(), "CAN 500000 Baud");
                            currentJobStatus = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.changeBaudRate, 1, true);
                            if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
                                this.isBaudRateChanged = false;
                            } else {
                                this.isBaudRateChangeSupported = false;
                                currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
                            }
                        }
                        currentJobStep = JobStep.ECU_RESET;
                        continue;
                    }
                    if (currentJobStep == JobStep.ECU_RESET) {
                        if (!this.isFunctionalAddressingDisabled && this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                        }
                        this.currentService = this.ecuReset(this.logicalLink, Boolean.FALSE, "Hard Reset");
                        currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 3, true);
                        if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                            currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                        }
                        this.setJobProgress(91L);
                        currentJobStep = JobStep.POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY;
                        continue;
                    }
                    if (currentJobStep == JobStep.POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY) {
                        if (!this.isFunctionalAddressingDisabled) {
                            if (this.isPduApiUsed) {
                                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Functional");
                                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                            } else {
                                this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                            }
                        }
                        this.currentService = this.diagnosticSessionControl(this.logicalLink, !this.isFunctionalAddressingDisabled, "Extended Diagnostic Session", true);
                        currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                        if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                            currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                        }
                        this.setJobProgress(92L);
                        currentJobStep = JobStep.POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF;
                        continue;
                    }
                    if (currentJobStep == JobStep.POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF) {
                        if (this.isFunctionalAddressingDisabled) {
                            if (this.isPduApiUsed) {
                                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Functional");
                                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                            } else {
                                this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                            }
                        }
                        this.currentService = this.controlDtcSetting(this.logicalLink, Boolean.TRUE, "Off");
                        currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                        if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                            currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                        }
                        if (this.isFunctionalAddressingDisabled) {
                            if (this.isPduApiUsed) {
                                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                            } else {
                                this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                            }
                        }
                        this.setJobProgress(93L);
                        currentJobStep = JobStep.POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX;
                        continue;
                    }
                    if (currentJobStep == JobStep.POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX) {
                        this.currentService = this.communicationControl(this.logicalLink, !this.isFunctionalAddressingDisabled, "Enable Rx And Disable Tx", "Normal Communication Messages", "All Networks");
                        currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                        if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                            currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                        }
                        this.setJobProgress(94L);
                        if (this.isNormalCommunicationReEnabled) {
                            currentJobStep = JobStep.POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX;
                            continue;
                        }
                        currentJobStep = JobStep.POSTPROGRAMMING_SWITCH_TO_DEFAULT_SESSION_PHYSICALLY;
                        continue;
                    }
                    if (currentJobStep == JobStep.POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX) {
                        this.currentService = this.communicationControl(this.logicalLink, !this.isFunctionalAddressingDisabled, "Enable Rx And Tx", "Normal Communication Messages", "All Networks");
                        if (!this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "RequestTime", 500L);
                        }
                        if ((currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true)) == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                            currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                        }
                        this.setJobProgress(95L);
                        currentJobStep = JobStep.POSTPROGRAMMING_CONTROL_DTC_SETTING_ON;
                        continue;
                    }
                    if (currentJobStep == JobStep.POSTPROGRAMMING_CONTROL_DTC_SETTING_ON) {
                        if (this.isFunctionalAddressingDisabled) {
                            if (this.isPduApiUsed) {
                                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Functional");
                                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", 0L);
                            } else {
                                this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", 0L);
                            }
                        }
                        this.currentService = this.controlDtcSetting(this.logicalLink, Boolean.TRUE, "On");
                        if (!this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "RequestTime", this.savedRequestTime);
                        } else {
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_P3Func", 500000L);
                        }
                        currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                        if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                            currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                        }
                        this.setJobProgress(96L);
                        currentJobStep = JobStep.POSTPROGRAMMING_SWITCH_TO_DEFAULT_SESSION_PHYSICALLY;
                        continue;
                    }
                    if (currentJobStep == JobStep.POSTPROGRAMMING_SWITCH_TO_DEFAULT_SESSION_PHYSICALLY) {
                        if (this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_P3Func", this.savedP3CanClientFunc);
                        }
                        if (this.isPduApiUsed) {
                            this.setProtocolParameterValue(this.protocolParameterSet, "CP_RequestAddrMode", "Physical");
                        }
                        if (this.isNormalCommunicationReEnabled) {
                            this.currentService = this.diagnosticSessionControl(this.logicalLink, Boolean.FALSE, "OBDII And VW Default Diagnostic Session", false);
                            currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.currentService, 1, true);
                        }
                        if (!this.isFunctionalAddressingDisabled) {
                            if (this.isPduApiUsed) {
                                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", this.savedNumberOfErrorRepetitions);
                            } else {
                                this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", this.savedNumberOfErrorRepetitions);
                            }
                        }
                        if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED || currentJobStatusPostProgramming == AbstractJob.JobStatus.ERROR) {
                            currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                        } else if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION && this.isSubSystemSupportingCommunicationControl()) {
                            this.logger.info("Ignoring P2 timeout for flashable sub system after implicitly disabling routing via re-enabling normal communication.");
                            currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                        }
                        this.setJobProgress(97L);
                        currentJobStep = JobStep.POSTPROGRAMMING_START_COMMUNICATION;
                        continue;
                    }
                    if (currentJobStep == JobStep.POSTPROGRAMMING_START_COMMUNICATION) {
                        currentJobStatusPostProgramming = this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.jobStartCommunication, 1, true);
                        if (currentJobStatusPostProgramming == AbstractJob.JobStatus.NEGATIVE_RESPONSE || currentJobStatusPostProgramming == AbstractJob.JobStatus.COMMUNICATION_DISTURBED || currentJobStatusPostProgramming == AbstractJob.JobStatus.ERROR) {
                            currentJobStatusPostProgramming = AbstractJob.JobStatus.NO_ERROR;
                        }
                        this.setJobProgress(98L);
                        currentJobStep = JobStep.RESTORE_PROTOCOL_PARAMETERS;
                        continue;
                    }
                    if (currentJobStep != JobStep.RESTORE_PROTOCOL_PARAMETERS) continue;
                    if (this.isPduApiUsed && this.separationTimeRequest != this.savedStMinOverride) {
                        this.logger.debug("Resetting CP_StMinOverride to value " + this.savedStMinOverride + " us.");
                        this.setProtocolParameterValue(this.protocolParameterSet, "CP_StMinOverride", this.savedStMinOverride);
                    }
                    currentJobStep = JobStep.DONE;
                }
            }
        }
        this.logger.debug("Final job status: " + currentJobStatus);
        this.setJobProgress(99L);
        if (currentJobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobCompletionStatus = "Job completed successfully";
            this.jobMessage = "Update programming finished successfully";
            this.jobResult = "Programming successful finished";
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        return this.jobCompletionStatus;
    }

    protected void finalizeJobGuarded() {
        try {
            this.finalizeJob();
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in finalizeJob() method.");
            this.logger.logThrowable(e);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in finalizeJob() method.");
            this.logger.logThrowable(t);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
    }

    protected void finalizeJob() {
        this.logger.trace("Entering finalizeJob(...).");
        if (this.jobMessage.equalsIgnoreCase("Update programming finished successfully")) {
            this.jobStatus = AbstractJob.JobStatus.NO_ERROR;
        } else if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) {
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        super.finalizeJob();
        this.finalizeLogging();
    }

    protected void finalizeLogging() {
        this.logger.debug("Initial  repetitions: " + this.numberOfInitialRepetitions);
        this.logger.debug("Repeated repetitions: " + (this.numberOfTotalRepetitions - this.numberOfInitialRepetitions));
        this.logger.debug("Total    repetitions: " + this.numberOfTotalRepetitions);
        this.logger.debug("Last value of STmin : " + this.separationTimeRequest + " \u00b5s");
        this.logger.finalize(this.getCurrentJobRuntimeAsString());
    }

    protected void addOutputParameters(MCDResponse pResponse, Map pOutputParameters) {
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        if (pResponse == null) {
            this.logger.error("addResponse() called with null argument!");
        } else {
            try {
                responseParameters = pResponse.getResponseParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response parameters from response.");
                this.logger.logThrowable(mcde);
            }
            if (responseParameters != null) {
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                }
                if (!pOutputParameters.keySet().isEmpty()) {
                    for (long l = 0L; l < numberOfResponseParameters; ++l) {
                    }
                }
            }
        }
    }

    protected AbstractJob.JobStatus readInputParameters(MCDRequestParameters pRequestParameters, String pShortNameOfWrappingParameter) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfInputParameters = 0L;
        MCDRequestParameter inputParameter = null;
        MCDRequestParameters nestedParameters = null;
        String inputParameterName = null;
        int logLevel = -1;
        this.logger.trace("Entering readInputParameters(...).");
        try {
            numberOfInputParameters = pRequestParameters.getCount();
        }
        catch (MCDException mcde) {
            if (pShortNameOfWrappingParameter == null) {
                this.logger.fatal("Error determining number of job input parameters.");
            } else {
                this.logger.fatal("Error determining number of parameters for structured INPUT-PARAM \"" + pShortNameOfWrappingParameter + "\".");
            }
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pShortNameOfWrappingParameter == null) {
            this.logger.info("Number of INPUT-PARAMETERS to read: " + numberOfInputParameters);
        } else {
            this.logger.info("Number of PARAMS to read for INPUT-PARAM \"" + pShortNameOfWrappingParameter + "\": " + numberOfInputParameters);
        }
        for (long i = 0L; i < numberOfInputParameters; ++i) {
            try {
                inputParameter = pRequestParameters.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                inputParameterName = inputParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting SHORT-NAME of job input parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (inputParameterName.equals("IPA_LogLevel")) {
                try {
                    logLevel = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if ((logLevel & 0x80) > 0) {
                        this.isFunctionalAddressingDisabled = true;
                    }
                    if ((logLevel & 0x40) > 0) {
                        this.isNormalCommunicationReEnabled = false;
                    }
                    if ((logLevel & 0x20) > 0) {
                        this.isPreprogrammingSequenceDisabled = true;
                    }
                    if ((logLevel & 0x10) > 0) {
                        this.isPostProgrammingSequenceDisabled = true;
                    }
                    if ((logLevel &= 7) >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + logLevel);
                    }
                }
                catch (Exception e) {
                    logLevel = 0;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + logLevel + ".");
                    this.logger.logThrowable(e);
                }
                if (this.logger.isConfiguredByPropertiesFile()) {
                    this.logger.debug("Ignoring " + inputParameterName + " since logger has already been configured by properties file.");
                } else if (logLevel > 0) {
                    this.logger.init(this.dbEcuName, logLevel);
                }
                this.logger.info("Configuration via properties and additional bits of \"IPA_LogLevel\":");
                this.logger.info("- Functional addressing disabled                              : " + this.isFunctionalAddressingDisabled);
                this.logger.info("- Normal communication re-enabled (non-parallel programming)  : " + this.isNormalCommunicationReEnabled);
                this.logger.info("- Preprogramming  disabled for non-first bootloader data set  : " + this.isPreprogrammingSequenceDisabled);
                this.logger.info("- Postprogramming disabled for non-last  bootloader data sets : " + this.isPostProgrammingSequenceDisabled);
                continue;
            }
            if (inputParameterName.equals("IPA_AddreAndLengtFormaIdent")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_AddreAndLengtFormaIdent")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_RoutiContrEraseMemorLengtFormaIdent") || inputParameterName.endsWith("Param_RoutiContrEraseMemorLengtFormaIdent") || inputParameterName.equals("IPA_RoutiContrEraseMemorLengtFormaIdent")) {
                try {
                    this.LFID_EM = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.LFID_EM);
                    continue;
                }
                catch (Exception e) {
                    this.LFID_EM = 0;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.LFID_EM + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RoutiContrEraseMemorAddreFormaIdent") || inputParameterName.endsWith("Param_RoutiContrEraseMemorAddreFormaIdent") || inputParameterName.equals("IPA_RoutiContrEraseMemorAddreFormaIdent")) {
                try {
                    this.AFID_EM = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.AFID_EM);
                    continue;
                }
                catch (Exception e) {
                    this.AFID_EM = 1;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.AFID_EM + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RequeDownlLengtFormaIdent") || inputParameterName.endsWith("Param_RequeDownlLengtFormaIdent") || inputParameterName.equals("IPA_RequeDownlLengtFormaIdent")) {
                try {
                    this.LFID_RD = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.LFID_RD);
                    continue;
                }
                catch (Exception e) {
                    this.LFID_RD = (byte)4;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.LFID_RD + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RequeDownlAddreFormaIdent") || inputParameterName.endsWith("Param_RequeDownlAddreFormaIdent") || inputParameterName.equals("IPA_RequeDownlAddreFormaIdent")) {
                try {
                    this.AFID_RD = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.AFID_RD);
                    continue;
                }
                catch (Exception e) {
                    this.AFID_RD = 1;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.AFID_RD + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RoutiContrCheckMemorLengtFormaIdent") || inputParameterName.endsWith("Param_RoutiContrCheckMemorLengtFormaIdent") || inputParameterName.equals("IPA_RoutiContrCheckMemorLengtFormaIdent")) {
                try {
                    this.LFID_CM = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.LFID_CM);
                    continue;
                }
                catch (Exception e) {
                    this.LFID_CM = 0;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.LFID_CM + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_RoutiContrCheckMemorAddreFormaIdent") || inputParameterName.endsWith("Param_RoutiContrCheckMemorAddreFormaIdent") || inputParameterName.equals("IPA_RoutiContrCheckMemorAddreFormaIdent")) {
                try {
                    this.AFID_CM = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.AFID_CM);
                    continue;
                }
                catch (Exception e) {
                    this.AFID_CM = 1;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.AFID_CM + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_PFLEnabl")) {
                try {
                    this.partialFlashProgrammingEnabled = Boolean.valueOf(this.getParameterValueAsString((MCDParameter)inputParameter));
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + String.valueOf(this.partialFlashProgrammingEnabled));
                    continue;
                }
                catch (Exception e) {
                    this.partialFlashProgrammingEnabled = Boolean.valueOf("TRUE");
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + "TRUE" + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_RepaiShopCodeOrTesteSeriaNumbe")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
                    this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                    return this.jobStatus;
                }
                if (this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet && this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet && this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet || !this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet && !this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet && !this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet) continue;
                this.logger.fatal("RepairShopCodeOrTesterSerialNumber has been set incompletely!");
                return AbstractJob.JobStatus.ERROR;
            }
            if (inputParameterName.equals("IPA_ProgrDate")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus != AbstractJob.JobStatus.NO_ERROR) {
                    this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                    return this.jobStatus;
                }
                if (this.isInputParamProgrammingDateYearSet && this.isInputParamProgrammingDateMonthSet && this.isInputParamProgrammingDateDaySet || !this.isInputParamProgrammingDateYearSet && !this.isInputParamProgrammingDateMonthSet && !this.isInputParamProgrammingDateDaySet) continue;
                this.logger.fatal("Programming date has been set incompletely!");
                return AbstractJob.JobStatus.ERROR;
            }
            if (inputParameterName.equals("Param_VWDevicNumbe")) {
                try {
                    this.vwDeviceNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.vwDeviceNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_ImporNumbe")) {
                try {
                    this.importerNumber = this.getParameterValueUint32AsShort((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.importerNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_WorksNumbe")) {
                try {
                    this.workshopNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.workshopNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_RepaiShopCodeOrTesteSeriaNumbe")) continue;
            if (inputParameterName.equals("Param_Year")) {
                try {
                    this.year = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.year);
                    }
                    this.isInputParamProgrammingDateYearSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_Month")) {
                try {
                    this.month = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.month);
                    }
                    this.isInputParamProgrammingDateMonthSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("Param_Day")) {
                try {
                    this.day = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.day);
                    }
                    this.isInputParamProgrammingDateDaySet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("IPA_MaximBuffeSizeTransLayer")) {
                try {
                    this.maximumBlockSizeTransportLayer = this.getParameterValueUint32((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.maximumBlockSizeTransportLayer);
                }
                catch (Exception e) {
                    this.maximumBlockSizeTransportLayer = 4095L;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.maximumBlockSizeTransportLayer + " bytes.");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_MaximNumbeOfTransDataRepet")) {
                try {
                    this.maximumNumberOfTransferDataRepetitions = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.maximumNumberOfTransferDataRepetitions);
                }
                catch (Exception e) {
                    this.maximumNumberOfTransferDataRepetitions = 50;
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.maximumNumberOfTransferDataRepetitions + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("IPA_STminHandl")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_STminHandl")) {
                try {
                    nestedParameters = inputParameter.getParameters();
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting nested parameters of job input parameter \"" + inputParameterName + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.jobStatus = this.readInputParameters(nestedParameters, inputParameterName);
                if (this.jobStatus == AbstractJob.JobStatus.NO_ERROR) continue;
                this.logger.fatal("Error reading PARAMs of structured INPUT-PARAM \"" + inputParameterName + "\"!");
                return this.jobStatus;
            }
            if (inputParameterName.equals("Param_ForceSTminLowerLimitAtJobStart") || inputParameterName.endsWith("Param_ForceSTminLowerLimitAtJobStart") || inputParameterName.equals("IPA_ForceSTminLowerLimitAtJobStart")) {
                try {
                    this.forceSTminLowerLimitAtJobStart = Boolean.valueOf(this.getParameterValueAsString((MCDParameter)inputParameter));
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + String.valueOf(this.forceSTminLowerLimitAtJobStart));
                    continue;
                }
                catch (Exception e) {
                    this.forceSTminLowerLimitAtJobStart = Boolean.valueOf("FALSE");
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.forceSTminLowerLimitAtJobStart + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("Param_STminLowerLimit") || inputParameterName.endsWith("Param_STminLowerLimit") || inputParameterName.equals("IPA_STminLowerLimit")) {
                try {
                    this.sTminLowerLimit = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.sTminLowerLimit);
                }
                catch (Exception e) {
                    this.sTminLowerLimit = 0L;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.sTminLowerLimit + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            if (inputParameterName.equals("Param_STminUpperLimit") || inputParameterName.endsWith("Param_STminUpperLimit") || inputParameterName.equals("IPA_STminUpperLimit")) {
                try {
                    this.sTminUpperLimit = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.sTminUpperLimit);
                    continue;
                }
                catch (Exception e) {
                    this.sTminUpperLimit = 2000L;
                    this.logger.fatal("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + this.sTminUpperLimit + ".");
                    this.logger.logThrowable(e);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_VWDevicNumbe")) {
                if (this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet) continue;
                try {
                    this.vwDeviceNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.vwDeviceNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet = true;
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_ImporNumbe")) {
                if (this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet) continue;
                try {
                    this.importerNumber = this.getParameterValueUint32AsShort((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.importerNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet = true;
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_WorksNumbe")) {
                if (this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet) continue;
                try {
                    this.workshopNumber = this.getParameterValueUint32AsInteger((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.workshopNumber);
                    }
                    this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet = true;
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            if (inputParameterName.equals("IPA_Year")) {
                if (this.isInputParamProgrammingDateYearSet) continue;
                try {
                    this.year = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.year);
                    }
                    this.isInputParamProgrammingDateYearSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("IPA_Month")) {
                if (this.isInputParamProgrammingDateMonthSet) continue;
                try {
                    this.month = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.month);
                    }
                    this.isInputParamProgrammingDateMonthSet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("IPA_Day")) {
                if (this.isInputParamProgrammingDateDaySet) continue;
                try {
                    this.day = this.getParameterValueUint32AsByte((MCDParameter)inputParameter);
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + this.day);
                    }
                    this.isInputParamProgrammingDateDaySet = true;
                }
                catch (Exception e) {
                    this.logger.warn("Error getting value of job input parameter \"" + inputParameterName + "\".");
                }
                continue;
            }
            if (inputParameterName.equals("IPA_Enabl1MbpsBaudrSwitch")) {
                try {
                    this.isBaudRateChangeSupported = Boolean.valueOf(this.getParameterValueAsString((MCDParameter)inputParameter));
                    if (this.logger.getLogLevel() < 5) continue;
                    this.logger.debug("INPUT-PARAM \"" + inputParameterName + "\" has value: " + String.valueOf(this.isBaudRateChangeSupported));
                }
                catch (Exception e) {
                    this.isBaudRateChangeSupported = Boolean.valueOf("FALSE");
                    this.logger.error("Error getting value of job input parameter \"" + inputParameterName + "\" - defaulting to " + "FALSE" + ".");
                    this.logger.logThrowable(e);
                }
                continue;
            }
            return AbstractJob.JobStatus.ERROR;
        }
        if (pShortNameOfWrappingParameter == null) {
            if (!(this.isInputParamRepaiShopCodeOrTesteSeriaNumbeVwDeviceNumberSet && this.isInputParamRepaiShopCodeOrTesteSeriaNumbeImporterNumberSet && this.isInputParamRepaiShopCodeOrTesteSeriaNumbeWorkshopNumberSet)) {
                this.logger.fatal("RepairShopCodeOrTesterSerialNumber has been set incompletely!");
                return AbstractJob.JobStatus.ERROR;
            }
            if (!(this.isInputParamProgrammingDateYearSet && this.isInputParamProgrammingDateMonthSet && this.isInputParamProgrammingDateDaySet)) {
                this.logger.warn("Programming date has been set incompletely!");
                this.year = (byte)(DateTime.calendar.get(1) - 2000);
                this.month = (byte)(DateTime.calendar.get(2) + 1);
                this.day = (byte)DateTime.calendar.get(5);
                this.logger.warn("- Defaulting to current year : " + this.year);
                this.logger.warn("- Defaulting to current month: " + this.month);
                this.logger.warn("- Defaulting to current day  : " + this.day);
            }
        }
        this.logger.trace("Leaving readInputParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus addOutputParameters(MCDResponse pResponse) {
        MCDResponseParameter respParam_jobCompletionStatus = null;
        MCDResponseParameter respParam_jobMessages = null;
        MCDResponseParameter respParam_jobResult = null;
        MCDResponseParameter respParam_jobStatus = null;
        MCDValue value_jobCompletionStatus = null;
        MCDValue value_jobResult = null;
        MCDValue value_jobStatus = null;
        if (pResponse == null) {
            this.logger.error("addOutputParameters() called with null argument!");
        } else {
            this.logger.debug("Retrieving response parameters.");
            try {
                respParam_jobCompletionStatus = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu");
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                respParam_jobMessages = pResponse.getResponseParameters().getItemByName("OPA_JobMessa");
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobMessa\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                respParam_jobResult = pResponse.getResponseParameters().getItemByName("OPA_JobResul");
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobResul\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                respParam_jobStatus = pResponse.getResponseParameters().getItemByName("OPA_JobStatu");
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting job out parameter with SHORT-NAME \"OPA_JobStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Retrieving values.");
            try {
                value_jobCompletionStatus = this.jobApi.createValue(14);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting value of job out parameter with SHORT-NAME \"OPA_JobComplStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                value_jobResult = this.jobApi.createValue(14);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting value of job output parameter with SHORT-NAME \"OPA_JobResul\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                value_jobStatus = this.jobApi.createValue(11);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting value of job output parameter with SHORT-NAME \"OPA_JobStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Setting values.");
            this.logger.debug("Setting job completion status: " + this.jobCompletionStatus);
            try {
                value_jobCompletionStatus.setValueAsString(this.jobCompletionStatus);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting value of job output parameter with SHORT-NAME \"OPA_JobComplStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.setJobInfo("Job completion status: " + this.jobCompletionStatus);
            if (this.jobStatus == AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION) {
                this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU did not respond within the timeout period.");
            } else if (this.jobStatus == AbstractJob.JobStatus.NEGATIVE_RESPONSE) {
                this.addJobMessage(respParam_jobMessages, "dynamic", "The ECU returned a negative response.");
            } else if (this.jobStatus == AbstractJob.JobStatus.WRONG_UBATT_DETECTED) {
                this.addJobMessage(respParam_jobMessages, "dynamic", "The voltage on terminal 30 is invalid.");
            } else if (this.jobStatus == AbstractJob.JobStatus.COMMUNICATION_DISTURBED) {
                this.addJobMessage(respParam_jobMessages, "dynamic", "Communication disturbed (error frames on bus).");
            } else {
                this.addJobMessage(respParam_jobMessages, "static", this.jobMessage);
            }
            this.addJobMessage(respParam_jobMessages, "dynamic", "Job runtime: " + this.getCurrentJobRuntimeAsString());
            this.addJobMessage(respParam_jobMessages, "dynamic", "Initial repetitions: " + this.numberOfInitialRepetitions);
            this.addJobMessage(respParam_jobMessages, "dynamic", "Total   repetitions: " + this.numberOfTotalRepetitions);
            this.addJobMessage(respParam_jobMessages, "dynamic", "Last value of STmin: " + this.separationTimeRequest + " \u00b5s");
            this.setJobInfo("Job runtime: " + this.getCurrentJobRuntimeAsString());
            this.setJobInfo("Initial repetitions: " + this.numberOfInitialRepetitions);
            this.setJobInfo("Total   repetitions: " + this.numberOfTotalRepetitions);
            this.setJobInfo("Last value of STmin: " + this.separationTimeRequest + " \u00b5s");
            this.logger.debug("Setting job result: " + this.jobResult);
            try {
                value_jobResult.setValueAsString(this.jobResult);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting value of job output parameter with SHORT-NAME \"OPA_JobResul\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.setJobInfo("Job result: " + this.jobResult);
            this.logger.debug("Setting job status: " + this.jobStatus);
            try {
                value_jobStatus.setUint32((long)this.jobStatus.intValue());
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting value of job output parameter with SHORT-NAME \"OPA_JobStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Setting output parameters.");
            try {
                respParam_jobCompletionStatus.setValue(value_jobCompletionStatus);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting parameter value of job output parameter with SHORT-NAME \"OPA_JobComplStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                respParam_jobResult.setValue(value_jobResult);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting parameter value of job output parameter with SHORT-NAME \"OPA_JobResul\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                respParam_jobStatus.setValue(value_jobStatus);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error setting parameter value of job output parameter with SHORT-NAME \"OPA_JobStatu\".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus addJobMessage(MCDResponseParameter pJobMessages, String pMessageType, String pMessage) {
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter respParam_jobMessage = null;
        MCDResponseParameters respParams_messageMuxBranchElements = null;
        MCDResponseParameters respParams_messageMux = null;
        MCDResponseParameter muxBranch = null;
        MCDResponseParameter respParam_messageType = null;
        MCDResponseParameter respParam_message = null;
        MCDValue value_messageType = null;
        MCDValue value_message = null;
        int messageDataType = 255;
        try {
            fieldElements = pJobMessages.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_jobMessage = fieldElements.addElement();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding job message to collection of job messages.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType = this.getLastResponseParameterOfFieldByName(respParam_jobMessage, "Param_MessaType");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested output parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_messageType.setValueAsString(pMessageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_messageType.setValue(value_messageType);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_MessaType.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = this.getLastResponseParameterOfFieldByName(pJobMessages, "Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMux = respParam_message.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            this.logger.debug("Adding MUX branch.");
            muxBranch = respParams_messageMux.addMuxBranch(Conversions.longName2ShortName("Case_", pMessageType));
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error adding branch to multiplexer in Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParams_messageMuxBranchElements = muxBranch.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameters of multiplexer branch of Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message = respParams_messageMuxBranchElements.getItemByName("Param_Messa");
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting nested parameter Param_Messa from multiplexer branch.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            value_message = this.jobApi.createValue(14);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            messageDataType = respParam_message.getType();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining MCD data type of nested output parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("MCDDataType of message: " + McdEnumDecoder.decodeMcdDataType(messageDataType));
        try {
            value_message.setValueAsString(pMessage);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            respParam_message.setValue(value_message);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error setting MCD value of nested parameter Param_Messa.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected AbstractJob.JobStatus readFlash(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readFlash(...).");
        try {
            this.dbFlashSessionName = pDbFlashSession.getShortName();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting SHORT-NAME of SESSION.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.dbFlashSessionName.startsWith("SESD_")) {
            this.sessionDescShortName = this.dbFlashSessionName;
        } else if (this.dbFlashSessionName.startsWith("SES_")) {
            this.sessionDescShortName = this.dbFlashSessionName.replaceFirst("SES_", "SESD_");
            this.logger.info("Generated SHORT-NAME of SESSION-DESC: " + this.sessionDescShortName);
        } else {
            this.logger.error("Unexpected SHORT-NAME of SESSION: Prefix is neither \"SESD_\" nor \"SES_\"!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            this.flashKey = pDbFlashSession.getFlashKey();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting flash key of SESSION.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Found SESSION: " + this.dbFlashSessionName + " (FlashKey: " + this.flashKey + ").");
        if (!this.readEcuMem(pDbFlashSession)) {
            this.logger.debug("Error reading ECU-MEM.");
            return AbstractJob.JobStatus.ERROR;
        }
        if (!this.readEcuMemConnector(pDbFlashSession)) {
            this.logger.debug("Error reading ECU-MEM-CONNECTOR.");
            return AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving readFlash(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected boolean readEcuMem(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readEcuMem(...).");
        if (!this.readMem(pDbFlashSession)) {
            this.logger.debug("Error reading MEM.");
            return false;
        }
        if (!this.readPhysMem(pDbFlashSession)) {
            this.logger.debug("Error reading PHYS-MEM.");
            return false;
        }
        this.logger.trace("Leaving readEcuMem(...).");
        return true;
    }

    protected boolean readEcuMemConnector(MCDDbFlashSession pDbFlashSession) {
        block15: {
            block14: {
                block13: {
                    block12: {
                        this.logger.trace("Entering readEcuMemConnector(...).");
                        boolean isDownloadSession = false;
                        try {
                            isDownloadSession = pDbFlashSession.isDownload();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining DIRECTION of SESSION.");
                            this.logger.logThrowable(mcde);
                        }
                        if (!isDownloadSession) {
                            this.logger.debug("DIRECTION of SESSION is *not* \"DOWNLOAD\".");
                            return false;
                        }
                        try {
                            pDbFlashSession.getDbFlashSessionsClasses();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining FLASH-SESSION-CLASSES of SESSION.");
                            if (VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && this.logger.getLogLevel() < 6 && (mcde.getError().getCode() == 57361 || mcde.getError().getCode() == 57363)) break block12;
                            this.logger.logThrowable(mcde);
                        }
                    }
                    try {
                        pDbFlashSession.getPriority();
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error determining PRIORITY of SESSION.");
                        if (VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && this.logger.getLogLevel() < 6 && mcde.getError().getCode() == 57363) break block13;
                        this.logger.logThrowable(mcde);
                    }
                }
                try {
                    this.vendorSpecific.getDbFlashJobOfDbFlashSession(pDbFlashSession, this.dbLocationOfLogicalLink);
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining flash job (DIAG-COMM-SNREF) for downloading the SESSION.");
                    if (VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && this.logger.getLogLevel() < 6 && mcde.getError().getCode() == 57363) break block14;
                    this.logger.logThrowable(mcde);
                }
            }
            if (this.numberOfExpectedIdents > 0L) {
                try {
                    pDbFlashSession.getDbExpectedIdents().getItemByIndex(0L).getReadDbIdentDescription();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining IDENT-DESCS for checking the IDENTS of the SESSION.");
                    if (VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && this.logger.getLogLevel() < 6 && mcde.getError().getCode() == 58642) break block15;
                    this.logger.logThrowable(mcde);
                }
            }
        }
        this.logger.trace("Leaving readEcuMemConnector(...).");
        return true;
    }

    protected boolean readMem(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readMem(...).");
        if (!this.readSession(pDbFlashSession)) {
            this.logger.debug("Error reading SESSION.");
            return false;
        }
        this.logger.trace("Leaving readMem(...).");
        return true;
    }

    protected boolean readPhysMem(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readPhysMem(...).");
        pDbFlashSession.hashCode();
        this.logger.trace("Leaving readPhysMem(...).");
        return true;
    }

    protected boolean readSession(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readSession(...).");
        if (this.isMcd20002Interface) {
            if (!this.readSpecialDataGroupsOfSession(pDbFlashSession)) {
                return false;
            }
        } else {
            this.logger.warn("Skipping all SDGS in ODX FLASH due to detected MCD3D 2.00.xx interface prior to 2.00.02!");
            this.logger.warn("=> Assuming ECU-MEM specification version prior to 3.0.0.");
            this.logger.warn("=> Assuming VW80126 specification version prior to 2.0.0.");
            this.ecuMemSpecVersion = "";
            this.vw80126Version = "1.x.x";
        }
        if (!this.readExpectedIdents(pDbFlashSession)) {
            return false;
        }
        if (!this.readChecksums(pDbFlashSession)) {
            return false;
        }
        if (!this.readSecurities(pDbFlashSession)) {
            return false;
        }
        if (!this.readDataBlocks(pDbFlashSession)) {
            return false;
        }
        this.logger.trace("Leaving readSession(...).");
        return true;
    }

    protected boolean readExpectedIdents(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readExpectedIdents(...).");
        try {
            this.dbExpectedIdents = pDbFlashSession.getDbExpectedIdents();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining EXPECTED-IDENTS of the SESSION.");
            if (!VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) || this.logger.getLogLevel() >= 6 || mcde.getError().getCode() != 57363) {
                this.logger.logThrowable(mcde);
            }
            return true;
        }
        try {
            this.numberOfExpectedIdents = this.dbExpectedIdents.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of EXPECTED-IDENTS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (this.numberOfExpectedIdents > 0L) {
            this.dbExpectedIdentDescription = new MCDDbIdentDescription[(int)this.numberOfExpectedIdents];
            try {
                this.dbExpectedIdents.getItemByIndex(0L).getIdentValues();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining IDENT-VALUES of EXPECTED-IDENTS.");
                this.logger.logThrowable(mcde);
                return false;
            }
        }
        this.logger.trace("Leaving readExpectedIdents(...).");
        return true;
    }

    protected boolean readChecksums(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readChecksums(...).");
        pDbFlashSession.hashCode();
        this.logger.trace("Leaving readChecksums(...).");
        return true;
    }

    protected boolean readSecurities(MCDDbFlashSession pDbFlashSession) {
        this.logger.trace("Entering readSecurities(...).");
        MCDDbFlashSecurities dbFlashSecurities = null;
        try {
            dbFlashSecurities = pDbFlashSession.getDbSecurities();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining SECURITYS of SESSION.");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (!this.readSecurityAccessAlgorithm(dbFlashSecurities)) {
            this.logger.fatal("Error reading SA2 record.");
            return false;
        }
        if (!this.readAddressAndLengthFormatIdentifiers(dbFlashSecurities)) {
            this.logger.fatal("Error reading addressAndLengthFormatIdentfiers (ALFIDs).");
            return false;
        }
        this.flashwareChecksums = new TreeMap();
        if (!this.readFlashwareChecksums(dbFlashSecurities)) {
            this.logger.fatal("Error reading FW-CHECKSUMS.");
            return false;
        }
        this.flashwareSignatures = new TreeMap();
        if (!this.readFlashwareSignatures(dbFlashSecurities)) {
            this.logger.fatal("Error reading FW-SIGNATURES.");
            return false;
        }
        this.logger.trace("Leaving readSecurities(...).");
        return true;
    }

    protected boolean readSecurityAccessAlgorithm(MCDDbFlashSecurities pDbFlashSecurities) {
        long numberOfDbFlashSecurities;
        MCDDbFlashSecurity dbFlashSecurity = null;
        MCDValue securityMethodValue = null;
        int securityMethodDataType = -1;
        String securityMethod = null;
        MCDValue sa2FlashWareSignature = null;
        int sa2FlashWareSignatureDataType = -1;
        String securityAlgorithm = null;
        this.logger.trace("Entering readSecurityAccessAlgorithm(...).");
        try {
            numberOfDbFlashSecurities = pDbFlashSecurities.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining number of SECURITYS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        for (long i = 0L; i < numberOfDbFlashSecurities && dbFlashSecurity == null; ++i) {
            try {
                dbFlashSecurity = pDbFlashSecurities.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error reading SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                securityMethodValue = dbFlashSecurity.getSecurityMethod();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining MCD value of SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                securityMethodDataType = securityMethodValue.getDataType();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting data type of SECURITY-METHOD.");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (securityMethodDataType != 1) {
                this.logger.fatal("Expected data type of SECURITY-METHOD is: " + McdEnumDecoder.decodeMcdDataType(1));
                this.logger.fatal("Current  data type of SECURITY-METHOD is: " + McdEnumDecoder.decodeMcdDataType(securityMethodDataType));
                return false;
            }
            try {
                securityMethod = securityMethodValue.getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining value of SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (securityMethod.equalsIgnoreCase("SA2")) continue;
            dbFlashSecurity = null;
        }
        if (dbFlashSecurity == null) {
            this.logger.fatal("Error locating SA2 record.");
            return false;
        }
        try {
            sa2FlashWareSignature = dbFlashSecurity.getFlashwareSignature();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error reading SA2 record ( FW-SIGNATURE) from SECURITY.");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            sa2FlashWareSignatureDataType = sa2FlashWareSignature.getDataType();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting data type of FW-SIGNATURE.");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (sa2FlashWareSignatureDataType != 3) {
            this.logger.fatal("Expected data type of FW-SIGNATURE is: " + McdEnumDecoder.decodeMcdDataType(3));
            this.logger.fatal("Current  data type of FW-SIGNATURE is: " + McdEnumDecoder.decodeMcdDataType(sa2FlashWareSignatureDataType));
            return false;
        }
        try {
            this.m_securityAlgorithm = sa2FlashWareSignature.getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error reading SA2 record (byte[]) from SECURITY.");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            securityAlgorithm = this.vendorSpecific.pduValue2String(sa2FlashWareSignature);
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error reading SA2 record (String) from SECURITY.");
            this.logger.logThrowable(mcde);
            return false;
        }
        this.logger.debug("SA2 algorithm is: " + securityAlgorithm);
        this.logger.trace("Leaving readSecurityAccessAlgorithm(...).");
        return true;
    }

    protected boolean readAddressAndLengthFormatIdentifiers(MCDDbFlashSecurities pDbFlashSecurities) {
        long numberOfDbFlashSecurities;
        MCDDbFlashSecurity dbFlashSecurity = null;
        MCDValue securityMethodValue = null;
        int securityMethodDataType = -1;
        String securityMethod = null;
        MCDValue alfidFlashWareSignature = null;
        int alfidFlashWareSignatureDataType = -1;
        byte[] addressAndLengthFormatIdentifiers = null;
        String addressAndLengthFormatIdentifiersAsString = null;
        this.logger.trace("Entering readAddressAndLengthFormatIdentifiers(...).");
        try {
            numberOfDbFlashSecurities = pDbFlashSecurities.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining number of SECURITYS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        for (long i = 0L; i < numberOfDbFlashSecurities && dbFlashSecurity == null; ++i) {
            try {
                dbFlashSecurity = pDbFlashSecurities.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error reading SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                securityMethodValue = dbFlashSecurity.getSecurityMethod();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining MCD value of SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                securityMethodDataType = securityMethodValue.getDataType();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting data type of SECURITY-METHOD.");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (securityMethodDataType != 1) {
                this.logger.fatal("Expected data type of SECURITY-METHOD is: " + McdEnumDecoder.decodeMcdDataType(1));
                this.logger.fatal("Current  data type of SECURITY-METHOD is: " + McdEnumDecoder.decodeMcdDataType(securityMethodDataType));
                return false;
            }
            try {
                securityMethod = securityMethodValue.getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining value of SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (securityMethod.equalsIgnoreCase("ALFID")) continue;
            dbFlashSecurity = null;
        }
        if (dbFlashSecurity == null) {
            this.logger.warn("Error locating addressAndLengthFormatIdentifiers (ALFIDs).");
            if (this.ecuMemSpecVersion.equals("3.0.0")) {
                this.logger.error("Aborting since ECUMEM_317 requires a SECURITY with SECURITY-METHOD=\"ALFID\"!");
                return false;
            }
            this.setALFIDbyShortName(this.dbEcuName);
        } else {
            try {
                alfidFlashWareSignature = dbFlashSecurity.getFlashwareSignature();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error reading ALFIDs (FW-SIGNATURE) from SECURITY.");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                alfidFlashWareSignatureDataType = alfidFlashWareSignature.getDataType();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error getting data type of FW-SIGNATURE.");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (alfidFlashWareSignatureDataType != 3) {
                this.logger.fatal("Expected data type of FW-SIGNATURE is: " + McdEnumDecoder.decodeMcdDataType(3));
                this.logger.fatal("Current  data type of FW-SIGNATURE is: " + McdEnumDecoder.decodeMcdDataType(alfidFlashWareSignatureDataType));
                return false;
            }
            try {
                addressAndLengthFormatIdentifiers = alfidFlashWareSignature.getBytefield();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error reading ALFIDs (byte[]) from SECURITY.");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                addressAndLengthFormatIdentifiersAsString = alfidFlashWareSignature.getValueAsString().trim();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error reading ALFIDs (String) from SECURITY.");
                this.logger.logThrowable(mcde);
                return false;
            }
            this.logger.fatal("ALFIDs are: " + addressAndLengthFormatIdentifiersAsString);
            if (this.vw80126Version.equals("2.0.0")) {
                if (addressAndLengthFormatIdentifiers.length != 2) {
                    this.logger.warn("Expected length of ALFIDs is: 2");
                    this.logger.warn("Current  length of ALFIDs is: " + addressAndLengthFormatIdentifiers.length);
                    if (addressAndLengthFormatIdentifiers.length < 2 || addressAndLengthFormatIdentifiers.length > 3) {
                        return false;
                    }
                    this.logger.warn("Ignoring superfluous 3rd byte (" + addressAndLengthFormatIdentifiersAsString.substring(4, 6) + ") since it is no longer used with RoutineControl/checkMemory.");
                }
            } else if (addressAndLengthFormatIdentifiers.length != 3) {
                this.logger.warn("Expected length of ALFIDs is: 2");
                this.logger.warn("Current  length of ALFIDs is: " + addressAndLengthFormatIdentifiers.length);
                if (addressAndLengthFormatIdentifiers.length == 2) {
                    this.logger.info("Assuming VW80126 v2.0 due to detected length of ALFIDs: 2");
                    this.vw80126Version = "2.0.0";
                } else {
                    return false;
                }
            }
            this.LFID_EM = (byte)(addressAndLengthFormatIdentifiers[0] >> 4 & 0xF);
            this.AFID_EM = (byte)(addressAndLengthFormatIdentifiers[0] & 0xF);
            this.LFID_RD = (byte)(addressAndLengthFormatIdentifiers[1] >> 4 & 0xF);
            this.AFID_RD = (byte)(addressAndLengthFormatIdentifiers[1] & 0xF);
            if (this.vw80126Version.equals("2.0.0")) {
                this.LFID_CM = 0;
                this.AFID_CM = 0;
            } else {
                this.LFID_CM = (byte)(addressAndLengthFormatIdentifiers[2] >> 4 & 0xF);
                this.AFID_CM = (byte)(addressAndLengthFormatIdentifiers[2] & 0xF);
            }
            this.LI_CM = (short)-1;
        }
        if (this.logger.getLogLevel() >= 5) {
            this.logger.debug("lengthFormatIdentifier  for RoutineControl/eraseMemory: " + this.LFID_EM);
            this.logger.debug("addressFormatIdentifier for RoutineControl/eraseMemory: " + this.AFID_EM);
            this.logger.debug("lengthFormatIdentifier  for RequestDownload           : " + this.LFID_RD);
            this.logger.debug("addressFormatIdentifier for RequestDownload           : " + this.AFID_RD);
            if (!this.vw80126Version.equals("2.0.0")) {
                this.logger.debug("lengthFormatIdentifier  for RoutineControl/checkMemory: " + this.LFID_CM);
                this.logger.debug("addressFormatIdentifier for RoutineControl/checkMemory: " + this.AFID_CM);
                this.logger.debug("lengthInformation       for RoutineControl/checkMemory: " + this.LI_CM);
            }
        }
        this.logger.trace("Leaving readAddressAndLengthFormatIdentifiers(...).");
        return true;
    }

    protected boolean readFlashwareChecksums(MCDDbFlashSecurities pDbFlashSecurities) {
        long numberOfDbFlashSecurities = 0L;
        MCDDbFlashSecurity dbFlashSecurity = null;
        MCDValue securityMethodValue = null;
        int securityMethodDataType = -1;
        String securityMethod = null;
        MCDValue validityForValue = null;
        int validityForDataType = -1;
        String dataBlockName = null;
        MCDValue flashWareChecksumValue = null;
        int flashWareChecksumDataType = -1;
        byte[] currentFlashwareChecksum = null;
        this.logger.trace("Entering readFlashwareChecksums(...).");
        try {
            numberOfDbFlashSecurities = pDbFlashSecurities.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining number of SECURITYS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        for (long i = 0L; i < numberOfDbFlashSecurities; ++i) {
            try {
                dbFlashSecurity = pDbFlashSecurities.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                securityMethodValue = dbFlashSecurity.getSecurityMethod();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining MCD value of SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                securityMethodDataType = securityMethodValue.getDataType();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining data type of SECURITY-METHOD for SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (securityMethodDataType != 1) {
                this.logger.fatal("Expected data type of SECURITY-METHOD is: " + McdEnumDecoder.decodeMcdDataType(1));
                this.logger.fatal("Current  data type of SECURITY-METHOD is: " + McdEnumDecoder.decodeMcdDataType(securityMethodDataType));
                return false;
            }
            try {
                securityMethod = securityMethodValue.getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining value of SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (!securityMethod.equalsIgnoreCase("SA2") && !securityMethod.equalsIgnoreCase("ALFID")) {
                block37: {
                    try {
                        validityForValue = dbFlashSecurity.getValidity();
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error determining MCD value of VALIDITY-FOR for SECURITY with index " + i + ".");
                        this.logger.logThrowable(mcde);
                        return false;
                    }
                    try {
                        validityForDataType = validityForValue.getDataType();
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error determining data type of VALIDITY-FOR for SECURITY with index " + i + ".");
                        this.logger.logThrowable(mcde);
                        return false;
                    }
                    if (validityForDataType != 1) {
                        this.logger.fatal("Expected data type of VALIDITY-FOR is: " + McdEnumDecoder.decodeMcdDataType(1));
                        this.logger.fatal("Current  data type of VALIDITY-FOR is: " + McdEnumDecoder.decodeMcdDataType(validityForDataType));
                        return false;
                    }
                    try {
                        dataBlockName = validityForValue.getValueAsString();
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error determining value of VALIDITY-FOR for SECURITY with index " + i + ".");
                        this.logger.logThrowable(mcde);
                        return false;
                    }
                    this.logger.debug("Found SECURITY for DATABLOCK \"" + dataBlockName + "\".");
                    try {
                        flashWareChecksumValue = dbFlashSecurity.getFlashwareChecksum();
                        this.logger.debug("Found FW-CHECKSUM for DATABLOCK \"" + dataBlockName + "\".");
                        try {
                            flashWareChecksumDataType = flashWareChecksumValue.getDataType();
                        }
                        catch (MCDException mcde) {
                            flashWareChecksumDataType = -1;
                            this.logger.warn("Found no FW-CHECKSUM for SECURITY with index " + i + ".");
                            if (securityMethod.substring(0, 3).equalsIgnoreCase("SIG")) {
                                this.logger.debug("Ignoring missing FW-CHECKSUM for signed data block \"" + dataBlockName + "\" since it does not neccessarily need one.");
                                currentFlashwareChecksum = new byte[]{};
                            }
                            this.logger.fatal("Error determining data type of FW-CHECKSUM for unsigned data block \"" + dataBlockName + "\".");
                            this.logger.logThrowable(mcde);
                            return false;
                        }
                        if (flashWareChecksumDataType != 3) {
                            this.logger.warn("TYPE of FW-CHECKSUM does not match expected TYPE!");
                            this.logger.warn("- expected data type of FW-CHECKSUM is: " + McdEnumDecoder.decodeMcdDataType(3));
                            this.logger.warn("- current  data type of FW-CHECKSUM is: " + McdEnumDecoder.decodeMcdDataType(flashWareChecksumDataType));
                            if (securityMethod.substring(0, 3).equalsIgnoreCase("SIG")) {
                                this.logger.debug("Ignoring data type mismatch of FW-CHECKSUM for signed data block \"" + dataBlockName + "\" since it does not neccessarily need a FW-CHECKSUM.");
                                currentFlashwareChecksum = new byte[]{};
                                break block37;
                            }
                            this.logger.fatal("Error determining data type of FW-CHECKSUM for unsigned data block \"" + dataBlockName + "\" due to TYPE mismatch of the FW-CHECKSUM.");
                            return false;
                        }
                        try {
                            currentFlashwareChecksum = flashWareChecksumValue.getBytefield();
                        }
                        catch (MCDException mcde) {
                            this.logger.fatal("Error reading value of FW-CHECKSUM for SECURITY with index " + i + ".");
                            this.logger.logThrowable(mcde);
                            return false;
                        }
                    }
                    catch (MCDException mcde) {
                        if (!securityMethod.substring(0, 3).equalsIgnoreCase("SIG")) {
                            this.logger.fatal("Error reading MCD value of FW-CHECKSUM for SECURITY with index " + i + ".");
                            this.logger.logThrowable(mcde);
                            return false;
                        }
                        this.logger.warn("Found no FW-CHECKSUM for SECURITY with index " + i + ".");
                        currentFlashwareChecksum = new byte[]{};
                    }
                }
                if (currentFlashwareChecksum != null) {
                    this.logger.debug("currentFlashwareChecksum.length: " + currentFlashwareChecksum.length);
                }
                this.logger.debug("lengthInformation: " + this.LI_CM);
                if (currentFlashwareChecksum != null) {
                    if (this.LI_CM != -1 && currentFlashwareChecksum.length != this.LI_CM) {
                        int j;
                        this.logger.warn("Adapting FW-CHECKSUM to lengthInformation - check your ECU-MEM container for correct length!!!");
                        byte[] newFlashwareChecksum = null;
                        newFlashwareChecksum = new byte[this.LI_CM];
                        for (j = 0; j < this.LI_CM; ++j) {
                            newFlashwareChecksum[j] = 0;
                        }
                        for (j = 0; j < newFlashwareChecksum.length && j < currentFlashwareChecksum.length; ++j) {
                            newFlashwareChecksum[newFlashwareChecksum.length - 1 - j] = currentFlashwareChecksum[currentFlashwareChecksum.length - 1 - j];
                        }
                        this.flashwareChecksums.put(dataBlockName, newFlashwareChecksum);
                    } else {
                        this.flashwareChecksums.put(dataBlockName, currentFlashwareChecksum);
                    }
                }
            }
            Iterator iterator = this.flashwareChecksums.keySet().iterator();
            while (iterator.hasNext()) {
                this.logger.debug("FW-CHECKSUM map contains DATABLOCK: " + (String)iterator.next());
            }
        }
        this.logger.trace("Leaving readFlashwareChecksums(...).");
        return true;
    }

    protected boolean readFlashwareSignatures(MCDDbFlashSecurities pDbFlashSecurities) {
        long numberOfDbFlashSecurities = 0L;
        MCDDbFlashSecurity dbFlashSecurity = null;
        MCDValue securityMethodValue = null;
        int securityMethodDataType = -1;
        String securityMethod = null;
        MCDValue validityForValue = null;
        int validityForDataType = -1;
        String dataBlockName = null;
        MCDValue flashWareSignatureValue = null;
        int flashWareSignatureDataType = -1;
        byte[] currentFlashwareSignature = null;
        this.logger.trace("Entering readFlashwareSignatures(...).");
        try {
            numberOfDbFlashSecurities = pDbFlashSecurities.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error determining number of SECURITYS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        for (long i = 0L; i < numberOfDbFlashSecurities; ++i) {
            try {
                dbFlashSecurity = pDbFlashSecurities.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                securityMethodValue = dbFlashSecurity.getSecurityMethod();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining MCD value of SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                securityMethodDataType = securityMethodValue.getDataType();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining data type of SECURITY-METHOD for SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (securityMethodDataType != 1) {
                this.logger.fatal("Expected data type of SECURITY-METHOD is: " + McdEnumDecoder.decodeMcdDataType(1));
                this.logger.fatal("Current  data type of SECURITY-METHOD is: " + McdEnumDecoder.decodeMcdDataType(securityMethodDataType));
                return false;
            }
            try {
                securityMethod = securityMethodValue.getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining value of SECURITY-METHOD of SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (!securityMethod.substring(0, 3).equalsIgnoreCase("SIG")) continue;
            try {
                validityForValue = dbFlashSecurity.getValidity();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining MCD value of VALIDITY-FOR for SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                validityForDataType = validityForValue.getDataType();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining data type of VALIDITY-FOR for SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (validityForDataType != 1) {
                this.logger.fatal("Expected data type of VALIDITY-FOR is: " + McdEnumDecoder.decodeMcdDataType(1));
                this.logger.fatal("Current  data type of VALIDITY-FOR is: " + McdEnumDecoder.decodeMcdDataType(validityForDataType));
                return false;
            }
            try {
                dataBlockName = validityForValue.getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining value of VALIDITY-FOR for SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            this.logger.debug("Found SECURITY for DATABLOCK \"" + dataBlockName + "\".");
            try {
                flashWareSignatureValue = dbFlashSecurity.getFlashwareSignature();
                this.logger.debug("Found FW-SIGNATURE for DATABLOCK \"" + dataBlockName + "\".");
            }
            catch (MCDException mcde) {
                if (securityMethod.startsWith("SIG_DSDG2") && VendorSpecific.getServerVendor() == DServerVendor.DSA && mcde.getError().getCode() == 57362 && mcde.getError().getVendorCode() == 12289) {
                    this.logger.debug("Searching external FW-SIGNATURE for FDS project ID " + this.fdsProjectIdEcu + " / " + this.fdsKeyTypeEcu + " / " + this.dbFlashSessionName + " / " + dataBlockName);
                    FdsProject fdsProject = this.fds.getFdsProjectById(this.fdsProjectIdEcu);
                    FdsSignatures fdsSignatures = fdsProject.getFdsSignaturesBySessionDescShortNameAndType(this.sessionDescShortName, this.fdsKeyTypeEcu);
                    FdsSignature fdsSignature = fdsSignatures.getFdsSignatureByDataBlockShortName(dataBlockName);
                    currentFlashwareSignature = fdsSignature.getFwSignature();
                    this.flashwareSignatures.put(dataBlockName, currentFlashwareSignature);
                }
                this.logger.error("Error reading MCD value of FW-SIGNATURE for SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (flashWareSignatureValue == null) continue;
            try {
                flashWareSignatureDataType = flashWareSignatureValue.getDataType();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error determining data type of FW-SIGNATURE for SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (flashWareSignatureDataType != 3) {
                this.logger.fatal("Expected data type of FW-SIGNATURE is: " + McdEnumDecoder.decodeMcdDataType(3));
                this.logger.fatal("Current  data type of FW-SIGNATURE is: " + McdEnumDecoder.decodeMcdDataType(flashWareSignatureDataType));
                if (securityMethod.startsWith("SIG_DSDG2") && VendorSpecific.getServerVendor() == DServerVendor.SOFTING && flashWareSignatureDataType == 255) {
                    this.logger.debug("Searching external FW-SIGNATURE for FDS project ID " + this.fdsProjectIdEcu + " / " + this.fdsKeyTypeEcu + " / " + this.dbFlashSessionName + " / " + dataBlockName);
                    FdsProject fdsProject = this.fds.getFdsProjectById(this.fdsProjectIdEcu);
                    FdsSignatures fdsSignatures = fdsProject.getFdsSignaturesBySessionDescShortNameAndType(this.dbFlashSessionName, this.fdsKeyTypeEcu);
                    FdsSignature fdsSignature = fdsSignatures.getFdsSignatureByDataBlockShortName(dataBlockName);
                    currentFlashwareSignature = fdsSignature.getFwSignature();
                    this.flashwareSignatures.put(dataBlockName, currentFlashwareSignature);
                    continue;
                }
                return false;
            }
            try {
                currentFlashwareSignature = flashWareSignatureValue.getBytefield();
            }
            catch (MCDException mcde) {
                this.logger.fatal("Error reading value of FW-SIGNATURE for SECURITY with index " + i + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            this.logger.debug("Length of FW-SIGNATURE is " + currentFlashwareSignature.length + ".");
            this.flashwareSignatures.put(dataBlockName, currentFlashwareSignature);
        }
        Iterator iterator = this.flashwareSignatures.keySet().iterator();
        while (iterator.hasNext()) {
            this.logger.debug("FW-SIGNATURE map contains DATABLOCK: " + (String)iterator.next());
        }
        this.logger.trace("Leaving readFlashwareSignatures(...).");
        return true;
    }

    protected boolean readDataBlocks(MCDDbFlashSession pDbFlashSession) {
        MCDDbFlashDataBlocks dbFlashDataBlocks = null;
        this.logger.trace("Entering readDataBlocks(...).");
        try {
            dbFlashDataBlocks = pDbFlashSession.getDbDataBlocks();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error reading DATABLOCKS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            this.numberOfDataBlocks = (int)dbFlashDataBlocks.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of DATABLOCKS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (this.numberOfDataBlocks == 0) {
            this.logger.error("Got 0 DATABLOCKS from SESSION... make sure that all DATABLOCK-REFs in your ECU-MEM are resolved!");
            return false;
        }
        this.dataBlockShortNames = new HashMap();
        this.dbDataBlocks = new MCDDbFlashDataBlock[this.numberOfDataBlocks];
        this.dataBlockType = new String[this.numberOfDataBlocks];
        this.dbFlashData = new MCDDbFlashData[this.numberOfDataBlocks];
        this.flashDataFormat = new int[this.numberOfDataBlocks];
        this.numberOfFlashSegments = new int[this.numberOfDataBlocks];
        this.compressionMethod = new String[this.numberOfDataBlocks];
        this.encryptionMethod = new String[this.numberOfDataBlocks];
        this.dbFlashFilters = new MCDDbFlashFilters[this.numberOfDataBlocks];
        this.dbFlashFilter = new MCDDbFlashFilter[this.numberOfDataBlocks][];
        this.dbFlashFilterStart = new long[this.numberOfDataBlocks][];
        this.dbFlashFilterSize = new long[this.numberOfDataBlocks][];
        this.dbFlashSegments = new MCDDbFlashSegments[this.numberOfDataBlocks];
        this.dbFlashSegment = new MCDDbFlashSegment[this.numberOfDataBlocks][];
        this.logicalBlockIndex = new byte[this.numberOfDataBlocks][];
        this.sourceStartAddress = new long[this.numberOfDataBlocks][];
        this.uncompressedSize = new long[this.numberOfDataBlocks][];
        this.compressedSize = new long[this.numberOfDataBlocks][];
        this.binaryData = new byte[this.numberOfDataBlocks][][];
        this.dbFlashSegmentSize = new int[this.numberOfDataBlocks][];
        this.dbOwnIdents = new MCDDbFlashIdents[this.numberOfDataBlocks];
        this.dbOwnIdentDescription = new MCDDbIdentDescription[this.numberOfDataBlocks][];
        this.flashwareChecksum = new byte[this.numberOfDataBlocks][];
        this.flashwareSignature = new byte[this.numberOfDataBlocks][];
        for (int i = 0; i < this.numberOfDataBlocks; ++i) {
            this.logger.debug("Reading block " + i + ".");
            if (this.readDataBlockByIndex(dbFlashDataBlocks, i)) continue;
            this.logger.debug("Error reading DATABLOCK with index " + i + ".");
            return false;
        }
        this.logger.debug("Total number of bytes to transfer: " + this.totalNumberOfBytesToTransfer);
        this.setJobInfo("Total number of bytes to transfer: " + this.totalNumberOfBytesToTransfer);
        this.logger.trace("Leaving readDataBlocks(...).");
        return true;
    }

    protected boolean readDataBlockByIndex(MCDDbFlashDataBlocks pDbFlashDataBlocks, int pIndex) {
        block29: {
            String dataBlockName = null;
            byte[] fwChecksum = null;
            this.logger.trace("Entering readDataBlockByIndex(...).");
            try {
                this.dbDataBlocks[pIndex] = pDbFlashDataBlocks.getItemByIndex((long)pIndex);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error reading DATABLOCK with index " + pIndex + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                this.dataBlockType[pIndex] = this.dbDataBlocks[pIndex].getDataBlockType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining TYPE of DATABLOCK with index " + pIndex + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                dataBlockName = this.dbDataBlocks[pIndex].getShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining SHORT-NAME of DATABLOCK with index " + pIndex + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            this.dataBlockShortNames.put(this.dbDataBlocks[pIndex], dataBlockName);
            if (!this.dataBlockType[pIndex].equalsIgnoreCase("ERASE")) {
                Iterator i = this.flashwareChecksums.keySet().iterator();
                while (i.hasNext()) {
                    this.logger.debug("FW-CHECKSUM map contains DATABLOCK: " + (String)i.next());
                }
                if (this.flashwareChecksums.containsKey(dataBlockName)) {
                    fwChecksum = (byte[])this.flashwareChecksums.get(dataBlockName);
                    if (fwChecksum != null) {
                        this.flashwareChecksum[pIndex] = fwChecksum;
                    } else {
                        this.logger.error("Internal error getting FW-CHECKSUM of DATABLOCK \"" + dataBlockName + "\".");
                        if (!this.dbEcuName.startsWith("EV_KombiVW")) {
                            return false;
                        }
                    }
                } else if (this.flashwareSignatures.containsKey(dataBlockName)) {
                    fwChecksum = (byte[])this.flashwareSignatures.get(dataBlockName);
                    if (fwChecksum != null) {
                        this.flashwareChecksum[pIndex] = fwChecksum;
                    } else {
                        this.logger.error("Internal error getting FW-SIGNATURE of DATABLOCK \"" + dataBlockName + "\".");
                        if (this.dbEcuName.startsWith("EV_KombiVW")) {
                            return false;
                        }
                    }
                }
            }
            try {
                this.dbFlashData[pIndex] = this.dbDataBlocks[pIndex].getDbFlashData();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error reading FLASHDATA for DATABLOCK with index " + pIndex + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                this.dbFlashFilters[pIndex] = this.dbDataBlocks[pIndex].getDbFlashFilters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error reading FILTERS for DATABLOCK with index " + pIndex + ".");
                if (VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && this.logger.getLogLevel() < 6 && (mcde.getError().getCode() == 57361 || mcde.getError().getCode() == 57363)) break block29;
                this.logger.logThrowable(mcde);
            }
        }
        try {
            this.dbFlashSegments[pIndex] = this.dbDataBlocks[pIndex].getDbFlashSegments();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error reading SEGMENTS for DATABLOCK with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (!this.readFlashDataByDataBlockIndex(pIndex)) {
            this.logger.debug("Error reading FLASHDATA of DATABLOCK " + pIndex + ".");
            return false;
        }
        if (this.ecuMemSpecVersion.equalsIgnoreCase("3.0.0")) {
            if (this.isMcd20002Interface) {
                if (!this.readSpecialDataGroupsOfDataBlockByIndex(pIndex)) {
                    this.logger.debug("Error reading SDGs of DATABLOCK " + pIndex + ".");
                    return false;
                }
            } else {
                this.logger.error("Unable to read flash container with detected MCD3D 2.00.xx interface prior to 2.00.02!");
                return false;
            }
        }
        if (!this.readFlashSegmentsByDataBlockIndex(pIndex)) {
            this.logger.debug("Error reading SEGMENTS of DATABLOCK " + pIndex + ".");
            return false;
        }
        this.logger.trace("Leaving readDataBlockByIndex(...).");
        return true;
    }

    protected boolean readFlashDataByDataBlockIndex(int pIndex) {
        byte[] encryptionCompressionMethod = null;
        byte compressMethod = -1;
        byte encryptMethod = -1;
        this.logger.trace("Entering readFlashDataByDataBlockIndex(...).");
        try {
            this.flashDataFormat[pIndex] = this.dbFlashData[pIndex].getDataFormat();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error reading DATAFORMAT of DATABLOCK with index " + pIndex);
            this.logger.logThrowable(mcde);
            return false;
        }
        if (this.flashDataFormat[pIndex] != 27393) {
            this.logger.fatal("DATAFORMAT of DATABLOCK with index " + pIndex + " is *not* \"BINARY\".");
            return false;
        }
        try {
            encryptionCompressionMethod = this.dbFlashData[pIndex].getEncryptionCompressionMethod().getBytefield();
            this.logger.debug("Read ENCRYPT-COMPRESS-METHOD: " + Conversions.byteArray2String(encryptionCompressionMethod));
        }
        catch (MCDException mcde) {
            this.logger.warn("Error reading ENCRYPT-COMPRESS-METHOD of DATABLOCK with index " + pIndex + " - assuming Uncompressed/Unencrypted!");
            this.compressionMethod[pIndex] = "Uncompressed";
            this.encryptionMethod[pIndex] = "Unencrypted";
            return true;
        }
        if (encryptionCompressionMethod.length != 1) {
            this.logger.debug("ENCRYPT-COMPRESS-METHOD has invalid length of " + encryptionCompressionMethod.length + " bytes.");
            return false;
        }
        compressMethod = (byte)(encryptionCompressionMethod[0] >>> 4 & 0xF);
        this.compressionMethod[pIndex] = RequestParameterValue.RequeDownl.CompressionMethod.toString(compressMethod);
        this.logger.debug("Read compressionMethod: " + this.compressionMethod[pIndex]);
        encryptMethod = (byte)(encryptionCompressionMethod[0] & 0xF);
        this.encryptionMethod[pIndex] = RequestParameterValue.RequeDownl.EncryptionMethod.toString(encryptMethod);
        this.logger.debug("Read encryptionMethod: " + this.encryptionMethod[pIndex]);
        this.logger.trace("Leaving readFlashDataByDataBlockIndex(...).");
        return true;
    }

    protected boolean readSpecialDataGroupsOfDataBlockByIndex(int pIndex) {
        SpecialDataGroupHelperImpl sdgHelper = null;
        String numberOfDataBlock = null;
        String expectedSdgCaption = null;
        MCDDbSpecialDataGroups dbSpecialDataGroups = null;
        TreeMap specialDataElementsLogicalBlockIndex = null;
        String logicalBlockIndexAsString = null;
        this.logger.trace("Entering readSpecialDataGroupsOfDataBlock(...).");
        sdgHelper = new SpecialDataGroupHelperImpl(this.logger, (VendorSpecificMCD20002)((Object)this.vendorSpecific));
        numberOfDataBlock = this.getNumberOfFlashDataBlockFromLongName(this.dbDataBlocks[pIndex]);
        if (numberOfDataBlock == null) {
            this.logger.error("Error determining number of the DATA-BLOCK.");
            return false;
        }
        try {
            dbSpecialDataGroups = this.dbDataBlocks[pIndex].getDbSDGs();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining SDGS of the DATA-BLOCK.");
            this.logger.logThrowable(mcde);
            return false;
        }
        expectedSdgCaption = "SDGC_LOGICBLOCKINDEXDB" + numberOfDataBlock;
        specialDataElementsLogicalBlockIndex = new TreeMap();
        if (!sdgHelper.getSpecialDataElementsFromSpecialDataGroupsByCaption(dbSpecialDataGroups, expectedSdgCaption, specialDataElementsLogicalBlockIndex)) {
            return false;
        }
        if (specialDataElementsLogicalBlockIndex.isEmpty()) {
            expectedSdgCaption = "SDGC_LOGICBLOCKINDEX" + numberOfDataBlock;
            specialDataElementsLogicalBlockIndex.clear();
            if (!sdgHelper.getSpecialDataElementsFromSpecialDataGroupsByCaption(dbSpecialDataGroups, expectedSdgCaption, specialDataElementsLogicalBlockIndex)) {
                return false;
            }
            if (specialDataElementsLogicalBlockIndex.isEmpty()) {
                return false;
            }
        }
        if (specialDataElementsLogicalBlockIndex.containsKey("LOGICAL-BLOCK-INDEX")) {
            logicalBlockIndexAsString = (String)specialDataElementsLogicalBlockIndex.get("LOGICAL-BLOCK-INDEX");
            try {
                this.logicalBlockIndex[pIndex] = Conversions.hexString2ByteArray(logicalBlockIndexAsString);
            }
            catch (IllegalArgumentException iae) {
                this.logger.error("Error converting LOGICAL-BLOCK-INDEX '" + logicalBlockIndexAsString + "' to byte[]!");
                return false;
            }
        } else {
            this.logger.error("Error determining LOGICAL-BLOCK-INDEX from SDGS of DATA-BLOCK.");
            return false;
        }
        this.logger.trace("Leaving readSpecialDataGroupsOfDataBlock(...).");
        return true;
    }

    protected String getNumberOfFlashDataBlockFromLongName(MCDDbFlashDataBlock pDbFlashDataBlock) {
        String dbFlashDataBlockLongName = null;
        String numberOfDataBlock = null;
        String[] partsOfNumberOfDataBlock = null;
        this.logger.trace("Entering getNumberOfFlashDataBlockFromLongName(...).");
        dbFlashDataBlockLongName = pDbFlashDataBlock.getLongName();
        if (dbFlashDataBlockLongName == null) {
            this.logger.debug("LONG-NAME of the DATA-BLOCK is null!");
            return this.getNumberOfFlashDataBlockFromShortName(pDbFlashDataBlock);
        }
        if (dbFlashDataBlockLongName.trim().length() == 0) {
            this.logger.debug("LONG-NAME of the DATA-BLOCK is empty!");
            return this.getNumberOfFlashDataBlockFromShortName(pDbFlashDataBlock);
        }
        numberOfDataBlock = dbFlashDataBlockLongName.trim();
        if (numberOfDataBlock.endsWith("ERASE_PROGRAMMING_ROUTINE".replaceAll("_", " "))) {
            numberOfDataBlock = numberOfDataBlock.substring(0, numberOfDataBlock.length() - "ERASE_PROGRAMMING_ROUTINE".length());
        } else if (numberOfDataBlock.endsWith("ERASE_ROUTINE".replaceAll("_", " "))) {
            numberOfDataBlock = numberOfDataBlock.substring(0, numberOfDataBlock.length() - "ERASE_ROUTINE".length());
        } else if (numberOfDataBlock.endsWith("FLASH_DATA".replaceAll("_", " "))) {
            numberOfDataBlock = numberOfDataBlock.substring(0, numberOfDataBlock.length() - "FLASH_DATA".length());
        } else if (numberOfDataBlock.endsWith("PROGRAMMING_ROUTINE".replaceAll("_", " "))) {
            numberOfDataBlock = numberOfDataBlock.substring(0, numberOfDataBlock.length() - "PROGRAMMING_ROUTINE".length());
        } else {
            this.logger.debug("Error extracting data block number from LONG-NAME '" + dbFlashDataBlockLongName + "'... probably due to missing trailing space or unknown data block type (after block number) in LONG-NAME (see ECUMEM_165)!");
            return null;
        }
        if (!numberOfDataBlock.endsWith(" ")) {
            this.logger.debug("Error extracting data block number from LONG-NAME '" + dbFlashDataBlockLongName + "'... probably due to missing trailing space or unknown data block type (after block number) in LONG-NAME (see ECUMEM_165)!");
            return null;
        }
        numberOfDataBlock = numberOfDataBlock.substring(0, numberOfDataBlock.length() - 1);
        if (numberOfDataBlock.indexOf(" ") == -1) {
            if (numberOfDataBlock.length() > 5) {
                this.logger.debug("Error extracting data block number from LONG-NAME '" + dbFlashDataBlockLongName + "' due to a LONG-NAME part that exceeds 5 characters (see ECUMEM_523)!");
                return null;
            }
        } else {
            partsOfNumberOfDataBlock = numberOfDataBlock.split(" ");
            for (int i = 0; i < partsOfNumberOfDataBlock.length; ++i) {
                if (partsOfNumberOfDataBlock[i].length() <= 5) continue;
                this.logger.debug("Error extracting data block number from LONG-NAME '" + dbFlashDataBlockLongName + "' due to '" + partsOfNumberOfDataBlock[i] + "' in the LONG-NAME which exceeds 5 characters (see ECUMEM_523)!");
                return null;
            }
            numberOfDataBlock = numberOfDataBlock.replaceAll(" ", "");
        }
        if (numberOfDataBlock.length() % 2 != 0) {
            this.logger.debug("Error extracting data block number from LONG-NAME '" + dbFlashDataBlockLongName + "' due to odd number of characters in '" + numberOfDataBlock + "'!");
            return null;
        }
        if (!numberOfDataBlock.toUpperCase().matches("([0-9A-F]{2}){1,2}")) {
            this.logger.debug("Error extracting data block number from LONG-NAME '" + dbFlashDataBlockLongName + "' due to contained non-hex characters (see ECUMEM_395)!");
            return null;
        }
        this.logger.debug("Number of DATA-BLOCK: " + numberOfDataBlock);
        this.logger.trace("Leaving getNumberOfFlashDataBlockFromLongName(...).");
        return numberOfDataBlock;
    }

    protected String getNumberOfFlashDataBlockFromShortName(MCDDbFlashDataBlock pDbFlashDataBlock) {
        String dbFlashDataBlockShortName = null;
        String numberOfDataBlock = null;
        this.logger.trace("Entering getNumberOfFlashDataBlockFromShortName(...).");
        try {
            dbFlashDataBlockShortName = pDbFlashDataBlock.getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting SHORT-NAME of the DATA-BLOCK!");
            this.logger.logThrowable(mcde);
        }
        if (dbFlashDataBlockShortName == null) {
            this.logger.debug("SHORT-NAME of the DATA-BLOCK is null!");
        } else {
            numberOfDataBlock = dbFlashDataBlockShortName;
            if (numberOfDataBlock.startsWith("DB_")) {
                numberOfDataBlock = numberOfDataBlock.substring("DB_".length());
            }
            if (numberOfDataBlock.endsWith(Conversions.longName2ShortName("", "ERASE_PROGRAMMING_ROUTINE"))) {
                numberOfDataBlock = numberOfDataBlock.substring(0, numberOfDataBlock.length() - Conversions.longName2ShortName("", "ERASE_PROGRAMMING_ROUTINE").length());
            } else if (numberOfDataBlock.endsWith(Conversions.longName2ShortName("", "ERASE_ROUTINE"))) {
                numberOfDataBlock = numberOfDataBlock.substring(0, numberOfDataBlock.length() - Conversions.longName2ShortName("", "ERASE_ROUTINE").length());
            } else if (numberOfDataBlock.endsWith(Conversions.longName2ShortName("", "FLASH_DATA"))) {
                numberOfDataBlock = numberOfDataBlock.substring(0, numberOfDataBlock.length() - Conversions.longName2ShortName("", "FLASH_DATA").length());
            } else if (numberOfDataBlock.endsWith(Conversions.longName2ShortName("", "PROGRAMMING_ROUTINE"))) {
                numberOfDataBlock = numberOfDataBlock.substring(0, numberOfDataBlock.length() - Conversions.longName2ShortName("", "PROGRAMMING_ROUTINE").length());
            } else {
                this.logger.debug("Error extracting data block number from SHORT-NAME '" + dbFlashDataBlockShortName + "'... probably due to unknown data block type (after block number) in SHORT-NAME (see ECUMEM_165)!");
                return null;
            }
            if (numberOfDataBlock.length() % 2 != 0) {
                this.logger.debug("Error extracting data block number from SHORT-NAME '" + dbFlashDataBlockShortName + "' due to odd number of characters in '" + numberOfDataBlock + "'!");
                return null;
            }
            if (!numberOfDataBlock.toUpperCase().matches("([0-9A-F]{2}){1,2}")) {
                this.logger.debug("Error extracting data block number from SHORT-NAME '" + dbFlashDataBlockShortName + "' due to contained non-hex characters (see ECUMEM_395)!");
                return null;
            }
            this.logger.debug("Number of DATA-BLOCK: " + numberOfDataBlock);
        }
        this.logger.trace("Leaving getNumberOfFlashDataBlockFromShortName(...).");
        return numberOfDataBlock;
    }

    protected boolean readFlashSegmentsByDataBlockIndex(int pIndex) {
        this.logger.trace("Entering readFlashSegmentsByDataBlockIndex(...).");
        try {
            this.numberOfFlashSegments[pIndex] = (int)this.dbFlashSegments[pIndex].getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of SEGMENTS.");
            this.logger.logThrowable(mcde);
            return false;
        }
        this.dbFlashSegment[pIndex] = new MCDDbFlashSegment[this.numberOfFlashSegments[pIndex]];
        this.dbFlashSegmentSize[pIndex] = new int[this.numberOfFlashSegments[pIndex]];
        this.sourceStartAddress[pIndex] = new long[this.numberOfFlashSegments[pIndex]];
        this.uncompressedSize[pIndex] = new long[this.numberOfFlashSegments[pIndex]];
        if (!this.dataBlockType[pIndex].equalsIgnoreCase("ERASE")) {
            if (!this.compressionMethod[pIndex].equals("Uncompressed")) {
                this.compressedSize[pIndex] = new long[this.numberOfFlashSegments[pIndex]];
            }
            this.binaryData[pIndex] = new byte[this.numberOfFlashSegments[pIndex]][];
        }
        for (int i = 0; i < this.numberOfFlashSegments[pIndex]; ++i) {
            this.logger.debug("Reading segment " + i + ".");
            try {
                this.dbFlashSegment[pIndex][i] = this.dbFlashSegments[pIndex].getItemByIndex((long)i);
            }
            catch (MCDException mcde) {
                this.logger.warn("Error reading SEGMENT with index " + i + " of DATABLOCK with index " + pIndex + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                this.sourceStartAddress[pIndex][i] = this.dbFlashSegment[pIndex][i].getSourceStartAddress();
            }
            catch (MCDException mcde) {
                this.logger.warn("Error determining SOURCE-START-ADDRESS of SEGMENT with index " + i + " of DATABLOCK with index " + pIndex + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                this.uncompressedSize[pIndex][i] = this.dbFlashSegment[pIndex][i].getUncompressedSize();
            }
            catch (MCDException mcde) {
                this.logger.warn("Error determining UNCOMPRESSED-SIZE of SEGMENT with index " + i + " of DATABLOCK with index " + pIndex + ".");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (this.dataBlockType[pIndex].equalsIgnoreCase("ERASE")) continue;
            if (!this.compressionMethod[pIndex].equals("Uncompressed")) {
                try {
                    this.compressedSize[pIndex][i] = this.dbFlashSegment[pIndex][i].getCompressedSize();
                }
                catch (MCDException mcde) {
                    this.logger.warn("Error determining COMPRESSED-SIZE of SEGMENT with index " + i + " of DATABLOCK with index " + pIndex + ".");
                    this.logger.logThrowable(mcde);
                    return false;
                }
            }
            try {
                this.dbFlashSegmentSize[pIndex][i] = this.dbFlashSegment[pIndex][i].getBinaryData().length;
                if (VendorSpecific.getServerVendor() == DServerVendor.DSA && !this.compressionMethod[pIndex].equals("Uncompressed") && (long)this.dbFlashSegmentSize[pIndex][i] != this.compressedSize[pIndex][i]) {
                    this.logger.error("Detected mismatch between COMPRESSED-SIZE (" + this.compressedSize[pIndex][i] + ") and length of binary data (" + this.dbFlashSegmentSize[pIndex][i] + ") for SEGMENT with index " + i + " of DATABLOCK with index " + pIndex + ".");
                    return false;
                }
                this.totalNumberOfBytesToTransfer += this.dbFlashSegmentSize[pIndex][i];
                continue;
            }
            catch (MCDException mcde) {
                if (VendorSpecific.getServerVendor() == DServerVendor.DSA && mcde.getError().getCode() == 53315 && mcde.getError().getVendorCode() == 6186) {
                    this.logger.error("Error reading binary data of SEGMENT with index " + i + " of DATABLOCK with index " + pIndex + "... probably due to mismatched COMPRESSED-SIZE.");
                    this.setJobInfo("ERROR: Error reading binary data of SEGMENT with index " + i + " of DATABLOCK with index " + pIndex + "... probably due to mismatched COMPRESSED-SIZE.");
                } else {
                    this.logger.logThrowable(mcde);
                }
                return false;
            }
        }
        this.logger.trace("Leaving readFlashSegmentsByDataBlockIndex(...).");
        return true;
    }

    protected boolean readOwnIdentsByDataBlockIndex(int pIndex) {
        int count;
        this.logger.trace("Entering readOwnIdentsByDataBlockIndex(...).");
        try {
            count = (int)this.dbExpectedIdents.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of OWN-IDENTS for DATABLOCK with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        this.dbOwnIdent[pIndex] = new MCDDbFlashIdent[count];
        this.dbOwnIdentDescription[pIndex] = new MCDDbIdentDescription[count];
        try {
            this.dbOwnIdents[pIndex].getItemByIndex(0L).getIdentValues();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error reading IDENT-VALUES of OWN-IDENTS for DATABLOCK with index " + pIndex + ".");
            this.logger.logThrowable(mcde);
            return false;
        }
        this.logger.trace("Leaving readOwnIdentsByDataBlockIndex(...).");
        return true;
    }

    protected boolean readSpecialDataGroupsOfSession(MCDDbFlashSession pDbFlashSession) {
        SpecialDataGroupHelperImpl sdgHelper = null;
        MCDDbSpecialDataGroups dbSpecialDataGroups = null;
        TreeMap specialDataElementsEcuMemSpecVersion = null;
        TreeMap specialDataElementsVw80126Version = null;
        TreeMap specialDataElementsFdsProjectId = null;
        this.logger.trace("Entering readSpecialDataGroupsOfSession(...).");
        sdgHelper = new SpecialDataGroupHelperImpl(this.logger, (VendorSpecificMCD20002)((Object)this.vendorSpecific));
        try {
            dbSpecialDataGroups = pDbFlashSession.getDbSDGs();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SDGS of the SESSION.");
            this.logger.logThrowable(mcde);
            return false;
        }
        specialDataElementsEcuMemSpecVersion = new TreeMap();
        if (!sdgHelper.getSpecialDataElementsFromSpecialDataGroupsByCaption(dbSpecialDataGroups, "SDGC_ECUMEMSPEC", specialDataElementsEcuMemSpecVersion)) {
            return false;
        }
        this.ecuMemSpecVersion = specialDataElementsEcuMemSpecVersion.containsKey("VERSION") ? (String)specialDataElementsEcuMemSpecVersion.get("VERSION") : (specialDataElementsEcuMemSpecVersion.containsKey("ECU-MEM-SPEC-VERSION") ? (String)specialDataElementsEcuMemSpecVersion.get("ECU-MEM-SPEC-VERSION") : "");
        specialDataElementsVw80126Version = new TreeMap();
        if (!sdgHelper.getSpecialDataElementsFromSpecialDataGroupsByCaption(dbSpecialDataGroups, "SDGC_VW80126", specialDataElementsVw80126Version)) {
            return false;
        }
        if (specialDataElementsVw80126Version.containsKey("VW80126-VERSION")) {
            this.vw80126Version = (String)specialDataElementsVw80126Version.get("VW80126-VERSION");
            if (this.vw80126Version.substring(0, 1).equals("1.x.x".substring(0, 1))) {
                this.vw80126Version = "1.x.x";
            }
        } else {
            this.vw80126Version = "1.x.x";
        }
        if (sdgHelper.getSpecialDataElementsFromSpecialDataGroupsByCaption(dbSpecialDataGroups, "SDGC_FDSProjeID", specialDataElementsFdsProjectId = new TreeMap())) {
            this.fdsProjectIdEcu = SharedData.getFdsProjectId();
            this.fds = SharedData.getFDS();
            this.fdsKeyTypeEcu = SharedData.getFdsKeyType();
            if (this.fds != null) {
                this.dumpFds();
            }
        }
        this.logger.trace("Leaving readSpecialDataGroupsOfSession(...).");
        return true;
    }

    protected AbstractJob.JobStatus prepareProtocolParameterSet() {
        block17: {
            MCDRequest protocolParameterSetRequest = null;
            MCDRequestParameter comParam = null;
            MCDValue paramValue = null;
            String modifyTiming = null;
            this.logger.trace("Entering prepareProtocolParameterSet(...).");
            try {
                this.protocolParameterSet = (MCDProtocolParameterSet)this.logicalLink.createDiagComPrimitiveByType(1193);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error creating ProtocolParameterSet!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                this.protocolParameterSet.fetchValuesFromInterface();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error fetching COMPARAM values from interface!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                protocolParameterSetRequest = this.protocolParameterSet.getRequest();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request of ProtocolParameterSet!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                this.protocolParameters = protocolParameterSetRequest.getRequestParameters();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting COMPARAMs from ProtocolParameterSet request!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                comParam = this.protocolParameters.getItemByName("CP_ModifyTiming");
                this.isPduApiUsed = true;
                this.logger.info("Using PDU-API firmware with ISO 22900-2 COMPARAMs.");
                paramValue = comParam.getValue();
                modifyTiming = paramValue.getValueAsString();
                this.isModifyTimingEnabled = modifyTiming.equals("Enabled");
            }
            catch (MCDException mcde) {
                this.isPduApiUsed = false;
                this.logger.info("Using Softing EIDBSS firmware with proprietary COMPARAMs.");
                if (this.maximumBlockSizeTransportLayer <= 1012L) break block17;
                if (this.logger.getLogLevel() >= 4) {
                    this.logger.info("maximumBlockSizeTransportLayer (" + this.maximumBlockSizeTransportLayer + ") exceeds buffer limit of EDIC hardware with EIDBSS firmware (" + 1012 + " bytes)!");
                    this.logger.info("Limiting maximumBlockSizeTransportLayer to 1012 bytes.");
                }
                this.maximumBlockSizeTransportLayer = 1012L;
            }
        }
        this.logger.debug("Saving initial COMPARAM values.");
        try {
            if (this.isPduApiUsed) {
                this.savedCanTransmissionTime = this.getProtocolParameterUint32(this.protocolParameterSet, this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime);
                this.savedP3CanClientPhys = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P3Phys");
                this.savedP3CanClientFunc = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_P3Func");
                this.savedStMinOverride = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_StMinOverride");
                this.savedStMinOverride &= 0xFFFFFFFFL;
                this.separationTimeRequest = this.savedStMinOverride;
                this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "CP_RepeatReqCountApp");
                this.savedStandTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
                this.savedExtenTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
            } else {
                this.savedCanTransmissionTime = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_CANTransTime");
                this.savedNumberOfErrorRepetitions = this.getProtocolParameterUint32(this.protocolParameterSet, "NumberOfErrorRepetitions");
                this.savedStandTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "ResponseTimeout");
                this.savedExtenTiminP2Serve = this.getProtocolParameterUint32(this.protocolParameterSet, "RC78ResponseTimeout");
                this.savedP3CanClientPhys = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_P3CANClienPhys");
                this.savedP3CanClientFunc = this.getProtocolParameterUint32(this.protocolParameterSet, "ComPar_P3CANClienFunc");
                this.savedRequestTime = this.getProtocolParameterUint32(this.protocolParameterSet, "RequestTime");
            }
            this.logger.debug("CP_P2Max /CP_P6Max : " + this.savedStandTiminP2Serve);
            this.logger.debug("CP_P2Star/CP_P6Star: " + this.savedExtenTiminP2Serve);
            this.logger.debug("CP_StMinOverride   : " + this.savedStMinOverride);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error saving initial COMPARAM values!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.savedStMinOverride != 0xFFFFFFFFL && this.sTminLowerLimit < this.savedStMinOverride) {
            this.logger.debug("The current value of CP_StMinOverride (" + this.savedStMinOverride + " us) exceeds the value of the INPUT-PARAMETER " + "Param_STminLowerLimit" + " (" + this.sTminLowerLimit + " us)!");
            long stMinRange = this.sTminUpperLimit - this.sTminLowerLimit;
            if (stMinRange < 0L) {
                stMinRange = 0L;
            }
            this.sTminLowerLimit = this.savedStMinOverride;
            this.sTminUpperLimit = this.sTminLowerLimit + stMinRange;
            this.logger.debug("Adjusting STmin lower limit to: " + this.sTminLowerLimit);
            this.logger.debug("Adjusting STmin upper limit to: " + this.sTminUpperLimit);
        }
        this.logger.trace("Leaving prepareProtocolParameterSet(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected void logProtocolParameterSet(MCDProtocolParameterSet pProtocolParameterSet) throws MCDException {
        MCDRequestParameters comParams = null;
        long numberOfComParams = 0L;
        MCDRequestParameter comParam = null;
        MCDValue paramValue = null;
        this.logger.trace("Entering logProtocolParameterSet(...).");
        pProtocolParameterSet.fetchValuesFromInterface();
        comParams = pProtocolParameterSet.getRequest().getRequestParameters();
        numberOfComParams = comParams.getCount();
        this.logger.debug("Found " + numberOfComParams + " protocolParameters - current values are:");
        block5: for (long i = 0L; i < numberOfComParams; ++i) {
            comParam = comParams.getItemByIndex(i);
            paramValue = comParam.getValue();
            this.logMessage = "- " + comParam.getShortName() + ": ";
            switch (paramValue.getDataType()) {
                case 11: {
                    this.logMessage = this.logMessage + String.valueOf(paramValue.getUint32());
                    this.logger.debug(this.logMessage);
                    continue block5;
                }
                case 1: 
                case 14: {
                    this.logMessage = this.logMessage + paramValue.getValueAsString();
                    this.logger.debug(this.logMessage);
                    continue block5;
                }
                case 3: {
                    this.logMessage = this.logMessage + paramValue.getValueAsString();
                    this.logger.debug(this.logMessage);
                    continue block5;
                }
                default: {
                    this.logMessage = this.logMessage + "Data type of " + comParam.getShortName() + " is not ( yet) interpreted!";
                    this.logger.debug(this.logMessage);
                }
            }
        }
        this.logger.trace("Leaving logProtocolParameterSet(...).");
    }

    protected void setALFIDbyShortName(String pVariantShortName) {
        this.logger.trace("Entering setALFIDbyShortName(...).");
        if (pVariantShortName.startsWith("EV_ECM14L_") || pVariantShortName.startsWith("EV_ECM14TFS") || pVariantShortName.startsWith("EV_ECM14TSI") || pVariantShortName.startsWith("EV_ECM18TFS") && !pVariantShortName.startsWith("EV_ECM18TFS021") || pVariantShortName.startsWith("EV_ECM18TSI") || pVariantShortName.startsWith("EV_ECM18L") || pVariantShortName.startsWith("EV_ECM20C7") || pVariantShortName.startsWith("EV_ECM20TFS") && !pVariantShortName.startsWith("EV_ECM20TFS021") || pVariantShortName.startsWith("EV_ECM20STF") || pVariantShortName.startsWith("EV_ECM20AVS") || pVariantShortName.startsWith("EV_ECM20LAVS") || pVariantShortName.startsWith("EV_ECM20TDI") || pVariantShortName.startsWith("EV_ECM20LTDI") || pVariantShortName.startsWith("EV_ECM20BTD01") || pVariantShortName.startsWith("EV_ECM25MPI") || pVariantShortName.startsWith("EV_ECM25TDI") || pVariantShortName.startsWith("EV_ECM27LTDIA5") || pVariantShortName.startsWith("EV_ECM27TDI") || pVariantShortName.startsWith("EV_ECM30BIN") || pVariantShortName.startsWith("EV_ECM30LTDIA5_A") || pVariantShortName.startsWith("EV_ECM30QMP") || pVariantShortName.startsWith("EV_ECM30TDI") || pVariantShortName.startsWith("EV_ECM30TFS01") || pVariantShortName.startsWith("EV_ECM30TNF") || pVariantShortName.startsWith("EV_ECM30W36") || pVariantShortName.startsWith("EV_ECM30TSI") || pVariantShortName.startsWith("EV_ECM36FSI") || pVariantShortName.startsWith("EV_ECM42FSI") || pVariantShortName.startsWith("EV_ECM42HDZ") || pVariantShortName.startsWith("EV_ECM42TDI") || pVariantShortName.startsWith("EV_ECM142TDI") || pVariantShortName.startsWith("EV_ECM242TDI") || pVariantShortName.startsWith("EV_ECM40TFS") || pVariantShortName.startsWith("EV_ECM63FSI") || pVariantShortName.startsWith("EV_ECM68TMP") || pVariantShortName.matches("[EG]V_ECM[0-9]{2}(TSI|TFS|FSI|MPI|TMP|TDI|SDI|BTD)[0-2]1[0-9A-Z][0-9A-Za-z]{0,11}_[SXA0-9][0-9]{2}")) {
            this.LFID_EM = 0;
            this.AFID_EM = 1;
            this.LFID_RD = (byte)3;
            this.AFID_RD = 1;
            this.LFID_CM = 0;
            this.AFID_CM = 1;
            this.LI_CM = (short)2;
        } else if (pVariantShortName.startsWith("EV_Kombi") || pVariantShortName.startsWith("BV_DashBoardUDS_")) {
            this.LFID_EM = (byte)4;
            this.AFID_EM = (byte)4;
            this.LFID_RD = (byte)4;
            this.AFID_RD = (byte)4;
            this.LFID_CM = 0;
            this.AFID_CM = (byte)4;
        } else if (pVariantShortName.startsWith("EV_AirbaVW10BPAVW250")) {
            this.LFID_EM = (byte)4;
            this.AFID_EM = (byte)4;
            this.LFID_RD = (byte)4;
            this.AFID_RD = (byte)4;
            this.LFID_CM = (byte)4;
            this.AFID_CM = (byte)4;
            this.LI_CM = (short)4;
        } else {
            this.LI_CM = (short)-1;
        }
        this.logger.trace("Leaving setALFIDbyShortName(...).");
    }

    protected MCDStartCommunication startCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStartCommunication startCommunicationTmp = null;
        this.logger.trace("Entering startCommunication(...).");
        startCommunicationTmp = (MCDStartCommunication)pLogicalLink.createDiagComPrimitiveByType(1201);
        this.logger.trace("Leaving startCommunication(...).");
        return startCommunicationTmp;
    }

    protected MCDStopCommunication stopCommunication(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDStopCommunication stopCommunicationTmp = null;
        this.logger.trace("Entering stopCommunication(...).");
        stopCommunicationTmp = (MCDStopCommunication)pLogicalLink.createDiagComPrimitiveByType(1202);
        this.logger.trace("Leaving stopCommunication(...).");
        return stopCommunicationTmp;
    }

    protected MCDService createService(MCDLogicalLink pLogicalLink, String pServiceShortName) throws MCDException {
        MCDService service = null;
        try {
            service = (MCDService)pLogicalLink.createDiagComPrimitiveByName(pServiceShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating service with SHORT-NAME: " + pServiceShortName);
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            throw mcde;
        }
        return service;
    }

    protected MCDHexService createHexService(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDHexService hexService = null;
        try {
            hexService = (MCDHexService)pLogicalLink.createDiagComPrimitiveByType(1190);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating hex service!");
            this.logger.logThrowable(mcde);
            this.jobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            throw mcde;
        }
        return hexService;
    }

    protected MCDSingleEcuJob createJob(MCDLogicalLink pLogicalLink, String pJobShortName) {
        MCDSingleEcuJob singleEcuJob = null;
        try {
            singleEcuJob = (MCDSingleEcuJob)pLogicalLink.createDiagComPrimitiveByName(pJobShortName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating single ECU job with SHORT-NAME: " + pJobShortName);
            this.logger.logThrowable(mcde);
        }
        return singleEcuJob;
    }

    protected MCDService diagnosticSessionControl(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pDiagnosticSessionType, boolean pUseFunctionalAddressing) throws MCDException {
        MCDService diagnosticSessionControl = null;
        this.logger.trace("Entering diagnosticSessionControl(...).");
        diagnosticSessionControl = pUseFunctionalAddressing ? this.createService(pLogicalLink, "DiagnServi_DiagnSessiContrFUNCT") : this.createService(pLogicalLink, "DiagnServi_DiagnSessiContr");
        this.setSuppressPosRspMsgIndicationBit(diagnosticSessionControl, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)diagnosticSessionControl, "Param_DiagnSessiType", pDiagnosticSessionType);
        this.logger.trace("Leaving diagnosticSessionControl(...).");
        return diagnosticSessionControl;
    }

    protected MCDService routineControlCheckProgrammingPreconditions(MCDLogicalLink pLogicalLink) throws MCDException {
        MCDService routineControl = null;
        this.logger.trace("Entering routineControlCheckProgrammingPreconditions(...).");
        routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrCheckProgrPreco");
        this.logger.trace("Leaving routineControlCheckProgrammingPreconditions(...).");
        return routineControl;
    }

    protected MCDService communicationControl(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pControlType, String pCommunicationType, String pSubnetNumber) throws MCDException {
        MCDService communicationControl = null;
        this.logger.trace("Entering communicationControl(...).");
        if (pControlType.equalsIgnoreCase("Enable Rx And Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrEnablRxAndTxNormaCommuMessa");
        } else if (pControlType.equalsIgnoreCase("Enable Rx And Disable Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrEnablRxAndDisabTxNormaCommuMessa");
        } else if (pControlType.equalsIgnoreCase("Disable Rx And Enable Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrDisabRxAndEnablTxNormaCommuMessa");
        } else if (pControlType.equalsIgnoreCase("Disable Rx And Tx")) {
            communicationControl = this.createService(pLogicalLink, "DiagnServi_CommuContrDisabRxAndTxNormaCommuMessa");
        } else {
            throw new IllegalArgumentException("Invalid controlType.");
        }
        this.setSuppressPosRspMsgIndicationBit(communicationControl, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_CommuTypeBits0To1", pCommunicationType);
        this.setRequestParameterString((MCDDiagComPrimitive)communicationControl, "Param_CommuTypeBits4To7", pSubnetNumber);
        this.logger.trace("Leaving communicationControl(...).");
        return communicationControl;
    }

    protected MCDService controlDtcSetting(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pDtcSettingType) throws MCDException {
        MCDService controlDtcSetting = null;
        this.logger.trace("Entering controlDtcSetting(...).");
        controlDtcSetting = this.createService(pLogicalLink, "DiagnServi_ContrDTCSetti");
        this.setSuppressPosRspMsgIndicationBit(controlDtcSetting, pSuppressResponse);
        this.setRequestParameterString((MCDDiagComPrimitive)controlDtcSetting, "Param_DTCSettiType", pDtcSettingType);
        this.logger.trace("Leaving controlDtcSetting(...).");
        return controlDtcSetting;
    }

    protected MCDSingleEcuJob flashPostProgramming(MCDLogicalLink pLogicalLink, int pLogLevel) throws MCDException {
        MCDSingleEcuJob flashPostProgrammingTmp = null;
        this.logger.trace("Entering flashPostProgramming(...).");
        flashPostProgrammingTmp = this.createJob(pLogicalLink, "SinglJob_FlashPostProgr");
        this.setRequestParameterUint32((MCDDiagComPrimitive)flashPostProgrammingTmp, "IPA_LogLevel", (long)pLogLevel);
        this.logger.trace("Leaving flashPostProgramming(...).");
        return flashPostProgrammingTmp;
    }

    protected MCDSingleEcuJob flashPreProgramming(MCDLogicalLink pLogicalLink, int pLogLevel) throws MCDException {
        MCDSingleEcuJob flashPreProgrammingTmp = null;
        this.logger.trace("Entering flashPreProgramming(...).");
        flashPreProgrammingTmp = this.createJob(pLogicalLink, "SinglJob_FlashPreProgr");
        this.setRequestParameterUint32((MCDDiagComPrimitive)flashPreProgrammingTmp, "IPA_LogLevel", (long)pLogLevel);
        this.logger.trace("Leaving flashPreProgramming(...).");
        return flashPreProgrammingTmp;
    }

    protected MCDSingleEcuJob checkOwnIdents(MCDLogicalLink pLogicalLink, int pLogLevel, String pDbFlashSessionName) throws MCDException {
        MCDSingleEcuJob checkOwnIdentsTmp = null;
        this.logger.trace("Entering checkOwnIdents(...).");
        checkOwnIdentsTmp = this.createJob(pLogicalLink, "SinglJob_CheckOwnIdent");
        this.setRequestParameterUint32((MCDDiagComPrimitive)checkOwnIdentsTmp, "IPA_LogLevel", (long)pLogLevel);
        this.setRequestParameterString((MCDDiagComPrimitive)checkOwnIdentsTmp, "IPA_FlashSessiName", this.dbFlashSessionName);
        this.logger.trace("Leaving checkOwnIdents(...).");
        return checkOwnIdentsTmp;
    }

    protected MCDSingleEcuJob securityAccess(MCDLogicalLink pLogicalLink, int pLogLevel, String pSecurityMethod, byte[] pSecurityAlgorithm) throws MCDException {
        MCDSingleEcuJob securityAccessTmp = null;
        this.logger.trace("Entering securityAccess(...).");
        securityAccessTmp = this.createJob(pLogicalLink, "SinglJob_SecurAcces");
        this.setRequestParameterUint32((MCDDiagComPrimitive)securityAccessTmp, "IPA_LogLevel", (long)pLogLevel);
        this.setRequestParameterString((MCDDiagComPrimitive)securityAccessTmp, "IPA_SecurMetho", pSecurityMethod);
        if (pSecurityAlgorithm != null) {
            this.setRequestParameterBytefield((MCDDiagComPrimitive)securityAccessTmp, "IPA_SecurAlgor", pSecurityAlgorithm);
        }
        this.logger.trace("Leaving securityAccess(...).");
        return securityAccessTmp;
    }

    protected MCDSingleEcuJob writeFingerprint(MCDLogicalLink pLogicalLink, int pLogLevel, String pFingerprintType, long pVwDeviceNumber, short pImporterNumber, long pWorkshopNumber, byte pYear, byte pMonth, byte pDay) throws MCDException {
        MCDSingleEcuJob writeFingerprintTmp = null;
        this.logger.trace("Entering writeFingerprint(...).");
        writeFingerprintTmp = this.createJob(pLogicalLink, "SinglJob_WriteFinge");
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "IPA_LogLevel", (long)pLogLevel);
        this.setRequestParameterString((MCDDiagComPrimitive)writeFingerprintTmp, "IPA_FingeType", pFingerprintType);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_VWDevicNumbe", pVwDeviceNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_ImporNumbe", (long)pImporterNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_WorksNumbe", pWorkshopNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_Year", (long)pYear);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_Month", (long)pMonth);
        this.setRequestParameterUint32((MCDDiagComPrimitive)writeFingerprintTmp, "Param_Day", (long)pDay);
        this.logger.trace("Leaving writeFingerprint(...).");
        return writeFingerprintTmp;
    }

    protected MCDSingleEcuJob startCommunication(MCDLogicalLink pLogicalLink, int pLogLevel, long pVwDeviceNumber, short pImporterNumber, long pWorkshopNumber, byte pYear, byte pMonth, byte pDay) throws MCDException {
        MCDSingleEcuJob startCommunicationTmp = null;
        this.logger.trace("Entering startCommunication(...).");
        startCommunicationTmp = this.createJob(pLogicalLink, "SinglJob_StartCommu");
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "IPA_LogLevel", (long)pLogLevel);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_VWDevicNumbe", pVwDeviceNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_ImporNumbe", (long)pImporterNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_WorksNumbe", pWorkshopNumber);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_Year", (long)pYear);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_Month", (long)pMonth);
        this.setRequestParameterUint32((MCDDiagComPrimitive)startCommunicationTmp, "Param_Day", (long)pDay);
        this.logger.trace("Leaving startCommunication(...).");
        return startCommunicationTmp;
    }

    protected MCDSingleEcuJob changeBaudRate(MCDLogicalLink pLogicalLink, int pLogLevel, String pTargetBaudRate) throws MCDException {
        MCDSingleEcuJob changeBaudRateTmp = null;
        this.logger.trace("Entering changeBaudRate(...).");
        changeBaudRateTmp = this.createJob(pLogicalLink, "SinglJob_ChangBaudRate");
        this.setRequestParameterUint32((MCDDiagComPrimitive)changeBaudRateTmp, "IPA_LogLevel", (long)pLogLevel);
        this.setRequestParameterString((MCDDiagComPrimitive)changeBaudRateTmp, "IPA_TargeBaudRate", pTargetBaudRate);
        this.logger.trace("Leaving changeBaudRate(...).");
        return changeBaudRateTmp;
    }

    protected MCDService routineControlEraseMemory(MCDLogicalLink pLogicalLink, byte pLengthFormatIdentifier, byte pAddressFormatIdentifier, long pMemoryAddress, long pMemorySize) throws MCDException {
        MCDService routineControl = null;
        this.logger.trace("Entering routineControlEraseMemory(...).");
        if (this.isMcd20002Interface) {
            routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrEraseMemor");
        } else {
            try {
                routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrEraseMemorMCD20001");
            }
            catch (MCDException mcde) {
                routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrEraseMemor");
            }
        }
        if (this.isMcd20002Interface) {
            this.setLengthFormatIdentifier((MCDDiagService)routineControl, (byte)(pLengthFormatIdentifier * 8));
        } else {
            this.setLengthFormatIdentifier((MCDDiagService)routineControl, pLengthFormatIdentifier);
        }
        if (this.isMcd20002Interface) {
            this.setAddressFormatIdentifier((MCDDiagService)routineControl, (byte)(pAddressFormatIdentifier * 8));
        } else {
            this.setAddressFormatIdentifier((MCDDiagService)routineControl, pAddressFormatIdentifier);
        }
        if (pAddressFormatIdentifier > 0) {
            this.setMemoryAddress((MCDDiagService)routineControl, Conversions.long2ByteArray(pMemoryAddress, pAddressFormatIdentifier));
        }
        if (pLengthFormatIdentifier > 0) {
            this.setMemorySize((MCDDiagService)routineControl, Conversions.long2ByteArray(pMemorySize, pLengthFormatIdentifier));
        }
        this.logger.trace("Leaving routineControlEraseMemory(...).");
        return routineControl;
    }

    protected MCDService routineControlEraseMemory(MCDLogicalLink pLogicalLink, byte pLengthFormatIdentifier, byte pAddressFormatIdentifier, byte[] pLogicalBlockIndex) throws MCDException {
        MCDService routineControl = null;
        this.logger.trace("Entering routineControlEraseMemory(...).");
        if (this.isMcd20002Interface) {
            routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrEraseMemor");
        } else {
            try {
                routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrEraseMemorMCD20001");
            }
            catch (MCDException mcde) {
                routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrEraseMemor");
            }
        }
        this.setLengthFormatIdentifier((MCDDiagService)routineControl, (byte)0);
        if (this.isMcd20002Interface) {
            this.setAddressFormatIdentifier((MCDDiagService)routineControl, (byte)(pAddressFormatIdentifier * 8));
        } else {
            this.setAddressFormatIdentifier((MCDDiagService)routineControl, pAddressFormatIdentifier);
        }
        if (pAddressFormatIdentifier > 0) {
            this.setMemoryAddress((MCDDiagService)routineControl, pLogicalBlockIndex);
        }
        this.logger.trace("Leaving routineControlEraseMemory(...).");
        return routineControl;
    }

    protected MCDService requestDownload(MCDLogicalLink pLogicalLink, String pCompressionMethod, String pEncryptionMethod, byte pLengthFormatIdentifier, byte pAddressFormatIdentifier, long pMemoryAddress, long pMemorySize) throws MCDException {
        MCDService requestDownload = null;
        this.logger.trace("Entering requestDownload(...).");
        if (this.isMcd20002Interface) {
            requestDownload = this.createService(pLogicalLink, "DiagnServi_RequeDownl");
        } else {
            try {
                requestDownload = this.createService(pLogicalLink, "DiagnServi_RequeDownlMCD20001");
            }
            catch (MCDException mcde) {
                requestDownload = this.createService(pLogicalLink, "DiagnServi_RequeDownl");
            }
        }
        this.setRequestParameterString((MCDDiagComPrimitive)requestDownload, "Param_ComprMetho", pCompressionMethod);
        this.setRequestParameterString((MCDDiagComPrimitive)requestDownload, "Param_EncryMetho", pEncryptionMethod);
        if (this.isMcd20002Interface) {
            this.setLengthFormatIdentifier((MCDDiagService)requestDownload, (byte)(pLengthFormatIdentifier * 8));
        } else {
            this.setLengthFormatIdentifier((MCDDiagService)requestDownload, pLengthFormatIdentifier);
        }
        if (this.isMcd20002Interface) {
            this.setAddressFormatIdentifier((MCDDiagService)requestDownload, (byte)(pAddressFormatIdentifier * 8));
        } else {
            this.setAddressFormatIdentifier((MCDDiagService)requestDownload, pAddressFormatIdentifier);
        }
        if (pAddressFormatIdentifier > 0) {
            this.setMemoryAddress((MCDDiagService)requestDownload, Conversions.long2ByteArray(pMemoryAddress, pAddressFormatIdentifier));
        }
        if (pLengthFormatIdentifier > 0) {
            this.setMemorySize((MCDDiagService)requestDownload, Conversions.long2ByteArray(pMemorySize, pLengthFormatIdentifier));
        }
        this.logger.trace("Leaving requestDownload(...).");
        return requestDownload;
    }

    protected MCDService transferData(MCDLogicalLink pLogicalLink, byte pBlockSequenceCounter, byte[] pTransferRequestParameterRecord) throws MCDException {
        this.logger.trace("Entering transferData(...).");
        MCDService transferData = this.createService(pLogicalLink, "DiagnServi_TransData");
        this.setBlockSequenceCounter((MCDDiagService)transferData, pBlockSequenceCounter);
        this.setTransferRequestParameterRecord((MCDDiagService)transferData, pTransferRequestParameterRecord);
        this.logger.trace("Leaving transferData(...).");
        return transferData;
    }

    protected MCDService requestTransferExit(MCDLogicalLink pLogicalLink) throws MCDException {
        this.logger.trace("Entering requestTransferExit(...).");
        MCDService requestTransferExit = this.createService(pLogicalLink, "DiagnServi_RequeTransExit");
        this.logger.trace("Leaving requestTransferExit(...).");
        return requestTransferExit;
    }

    protected MCDDiagService routineControlCheckMemoryVW80126v1x(MCDLogicalLink pLogicalLink, byte pLengthFormatIdentifier, byte pAddressFormatIdentifier, long pMemoryAddress, long pMemorySize, short pLengthInformation, byte[] pChecksum) throws MCDException {
        MCDService routineControl = null;
        int numberOfRequestSidBytesInRequestPdu = 0;
        MCDRequest request = null;
        MCDValue value_requestPdu = null;
        byte[] requestPdu = null;
        this.logger.trace("Entering routineControlCheckMemoryVW80126v1x(...).");
        if (this.isMcd20002Interface) {
            routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrCheckMemor");
            numberOfRequestSidBytesInRequestPdu = 1;
        } else {
            try {
                routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrCheckMemorMCD20001");
            }
            catch (MCDException mcde) {
                routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrCheckMemor");
            }
        }
        this.logger.debug("Setting checksum value according to VW80126 v1.x.x...");
        if (this.vw80126VersionOfRoutineControlCheckMemory.equals(this.vw80126Version)) {
            if (this.isMcd20002Interface) {
                this.setLengthFormatIdentifier((MCDDiagService)routineControl, (byte)(pLengthFormatIdentifier * 8));
            } else {
                this.setLengthFormatIdentifier((MCDDiagService)routineControl, pLengthFormatIdentifier);
            }
            if (this.isMcd20002Interface) {
                this.setAddressFormatIdentifier((MCDDiagService)routineControl, (byte)(pAddressFormatIdentifier * 8));
            } else {
                this.setAddressFormatIdentifier((MCDDiagService)routineControl, pAddressFormatIdentifier);
            }
            if (pAddressFormatIdentifier > 0) {
                this.setMemoryAddress((MCDDiagService)routineControl, Conversions.long2ByteArray(pMemoryAddress, pAddressFormatIdentifier));
            }
            if (pLengthFormatIdentifier > 0) {
                this.setMemorySize((MCDDiagService)routineControl, Conversions.long2ByteArray(pMemorySize, pLengthFormatIdentifier));
            }
            if (this.isMcd20002Interface) {
                this.setRequestParameterUint32((MCDDiagComPrimitive)routineControl, "Param_LengtInfor", (long)((short)(pLengthInformation * 8)));
            } else {
                this.setRequestParameterUint32((MCDDiagComPrimitive)routineControl, "Param_LengtInfor", (long)pLengthInformation);
            }
            if (pLengthInformation > 0) {
                this.setRequestParameterBytefield((MCDDiagComPrimitive)routineControl, "Param_Check", pChecksum);
            } else {
                this.logger.warn("VW80126 specification versions of \"DiagnServi_RoutiContrCheckMemor\" do NOT match in ECU-MEM and ODX! Creating request manually...");
                this.logicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)routineControl);
                routineControl = this.createHexService(this.logicalLink);
                request = routineControl.getRequest();
                value_requestPdu = this.jobApi.createValue(3);
                request = routineControl.getRequest();
                requestPdu = new byte[numberOfRequestSidBytesInRequestPdu + 1 + 2 + 1 + pLengthFormatIdentifier + pAddressFormatIdentifier + 2 + pLengthInformation];
                if (numberOfRequestSidBytesInRequestPdu == 1) {
                    requestPdu[0] = 49;
                }
                requestPdu[numberOfRequestSidBytesInRequestPdu] = 1;
                requestPdu[numberOfRequestSidBytesInRequestPdu + 1] = 2;
                requestPdu[numberOfRequestSidBytesInRequestPdu + 2] = 2;
                requestPdu[numberOfRequestSidBytesInRequestPdu + 3] = pAddressFormatIdentifier;
                int n = numberOfRequestSidBytesInRequestPdu + 3;
                requestPdu[n] = (byte)(requestPdu[n] + (pLengthFormatIdentifier << 4));
                if (pAddressFormatIdentifier > 0) {
                    System.arraycopy(Conversions.long2ByteArray(pMemoryAddress, pAddressFormatIdentifier), 0, requestPdu, numberOfRequestSidBytesInRequestPdu + 4, pAddressFormatIdentifier);
                }
                if (pLengthFormatIdentifier > 0) {
                    System.arraycopy(Conversions.long2ByteArray(pMemorySize, pLengthFormatIdentifier), 0, requestPdu, numberOfRequestSidBytesInRequestPdu + 4 + pAddressFormatIdentifier, pLengthFormatIdentifier);
                }
                System.arraycopy(Conversions.long2ByteArray(pLengthInformation, 2), 0, requestPdu, numberOfRequestSidBytesInRequestPdu + 4 + pAddressFormatIdentifier + pLengthFormatIdentifier, 2);
                if (pLengthInformation > 0) {
                    System.arraycopy(pChecksum, 0, requestPdu, numberOfRequestSidBytesInRequestPdu + 4 + pAddressFormatIdentifier + pLengthFormatIdentifier + 2, pLengthInformation);
                }
                value_requestPdu.setBytefield(requestPdu);
                request.enterPDU(value_requestPdu);
            }
        }
        this.logger.trace("Leaving routineControlCheckMemoryVW80126v1x(...).");
        return routineControl;
    }

    protected MCDDiagService routineControlCheckMemoryVW80126v20(MCDLogicalLink pLogicalLink, byte[] pChecksum) throws MCDException {
        MCDService routineControl = null;
        int numberOfRequestSidBytesInRequestPdu = 0;
        MCDRequest request = null;
        MCDValue value_requestPdu = null;
        byte[] requestPdu = null;
        this.logger.trace("Entering routineControlCheckMemoryVW80126v20(...).");
        if (this.isMcd20002Interface) {
            routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrCheckMemor");
            numberOfRequestSidBytesInRequestPdu = 1;
        } else {
            try {
                routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrCheckMemorMCD20001");
            }
            catch (MCDException mcde) {
                routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrCheckMemor");
            }
        }
        this.logger.debug("Setting checksum value according to VW80126 v2.0.0...");
        if (this.vw80126VersionOfRoutineControlCheckMemory.equals(this.vw80126Version)) {
            try {
                this.setRequestParameterBytefield((MCDDiagComPrimitive)routineControl, "Param_Value", pChecksum);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error setting \"Param_Value\"!");
                this.logger.logThrowable(mcde);
                return null;
            }
        } else {
            this.logger.warn("VW80126 specification versions of \"DiagnServi_RoutiContrCheckMemor\" do NOT match in ECU-MEM and ODX! Creating request manually...");
            this.logicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)routineControl);
            routineControl = this.createHexService(this.logicalLink);
            request = routineControl.getRequest();
            value_requestPdu = this.jobApi.createValue(3);
            requestPdu = new byte[numberOfRequestSidBytesInRequestPdu + 1 + 2 + pChecksum.length];
            if (numberOfRequestSidBytesInRequestPdu == 1) {
                requestPdu[0] = 49;
            }
            requestPdu[numberOfRequestSidBytesInRequestPdu] = 1;
            requestPdu[numberOfRequestSidBytesInRequestPdu + 1] = 2;
            requestPdu[numberOfRequestSidBytesInRequestPdu + 2] = 2;
            System.arraycopy(pChecksum, 0, requestPdu, numberOfRequestSidBytesInRequestPdu + 3, pChecksum.length);
            if (VendorSpecific.getServerVendor() == DServerVendor.SIEMENS) {
                int numberOfMetaDataBytesInCifRequestPdus = 7;
                byte[] cifRequestPdu = new byte[7 + requestPdu.length];
                cifRequestPdu[0] = 0;
                cifRequestPdu[1] = 0;
                cifRequestPdu[2] = 0;
                cifRequestPdu[3] = 0;
                cifRequestPdu[4] = 0;
                cifRequestPdu[5] = (byte)(requestPdu.length & 0xFF);
                cifRequestPdu[6] = (byte)(requestPdu.length >>> 8 & 0xFF);
                System.arraycopy(requestPdu, 0, cifRequestPdu, 7, cifRequestPdu.length - 7);
                requestPdu = new byte[cifRequestPdu.length];
                System.arraycopy(cifRequestPdu, 0, requestPdu, 0, requestPdu.length);
            }
            value_requestPdu.setBytefield(requestPdu);
            request.enterPDU(value_requestPdu);
        }
        this.logger.trace("Leaving routineControlCheckMemoryVW80126v20(...).");
        return routineControl;
    }

    protected MCDService routineControlCheckProgrammingDependencies(MCDLogicalLink pLogicalLink) throws MCDException {
        this.logger.trace("Entering routineControlCheckProgrammingDependencies(...).");
        MCDService routineControl = this.createService(pLogicalLink, "DiagnServi_RoutiContrCheckProgrDepen");
        this.logger.trace("Leaving routineControlCheckProgrammingDependencies(...).");
        return routineControl;
    }

    protected MCDService ecuReset(MCDLogicalLink pLogicalLink, Boolean pSuppressResponse, String pResetType) throws MCDException {
        MCDService ecuReset = null;
        this.logger.trace("Entering ecuReset(...).");
        if (pResetType.equals("Hard Reset")) {
            ecuReset = this.createService(pLogicalLink, "DiagnServi_ECUResetHardReset");
        } else if (pResetType.equals("Key Off On Reset")) {
            ecuReset = this.createService(pLogicalLink, "DiagnServi_ECUResetKeyOffOnReset");
        } else if (pResetType.equals("Soft Reset")) {
            ecuReset = this.createService(pLogicalLink, "DiagnServi_ECUResetSoftReset");
        } else {
            throw new IllegalArgumentException("Invalid resetType.");
        }
        pSuppressResponse.hashCode();
        this.logger.trace("Leaving ecuReset(...).");
        return ecuReset;
    }

    protected void setSuppressPosRspMsgIndicationBit(MCDService pService, Boolean pValue) throws MCDException {
        this.logger.trace("Entering setSuppressPosRspMsgIndicationBit(...).");
        this.setRequestParameterString((MCDDiagComPrimitive)pService, "Param_SupprPositRespoMessaIndicBit", pValue.toString().toUpperCase());
        if (pValue == Boolean.TRUE && this.isMcd300Interface) {
            this.logger.debug("Setting SPR flag.");
            this.vendorSpecific.setSuppressPositiveResponseUnchecked(pService);
        }
        this.logger.trace("Leaving setSuppressPosRspMsgIndicationBit(...).");
    }

    protected void setAddressFormatIdentifier(MCDDiagService pService, byte pAddressFormatIdentifier) throws MCDException {
        this.logger.trace("Entering setAddressFormatIdentifier(...).");
        this.setRequestParameterUint32((MCDDiagComPrimitive)pService, "Param_AddreFormaIdent", (long)pAddressFormatIdentifier);
        this.logger.trace("Leaving setAddressFormatIdentifier(...).");
    }

    protected void setLengthFormatIdentifier(MCDDiagService pService, byte pLengthFormatIdentifier) throws MCDException {
        this.logger.trace("Entering setLengthFormatIdentifier(...).");
        this.setRequestParameterUint32((MCDDiagComPrimitive)pService, "Param_LengtFormaIdent", (long)pLengthFormatIdentifier);
        this.logger.trace("Leaving setLengthFormatIdentifier(...).");
    }

    protected void setMemoryAddress(MCDDiagService pService, byte[] pMemoryAddress) throws MCDException {
        byte[] memoryAddressToSet = null;
        this.logger.trace("Entering setMemoryAddress(...).");
        memoryAddressToSet = pMemoryAddress;
        MCDRequestParameter param_memoryAddress = pService.getRequest().getRequestParameters().getItemByName("Param_MemorAddre");
        MCDValue memoryAddress = param_memoryAddress.createValue();
        memoryAddress.setBytefield(memoryAddressToSet);
        param_memoryAddress.setValue(memoryAddress);
        this.logger.trace("Leaving setMemoryAddress(...).");
    }

    protected void setMemorySize(MCDDiagService pService, byte[] pMemorySize) throws MCDException {
        byte[] memorySizeToSet = null;
        this.logger.trace("Entering setMemorySize(...).");
        memorySizeToSet = pMemorySize;
        MCDRequestParameter param_memorySize = pService.getRequest().getRequestParameters().getItemByName("Param_MemorSize");
        MCDValue memorySize = param_memorySize.createValue();
        memorySize.setBytefield(memorySizeToSet);
        param_memorySize.setValue(memorySize);
        this.logger.trace("Leaving setMemorySize(...).");
    }

    protected void setBlockSequenceCounter(MCDDiagService pService, byte pBlockSequenceCounter) throws MCDException {
        this.logger.trace("Entering setBlockSequenceCounter(...).");
        this.setRequestParameterUint32((MCDDiagComPrimitive)pService, "Param_BlockSequeCount", (long)(pBlockSequenceCounter & 0xFF));
        this.logger.trace("Leaving setBlockSequenceCounter(...).");
    }

    protected void setTransferRequestParameterRecord(MCDDiagService pService, byte[] pTransferRequestParameterRecord) throws MCDException {
        this.logger.trace("Entering setTransferRequestParameterRecord(...).");
        this.setRequestParameterBytefield((MCDDiagComPrimitive)pService, "Param_TransRequeParamRecor", pTransferRequestParameterRecord);
        this.logger.trace("Leaving setTransferRequestParameterRecord(...).");
    }

    protected void setRequestParameterUint32(MCDRequestParameters pRequestParameters, String pRequestParameterName, long pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterUint32(...).");
        requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        value = requestParameter.createValue();
        value.setUint32(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterUint32(...).");
    }

    protected void setRequestParameterUint32(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, long pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterUint32(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        value.setUint32(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterUint32(...).");
    }

    protected void setRequestParameterString(MCDRequestParameters pRequestParameters, String pRequestParameterName, String pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterString(...).");
        requestParameter = this.getRequestParameter(pRequestParameters, pRequestParameterName);
        value = requestParameter.createValue();
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected void setRequestParameterString(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, String pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterString(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        this.logger.debug("Setting parameter to: " + pValue);
        value.setValueAsString(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterString(...).");
    }

    protected void setRequestParameterBytefield(MCDRequestParameters pRequestParameters, String pRequestParameterName, byte[] pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterBytefield(...).");
        requestParameter = this.getRequestParameter(pRequestParameters, pRequestParameterName);
        value = requestParameter.createValue();
        value.setBytefield(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterBytefield(...).");
    }

    protected void setRequestParameterBytefield(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName, byte[] pValue) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDValue value = null;
        this.logger.trace("Entering setRequestParameterBytefield(...).");
        requestParameter = this.getRequestParameter(pDiagComPrimitive, pRequestParameterName);
        value = requestParameter.createValue();
        value.setBytefield(pValue);
        requestParameter.setValue(value);
        this.logger.trace("Leaving setRequestParameterBytefield(...).");
    }

    protected MCDRequestParameter getRequestParameter(MCDRequestParameters pRequestParameters, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = null;
        MCDRequestParameter currentRequestParameter = null;
        MCDRequestParameters requestSubParameters = null;
        long numberOfRequestParameters = 0L;
        this.logger.debug("Getting request parameter: " + pRequestParameterName);
        try {
            requestParameter = pRequestParameters.getItemByName(pRequestParameterName);
        }
        catch (MCDException mcde) {
            if (mcde.getError().getCode() != 49184 && mcde.getError().getCode() != 49177) {
                this.logger.debug("Error getting request parameter with SHORT-NAME \"" + pRequestParameterName + "\"!");
                this.logger.logThrowable(mcde);
            }
            numberOfRequestParameters = pRequestParameters.getCount();
            for (long i = 0L; i < numberOfRequestParameters && requestParameter == null; ++i) {
                currentRequestParameter = pRequestParameters.getItemByIndex(i);
                if (currentRequestParameter.getType() != 17) continue;
                requestSubParameters = currentRequestParameter.getParameters();
                requestParameter = this.getRequestParameter(requestSubParameters, pRequestParameterName);
            }
        }
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected MCDRequestParameter getRequestParameter(MCDDiagComPrimitive pDiagComPrimitive, String pRequestParameterName) throws MCDException {
        this.logger.trace("Entering getRequestParameter(...).");
        MCDRequestParameter requestParameter = this.getRequestParameter(pDiagComPrimitive.getRequest().getRequestParameters(), pRequestParameterName);
        this.logger.trace("Leaving getRequestParameter(...).");
        return requestParameter;
    }

    protected void updateProtocolParameters(MCDProtocolParameterSet pProtocolParameterSet) {
        MCDResult result = null;
        int diagComprimitiveState = 0;
        this.logger.trace("Entering updateProtocolParameters(...).");
        try {
            result = pProtocolParameterSet.executeSync();
        }
        catch (MCDException mcde) {
            this.logger.error("Error executing MCDProtocolParameterSet.");
            this.logger.logThrowable(mcde);
            return;
        }
        try {
            diagComprimitiveState = pProtocolParameterSet.getState();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining comprimitive state of protocol parameter set.");
            this.logger.logThrowable(mcde);
            return;
        }
        this.logger.info("Current state of protocol parameter set is: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComprimitiveState));
        if (result != null) {
            boolean resultHasError = true;
            try {
                resultHasError = result.hasError();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining if result has an error.");
                this.logger.logThrowable(mcde);
                return;
            }
            if (resultHasError) {
                MCDError error = null;
                this.logger.debug("Error updating protocol parameters: Result has error.");
                try {
                    error = result.getError();
                }
                catch (Exception e) {
                    this.logger.error("Error getting error from result.");
                    this.logger.logThrowable(e);
                    return;
                }
                this.logger.logMcdError(error);
            } else {
                int executionState = -1;
                try {
                    executionState = result.getResultState().getExecutionState();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting execution state from result state.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.debug("Success updating protocol parameters.");
                this.logger.debug("ResultState of MCDProtocolParameterSet: " + McdEnumDecoder.decodeMcdExecutionState(executionState));
            }
        } else {
            MCDErrors errors = null;
            long numberOfErrors = 0L;
            MCDError error = null;
            this.logger.debug("Error updating protocol parameters: Result is null. This is caused by a DTS bug.");
            try {
                errors = pProtocolParameterSet.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting errors from MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            try {
                numberOfErrors = errors.getCount();
            }
            catch (MCDException mcde) {
                this.logger.error("Error determining number of errors of MCDProtocolParameterSet.");
                this.logger.logThrowable(mcde);
                return;
            }
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = errors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + " from MCDProtocolParameterSet.");
                    this.logger.logThrowable(mcde);
                    return;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving updateProtocolParameters(...).");
    }

    protected AbstractJob.JobStatus updateSessionTimings(MCDProtocolParameterSet pProtocolParameterSet, long pStandTiminP2Serve, long pExtenTiminP2Serve) throws MCDException {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        int canTransmissionTime = 0;
        int p2CanServer = 0;
        int p2StarCanServer = 0;
        this.logger.trace("Entering updateSessionTimings(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.isPduApiUsed) {
            if (!this.isModifyTimingEnabled) {
                canTransmissionTime = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamCanOrNetworkTransmissionTime);
                p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
                p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
                this.logger.debug("Setting P2_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ") from " + p2CanServer + " \u00b5s to " + (pStandTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max, pStandTiminP2Serve * 1000L + (long)canTransmissionTime);
                this.logger.debug("Setting P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") from " + p2StarCanServer + " \u00b5s to " + (pExtenTiminP2Serve * 1000L + (long)canTransmissionTime) + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star, pExtenTiminP2Serve * 1000L + (long)canTransmissionTime);
            }
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Max);
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, this.protocolStack.shortNameOfComParamP2OrP6Star);
            this.logger.debug("P2_CAN_Server  (" + this.protocolStack.shortNameOfComParamP2OrP6Max + ")  is now set to " + p2CanServer + " \u00b5s.");
            this.logger.debug("P2*_CAN_Server (" + this.protocolStack.shortNameOfComParamP2OrP6Star + ") is now set to " + p2StarCanServer + " \u00b5s.");
        } else {
            canTransmissionTime = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ComPar_CANTransTime");
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("Setting P2_CAN_Server (ResponseTimeout) from " + p2CanServer + " ms to " + (pStandTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "ResponseTimeout", pStandTiminP2Serve + (long)canTransmissionTime);
            this.logger.debug("Setting P2*_CAN_Server (RC78ResponseTimeout) from " + p2StarCanServer + " ms to " + (pExtenTiminP2Serve + (long)canTransmissionTime) + " ms.");
            this.setProtocolParameterValue(pProtocolParameterSet, "RC78ResponseTimeout", pExtenTiminP2Serve + (long)canTransmissionTime);
            p2CanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "ResponseTimeout");
            p2StarCanServer = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "RC78ResponseTimeout");
            this.logger.debug("P2_CAN_Server  (ResponseTimeout)     is now set to " + p2CanServer + " ms.");
            this.logger.debug("P2*_CAN_Server (RC78ResponseTimeout) is now set to " + p2StarCanServer + " ms.");
        }
        this.logger.trace("Leaving updateSessionTimings(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus updateSeparationTimeRequest(MCDProtocolParameterSet pProtocolParameterSet, long pSeparationTimeRequest) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long currentSeparationTimeRequest = 0L;
        this.logger.trace("Entering updateSeparationTimeRequest(...).");
        try {
            pProtocolParameterSet.fetchValuesFromInterface();
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            if (this.isPduApiUsed) {
                currentSeparationTimeRequest = (int)this.getProtocolParameterUint32(pProtocolParameterSet, "CP_StMinOverride");
                this.logger.debug("Setting STmin (CP_StMinOverride) from " + currentSeparationTimeRequest + " \u00b5s to " + pSeparationTimeRequest + " \u00b5s.");
                this.setJobInfo("Setting STmin (CP_StMinOverride) from " + currentSeparationTimeRequest + " \u00b5s to " + pSeparationTimeRequest + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, "CP_StMinOverride", pSeparationTimeRequest);
                this.cpSTminOverride = this.getProtocolParameterUint32(pProtocolParameterSet, "CP_StMinOverride");
                this.logger.debug("CP_StMinOverride is now set to: " + this.cpSTminOverride + ".");
            } else {
                if (this.separationTimeHandling == null) {
                    this.separationTimeHandling = this.getProtocolParameterString(pProtocolParameterSet, "SeparationTimeHandling");
                }
                if (this.separationTimeHandling.equals("use ECU value")) {
                    this.logger.debug("Switching SeparationTimeHandling from use ECU value to use SeparationTimeRequest.");
                    this.setProtocolParameterValue(pProtocolParameterSet, "SeparationTimeHandling", "use SeparationTimeRequest");
                    this.separationTimeHandling = this.getProtocolParameterString(pProtocolParameterSet, "SeparationTimeHandling");
                    this.logger.debug("SeparationTimeHandling is now set to: " + this.separationTimeHandling + ".");
                }
                currentSeparationTimeRequest = this.convertStMinFromEIDBSS((int)this.getProtocolParameterUint32(pProtocolParameterSet, "SeparationTimeRequest"));
                this.logger.debug("Setting STmin (SeparationTimeRequest) from " + currentSeparationTimeRequest + " \u00b5s to " + pSeparationTimeRequest + " \u00b5s.");
                this.setProtocolParameterValue(pProtocolParameterSet, "SeparationTimeRequest", this.convertStMinToEIDBSS(pSeparationTimeRequest));
                this.separationTimeRequest = this.convertStMinFromEIDBSS(this.getProtocolParameterUint32(pProtocolParameterSet, "SeparationTimeRequest"));
                this.logger.debug("SeparationTimeRequest is now set to: " + this.separationTimeRequest + ".");
            }
        }
        catch (MCDException mcde) {
            this.logger.error("Error updating STmin.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.trace("Leaving updateSeparationTimeRequest(...).");
        return currentJobStatus;
    }

    protected long decreaseSeparationTimeRequest(long pSeparationTimeRequest) {
        long newSeparationTimeRequest = -1L;
        this.logger.trace("Entering decreaseSeparationTimeRequest(...).");
        newSeparationTimeRequest = pSeparationTimeRequest > 127000L ? 127000L : (pSeparationTimeRequest >= 2000L ? pSeparationTimeRequest - 1000L : (pSeparationTimeRequest >= 100L && pSeparationTimeRequest <= 1000L ? pSeparationTimeRequest - 100L : 0L));
        this.logger.trace("Leaving decreaseSeparationTimeRequest(...).");
        return newSeparationTimeRequest;
    }

    protected long increaseSeparationTimeRequest(long pSeparationTimeRequest) {
        long newSeparationTimeRequest = -1L;
        this.logger.trace("Entering increaseSeparationTimeRequest(...).");
        newSeparationTimeRequest = pSeparationTimeRequest == 0xFFFFFFFFL ? 100L : (pSeparationTimeRequest < 1000L ? pSeparationTimeRequest + 100L : (pSeparationTimeRequest >= 1000L && pSeparationTimeRequest <= 126000L ? pSeparationTimeRequest + 1000L : 127000L));
        this.logger.trace("Leaving increaseSeparationTimeRequest(...).");
        return newSeparationTimeRequest;
    }

    protected void setRepeatRequestCounter(long pNumberOfRepetitions) throws MCDException {
        this.logger.trace("Entering setRepeatRequestCounter(...).");
        try {
            if (this.isPduApiUsed) {
                this.setProtocolParameterValue(this.protocolParameterSet, "CP_RepeatReqCountApp", pNumberOfRepetitions);
            } else {
                this.setProtocolParameterValue(this.protocolParameterSet, "NumberOfErrorRepetitions", pNumberOfRepetitions);
            }
        }
        catch (MCDException mcde) {
            this.logger.error("Error updating the repetition counter!");
            throw mcde;
        }
        this.logger.debug("RepeatRequestCounter set to: " + pNumberOfRepetitions);
        this.logger.trace("Leaving setRepeatRequestCounter(...).");
    }

    protected AbstractJob.JobStatus executeDiagComPrimitiveSync(MCDLogicalLink pLogicalLink, MCDDiagComPrimitive pDiagComPrimitive, int pMaxNumberOfRepetitions, boolean pRemoveDiagComPrimitive) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResult result = null;
        int diagComPrimitiveType = -1;
        int transmissionMode = -1;
        String diagComPrimitiveName = null;
        MCDValue requestPdu = null;
        String requestPduAsString = null;
        int diagComPrimitiveState = -1;
        MCDErrors errors = null;
        long startTime = 0L;
        this.logger.trace("Entering executeDiagComPrimitiveSync(...).");
        try {
            diagComPrimitiveType = pDiagComPrimitive.getObjectType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining type of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Type of diagComPrimitive: " + McdEnumDecoder.decodeMcdObjectType(diagComPrimitiveType));
        if (VendorSpecific.getServerVendor() != DServerVendor.SIEMENS || diagComPrimitiveType != 1190) {
            try {
                transmissionMode = pDiagComPrimitive.getDbObject().getTransmissionMode();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining transmission mode of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Transmission mode of diagComPrimitive: " + McdEnumDecoder.decodeMcdTransmissionMode(transmissionMode));
        }
        try {
            diagComPrimitiveName = pDiagComPrimitive.getDbObject().getShortName();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining SHORT-NAME of diagComPrimitive.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Name of diagComPrimitive: " + diagComPrimitiveName);
        if (this.logger.getLogLevel() > 0 && (diagComPrimitiveType == 1190 || diagComPrimitiveType == 1198)) {
            try {
                requestPdu = pDiagComPrimitive.getRequest().getPDU();
                requestPduAsString = this.vendorSpecific.pduValue2String(requestPdu);
                if (requestPduAsString.length() > 256) {
                    requestPduAsString = requestPduAsString.substring(0, 256) + " ... (truncated for logging)";
                }
                this.logger.debug("Request PDU of diagComPrimitive: " + requestPduAsString);
                if (this.logger.getLogLevel() >= 6) {
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " -> [   ".substring(0, 8 - Integer.toHexString(requestPdu.getBytefield().length).length()) + Integer.toHexString(requestPdu.getBytefield().length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(requestPdu));
                }
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request PDU of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        int repetitions = pMaxNumberOfRepetitions;
        block24: do {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
            this.logger.debug("Executing diagComPrimitive '" + diagComPrimitiveName + "'.");
            try {
                --repetitions;
                startTime = System.currentTimeMillis();
                result = pDiagComPrimitive.executeSync();
                this.logger.debug("Execution time of diagComPrimitive \"" + diagComPrimitiveName + "\": " + (System.currentTimeMillis() - startTime) + " ms");
            }
            catch (MCDException mcde) {
                this.logger.debug("Error executing diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("Getting errors.");
            try {
                errors = pDiagComPrimitive.getErrors();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting errors of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            if (errors == null) {
                this.logger.error("MCDDiagComPrimitive.getErrors() returned null.");
            } else {
                this.logger.debug("Handling errors.");
                currentJobStatus = this.handleErrors(errors);
            }
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                // empty if block
            }
            this.logger.debug("Determining state of diagComPrimitive.");
            try {
                diagComPrimitiveState = pDiagComPrimitive.getState();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining state of diagComPrimitive.");
                this.logger.logThrowable(mcde);
                currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                break;
            }
            this.logger.debug("State of diagComPrimitive: " + McdEnumDecoder.decodeMcdDiagComPrimitiveState(diagComPrimitiveState));
            switch (diagComPrimitiveState) {
                case 25090: {
                    try {
                        pDiagComPrimitive.cancel();
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error cancelling diagComPrimitive.");
                        this.logger.logThrowable(mcde);
                        currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        break;
                    }
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                    break;
                }
                case 25089: {
                    if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR || diagComPrimitiveType == 1201 || diagComPrimitiveType == 1202) continue block24;
                    currentJobStatus = this.handleResult(pDiagComPrimitive, diagComPrimitiveType, result);
                    this.logger.debug("job status after handleResult(): " + currentJobStatus);
                    if (currentJobStatus != AbstractJob.JobStatus.WRONG_UBATT_DETECTED) continue block24;
                    this.logger.debug("Cancelling repetitions due to detection of wrong battery voltage.");
                    repetitions = 0;
                    break;
                }
                default: {
                    this.logger.error("*** UNKNOWN MCDDiagComPrimitiveState ***: " + diagComPrimitiveState);
                }
            }
        } while (repetitions > 0 && currentJobStatus != AbstractJob.JobStatus.NO_ERROR);
        this.logger.debug("Releasing result.");
        try {
            this.job.releaseResult(result);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error releasing result.");
            this.logger.logThrowable(mcde);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pRemoveDiagComPrimitive) {
            try {
                pLogicalLink.removeDiagComPrimitive(pDiagComPrimitive);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error removing diagComPrimitive from logical link.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        this.logger.trace("Leaving executeDiagComPrimitiveSync(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResult(MCDDiagComPrimitive pDiagComPrimitive, int pDiagComPrimitiveType, MCDResult pResult) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        boolean resultHasError = false;
        this.logger.trace("Entering handleResult(...).");
        if (pDiagComPrimitiveType == 1198 || pDiagComPrimitiveType == 1190) {
            try {
                request = pDiagComPrimitive.getRequest();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting request from diagComPrimitive.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (pDiagComPrimitiveType != 1190) {
                try {
                    requestParameters = request.getRequestParameters();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting request parameters from request.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
        }
        try {
            resultHasError = pResult.hasError();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining if result has an error.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (resultHasError) {
            MCDError error = null;
            this.logger.debug("Result has error.");
            try {
                error = pResult.getError();
            }
            catch (Exception e) {
                this.logger.debug("Error getting error from result.");
                this.logger.logThrowable(e);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53392 && error.getVendorCode() == 259 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 5074 || pDiagComPrimitiveType == 1198 && this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53315 && error.getVendorCode() == 20480 || pDiagComPrimitiveType == 1198 && !this.isPduApiUsed && this.isPositiveResponseSuppressed(pDiagComPrimitiveType, requestParameters) && error.getCode() == 53327 && error.getVendorCode() == 19) {
                this.logger.debug("Ignoring P2 timeout since positive response has been suppressed.");
            } else if (error.getCode() == 53327 && error.getVendorCode() == 257) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 20) {
                this.logger.warn("CAN communication disturbed - probably error frames on bus!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_DISTURBED;
            } else if (error.getCode() == 53327 && (error.getVendorCode() == 17 || error.getVendorCode() == 25 || error.getVendorCode() == 26 || error.getVendorCode() == 42 || error.getVendorCode() == 47)) {
                this.logger.warn("Wrong battery voltage detected - probably due to an interruption of clamp 30 or 15!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.WRONG_UBATT_DETECTED;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 27) {
                this.logger.warn("EDIC interface deadlock error detected - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 53327 && error.getVendorCode() == 16 || error.getCode() == 53315 && error.getVendorCode() == 16) {
                this.logger.warn("Command refused by EDIC interface - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else if (error.getCode() == 58644 || error.getCode() == 53327 && (this.isPduApiUsed && error.getCode() == 262 || !this.isPduApiUsed && error.getCode() == 13)) {
                this.logger.warn("Communication to VCI lost (possibly due to voltage drop) - aborting execution!");
                this.logger.logMcdError(error);
                currentJobStatus = AbstractJob.JobStatus.COMMUNICATION_TO_VCI_LOST_OR_DISTURBED;
            } else {
                this.logger.logMcdError(error);
                if (error.getCode() != 49152) {
                    if (this.isPduApiUsed && error.getCode() == 53327 && error.getVendorCode() == 5076) {
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                        this.setJobInfo("ERROR: No result received from called job!");
                    } else if (error.getCode() != 49192) {
                        currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
                    } else {
                        String serviceShortName = null;
                        int resultType = -1;
                        MCDResponses responses = null;
                        try {
                            serviceShortName = pResult.getServiceShortName();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining service SHORT-NAME of result.");
                            this.logger.logThrowable(mcde);
                            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        }
                        this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
                        try {
                            resultType = pResult.getType();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error determining type of result.");
                            this.logger.logThrowable(mcde);
                            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                        }
                        this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
                        if (resultType == 1793) {
                            this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
                        } else {
                            try {
                                responses = pResult.getResponses();
                            }
                            catch (MCDException mcde) {
                                this.logger.debug("Error getting responses from result.");
                                this.logger.logThrowable(mcde);
                                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                            }
                            currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, request, requestParameters, responses);
                            this.logger.debug("job status after handleResponses(): " + currentJobStatus);
                        }
                    }
                }
            }
            if (!this.isPduApiUsed) {
                this.logger.debug("Restarting communication after timeout.");
                if (error.getCode() != 49152) {
                    this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.stopCommunication, 1, false);
                    this.executeDiagComPrimitiveSync(this.logicalLink, (MCDDiagComPrimitive)this.startCommunication, 1, false);
                }
            }
        } else {
            String serviceShortName = null;
            int resultType = -1;
            MCDResponses responses = null;
            try {
                serviceShortName = pResult.getServiceShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining service SHORT-NAME of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result for diagComPrimitive: " + serviceShortName);
            try {
                resultType = pResult.getType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining type of result.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Result is of type: " + McdEnumDecoder.decodeMcdResultType(resultType));
            if (resultType == 1793) {
                this.logger.debug("Omitting evaluation of responses for MCDResultType.eREQUEST.");
            } else {
                try {
                    responses = pResult.getResponses();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting responses from result.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                currentJobStatus = this.handleResponses(pDiagComPrimitiveType, serviceShortName, request, requestParameters, responses);
                this.logger.debug("job status after handleResponses(): " + currentJobStatus);
            }
        }
        this.logger.trace("Leaving handleResult(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleResponses(int pDiagComPrimitiveType, String pServiceShortName, MCDRequest pRequest, MCDRequestParameters pRequestParameters, MCDResponses pResponses) {
        AbstractJob.JobStatus currentJobStatus = null;
        long responseCount = 0L;
        MCDResponse response = null;
        AbstractJob.JobStatus currentStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handleResponses(...).");
        try {
            responseCount = pResponses.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of responses.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of responses: " + responseCount);
        if (!this.isPositiveResponseSuppressed(pDiagComPrimitiveType, pRequestParameters)) {
            currentJobStatus = AbstractJob.JobStatus.NO_RESPONSE_FROM_TARGET_LOCATION;
        } else if (responseCount == 0L) {
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        for (long i = 0L; i < responseCount; ++i) {
            try {
                response = pResponses.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting response with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            currentStatus = this.handleResponse(pDiagComPrimitiveType, pServiceShortName, pRequest, pRequestParameters, response);
            if (this.responseLocationAccessKey.equals(this.dbLocationAccessKey) || this.responseLocationAccessKey.equals(this.dbLocationAccessKeyBaseVariant)) {
                currentJobStatus = currentStatus;
                continue;
            }
            this.logger.debug("dbLocation of response    : " + this.responseLocationAccessKey);
            this.logger.debug("dbLocation of BASE-VARIANT: " + this.dbLocationAccessKeyBaseVariant);
            this.logger.debug("dbLocation of LOGICAL-LINK: " + this.dbLocationAccessKey);
        }
        this.logger.trace("Leaving handleResponses(...).");
        return currentJobStatus;
    }

    protected boolean isPositiveResponseSuppressed(int pDiagComPrimitiveType, MCDRequestParameters pRequestParameters) {
        MCDRequestParameter param_suppressPositiveResponseMessageIndicationBit = null;
        String suppressPositiveResponseMessageIndicationBit = null;
        this.logger.trace("Entering isPositiveResponseSuppressed(...).");
        switch (pDiagComPrimitiveType) {
            case 1198: {
                try {
                    param_suppressPositiveResponseMessageIndicationBit = pRequestParameters.getItemByName("Param_SupprPositRespoMessaIndicBit");
                    this.logger.info("Found Param_SupprPositRespoMessaIndicBit in request.");
                    try {
                        suppressPositiveResponseMessageIndicationBit = param_suppressPositiveResponseMessageIndicationBit.getValue().getValueAsString();
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting value of Param_SupprPositRespoMessaIndicBit from request.");
                        this.logger.logThrowable(mcde);
                        suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                    }
                }
                catch (MCDException mcde) {
                    this.logger.info("No Param_SupprPositRespoMessaIndicBit found in request.");
                    suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                }
                break;
            }
            case 1190: 
            case 1192: 
            case 1197: 
            case 1200: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
                break;
            }
            default: {
                suppressPositiveResponseMessageIndicationBit = Boolean.FALSE.toString().toUpperCase();
            }
        }
        if (suppressPositiveResponseMessageIndicationBit.equalsIgnoreCase(Boolean.TRUE.toString())) {
            this.logger.debug("Response has been suppressed.");
        } else {
            this.logger.debug("Response has not been suppressed.");
        }
        this.logger.trace("Leaving isPositiveResponseSuppressed(...).");
        return Boolean.valueOf(suppressPositiveResponseMessageIndicationBit);
    }

    protected AbstractJob.JobStatus handleResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequest pRequest, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDAccessKey accessKeyOfLocation = null;
        int responseState = -1;
        MCDValue responseMessage = null;
        byte[] responsePdu = null;
        MCDValue requestMessage = null;
        byte[] requestPdu = null;
        this.logger.trace("Entering handleResponse(...).");
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    accessKeyOfLocation = pResponse.getAccessKeyOfLocation();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error determining access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (accessKeyOfLocation == null) {
                    this.logger.debug("MCDResponse.getAccessKeyOfLocation() returned null!");
                    return AbstractJob.JobStatus.ERROR;
                }
                try {
                    this.responseLocationAccessKey = accessKeyOfLocation.getString();
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting string for access key of response location.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1192: 
            case 1197: 
            case 1200: {
                this.responseLocationAccessKey = this.dbLocationAccessKey;
                break;
            }
        }
        this.logger.debug("DbLocation of response: " + this.responseLocationAccessKey);
        switch (pDiagComPrimitiveType) {
            case 1190: 
            case 1198: {
                try {
                    responseMessage = pResponse.getResponseMessage();
                    this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(responseMessage));
                    if (this.logger.getLogLevel() < 6) break;
                    responsePdu = responseMessage.getBytefield();
                    this.logger.busTrace(this.getCurrentJobRuntimeAsString() + " <- [   ".substring(0, 8 - Integer.toHexString(responsePdu.length).length()) + Integer.toHexString(responsePdu.length).toUpperCase() + "] " + this.vendorSpecific.pduValue2String(responseMessage));
                    break;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting response message by getValueAsString().");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            case 1200: {
                if (pServiceShortName.equals("SinglJob_SecurAcces")) {
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace("");
                    this.logger.busTrace("See MCD3_SecurAcces_*.asc for trace of SinglJob_SecurAcces.");
                    this.logger.busTrace("");
                    break;
                }
                if (pServiceShortName.equals("SinglJob_WriteFinge")) {
                    if (this.logger.getLogLevel() < 6) break;
                    this.logger.busTrace("");
                    this.logger.busTrace("See MCD3_WriteFinge_*.asc for trace of SinglJob_WriteFinge.");
                    this.logger.busTrace("");
                    break;
                }
                if (this.logger.getLogLevel() < 6) break;
                this.logger.busTrace("");
                this.logger.busTrace("No trace available for SinglJob_SecurAcces - messages might be missing.");
                this.logger.busTrace("");
                break;
            }
            case 1192: 
            case 1197: {
                break;
            }
        }
        try {
            responseState = pResponse.getState();
        }
        catch (MCDException mcde) {
            if (VendorSpecific.getServerVendor() == DServerVendor.SIEMENS && pDiagComPrimitiveType == 1190 && mcde.getError().getCode() == 53315 && mcde.getError().getVendorCode() == 9477) {
                try {
                    requestMessage = pRequest.getPDU();
                    requestPdu = requestMessage.getBytefield();
                    if (responsePdu == null) {
                        responsePdu = responseMessage.getBytefield();
                    }
                    responseState = this.vendorSpecific.determineResponseStateFromPdus(requestPdu, responsePdu);
                }
                catch (MCDException mcde2) {
                    this.logger.debug("Error determining response state from PDUs.");
                    this.logger.logThrowable(mcde2);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
            }
            this.logger.debug("Error determining response state.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        switch (responseState) {
            case 26625: {
                currentJobStatus = this.handlePositiveResponse(pDiagComPrimitiveType, pServiceShortName, pRequest, pRequestParameters, pResponse);
                break;
            }
            case 26626: {
                currentJobStatus = this.handleNegativeResponse(pDiagComPrimitiveType, pServiceShortName, pRequest, pRequestParameters, pResponse);
                break;
            }
            default: {
                this.logger.error("Invalid MCDResponseState: " + McdEnumDecoder.decodeMcdResponseState(responseState));
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handleResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequest pRequest, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveResponse(...).");
        this.logger.debug("Response is positive.");
        switch (pDiagComPrimitiveType) {
            case 1190: {
                currentJobStatus = this.handlePositiveHexServiceResponse(pServiceShortName, pRequest, pResponse);
                break;
            }
            case 1198: {
                currentJobStatus = this.handlePositiveServiceResponse(pServiceShortName, pRequestParameters, pResponse);
                break;
            }
            case 1192: 
            case 1197: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
            case 1200: {
                currentJobStatus = this.handlePositiveJobResponse(pServiceShortName, pResponse);
                break;
            }
        }
        this.logger.trace("Leaving handlePositiveResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveJobResponse(String pJobShortName, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        this.logger.trace("Entering handlePositiveJobResponse(...).");
        if (pJobShortName.equals("SinglJob_ChangBaudRate")) {
            currentJobStatus = this.handlePositiveResponseChangeBaudRate(pResponse);
        } else if (pJobShortName.equals("SinglJob_CheckOwnIdent")) {
            currentJobStatus = this.handlePositiveResponseCheckOwnIdents(pResponse);
        } else if (pJobShortName.equals("SinglJob_SecurAcces")) {
            currentJobStatus = this.handlePositiveResponseSecurityAccess(pResponse);
        } else if (pJobShortName.equals("SinglJob_WriteFinge")) {
            currentJobStatus = this.handlePositiveResponseWriteFingerprint(pResponse);
        } else if (pJobShortName.equals("SinglJob_StartCommu")) {
            currentJobStatus = this.handlePositiveResponseStartCommunication(pResponse);
        } else {
            this.logger.debug("*** UNKNOWN job ***: " + pJobShortName);
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving handlePositiveJobResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveHexServiceResponse(String pServiceShortName, MCDRequest pRequest, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        byte responseServiceIdentifier = 0;
        byte requestServiceIdentifier = 0;
        this.logger.trace("Entering handlePositiveHexServiceResponse(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (VendorSpecific.getServerVendor() == DServerVendor.SIEMENS) {
            int numberOfMetaDataBytesInCifResponsePdus = 8;
            this.logger.debug("Response PDU (CIF)  : " + Conversions.byteArray2String(responseMessage));
            byte[] tempPdu = new byte[responseMessage.length];
            System.arraycopy(responseMessage, 0, tempPdu, 0, tempPdu.length);
            responseMessage = new byte[tempPdu.length - 8];
            System.arraycopy(tempPdu, 8, responseMessage, 0, responseMessage.length);
            this.logger.debug("Response PDU (SIDIS): " + Conversions.byteArray2String(responseMessage));
        }
        if (responseMessage.length < 1) {
            this.logger.error("Error getting response service id from response with length of " + responseMessage.length + " bytes.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        responseServiceIdentifier = responseMessage[0];
        if ((responseServiceIdentifier & 0x40 & 0xFF) == 0) {
            this.logger.error("The extracted response service id (0x" + Integer.toHexString(responseServiceIdentifier & 0xFF).toUpperCase() + ") is not a positive response service identifier!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        requestServiceIdentifier = (byte)(responseServiceIdentifier - 64);
        switch (requestServiceIdentifier) {
            case 49: {
                currentJobStatus = this.handlePositiveHexResponseRoutineControl(pRequest, pResponse);
                break;
            }
            default: {
                this.logger.debug("*** UNKNOWN hex service ***: " + pServiceShortName);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handlePositiveHexServiceResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveServiceResponse(String pServiceShortName, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        byte responseServiceIdentifier = 0;
        byte requestServiceIdentifier = 0;
        this.logger.trace("Entering handlePositiveServiceResponse(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
            responseMessageString = pResponse.getResponseMessage().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length < 1) {
            this.logger.error("Error getting response service id from response with length of " + responseMessage.length + " bytes.");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        responseServiceIdentifier = responseMessage[0];
        if ((responseServiceIdentifier & 0x40 & 0xFF) == 0) {
            this.logger.error("The extracted response service id (0x" + Integer.toHexString(responseServiceIdentifier & 0xFF).toUpperCase() + ") is not a positive response service identifier!");
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        requestServiceIdentifier = (byte)(responseServiceIdentifier - 64);
        try {
            numberOfResponseParameters = pResponse.getResponseParameters().getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.warn("Ignoring response since it is not covered by a database response: " + responseMessageString);
        } else {
            switch (requestServiceIdentifier) {
                case 16: {
                    currentJobStatus = this.handlePositiveResponseDiagnosticSessionControl(pRequestParameters, pResponse);
                    break;
                }
                case 17: {
                    currentJobStatus = this.handlePositiveResponseEcuReset(pRequestParameters, pResponse);
                    break;
                }
                case 40: {
                    currentJobStatus = this.handlePositiveResponseCommunicationControl(pRequestParameters, pResponse);
                    break;
                }
                case 49: {
                    currentJobStatus = this.handlePositiveResponseRoutineControl(pRequestParameters, pResponse);
                    break;
                }
                case 52: {
                    currentJobStatus = this.handlePositiveResponseRequestDownload(pResponse);
                    break;
                }
                case 54: {
                    currentJobStatus = this.handlePositiveResponseTransferData(pRequestParameters, pResponse);
                    break;
                }
                case 55: {
                    currentJobStatus = this.handlePositiveResponseRequestTransferExit(pResponse);
                    break;
                }
                case -123: {
                    currentJobStatus = this.handlePositiveResponseControlDTCSetting(pRequestParameters, pResponse);
                    break;
                }
                default: {
                    this.logger.debug("*** UNKNOWN service ***: " + pServiceShortName);
                    currentJobStatus = AbstractJob.JobStatus.ERROR;
                }
            }
        }
        this.logger.trace("Leaving handlePositiveServiceResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseDiagnosticSessionControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String diagnosticSessionTypeRequest = null;
        String diagnosticSessionTypeResponse = null;
        MCDResponseParameters responseParameters = null;
        long p2CanServer = 0L;
        long p2StarCanServer = 0L;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseDiagnosticSessionControl(...).");
        try {
            diagnosticSessionTypeRequest = pRequestParameters.getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of request (Param_DiagnSessiType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            diagnosticSessionTypeResponse = pResponse.getResponseParameters().getItemByName("Param_DiagnSessiType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting diagnostic session type of response (Param_DiagnSessiType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!diagnosticSessionTypeResponse.equals(diagnosticSessionTypeRequest)) {
            this.logger.error("diagnosticSessionType of response does NOT match request: " + diagnosticSessionTypeRequest + " / " + diagnosticSessionTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            p2CanServer = responseParameters.getItemByName("Param_StandTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_StandTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
            this.logger.warn("Leaving session timings untouched since new timings could not be extracted from response!");
            return AbstractJob.JobStatus.NO_ERROR;
        }
        this.logger.info("Current value of P2_CAN_Server is: " + p2CanServer + " ms.");
        try {
            p2StarCanServer = responseParameters.getItemByName("Param_ExtenTiminP2Serve").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error reading Param_ExtenTiminP2Serve from response.");
            this.logger.logThrowable(mcde);
            this.logger.warn("Leaving session timings untouched since new timings could not be extracted from response!");
            return AbstractJob.JobStatus.NO_ERROR;
        }
        this.logger.info("Current value of P2*_CAN_Server is: " + p2StarCanServer + " ms.");
        if (!this.isPduApiUsed && p2StarCanServer > 65500L - this.savedCanTransmissionTime) {
            this.logger.warn("Provided value of P2*_CAN_Server exceeds maximum timeout supported by Softing EIDBSS firmware (" + (65500L - this.savedCanTransmissionTime) + " ms)...");
            this.logger.warn("... limiting P2*_CAN_Server to maximum supported value.");
            p2StarCanServer = (int)(65500L - this.savedCanTransmissionTime);
            this.logger.info("Current value of P2*_CAN_Server is now: " + p2StarCanServer + " ms.");
        }
        try {
            currentJobStatus = this.updateSessionTimings(this.protocolParameterSet, p2CanServer, p2StarCanServer);
        }
        catch (MCDException mcde) {
            this.logger.error("Error updating session timings.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
            return currentJobStatus;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 6) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseDiagnosticSessionControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseEcuReset(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String resetTypeRequest = null;
        String resetTypeResponse = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseEcuReset(...).");
        try {
            resetTypeRequest = pRequestParameters.getItemByName("Param_ResetType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting reset type of request (Param_ResetType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            resetTypeResponse = pResponse.getResponseParameters().getItemByName("Param_ResetType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting reset type of response (Param_ResetType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!resetTypeResponse.equals(resetTypeRequest)) {
            this.logger.error("resetType of response does NOT match request: " + resetTypeRequest + " / " + resetTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseEcuReset(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseChangeBaudRate(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusChangeBaudRate = null;
        this.logger.trace("Entering handlePositiveResponseChangeBaudRate(...).");
        try {
            jobCompletionStatusChangeBaudRate = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status (OPA_JobComplStatu).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of Change Baud Rate is: " + jobCompletionStatusChangeBaudRate + ".");
        currentJobStatus = jobCompletionStatusChangeBaudRate.equals("Job completed successfully") || jobCompletionStatusChangeBaudRate.equals("Job completed with warnings") ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.ERROR;
        this.logger.trace("Leaving handlePositiveResponseChangeBaudRate(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseCheckOwnIdents(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusCheckOwnIdents = null;
        MCDResponseParameters outDatedDataBlocks = null;
        String dataBlockName = null;
        String namesOfOutdatedDataBlocks = null;
        this.logger.trace("Entering handlePositiveResponseCheckOwnIdents(...).");
        try {
            jobCompletionStatusCheckOwnIdents = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status (OPA_JobComplStatu).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of Check OWN-IDENTS is: " + jobCompletionStatusCheckOwnIdents + ".");
        if (!jobCompletionStatusCheckOwnIdents.equals("Job completed successfully")) {
            this.logger.debug("Disabling partial programming due to errors during OWN-IDENT check!");
            this.partialFlashProgrammingEnabled = false;
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        } else {
            this.outdatedDataBlocks = new TreeSet();
            try {
                outDatedDataBlocks = pResponse.getResponseParameters().getItemByName("OPA_OutdaDataBlock").getParameters();
                this.logger.debug("Got " + outDatedDataBlocks.getCount() + " outdated data blocks.");
                int i = 0;
                while ((long)i < outDatedDataBlocks.getCount()) {
                    try {
                        dataBlockName = outDatedDataBlocks.getItemByIndex((long)i).getParameters().getItemByName("Param_DataBlockSHORTNAME").getValue().getValueAsString();
                    }
                    catch (MCDException mcde) {
                        dataBlockName = outDatedDataBlocks.getItemByIndex((long)i).getValue().getValueAsString();
                    }
                    namesOfOutdatedDataBlocks = namesOfOutdatedDataBlocks == null ? dataBlockName : namesOfOutdatedDataBlocks + ", " + dataBlockName;
                    this.outdatedDataBlocks.add(dataBlockName);
                    ++i;
                }
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting outdated data blocks (OPA_OutdaDataBlock).");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (namesOfOutdatedDataBlocks != null) {
                this.logger.info("[PFL] Outdated data blocks: " + namesOfOutdatedDataBlocks);
                this.setJobInfo("[PFL] Outdated data blocks: " + namesOfOutdatedDataBlocks);
            }
            currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        }
        this.logger.trace("Leaving handlePositiveResponseCheckOwnIdents(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseSecurityAccess(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusSecurityAccess = null;
        this.logger.trace("Entering handlePositiveResponseSecurityAccess(...).");
        try {
            jobCompletionStatusSecurityAccess = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status (OPA_JobComplStatu).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of security access is: " + jobCompletionStatusSecurityAccess + ".");
        currentJobStatus = jobCompletionStatusSecurityAccess.equals("Job completed successfully") || jobCompletionStatusSecurityAccess.equals("Job completed with warnings") ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.SECURITY_ACCESS_FAILED;
        this.logger.trace("Leaving handlePositiveResponseSecurityAccess(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseWriteFingerprint(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusWriteFingerprint = null;
        this.logger.trace("Entering handlePositiveResponseWriteFingerprint(...).");
        try {
            jobCompletionStatusWriteFingerprint = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status (OPA_JobComplStatu).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of writing fingerprint is: " + jobCompletionStatusWriteFingerprint + ".");
        currentJobStatus = jobCompletionStatusWriteFingerprint.equals("Job completed successfully") || jobCompletionStatusWriteFingerprint.equals("Job completed with warnings") ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.ERROR_WRITING_FINGERPRINT;
        this.logger.trace("Leaving handlePositiveResponseWriteFingerprint(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseStartCommunication(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String jobCompletionStatusStartCommunication = null;
        this.logger.trace("Entering handlePositiveResponseStartCommunication(...).");
        try {
            jobCompletionStatusStartCommunication = pResponse.getResponseParameters().getItemByName("OPA_JobComplStatu").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting job completion status (OPA_JobComplStatu).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.info("Completion status of (re)starting communication is: " + jobCompletionStatusStartCommunication + ".");
        currentJobStatus = jobCompletionStatusStartCommunication.equals("Job completed successfully") || jobCompletionStatusStartCommunication.equals("Job completed with warnings") ? AbstractJob.JobStatus.NO_ERROR : AbstractJob.JobStatus.ERROR;
        this.logger.trace("Leaving handlePositiveResponseStartCommunication(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseCommunicationControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseCommunicationControl(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseCommunicationControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseRoutineControl(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String routineControlTypeRequest = null;
        String routineControlTypeResponse = null;
        String routineIdentifierRequest = null;
        String routineIdentifierResponse = null;
        MCDResponseParameters responseParameters = null;
        this.logger.trace("Entering handlePositiveResponseRoutineControl(...).");
        try {
            responseParameters = pResponse.getResponseParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            routineControlTypeRequest = pRequestParameters.getItemByName("Param_RoutiContrType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine control type of request (Param_RoutiContrType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            routineControlTypeResponse = responseParameters.getItemByName("Param_RoutiContrType").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine control type of response (Param_RoutiContrType).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!routineControlTypeResponse.equals(routineControlTypeRequest)) {
            this.logger.error("routineControlType of response does NOT match request: " + routineControlTypeRequest + " / " + routineControlTypeResponse);
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        try {
            routineIdentifierRequest = pRequestParameters.getItemByName("Param_RoutiIdent").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine identifier of request (Param_RoutiIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            routineIdentifierResponse = responseParameters.getItemByName("Param_RoutiIdent").getValue().getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine identifier of response (Param_RoutiIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (!routineIdentifierResponse.equals(routineIdentifierRequest)) {
            this.logger.error("routineIdentifier of response does NOT match request: " + routineIdentifierRequest + " / " + routineIdentifierResponse);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (routineIdentifierResponse.equals("Check Programming Preconditions")) {
            currentJobStatus = this.handleRoutineStatusCheckProgrammingPreconditions(responseParameters);
        } else if (routineIdentifierResponse.equals("Erase Memory")) {
            currentJobStatus = this.handleRoutineStatusEraseMemory(pResponse, responseParameters);
        } else if (routineIdentifierResponse.equals("Check Memory")) {
            currentJobStatus = this.handleRoutineStatusCheckMemory(pResponse, responseParameters);
        } else if (routineIdentifierResponse.equals("Check Programming Dependencies")) {
            currentJobStatus = this.handleRoutineStatusCheckProgrammingDependencies(pResponse, responseParameters);
        } else {
            this.logger.error("*** UNKNOWN routineIdentifier ***: " + routineIdentifierResponse);
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        }
        this.logger.trace("Leaving handlePositiveResponseRoutineControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveHexResponseRoutineControl(MCDRequest pRequest, MCDResponse pResponse) {
        byte[] tempPdu;
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDDbService routineControl = null;
        MCDDbRequest dbRequest = null;
        MCDDbResponse dbResponse = null;
        MCDDbRequestParameters dbRequestParameters = null;
        MCDDbResponseParameters dbResponseParameters = null;
        MCDDbRequestParameter dbRequestParameter_routineControlType = null;
        MCDDbRequestParameter dbRequestParameter_routineIdentifier = null;
        MCDDbResponseParameter dbResponseParameter_routineControlType = null;
        MCDDbResponseParameter dbResponseParameter_routineIdentifier = null;
        int numberOfRequestSidBytesInRequestPdu = 0;
        MCDValue value_requestPdu = null;
        byte[] requestPdu = null;
        MCDValue responseMessage = null;
        byte[] responsePdu = null;
        byte routineControlTypeRequestValue = 0;
        byte routineControlTypeResponseValue = 0;
        short routineIdentifierRequestValue = 0;
        short routineIdentifierResponseValue = 0;
        String routineControlTypeRequest = null;
        String routineControlTypeResponse = null;
        String routineIdentifierRequest = null;
        String routineIdentifierResponse = null;
        this.logger.trace("Entering handlePositiveHexResponseRoutineControl(...).");
        try {
            routineControl = this.dbLocationOfLogicalLink.getDbServices().getItemByName("DiagnServi_RoutiContrCheckMemor");
            dbRequest = routineControl.getDbRequest();
            dbResponse = routineControl.getDbResponsesByType(28417).getItemByIndex(0L);
            dbRequestParameters = dbRequest.getDbRequestParameters();
            dbResponseParameters = dbResponse.getDbResponseParameters();
            dbRequestParameter_routineControlType = dbRequestParameters.getItemByName("Param_RoutiContrType");
            dbRequestParameter_routineIdentifier = dbRequestParameters.getItemByName("Param_RoutiIdent");
            dbResponseParameter_routineControlType = dbResponseParameters.getItemByName("Param_RoutiContrType");
            dbResponseParameter_routineIdentifier = dbResponseParameters.getItemByName("Param_RoutiIdent");
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.isMcd20002Interface) {
            numberOfRequestSidBytesInRequestPdu = 1;
        }
        try {
            value_requestPdu = pRequest.getPDU();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting request PDU from request.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            requestPdu = value_requestPdu.getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting request PDU from PDU value.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (VendorSpecific.getServerVendor() == DServerVendor.SIEMENS) {
            int numberOfMetaDataBytesInCifRequestPdus = 7;
            this.logger.debug("Request  PDU (CIF)  : " + Conversions.byteArray2String(requestPdu));
            tempPdu = new byte[requestPdu.length];
            System.arraycopy(requestPdu, 0, tempPdu, 0, tempPdu.length);
            requestPdu = new byte[tempPdu.length - 7];
            System.arraycopy(tempPdu, 7, requestPdu, 0, requestPdu.length);
            this.logger.debug("Request  PDU (SIDIS): " + Conversions.byteArray2String(requestPdu));
        }
        try {
            responseMessage = pResponse.getResponseMessage();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message from response.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            responsePdu = responseMessage.getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response PDU from response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (VendorSpecific.getServerVendor() == DServerVendor.SIEMENS) {
            int numberOfMetaDataBytesInCifResponsePdus = 8;
            tempPdu = new byte[responsePdu.length];
            System.arraycopy(responsePdu, 0, tempPdu, 0, tempPdu.length);
            responsePdu = new byte[tempPdu.length - 8];
            System.arraycopy(tempPdu, 8, responsePdu, 0, responsePdu.length);
        }
        if (requestPdu.length < numberOfRequestSidBytesInRequestPdu + 1) {
            this.logger.error("Request PDU is too short to extract routine control type from request!");
            return AbstractJob.JobStatus.ERROR;
        }
        routineControlTypeRequestValue = requestPdu[numberOfRequestSidBytesInRequestPdu];
        if (VendorSpecific.getServerVendor() != DServerVendor.SIEMENS) {
            try {
                routineControlTypeRequest = VendorSpecific.getServerVendor() == DServerVendor.DSA && !this.isMcd300Interface && dbRequestParameter_routineControlType.getParameterType() == 14 && dbRequestParameter_routineControlType.isConstant() ? dbRequestParameter_routineControlType.getDefaultValue().getValueAsString() : this.vendorSpecific.getTextTableElementOfDbParameterByCodedValueUint32((MCDDbParameter)dbRequestParameter_routineControlType, routineControlTypeRequestValue).getLongName();
            }
            catch (MCDException mcde) {
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        if (responsePdu.length < 2) {
            this.logger.error("Response PDU is too short to extract routine control type from response!");
            return AbstractJob.JobStatus.ERROR;
        }
        routineControlTypeResponseValue = responsePdu[1];
        if (VendorSpecific.getServerVendor() != DServerVendor.SIEMENS) {
            try {
                routineControlTypeResponse = VendorSpecific.getServerVendor() == DServerVendor.DSA && !this.isMcd300Interface && dbResponseParameter_routineControlType.getParameterType() == 14 && dbResponseParameter_routineControlType.isConstant() ? dbResponseParameter_routineControlType.getDefaultValue().getValueAsString() : this.vendorSpecific.getTextTableElementOfDbParameterByCodedValueUint32((MCDDbParameter)dbResponseParameter_routineControlType, routineControlTypeResponseValue).getLongName();
            }
            catch (MCDException mcde) {
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        if (VendorSpecific.getServerVendor() != DServerVendor.SIEMENS) {
            if (!routineControlTypeResponse.equals(routineControlTypeRequest)) {
                this.logger.error("routineControlType of response does NOT match request: " + routineControlTypeRequest + " / " + routineControlTypeResponse);
                return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
            }
        } else if (routineControlTypeResponseValue != routineControlTypeRequestValue) {
            this.logger.error("routineControlType of response does NOT match request: 0x" + Integer.toHexString(routineControlTypeRequestValue).toUpperCase() + " / 0x" + Integer.toHexString(routineControlTypeResponseValue).toUpperCase());
            return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
        }
        if (requestPdu.length < numberOfRequestSidBytesInRequestPdu + 1 + 2) {
            this.logger.error("Request PDU is too short to extract routine identifier from request!");
            return AbstractJob.JobStatus.ERROR;
        }
        routineIdentifierRequestValue = (short)(requestPdu[numberOfRequestSidBytesInRequestPdu + 1] << 8);
        routineIdentifierRequestValue = (short)(routineIdentifierRequestValue + requestPdu[numberOfRequestSidBytesInRequestPdu + 2]);
        if (VendorSpecific.getServerVendor() != DServerVendor.SIEMENS) {
            try {
                routineIdentifierRequest = VendorSpecific.getServerVendor() == DServerVendor.DSA && !this.isMcd300Interface && dbRequestParameter_routineIdentifier.getParameterType() == 14 && dbRequestParameter_routineIdentifier.isConstant() ? dbRequestParameter_routineIdentifier.getDefaultValue().getValueAsString() : this.vendorSpecific.getTextTableElementOfDbParameterByCodedValueUint32((MCDDbParameter)dbRequestParameter_routineIdentifier, routineIdentifierRequestValue).getLongName();
            }
            catch (MCDException mcde) {
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        if (responsePdu.length < 4) {
            this.logger.error("Response PDU is too short to extract routine identifier from response!");
            return AbstractJob.JobStatus.ERROR;
        }
        routineIdentifierResponseValue = (short)(responsePdu[2] << 8);
        routineIdentifierResponseValue = (short)(routineIdentifierResponseValue + responsePdu[3]);
        if (VendorSpecific.getServerVendor() != DServerVendor.SIEMENS) {
            try {
                routineIdentifierResponse = this.vendorSpecific.getTextTableElementOfDbParameterByCodedValueUint32((MCDDbParameter)dbResponseParameter_routineIdentifier, routineIdentifierResponseValue).getLongName();
            }
            catch (MCDException mcde) {
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (!routineIdentifierResponse.equals(routineIdentifierRequest)) {
                this.logger.error("routineIdentifier of response does NOT match request: " + routineIdentifierRequest + " / " + routineIdentifierResponse);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (routineIdentifierResponse.equals("Check Memory")) {
                currentJobStatus = this.handleRoutineStatusHexCheckMemory(dbResponseParameters, responsePdu);
            } else {
                this.logger.error("*** UNKNOWN routineIdentifier ***: " + routineIdentifierResponse);
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        } else {
            if (routineIdentifierResponseValue != routineIdentifierRequestValue) {
                this.logger.error("routineIdentifier of response does NOT match request: 0x" + Integer.toHexString(routineIdentifierRequestValue).toUpperCase() + " / 0x" + Integer.toHexString(routineIdentifierResponseValue).toUpperCase());
                return AbstractJob.JobStatus.REQUEST_PARAMETER_MISMATCH;
            }
            if (routineIdentifierResponseValue == 514) {
                currentJobStatus = this.handleRoutineStatusHexCheckMemory(dbResponseParameters, responsePdu);
            } else {
                this.logger.error("*** UNKNOWN routineIdentifier ***: 0x" + Integer.toHexString(routineIdentifierResponseValue).toUpperCase());
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            }
        }
        this.logger.trace("Leaving handlePositiveHexResponseRoutineControl(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleRoutineStatusCheckProgrammingPreconditions(MCDResponseParameters pResponseParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResponseParameters unfulfilledPreconditions = null;
        long numberOfUnfulfilledPreconditions = 0L;
        MCDResponseParameter unfulfilledPrecondition = null;
        String preconditionAsString = null;
        this.logger.trace("Entering handleRoutineStatusCheckProgrammingPreconditions(...).");
        try {
            unfulfilledPreconditions = pResponseParameters.getItemByName("Param_ProgrPrecoList").getParameters();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine status (Param_ProgrPrecoList).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            numberOfUnfulfilledPreconditions = unfulfilledPreconditions.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of unfulfilled preconditions.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Number of unfulfilled preconditions: " + numberOfUnfulfilledPreconditions);
        if (numberOfUnfulfilledPreconditions > 0L) {
            currentJobStatus = AbstractJob.JobStatus.UNFULFILLED_PRECONDITIONS;
            this.setJobInfo("The ECU reported " + numberOfUnfulfilledPreconditions + " unfulfilled programming preconditions!");
            for (long i = 0L; i < numberOfUnfulfilledPreconditions; ++i) {
                try {
                    unfulfilledPrecondition = unfulfilledPreconditions.getItemByIndex(i);
                    if (unfulfilledPrecondition.getType() == 17) {
                        unfulfilledPrecondition = unfulfilledPrecondition.getParameters().getItemByName("Param_ProgrPreco");
                    }
                    if (unfulfilledPrecondition == null) {
                        this.logger.error("Error getting unfulfilled preconditions (Param_ProgrPreco).");
                        preconditionAsString = "*** UNKNOWN precondition ***";
                    } else {
                        preconditionAsString = unfulfilledPrecondition.getValue().getValueAsString();
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting unfulfilled preconditions (Param_ProgrPreco).");
                    this.logger.logThrowable(mcde);
                    preconditionAsString = "*** UNKNOWN precondition ***";
                }
                this.logger.info("Unfulfilled programming precondition (" + (i + 1L) + "): " + preconditionAsString);
                this.setJobInfo("Unfulfilled programming precondition (" + (i + 1L) + "): " + preconditionAsString);
            }
        }
        this.logger.trace("Leaving handleRoutineStatusCheckProgrammingPreconditions(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleRoutineStatusEraseMemory(MCDResponse pResponse, MCDResponseParameters pResponseParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        MCDResponseParameter responseParameterRoutineStatus = null;
        MCDResponseParameters responseParametersRoutineStatus = null;
        int typeOfResponseParameterRoutineStatus = 0;
        MCDValue valueRoutineStatus = null;
        String routineStatus = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handleRoutineStatusEraseMemory(...).");
        try {
            numberOfResponseParameters = pResponseParameters.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.error("Number of response parameter is zero!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            for (long i = 0L; i < numberOfResponseParameters && !(responseParameterRoutineStatus = pResponseParameters.getItemByIndex(i)).getShortName().startsWith("Param_RoutiStatu"); ++i) {
                responseParameterRoutineStatus = null;
            }
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameter Param_RoutiStatu!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseParameterRoutineStatus == null) {
            this.logger.error("Error getting response parameter Param_RoutiStatu!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            typeOfResponseParameterRoutineStatus = responseParameterRoutineStatus.getType();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting type of response parameter with index 0!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Response parameter with index 0 has type: " + McdEnumDecoder.decodeMcdDataType(typeOfResponseParameterRoutineStatus));
        if (typeOfResponseParameterRoutineStatus == 17) {
            try {
                responseParametersRoutineStatus = responseParameterRoutineStatus.getParameters();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response parameters of (Param_RoutiStatu).");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                responseParameterRoutineStatus = responseParametersRoutineStatus.getItemByName("Param_RoutiStatuEraseOrCheckMemor");
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response parameter Param_RoutiStatuEraseOrCheckMemor!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        try {
            valueRoutineStatus = responseParameterRoutineStatus.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value of Param_RoutiStatuEraseOrCheckMemor!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            routineStatus = valueRoutineStatus.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine status (Param_RoutiStatuEraseOrCheckMemor).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Routine status is: " + routineStatus);
        if (!routineStatus.equals("Correct Result")) {
            this.logger.fatal("The erase routine could NOT be executed successfully: " + routineStatus);
            return AbstractJob.JobStatus.ERASE_ERROR;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 5) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handleRoutineStatusEraseMemory(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleRoutineStatusCheckMemory(MCDResponse pResponse, MCDResponseParameters pResponseParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        MCDResponseParameter responseParameterRoutineStatus = null;
        MCDResponseParameters responseParametersRoutineStatus = null;
        int typeOfResponseParameterRoutineStatus = 0;
        MCDValue valueRoutineStatus = null;
        String routineStatus = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handleRoutineStatusCheckMemory(...).");
        try {
            numberOfResponseParameters = pResponseParameters.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.error("Number of response parameter is zero!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            for (long i = 0L; i < numberOfResponseParameters && !(responseParameterRoutineStatus = pResponseParameters.getItemByIndex(i)).getShortName().startsWith("Param_RoutiStatu"); ++i) {
                responseParameterRoutineStatus = null;
            }
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameter Param_RoutiStatu!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseParameterRoutineStatus == null) {
            this.logger.error("Error getting response parameter Param_RoutiStatu!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            typeOfResponseParameterRoutineStatus = responseParameterRoutineStatus.getType();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting type of response parameter with index 0!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Response parameter with index 0 has type: " + McdEnumDecoder.decodeMcdDataType(typeOfResponseParameterRoutineStatus));
        if (typeOfResponseParameterRoutineStatus == 17) {
            try {
                responseParametersRoutineStatus = responseParameterRoutineStatus.getParameters();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response parameters of (Param_RoutiStatu).");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                responseParameterRoutineStatus = responseParametersRoutineStatus.getItemByName("Param_RoutiStatuEraseOrCheckMemor");
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response parameter Param_RoutiStatuEraseOrCheckMemor!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        try {
            valueRoutineStatus = responseParameterRoutineStatus.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value of Param_RoutiStatuEraseOrCheckMemor!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            routineStatus = valueRoutineStatus.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine status (Param_RoutiStatuEraseOrCheckMemor).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Routine status is: " + routineStatus);
        if (!routineStatus.equals("Correct Result")) {
            this.logger.fatal("The checksum verification failed: " + routineStatus);
            return AbstractJob.JobStatus.CHECKSUM_ERROR;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 5) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handleRoutineStatusCheckMemory(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleRoutineStatusHexCheckMemory(MCDDbResponseParameters pDbResponseParameters, byte[] pResponsePdu) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDDbParameter dbResponseParameter_routineStatus = null;
        byte routineStatusValue = 0;
        MCDTextTableElement texttableElement_routineStatus = null;
        String routineStatus = null;
        String responseMessageString = null;
        this.logger.trace("Entering handleRoutineStatusHexCheckMemory(...).");
        try {
            dbResponseParameter_routineStatus = pDbResponseParameters.getItemByName("Param_RoutiStatu").getDbParameters().getItemByName("Param_RoutiStatuEraseOrCheckMemor");
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (pResponsePdu.length < 5) {
            this.logger.error("Response PDU is too short to extract routine status from response!");
            return AbstractJob.JobStatus.ERROR;
        }
        routineStatusValue = pResponsePdu[4];
        if (VendorSpecific.getServerVendor() != DServerVendor.SIEMENS) {
            try {
                texttableElement_routineStatus = this.vendorSpecific.getTextTableElementOfDbParameterByCodedValueUint32(dbResponseParameter_routineStatus, routineStatusValue);
                routineStatus = texttableElement_routineStatus != null ? this.vendorSpecific.getTextTableElementOfDbParameterByCodedValueUint32(dbResponseParameter_routineStatus, routineStatusValue).getLongName() : "***UNKNOWN*** routine status";
            }
            catch (MCDException mcde) {
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Routine status is: " + routineStatus);
            if (!routineStatus.equals("Correct Result")) {
                this.logger.error("The checksum verification failed: " + routineStatus);
                return AbstractJob.JobStatus.CHECKSUM_ERROR;
            }
        } else {
            this.logger.debug("Routine status is: 0x" + Integer.toHexString(routineStatusValue).toUpperCase());
            if (routineStatusValue != 0) {
                this.logger.error("The checksum verification failed: 0x" + Integer.toHexString(routineStatusValue).toUpperCase());
                return AbstractJob.JobStatus.CHECKSUM_ERROR;
            }
        }
        if (pResponsePdu.length > 5) {
            responseMessageString = Conversions.byteArray2String(pResponsePdu);
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handleRoutineStatusHexCheckMemory(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleRoutineStatusCheckProgrammingDependencies(MCDResponse pResponse, MCDResponseParameters pResponseParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        MCDResponseParameter responseParameterRoutineStatus = null;
        MCDResponseParameters responseParametersRoutineStatus = null;
        int typeOfResponseParameterRoutineStatus = 0;
        MCDValue valueRoutineStatus = null;
        String routineStatus = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handleRoutineStatusCheckProgrammingDependencies(...).");
        try {
            numberOfResponseParameters = pResponseParameters.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of response parameters!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (numberOfResponseParameters == 0L) {
            this.logger.error("Number of response parameter is zero!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            for (long i = 0L; i < numberOfResponseParameters && !(responseParameterRoutineStatus = pResponseParameters.getItemByIndex(i)).getShortName().startsWith("Param_RoutiStatu"); ++i) {
                responseParameterRoutineStatus = null;
            }
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameter Param_RoutiStatu!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseParameterRoutineStatus == null) {
            this.logger.error("Error getting response parameter Param_RoutiStatu!");
            return AbstractJob.JobStatus.ERROR;
        }
        try {
            typeOfResponseParameterRoutineStatus = responseParameterRoutineStatus.getType();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting type of response parameter with index 0!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Response parameter with index 0 has type: " + McdEnumDecoder.decodeMcdDataType(typeOfResponseParameterRoutineStatus));
        if (typeOfResponseParameterRoutineStatus == 17) {
            try {
                responseParametersRoutineStatus = responseParameterRoutineStatus.getParameters();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response parameters of (Param_RoutiStatu).");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            try {
                responseParameterRoutineStatus = responseParametersRoutineStatus.getItemByName("Param_RoutiStatuCheckProgrDepen");
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response parameter Param_RoutiStatuCheckProgrDepen!");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
        }
        try {
            valueRoutineStatus = responseParameterRoutineStatus.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value of Param_RoutiStatuCheckProgrDepen!");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            routineStatus = valueRoutineStatus.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting routine status (Param_RoutiStatuCheckProgrDepen).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("Routine status is: " + routineStatus);
        if (!routineStatus.equals("Correct Result")) {
            this.logger.fatal("The programming dependencies of the ECU are NOT fulfilled - result of the routine: " + routineStatus);
            return AbstractJob.JobStatus.UNFULFILLED_PROGRAMMING_DEPENDENCIES;
        }
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 5) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handleRoutineStatusCheckProgrammingDependencies(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseRequestDownload(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte lengthFormatIdentifier = 0;
        byte[] maxNumberOfBlockLength = null;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseRequestDownload(...).");
        try {
            lengthFormatIdentifier = (byte)pResponse.getResponseParameters().getItemByName("Param_LengtFormaIdent").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting length format identifier (Param_LengtFormaIdent).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (this.isMcd20002Interface) {
            if (lengthFormatIdentifier % 8 != 0) {
                this.logger.error("Error calculating byte length of lengthFormatIdentifier with bit length " + lengthFormatIdentifier + " ( *NOT* a multiple of 8 )!");
                return AbstractJob.JobStatus.ERROR;
            }
            lengthFormatIdentifier = (byte)(lengthFormatIdentifier / 8);
        }
        try {
            maxNumberOfBlockLength = pResponse.getResponseParameters().getItemByName("Param_MaxNumbeOfBlockLengt").getValue().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting currentMaxNumberOfBlockLength (Param_MaxNumbeOfBlockLengt).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (maxNumberOfBlockLength.length != lengthFormatIdentifier) {
            this.logger.error("Byte size of currentMaxNumberOfBlockLength (" + maxNumberOfBlockLength.length + ") does NOT match length format identifier (" + lengthFormatIdentifier + ").");
            return AbstractJob.JobStatus.FORMAT_IDENTIFIER_MISMATCH;
        }
        this.currentMaxNumberOfBlockLength = Conversions.byteArray2Long(maxNumberOfBlockLength);
        if (this.currentMaxNumberOfBlockLength > this.maximumBlockSizeTransportLayer) {
            this.logger.info("currentMaxNumberOfBlockLength (" + this.currentMaxNumberOfBlockLength + ") exceeds maximum block size of underlying transport layer (" + this.maximumBlockSizeTransportLayer + " bytes)!");
            this.logger.info("Limiting currentMaxNumberOfBlockLength to " + this.maximumBlockSizeTransportLayer + " bytes.");
            this.currentMaxNumberOfBlockLength = this.maximumBlockSizeTransportLayer;
        } else {
            this.logger.info("currentMaxNumberOfBlockLength is: " + this.currentMaxNumberOfBlockLength + " bytes.");
        }
        this.currentMaxNumberOfBlockLength -= 2L;
        if (this.currentMaxNumberOfBlockLength < 1L) {
            this.logger.error("Netto value of currentMaxNumberOfBlockLength (" + this.currentMaxNumberOfBlockLength + ") MUST be at least 1 byte.");
            currentJobStatus = AbstractJob.JobStatus.INVALID_MAX_NUMBER_OF_BLOCK_LENGTH;
        }
        this.logMemoryUsage();
        try {
            this.currentBinaryDataBuffer = ByteBuffer.wrap(this.dbFlashSegment[this.currentFlashDataBlock][this.currentFlashSegment].getBinaryData());
        }
        catch (MCDException mcde) {
            this.logger.error("Error wrapping binary data of current flash segment into buffer.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logMemoryUsage();
        int blockSize = this.currentBinaryDataBuffer.capacity();
        this.numberOfDataChunks = blockSize / (int)this.currentMaxNumberOfBlockLength;
        if (blockSize % (int)this.currentMaxNumberOfBlockLength != 0) {
            ++this.numberOfDataChunks;
        }
        this.currentBinaryDataBuffer.position(0);
        this.currentDataChunk = 0;
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2 + lengthFormatIdentifier) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseRequestDownload(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseTransferData(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte blockSequenceCounterRequest = 0;
        byte blockSequenceCounterResponse = 0;
        int transferRequestParameterRecordLength = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseTransferData(...).");
        try {
            blockSequenceCounterRequest = (byte)pRequestParameters.getItemByName("Param_BlockSequeCount").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting block sequence counter of request (Param_BlockSequeCount).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            blockSequenceCounterResponse = (byte)pResponse.getResponseParameters().getItemByName("Param_BlockSequeCount").getValue().getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting block sequence counter of response (Param_BlockSequeCount).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (blockSequenceCounterResponse != blockSequenceCounterRequest) {
            this.logger.error("blockSequenceCounter of response does NOT match request: " + blockSequenceCounterRequest + " / " + blockSequenceCounterResponse);
            return AbstractJob.JobStatus.BLOCK_SEQUENCE_COUNTER_MISMATCH;
        }
        try {
            transferRequestParameterRecordLength = pRequestParameters.getItemByName("Param_TransRequeParamRecor").getValue().getBytefield().length;
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting length of transfer request parameter record of request (Param_TransRequeParamRecor).");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.totalNumberOfBytesTransferred += transferRequestParameterRecordLength;
        this.currentBlockSequenceCounter = (byte)(this.currentBlockSequenceCounter + 1);
        this.currentBlockSequenceCounter = (byte)(this.currentBlockSequenceCounter % 255);
        ++this.currentDataChunk;
        this.numberOfTransferDataRepetitions = 0;
        this.logger.debug("totalNumberOfBytesTransferred: " + this.totalNumberOfBytesTransferred);
        this.logger.debug("totalNumberOfBytesToTransfer: " + this.totalNumberOfBytesToTransfer);
        this.setJobProgress(10L + (long)this.totalNumberOfBytesTransferred * 80L / (long)this.totalNumberOfBytesToTransfer);
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseTransferData(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseRequestTransferExit(MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseRequestTransferExit(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 1) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseRequestTransferExit(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handlePositiveResponseControlDTCSetting(MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte[] responseMessage = null;
        String responseMessageString = null;
        this.logger.trace("Entering handlePositiveResponseControlDTCSetting(...).");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length > 2) {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
        }
        this.logger.trace("Leaving handlePositiveResponseControlDTCSetting(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleNegativeResponse(int pDiagComPrimitiveType, String pServiceShortName, MCDRequest pRequest, MCDRequestParameters pRequestParameters, MCDResponse pResponse) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        byte requestServiceIdentifierRequest = 0;
        byte requestServiceIdentifierResponse = 0;
        String negativeResponseCode = null;
        byte nrc = 0;
        byte[] responseMessage = null;
        String responseMessageString = null;
        MCDResponseParameters responseParameters = null;
        long numberOfResponseParameters = 0L;
        this.logger.trace("Entering handleNegativeResponse(...).");
        this.logger.debug("Response is negative.");
        try {
            responseMessage = pResponse.getResponseMessage().getBytefield();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response message.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        if (responseMessage.length == 3) {
            long i;
            block27: {
                try {
                    for (i = 0L; i < pRequestParameters.getCount(); ++i) {
                        if (!pRequestParameters.getItemByIndex(i).getShortName().endsWith("RequeServiId")) continue;
                        requestServiceIdentifierRequest = (byte)pRequestParameters.getItemByIndex(i).getValue().getUint32();
                        break;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting request service identifier from request.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    responseParameters = pResponse.getResponseParameters();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting response parameters from response!");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    numberOfResponseParameters = responseParameters.getCount();
                    this.logger.debug("Number of response parameters: " + numberOfResponseParameters);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error determining number of response parameters.");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (numberOfResponseParameters < 4L) {
                    requestServiceIdentifierResponse = requestServiceIdentifierRequest;
                } else {
                    try {
                        this.logger.debug("Datatype of request SID: " + McdEnumDecoder.decodeMcdDataType(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getDataType()));
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 3) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseParameters().getItemByName("Param_RequeServiIdent").getValue().getBytefield()[0] & 0xFF);
                            break block27;
                        }
                        if (responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 14 || responseParameters.getItemByName("Param_RequeServiIdent").getValue().getDataType() == 1) {
                            requestServiceIdentifierResponse = (byte)(pResponse.getResponseMessage().getBytefield()[1] & 0xFF);
                            break block27;
                        }
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        requestServiceIdentifierResponse = 0;
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                    catch (MCDException mcde) {
                        this.logger.error("Error getting request service identifier (Param_RequeServiIdent) from response.");
                        this.logger.logThrowable(mcde);
                        return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                    }
                }
            }
            try {
                for (i = 0L; i < numberOfResponseParameters; ++i) {
                    if (!responseParameters.getItemByIndex(i).getShortName().equals("Param_NegatRespoCode")) continue;
                    negativeResponseCode = responseParameters.getItemByIndex(i).getValue().getValueAsString();
                    break;
                }
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting negative response code (Param_NegatRespoCode) from response.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            nrc = responseMessage[2];
            this.logger.debug("- Service ID: 0x" + Integer.toHexString(requestServiceIdentifierResponse & 0xFF).toUpperCase());
            this.logger.debug("- NRC       : 0x" + Integer.toHexString(nrc).toUpperCase() + " (" + negativeResponseCode + ")");
            if (requestServiceIdentifierResponse != requestServiceIdentifierRequest) {
                this.logger.error("Request service identifier of response does NOT match request: 0x" + Integer.toHexString(requestServiceIdentifierRequest) + " / " + Integer.toHexString(requestServiceIdentifierResponse));
            }
        } else {
            try {
                responseMessageString = pResponse.getResponseMessage().getValueAsString();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting response message as string.");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            if (responseMessage.length < 3) {
                this.logger.debug("Negative response has invalid length of " + responseMessage.length + " bytes: " + responseMessageString);
            } else if (responseMessage.length > 3) {
                this.logger.warn("Unexpected additional response parameters: " + responseMessageString);
            }
        }
        currentJobStatus = AbstractJob.JobStatus.NEGATIVE_RESPONSE;
        this.logger.trace("Leaving handleNegativeResponse(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus handleErrors(MCDErrors pErrors) {
        long numberOfErrors = 0L;
        MCDError error = null;
        this.logger.trace("Entering handleErrors(...).");
        try {
            numberOfErrors = pErrors.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of errors.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("diagComPrimitive has " + numberOfErrors + " errors.");
        if (numberOfErrors == 0L) {
            this.logger.debug("Collection of errors is empty - NO errors occured.");
        } else {
            for (long i = 0L; i < numberOfErrors; ++i) {
                try {
                    error = pErrors.getItemByIndex(i);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting error with index " + i + ".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                this.logger.logMcdError(error);
            }
        }
        this.logger.trace("Leaving handleErrors(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected String getProtocolParameterString(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) throws MCDException {
        MCDValue mcdValue = null;
        String value = null;
        this.logger.trace("Entering getProtocolParameterString(...).");
        try {
            mcdValue = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCDValue of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            value = mcdValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UNICODE2STRING value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.trace("Leaving getProtocolParameterString(...).");
        return value;
    }

    protected long getProtocolParameterUint32(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) throws MCDException {
        MCDValue mcdValue = null;
        long value = -1L;
        this.logger.trace("Entering getProtocolParameterUint32(...).");
        try {
            mcdValue = this.getProtocolParameterValue(pProtocolParameterSet, pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCDValue of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            value = mcdValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UINT32 value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.trace("Leaving getProtocolParameterUint32(...).");
        return value;
    }

    protected MCDValue getProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName) throws MCDException {
        MCDValue comParamValue = null;
        MCDRequestParameter comParam = null;
        this.logger.trace("Entering getProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error fetching protocol parameter with SHORT-NAME \"" + pComParamName + "\" from interface.");
            throw mcde;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting MCDValue of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.trace("Leaving getProtocolParameterValue(...).");
        return comParamValue;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, String pValue) throws MCDException {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        String currentValue = null;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter with SHORT-NAME \"" + pComParamName + "\" from interface!");
            this.logger.logThrowable(mcde);
            throw mcde;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            this.logger.logThrowable(mcde);
            throw mcde;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            currentValue = comParamValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setValueAsString(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            throw mcde;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        if (this.logger.getLogLevel() >= 5) {
            try {
                pProtocolParameterSet.fetchValueFromInterface(pComParamName);
            }
            catch (MCDException mcde) {
                this.logger.error("Error fetching new protocol parameter value of \"" + pComParamName + "\" from interface!");
                throw mcde;
            }
            try {
                this.logger.debug("New value of \"" + pComParamName + "\" is " + this.protocolParameters.getItemByName(pComParamName).getValue().getValueAsString());
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting new value of \"" + pComParamName + "\".");
                throw mcde;
            }
        }
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected MCDResult setProtocolParameterValue(MCDProtocolParameterSet pProtocolParameterSet, String pComParamName, long pValue) throws MCDException {
        MCDRequestParameter comParam = null;
        MCDValue comParamValue = null;
        MCDResult result = null;
        long currentValue = -1L;
        this.logger.trace("Entering setProtocolParameterValue(...).");
        try {
            pProtocolParameterSet.fetchValueFromInterface(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error fetching protocol parameter values from interface.");
            throw mcde;
        }
        try {
            comParam = pProtocolParameterSet.getRequest().getRequestParameters().getItemByName(pComParamName);
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            comParamValue = comParam.getValue();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting value for protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        try {
            currentValue = comParamValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting current value of protocol parameter \"" + pComParamName + "\".");
            throw mcde;
        }
        this.logger.debug("Setting value of protocol parameter \"" + pComParamName + "\" from " + currentValue + " to " + pValue + ".");
        try {
            comParamValue.setUint32(pValue);
            comParam.setValue(comParamValue);
        }
        catch (MCDException mcde) {
            this.logger.error("Error setting value of protocol parameter \"" + pComParamName + "\" to " + pValue + ".");
            throw mcde;
        }
        this.updateProtocolParameters(pProtocolParameterSet);
        this.logger.trace("Leaving setProtocolParameterValue(...).");
        return result;
    }

    protected AbstractJob.JobStatus listRequestParameters(MCDRequestParameters pRequestParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfRequestParameters = 0L;
        MCDDbRequestParameter dbRequestParameter = null;
        this.logger.trace("Entering listRequestParameters(...).");
        try {
            numberOfRequestParameters = pRequestParameters.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting request parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (long i = 0L; i < numberOfRequestParameters; ++i) {
            try {
                dbRequestParameter = (MCDDbRequestParameter)pRequestParameters.getItemByIndex(i).getDbObject();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting database request parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Parameter with index " + i);
            this.listDbParameter((MCDDbParameter)dbRequestParameter);
        }
        this.logger.trace("Leaving listRequestParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus listResponseParameters(MCDResponseParameters pResponseParameters) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        long numberOfResponseParameters = 0L;
        MCDResponseParameter responseParameter = null;
        this.logger.trace("Entering listResponseParameters(...).");
        try {
            numberOfResponseParameters = pResponseParameters.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting response parameters.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (long i = 0L; i < numberOfResponseParameters; ++i) {
            try {
                responseParameter = pResponseParameters.getItemByIndex(i);
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting database response parameter with index " + i + ".");
                this.logger.logThrowable(mcde);
                return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
            }
            this.logger.debug("Parameter with index " + i);
            this.listResponseParameter(responseParameter);
        }
        this.logger.trace("Leaving listResponseParameters(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus listResponseParameter(MCDResponseParameter pResponseParameter) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String parameterName = null;
        int parameterType = -1;
        this.logger.trace("Entering listResponseParameter(...).");
        try {
            parameterName = pResponseParameter.getShortName();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting SHORT-NAME of database parameter.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            parameterType = pResponseParameter.getType();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting parameter type of database parameter.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("- parameter name: " + parameterName);
        this.logger.debug("- parameter type: " + McdEnumDecoder.decodeMcdDataType(parameterType));
        this.logger.trace("Leaving listResponseParameter(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus listDbParameter(MCDDbParameter pDbParameter) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        String parameterName = null;
        int parameterType = -1;
        long bytePosition = -1L;
        int bitPosition = -1;
        this.logger.trace("Entering listDbParameter(...).");
        try {
            parameterName = pDbParameter.getShortName();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting SHORT-NAME of database parameter.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            parameterType = pDbParameter.getParameterType();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting parameter type of database parameter.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            bytePosition = pDbParameter.getBytePos();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting BYTE-POSITION of database.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            bitPosition = pDbParameter.getBitPos();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting BIT-POSITION of database parameter.");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        this.logger.debug("- parameter name: " + parameterName);
        this.logger.debug("- parameter type: " + McdEnumDecoder.decodeMcdDataType(parameterType));
        this.logger.debug("- BYTE-POSITION : " + bytePosition);
        this.logger.debug("- BIT-POSITION  : " + bitPosition);
        this.logger.trace("Leaving listDbParameter(...).");
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus checkRequiredDiagComms(String[] pRequiredDiagComms) {
        AbstractJob.JobStatus currentJobStatus = this.jobStatus;
        MCDDbDataPrimitives dbDataPrimitives = null;
        long dbDataPrimitiveCount = 0L;
        MCDDbDataPrimitive dbDataPrimitive = null;
        String dbDataPrimitiveShortName = null;
        boolean isDiagCommAvailable = false;
        try {
            dbDataPrimitives = this.dbLocationOfLogicalLink.getDbDataPrimitives();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        try {
            dbDataPrimitiveCount = dbDataPrimitives.getCount();
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining number of available data primitives for database location \"" + this.dbLocationAccessKey + "\".");
            this.logger.logThrowable(mcde);
            return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        for (int i = 0; i < pRequiredDiagComms.length; ++i) {
            this.logMessage = "Checking availability of DIAG-COMM \"" + pRequiredDiagComms[i] + "\"... ";
            isDiagCommAvailable = false;
            for (long j = 0L; j < dbDataPrimitiveCount; ++j) {
                try {
                    dbDataPrimitive = dbDataPrimitives.getItemByIndex(j);
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                try {
                    dbDataPrimitiveShortName = dbDataPrimitive.getShortName();
                }
                catch (MCDException mcde) {
                    this.logger.error("Error getting SHORT-NAME of data primitive with index " + j + " for database location \"" + this.dbLocationAccessKey + "\".");
                    this.logger.logThrowable(mcde);
                    return AbstractJob.JobStatus.EXCEPTION_CAUGHT;
                }
                if (!dbDataPrimitiveShortName.equals(pRequiredDiagComms[i])) continue;
                isDiagCommAvailable = true;
                this.logMessage = this.logMessage + "OK.";
                this.logger.debug(this.logMessage);
            }
            if (isDiagCommAvailable) continue;
            this.logMessage = this.logMessage + "*** MISSING ***.";
            this.logger.fatal(this.logMessage);
            this.jobStatus = AbstractJob.JobStatus.ERROR;
        }
        return currentJobStatus;
    }

    private MCDValue getParameterValue(MCDParameter pParameter) throws MCDException, NullPointerException {
        String shortName = null;
        MCDValue value = null;
        this.logger.trace("Entering getParameterValue(...).");
        if (this.logger.getLogLevel() >= 5) {
            try {
                shortName = pParameter.getShortName();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting SHORT-NAME of parameter.");
                this.logger.logThrowable(mcde);
            }
            this.logger.debug("Getting value of parameter: " + shortName);
        }
        try {
            value = pParameter.getValue();
        }
        catch (MCDException mcde) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.error("Error getting value of parameter \"" + shortName + "\".");
            } else {
                this.logger.error("Error getting value of parameter.");
            }
            throw mcde;
        }
        if (value == null) {
            this.logger.error("MCDParameter.getValue() returned null!");
            throw new NullPointerException("MCDParameter.getValue() returned null!");
        }
        this.logger.trace("Leaving getParameterValue(...).");
        return value;
    }

    protected long getParameterValueUint32(MCDParameter pParameter) throws MCDException, NullPointerException {
        MCDValue mcdValue = null;
        long value = 0L;
        this.logger.trace("Entering getParameterValueUint32(...).");
        mcdValue = this.getParameterValue(pParameter);
        try {
            value = mcdValue.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting A_UINT32 value from MCDValue.");
            throw mcde;
        }
        this.logger.trace("Leaving getParameterValueUint32(...).");
        return value;
    }

    protected int getParameterValueUint32AsInteger(MCDParameter pParameter) throws IllegalArgumentException, MCDException, NullPointerException {
        long longValue = 0L;
        int value = 0;
        this.logger.trace("Entering getParameterValueUint32AsInteger(...).");
        longValue = this.getParameterValueUint32(pParameter);
        if (longValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The value " + longValue + " exceeds the maximum 'int' value of " + Integer.MAX_VALUE + "!");
        }
        value = (int)longValue;
        this.logger.trace("Leaving getParameterValueUint32AsInteger(...).");
        return value;
    }

    protected short getParameterValueUint32AsShort(MCDParameter pParameter) throws IllegalArgumentException, MCDException, NullPointerException {
        long longValue = 0L;
        short value = 0;
        this.logger.trace("Entering getParameterValueUint32AsShort(...).");
        longValue = this.getParameterValueUint32(pParameter);
        if (longValue > 32767L) {
            throw new IllegalArgumentException("The value " + longValue + " exceeds the maximum 'short' value of " + Short.MAX_VALUE + "!");
        }
        value = (short)longValue;
        this.logger.trace("Leaving getParameterValueUint32AsShort(...).");
        return value;
    }

    protected byte getParameterValueUint32AsByte(MCDParameter pParameter) throws IllegalArgumentException, MCDException, NullPointerException {
        long longValue = 0L;
        byte value = 0;
        this.logger.trace("Entering getParameterValueUint32AsByte(...).");
        longValue = this.getParameterValueUint32(pParameter);
        if (longValue > 127L) {
            throw new IllegalArgumentException("The value " + longValue + " exceeds the maximum 'byte' value of " + 127 + "!");
        }
        value = (byte)longValue;
        this.logger.trace("Leaving getParameterValueUint32AsByte(...).");
        return value;
    }

    protected String getParameterValueAsString(MCDParameter pParameter) throws MCDException, NullPointerException {
        MCDValue mcdValue = null;
        String value = null;
        this.logger.trace("Entering getParameterValueAsString(...).");
        mcdValue = this.getParameterValue(pParameter);
        try {
            value = mcdValue.getValueAsString();
        }
        catch (MCDException mcde) {
            this.logger.error("Error getting A_UNICODE2STRING value from MCDValue.");
            throw mcde;
        }
        if (value == null) {
            this.logger.error("MCDValue.getValueAsString() returned null!");
            throw new NullPointerException("MCDValue.getValueAsString() returned null!");
        }
        this.logger.trace("Leaving getParameterValueAsString(...).");
        return value;
    }

    private MCDResponseParameter getLastResponseParameterOfFieldByName(MCDResponseParameter pResponseParameter, String pShortName) throws MCDException {
        long numberFieldElements = 0L;
        MCDResponseParameters fieldElements = null;
        MCDResponseParameter responseParameter = null;
        MCDResponseParameter currentResponseParameter = null;
        String responseParameterName = null;
        this.logger.trace("Entering getLastResponseParameterOfFieldByName()...");
        try {
            fieldElements = pResponseParameter.getParameters();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting elements of field.");
            throw mcde;
        }
        try {
            numberFieldElements = fieldElements.getCount();
        }
        catch (MCDException mcde) {
            this.logger.fatal("Error getting number of response parameters in field.");
            throw mcde;
        }
        int i = 0;
        while ((long)i < numberFieldElements) {
            block12: {
                try {
                    currentResponseParameter = fieldElements.getItemByIndex((long)i);
                    if (currentResponseParameter.getType() == 17) {
                        responseParameter = fieldElements.getItemByIndex(numberFieldElements - 1L).getParameters().getItemByName(pShortName);
                        break block12;
                    }
                    try {
                        responseParameterName = currentResponseParameter.getShortName();
                        if (responseParameterName.startsWith("#RtGen_")) {
                            responseParameterName = responseParameterName.replaceFirst("#RtGen_", "");
                            responseParameterName = responseParameterName.substring(0, responseParameterName.lastIndexOf("_"));
                        }
                    }
                    catch (MCDException mcde) {
                        this.logger.fatal("Error getting SHORT-NAME of response parameter with index " + i + ".");
                        throw mcde;
                    }
                    if (responseParameterName != null && responseParameterName.equals(pShortName)) {
                        responseParameter = currentResponseParameter;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.fatal("Error getting response parameter with index " + i + " from field.");
                    throw mcde;
                }
            }
            ++i;
        }
        this.logger.trace("Leaving getLastResponseParameterOfFieldByName()...");
        return responseParameter;
    }

    private final long convertStMinToEIDBSS(long pStMin) {
        long result = 0L;
        this.logger.trace("Entering convertStMinToEIDBSS()...");
        this.logger.debug("STmin value to convert: " + pStMin + " \u00b5s");
        if (pStMin == 0L) {
            result = 0L;
        } else if (pStMin > 127000L) {
            result = 127000L;
        } else if (pStMin % 1000L == 0L) {
            result = pStMin / 1000L;
        } else if (pStMin > 1000L) {
            result = 1L + pStMin / 1000L;
        } else if (pStMin % 100L == 0L) {
            result = pStMin / 100L;
            result += 240L;
        } else {
            result = (result /= 100L) < 9L ? (result += 241L) : 1L;
        }
        this.logger.debug("EIDBSS internal value : 0x" + Long.toHexString(result).toUpperCase());
        this.logger.trace("Leaving convertStMinToEIDBSS()...");
        return result;
    }

    private final long convertStMinFromEIDBSS(long pStMin) {
        long result = 0L;
        this.logger.trace("Entering convertStMinFromEIDBSS()...");
        this.logger.debug("EIDBSS internal value: 0x" + Long.toHexString(pStMin).toUpperCase());
        if (pStMin == 0L) {
            result = 0L;
        } else if (pStMin >= 241L && pStMin <= 249L) {
            result = pStMin - 240L;
            result *= 100L;
        } else {
            result = pStMin >= 1L && pStMin <= 127L ? pStMin * 1000L : 127L;
        }
        this.logger.debug("Converted STmin value: " + result + " \u00b5s");
        this.logger.trace("Leaving convertStMinFromEIDBSS()...");
        return result;
    }

    boolean determineSpecificationVersionOfRoutineControlCheckMemory() {
        MCDDbDiagServices dbDiagServices = null;
        MCDDbDiagService dbDiagService = null;
        MCDDbRequest dbRequest = null;
        MCDDbRequestParameters dbRequestParameters = null;
        String dbRequestParameterShortName = null;
        this.logger.trace("Entering determineSpecificationVersionOfRoutineControlCheckMemory()");
        try {
            dbDiagServices = this.dbLocationOfLogicalLink.getDbDiagServices();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting DbDiagServices for " + this.dbLocationAccessKey + "!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            dbDiagService = dbDiagServices.getItemByName("DiagnServi_RoutiContrCheckMemor");
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting DbDiagService with SHORT-NAME \"DiagnServi_RoutiContrCheckMemor\"!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            dbRequest = dbDiagService.getDbRequest();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting request of DbDiagService \"DiagnServi_RoutiContrCheckMemor\"!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            dbRequestParameters = dbRequest.getDbRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting request parameters of DbDiagService \"DiagnServi_RoutiContrCheckMemor\"!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            dbRequestParameters.getItemByName("Param_Value");
            this.vw80126VersionOfRoutineControlCheckMemory = "2.0.0";
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting request parameter with SHORT-NAME \"Param_Value\" of DbDiagService \"DiagnServi_RoutiContrCheckMemor\"!");
            try {
                dbRequestParameterShortName = "Param_AddreFormaIdent";
                dbRequestParameters.getItemByName(dbRequestParameterShortName);
                dbRequestParameterShortName = "Param_LengtFormaIdent";
                dbRequestParameters.getItemByName(dbRequestParameterShortName);
                dbRequestParameterShortName = "Param_MemorAddre";
                dbRequestParameters.getItemByName(dbRequestParameterShortName);
                dbRequestParameterShortName = "Param_MemorSize";
                dbRequestParameters.getItemByName(dbRequestParameterShortName);
                dbRequestParameterShortName = "Param_LengtInfor";
                dbRequestParameters.getItemByName(dbRequestParameterShortName);
                dbRequestParameterShortName = "Param_Check";
                dbRequestParameters.getItemByName(dbRequestParameterShortName);
                this.vw80126VersionOfRoutineControlCheckMemory = "1.x.x";
            }
            catch (MCDException mcde2) {
                this.logger.debug("Error getting request parameter with SHORT-NAME \"" + dbRequestParameterShortName + "\" of DbDiagService \"" + "DiagnServi_RoutiContrCheckMemor" + "\"!");
                this.logger.error("Unable to determine specification version of VW80126 supported by DbDiagService \"DiagnServi_RoutiContrCheckMemor\"!");
                return false;
            }
        }
        this.logger.debug("VW80126 version of ECU-MEM: " + this.vw80126Version);
        this.logger.debug("VW80126 version of DiagnServi_RoutiContrCheckMemor: " + this.vw80126VersionOfRoutineControlCheckMemory);
        if (!this.vw80126Version.equals(this.vw80126VersionOfRoutineControlCheckMemory)) {
            this.logger.warn("Specification version of VW80126 supported by DbDiagService \"DiagnServi_RoutiContrCheckMemor\" does NOT match the specification version of VW80126 used by ECU-MEM!");
        }
        this.logger.trace("Leaving determineSpecificationVersionOfRoutineControlCheckMemory()");
        return true;
    }

    private boolean isSubSystemSupportingCommunicationControl() {
        MCDDbDiagServices dbDiagServices = null;
        MCDDbDiagService communicationControl = null;
        MCDDbRequest communicationControlRequest = null;
        MCDDbRequestParameters dbRequestParameters = null;
        MCDDbRequestParameter controlType = null;
        MCDTextTableElements controlTypes = null;
        long numberOfControlTypes = -1L;
        MCDTextTableElement currentControlType = null;
        String controlTypeVt = null;
        this.logger.trace("Entering isSubSystemSupportingCommunicationControl()");
        try {
            dbDiagServices = this.dbLocationOfLogicalLink.getDbDiagServices();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting DbDiagServices for " + this.dbLocationAccessKey + " ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            communicationControl = dbDiagServices.getItemByName("DiagnServi_CommuContr");
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting DbDiagService with SHORT-NAME \"DiagnServi_CommuContr\" from " + this.dbLocationAccessKey + " ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (communicationControl == null) {
            this.logger.warn("DbDiagService \"DiagnServi_CommuContr\" seems to be eliminated on " + this.dbLocationAccessKey + " ...assuming false!");
            return false;
        }
        try {
            communicationControlRequest = communicationControl.getDbRequest();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting request of DbDiagService \"DiagnServi_CommuContr\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            dbRequestParameters = communicationControlRequest.getDbRequestParameters();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting request parameters of DbDiagService \"DiagnServi_CommuContr\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            controlType = dbRequestParameters.getItemByName("Param_ContrType");
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting request parameter with SHORT-NAME \"Param_ContrType\" of DbDiagService \"DiagnServi_CommuContr\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        if (controlType == null) {
            this.logger.warn("DbDiagService \"DiagnServi_CommuContr\" does NOT contain a request parameter with SHORT-NAME \"Param_ContrType\" ...assuming false!");
            return false;
        }
        try {
            controlTypes = controlType.getTextTableElements();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting text table elements of request parameter \"Param_ContrType\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        try {
            numberOfControlTypes = controlTypes.getCount();
        }
        catch (MCDException mcde) {
            this.logger.warn("Error getting number of text table elements of request parameter \"Param_ContrType\" ...assuming false!");
            this.logger.logThrowable(mcde);
            return false;
        }
        int i = 0;
        while ((long)i < numberOfControlTypes) {
            try {
                currentControlType = controlTypes.getItemByIndex((long)i);
            }
            catch (MCDException mcde) {
                this.logger.warn("Error getting text table element with index " + i + " of request parameter \"" + "Param_ContrType" + "\" ...assuming false!");
                this.logger.logThrowable(mcde);
                return false;
            }
            try {
                controlTypeVt = currentControlType.getLongName();
            }
            catch (MCDException mcde) {
                this.logger.warn("Error getting VT of text table element with index " + i + " of request parameter \"" + "Param_ContrType" + "\" ...assuming false!");
                this.logger.logThrowable(mcde);
                return false;
            }
            if (controlTypeVt.equals("Enable Rx And Tx With Enhanced Address Information") || controlTypeVt.equals("Enable Subnet Routing")) {
                this.logger.debug("Found controlType: " + controlTypeVt);
                return true;
            }
            ++i;
        }
        this.logger.trace("Leaving isSubSystemSupportingCommunicationControl()");
        return false;
    }

    protected void evaluateJobProperties() {
        String propertyNamePrefix = null;
        String propertyName = null;
        String propertyValueAsString = null;
        boolean usePhysicalAddressingOnly = false;
        boolean usePhysicalAddressingOnlyDefault = false;
        boolean keepNormalCommunicationDisabled = false;
        boolean keepNormalCommunicationDisabledDefault = false;
        propertyNamePrefix = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1) + ".";
        propertyName = propertyNamePrefix + "usePhysicalAddressingOnly";
        propertyValueAsString = this.jobProperties.getProperty(propertyName);
        if (propertyValueAsString == null) {
            usePhysicalAddressingOnly = usePhysicalAddressingOnlyDefault;
        } else if ((propertyValueAsString = propertyValueAsString.trim()).length() == 0) {
            this.logger.warn("Property \"" + propertyName + "\" is empty! Using default value...");
            usePhysicalAddressingOnly = usePhysicalAddressingOnlyDefault;
        } else {
            usePhysicalAddressingOnly = Boolean.valueOf(propertyValueAsString);
        }
        this.isFunctionalAddressingDisabled = usePhysicalAddressingOnly;
        propertyName = propertyNamePrefix + "keepNormalCommunicationDisabled";
        propertyValueAsString = this.jobProperties.getProperty(propertyName);
        if (propertyValueAsString == null) {
            keepNormalCommunicationDisabled = keepNormalCommunicationDisabledDefault;
        } else if ((propertyValueAsString = propertyValueAsString.trim()).length() == 0) {
            this.logger.warn("Property \"" + propertyName + "\" is empty! Using default value...");
            keepNormalCommunicationDisabled = keepNormalCommunicationDisabledDefault;
        } else {
            keepNormalCommunicationDisabled = Boolean.valueOf(propertyValueAsString);
        }
        this.isNormalCommunicationReEnabled = !keepNormalCommunicationDisabled;
    }

    private void dumpFds() {
        FdsProject fdsProject = null;
        FdsSignatures fdsSignatures = null;
        FdsSignature fdsSignature = null;
        this.logger.debug("Dumping FDS...");
        Iterator fdsProjectsIteraror = this.fds.getFdsProjects().values().iterator();
        while (fdsProjectsIteraror.hasNext()) {
            fdsProject = (FdsProject)fdsProjectsIteraror.next();
            this.logger.debug("- FDS-PROJECT: " + fdsProject.getId() + " / " + fdsProject.getEncryptionAlgorithm() + " / " + fdsProject.getHashAlgorithm());
            Iterator fdsSignaturesIterator = fdsProject.getFdsSignatures().entrySet().iterator();
            while (fdsSignaturesIterator.hasNext()) {
                Map.Entry currentEntry = fdsSignaturesIterator.next();
                fdsSignatures = (FdsSignatures)currentEntry.getValue();
                this.logger.debug("   - FDS-SIGNATURES: " + fdsSignatures.getSessionShortName() + " / " + fdsSignatures.getSessionDescShortName() + " / " + fdsSignatures.getType());
                Iterator fdsSignatureIterator = fdsSignatures.getFdsSignatures().entrySet().iterator();
                while (fdsSignatureIterator.hasNext()) {
                    Map.Entry currentEntry2 = fdsSignatureIterator.next();
                    fdsSignature = (FdsSignature)currentEntry2.getValue();
                    this.logger.debug("     - FDS-SIGNATURE: " + fdsSignature.getDataBlockShortName() + " / " + Conversions.byteArray2String(fdsSignature.getFwSignature()));
                }
            }
        }
    }

    public static final class JobStep
    implements Comparable {
        public static final JobStep PREPARE_SUB_JOBS = new JobStep("PREPARE_SUB_JOBS");
        public static final JobStep PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_PHYSICALLY = new JobStep("PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_PHYSICALLY");
        public static final JobStep PREPROGRAMMING_CHECK_PROGRAMMING_PRECONDTITIONS = new JobStep("PREPROGRAMMING_CHECK_PROGRAMMING_PRECONDTITIONS");
        public static final JobStep PREPROGRAMMING_CONTROL_DTC_SETTING_OFF = new JobStep("PREPROGRAMMING_CONTROL_DTC_SETTING_OFF");
        public static final JobStep PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX = new JobStep("PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX");
        public static final JobStep SWITCH_TO_PROGRAMMING_SESSION = new JobStep("SWITCH_TO_PROGRAMMING_SESSION");
        public static final JobStep CHANGE_BAUD_RATE = new JobStep("CHANGE_BAUD_RATE");
        public static final JobStep SECURITY_ACCESS = new JobStep("SECURITY_ACCESS");
        public static final JobStep WRITE_FINGERPRINT = new JobStep("WRITE_FINGERPRINT");
        public static final JobStep ANALYZE_CURRENT_DATA_BLOCK_AND_SEGMENT = new JobStep("ANALYZE_CURRENT_DATA_BLOCK_AND_SEGMENT");
        public static final JobStep ERASE_MEMORY = new JobStep("ERASE_MEMORY");
        public static final JobStep REQUEST_DOWNLOAD = new JobStep("REQUEST_DOWNLOAD");
        public static final JobStep TRANSFER_DATA_SETUP = new JobStep("TRANSFER_DATA_SETUP");
        public static final JobStep TRANSFER_DATA = new JobStep("TRANSFER_DATA");
        public static final JobStep REQUEST_TRANSFER_EXIT = new JobStep("REQUEST_TRANSFER_EXIT");
        public static final JobStep CHECK_FOR_MORE_SEGMENTS = new JobStep("CHECK_FOR_MORE_SEGMENTS");
        public static final JobStep CHECK_MEMORY = new JobStep("CHECK_MEMORY");
        public static final JobStep CHECK_PROGRAMMING_DEPENDENCIES = new JobStep("CHECK_PROGRAMMING_DEPENDENCIES");
        public static final JobStep RESTORE_BAUD_RATE = new JobStep("RESTORE_BAUD_RATE");
        public static final JobStep ECU_RESET = new JobStep("ECU_RESET");
        public static final JobStep POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY = new JobStep("POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY");
        public static final JobStep POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF = new JobStep("POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF");
        public static final JobStep POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX = new JobStep("POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX");
        public static final JobStep POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX = new JobStep("POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX");
        public static final JobStep POSTPROGRAMMING_CONTROL_DTC_SETTING_ON = new JobStep("POSTPROGRAMMING_CONTROL_DTC_SETTING_ON");
        public static final JobStep POSTPROGRAMMING_SWITCH_TO_DEFAULT_SESSION_PHYSICALLY = new JobStep("POSTPROGRAMMING_SWITCH_TO_DEFAULT_SESSION_PHYSICALLY");
        public static final JobStep POSTPROGRAMMING_START_COMMUNICATION = new JobStep("POSTPROGRAMMING_START_COMMUNICATION");
        public static final JobStep RESTORE_PROTOCOL_PARAMETERS = new JobStep("RESTORE_PROTOCOL_PARAMETERS");
        public static final JobStep DONE = new JobStep("DONE");
        private static int nextOrdinal = 0;
        static final JobStep[] values = new JobStep[]{PREPARE_SUB_JOBS, PREPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_PHYSICALLY, PREPROGRAMMING_CHECK_PROGRAMMING_PRECONDTITIONS, PREPROGRAMMING_CONTROL_DTC_SETTING_OFF, PREPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX, SWITCH_TO_PROGRAMMING_SESSION, CHANGE_BAUD_RATE, SECURITY_ACCESS, WRITE_FINGERPRINT, ANALYZE_CURRENT_DATA_BLOCK_AND_SEGMENT, ERASE_MEMORY, REQUEST_DOWNLOAD, TRANSFER_DATA_SETUP, TRANSFER_DATA, REQUEST_TRANSFER_EXIT, CHECK_FOR_MORE_SEGMENTS, CHECK_MEMORY, CHECK_PROGRAMMING_DEPENDENCIES, RESTORE_BAUD_RATE, ECU_RESET, POSTPROGRAMMING_SWITCH_TO_EXTENDED_DIAGNOSTIC_SESSION_FUNCTIONALLY, POSTPROGRAMMING_CONTROL_DTC_SETTING_OFF, POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_DISABLE_TX, POSTPROGRAMMING_COMMUNICATION_CONTROL_ENABLE_RX_AND_TX, POSTPROGRAMMING_CONTROL_DTC_SETTING_ON, POSTPROGRAMMING_SWITCH_TO_DEFAULT_SESSION_PHYSICALLY, POSTPROGRAMMING_START_COMMUNICATION, RESTORE_PROTOCOL_PARAMETERS, DONE};
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
        private final int ordinal = nextOrdinal++;
        private final String name;

        private JobStep(String pName) {
            this.name = pName;
        }

        public static final JobStep valueOf(String pName) throws IllegalArgumentException {
            JobStep jobStep = null;
            Iterator jobStepIterator = VALUES.iterator();
            while (jobStepIterator.hasNext()) {
                jobStep = (JobStep)jobStepIterator.next();
                if (!pName.equals(jobStep.toString())) continue;
                return jobStep;
            }
            throw new IllegalArgumentException("Cannot parse '" + pName + "' into an element of JobStep!");
        }

        public final int compareTo(Object pObject) {
            return this.ordinal - ((JobStep)pObject).ordinal;
        }

        public final boolean equals(Object pObject) {
            return super.equals(pObject);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final int intValue() {
            return this.ordinal;
        }

        public final String toString() {
            return this.name;
        }
    }
}

