/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.util.dserver.impl;

import asam.d.MCDDbIdentDescription;
import asam.d.MCDDbLocation;
import asam.d.MCDDbParameter;
import asam.d.MCDDbResponseParameter;
import asam.d.MCDDbSpecialDataGroup;
import asam.d.MCDDbSpecialDataGroupCaption;
import asam.d.MCDException;
import asam.d.MCDInterval;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.util.dserver.impl.VendorSpecificMCD20002Impl;
import com.audi.mcd.joblibrary.util.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class VendorSpecificSiemensSidisImpl
extends VendorSpecificMCD20002Impl {
    public static final int numberOfMetaDataBytesInCifRequestPdus = 7;
    public static final int numberOfMetaDataBytesInCifResponsePdus = 8;

    public VendorSpecificSiemensSidisImpl(Logger pLogger) {
        super(pLogger);
    }

    public int determineResponseStateFromPdus(byte[] pRequestPdu, byte[] pResponsePdu) {
        byte[] requestPdu = null;
        byte[] responsePdu = null;
        this.logger.trace("Entering determineResponseStateFromPdus(...).");
        requestPdu = new byte[pRequestPdu.length - 7];
        System.arraycopy(pRequestPdu, 7, requestPdu, 0, requestPdu.length);
        responsePdu = new byte[pResponsePdu.length - 8];
        System.arraycopy(pResponsePdu, 8, responsePdu, 0, responsePdu.length);
        this.logger.trace("Leaving determineResponseStateFromPdus(...).");
        return super.determineResponseStateFromPdus(requestPdu, responsePdu);
    }

    public MCDDbResponseParameter getDbResponseParameterOfDbIdentDescription(MCDDbIdentDescription pDbIdentDescription, MCDDbLocation pDbLocation) {
        MCDDbResponseParameter dbResponseParameter = null;
        this.logger.trace("Entering getDbResponseParameterOfDbIdentDescription(...).");
        this.logger.trace("Leaving getDbResponseParameterOfDbIdentDescription(...).");
        return dbResponseParameter;
    }

    public String getLongNameIDOfDbUnitOfDbParameter(MCDDbParameter pDbParameter) {
        return "";
    }

    public MCDValue getLowerLimitFromInterval(MCDInterval pInterval) throws MCDException {
        return pInterval.getLowerLimit();
    }

    public int getLowerLimitIntervalTypeFromInterval(MCDInterval pInterval) throws MCDException {
        return pInterval.getLowerLimitIntervalType();
    }

    public MCDDbSpecialDataGroupCaption getSpecialDataGroupCaption(MCDDbSpecialDataGroup pDbSpecialDataGroup) {
        Class<?> mcdDbSpecialDataGroupClass = null;
        Method[] mcdDbSpecialDataGroupClassMethods = null;
        Method currentMethod = null;
        String currentMethodName = null;
        Method hasCaptionMethod = null;
        Method getCaptionMethod = null;
        boolean sdgHasCaption = false;
        MCDDbSpecialDataGroupCaption dbSpecialDataGroupCaption = null;
        this.logger.trace("Entering getSpecialDataGroupCaption(...).");
        mcdDbSpecialDataGroupClass = pDbSpecialDataGroup.getClass();
        mcdDbSpecialDataGroupClassMethods = mcdDbSpecialDataGroupClass.getMethods();
        for (int i = 0; i < mcdDbSpecialDataGroupClassMethods.length; ++i) {
            currentMethod = mcdDbSpecialDataGroupClassMethods[i];
            currentMethodName = currentMethod.getName();
            if (currentMethodName.equals("hasCaption")) {
                hasCaptionMethod = currentMethod;
                hasCaptionMethod.setAccessible(true);
                continue;
            }
            if (!currentMethodName.equals("getCaption")) continue;
            getCaptionMethod = currentMethod;
            getCaptionMethod.setAccessible(true);
        }
        if (hasCaptionMethod == null) {
            this.logger.error("Error determining MCDDbSpecialDataGroup.hasCaption() method!");
            return null;
        }
        if (getCaptionMethod == null) {
            this.logger.error("Error determining MCDDbSpecialDataGroup.getCaption() method!");
            return null;
        }
        try {
            sdgHasCaption = (Boolean)hasCaptionMethod.invoke((Object)pDbSpecialDataGroup, null);
            if (!sdgHasCaption) {
                this.logger.debug("Skipping unexpected SDG without SDG-CAPTION.");
                return null;
            }
        }
        catch (InvocationTargetException ite) {
            this.logger.error("Error testing for SDG-CAPTION of SDG.");
            this.logger.logThrowable(ite);
            return null;
        }
        catch (IllegalArgumentException iare) {
            this.logger.error("Error testing for SDG-CAPTION of SDG.");
            this.logger.logThrowable(iare);
            return null;
        }
        catch (IllegalAccessException iace) {
            this.logger.error("Error testing for SDG-CAPTION of SDG.");
            this.logger.logThrowable(iace);
            return null;
        }
        catch (Exception mcde) {
            this.logger.debug("Error testing for SDG-CAPTION of SDG... skipping current SDG.");
            this.logger.logThrowable(mcde);
            return null;
        }
        try {
            dbSpecialDataGroupCaption = (MCDDbSpecialDataGroupCaption)getCaptionMethod.invoke((Object)pDbSpecialDataGroup, null);
        }
        catch (InvocationTargetException ite) {
            this.logger.error("Error getting SDG-CAPTION of SDG.");
            this.logger.logThrowable(ite);
            return null;
        }
        catch (IllegalArgumentException iare) {
            this.logger.error("Error getting SDG-CAPTION of SDG.");
            this.logger.logThrowable(iare);
            return null;
        }
        catch (IllegalAccessException iace) {
            this.logger.error("Error getting SDG-CAPTION of SDG.");
            this.logger.logThrowable(iace);
            return null;
        }
        catch (Exception mcde) {
            this.logger.debug("Error getting SDG-CAPTION of SDG... skipping current SDG.");
            this.logger.logThrowable(mcde);
            return null;
        }
        if (dbSpecialDataGroupCaption == null) {
            this.logger.debug("Error getting SDG-CAPTION of SDG with index... skipping current SDG.");
            return null;
        }
        this.logger.trace("Leaving getSpecialDataGroupCaption(...).");
        return dbSpecialDataGroupCaption;
    }

    public MCDRequestParameter getTableStructParameterByTableKeyValue(MCDRequestParameters pRequestParameters, String pShortNameOfTableStructParameter, String pStringValueOfTableKey) throws MCDException {
        MCDRequestParameter requestParameterTableStruct = null;
        MCDRequestParameters requestParametersTableStruct = null;
        long numberOfTableStructParameters = 0L;
        MCDRequestParameter nestedRequestParameterTableStruct = null;
        String shortNameOfNestedRequestParameterTableStruct = null;
        this.logger.trace("Entering getTableStructParameterByTableKeyValue(...).");
        requestParameterTableStruct = pRequestParameters.getItemByName(pShortNameOfTableStructParameter);
        requestParametersTableStruct = requestParameterTableStruct.getParameters();
        numberOfTableStructParameters = requestParametersTableStruct.getCount();
        if (numberOfTableStructParameters == 1L && (shortNameOfNestedRequestParameterTableStruct = (nestedRequestParameterTableStruct = requestParametersTableStruct.getItemByIndex(0L)).getShortName()).equals(pShortNameOfTableStructParameter)) {
            this.logger.debug("Found nested parameter with matching SHORT-NAME... assuming IS-VISIBLE=true... returning nested parameter.");
            requestParameterTableStruct = nestedRequestParameterTableStruct;
        }
        this.logger.trace("Leaving getTableStructParameterByTableKeyValue(...).");
        return requestParameterTableStruct;
    }

    public MCDTextTableElements getTextTableElementsOfDbResponseParameter(MCDDbResponseParameter pDbResponseParameter) {
        MCDTextTableElements textTableElements = null;
        this.logger.trace("Entering getTextTableElementsOfDbResponseParameter(...).");
        this.logger.trace("MCDDbResponseParameter.getTextTableElements() is NOT implemented in SIDIS!");
        this.logger.trace("Leaving getTextTableElementsOfDbResponseParameter(...).");
        return textTableElements;
    }

    public MCDValue getUpperLimitFromInterval(MCDInterval pInterval) throws MCDException {
        return pInterval.getUpperLimit();
    }

    public int getUpperLimitIntervalTypeFromInterval(MCDInterval pInterval) throws MCDException {
        return pInterval.getUpperLimitIntervalType();
    }
}

