/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary3.util.parsers.xmlmsg.impl;

import asam.d.MCDDbFlashDataBlock;
import asam.d.MCDDbFlashDataBlocks;
import asam.d.MCDDbFlashSegment;
import asam.d.MCDDbFlashSegments;
import asam.d.MCDDbFlashSession;
import asam.d.MCDDbFlashSessions;
import asam.d.MCDDbLocation;
import asam.d.MCDException;
import com.audi.mcd.joblibrary3.util.logging.Logger;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.ParameterDataBootloader;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.impl.ParameterDataImpl;

public class ParameterDataBootloaderImpl
extends ParameterDataImpl
implements ParameterDataBootloader {
    private MCDDbLocation dbLocation = null;
    private String fileName = null;
    private int logicalBlockAddress = 0;
    private int logicalBlockSize = 0;
    private String sessionName = null;
    private MCDDbFlashSession dbFlashSession = null;

    public ParameterDataBootloaderImpl(Logger pLogger, MCDDbLocation pDbLocation, String pFileName) {
        super(pLogger);
        this.dbLocation = pDbLocation;
        this.fileName = pFileName;
    }

    public int getDataSize() {
        return this.logicalBlockSize;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getLogicalBlockAddress() {
        return this.logicalBlockAddress;
    }

    public final String getSessionName() {
        return this.sessionName;
    }

    public final void setSessionName(String pSessionName) throws MCDException {
        String sessionDescShortName = null;
        MCDDbFlashSessions dbFlashSessions = null;
        long numberOfFlashSessions = 0L;
        MCDDbFlashSession currentDbFlashSession = null;
        String currentDbFlashSessionShortName = null;
        boolean dbFlashSessionFound = false;
        sessionDescShortName = pSessionName.replaceAll("SES_", "SESD_");
        this.logger.debug("Searching for SESSION with SHORT-NAME \"" + sessionDescShortName + "\" (alternate SHORT-NAME \"" + pSessionName + "\")...");
        dbFlashSessions = this.dbLocation.getDbFlashSessions();
        numberOfFlashSessions = dbFlashSessions.getCount();
        this.logger.debug("Found " + numberOfFlashSessions + " flash sessions at location " + this.dbLocation.getAccessKey().getString() + ".");
        if (numberOfFlashSessions == 0L) {
            this.logger.error("NO MCDDbFlashSessions found at active location! Make sure the LAYER-REFs in the ECU-MEM container exactly match \"" + this.dbLocation.getAccessKey().getEcuBaseVariant() + "\"!");
        } else {
            for (long i = 0L; i < numberOfFlashSessions; ++i) {
                currentDbFlashSession = dbFlashSessions.getItemByIndex(i);
                currentDbFlashSessionShortName = currentDbFlashSession.getShortName();
                this.logger.debug("Found SESSION with SHORT-NAME \"" + currentDbFlashSessionShortName + "\" at index " + i + ".");
                if (currentDbFlashSessionShortName.equals(pSessionName)) {
                    this.dbFlashSession = currentDbFlashSession;
                    this.sessionName = pSessionName;
                    dbFlashSessionFound = true;
                    break;
                }
                if (!currentDbFlashSessionShortName.equals(sessionDescShortName)) continue;
                this.dbFlashSession = currentDbFlashSession;
                this.sessionName = sessionDescShortName;
                dbFlashSessionFound = true;
                break;
            }
        }
        if (!dbFlashSessionFound) {
            throw new RuntimeException("The MCDDbFlashSession with the SHORT-NAME \"" + pSessionName + "\" is not available!");
        }
        try {
            this.logicalBlockSize = this.determineSizeOfFlashSession();
            this.logger.debug("Data size of SESSION with SHORT-NAME \"" + this.sessionName + "\" is " + this.logicalBlockSize + " bytes.");
        }
        catch (MCDException mcde) {
            this.logger.error("Error determining size of DATABLOCKs for SESSION \"" + this.sessionName + "\"!");
            this.logger.logThrowable(mcde);
            throw new RuntimeException("Error determining size of DATABLOCKs for SESSION \"" + this.sessionName + "\"!");
        }
    }

    public final MCDDbFlashSession getDbFlashSession() {
        return this.dbFlashSession;
    }

    private final int determineSizeOfFlashSession() throws MCDException {
        int sizeOfFlashSession = 0;
        MCDDbFlashDataBlocks dbFlashDataBlocks = null;
        long numberOfDbFlashDataBlocks = 0L;
        MCDDbFlashDataBlock currentDbFlashDataBlock = null;
        MCDDbFlashSegments dbFlashSegments = null;
        long numberOfDbFlashSegments = 0L;
        MCDDbFlashSegment currentDbFlashSegment = null;
        byte[] currentBinaryData = null;
        int lengthOfCurrentBinaryData = 0;
        dbFlashDataBlocks = this.dbFlashSession.getDbDataBlocks();
        numberOfDbFlashDataBlocks = dbFlashDataBlocks.getCount();
        for (long i = 0L; i < numberOfDbFlashDataBlocks; ++i) {
            currentDbFlashDataBlock = dbFlashDataBlocks.getItemByIndex(i);
            dbFlashSegments = currentDbFlashDataBlock.getDbFlashSegments();
            numberOfDbFlashSegments = dbFlashSegments.getCount();
            for (long j = 0L; j < numberOfDbFlashSegments; ++j) {
                currentDbFlashSegment = dbFlashSegments.getItemByIndex(j);
                currentBinaryData = currentDbFlashSegment.getBinaryData();
                lengthOfCurrentBinaryData = currentBinaryData.length;
                sizeOfFlashSession += lengthOfCurrentBinaryData;
            }
        }
        return sizeOfFlashSession;
    }
}

