/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary2.util.logging.impl;

import asam.d.MCDError;
import asam.d.MCDException;
import com.audi.mcd.joblibrary2.jobs.AbstractJob;
import com.audi.mcd.joblibrary2.util.DateTime;
import com.audi.mcd.joblibrary2.util.McdEnumDecoder;
import com.audi.mcd.joblibrary2.util.logging.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class LoggerImpl
implements Logger {
    public static final int LOGGING_BUFFER_SIZE = 32768;
    private Class loggedClass = null;
    private String loggedClassName = null;
    private String loggedJobRevision = null;
    private int logLevel = 0;
    private boolean configuredByPropertiesFile = false;
    private String logFileName = null;
    private String traceFileName = null;
    private PrintWriter logWriter = null;
    private PrintWriter traceWriter = null;

    public LoggerImpl(AbstractJob pAbstractJob) {
        this.loggedClass = pAbstractJob.getClass();
        this.loggedClassName = this.loggedClass.getName().substring(this.loggedClass.getName().lastIndexOf(".") + 1);
        this.loggedJobRevision = pAbstractJob.getRevision();
    }

    public final int determineLogLevel(String pClassName) {
        String logDirectoryName = null;
        File logDirectory = null;
        String logPropertyFileName = null;
        File logPropertyFile = null;
        Properties logProperties = null;
        FileInputStream logPropertyInputStream = null;
        String logLevelAsString = null;
        int configuredLogLevel = 0;
        logDirectoryName = LOG_DIRECTORY_NAME;
        logDirectory = new File(logDirectoryName);
        if (!logDirectory.exists()) {
            if (LOG_DIRECTORY_NAME_DSA == null) {
                return 0;
            }
            logDirectoryName = LOG_DIRECTORY_NAME_DSA;
            logDirectory = new File(logDirectoryName);
            if (!logDirectory.exists()) {
                return 0;
            }
        }
        if (!(logPropertyFileName = logDirectoryName).endsWith(File.separator)) {
            logPropertyFileName = logPropertyFileName + File.separator;
        }
        if (!(logPropertyFile = new File(logPropertyFileName = logPropertyFileName + "loglevel.properties")).exists()) {
            return 0;
        }
        if (!logPropertyFile.isFile()) {
            System.err.println("Log property file is not a regular file!");
            return 0;
        }
        if (!logPropertyFile.canRead()) {
            System.err.println("Log property file is not readable!");
            return 0;
        }
        try {
            logPropertyInputStream = new FileInputStream(logPropertyFile);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Log property file not found!");
            return 0;
        }
        logProperties = new Properties();
        try {
            logProperties.load(logPropertyInputStream);
        }
        catch (IOException ioe) {
            System.err.println("Log property file is not a properties file or contains illegal characters!");
            return 0;
        }
        logLevelAsString = logProperties.getProperty(pClassName);
        if (logLevelAsString == null) {
            return 0;
        }
        if ((logLevelAsString = logLevelAsString.trim()).length() == 0) {
            System.err.println("Log level for '" + pClassName + "' is empty!");
            return 0;
        }
        try {
            configuredLogLevel = Integer.parseInt(logLevelAsString);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Log level for '" + pClassName + "' is not an integer value (" + logLevelAsString + ")!");
            return 0;
        }
        if (configuredLogLevel < 0) {
            configuredLogLevel = 0;
        }
        if (configuredLogLevel > 6) {
            configuredLogLevel = 6;
        }
        this.configuredByPropertiesFile = true;
        return configuredLogLevel;
    }

    public final void init(String pAdditionalInformation) {
        this.logLevel = this.determineLogLevel(this.loggedClassName);
        this.init(pAdditionalInformation, this.logLevel);
    }

    public void init(String pAdditionalInformation, int pLogLevel) {
        String logDirectoryName = null;
        File logDirectory = null;
        File parentDirectory = null;
        boolean isLogDirectoryCreated = false;
        this.logLevel = pLogLevel;
        if (this.logLevel == 0) {
            return;
        }
        logDirectoryName = LOG_DIRECTORY_NAME;
        logDirectory = new File(logDirectoryName);
        parentDirectory = logDirectory.getParentFile();
        if (!parentDirectory.canWrite()) {
            if (LOG_DIRECTORY_NAME_DSA == null) {
                System.err.println("Unable to create log directory or file due to missing write permissions for directory '" + parentDirectory + "'... logging disabled!");
                this.logWriter = null;
                this.logLevel = 0;
                return;
            }
            logDirectoryName = LOG_DIRECTORY_NAME_DSA;
            logDirectory = new File(logDirectoryName);
        }
        if (!logDirectory.exists()) {
            try {
                isLogDirectoryCreated = logDirectory.mkdirs();
            }
            catch (SecurityException se) {
                System.err.println("Error creating log directory.");
                se.printStackTrace();
                this.logWriter = null;
                this.logLevel = 0;
                return;
            }
            if (!isLogDirectoryCreated) {
                System.err.println("Error creating log directory.");
                this.logWriter = null;
                this.logLevel = 0;
                return;
            }
        }
        this.logFileName = pAdditionalInformation == null || pAdditionalInformation.trim().length() == 0 ? DateTime.buildTimestampFileName(logDirectoryName + File.separator, this.loggedClassName + "_", "log") : DateTime.buildTimestampFileName(logDirectoryName + File.separator, this.loggedClassName + "_" + pAdditionalInformation.trim() + "_", "log");
        try {
            this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.logFileName), 32768));
        }
        catch (IOException ioe) {
            System.err.println("Error creating log file.");
            ioe.printStackTrace();
            this.logWriter = null;
            this.logLevel = 0;
            return;
        }
        this.fatal("--------------------------------------------------------------------------------");
        this.fatal("Logging activated: " + this.logFileName);
        this.fatal("Job revision: " + this.loggedClassName + "-" + this.loggedJobRevision);
        this.fatal("--------------------------------------------------------------------------------");
        this.fatal("Logging started in init(...) on " + DateTime.buildDateString() + " at " + DateTime.buildTimeString() + ".");
        if (this.logLevel >= 6) {
            this.traceFileName = this.logFileName.substring(0, this.logFileName.lastIndexOf(".") + 1) + "asc";
            try {
                this.traceWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.traceFileName), 32768));
            }
            catch (IOException ioe) {
                System.err.println("Error creating trace file.");
                ioe.printStackTrace();
                this.traceWriter = null;
                return;
            }
            this.busTrace("--------------------------------------------------------------------------------");
            this.busTrace("Trace activated: " + this.traceFileName);
            this.busTrace("--------------------------------------------------------------------------------");
            this.busTrace("Tracing started at " + DateTime.buildTimeString() + ".");
            this.busTrace("");
        }
    }

    public boolean isConfiguredByPropertiesFile() {
        return this.configuredByPropertiesFile;
    }

    public final void flush() {
        if (this.logWriter != null) {
            this.logWriter.flush();
        }
    }

    public final void exit() {
        if (this.logWriter != null) {
            this.flush();
            this.logWriter.close();
        }
        if (this.traceWriter != null) {
            this.traceWriter.close();
        }
    }

    public void finalize(String pJobRuntime) {
        this.fatal("Logging stopped in finalizeLogging(...) on " + DateTime.buildDateString() + " at " + DateTime.buildTimeString() + ".");
        this.fatal("Job runtime: " + pJobRuntime);
        this.fatal("--------------------------------------------------------------------------------");
        this.fatal("End of log.");
        this.fatal("--------------------------------------------------------------------------------");
        if (this.logLevel >= 6) {
            this.busTrace("");
            this.busTrace("--------------------------------------------------------------------------------");
            this.busTrace("End of trace.");
            this.busTrace("--------------------------------------------------------------------------------");
            if (this.traceWriter != null) {
                this.traceWriter.close();
            }
        }
        this.exit();
    }

    public final int getLogLevel() {
        return this.logLevel;
    }

    public final void log(int pLogLevel, String pMessage) {
        if (this.logLevel > 0 && this.logLevel >= pLogLevel && this.logWriter != null) {
            this.logWriter.println(pMessage);
            if (this.logLevel >= 6) {
                this.logWriter.flush();
            }
        }
    }

    public final void fatal(String pMessage) {
        this.log(1, pMessage);
    }

    public final void error(String pMessage) {
        this.log(2, pMessage);
    }

    public final void warn(String pMessage) {
        this.log(3, pMessage);
    }

    public final void info(String pMessage) {
        this.log(4, pMessage);
    }

    public final void debug(String pMessage) {
        this.log(5, pMessage);
    }

    public final void trace(String pMessage) {
        this.log(6, pMessage);
    }

    public final void logThrowable(Throwable pThrowable) {
        if (this.logWriter != null) {
            if (pThrowable instanceof MCDException) {
                this.logMcdError(((MCDException)pThrowable).getError());
            }
            pThrowable.printStackTrace(this.logWriter);
            this.logWriter.flush();
        }
    }

    public void logMcdError(MCDError pError) {
        if (pError != null) {
            this.debug("Details of MCDError are");
            this.debug("- Severity             : " + McdEnumDecoder.decodeMcdSeverity(pError.getSeverity()));
            this.debug("- Code                 : 0x" + Integer.toHexString(pError.getCode()).toUpperCase() + " (" + McdEnumDecoder.decodeMcdErrorCodes(pError.getCode()) + ")");
            this.debug("- CodeDescription      : " + pError.getCodeDescription());
            this.debug("- VendorCode           : 0x" + Integer.toHexString(pError.getVendorCode()).toUpperCase());
            this.debug("- VendorCodeDescription: " + pError.getVendorCodeDescription());
        }
    }

    public void busTrace(String pMessage) {
        if (this.logLevel >= 6 && this.traceWriter != null) {
            this.traceWriter.println(pMessage);
            this.logWriter.flush();
        }
    }
}

