/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.util.impl;

import asam.d.MCDException;
import asam.d.MCDParameter;
import asam.d.MCDRequestParameter;
import asam.d.MCDTextTableElement;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.util.Conversions;
import com.audi.mcd.joblibrary.util.SubSystemHelper;
import com.audi.mcd.joblibrary.util.dserver.McdTextTableHelper;
import com.audi.mcd.joblibrary.util.logging.Logger;
import java.util.HashMap;
import java.util.Map;

public class SubSystemHelperImpl
implements SubSystemHelper {
    protected static final Map subSystemIdentificationBaseDataIdentifiers = new HashMap();
    protected static final Map subSystemIdentificationSuffixes;
    protected Logger logger = null;
    protected McdTextTableHelper textTableHelper = null;

    public SubSystemHelperImpl(Logger pLogger, McdTextTableHelper pTextTableHelper) {
        this.logger = pLogger;
        this.textTableHelper = pTextTableHelper;
    }

    public boolean findAndSetMatchingTextTableElementWithSubSystemId(String pServiceShortName, MCDRequestParameter pRequestParameter, short pSubSystemId) {
        Integer baseDataIdentifierAsInteger = null;
        int baseDataIdentifier = 0;
        String subSystemShortName = null;
        int expectedDataIdentifier = 0;
        MCDTextTableElement textTableElement = null;
        String vtOfTextTableElement = null;
        MCDValue value_tableKey = null;
        baseDataIdentifierAsInteger = (Integer)subSystemIdentificationBaseDataIdentifiers.get(pServiceShortName);
        if (baseDataIdentifierAsInteger == null) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.debug("No base data identifier found for " + pServiceShortName + "!");
            }
            return false;
        }
        baseDataIdentifier = baseDataIdentifierAsInteger;
        if (this.logger.getLogLevel() >= 5) {
            this.logger.debug("Base data identifier for " + pServiceShortName + " is: 0x" + Integer.toHexString(baseDataIdentifier).toUpperCase());
        }
        expectedDataIdentifier = baseDataIdentifier + pSubSystemId;
        if (this.logger.getLogLevel() >= 5) {
            this.logger.debug("Expected data identifier for subsystem id 0x" + Integer.toHexString(pSubSystemId).toUpperCase() + " is: 0x" + Integer.toHexString(expectedDataIdentifier).toUpperCase());
        }
        if (this.logger.getLogLevel() >= 5) {
            this.logger.debug("Searching matching text table element for data identifier 0x" + Integer.toHexString(expectedDataIdentifier).toUpperCase() + "...");
        }
        try {
            textTableElement = this.textTableHelper.getTextTableElementOfParameterByCodedValueUint32((MCDParameter)pRequestParameter, expectedDataIdentifier);
            if (textTableElement == null) {
                return false;
            }
            vtOfTextTableElement = textTableElement.getLongName();
            if (this.logger.getLogLevel() >= 5) {
                this.logger.debug("... found matching text table element: " + vtOfTextTableElement);
            }
        }
        catch (MCDException mcde) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.error("Error locating matching text table element for " + subSystemShortName);
                this.logger.logThrowable(mcde);
            }
            return false;
        }
        if (this.logger.getLogLevel() >= 5) {
            this.logger.error("Setting \"" + vtOfTextTableElement + "\" to request parameter.");
        }
        try {
            value_tableKey = pRequestParameter.createValue();
            value_tableKey.setValueAsString(vtOfTextTableElement);
            pRequestParameter.setValue(value_tableKey);
        }
        catch (MCDException mcde) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.error("Error setting TABLE-KEY to request parameter!");
                this.logger.logThrowable(mcde);
            }
            return false;
        }
        return true;
    }

    public boolean findAndSetMatchingTextTableElementWithSubSystemLongName(String pServiceShortName, MCDRequestParameter pRequestParameter, String pSubSystemLongName) {
        String vtSuffixLongName = null;
        String subSystemLongName = null;
        String subSystemShortName = null;
        String vtSuffixShortName = null;
        String vtConcatenatedAsShortName = null;
        MCDTextTableElements textTableElements = null;
        long numberOfTextTableElements = 0L;
        MCDTextTableElement currentTextTableElement = null;
        String vtOfCurrentTextTableElement = null;
        String vtOfCurrentTextTableElementAsShortName = null;
        boolean foundMatch = false;
        MCDValue value_tableKey = null;
        vtSuffixLongName = (String)subSystemIdentificationSuffixes.get(pServiceShortName);
        if (vtSuffixLongName == null) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.debug("No VT suffix found for " + pServiceShortName + "!");
            }
            return false;
        }
        if (this.logger.getLogLevel() >= 5) {
            this.logger.debug("VT suffix for " + pServiceShortName + " is: " + vtSuffixLongName);
        }
        if (pSubSystemLongName.endsWith(" Sub")) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.debug("Stripping suffix \" Sub\" from sub system name.");
            }
            subSystemLongName = pSubSystemLongName.substring(0, pSubSystemLongName.length() - " Sub".length());
        } else {
            subSystemLongName = pSubSystemLongName;
        }
        subSystemShortName = Conversions.longName2ShortName("", subSystemLongName);
        vtSuffixShortName = Conversions.longName2ShortName("", vtSuffixLongName);
        vtConcatenatedAsShortName = subSystemShortName + vtSuffixShortName;
        if (this.logger.getLogLevel() >= 5) {
            this.logger.debug("Searching matching text table element for \"" + subSystemLongName + "[" + vtSuffixLongName + "]\" ( " + subSystemShortName + "[" + vtSuffixShortName + "] )...");
        }
        try {
            textTableElements = this.textTableHelper.getTextTableElementsOfParameter((MCDParameter)pRequestParameter);
            numberOfTextTableElements = textTableElements.getCount();
            for (long i = 0L; i < numberOfTextTableElements; ++i) {
                currentTextTableElement = textTableElements.getItemByIndex(i);
                vtOfCurrentTextTableElement = currentTextTableElement.getLongName();
                vtOfCurrentTextTableElementAsShortName = Conversions.longName2ShortName("", vtOfCurrentTextTableElement);
                if (vtOfCurrentTextTableElementAsShortName.equals(vtConcatenatedAsShortName) || vtOfCurrentTextTableElementAsShortName.equals(subSystemShortName)) {
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("... found matching text table element: " + vtOfCurrentTextTableElement);
                    }
                    foundMatch = true;
                } else {
                    if (!vtOfCurrentTextTableElementAsShortName.equalsIgnoreCase(vtConcatenatedAsShortName) && !vtOfCurrentTextTableElementAsShortName.equalsIgnoreCase(subSystemShortName)) continue;
                    if (this.logger.getLogLevel() >= 5) {
                        this.logger.debug("... found (case-insensitively) matching text table element: " + vtOfCurrentTextTableElement);
                    }
                    foundMatch = true;
                }
                break;
            }
        }
        catch (MCDException mcde) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.error("Error locating matching text table element for " + subSystemShortName);
                this.logger.logThrowable(mcde);
            }
            return false;
        }
        if (!foundMatch) {
            return false;
        }
        if (this.logger.getLogLevel() >= 5) {
            this.logger.error("Setting \"" + vtOfCurrentTextTableElement + "\" to request parameter.");
        }
        try {
            value_tableKey = pRequestParameter.createValue();
            value_tableKey.setValueAsString(vtOfCurrentTextTableElement);
            pRequestParameter.setValue(value_tableKey);
        }
        catch (MCDException mcde) {
            if (this.logger.getLogLevel() >= 5) {
                this.logger.error("Error setting TABLE-KEY to request parameter!");
                this.logger.logThrowable(mcde);
            }
            return false;
        }
        return true;
    }

    static {
        subSystemIdentificationBaseDataIdentifiers.put("DiagnServi_ReadDataByIdentVWSlaveSysteName", BASE_DATA_IDENTIFIER_SYSTEM_NAME);
        subSystemIdentificationBaseDataIdentifiers.put("DiagnServi_ReadDataByIdentVWSlaveSparePartNumbe", BASE_DATA_IDENTIFIER_SPARE_PART_NUMBER);
        subSystemIdentificationBaseDataIdentifiers.put("DiagnServi_ReadDataByIdentVWSlaveHardwNumbe", BASE_DATA_IDENTIFIER_HARDWARE_NUMBER);
        subSystemIdentificationBaseDataIdentifiers.put("DiagnServi_ReadDataByIdentVWSlaveSoftwVersiNumbe", BASE_DATA_IDENTIFIER_APPLICATION_SOFTWARE_VERSION_NUMBER);
        subSystemIdentificationBaseDataIdentifiers.put("DiagnServi_ReadDataByIdentVWSlaveHardwVersiNumbe", BASE_DATA_IDENTIFIER_HARDWARE_VERSION_NUMBER);
        subSystemIdentificationBaseDataIdentifiers.put("DiagnServi_ReadDataByIdentVWSlaveSeriaNumbe", BASE_DATA_IDENTIFIER_SERIAL_NUMBER);
        subSystemIdentificationBaseDataIdentifiers.put("DiagnServi_ReadDataByIdentVWSlaveCodinValue", BASE_DATA_IDENTIFIER_CODING_VALUES);
        subSystemIdentificationBaseDataIdentifiers.put("DiagnServi_ReadDataByIdentVWSlaveFAZITIdentStrin", BASE_DATA_IDENTIFIER_VW_SLAVE_FAZIT_STRING);
        subSystemIdentificationBaseDataIdentifiers.put("DiagnServi_WriteDataByIdentVWSlaveCodinValue", BASE_DATA_IDENTIFIER_CODING_VALUES);
        subSystemIdentificationSuffixes = new HashMap();
        subSystemIdentificationSuffixes.put("DiagnServi_ReadDataByIdentVWSlaveSysteName", "_System_Name");
        subSystemIdentificationSuffixes.put("DiagnServi_ReadDataByIdentVWSlaveSparePartNumbe", "_Spare_Part_Number");
        subSystemIdentificationSuffixes.put("DiagnServi_ReadDataByIdentVWSlaveHardwNumbe", "_Hardware_Number");
        subSystemIdentificationSuffixes.put("DiagnServi_ReadDataByIdentVWSlaveSoftwVersiNumbe", "_Application_Software_Version_Number");
        subSystemIdentificationSuffixes.put("DiagnServi_ReadDataByIdentVWSlaveHardwVersiNumbe", "_Hardware_Version_Number");
        subSystemIdentificationSuffixes.put("DiagnServi_ReadDataByIdentVWSlaveSeriaNumbe", "_Serial_Number");
        subSystemIdentificationSuffixes.put("DiagnServi_ReadDataByIdentVWSlaveCodinValue", "_Coding_Values");
        subSystemIdentificationSuffixes.put("DiagnServi_ReadDataByIdentVWSlaveFAZITIdentStrin", "_VW_Slave_FAZIT_string");
        subSystemIdentificationSuffixes.put("DiagnServi_WriteDataByIdentVWSlaveCodinValue", "_Coding_Values");
    }
}

