/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.util.logging.impl;

import asam.d.MCDAccessKey;
import asam.d.MCDDbAccessLevel;
import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDataPrimitives;
import asam.d.MCDDbDiagComPrimitive;
import asam.d.MCDDbDiagTroubleCode;
import asam.d.MCDDbFlashChecksum;
import asam.d.MCDDbFlashChecksums;
import asam.d.MCDDbFlashData;
import asam.d.MCDDbFlashDataBlock;
import asam.d.MCDDbFlashDataBlocks;
import asam.d.MCDDbFlashFilter;
import asam.d.MCDDbFlashFilters;
import asam.d.MCDDbFlashIdent;
import asam.d.MCDDbFlashIdents;
import asam.d.MCDDbFlashJob;
import asam.d.MCDDbFlashSecurities;
import asam.d.MCDDbFlashSecurity;
import asam.d.MCDDbFlashSegment;
import asam.d.MCDDbFlashSegments;
import asam.d.MCDDbFlashSession;
import asam.d.MCDDbFlashSessionClass;
import asam.d.MCDDbFlashSessionClasses;
import asam.d.MCDDbFlashSessions;
import asam.d.MCDDbFunctionalClasses;
import asam.d.MCDDbIdentDescription;
import asam.d.MCDDbJob;
import asam.d.MCDDbObject;
import asam.d.MCDDbRequest;
import asam.d.MCDDbResponses;
import asam.d.MCDDbSpecialData;
import asam.d.MCDDbSpecialDataElement;
import asam.d.MCDDbSpecialDataGroup;
import asam.d.MCDDbSpecialDataGroupCaption;
import asam.d.MCDDbSpecialDataGroups;
import asam.d.MCDError;
import asam.d.MCDException;
import asam.d.MCDInterval;
import asam.d.MCDParameter;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDResultState;
import asam.d.MCDTextTableElement;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import asam.d.MCDValues;
import asam.d.MCDVersion;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import com.audi.mcd.joblibrary.util.dserver.DServerVendor;
import com.audi.mcd.joblibrary.util.dserver.VendorSpecific;
import com.audi.mcd.joblibrary.util.logging.Logger;
import com.audi.mcd.joblibrary.util.logging.McdObjectDumper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;

public class McdObjectDumperImpl
implements McdObjectDumper {
    protected static final String LOG_MESSAGE_INDENTATION = "  ";
    private Logger logger = null;
    protected VendorSpecific vendorSpecific = null;

    public McdObjectDumperImpl(Logger pLogger) {
        this.logger = pLogger;
    }

    public void dumpDbDataPrimitive(MCDDbDataPrimitive pDbDataPrimitive, int pLevel) throws MCDException {
        this.dumpDbDiagComPrimitive((MCDDbDiagComPrimitive)pDbDataPrimitive, pLevel);
        MCDDbAccessLevel dbAccessLevel = pDbDataPrimitive.getAccessLevel();
        MCDDbSpecialDataGroups dbSpecialDataGroups = pDbDataPrimitive.getDbSDGs();
        String[] relationTypes = new String[]{};
        for (int i = 0; i < relationTypes.length; ++i) {
            MCDDbDataPrimitives relatedDbDataPrimitives = pDbDataPrimitive.getRelatedDataPrimitives(relationTypes[i]);
        }
        int repetitionMode = pDbDataPrimitive.getRepetitionMode();
    }

    public void dumpDbDiagComPrimitive(MCDDbDiagComPrimitive pDbDiagComPrimitive, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbDiagComPrimitive, pLevel);
        MCDDbFunctionalClasses dbFunctionalClasses = pDbDiagComPrimitive.getDbFunctionalClasses();
        MCDDbRequest dbRequest = pDbDiagComPrimitive.getDbRequest();
        MCDDbResponses dbResponses = pDbDiagComPrimitive.getDbResponses();
        String semantic = pDbDiagComPrimitive.getSemantic();
        int transmissionMode = pDbDiagComPrimitive.getTransmissionMode();
        boolean isApiExecutable = pDbDiagComPrimitive.isApiExecutable();
        boolean isNoOperation = pDbDiagComPrimitive.isNoOperation();
    }

    public void dumpDbDiagTroubleCode(MCDDbDiagTroubleCode pMcdDbDiagTroubleCode, int pLevel) throws MCDException {
        String uniqueObjectIdentifier = null;
        String shortName = null;
        long troubleCode = -1L;
        String displayTroubleCode = null;
        String ti = null;
        String dtcText = null;
        long level = -1L;
        MCDDbSpecialDataGroups dbSpecialDataGroups = null;
        if (pMcdDbDiagTroubleCode == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbDiagTroubleCode is null!"));
        } else {
            block7: {
                try {
                    uniqueObjectIdentifier = pMcdDbDiagTroubleCode.getUniqueObjectIdentifier();
                    if (uniqueObjectIdentifier.trim().length() > 0) {
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Unique Object ID    : " + uniqueObjectIdentifier));
                    }
                }
                catch (MCDException mcde) {
                    if (mcde.getError().getCode() == 57362) break block7;
                    this.logger.debug("Error getting OID of DbDiagTroubleCode!");
                    this.logger.logThrowable(mcde);
                }
            }
            shortName = pMcdDbDiagTroubleCode.getShortName();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "ShortName           : " + shortName));
            troubleCode = pMcdDbDiagTroubleCode.getTroubleCode();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "TroubleCode         : 0x" + Long.toHexString(troubleCode).toUpperCase()));
            displayTroubleCode = pMcdDbDiagTroubleCode.getDisplayTroubleCode();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DisplayTroubleCode  : " + displayTroubleCode));
            ti = this.vendorSpecific.getLongNameIDOfDbDiagTroubleCode(pMcdDbDiagTroubleCode);
            if (ti != null && ti.trim().length() > 0) {
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "TI                  : " + ti));
            }
            dtcText = pMcdDbDiagTroubleCode.getDTCText();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DTCText             : " + dtcText));
            level = pMcdDbDiagTroubleCode.getLevel();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Level               : " + level));
            if (this.logger.getLogLevel() >= 6) {
                dbSpecialDataGroups = pMcdDbDiagTroubleCode.getDbSDGs();
                this.dumpDbSpecialDataGroups(dbSpecialDataGroups, pLevel);
            }
        }
    }

    public void dumpDbFlashChecksum(MCDDbFlashChecksum pDbFlashChecksum, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbFlashChecksum, pLevel);
        String checksumAlgorithm = pDbFlashChecksum.getChecksumAlgorithm();
        MCDValue checksumResult = pDbFlashChecksum.getChecksumResult();
        int dataTypeOfChecksumResult = checksumResult.getDataType();
        String valueOfChecksumResultAsString = null;
        valueOfChecksumResultAsString = dataTypeOfChecksumResult == 3 ? this.vendorSpecific.pduValue2String(checksumResult) : checksumResult.getValueAsString();
        long compressedSize = pDbFlashChecksum.getCompressedSize();
        byte[] fillbyte = pDbFlashChecksum.getFillByte();
        long sourceEndAddress = pDbFlashChecksum.getSourceEndAddress();
        long sourceStartAddress = pDbFlashChecksum.getSourceStartAddress();
        long uncompressedSize = pDbFlashChecksum.getUncompressedSize();
    }

    public void dumpDbFlashChecksums(MCDDbFlashChecksums pDbFlashChecksums, int pLevel) throws MCDException {
        long numberOfDbFlashChecksums = 0L;
        MCDDbFlashChecksum dbFlashChecksum = null;
        if (pDbFlashChecksums == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbFlashChecksums is null!"));
        } else {
            numberOfDbFlashChecksums = pDbFlashChecksums.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbFlashChecksums: " + numberOfDbFlashChecksums));
            for (long i = 0L; i < numberOfDbFlashChecksums; ++i) {
                dbFlashChecksum = pDbFlashChecksums.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbFlashChecksum with index " + i));
                this.dumpDbFlashChecksum(dbFlashChecksum, pLevel + 1);
            }
        }
    }

    public void dumpDbFlashData(MCDDbFlashData pDbFlashData, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbFlashData, pLevel);
        pDbFlashData.getDataFileName();
        pDbFlashData.getDataFormat();
        MCDValue encryptionCompressionMethod = pDbFlashData.getEncryptionCompressionMethod();
        encryptionCompressionMethod.getDataType();
        encryptionCompressionMethod.getValueAsString();
    }

    public void dumpDbFlashDataBlock(MCDDbFlashDataBlock pDbFlashDataBlock, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbFlashDataBlock, pLevel);
        pDbFlashDataBlock.getAddressOffset();
        pDbFlashDataBlock.getDataBlockType();
        MCDDbFlashData dbFlashData = pDbFlashDataBlock.getDbFlashData();
        MCDDbFlashFilters dbFlashFilters = pDbFlashDataBlock.getDbFlashFilters();
        MCDDbFlashSegments dbFlashSegments = pDbFlashDataBlock.getDbFlashSegments();
        MCDDbFlashIdents dbFlashIdents = pDbFlashDataBlock.getDbOwnIdents();
        MCDDbSpecialDataGroups dbSpecialDataGroups = pDbFlashDataBlock.getDbSDGs();
    }

    public void dumpDbFlashDataBlocks(MCDDbFlashDataBlocks pDbFlashDataBlocks, int pLevel) throws MCDException {
        long numberOfDbFlashDataBlocks = 0L;
        MCDDbFlashDataBlock dbFlashDataBlock = null;
        if (pDbFlashDataBlocks == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbFlashDataBlocks is null!"));
        } else {
            numberOfDbFlashDataBlocks = pDbFlashDataBlocks.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbFlashDataBlocks: " + numberOfDbFlashDataBlocks));
            for (long i = 0L; i < numberOfDbFlashDataBlocks; ++i) {
                dbFlashDataBlock = pDbFlashDataBlocks.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbFlashDataBlock with index " + i));
                this.dumpDbFlashDataBlock(dbFlashDataBlock, pLevel + 1);
            }
        }
    }

    public void dumpDbFlashFilter(MCDDbFlashFilter pDbFlashFilter, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbFlashFilter, pLevel);
        pDbFlashFilter.getFilterEnd();
        pDbFlashFilter.getFilterSize();
        pDbFlashFilter.getFilterStart();
    }

    public void dumpDbFlashFilters(MCDDbFlashFilters pDbFlashFilters, int pLevel) throws MCDException {
        long numberOfDbFlashFilters = 0L;
        MCDDbFlashFilter dbFlashFilter = null;
        if (pDbFlashFilters == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbFlashFilters is null!"));
        } else {
            numberOfDbFlashFilters = pDbFlashFilters.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbFlashFilters: " + numberOfDbFlashFilters));
            for (long i = 0L; i < numberOfDbFlashFilters; ++i) {
                dbFlashFilter = pDbFlashFilters.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbFlashFilter with index " + i));
                this.dumpDbFlashFilter(dbFlashFilter, pLevel + 1);
            }
        }
    }

    public void dumpDbFlashIdent(MCDDbFlashIdent pDbFlashIdent, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbFlashIdent, pLevel);
        MCDValues identValues = pDbFlashIdent.getIdentValues();
        MCDDbIdentDescription readDbIdentDescription = pDbFlashIdent.getReadDbIdentDescription();
        MCDDbIdentDescription writeDbIdentDescription = pDbFlashIdent.getWriteDbIdentDescription();
    }

    public void dumpDbFlashIdents(MCDDbFlashIdents pDbFlashIdents, int pLevel) throws MCDException {
        long numberOfDbFlashIdents = 0L;
        MCDDbFlashIdent dbFlashIdent = null;
        if (pDbFlashIdents == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbFlashIdents is null!"));
        } else {
            numberOfDbFlashIdents = pDbFlashIdents.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbFlashIdents: " + numberOfDbFlashIdents));
            for (long i = 0L; i < numberOfDbFlashIdents; ++i) {
                dbFlashIdent = pDbFlashIdents.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbFlashIdent with index " + i));
                this.dumpDbFlashIdent(dbFlashIdent, pLevel + 1);
            }
        }
    }

    public void dumpDbFlashJob(MCDDbFlashJob pDbFlashJob, int pLevel) throws MCDException {
        if (pDbFlashJob == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbFlashJob is null!"));
        } else {
            this.dumpDbJob((MCDDbJob)pDbFlashJob, pLevel);
        }
    }

    public void dumpDbFlashSecurities(MCDDbFlashSecurities pDbFlashSecurities, int pLevel) throws MCDException {
        long numberOfDbFlashSecurities = 0L;
        MCDDbFlashSecurity dbFlashSecurity = null;
        if (pDbFlashSecurities == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbFlashSecurities is null!"));
        } else {
            numberOfDbFlashSecurities = pDbFlashSecurities.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbFlashSecurities: " + numberOfDbFlashSecurities));
            for (long i = 0L; i < numberOfDbFlashSecurities; ++i) {
                dbFlashSecurity = pDbFlashSecurities.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbFlashSecurity with index " + i));
                this.dumpDbFlashSecurity(dbFlashSecurity, pLevel + 1);
            }
        }
    }

    public void dumpDbFlashSecurity(MCDDbFlashSecurity pDbFlashSecurity, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbFlashSecurity, pLevel);
        MCDValue flashwareChecksum = pDbFlashSecurity.getFlashwareChecksum();
        flashwareChecksum.getDataType();
        flashwareChecksum.getValueAsString();
        MCDValue flashwareSignature = pDbFlashSecurity.getFlashwareSignature();
        flashwareSignature.getDataType();
        flashwareSignature.getValueAsString();
        MCDValue securityMethod = pDbFlashSecurity.getSecurityMethod();
        securityMethod.getDataType();
        securityMethod.getValueAsString();
        MCDValue validity = pDbFlashSecurity.getValidity();
        validity.getDataType();
        validity.getValueAsString();
    }

    public void dumpDbFlashSegment(MCDDbFlashSegment pDbFlashSegment, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbFlashSegment, pLevel);
        pDbFlashSegment.getBinaryData();
        pDbFlashSegment.getCompressedSize();
        pDbFlashSegment.getSourceEndAddress();
        pDbFlashSegment.getSourceStartAddress();
        pDbFlashSegment.getUncompressedSize();
    }

    public void dumpDbFlashSegments(MCDDbFlashSegments pDbFlashSegments, int pLevel) throws MCDException {
        long numberOfDbFlashSegments = 0L;
        MCDDbFlashSegment dbFlashSegment = null;
        if (pDbFlashSegments == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbFlashSegments is null!"));
        } else {
            numberOfDbFlashSegments = pDbFlashSegments.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbFlashSegments: " + numberOfDbFlashSegments));
            for (long i = 0L; i < numberOfDbFlashSegments; ++i) {
                dbFlashSegment = pDbFlashSegments.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbFlashSegment with index " + i));
                this.dumpDbFlashSegment(dbFlashSegment, pLevel + 1);
            }
        }
    }

    public void dumpDbFlashSession(MCDDbFlashSession pDbFlashSession, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbFlashSession, pLevel);
        MCDDbFlashChecksums dbFlashChecksums = pDbFlashSession.getChecksums();
        MCDDbFlashDataBlocks dbFlashDataBlocks = pDbFlashSession.getDbDataBlocks();
        MCDDbFlashIdents dbExpectedIdents = pDbFlashSession.getDbExpectedIdents();
        MCDDbFlashJob dbFlashJob = pDbFlashSession.getDbFlashJob();
        MCDDbFlashSessionClasses dbFlashSessionClasses = pDbFlashSession.getDbFlashSessionsClasses();
        MCDDbSpecialDataGroups dbSpecialDataGroups = pDbFlashSession.getDbSDGs();
        MCDDbFlashSecurities dbFlashSecurities = pDbFlashSession.getDbSecurities();
        String flashKey = pDbFlashSession.getFlashKey();
        long priority = pDbFlashSession.getPriority();
    }

    public void dumpDbFlashSessions(MCDDbFlashSessions pDbFlashSessions, int pLevel) throws MCDException {
        long numberOfDbFlashSessions = 0L;
        MCDDbFlashSession dbFlashSession = null;
        if (pDbFlashSessions == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbFlashSessions is null!"));
        } else {
            numberOfDbFlashSessions = pDbFlashSessions.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbFlashSessions: " + numberOfDbFlashSessions));
            for (long i = 0L; i < numberOfDbFlashSessions; ++i) {
                dbFlashSession = pDbFlashSessions.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbFlashSession with index " + i));
                this.dumpDbFlashSession(dbFlashSession, pLevel + 1);
            }
        }
    }

    public void dumpDbFlashSessionClass(MCDDbFlashSessionClass pDbFlashSessionClass, int pLevel) throws MCDException {
        this.dumpDbObject((MCDDbObject)pDbFlashSessionClass, pLevel);
        MCDDbFlashSessions dbFlashSessions = pDbFlashSessionClass.getDbFlashSessions();
    }

    public void dumpDbFlashSessionClasses(MCDDbFlashSessionClasses pDbFlashSessionClasses, int pLevel) throws MCDException {
        long numberOfDbFlashSessionClasses = 0L;
        MCDDbFlashSessionClass dbFlashSessionClass = null;
        if (pDbFlashSessionClasses == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbFlashSessionClasses is null!"));
        } else {
            numberOfDbFlashSessionClasses = pDbFlashSessionClasses.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbFlashSessionClasses: " + numberOfDbFlashSessionClasses));
            for (long i = 0L; i < numberOfDbFlashSessionClasses; ++i) {
                dbFlashSessionClass = pDbFlashSessionClasses.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbFlashSessionClass with index " + i));
                this.dumpDbFlashSessionClass(dbFlashSessionClass, pLevel + 1);
            }
        }
    }

    public void dumpDbJob(MCDDbJob pDbJob, int pLevel) throws MCDException {
        this.dumpDbDataPrimitive((MCDDbDataPrimitive)pDbJob, pLevel);
        MCDVersion version = pDbJob.getVersion();
        boolean isReducedResultsEnabled = pDbJob.isReducedResultEnabled();
    }

    public void dumpDbObject(MCDDbObject pDbObject, int pLevel) throws MCDException {
        String description = pDbObject.getDescription();
        String descriptionID = pDbObject.getDescriptionID();
        String longName = pDbObject.getLongName();
        String longNameID = pDbObject.getLongNameID();
        String shortName = pDbObject.getShortName();
        String uniqueObjectIdentifier = pDbObject.getUniqueObjectIdentifier();
    }

    public void dumpDbSpecialData(MCDDbSpecialData pDbSpecialData, int pLevel) throws MCDException {
        MCDDbSpecialDataElement dbSpecialDataElement = null;
        MCDDbSpecialDataGroup dbSpecialDataGroup = null;
        if (pDbSpecialData == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbSpecialData is null!"));
        } else if (pDbSpecialData instanceof MCDDbSpecialDataElement) {
            dbSpecialDataElement = (MCDDbSpecialDataElement)pDbSpecialData;
            this.dumpDbSpecialDataElement(dbSpecialDataElement, pLevel);
        } else if (pDbSpecialData instanceof MCDDbSpecialDataGroup) {
            dbSpecialDataGroup = (MCDDbSpecialDataGroup)pDbSpecialData;
            this.dumpDbSpecialDataGroup(dbSpecialDataGroup, pLevel + 1);
        }
    }

    public void dumpDbSpecialDataElement(MCDDbSpecialDataElement pDbSpecialDataElement, int pLevel) throws MCDException {
        String semanticInformation = null;
        String ti = null;
        String content = null;
        if (pDbSpecialDataElement == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbSpecialDataElement is null!"));
        } else {
            semanticInformation = pDbSpecialDataElement.getSemanticInformation();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Semantic information: " + semanticInformation));
            ti = pDbSpecialDataElement.getTextID();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "TI                  : " + ti));
            content = pDbSpecialDataElement.getContent();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Content             : " + content));
        }
    }

    public void dumpDbSpecialDataGroup(MCDDbSpecialDataGroup pDbSpecialDataGroup, int pLevel) throws MCDException {
        long numberOfDbSpecialData = -1L;
        MCDDbSpecialData dbSpecialData = null;
        if (pDbSpecialDataGroup == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbSpecialDataGroup is null!"));
        } else {
            numberOfDbSpecialData = pDbSpecialDataGroup.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbSpecialData: " + numberOfDbSpecialData));
            for (long i = 0L; i < numberOfDbSpecialData; ++i) {
                dbSpecialData = pDbSpecialDataGroup.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbSpecialData with index " + i));
                this.dumpDbSpecialData(dbSpecialData, pLevel + 1);
            }
        }
    }

    public void dumpDbSpecialDataGroupCaption(MCDDbSpecialDataGroupCaption pDbSpecialDataGroupCaption, int pLevel) throws MCDException {
        if (pDbSpecialDataGroupCaption == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbSpecialDataGroupCaption is null!"));
        } else {
            this.dumpDbObject((MCDDbObject)pDbSpecialDataGroupCaption, pLevel);
        }
    }

    public void dumpDbSpecialDataGroups(MCDDbSpecialDataGroups pDbSpecialDataGroups, int pLevel) throws MCDException {
        long numberOfDbSpecialDataGroups = -1L;
        MCDDbSpecialDataGroup dbSpecialDataGroup = null;
        if (pDbSpecialDataGroups == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "DbSpecialDataGroups is null!"));
        } else {
            numberOfDbSpecialDataGroups = pDbSpecialDataGroups.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of DbSpecialDataGroups: " + numberOfDbSpecialDataGroups));
            for (long i = 0L; i < numberOfDbSpecialDataGroups; ++i) {
                dbSpecialDataGroup = pDbSpecialDataGroups.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping DbSpecialDataGroup with index " + i));
                this.dumpDbSpecialDataGroup(dbSpecialDataGroup, pLevel + 1);
            }
        }
    }

    public void dumpParameter(MCDParameter pParameter, int pLevel) throws MCDException {
        MCDRequestParameter requestParameter = null;
        MCDResponseParameter responseParameter = null;
        String shortName = null;
        String longName = null;
        Object longNameTI = null;
        String description = null;
        int parameterType = -1;
        int valueRangeInfo = -1;
        MCDValue value = null;
        int dataType = -1;
        long valueUint32 = -1L;
        String valueAsString = null;
        String unit = null;
        String unitTI = null;
        MCDDbDiagTroubleCode dbDiagTroubleCode = null;
        MCDRequestParameters requestParameters = null;
        MCDResponseParameters responseParameters = null;
        String ti = null;
        MCDTextTableElements textTableElements = null;
        if (pParameter == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Parameter is null!"));
        } else {
            if (pParameter instanceof MCDRequestParameter) {
                requestParameter = (MCDRequestParameter)pParameter;
            } else if (pParameter instanceof MCDResponseParameter) {
                responseParameter = (MCDResponseParameter)pParameter;
            }
            if (responseParameter != null) {
                if (responseParameter.hasError()) {
                    this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Response parameter has error."));
                    MCDError error = responseParameter.getError();
                    this.logger.logMcdError(error);
                } else {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Response parameter has no error."));
                }
            }
            shortName = pParameter.getShortName();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "ShortName           : " + shortName));
            longName = pParameter.getLongName();
            if (longName.trim().length() > 0) {
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "LongName            : " + longName));
            }
            if ((description = pParameter.getDescription()).trim().length() > 0) {
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Description         : " + description));
            }
            parameterType = pParameter.getType();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Type of parameter   : " + McdEnumDecoder.decodeMcdDataType(parameterType)));
            try {
                valueRangeInfo = pParameter.getValueRangeInfo();
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Range info of value : " + McdEnumDecoder.decodeMcdRangeInfo(valueRangeInfo)));
            }
            catch (MCDException mcde) {
                this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Error getting range info of value!"));
                if (VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && mcde.getError().getCode() == 53315 && mcde.getError().getVendorCode() == 12288) {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "No MCDRangeInfo available due to missing default value."));
                }
                this.logger.logMcdError(mcde.getError());
            }
            try {
                value = pParameter.getValue();
            }
            catch (MCDException mcde) {
                this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Error getting value!"));
                if (valueRangeInfo == 1542 && (mcde.getError().getCode() == 57366 || mcde.getError().getCode() == 57362)) {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "No value available with RangeInfo=" + McdEnumDecoder.decodeMcdRangeInfo(valueRangeInfo) + " due to missing default value."));
                }
                if (VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && valueRangeInfo == 1538 && mcde.getError().getCode() == 53315) {
                    if (parameterType == 23 && mcde.getError().getVendorCode() == 12288) {
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Value for parameters of type " + McdEnumDecoder.decodeMcdDataType(23) + " is unavailable with SIDIS."));
                    } else if (mcde.getError().getVendorCode() == 12358) {
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "No TABLE-STRUCT available due to unset TABLE-KEY."));
                    }
                }
                this.logger.logMcdError(mcde.getError());
            }
            if (value == null) {
                if (valueRangeInfo != 1542) {
                    this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "value is null!"));
                }
            } else {
                dataType = value.getDataType();
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "MCDDataType of value: " + McdEnumDecoder.decodeMcdDataType(dataType)));
                switch (dataType) {
                    case 255: {
                        break;
                    }
                    case 11: {
                        valueUint32 = 0L;
                        try {
                            valueUint32 = value.getUint32();
                            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "A_UINT32 value      : " + valueUint32 + " (0x" + Long.toHexString(valueUint32).toUpperCase() + ")"));
                        }
                        catch (MCDException mcde) {
                            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Error getting A_UINT32 value!"));
                            if (VendorSpecific.getServerVendor().equals(DServerVendor.SOFTING) && valueRangeInfo == 1538 && mcde.getError().getCode() == 57366) {
                                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "No value available due to missing default value."));
                                break;
                            }
                            if (VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && mcde.getError().getCode() == 53315 && mcde.getError().getVendorCode() == 12300) {
                                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "No value available due to missing default value."));
                                break;
                            }
                            this.logger.logMcdError(mcde.getError());
                        }
                        break;
                    }
                    default: {
                        try {
                            valueAsString = dataType == 3 ? this.vendorSpecific.pduValue2String(value) : value.getValueAsString();
                            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Value as string     : " + valueAsString));
                            break;
                        }
                        catch (MCDException mcde) {
                            if (VendorSpecific.getServerVendor().equals(DServerVendor.SOFTING) && valueRangeInfo == 1538 && mcde.getError().getCode() == 57366 || VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) && valueRangeInfo == 1538 && mcde.getError().getCode() == 53315 && mcde.getError().getVendorCode() == 12300) {
                                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "No value available due to missing default value."));
                                break;
                            }
                            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Error getting value as String!"));
                            this.logger.logMcdError(mcde.getError());
                        }
                    }
                }
                if (parameterType == 1 || parameterType == 2 || parameterType == 19 || parameterType == 3 || parameterType == 4 || parameterType == 5 || parameterType == 6 || parameterType == 7 || parameterType == 8 || parameterType == 9 || parameterType == 10 || parameterType == 11 || parameterType == 12 || parameterType == 13 || parameterType == 14 || parameterType == 18) {
                    block67: {
                        try {
                            unit = pParameter.getUnit();
                        }
                        catch (MCDException mcde) {
                            if (mcde.getError().getCode() == 57362) break block67;
                            this.logger.logThrowable(mcde);
                        }
                    }
                    if (unit != null) {
                        unitTI = this.vendorSpecific.getLongNameIDOfDbUnitOfParameter(pParameter);
                        if (unit.trim().length() > 0) {
                            if (unitTI != null && unitTI.trim().length() > 0) {
                                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Unit (TI)           : " + unit + " (" + unitTI + ")"));
                            } else {
                                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Unit                : " + unit));
                            }
                        }
                    }
                }
            }
            switch (parameterType) {
                case 20: {
                    if (responseParameter == null) break;
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping parameters of DTC " + shortName + " as DbDtc..."));
                    try {
                        dbDiagTroubleCode = responseParameter.getDbDTC();
                        this.dumpDbDiagTroubleCode(dbDiagTroubleCode, pLevel + 1);
                    }
                    catch (MCDException mcde) {
                        this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Error getting DbDiagTroubleCode!"));
                        if (this.logger.getLogLevel() < 6) break;
                        this.logger.logThrowable(mcde);
                    }
                    break;
                }
                case 22: {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping parameters of END_OF_PDU " + shortName + "..."));
                    if (requestParameter != null) {
                        requestParameters = requestParameter.getParameters();
                        this.dumpRequestParameters(requestParameters, pLevel + 1);
                        break;
                    }
                    if (responseParameter == null) break;
                    responseParameters = responseParameter.getParameters();
                    this.dumpResponseParameters(responseParameters, pLevel + 1);
                    break;
                }
                case 21: {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping parameters of ENVDATA " + shortName + "..."));
                    if (requestParameter != null) {
                        requestParameters = requestParameter.getParameters();
                        this.dumpRequestParameters(requestParameters, pLevel + 1);
                        break;
                    }
                    if (responseParameter == null) break;
                    responseParameters = responseParameter.getParameters();
                    this.dumpResponseParameters(responseParameters, pLevel + 1);
                    break;
                }
                case 24: {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping parameters of ENVDATADESC " + shortName + "..."));
                    if (requestParameter != null) {
                        requestParameters = requestParameter.getParameters();
                        this.dumpRequestParameters(requestParameters, pLevel + 1);
                        break;
                    }
                    if (responseParameter == null) break;
                    responseParameters = responseParameter.getParameters();
                    this.dumpResponseParameters(responseParameters, pLevel + 1);
                    break;
                }
                case 15: {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping parameters of FIELD " + shortName + "..."));
                    if (requestParameter != null) {
                        requestParameters = requestParameter.getParameters();
                        this.dumpRequestParameters(requestParameters, pLevel + 1);
                        break;
                    }
                    if (responseParameter == null) break;
                    responseParameters = responseParameter.getParameters();
                    this.dumpResponseParameters(responseParameters, pLevel + 1);
                    break;
                }
                case 26: {
                    this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping of parameters of type LENGTHKEY is not yet implemented!"));
                    break;
                }
                case 16: {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping parameters of MULTIPLEXER " + shortName + "..."));
                    if (requestParameter != null) {
                        requestParameters = requestParameter.getParameters();
                        this.dumpRequestParameters(requestParameters, pLevel + 1);
                        break;
                    }
                    if (responseParameter == null) break;
                    responseParameters = responseParameter.getParameters();
                    this.dumpResponseParameters(responseParameters, pLevel + 1);
                    break;
                }
                case 23: {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping parameters of TABLE " + shortName + "..."));
                    if (requestParameter != null) {
                        try {
                            requestParameters = requestParameter.getParameters();
                            this.dumpRequestParameters(requestParameters, pLevel + 1);
                        }
                        catch (MCDException mcde) {
                            if (!VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) || mcde.getError().getCode() != 53315 || mcde.getError().getVendorCode() != 12330) break;
                            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "No MCDParameters collection available for parameter of type " + McdEnumDecoder.decodeMcdDataType(23) + " due to missing default value for referenced parameter of type " + McdEnumDecoder.decodeMcdDataType(25) + "."));
                        }
                        break;
                    }
                    if (responseParameter == null) break;
                    responseParameters = responseParameter.getParameters();
                    this.dumpResponseParameters(responseParameters, pLevel + 1);
                    break;
                }
                case 17: {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping parameters of STRUCTURE " + shortName + "..."));
                    if (requestParameter != null) {
                        try {
                            requestParameters = requestParameter.getParameters();
                            this.dumpRequestParameters(requestParameters, pLevel + 1);
                        }
                        catch (MCDException mcde) {
                            if (!VendorSpecific.getServerVendor().equals(DServerVendor.SIEMENS) || mcde.getError().getCode() != 53315 || mcde.getError().getVendorCode() != 12358) break;
                            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "No MCDParameters collection available for parameter of type " + McdEnumDecoder.decodeMcdDataType(17) + " (TABLE-STRUCT) due to unset value for referenced parameter of type " + McdEnumDecoder.decodeMcdDataType(25) + "."));
                        }
                        break;
                    }
                    if (responseParameter == null) break;
                    responseParameters = responseParameter.getParameters();
                    this.dumpResponseParameters(responseParameters, pLevel + 1);
                    break;
                }
                case 18: 
                case 25: {
                    ti = this.vendorSpecific.getLongNameIDOfTextTableParameterValue(pParameter, valueAsString);
                    if (ti != null && ti.trim().length() > 0) {
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "TI                  : " + ti));
                    }
                    if (this.logger.getLogLevel() < 6 || (textTableElements = this.vendorSpecific.getTextTableElementsOfParameter(pParameter)) == null) break;
                    this.dumpTextTableElements(textTableElements, pLevel);
                    break;
                }
            }
        }
    }

    public void dumpRequest(MCDRequest pRequest, int pLevel, boolean pIsJobRequest) throws MCDException {
        MCDValue requestPduValue = null;
        int dataType = -1;
        String requestPDU = null;
        MCDRequestParameters requestParameters = null;
        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping request"));
        if (pRequest == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Request is null!"));
        } else {
            if (!pIsJobRequest) {
                try {
                    requestPduValue = pRequest.getPDU();
                }
                catch (Exception e) {
                    this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Error getting PDU of request!"));
                    this.logger.logThrowable(e);
                }
                if (requestPduValue == null) {
                    this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Request PDU is null!"));
                } else {
                    dataType = requestPduValue.getDataType();
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Data type of request PDU: " + McdEnumDecoder.decodeMcdDataType(dataType)));
                    if (dataType != 255) {
                        requestPDU = this.vendorSpecific.pduValue2String(requestPduValue);
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Request PDU             : " + requestPDU));
                    }
                }
            }
            requestParameters = pRequest.getRequestParameters();
            this.dumpRequestParameters(requestParameters, pLevel + 1);
        }
    }

    public void dumpRequestParameters(MCDRequestParameters pRequestParameters, int pLevel) throws MCDException {
        long numberOfRequestParameters = 0L;
        MCDRequestParameter requestParameter = null;
        if (pRequestParameters == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "RequestParameters is null!"));
        } else {
            numberOfRequestParameters = pRequestParameters.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of request parameters: " + numberOfRequestParameters));
            for (long i = 0L; i < numberOfRequestParameters; ++i) {
                requestParameter = pRequestParameters.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping request parameter with index " + i));
                this.dumpParameter((MCDParameter)requestParameter, pLevel + 1);
            }
        }
    }

    public void dumpResponse(MCDResponse pResponse, int pLevel, boolean pIsJobResponse) throws MCDException {
        MCDAccessKey accessKeyOfLocation = null;
        int responseState = -1;
        String shortName = null;
        String longName = null;
        String description = null;
        MCDError error = null;
        MCDValue responseMessageValue = null;
        int dataType = -1;
        String responseMessage = null;
        MCDResponseParameters responseParameters = null;
        if (pResponse == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Response is null!"));
        } else {
            accessKeyOfLocation = pResponse.getAccessKeyOfLocation();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "AccessKey of location        : " + accessKeyOfLocation.getString()));
            responseState = pResponse.getState();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Response state               : " + McdEnumDecoder.decodeMcdResponseState(responseState)));
            shortName = pResponse.getShortName();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "ShortName                    : " + shortName));
            longName = pResponse.getLongName();
            if (longName.trim().length() > 0) {
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "LongName                     : " + longName));
            }
            if ((description = pResponse.getDescription()).trim().length() > 0) {
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Description                  : " + description));
            }
            if (pResponse.hasError()) {
                this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Response has error."));
                error = pResponse.getError();
                this.logger.logMcdError(error);
            } else {
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Response has no error."));
            }
            if (!pIsJobResponse) {
                try {
                    responseMessageValue = pResponse.getResponseMessage();
                    if (responseMessageValue == null) {
                        this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Response message is null!"));
                    } else {
                        dataType = responseMessageValue.getDataType();
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Data type of response message: " + McdEnumDecoder.decodeMcdDataType(dataType)));
                        if (dataType != 255) {
                            responseMessage = this.vendorSpecific.pduValue2String(responseMessageValue);
                            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Response message             : " + responseMessage));
                        }
                    }
                }
                catch (MCDException mcde) {
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Error getting response message!"));
                    this.logger.logThrowable(mcde);
                }
            }
            responseParameters = pResponse.getResponseParameters();
            this.dumpResponseParameters(responseParameters, pLevel + 1);
        }
    }

    public void dumpResponseParameters(MCDResponseParameters pResponseParameters, int pLevel) throws MCDException {
        long numberOfResponseParameters = 0L;
        MCDResponseParameter responseParameter = null;
        if (pResponseParameters == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "ResponseParameters is null!"));
        } else {
            TreeSet<String> responseParameterNamesSet;
            numberOfResponseParameters = pResponseParameters.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of response parameters: " + numberOfResponseParameters));
            String[] responseParameterNames = null;
            if (VendorSpecific.getServerVendor().equals(DServerVendor.SOFTING)) {
                responseParameterNames = new String[(int)numberOfResponseParameters];
                for (int i = 0; i < responseParameterNames.length; ++i) {
                    responseParameterNames[i] = pResponseParameters.getItemByIndex((long)i).getShortName();
                }
            } else {
                responseParameterNames = pResponseParameters.getNames();
            }
            if ((long)(responseParameterNamesSet = new TreeSet<String>(Arrays.asList(responseParameterNames))).size() == numberOfResponseParameters && numberOfResponseParameters > 1L) {
                Iterator responseParameterNamesIterator = responseParameterNamesSet.iterator();
                String responseParameterName = null;
                for (long i = 0L; responseParameterNamesIterator.hasNext() || i < pResponseParameters.getCount(); ++i) {
                    try {
                        responseParameterName = (String)responseParameterNamesIterator.next();
                        responseParameter = pResponseParameters.getItemByName(responseParameterName);
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping response parameter with (lexical) index " + i));
                        this.dumpParameter((MCDParameter)responseParameter, pLevel + 1);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.logThrowable(e);
                    }
                }
            } else {
                for (long i = 0L; i < numberOfResponseParameters; ++i) {
                    responseParameter = pResponseParameters.getItemByIndex(i);
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping response parameter with index " + i));
                    this.dumpParameter((MCDParameter)responseParameter, pLevel + 1);
                }
            }
        }
    }

    public void dumpResponses(MCDResponses pResponses, int pLevel, boolean pIsJobResponse) throws MCDException {
        long numberOfResponses = -1L;
        MCDResponse response = null;
        if (pResponses == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Responses is null!"));
        } else {
            numberOfResponses = pResponses.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of responses: " + numberOfResponses));
            for (long i = 0L; i < numberOfResponses; ++i) {
                response = pResponses.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping response with index " + i));
                this.dumpResponse(response, pLevel + 1, pIsJobResponse);
            }
        }
    }

    public void dumpResult(MCDResult pResult, int pLevel, boolean pIsJobResult) throws MCDException {
        MCDError error = null;
        MCDResultState resultState = null;
        int resultType = -1;
        String serviceShortName = null;
        MCDResponses responses = null;
        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping result..."));
        if (pResult.hasError()) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Result has error."));
            error = pResult.getError();
            this.logger.logMcdError(error);
        } else {
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Result has no error."));
        }
        try {
            resultState = pResult.getResultState();
            this.dumpResultState(resultState, pLevel + 1);
        }
        catch (MCDException mcde) {
            if (VendorSpecific.getServerVendor().equals(DServerVendor.DSA) && mcde.getError().getCode() == 53315 && mcde.getError().getVendorCode() == 6149) {
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Result state of jobs may be unavailable inside jobs with some versions of PRODIS.MCD."));
            }
            if (VendorSpecific.getServerVendor().equals(DServerVendor.SOFTING) && mcde.getError().getCode() == 53337) {
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Result state of jobs may be unavailable inside jobs with newer versions of Softing DTS."));
            }
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Error getting result state!"));
            this.logger.logThrowable(mcde);
        }
        resultType = pResult.getType();
        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Type of result: " + McdEnumDecoder.decodeMcdResultType(resultType)));
        serviceShortName = pResult.getServiceShortName();
        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "ShortName of service (or job): " + serviceShortName));
        responses = pResult.getResponses();
        this.dumpResponses(responses, pLevel + 1, pIsJobResult);
    }

    public void dumpResultState(MCDResultState pResultState, int pLevel) throws MCDException {
        int executionState = -1;
        int logicalLinkState = -1;
        int logicalLinkLockState = -1;
        int repetitionState = -1;
        int numberOfResults = -1;
        if (pResultState == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "ResultState is null!"));
        } else {
            executionState = pResultState.getExecutionState();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "MCDResultState.MCDExecutionState      : " + McdEnumDecoder.decodeMcdExecutionState(executionState)));
            logicalLinkState = pResultState.getLogicalLinkState();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "MCDResultState.MCDLogicalLinkState    : " + McdEnumDecoder.decodeMcdLogicalLinkState(logicalLinkState)));
            logicalLinkLockState = pResultState.getLogicalLinkLockState();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "MCDResultState.MCDLogicalLinkLockState: " + McdEnumDecoder.decodeMcdLockState(logicalLinkLockState)));
            repetitionState = pResultState.getRepetitionState();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "MCDResultState.MCDRepetitionState     : " + McdEnumDecoder.decodeMcdRepetitionState(repetitionState)));
            numberOfResults = pResultState.getNoOfResults();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of results                     : " + numberOfResults));
        }
    }

    public void dumpTextTableElements(MCDTextTableElements pMcdTextTableElements, int pLevel) throws MCDException {
        long numberOfTextTableElements = -1L;
        MCDTextTableElement textTableElement = null;
        if (pMcdTextTableElements == null) {
            this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "TextTableElements is null!"));
        } else {
            numberOfTextTableElements = pMcdTextTableElements.getCount();
            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Number of TEXTTABLE elements: " + numberOfTextTableElements));
            for (long i = 0L; i < numberOfTextTableElements; ++i) {
                textTableElement = pMcdTextTableElements.getItemByIndex(i);
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Dumping TEXTTABLE element with index " + i));
                this.dumpTextTableElement(textTableElement, pLevel + 1);
            }
        }
    }

    public void dumpTextTableElement(MCDTextTableElement pMcdTextTableElement, int pLevel) throws MCDException {
        block13: {
            MCDInterval interval = null;
            int lowerLimitIntervalType = -1;
            int upperLimitIntervalType = -1;
            MCDValue value = null;
            int dataType = -1;
            String valueAsString = null;
            String vt = null;
            String ti = null;
            if (pMcdTextTableElement == null) {
                this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "TextTableElement is null!"));
            } else {
                try {
                    interval = pMcdTextTableElement.getInterval();
                    lowerLimitIntervalType = interval.getLowerLimitIntervalType();
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Limit type of lowerLimit : " + McdEnumDecoder.decodeMcdLimitType(lowerLimitIntervalType)));
                    upperLimitIntervalType = interval.getUpperLimitIntervalType();
                    this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "Limit type of upperLimit : " + McdEnumDecoder.decodeMcdLimitType(upperLimitIntervalType)));
                    value = interval.getLowerLimit();
                    if (value == null) {
                        this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "lowerLimit is null!"));
                    } else {
                        dataType = value.getDataType();
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "MCDDataType of lowerLimit: " + McdEnumDecoder.decodeMcdDataType(dataType)));
                        if (dataType != 255) {
                            valueAsString = value.getValueAsString();
                            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "lowerLimit as string     : " + valueAsString));
                        }
                    }
                    value = interval.getUpperLimit();
                    if (value == null) {
                        this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "upperLimit is null!"));
                    } else {
                        dataType = value.getDataType();
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "MCDDataType of upperLimit: " + McdEnumDecoder.decodeMcdDataType(dataType)));
                        if (dataType != 255) {
                            valueAsString = value.getValueAsString();
                            this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "upperLimit as string     : " + valueAsString));
                        }
                    }
                }
                catch (MCDException mcde) {
                    this.logger.warn(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "MCDInterval of MCDTextTableElement is not available... probably a COMPU-DEFAULT-VALUE"));
                }
                vt = pMcdTextTableElement.getLongName();
                this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "VT                       : " + vt));
                try {
                    ti = pMcdTextTableElement.getLongNameID();
                    if (ti.trim().length() > 0) {
                        this.logger.debug(McdObjectDumperImpl.getIndentedLogMessage(pLevel, "TI                       : " + ti));
                    }
                }
                catch (MCDException mcde) {
                    if (this.logger.getLogLevel() < 6 && mcde.getError().getCode() == 57362) break block13;
                    this.logger.debug("Error getting TI of text table element with VT \"" + vt + "\"!");
                    this.logger.logThrowable(mcde);
                }
            }
        }
    }

    public void setVendorSpecific(VendorSpecific pVendorSpecific) {
        this.vendorSpecific = pVendorSpecific;
    }

    protected static String getIndentedLogMessage(int pLevel, String pLogMessage) {
        StringBuffer logMessage = null;
        logMessage = new StringBuffer();
        for (int i = 0; i < pLevel; ++i) {
            logMessage.append(LOG_MESSAGE_INDENTATION);
        }
        logMessage.append(pLogMessage);
        return logMessage.toString();
    }
}

