/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary3.util.parsers.xmlmsg.impl;

import asam.d.MCDDbLocation;
import asam.d.MCDException;
import com.audi.mcd.joblibrary3.util.Conversions;
import com.audi.mcd.joblibrary3.util.logging.Logger;
import com.audi.mcd.joblibrary3.util.parsers.swcnt.SwCnt;
import com.audi.mcd.joblibrary3.util.parsers.swcnt.impl.SwCntParserImpl;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.ParameterDataApplication;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.ParameterDataBootloader;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.TargetEcu;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.XmlMsg;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.XmlMsgParser;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.impl.ParameterDataApplicationGen1Impl;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.impl.ParameterDataApplicationGen2Impl;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.impl.ParameterDataBootloaderImpl;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.impl.TargetEcuImpl;
import com.audi.mcd.joblibrary3.util.parsers.xmlmsg.impl.XmlMsgImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlMsgParserImpl
implements XmlMsgParser {
    private Logger logger = null;
    private MCDDbLocation dbLocation = null;
    private String fileName = null;
    private String versionOfResponse = null;
    private boolean isGeneration2Response = false;
    private short diagnosticAddress = 0;
    private boolean isElementParameterDataParsed = false;
    private TargetEcu currentTargetEcu = null;
    private StringBuffer currentParameterDataAsString = null;
    private ParameterDataApplication currentApplicationDataSet = null;
    private ParameterDataBootloader currentBootloaderDataSet = null;
    private XmlMsg xmlMsg = null;

    public XmlMsgParserImpl(Logger pLogger, MCDDbLocation pDbLocation, short pDiagnosticAddress) {
        this.logger = pLogger;
        this.dbLocation = pDbLocation;
        this.diagnosticAddress = pDiagnosticAddress;
    }

    public final boolean readXML(String pFileName) throws FileNotFoundException {
        this.logger.debug("Reading XML file \"" + pFileName + "\"...");
        FileReader fileReader = null;
        InputSource inputSource = null;
        XMLReader xmlReader = null;
        this.fileName = pFileName;
        try {
            fileReader = new FileReader(this.fileName);
        }
        catch (FileNotFoundException fnfe) {
            this.logger.debug("Error opening file: " + this.fileName);
            this.logger.logThrowable(fnfe);
            throw fnfe;
        }
        inputSource = new InputSource(fileReader);
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException se) {
            this.logger.warn("Error creating XML reader using defaults! (" + se.getLocalizedMessage() + ")");
            this.logger.debug("Trying default XML reader...");
            try {
                xmlReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            }
            catch (SAXException se2) {
                this.logger.fatal("Error creating default XML reader!");
                this.logger.logThrowable(se2);
                return false;
            }
        }
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        this.xmlMsg = new XmlMsgImpl();
        try {
            xmlReader.parse(inputSource);
        }
        catch (Exception e) {
            this.logger.debug("Error parsing " + this.fileName + "!");
            this.logger.logThrowable(e);
            return false;
        }
        this.logger.debug(this.fileName + " read successfully.");
        return true;
    }

    public final XmlMsg getXmlMsg() {
        return this.xmlMsg;
    }

    public final void error(SAXParseException pException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[XMLMSG] Exception (error) while parsing " + this.fileName);
        stringBuffer.append(" at line " + pException.getLineNumber());
        stringBuffer.append(" / column " + pException.getColumnNumber());
        this.logger.debug(stringBuffer.toString());
        this.logger.debug("[XMLMSG] " + pException.getLocalizedMessage());
    }

    public final void fatalError(SAXParseException pException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[XMLMSG] Exception (fatal error) while parsing " + this.fileName);
        stringBuffer.append(" at line " + pException.getLineNumber());
        stringBuffer.append(" / column " + pException.getColumnNumber());
        this.logger.debug(stringBuffer.toString());
        this.logger.debug("[XMLMSG] " + pException.getLocalizedMessage());
    }

    public final void warning(SAXParseException pException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[XMLMSG] Exception (warning) while parsing " + this.fileName);
        stringBuffer.append(" at line " + pException.getLineNumber());
        stringBuffer.append(" / column " + pException.getColumnNumber());
        this.logger.debug(stringBuffer.toString());
        this.logger.debug("[XMLMSG] " + pException.getLocalizedMessage());
    }

    public final void characters(char[] pCh, int pStart, int pLength) {
        if (this.isElementParameterDataParsed && pLength > 0) {
            this.currentParameterDataAsString.append(pCh, pStart, pLength);
        }
    }

    public final void endDocument() {
        this.logger.debug("[XMLMSG] EndDocument");
    }

    public final void endElement(String pNamespaceURI, String pLocalName, String pName) {
        if (pLocalName.equals("PARAMETER_DATA")) {
            if (this.isElementParameterDataParsed) {
                String content = this.currentParameterDataAsString.toString();
                content = content.trim();
                content = content.replaceAll("0x", "");
                content = content.replaceAll("[^A-Fa-f0-9]", "");
                byte[] bytes = Conversions.hexString2ByteArray(content);
                this.logger.debug("[XMLMSG] - data bytes        : " + bytes.length + " (0x" + Integer.toHexString(bytes.length).toUpperCase() + ")");
                this.currentApplicationDataSet.setData(bytes);
                this.currentTargetEcu.addApplicationDataSet(this.currentApplicationDataSet);
                this.currentApplicationDataSet = null;
                this.isElementParameterDataParsed = false;
            } else if (this.currentApplicationDataSet != null) {
                this.currentTargetEcu.addApplicationDataSet(this.currentApplicationDataSet);
                this.currentApplicationDataSet = null;
            } else if (this.currentBootloaderDataSet != null) {
                this.currentTargetEcu.addBootLoaderDataSet(this.currentBootloaderDataSet);
                this.currentBootloaderDataSet = null;
            }
        }
        this.logger.debug("[XMLMSG] EndElement: " + pLocalName);
    }

    public final void endPrefixMapping(String pPrefix) {
    }

    public final void ignorableWhitespace(char[] pCh, int pStart, int pLength) {
    }

    public final void processingInstruction(String pTarget, String pData) {
    }

    public final void setDocumentLocator(Locator pLocator) {
    }

    public final void skippedEntity(String pName) {
    }

    public final void startDocument() {
        this.logger.debug("[XMLMSG] StartDocument");
    }

    public final void startElement(String pNamespaceURI, String pLocalName, String pName, Attributes pAttributes) {
        this.logger.debug("[XMLMSG] StartElement: " + pLocalName);
        if (pLocalName.equals("MESSAGE")) {
            this.startElementMessage(pAttributes);
        } else if (pLocalName.equals("RESPONSE")) {
            if (!this.startElementResponse(pAttributes)) {
                throw new RuntimeException("Error parsing RESPONSE!");
            }
        } else if (pLocalName.equals("PARAMETER_DATA") && !this.startElementParameterData(pAttributes)) {
            throw new RuntimeException("Error parsing PARAMETER_DATA!");
        }
    }

    private final boolean startElementMessage(Attributes pAttributes) {
        String dtd = null;
        String version = null;
        dtd = pAttributes.getValue("DTD");
        if (!dtd.equalsIgnoreCase("XMLMSG")) {
            this.logger.error("DTD of MESSAGE is not \"XMLMSG\"!");
            return false;
        }
        version = pAttributes.getValue("VERSION");
        if (!version.equalsIgnoreCase("1.1")) {
            this.logger.error("VERSION of MESSAGE is not \"1.1\"!");
            return false;
        }
        return true;
    }

    private final boolean startElementResponse(Attributes pAttributes) {
        String name = null;
        String dtd = null;
        name = pAttributes.getValue("NAME");
        if (!name.equalsIgnoreCase("GetParametrizeData")) {
            this.logger.error("NAME of RESPONSE is not \"GetParametrizeData\"!");
            return false;
        }
        dtd = pAttributes.getValue("DTD");
        if (!dtd.equalsIgnoreCase("RepairHints")) {
            this.logger.error("DTD of RESPONSE is not \"RepairHints\"!");
            return false;
        }
        this.versionOfResponse = pAttributes.getValue("VERSION");
        if (!this.versionOfResponse.matches("[0-9]{0,9}([.][0-9]{0,9}){3}")) {
            this.logger.error("VERSION of RESPONSE does not match \"[0-9]{0,9}([.][0-9]{0,9}){3}\"!");
            return false;
        }
        this.isGeneration2Response = this.isResponseVersionWithGeneration2(this.versionOfResponse);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean startElementParameterData(Attributes pAttributes) {
        File currentFilePath;
        String currentSessionName;
        String currentFileName;
        XmlMsg.DataSetDownloadType currentDataSetDownloadType;
        long currentStartAddress;
        String currentStartAddressAsString;
        block51: {
            block52: {
                block53: {
                    String currentDiagnosticAddressAsString = null;
                    short currentDiagnosticAddress = 0;
                    currentStartAddressAsString = null;
                    currentStartAddress = 0L;
                    String currentPrIdxAsString = null;
                    byte[] currentPrIdx = null;
                    String currentZdcName = null;
                    String currentZdcVersion = null;
                    String currentLoginAsString = null;
                    long currentLogin = 0L;
                    String currentLoginIndAsString = null;
                    String currentDataSetDownloadTypeAsString = null;
                    currentDataSetDownloadType = null;
                    currentFileName = null;
                    currentSessionName = null;
                    currentFilePath = null;
                    currentDiagnosticAddressAsString = pAttributes.getValue("DIAGNOSTIC_ADDRESS");
                    this.logger.debug("[XMLMSG] - DIAGNOSTIC_ADDRESS (string): " + currentDiagnosticAddressAsString);
                    if (!currentDiagnosticAddressAsString.matches("0x([0-9]|[A-F]){2,3}")) {
                        this.logger.error("ERROR: DIAGNOSTIC_ADDRESS does not match expected pattern \"0x([0-9]|[A-F]){2,3}\"!");
                        return false;
                    }
                    currentDiagnosticAddressAsString = currentDiagnosticAddressAsString.substring(2);
                    currentDiagnosticAddress = Short.parseShort(currentDiagnosticAddressAsString, 16);
                    this.logger.debug("[XMLMSG] - DIAGNOSTIC_ADDRESS (value ): 0x" + Integer.toHexString(currentDiagnosticAddress).toUpperCase());
                    if (this.diagnosticAddress != 0 && this.diagnosticAddress != currentDiagnosticAddress) {
                        this.logger.debug("Skipping PARAMETER_DATA for DIAGNOSTIC_ADDRESS " + currentDiagnosticAddressAsString + ".");
                        this.isElementParameterDataParsed = false;
                        return true;
                    }
                    currentPrIdxAsString = pAttributes.getValue("PR_IDX");
                    this.logger.debug("[XMLMSG] - PR_IDX (string)   : " + currentPrIdxAsString);
                    if (!currentPrIdxAsString.matches("[0-9A-F]{1,24}|.{0}")) {
                        this.logger.error("ERROR: PR_IDX does NOT match the regular expression \"[0-9A-F]{1,24}|.{0}\"!");
                        return false;
                    }
                    if (currentPrIdxAsString.length() % 2 != 0) {
                        this.logger.debug("Prepending additional '0' to PR_IDX of odd length (" + currentPrIdxAsString.length() + ").");
                        currentPrIdxAsString = "0" + currentPrIdxAsString;
                    }
                    currentPrIdx = Conversions.hexString2ByteArray(currentPrIdxAsString);
                    this.logger.debug("[XMLMSG] - PR_IDX (byte[])   : " + Conversions.byteArray2String(currentPrIdx));
                    currentZdcName = pAttributes.getValue("ZDC_NAME");
                    this.logger.debug("[XMLMSG] - ZDC_NAME          : " + currentZdcName);
                    if (currentZdcName.length() > 11) {
                        this.logger.error("[XMLMSG] - The length of the attribute \"ZDC_NAME\" (" + currentZdcName.length() + ") exceeds the maximum length!");
                        return false;
                    }
                    if (currentZdcName.length() < 9) {
                        this.logger.error("[XMLMSG] - The length of the attribute \"ZDC_NAME\" (" + currentZdcName.length() + ") is lower than the minimum length (excl. trailing spaces)!");
                        return false;
                    }
                    if (currentZdcName.length() < 11) {
                        this.logger.warn("[XMLMSG] - The length of the attribute \"ZDC_NAME\" (" + currentZdcName.length() + ") does NOT match the expected length!");
                        this.logger.info("[XMLMSG] - Padding attribute \"ZDC_NAME\" with value \"" + currentZdcName + "\" with trailing spaces...");
                        while (currentZdcName.length() < 11) {
                            currentZdcName = currentZdcName + " ";
                        }
                        this.logger.info("[XMLMSG] - ... new value incl. padding is: \"" + currentZdcName + "\".");
                    }
                    currentZdcVersion = pAttributes.getValue("ZDC_VERSION");
                    this.logger.debug("[XMLMSG] - ZDC_VERSION       : " + currentZdcVersion);
                    currentLoginAsString = pAttributes.getValue("LOGIN");
                    this.logger.debug("[XMLMSG] - LOGIN (string)    : " + currentLoginAsString);
                    if (currentLoginAsString.length() == 0) {
                        currentLogin = 0L;
                    } else {
                        if (!currentLoginAsString.matches("[0-9]{1,10}")) {
                            this.logger.error("ERROR: LOGIN does NOT match the regular expression \"[0-9]{1,10}\"!");
                            return false;
                        }
                        currentLogin = Long.parseLong(currentLoginAsString);
                        if (currentLogin > 0xFFFFFFFFL) {
                            this.logger.error("ERROR: LOGIN exceeds the maximum value 4294967295!");
                            return false;
                        }
                    }
                    this.logger.debug("[XMLMSG] - LOGIN (value)     : " + currentLogin);
                    currentLoginIndAsString = pAttributes.getValue("LOGIN_IND");
                    this.logger.debug("[XMLMSG] - LOGIN_IND         : " + currentLoginIndAsString);
                    if (currentLoginIndAsString.length() > 0) {
                        this.logger.error("ERROR: LOGIN_IND is NOT empty!");
                        return false;
                    }
                    this.currentTargetEcu = this.xmlMsg.getTargetEcuByDiagnosticAddress(currentDiagnosticAddress);
                    if (this.currentTargetEcu == null) {
                        this.currentTargetEcu = new TargetEcuImpl(currentDiagnosticAddress, currentPrIdx, currentZdcName, currentZdcVersion, currentLogin);
                        this.xmlMsg.addTargetEcu(this.currentTargetEcu);
                    }
                    if (!this.isGeneration2Response) break block52;
                    currentDataSetDownloadTypeAsString = pAttributes.getValue("DSD_TYPE");
                    this.logger.debug("[XMLMSG] - DSD_TYPE (string) : " + currentDataSetDownloadTypeAsString);
                    if (!currentDataSetDownloadTypeAsString.matches("(1|2)")) {
                        this.logger.error("ERROR: DSD_TYPE does not match expected pattern \"(1|2)\"!");
                        return false;
                    }
                    currentDataSetDownloadType = XmlMsg.DataSetDownloadType.valueOf(Byte.parseByte(currentDataSetDownloadTypeAsString));
                    this.logger.debug("[XMLMSG] - DSD_TYPE (value)  : " + currentDataSetDownloadType);
                    if (currentDataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_2 && currentPrIdxAsString.length() > 0) {
                        this.logger.error("ERROR: Attribute PR_IDX must be empty for DSD_TYPE=2!");
                        return false;
                    }
                    currentFileName = pAttributes.getValue("FILENAME");
                    currentSessionName = pAttributes.getValue("SESSIONNAME");
                    this.logger.debug("[XMLMSG] - FILENAME          : " + currentFileName);
                    this.logger.debug("[XMLMSG] - SESSIONNAME       : " + currentSessionName);
                    if (currentFileName == null) {
                        this.logger.error("ERROR: Attribute FILENAME must be present if attribute DSD_TYPE is present!");
                        return false;
                    }
                    if (currentSessionName == null) {
                        this.logger.error("ERROR: Attribute SESSIONNAME must be present if attribute DSD_TYPE is present!");
                        return false;
                    }
                    if (currentDataSetDownloadType != XmlMsg.DataSetDownloadType.GENERATION_1) break block53;
                    if (currentFileName.length() > 0) {
                        this.logger.error("ERROR: FILENAME must be empty for DSD_TYPE=1!");
                        return false;
                    }
                    if (currentSessionName.length() > 0) {
                        this.logger.error("ERROR: SESSIONNAME must be empty for DSD_TYPE=1!");
                        return false;
                    }
                    break block51;
                }
                if (currentDataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_2) {
                    if (currentFileName.substring(currentFileName.lastIndexOf(File.separator) + 1).matches("DA_[0-9A-F]{3}_72[0-9A-F]{2}_[0-9A-Z]{3}_[0-9A-Z]{4}_[0-9A-Z]{2}([0-9A-Z]{10})?(_[0-9A-Z]{1,80})?[.]xml")) {
                        if (currentSessionName.length() > 0) {
                            this.logger.error("ERROR: SESSIONNAME must be empty for application data sets!");
                            return false;
                        }
                        break block51;
                    } else {
                        if (!currentFileName.substring(currentFileName.lastIndexOf(File.separator) + 1).matches("DB_[0-9A-F]{3}_71[0-9A-F]{2}_[0-9A-Z]{3}_[0-9A-Z]{4}_[0-9A-Z]{2}([0-9A-Z]{10})?(_[0-9A-Z]{1,80})?[.](odx|frf)")) {
                            this.logger.error("ERROR: FILENAME \"" + currentFileName + "\" does not match either of the expected patterns \"" + "DA_[0-9A-F]{3}_72[0-9A-F]{2}_[0-9A-Z]{3}_[0-9A-Z]{4}_[0-9A-Z]{2}([0-9A-Z]{10})?(_[0-9A-Z]{1,80})?[.]xml" + "\" or \"" + "DB_[0-9A-F]{3}_71[0-9A-F]{2}_[0-9A-Z]{3}_[0-9A-Z]{4}_[0-9A-Z]{2}([0-9A-Z]{10})?(_[0-9A-Z]{1,80})?[.](odx|frf)" + "\"!");
                            return false;
                        }
                        if (!currentSessionName.matches("SES(D)?_[0-9A-F]{3}_71[0-9A-F]{2}_[0-9A-Z]{3}_[0-9A-Z]{4}_[0-9A-Z]{2}([0-9A-Z]{10})?(_[0-9A-Z]{1,80})?")) {
                            this.logger.error("ERROR: SESSIONNAME \"" + currentSessionName + "\" does NOT match the regular expression \"" + "SES(D)?_[0-9A-F]{3}_71[0-9A-F]{2}_[0-9A-Z]{3}_[0-9A-Z]{4}_[0-9A-Z]{2}([0-9A-Z]{10})?(_[0-9A-Z]{1,80})?" + "\"!");
                            return false;
                        }
                    }
                }
                break block51;
            }
            currentDataSetDownloadType = XmlMsg.DataSetDownloadType.GENERATION_1;
            if (pAttributes.getValue("DSD_TYPE") != null) {
                this.logger.error("ERROR: Attribute DSD_TYPE is NOT expected with VERSION \"" + this.versionOfResponse + "\" of " + "RESPONSE" + "!");
                return false;
            }
            if (pAttributes.getValue("FILENAME") != null) {
                this.logger.error("ERROR: Attribute FILENAME is NOT expected with VERSION \"" + this.versionOfResponse + "\" of " + "RESPONSE" + "!");
                return false;
            }
            if (pAttributes.getValue("SESSIONNAME") != null) {
                this.logger.error("ERROR: Attribute SESSIONNAME is NOT expected with VERSION \"" + this.versionOfResponse + "\" of " + "RESPONSE" + "!");
                return false;
            }
        }
        currentStartAddressAsString = pAttributes.getValue("START_ADDRESS");
        this.logger.debug("[XMLMSG] - START_ADDRESS (string): " + currentStartAddressAsString);
        if (currentDataSetDownloadType == XmlMsg.DataSetDownloadType.GENERATION_1) {
            if (this.currentTargetEcu.getDataSetDownloadType() != null && this.currentTargetEcu.getDataSetDownloadType() != XmlMsg.DataSetDownloadType.GENERATION_1) {
                this.logger.error("ERROR: Mixing of different DSD_TYPEs for the same DIAGNOSTIC_ADDRESS is not allowed!");
                return false;
            }
            if (!currentStartAddressAsString.matches("(0x)?[0-9A-Fa-f]{1,8}")) {
                this.logger.error("ERROR: START_ADDRESS does not match expected pattern \"(0x)?[0-9A-Fa-f]{1,8}\"!");
                return false;
            }
            if (currentStartAddressAsString.startsWith("0x")) {
                currentStartAddressAsString = currentStartAddressAsString.substring(2);
            }
            currentStartAddress = Long.parseLong(currentStartAddressAsString, 16);
            this.logger.debug("[XMLMSG] - START_ADDRESS (value ): 0x" + Long.toHexString(currentStartAddress).toUpperCase());
            this.currentTargetEcu.setDataSetDownloadType(XmlMsg.DataSetDownloadType.GENERATION_1);
            this.currentApplicationDataSet = new ParameterDataApplicationGen1Impl(this.logger, currentStartAddress);
            this.isElementParameterDataParsed = true;
            this.currentParameterDataAsString = new StringBuffer();
            return true;
        }
        if (currentDataSetDownloadType != XmlMsg.DataSetDownloadType.GENERATION_2) return true;
        if (this.currentTargetEcu.getDataSetDownloadType() != null && this.currentTargetEcu.getDataSetDownloadType() != XmlMsg.DataSetDownloadType.GENERATION_2) {
            this.logger.error("ERROR: Mixing of different DSD_TYPEs for the same DIAGNOSTIC_ADDRESS is not allowed!");
            return false;
        }
        if (currentStartAddressAsString.length() != 0) {
            this.logger.error("ERROR: The attribute START_ADDRESS must be empty with DSD_TYPE=2!");
            return false;
        }
        this.currentTargetEcu.setDataSetDownloadType(XmlMsg.DataSetDownloadType.GENERATION_2);
        if (currentFileName == null) {
            this.logger.error("ERROR: The attribute FILENAME should NOT be null at this point!");
            return false;
        }
        if (currentFileName.substring(currentFileName.lastIndexOf(File.separator) + 1).matches("DA_[0-9A-F]{3}_72[0-9A-F]{2}_[0-9A-Z]{3}_[0-9A-Z]{4}_[0-9A-Z]{2}([0-9A-Z]{10})?(_[0-9A-Z]{1,80})?[.]xml")) {
            SwCntParserImpl swCntParser = new SwCntParserImpl(this.logger);
            String swCntFileName = null;
            currentFilePath = new File(currentFileName);
            if (!currentFilePath.isAbsolute()) {
                swCntFileName = this.fileName.substring(0, this.fileName.lastIndexOf(File.separator) + 1);
                swCntFileName = swCntFileName + currentFileName;
            } else {
                swCntFileName = currentFileName;
            }
            File swCntFile = new File(swCntFileName);
            if (!swCntFile.exists()) {
                this.logger.error("ERROR: The referenced file \"" + swCntFileName + "\" does NOT exist!");
                return false;
            }
            if (!swCntFile.isFile()) {
                this.logger.error("ERROR: The referenced file \"" + swCntFile + "\" is NOT a regular file!");
                return false;
            }
            if (!swCntFile.canRead()) {
                this.logger.error("ERROR: The referenced file \"" + swCntFile + "\" is NOT readable!");
                return false;
            }
            if (!swCntParser.readXML(swCntFileName)) {
                this.logger.error("ERROR: Error parsing referenced file \"" + swCntFileName + "\"!");
                return false;
            }
            SwCnt swCnt = swCntParser.getSwCnt();
            this.currentApplicationDataSet = new ParameterDataApplicationGen2Impl(this.logger, swCnt.getStartAddress(), swCnt.getData());
            return true;
        }
        String flashFileName = null;
        currentFilePath = new File(currentFileName);
        if (!currentFilePath.isAbsolute()) {
            flashFileName = this.fileName.substring(0, this.fileName.lastIndexOf(File.separator) + 1);
            flashFileName = flashFileName + currentFileName;
        } else {
            flashFileName = currentFileName;
        }
        File flashFile = new File(flashFileName);
        if (!flashFile.exists()) {
            this.logger.warn("WARNING (can be ignored in production environments): The referenced flash file \"" + flashFileName + "\" does NOT exist!");
        } else {
            if (!flashFile.isFile()) {
                this.logger.error("ERROR: The referenced flash file \"" + flashFileName + "\" is NOT a regular file!");
                return false;
            }
            if (!flashFile.canRead()) {
                this.logger.error("ERROR: The referenced flash file \"" + flashFileName + "\" is NOT readable!");
                return false;
            }
        }
        this.currentBootloaderDataSet = new ParameterDataBootloaderImpl(this.logger, this.dbLocation, flashFileName);
        try {
            this.currentBootloaderDataSet.setSessionName(currentSessionName);
            return true;
        }
        catch (MCDException mcde) {
            this.logger.error("ERROR: Error setting flash session \"" + currentSessionName + "\"!");
            this.logger.logThrowable(mcde);
            return true;
        }
    }

    public final void startPrefixMapping(String pPrefix, String pUri) {
    }

    private boolean isResponseVersionWithGeneration2(String pVersionOfResponse) {
        String[] versions = null;
        int majorVersionOfResponse = 0;
        int minorVersionOfResponse = 0;
        int revisionOfResponse = 0;
        int patchVersionOfResponse = 0;
        int minimumMajorVersionOfResponse = 0;
        int minimumMinorVersionOfResponse = 0;
        int minimumRevisionOfResponse = 0;
        int minimumPatchVersionOfResponse = 0;
        this.logger.debug("VERSION of RESPONSE: " + pVersionOfResponse);
        versions = this.versionOfResponse.split("[.]");
        majorVersionOfResponse = Integer.parseInt(versions[0]);
        minorVersionOfResponse = Integer.parseInt(versions[1]);
        revisionOfResponse = Integer.parseInt(versions[2]);
        patchVersionOfResponse = Integer.parseInt(versions[3]);
        this.logger.debug("Minimum VERSION of generation 2 RESPONSEs: 1.4.6.0");
        versions = "1.4.6.0".split("[.]");
        minimumMajorVersionOfResponse = Integer.parseInt(versions[0]);
        minimumMinorVersionOfResponse = Integer.parseInt(versions[1]);
        minimumRevisionOfResponse = Integer.parseInt(versions[2]);
        minimumPatchVersionOfResponse = Integer.parseInt(versions[3]);
        if (majorVersionOfResponse > minimumMajorVersionOfResponse || majorVersionOfResponse == minimumMajorVersionOfResponse && minorVersionOfResponse > minimumMinorVersionOfResponse || majorVersionOfResponse == minimumMajorVersionOfResponse && minorVersionOfResponse == minimumMinorVersionOfResponse && revisionOfResponse >= minimumRevisionOfResponse || majorVersionOfResponse == minimumMajorVersionOfResponse && minorVersionOfResponse == minimumMinorVersionOfResponse && revisionOfResponse == minimumRevisionOfResponse && patchVersionOfResponse >= minimumPatchVersionOfResponse) {
            this.logger.debug("The RESPONSE supports generation 2 attributes.");
            return true;
        }
        this.logger.debug("The RESPONSE does NOT support generation 2 attributes.");
        return false;
    }
}

