/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.jobs.in2soft.impl;

import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDException;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.jobs.impl.AbstractSingleEcuJobImpl;
import com.audi.mcd.joblibrary.jobs.in2soft.AbstractIn2SoftSingleEcuJob;
import java.lang.reflect.Field;

public abstract class AbstractIn2SoftSingleEcuJobImpl
extends AbstractSingleEcuJobImpl
implements AbstractIn2SoftSingleEcuJob {
    protected Class classOfJobStatusCodes = null;
    protected Class classOfJobStatusInformations = null;
    protected int jobStatus = 0;
    protected MCDError mcdError = null;

    public AbstractIn2SoftSingleEcuJobImpl(String pRevision, Class pClassOfJobStatusCodes, Class pClassOfJobStatusInformations) {
        super(pRevision);
        this.classOfJobStatusCodes = pClassOfJobStatusCodes;
        this.classOfJobStatusInformations = pClassOfJobStatusInformations;
    }

    protected int addOutputParameters(MCDResponse pResponse) {
        block10: {
            block9: {
                MCDResponseParameters responseParameters = null;
                MCDResponseParameter responseParameter = null;
                MCDValue value = null;
                String jobStatusInformation = null;
                try {
                    responseParameters = pResponse.getResponseParameters();
                    responseParameter = responseParameters.getItemByName("OPA_JobStatuInfor");
                    jobStatusInformation = this.getJobStatusInformation();
                    value = this.jobApi.createValue(14);
                    value.setValueAsString(jobStatusInformation);
                    responseParameter.setValue(value);
                    try {
                        responseParameter = responseParameters.getItemByName("OPA_JobStatuCode");
                        value = this.jobApi.createValue(11);
                        value.setUint32((long)this.jobStatus);
                        responseParameter.setValue(value);
                        if (this.logger.getLogLevel() >= 5) {
                            this.logger.debug("Set Code " + this.jobStatus + " = " + jobStatusInformation);
                        }
                    }
                    catch (Exception e) {
                        if (this.logger.getLogLevel() >= 5) {
                            this.logger.debug("Set Status Code failed!");
                            this.logger.logThrowable(e);
                        }
                    }
                }
                catch (Exception e) {
                    if (this.logger.getLogLevel() < 5) break block9;
                    this.logger.debug("Set Status Information failed!");
                    this.logger.logThrowable(e);
                }
            }
            try {
                if (this.mcdError != null) {
                    ((MCDResult)((MCDResponses)pResponse.getParent()).getParent()).setError(this.mcdError);
                }
            }
            catch (Exception e) {
                if (this.logger.getLogLevel() < 5) break block10;
                this.logger.debug("Set Error Object failed!");
                this.logger.logThrowable(e);
            }
        }
        return 0;
    }

    public String getJobStatusInformation() {
        Field[] jobStatusCodes = null;
        Field[] jobStatusInformations = null;
        try {
            jobStatusCodes = this.classOfJobStatusCodes.getDeclaredFields();
        }
        catch (SecurityException se) {
            this.logger.error("Error getting job status codes from class \"" + this.classOfJobStatusCodes.getName());
            this.logger.logThrowable(se);
            return null;
        }
        try {
            jobStatusInformations = this.classOfJobStatusInformations.getDeclaredFields();
        }
        catch (SecurityException se) {
            this.logger.error("Error getting job status informations from class \"" + this.classOfJobStatusInformations.getName());
            this.logger.logThrowable(se);
            return null;
        }
        for (int i = 0; i < jobStatusCodes.length; ++i) {
            try {
                if (jobStatusCodes[i].getInt(jobStatusCodes[i]) != this.jobStatus) continue;
                for (int j = 0; j < jobStatusInformations.length; ++j) {
                    if (!jobStatusInformations[j].getName().equals(jobStatusCodes[i].getName())) continue;
                    return (String)jobStatusInformations[j].get(null);
                }
                continue;
            }
            catch (IllegalAccessException iae) {
                this.logger.error("Error translating job status code to job status information!");
                this.logger.logThrowable(iae);
                return null;
            }
        }
        this.logger.error("No matching job status information found for job status code: " + this.jobStatus);
        return null;
    }

    protected void printMCDResult(MCDResult result) {
        if (this.logger.getLogLevel() < 5) {
            return;
        }
        try {
            this.logger.debug("Response PDU: " + this.vendorSpecific.pduValue2String(result.getResponses().getItemByIndex(0L).getResponseMessage()));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (result.hasError()) {
                this.logger.debug("Result has error!");
                this.logger.logMcdError(result.getError());
            }
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
        }
        try {
            for (long i = 0L; i < result.getResponses().getCount(); ++i) {
                this.logger.debug("SHORT-NAME of response[" + i + "]: " + result.getResponses().getItemByIndex(i).getShortName());
            }
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
        }
    }

    protected void printRequest(MCDDiagComPrimitive service) {
        try {
            this.logger.debug("Request  PDU: " + this.vendorSpecific.pduValue2String(service.getRequest().getPDU()));
        }
        catch (MCDException mcde) {
            this.logger.debug("No RequestPDU available!");
            this.logger.logThrowable(mcde);
        }
    }

    protected int readInputParameters(MCDRequestParameters pRequestParameters) {
        return 0;
    }
}

