/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDbDiagService;
import asam.d.MCDDbLocation;
import asam.d.MCDDbParameter;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDParameterizationException;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDTextTableElement;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;
import com.audi.mcd.joblibrary.util.Conversions;
import com.audi.mcd.joblibrary.util.dserver.DServerVendor;
import com.audi.mcd.joblibrary.util.dserver.VendorSpecific;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

public class MCD3_StandECUIdent
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20140130";
    private static final String NULL = "NULL";
    protected static boolean fastMode = false;
    private static final String[][] IDENT_TABLE = new String[][]{{"Param_VWSparePartNumbe", "VW Spare Part Number", " ", Boolean.toString(true)}, {"Param_VWAppliSoftwVersiNumbe", "VW Application Software Version Number", " ", Boolean.toString(true)}, {"Param_VWECUHardwNumbe", "VW ECU Hardware Number", " ", Boolean.toString(true)}, {"Param_VWECUHardwVersiNumbe", "VW ECU Hardware Version Number", " ", Boolean.toString(true)}, {"Param_ASAMODXFileIdent", "ASAM ODX File Identifier", " ", Boolean.toString(true)}, {"Param_ASAMODXFileVersi", "ASAM ODX File Version", " ", Boolean.toString(true)}, {"Param_VWDataSetNumbeOrECUDataContaNumbe", "VW Data Set Number Or ECU Data Container Number", " ", Boolean.toString(true)}, {"Param_VWDataSetVersiNumbe", "VW Data Set Version Number", " ", Boolean.toString(true)}, {"Param_VWWorksSysteName", "VW Workshop System Name", " ", Boolean.toString(true)}, {"Param_ECUProgrInfor", "ECU Programming Information", " ", Boolean.toString(false)}, {"Param_VWSysteNameOrEnginType", "VW System Name Or Engine Type", " ", Boolean.toString(true)}, {"Param_VehicIdentNumbe", "Vehicle Identification Number", " ", Boolean.toString(true)}, {"Param_VWFAZITIdentStrin", "VW FAZIT Identification String", "", Boolean.toString(true)}, {"Param_ECUSeriaNumbe", "ECU Serial Number", " ", Boolean.toString(true)}, {"Param_EnginCodeLette", "Engine Code Letters", " ", Boolean.toString(true)}};
    private static final String[][][] IDENT_TABLE_SUBPARAMS = new String[][][]{{{"ECU Data Programming Information"}, {"Param_DataConsi", "Param_DataConsi"}, {"Param_DataProgr", "Param_DataProgr"}, {"Param_DataModifState", "Param_DataModifState"}, {"Param_FailuDurinLastDataSetDownl", "Param_FailuDurinLastDataSetDownl"}}, {{"ECU Programming Information"}, {"Param_ProgrConsi", "Param_ProgrConsi"}, {"Param_Progr", "Param_Progr"}}};
    protected Set availableIdentificationEcuIdentification = null;
    protected Set availableIdentificationVariantCoding = null;
    static /* synthetic */ Class class$asam$d$MCDDbLocation;

    public MCD3_StandECUIdent() {
        super(REVISION, OutputParameterValue.StandECUIdent.JobStatusCode.class, OutputParameterValue.StandECUIdent.JobStatusInformation.class);
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        try {
            this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
            this.availableIdentificationEcuIdentification = this.getAvailableIdentifications("DiagnServi_ReadDataByIdentECUIdent");
            if (fastMode) {
                this.logger.debug("fastMode enabled.");
                if (this.availableIdentificationEcuIdentification.contains("ECU Serial Number")) {
                    this.availableIdentificationEcuIdentification.remove("ECU Serial Number");
                }
                if (this.availableIdentificationEcuIdentification.contains("VW FAZIT Identification String")) {
                    this.availableIdentificationEcuIdentification.remove("VW FAZIT Identification String");
                }
                if (this.availableIdentificationEcuIdentification.contains("VW System Name Or Engine Type")) {
                    this.availableIdentificationEcuIdentification.remove("VW System Name Or Engine Type");
                }
            }
            this.availableIdentificationVariantCoding = this.getAvailableIdentifications("DiagnServi_ReadDataByIdentVariaCodin");
            MCDDiagComPrimitive service22 = pLogicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentECUIdent");
            MCDRequestParameter tableKeyParam = service22.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
            MCDValue id = tableKeyParam.createValue();
            this.logger.debug("Main 1 ");
            MCDResult responseReadData = null;
            Object[] resTemp = this.addResponse(pSingleEcuJob, this.logicalLink.getDbObject().getDbLocation());
            MCDResult jobResult = (MCDResult)resTemp[0];
            MCDResponse jobResponse = (MCDResponse)resTemp[1];
            MCDResponseParameter STRUC_ECUIdentInfoSTRUC = jobResponse.getResponseParameters().getItemByName("OPA_JobResul");
            this.logger.debug("Main 2");
            MCDResponseParameters parameters = STRUC_ECUIdentInfoSTRUC.getParameters();
            for (int j = 0; j < IDENT_TABLE.length; ++j) {
                MCDValue result;
                boolean currentIdAvailable;
                MCDResponseParameter jobResultParam;
                block40: {
                    jobResultParam = null;
                    currentIdAvailable = false;
                    boolean currIDFailed = false;
                    result = null;
                    try {
                        jobResultParam = parameters.getItemByName(IDENT_TABLE[j][0]);
                    }
                    catch (Exception e) {
                        this.logger.debug(IDENT_TABLE[j][0] + " not found! " + "Param_EnginCodeLette" + " only on BV Engine Control Modul valid(NO ERROR)!");
                        continue;
                    }
                    try {
                        this.logger.debug("loop 1 : " + IDENT_TABLE[j][1]);
                        pJobApi.setProgress(pLogicalLink, (MCDDiagComPrimitive)pSingleEcuJob, (short)((j + 1) * 100 / IDENT_TABLE.length));
                        if (!this.availableIdentificationEcuIdentification.contains(IDENT_TABLE[j][1])) {
                            this.logger.warn("The identification \"" + IDENT_TABLE[j][1] + "\" is not supported by this ECU!");
                            currentIdAvailable = false;
                            currIDFailed = true;
                        } else {
                            currentIdAvailable = true;
                            try {
                                id.setValueAsString(IDENT_TABLE[j][1]);
                                tableKeyParam.setValue(id);
                            }
                            catch (MCDException mcde) {
                                if (VendorSpecific.getServerVendor() == DServerVendor.SOFTING && mcde.getError().getCode() == 49172 || VendorSpecific.getServerVendor() == DServerVendor.DSA && mcde.getError().getCode() == 58649 && mcde.getError().getVendorCode() == 26898) {
                                    this.logger.warn("The identification \"" + IDENT_TABLE[j][1] + "\" is not supported by this ECU!");
                                    if (this.logger.getLogLevel() >= 6) {
                                        this.logger.logThrowable(mcde);
                                    }
                                } else {
                                    this.logger.logThrowable(mcde);
                                }
                                currIDFailed = true;
                            }
                        }
                        if (currIDFailed) break block40;
                        this.logger.debug("loop 2");
                        this.printRequest(service22);
                        responseReadData = service22.executeSync();
                        this.logger.debug("ResponsePDU: " + this.vendorSpecific.pduValue2String(responseReadData.getResponses().getItemByIndex(0L).getResponseMessage()));
                        try {
                            responseReadData.getResponses().getItemByName("Resp_ReadDataByIdentECUIdent");
                        }
                        catch (Exception e) {
                            this.printMCDResult(responseReadData);
                            currIDFailed = true;
                        }
                        if (currIDFailed || responseReadData.hasError()) {
                            if (responseReadData.hasError()) {
                                this.logger.logMcdError(responseReadData.getError());
                            }
                            break block40;
                        }
                        this.logger.debug("loop 3");
                        MCDResponse serviceResponse = responseReadData.getResponses().getItemByName("Resp_ReadDataByIdentECUIdent");
                        byte[] responsePDU = serviceResponse.getResponseMessage().getBytefield();
                        if (responsePDU == null || responsePDU.length <= 0) break block40;
                        if (responsePDU[0] == 127) {
                            result = responsePDU.length > 2 ? this.getAsciiResult("NRC: " + Integer.parseInt(String.valueOf(responsePDU[2]), 16)) : this.getAsciiResult("Negative Response received. Could not determine NRC!");
                            break block40;
                        }
                        try {
                            String temp = "";
                            String delimiter = IDENT_TABLE[j][2];
                            boolean found = false;
                            MCDResponseParameter serviceParam = null;
                            if (this.logger.getLogLevel() >= 6) {
                                this.mcdObjectDumper.dumpResponse(serviceResponse, 1, false);
                            }
                            MCDResponseParameters serviceParams = serviceResponse.getResponseParameters().getItemByName("Param_DataRecor").getParameters();
                            long numberOfResponseParameters = serviceParams.getCount();
                            this.logger.debug("loop 4 :" + numberOfResponseParameters);
                            if (numberOfResponseParameters == 1L && (serviceParam = serviceParams.getItemByIndex(0L)).getType() == 17) {
                                serviceParams = serviceParam.getParameters();
                            }
                            for (long i = 0L; i < numberOfResponseParameters; ++i) {
                                serviceParam = serviceParams.getItemByIndex(i);
                                this.logger.debug("loop 5 :" + serviceParam.getValue().getDataType());
                                MCDValue currentValue = serviceParam.getValue();
                                try {
                                    temp = currentValue.getDataType() == 3 ? temp + Conversions.byteArray2String(currentValue.getBytefield()) : temp + this.checkMCDValue(currentValue);
                                    found = true;
                                    if (i + 1L >= serviceParams.getCount() || currentValue.getDataType() != 1 && currentValue.getDataType() != 14) continue;
                                    temp = temp + delimiter;
                                    continue;
                                }
                                catch (MCDException mcde) {
                                    this.logger.logThrowable(mcde);
                                    continue;
                                }
                                catch (Exception e) {
                                    this.logger.logThrowable(e);
                                }
                            }
                            if (found) {
                                result = this.getAsciiResult(temp);
                                this.logger.debug("loop 6 :" + result.getDataType());
                            }
                        }
                        catch (MCDParameterizationException mcdpe) {}
                    }
                    catch (Exception e) {
                        result = null;
                        this.logger.logThrowable(e);
                    }
                }
                if (result == null) {
                    if (currentIdAvailable && Boolean.valueOf(IDENT_TABLE[j][3]).booleanValue()) {
                        this.jobStatus = 9;
                    }
                    jobResultParam.setValue(this.getAsciiResult(NULL));
                } else {
                    jobResultParam.setValue(result);
                }
                this.logger.debug("loop 9 :" + (jobResultParam.getValue() != null));
                try {
                    this.logger.debug("loop 10 :" + jobResultParam.getValue().getValueAsString());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.setPRNumbeCombi(service22, tableKeyParam, parameters);
            this.setF1E0Data(service22, tableKeyParam, parameters, IDENT_TABLE_SUBPARAMS[0]);
            this.setF1E0Data(service22, tableKeyParam, parameters, IDENT_TABLE_SUBPARAMS[1]);
            MCDResponseParameter jobResultParam = parameters.getItemByName("Param_ECUProgrInfor");
            MCDValue ecuProgrammingInformation = jobResultParam.getValue();
            String programmability = parameters.getItemByName("Param_Progr").getValue().getValueAsString();
            String programConsistency = parameters.getItemByName("Param_ProgrConsi").getValue().getValueAsString();
            if (programmability.equals(NULL) && programConsistency.equals(NULL)) {
                ecuProgrammingInformation.setValueAsString(NULL);
            } else {
                ecuProgrammingInformation.setValueAsString(programmability + " " + programConsistency);
            }
            jobResultParam.setValue(ecuProgrammingInformation);
            this.setCodingValue(pLogicalLink, STRUC_ECUIdentInfoSTRUC);
            this.setTesterCodingInformation(pLogicalLink, STRUC_ECUIdentInfoSTRUC, false);
            this.setStatus(jobResponse, this.jobStatus);
            this.dumpAndSendFinalResult(jobResult);
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
        }
        this.logger.finalize(this.getCurrentJobRuntimeAsString());
        this.logger.exit();
    }

    private void setF1E0Data(MCDDiagComPrimitive service, MCDRequestParameter tableKeyParam, MCDResponseParameters resultParameters, String[][] interfaces) {
        MCDResponseParameter resultParam = null;
        MCDResponseParameters serviceParameters = null;
        String tableID = interfaces[0][0];
        if (!this.availableIdentificationEcuIdentification.contains(tableID)) {
            this.logger.warn("The identification \"" + tableID + "\" is not supported by this ECU!");
            try {
                for (int i = 1; i < interfaces.length; ++i) {
                    resultParameters.getItemByName(interfaces[i][1]).setValue(this.getAsciiResult(NULL));
                }
            }
            catch (Exception e2) {}
        } else {
            try {
                MCDValue id = tableKeyParam.createValue();
                this.logger.debug("setF1E0Data Start " + tableID);
                id.setValueAsString(tableID);
                tableKeyParam.setValue(id);
                MCDResult result = service.executeSync();
                if (result.hasError()) {
                    this.logger.debug("setF1E0Data -> Result has error");
                    this.logger.logMcdError(result.getError());
                    try {
                        for (int i = 1; i < interfaces.length; ++i) {
                            resultParameters.getItemByName(interfaces[i][1]).setValue(this.getAsciiResult(NULL));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("Error setting default values for parameters of \"" + tableID + "\"!");
                        this.logger.logThrowable(e);
                    }
                    return;
                }
                try {
                    MCDResponse resultResponse = result.getResponses().getItemByName("Resp_ReadDataByIdentECUIdent");
                    serviceParameters = resultResponse.getResponseParameters().getItemByName("Param_DataRecor").getParameters();
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                    this.logger.debug("setF1E0Data -> Response not found");
                    try {
                        for (int i = 1; i < interfaces.length; ++i) {
                            resultParameters.getItemByName(interfaces[i][1]).setValue(this.getAsciiResult(NULL));
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return;
                }
                for (int i = 1; i < interfaces.length; ++i) {
                    try {
                        String[] inOutput = interfaces[i];
                        resultParam = resultParameters.getItemByName(inOutput[1]);
                        this.logger.debug("setF1E0Data loop " + inOutput[0]);
                        resultParam.setValue(serviceParameters.getItemByName(inOutput[0]).getValue());
                        continue;
                    }
                    catch (Exception e) {
                        if (resultParam != null) {
                            try {
                                resultParam.setValue(this.getAsciiResult(NULL));
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        this.logger.logThrowable(e);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof MCDException && (VendorSpecific.getServerVendor() == DServerVendor.SOFTING && ((MCDException)((Object)e)).getError().getCode() == 49172 || VendorSpecific.getServerVendor() == DServerVendor.DSA && ((MCDException)((Object)e)).getError().getCode() == 58649 && ((MCDException)((Object)e)).getError().getVendorCode() == 26898)) {
                    this.logger.warn("The identification \"" + tableID + "\" is not supported by this ECU!");
                    if (this.logger.getLogLevel() >= 6) {
                        this.logger.logThrowable(e);
                    }
                } else {
                    this.logger.logThrowable(e);
                }
                this.logger.debug("setF1E0Data -> Set KEY or Get and Set Value Failed");
                try {
                    for (int i = 1; i < interfaces.length; ++i) {
                        resultParameters.getItemByName(interfaces[i][1]).setValue(this.getAsciiResult(NULL));
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPRNumbeCombi(MCDDiagComPrimitive service, MCDRequestParameter tableKeyParam, MCDResponseParameters resultParameters) {
        MCDValue value2222;
        MCDResponseParameter resultParam = null;
        boolean failure = true;
        try {
            MCDValue id;
            try {
                this.logger.debug("SetPRNumbeCombi 1");
                resultParam = resultParameters.getItemByName("Param_VehicEquipCodeAndPRNumbeCombi");
                id = tableKeyParam.createValue();
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
                if (resultParam == null) return;
                if (!failure) return;
                try {
                    MCDValue value2222 = resultParam.getValue();
                    value2222.setBytefield(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
                    resultParam.setValue(value2222);
                    return;
                }
                catch (MCDException mcde) {
                    this.logger.debug("Failed to set DefaultValue to Param_VehicEquipCodeAndPRNumbeCombi");
                }
                return;
            }
            if (!this.availableIdentificationEcuIdentification.contains("Vehicle Equipment Code And PR Number Combination")) {
                this.logger.warn("The identification \"Vehicle Equipment Code And PR Number Combination\" is not supported by this ECU!");
                failure = true;
            } else {
                MCDResponse resultResponse;
                MCDResult result;
                block27: {
                    this.logger.debug("SetPRNumbeCombi 2");
                    id.setValueAsString("Vehicle Equipment Code And PR Number Combination");
                    tableKeyParam.setValue(id);
                    result = service.executeSync();
                    if (!result.hasError()) break block27;
                    this.logger.debug("SetPRNumbeCombi -> Result has error");
                    this.logger.logMcdError(result.getError());
                    if (resultParam == null) return;
                    if (!failure) return;
                    try {
                        MCDValue value2222 = resultParam.getValue();
                        value2222.setBytefield(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
                        resultParam.setValue(value2222);
                        return;
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Failed to set DefaultValue to Param_VehicEquipCodeAndPRNumbeCombi");
                    }
                    return;
                }
                try {
                    resultResponse = result.getResponses().getItemByName("Resp_ReadDataByIdentECUIdent");
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                    this.logger.debug("SetPRNumbeCombi -> Response not found");
                    if (resultParam == null) return;
                    if (!failure) return;
                    try {
                        MCDValue value2222 = resultParam.getValue();
                        value2222.setBytefield(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
                        resultParam.setValue(value2222);
                        return;
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Failed to set DefaultValue to Param_VehicEquipCodeAndPRNumbeCombi");
                    }
                    return;
                }
                try {
                    this.logger.debug("SetPRNumbeCombi 3");
                    value2222 = resultResponse.getResponseParameters().getItemByName("Param_DataRecor").getParameters().getItemByIndex(0L).getValue();
                    resultParam.setValue(value2222);
                    failure = false;
                }
                catch (Exception e) {
                    if (e instanceof MCDException && (VendorSpecific.getServerVendor() == DServerVendor.SOFTING && ((MCDException)((Object)e)).getError().getCode() == 49172 || VendorSpecific.getServerVendor() == DServerVendor.DSA && ((MCDException)((Object)e)).getError().getCode() == 58649 && ((MCDException)((Object)e)).getError().getVendorCode() == 26898)) {
                        this.logger.warn("The identification \"Vehicle Equipment Code And PR Number Combination\" is not supported by this ECU!");
                        if (this.logger.getLogLevel() >= 6) {
                            this.logger.logThrowable(e);
                        }
                    } else {
                        this.logger.logThrowable(e);
                    }
                    this.logger.debug("SetPRNumbeCombi -> Set KEY or Get and Set Value Failed");
                }
            }
            if (resultParam == null) return;
            if (!failure) return;
        }
        catch (Throwable throwable) {
            if (resultParam == null) throw throwable;
            if (!failure) throw throwable;
            try {
                MCDValue value2222 = resultParam.getValue();
                value2222.setBytefield(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
                resultParam.setValue(value2222);
                throw throwable;
            }
            catch (MCDException mcde) {
                this.logger.debug("Failed to set DefaultValue to Param_VehicEquipCodeAndPRNumbeCombi");
            }
            throw throwable;
        }
        try {
            value2222 = resultParam.getValue();
            value2222.setBytefield(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
            resultParam.setValue(value2222);
            return;
        }
        catch (MCDException mcde) {
            this.logger.debug("Failed to set DefaultValue to Param_VehicEquipCodeAndPRNumbeCombi");
            return;
        }
    }

    private void setCodingValue(MCDLogicalLink mCDLogicalLink, MCDResponseParameter STRUC_ECUIdentInfoSTRUC) {
        MCDResponseParameter param = null;
        MCDValue value = null;
        if (!this.availableIdentificationVariantCoding.contains("VW Coding Value")) {
            this.logger.warn("The identification \"VW Coding Value\" is not supported by this ECU!");
            try {
                param = STRUC_ECUIdentInfoSTRUC.getParameters().getItemByName("Param_VWCodinValue");
                value = this.jobApi.createValue(3);
                value.setBytefield(new byte[]{0, 0, 0});
                param.setValue(value);
            }
            catch (Exception e) {
                this.logger.debug("Failed to set Param_VWCodinValue DefaultValue!");
                this.logger.logThrowable(e);
            }
        } else {
            try {
                this.logger.debug("Main 3");
                this.readOutServiceData("DiagnServi_ReadDataByIdentVariaCodin", "VW Coding Value", "Resp_ReadDataByIdentVariaCodin", new Object[]{"Param_VWCodinValueRAW", "Param_RawData"}, mCDLogicalLink, STRUC_ECUIdentInfoSTRUC.getParameters().getItemByName("Param_VWCodinValue"), false);
            }
            catch (Exception e) {
                this.jobStatus = 9;
                try {
                    param = STRUC_ECUIdentInfoSTRUC.getParameters().getItemByName("Param_VWCodinValue");
                    value = this.jobApi.createValue(3);
                    value.setBytefield(new byte[]{0, 0, 0});
                    param.setValue(value);
                }
                catch (Exception e2) {
                    this.logger.debug("Failed to set Param_VWCodinValue DefaultValue!");
                    this.logger.logThrowable(e2);
                }
                this.logger.logThrowable(e);
            }
            if (VendorSpecific.getServerVendor() == DServerVendor.SOFTING) {
                this.logger.debug("[Softing-MCD] Checking for VW Coding Value violating MIN/MAX limits of MIN-MAX-LENGTH-TYPE parameter.");
                try {
                    MCDResponseParameter param_vwCodingValue = null;
                    MCDDbParameter dbParam_vwCodingValue = null;
                    MCDValue mcdVwCodingValue = null;
                    byte[] vwCodingValueTmp = null;
                    int vwCodingValueMinLength = 0;
                    int vwCodingValueMaxLength = 0;
                    byte[] vwCodingValueNew = null;
                    param_vwCodingValue = STRUC_ECUIdentInfoSTRUC.getParameters().getItemByName("Param_VWCodinValue");
                    dbParam_vwCodingValue = param_vwCodingValue.getDbObject();
                    vwCodingValueMinLength = dbParam_vwCodingValue.getMinLength();
                    vwCodingValueMaxLength = dbParam_vwCodingValue.getMaxLength();
                    mcdVwCodingValue = param_vwCodingValue.getValue();
                    vwCodingValueTmp = mcdVwCodingValue.getBytefield();
                    if (vwCodingValueTmp.length < vwCodingValueMinLength) {
                        int i;
                        this.logger.debug("VW Coding Value violates MIN limit of MIN-MAX-LENGTH-TYPE parameter!");
                        vwCodingValueNew = new byte[vwCodingValueMinLength];
                        for (i = 0; i < vwCodingValueTmp.length; ++i) {
                            vwCodingValueNew[i] = vwCodingValueTmp[i];
                        }
                        for (i = vwCodingValueTmp.length; i < vwCodingValueNew.length; ++i) {
                            vwCodingValueNew[i] = 0;
                        }
                        mcdVwCodingValue.setBytefield(vwCodingValueNew);
                        param_vwCodingValue.setValue(mcdVwCodingValue);
                        this.jobStatus = 9;
                    } else if (vwCodingValueTmp.length > vwCodingValueMaxLength) {
                        this.logger.debug("VW Coding Value violates MAX limit of MIN-MAX-LENGTH-TYPE parameter!");
                        vwCodingValueNew = new byte[vwCodingValueMaxLength];
                        System.arraycopy(vwCodingValueTmp, 0, vwCodingValueNew, 0, vwCodingValueMaxLength);
                        mcdVwCodingValue.setBytefield(vwCodingValueNew);
                        param_vwCodingValue.setValue(mcdVwCodingValue);
                        this.jobStatus = 9;
                    }
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error replacing erroneous VW Coding Value!");
                }
            }
        }
    }

    private void setTesterCodingInformation(MCDLogicalLink mCDLogicalLink, MCDResponseParameter STRUC_ECUIdentInfoSTRUC, boolean changeJobState) {
        block15: {
            MCDResponseParameters responseParameters = null;
            String[] responseParameterNames = null;
            MCDResponseParameter param_VWTesterCodingInformation = null;
            long lengthOfCodingValue = 0L;
            MCDValue value_vwTesterCodingInformation = null;
            if (!this.availableIdentificationEcuIdentification.contains("VW Tester Coding Information")) {
                this.logger.warn("The identification \"VW Tester Coding Information\" is not supported by this ECU!");
                try {
                    responseParameters = STRUC_ECUIdentInfoSTRUC.getParameters();
                    if (VendorSpecific.getServerVendor().equals(DServerVendor.SOFTING)) {
                        responseParameterNames = new String[(int)responseParameters.getCount()];
                        for (int i = 0; i < responseParameterNames.length; ++i) {
                            responseParameterNames[i] = responseParameters.getItemByIndex((long)i).getShortName();
                        }
                    } else {
                        responseParameterNames = STRUC_ECUIdentInfoSTRUC.getParameters().getNames();
                    }
                    if (Arrays.asList(responseParameterNames).contains("Param_VWTesteCodinInfor")) {
                        this.logger.warn("The job result *unexpectedly* contains the \"Param_VWTesteCodinInfor\"... setting value according to length of VW coding value.");
                        param_VWTesterCodingInformation = STRUC_ECUIdentInfoSTRUC.getParameters().getItemByName("Param_VWTesteCodinInfor");
                        value_vwTesterCodingInformation = this.jobApi.createValue(param_VWTesterCodingInformation.getType());
                        lengthOfCodingValue = STRUC_ECUIdentInfoSTRUC.getParameters().getItemByName("Param_VWCodinValue").getValue().getBytefield().length;
                        value_vwTesterCodingInformation.setValueAsString(Long.toString(lengthOfCodingValue));
                        param_VWTesterCodingInformation.setValue(value_vwTesterCodingInformation);
                    }
                }
                catch (MCDException mcde) {
                    this.logger.error("Caught exception while checking VW Tester Coding Information!");
                    this.logger.logThrowable(mcde);
                }
            } else {
                try {
                    block16: {
                        if (!Arrays.asList(STRUC_ECUIdentInfoSTRUC.getParameters().getNames()).contains("Param_VWTesteCodinInfor")) break block15;
                        try {
                            param_VWTesterCodingInformation = STRUC_ECUIdentInfoSTRUC.getParameters().getItemByName("Param_VWTesteCodinInfor");
                        }
                        catch (MCDException mcde) {
                            MCDError error = mcde.getError();
                            if (error.getCode() == 49184) break block16;
                            throw mcde;
                        }
                    }
                    this.logger.debug("Main 2");
                    this.readOutServiceData("DiagnServi_ReadDataByIdentECUIdent", "VW Tester Coding Information", "Resp_ReadDataByIdentECUIdent", new Object[]{"Param_LengtOfCodinValue"}, mCDLogicalLink, param_VWTesterCodingInformation, true);
                }
                catch (Exception e) {
                    if (changeJobState) {
                        this.jobStatus = 9;
                    }
                    try {
                        STRUC_ECUIdentInfoSTRUC.getParameters().getItemByName("Param_VWTesteCodinInfor").setValue(this.getAsciiResult(NULL));
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (e instanceof MCDException && (VendorSpecific.getServerVendor() == DServerVendor.SOFTING && ((MCDException)((Object)e)).getError().getCode() == 49172 || VendorSpecific.getServerVendor() == DServerVendor.DSA && ((MCDException)((Object)e)).getError().getCode() == 58649 && ((MCDException)((Object)e)).getError().getVendorCode() == 26898)) break block15;
                    this.logger.logThrowable(e);
                }
            }
        }
    }

    private void readOutServiceData(String serviceName, String key, String responseName, Object[] responsePath, MCDLogicalLink mCDLogicalLink, MCDResponseParameter targetParam, boolean convertToAscii) throws MCDException {
        MCDDiagComPrimitive service = null;
        MCDRequestParameter tableKeyParam = null;
        MCDValue value = null;
        this.logger.debug("Read " + key + " 1");
        if (!this.availableIdentificationEcuIdentification.contains(key) && !this.availableIdentificationVariantCoding.contains(key)) {
            this.logger.warn("The identification \"" + key + "\" is not supported by this ECU!");
            targetParam.setValue(this.getAsciiResult(NULL));
        } else {
            service = mCDLogicalLink.createDiagComPrimitiveByName(serviceName);
            tableKeyParam = service.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
            if (tableKeyParam.getDbObject().isConstant()) {
                value = tableKeyParam.getValue();
            } else {
                try {
                    value = tableKeyParam.createValue();
                    value.setValueAsString(key);
                    tableKeyParam.setValue(value);
                }
                catch (MCDException mcde) {
                    if (VendorSpecific.getServerVendor() == DServerVendor.SOFTING && mcde.getError().getCode() == 49172 || VendorSpecific.getServerVendor() == DServerVendor.DSA && mcde.getError().getCode() == 58649 && mcde.getError().getVendorCode() == 26898) {
                        this.logger.warn("The identification \"" + key + "\" is not supported by this ECU!");
                        if (this.logger.getLogLevel() >= 6) {
                            this.logger.logThrowable(mcde);
                        }
                    } else {
                        this.logger.logThrowable(mcde);
                    }
                    throw mcde;
                }
            }
            this.logger.debug("Read " + key + " 2 inputDataType: " + value.getDataType() + " name: " + tableKeyParam.getShortName());
            this.logger.debug("Read " + key + " 2b ID:" + value.getValueAsString());
            this.printRequest(service);
            MCDResult result = service.executeSync();
            this.logger.debug("Read " + key + " 2");
            try {
                if (result.hasError()) {
                    if (serviceName.equals("DiagnServi_ReadDataByIdentVariaCodin")) {
                        MCDResponses responses = result.getResponses();
                        if (responses == null) {
                            throw new IllegalArgumentException();
                        }
                        long numberOfResponses = responses.getCount();
                        if (numberOfResponses == 0L) {
                            throw new IllegalArgumentException();
                        }
                        MCDResponse response = responses.getItemByIndex(0L);
                        if (response == null) {
                            throw new IllegalArgumentException();
                        }
                        MCDResponseParameters responseParameters = response.getResponseParameters();
                        if (responseParameters == null) {
                            throw new IllegalArgumentException();
                        }
                        MCDResponseParameter dataRecord = responseParameters.getItemByName("Param_DataRecor");
                        if (dataRecord == null) {
                            throw new IllegalArgumentException();
                        }
                        responseParameters = dataRecord.getParameters();
                        if (responseParameters == null) {
                            throw new IllegalArgumentException();
                        }
                        MCDResponseParameter vwCodinValueRaw = responseParameters.getItemByName("Param_VWCodinValueRAW");
                        if (vwCodinValueRaw == null) {
                            throw new IllegalArgumentException();
                        }
                        responseParameters = vwCodinValueRaw.getParameters();
                        if (responseParameters == null) {
                            throw new IllegalArgumentException();
                        }
                        MCDResponseParameter rawData = responseParameters.getItemByName("Param_RawData");
                        if (rawData == null) {
                            throw new IllegalArgumentException();
                        }
                        if (rawData.hasError()) {
                            throw new IllegalArgumentException();
                        }
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                result.getResponses().getItemByName(responseName);
            }
            catch (Exception e) {
                this.logger.debug("Error received on result: " + key);
                this.logger.logThrowable(e);
                this.printMCDResult(result);
                throw new IllegalArgumentException("Error received on result: " + key);
            }
            this.logger.debug("Read " + key + " 3");
            this.logger.debug("Response: " + this.vendorSpecific.pduValue2String(result.getResponses().getItemByIndex(0L).getResponseMessage()));
            MCDResponseParameter responseParam = result.getResponses().getItemByName(responseName).getResponseParameters().getItemByName("Param_DataRecor");
            if (responsePath != null) {
                for (int i = 0; i < responsePath.length; ++i) {
                    if (responsePath[i] instanceof String) {
                        responseParam = responseParam.getParameters().getItemByName((String)responsePath[i]);
                        continue;
                    }
                    if (!(responsePath[i] instanceof Integer)) continue;
                    responseParam = responseParam.getParameters().getItemByIndex(((Integer)responsePath[i]).longValue());
                }
            }
            value = responseParam.getValue();
            if (convertToAscii) {
                value = this.getAsciiResult(value.getValueAsString());
            }
            targetParam.setValue(value);
            this.logger.debug("Read " + key + " 5");
        }
    }

    private MCDValue getAsciiResult(String string) throws MCDException {
        MCDValue result = this.jobApi.createValue(14);
        result.setValueAsString(string);
        this.logger.debug("to value: " + string);
        return result;
    }

    private String checkMCDValue(MCDValue source) {
        String text;
        try {
            switch (source.getDataType()) {
                case 1: 
                case 14: {
                    text = source.getValueAsString().replaceAll("[^\\p{ASCII}]", "?");
                    break;
                }
                default: {
                    return NULL;
                }
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            return NULL;
        }
        return text;
    }

    private void setStatus(MCDResponse jobResponse, int pJobStatus) {
        MCDResponseParameters params = null;
        try {
            params = jobResponse.getResponseParameters();
            MCDResponseParameter param = params.getItemByName("OPA_JobStatuInfor");
            MCDValue value = this.jobApi.createValue(14);
            value.setValueAsString(this.getJobStatusInformation());
            param.setValue(value);
            try {
                param = params.getItemByName("OPA_JobStatuCode");
                value = this.jobApi.createValue(11);
                value.setUint32((long)pJobStatus);
                param.setValue(value);
                this.logger.debug("Set Code " + pJobStatus + " = " + param.getValue().getUint32());
            }
            catch (Exception e) {
                this.logger.debug("Set Status Code failed!");
                this.logger.logThrowable(e);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Status failed!");
            this.logger.logThrowable(e);
        }
        try {
            if (this.mcdError != null) {
                ((MCDResult)((MCDResponses)jobResponse.getParent()).getParent()).setError(this.mcdError);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Error Object failed!");
            this.logger.logThrowable(e);
        }
    }

    private Object[] addResponse(MCDSingleEcuJob singleEcuJob, MCDDbLocation dbLocation) {
        Object[] list = new Object[2];
        try {
            Method[] methods = MCDResponses.class.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                Class<?>[] classes = method.getParameterTypes();
                if (classes.length == 2 && classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_StandECUIdent.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation) && classes[1].isAssignableFrom(Boolean.TYPE)) {
                    method.setAccessible(true);
                    MCDResult result = singleEcuJob.createResult(1794, 0, "", 0, "", 0);
                    MCDResponses responses = result.getResponses();
                    list[0] = result;
                    list[1] = method.invoke((Object)responses, dbLocation, Boolean.TRUE);
                    return list;
                }
                if (classes.length != 1 || !classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_StandECUIdent.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation)) continue;
                method.setAccessible(true);
                MCDResult result = singleEcuJob.createResult(1794, 49152, "", 0, "", 0);
                MCDResponses responses = result.getResponses();
                list[0] = result;
                list[1] = method.invoke((Object)responses, dbLocation);
                return list;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            throw new IllegalArgumentException("Can not MCDResponse#add(..) method! " + e.getMessage());
        }
        throw new IllegalArgumentException("Method MCDResponse#add(..) not found!");
    }

    protected int addOutputParameters(MCDResponse pResponse) {
        return 0;
    }

    private Set getAvailableIdentifications(String pServiceShortName) throws MCDException {
        TreeSet<String> availableIdentifications = null;
        MCDDbDiagService dbDiagService = null;
        MCDTextTableElements texttableElements = null;
        MCDTextTableElement currentTexttableElement = null;
        String currentLongName = null;
        availableIdentifications = new TreeSet<String>();
        try {
            dbDiagService = this.dbLocationOfLogicalLink.getDbDiagServices().getItemByName(pServiceShortName);
            texttableElements = dbDiagService.getDbRequest().getDbRequestParameters().getItemByName("Param_RecorDataIdent").getTextTableElements();
        }
        catch (MCDException mcde) {
            this.logger.debug("The DbDiagService \"" + pServiceShortName + "\" is not available.");
            return availableIdentifications;
        }
        for (long i = 0L; i < texttableElements.getCount(); ++i) {
            currentTexttableElement = texttableElements.getItemByIndex(i);
            try {
                currentTexttableElement.getInterval();
                currentLongName = currentTexttableElement.getLongName();
                availableIdentifications.add(currentLongName);
                continue;
            }
            catch (MCDException mcde) {
                // empty catch block
            }
        }
        return availableIdentifications;
    }
}

