/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDbLocation;
import asam.d.MCDDbRequestParameter;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDParameter;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDSystemException;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import com.audi.mcd.joblibrary.util.SubSystemHelper;
import com.audi.mcd.joblibrary.util.impl.SubSystemHelperImpl;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.GregorianCalendar;

public class MCD3_SubsyCodinWrite
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20140130";
    private boolean dedicatedSubSystemIdsSupported = false;
    private SubSystemHelper subSystemHelper = null;
    static /* synthetic */ Class class$asam$d$MCDDbLocation;

    public MCD3_SubsyCodinWrite() {
        super(REVISION, OutputParameterValue.SubsyCodinWrite.JobStatusCode.class, OutputParameterValue.SubsyCodinWrite.JobStatusInformation.class);
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        try {
            this.jobStatus = 0;
            this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
            this.subSystemHelper = new SubSystemHelperImpl(this.logger, this.vendorSpecific);
            MCDValue value_subSystemName = null;
            String subSystemName = null;
            MCDValue value_subSystemId = null;
            short subSystemId = 0;
            MCDValue codingValue = null;
            MCDRequestParameter param_SlaveSysteName = null;
            MCDDbRequestParameter dbParameter_SlaveSysteName = null;
            long lengthOfSubSystemNameDbParameter = 0L;
            Object[] resTemp = this.addResponse(pSingleEcuJob, pLogicalLink.getDbObject().getDbLocation());
            MCDResult jobResult = (MCDResult)resTemp[0];
            MCDResponse jobResponse = (MCDResponse)resTemp[1];
            this.addDebug("Main 1");
            try {
                codingValue = pRequestParameters.getItemByName("IPA_VWSlaveCodinValue").getValue();
                param_SlaveSysteName = pRequestParameters.getItemByName("IPA_SlaveSysteName").getParameters().getItemByName("Param_SlaveSysteName");
                dbParameter_SlaveSysteName = (MCDDbRequestParameter)param_SlaveSysteName.getDbObject();
                lengthOfSubSystemNameDbParameter = dbParameter_SlaveSysteName.getByteLength();
                if (lengthOfSubSystemNameDbParameter == 2L) {
                    this.dedicatedSubSystemIdsSupported = true;
                }
                try {
                    value_subSystemId = pRequestParameters.getItemByName("IPA_SlaveID").getValue();
                }
                catch (MCDException mcde) {
                    // empty catch block
                }
                try {
                    value_subSystemName = param_SlaveSysteName.getValue();
                    subSystemName = value_subSystemName.getValueAsString();
                }
                catch (Exception e) {
                    subSystemName = null;
                }
                if (subSystemName == null || MCD3_SubsyCodinWrite.removeAll(subSystemName, ' ').length() == 0 || subSystemName.equals("unknown Slave")) {
                    value_subSystemName = this.extractSlaveName(value_subSystemId.getUint32());
                    subSystemName = value_subSystemName.getValueAsString();
                    this.addDebug(" use extracted TextKey " + value_subSystemName.getValueAsString() + " from ID#:" + value_subSystemId.getUint32());
                } else {
                    this.addDebug("  use given TextKey: " + value_subSystemName.getValueAsString());
                }
                try {
                    if (value_subSystemId != null) {
                        subSystemId = (short)value_subSystemId.getUint32();
                    }
                }
                catch (MCDException mcde) {
                    try {
                        subSystemId = (short)this.vendorSpecific.getCodedValueUint32OfTextTableParameterByLongName((MCDParameter)param_SlaveSysteName, subSystemName);
                    }
                    catch (IllegalArgumentException iae) {
                        this.logger.warn("Error determining subsystem id for given sub system name \"" + subSystemName + "\".");
                        subSystemId = 0;
                    }
                }
                if (subSystemId != 0 && subSystemId != 65535 && subSystemId > 511) {
                    this.logger.warn("The read subsystem id 0x" + Integer.toHexString(subSystemId).toUpperCase() + " exceeds the maximum value 0x" + Integer.toHexString(511).toUpperCase() + "!");
                    subSystemId = (short)(subSystemId & 0x1FF);
                    this.logger.warn("The subsystem id has been truncated to 0x" + Integer.toHexString(subSystemId).toUpperCase() + ".");
                }
                if (codingValue == null) {
                    return;
                }
                this.addDebug("Main 2");
                this.addDebug("OP 1  set FingerPrint:");
                this.setTesterFingerPrint(pLogicalLink, pRequestParameters);
                this.addDebug("OP 2  : write Date:");
                try {
                    this.writeProgrammingDate(pLogicalLink);
                }
                catch (IllegalArgumentException iae) {
                }
                catch (Exception e) {
                    this.jobStatus = 11;
                    this.logger.logThrowable(e);
                }
                this.addDebug("OP 3  : write Coding:");
                this.writeCoding(pLogicalLink, subSystemName, subSystemId, codingValue);
                this.addDebug("Main END");
            }
            catch (IllegalArgumentException iae) {
                this.logger.logThrowable(iae);
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
                this.jobStatus = 1;
            }
            this.setStatus(jobResponse, this.jobStatus);
            this.dumpAndSendFinalResult(jobResult);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
            return;
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
            return;
        }
    }

    protected int readInputParameters(MCDRequestParameters pRequestParameters) {
        return 0;
    }

    private MCDValue extractSlaveName(long pSubSystemId) throws Exception {
        MCDResponseParameters EOPDUF_IdentSlaveSyste = this.getSlaveList();
        if (EOPDUF_IdentSlaveSyste == null) {
            throw new Exception();
        }
        for (long i = 0L; i < EOPDUF_IdentSlaveSyste.getCount(); ++i) {
            try {
                MCDResponseParameters STRUC_SlaveSyste = EOPDUF_IdentSlaveSyste.getItemByIndex(i).getParameters();
                this.addDebug("Compare " + pSubSystemId + " == " + STRUC_SlaveSyste.getItemByName("Param_SlaveID").getValue().getUint32());
                if (STRUC_SlaveSyste.getItemByName("Param_SlaveID").getValue().getUint32() != pSubSystemId) continue;
                return STRUC_SlaveSyste.getItemByName("Param_SlaveSyste").getValue();
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
            }
        }
        this.jobStatus = 1;
        throw new IllegalArgumentException("No matching SlaveID found!");
    }

    private MCDResponseParameters getSlaveList() throws IllegalAccessException, MCDException {
        MCDResponseParameters slaveCollection;
        this.logger.debug("2  Extract SlaveCollection");
        try {
            slaveCollection = this.getSlaveSystems("Identified SubSystem Numbers", false);
        }
        catch (Exception e) {
            this.logger.debug("DID 0608 failed (Identified SubSystem Numbers)!");
            slaveCollection = this.getSlaveSystems("Identified Slave Systems", true);
        }
        if (slaveCollection != null && slaveCollection.getCount() == 0L) {
            this.jobStatus = 0;
            throw new IllegalAccessException();
        }
        return slaveCollection;
    }

    private MCDResponseParameters getSlaveSystems(String did, boolean storeError) throws IllegalAccessException {
        MCDDiagComPrimitive service22060x = null;
        MCDResult result22060x = null;
        try {
            try {
                this.logger.debug("2 1 Create DiagnServi_ReadDataByIdentECUIdent");
                service22060x = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentECUIdent");
                MCDRequestParameter didParam = service22060x.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
                MCDValue value = didParam.createValue();
                value.setValueAsString(did);
                didParam.setValue(value);
            }
            catch (MCDException mcde) {
                this.logger.debug("2 2 Create DiagnServi_ReadDataByIdentECUIdent(" + did + ") FAILED!");
                this.logger.logThrowable(mcde);
                try {
                    service22060x = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentIdentSlaveSyste");
                }
                catch (MCDException mcde2) {
                    this.logger.debug("2 2 Create DiagnServi_ReadDataByIdentIdentSlaveSyste FAILED!");
                    this.logger.logThrowable(mcde2);
                    if (storeError) {
                        this.jobStatus = 5;
                    }
                    throw new IllegalAccessException();
                }
            }
            this.logger.debug("2 3 Execute Service");
            this.printRequest(service22060x);
            result22060x = service22060x.executeSync();
            if (result22060x.hasError()) {
                throw new Exception();
            }
            if (this.checkNRC(result22060x, 49L)) {
                this.logger.debug("2 3b NRC 0x31 found!");
                this.printMCDResult(result22060x);
                if (storeError) {
                    this.jobStatus = 2;
                }
                throw new IllegalAccessException();
            }
            this.logger.debug("2 4 Try to get pos Response..");
            if (this.responseNotAcknowledged(result22060x)) {
                this.catchResponseInfo(result22060x, null);
                if (storeError) {
                    this.jobStatus = 1;
                }
                throw new IllegalAccessException();
            }
            MCDResponse response22060x = result22060x.getResponses().getItemByIndex(0L);
            this.logger.debug("2 5 responsePDU: " + this.vendorSpecific.pduValue2String(response22060x.getResponseMessage()));
            MCDResponseParameter dataRecor = response22060x.getResponseParameters().getItemByName("Param_DataRecor");
            this.logger.debug("Data type of Data Record: " + McdEnumDecoder.decodeMcdDataType(dataRecor.getType()));
            MCDResponseParameters slaveCollection = dataRecor.getType() == 17 ? dataRecor.getParameters().getItemByIndex(0L).getParameters() : dataRecor.getParameters();
            this.logger.debug("Data type of slaveCollection: " + McdEnumDecoder.decodeMcdDataType(slaveCollection.getItemByIndex(0L).getType()));
            if (slaveCollection.getItemByIndex(0L).getType() == 22) {
                slaveCollection = slaveCollection.getItemByIndex(0L).getParameters();
            }
            this.logger.debug("2 6 Check SlaveCollection amount: " + slaveCollection.getCount());
            return slaveCollection;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.catchResponseInfo(result22060x, e);
            if (storeError) {
                this.jobStatus = 1;
            }
            throw new IllegalAccessException();
        }
    }

    private boolean checkNRC(MCDResult result, long value) {
        try {
            this.logger.debug("Check NRC " + value);
            byte[] pdu = result.getResponses().getItemByIndex(0L).getResponseMessage().getBytefield();
            return pdu.length >= 3 && pdu[0] == 127 && (long)pdu[2] == value;
        }
        catch (Exception e) {
            this.logger.debug("Check NRC " + value + " FAILED!");
            this.logger.logThrowable(e);
            return false;
        }
    }

    private void catchResponseInfo(MCDResult result, Exception e) {
        this.logger.logThrowable(e);
        this.printMCDResult(result);
    }

    private boolean responseNotAcknowledged(MCDResult result220606) {
        try {
            MCDResponse response220606;
            MCDResponses responses = result220606.getResponses();
            return responses == null || responses.getCount() < 1L || (response220606 = responses.getItemByIndex(0L)) == null || response220606.getState() != 26625;
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
            return true;
        }
    }

    private void writeProgrammingDate(MCDLogicalLink mCDLogicalLink) throws IllegalArgumentException, MCDException {
        MCDDiagComPrimitive wdbin = null;
        try {
            GregorianCalendar calender = new GregorianCalendar();
            this.addDebug("setDate 1 ");
            wdbin = mCDLogicalLink.createDiagComPrimitiveByName("DiagnServi_WriteDataByIdentECUIdent");
            MCDRequestParameter tableKeyParamN = wdbin.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
            MCDValue value = tableKeyParamN.createValue();
            value.setValueAsString("Programming Date");
            tableKeyParamN.setValue(value);
            this.addDebug("setDate 2 ");
            MCDRequestParameter tableKeyStruct = wdbin.getRequest().getRequestParameters().getItemByName("Param_DataRecor");
            if (tableKeyStruct.getType() == 17) {
                tableKeyStruct = tableKeyStruct.getParameters().getItemByName("TABROW_ProgrDate");
            }
            this.addDebug("setDate 3 ");
            MCDRequestParameters dateParams = tableKeyStruct.getParameters().getItemByName("Param_Date").getParameters();
            this.setDateParam(dateParams.getItemByName("Param_Year"), Integer.parseInt((calender.get(1) + "").substring(2)));
            this.setDateParam(dateParams.getItemByName("Param_Month"), calender.get(2) + 1);
            this.setDateParam(dateParams.getItemByName("Param_Day"), calender.get(5));
        }
        catch (Exception e) {
            this.jobStatus = 11;
            this.logger.logThrowable(e);
            throw new IllegalArgumentException("Write Coding Date Failed");
        }
        this.addDebug("setDate 4 ");
        this.printRequest(wdbin);
        MCDResult resultDate = wdbin.executeSync();
        if (resultDate == null || resultDate.hasError() || this.responseNotAcknowledged(resultDate)) {
            this.addDebug("Execute DiagnServi_WriteDataByIdentECUIdent failed!!");
            this.printMCDResult(resultDate);
            this.jobStatus = 11;
            this.setKnownErrors(resultDate);
            throw new IllegalArgumentException("Write Coding Date Failed");
        }
        this.addDebug("setDate success!");
    }

    private void writeCoding(MCDLogicalLink mCDLogicalLink, String pSubSystemName, short pSubSystemId, MCDValue codingValue) throws IllegalArgumentException, MCDException {
        MCDDiagComPrimitive writeDataByIdentVWSlaveCodinValue = null;
        MCDResult result = null;
        MCDRequest request = null;
        MCDRequestParameters requestParameters = null;
        MCDRequestParameter param_recordDataIdentifier = null;
        MCDRequestParameter param_dataRecord = null;
        MCDRequestParameter param_rawData = null;
        MCDValue value_rawData = null;
        String subSystemName = null;
        String tableKey = null;
        this.addDebug("writeCoding 1 ");
        try {
            writeDataByIdentVWSlaveCodinValue = mCDLogicalLink.createDiagComPrimitiveByName("DiagnServi_WriteDataByIdentVWSlaveCodinValue");
            this.addDebug("Service created: DiagnServi_WriteDataByIdentVWSlaveCodinValue");
        }
        catch (MCDSystemException mcdse) {
            this.addDebug("Service not found: DiagnServi_WriteDataByIdentVWSlaveCodinValue");
            this.jobStatus = 3;
            throw new IllegalArgumentException("Could Not Evaluate Identified Slave System Response From Master-ECU");
        }
        this.addDebug("writeCoding 2 ");
        request = writeDataByIdentVWSlaveCodinValue.getRequest();
        if (request == null || (requestParameters = request.getRequestParameters()) == null) {
            this.jobStatus = 10;
            throw new IllegalArgumentException("Write Coding Value Failed");
        }
        this.addDebug("writeCoding 3 ");
        try {
            subSystemName = pSubSystemName;
            String LONGNAME_SUFFIX_SYSTEM_NAME = "_System_Name";
            if (subSystemName.endsWith("_System_Name")) {
                subSystemName = subSystemName.substring(0, subSystemName.length() - "_System_Name".length());
            }
            if ((param_recordDataIdentifier = requestParameters.getItemByName("Param_RecorDataIdent")) == null) {
                this.jobStatus = 10;
                throw new IllegalArgumentException("Write Coding Value Failed");
            }
            if (!this.subSystemHelper.findAndSetMatchingTextTableElementWithSubSystemLongName(writeDataByIdentVWSlaveCodinValue.getDbObject().getShortName(), param_recordDataIdentifier, subSystemName)) {
                this.logger.warn("Failed to find/set matching TABLE-KEY for \"" + subSystemName + "\"!");
                if (!this.dedicatedSubSystemIdsSupported) {
                    this.jobStatus = 10;
                    throw new IllegalArgumentException("Write Coding Value Failed");
                }
                this.logger.debug("Trying to find/set matching TABLE-KEY for subsystem id 0x" + Integer.toHexString(pSubSystemId).toUpperCase() + "...");
                if (!this.subSystemHelper.findAndSetMatchingTextTableElementWithSubSystemId(writeDataByIdentVWSlaveCodinValue.getDbObject().getShortName(), param_recordDataIdentifier, pSubSystemId)) {
                    this.logger.error("Failed to find/set matching TABLE-KEY for subsystem id 0x" + Integer.toHexString(pSubSystemId).toUpperCase() + "...");
                    this.jobStatus = 10;
                    throw new IllegalArgumentException("Write Coding Value Failed");
                }
            }
            tableKey = param_recordDataIdentifier.getValue().getValueAsString();
        }
        catch (Exception e) {
            this.addDebug("Set key failed!!");
            this.logger.logThrowable(e);
            this.jobStatus = 10;
            throw new IllegalArgumentException("Write Coding Value Failed");
        }
        this.addDebug("writeCoding 4 ");
        param_recordDataIdentifier = requestParameters.getItemByName("Param_DataRecor");
        if (param_recordDataIdentifier == null || codingValue == null) {
            this.jobStatus = 2;
            throw new IllegalArgumentException("Could Not Determine Sub System Information");
        }
        try {
            param_dataRecord = this.vendorSpecific.getTableStructParameterByTableKeyValue(requestParameters, "Param_DataRecor", tableKey);
            param_rawData = param_dataRecord.getParameters().getItemByName("Param_RawData");
        }
        catch (Exception e) {
            this.addDebug("----------> This error can occurs if TAB-ROW Name extraction is failed!\n\tThis algorithm is only necessary for DTS-Runtime!!!!!");
            this.logger.logThrowable(e);
            this.jobStatus = 10;
            throw new IllegalArgumentException("Write Coding Value Failed");
        }
        value_rawData = param_rawData.createValue();
        value_rawData.setBytefield(codingValue.getBytefield());
        param_rawData.setValue(value_rawData);
        this.addDebug("writeCoding 5 ");
        this.printRequest(writeDataByIdentVWSlaveCodinValue);
        result = writeDataByIdentVWSlaveCodinValue.executeSync();
        if (result == null || result.hasError() || this.responseNotAcknowledged(result)) {
            this.addDebug("Execute DiagnServi_WriteDataByIdentVWSlaveCodinValue failed!!");
            this.printMCDResult(result);
            this.jobStatus = 10;
            this.setKnownErrors(result);
            throw new IllegalArgumentException("Write Coding Value Failed");
        }
        this.addDebug("writeCoding success! ");
    }

    private static String removeAll(String text, char sign) {
        StringBuffer sb = new StringBuffer();
        int l = text.length();
        for (int i = 0; i < l; ++i) {
            if (text.charAt(i) == sign) continue;
            sb.append(text.charAt(i));
        }
        return sb.toString();
    }

    private void setKnownErrors(MCDResult result) {
        try {
            byte[] pdu = result.getResponses().getItemByIndex(0L).getResponseMessage().getBytefield();
            if (pdu.length < 3) {
                return;
            }
            if (pdu[2] == 49) {
                this.jobStatus = 13;
                throw new IllegalArgumentException("Coding Not Supported / Incorrect Diagnostic Session");
            }
            if (pdu[2] == 34) {
                this.jobStatus = 12;
                throw new IllegalArgumentException("Incorrect Ignition Status Or Vehicle Condition");
            }
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
        }
    }

    private void setTesterFingerPrint(MCDLogicalLink mCDLogicalLink, MCDRequestParameters mCDRequestParameters) throws IllegalArgumentException, MCDException {
        MCDDiagComPrimitive service2EF198;
        block15: {
            boolean finger2;
            boolean finger1;
            MCDRequestParameters params;
            service2EF198 = null;
            MCDValue ipaDeviceNumbe = null;
            MCDValue ipaImportNumbe = null;
            MCDValue ipaWorksNumbe = null;
            MCDValue ipaSerialNumbe = null;
            this.addDebug("set FingerPrint 1 ");
            try {
                service2EF198 = mCDLogicalLink.createDiagComPrimitiveByName("DiagnServi_WriteDataByIdentECUIdent");
                this.addDebug("Service created: DiagnServi_WriteDataByIdentECUIdent");
            }
            catch (MCDSystemException mcdse) {
                this.addDebug("Service not found: DiagnServi_WriteDataByIdentECUIdent");
                this.jobStatus = 9;
                throw new IllegalArgumentException("Write Repair Shop Code Or Tester Serial Number Failed");
            }
            this.addDebug("set FingerPrint 2 ");
            MCDRequest request = service2EF198.getRequest();
            if (request == null || (params = request.getRequestParameters()) == null) {
                this.jobStatus = 9;
                throw new IllegalArgumentException("Write Repair Shop Code Or Tester Serial Number Failed");
            }
            this.addDebug("set FingerPrint 3 ");
            try {
                MCDRequestParameter keyParam = params.getItemByName("Param_RecorDataIdent");
                MCDValue key = keyParam.createValue();
                key.setValueAsString("Repair Shop Code Or Tester Serial Number");
                keyParam.setValue(key);
            }
            catch (Exception e) {
                this.addDebug("Set key failed!!");
                this.jobStatus = 9;
                throw new IllegalArgumentException("Write Repair Shop Code Or Tester Serial Number Failed");
            }
            this.addDebug("set FingerPrint 4 ");
            MCDRequestParameter fingerParam = params.getItemByName("Param_DataRecor");
            MCDRequestParameters testerSerialNumber = fingerParam.getParameters();
            if (fingerParam.getType() == 17) {
                testerSerialNumber = testerSerialNumber.getItemByName("TABROW_RepaiShopCodeOrTesteSeriaNumbe").getParameters();
            }
            try {
                ipaDeviceNumbe = mCDRequestParameters.getItemByName("IPA_VWDevicNumbe").getValue();
                ipaImportNumbe = mCDRequestParameters.getItemByName("IPA_ImporNumbe").getValue();
                ipaWorksNumbe = mCDRequestParameters.getItemByName("IPA_WorksNumbe").getValue();
                finger1 = true;
            }
            catch (Exception e) {
                finger1 = false;
                this.logger.logThrowable(e);
            }
            try {
                ipaSerialNumbe = mCDRequestParameters.getItemByName("IPA_Finge").getValue();
                finger2 = true;
            }
            catch (Exception e) {
                finger2 = false;
                this.logger.debug("Inputparameter IPA_Finge not found!");
            }
            try {
                if (finger2 && (!finger1 || ipaDeviceNumbe != null && ipaDeviceNumbe.getUint32() == 0L && ipaImportNumbe != null && ipaImportNumbe.getUint32() == 0L && ipaWorksNumbe != null && ipaWorksNumbe.getUint32() == 0L)) {
                    testerSerialNumber.getItemByName("Param_RepaiShopCodeOrTesteSeriaNumbe").setValue(ipaSerialNumbe);
                    this.addDebug("Use Param_RepaiShopCodeOrTesteSeriaNumbe");
                    break block15;
                }
                if (finger1) {
                    testerSerialNumber.getItemByName("Param_VWDevicNumbe").setValue(ipaDeviceNumbe);
                    testerSerialNumber.getItemByName("Param_ImporNumbe").setValue(ipaImportNumbe);
                    testerSerialNumber.getItemByName("Param_WorksNumbe").setValue(ipaWorksNumbe);
                    this.addDebug("Use Param_VWDevicNumbe Param_ImporNumbe Param_WorksNumbe");
                    break block15;
                }
                this.jobStatus = 9;
                throw new IllegalArgumentException("Write Repair Shop Code Or Tester Serial Number Failed");
            }
            catch (MCDException mcde) {
                testerSerialNumber.getItemByName("Param_VWDevicNumbe").setValue(ipaDeviceNumbe);
                testerSerialNumber.getItemByName("Param_ImporNumbe").setValue(ipaImportNumbe);
                testerSerialNumber.getItemByName("Param_WorksNumbe").setValue(ipaWorksNumbe);
                this.addDebug("  use Param_RepaiShopCodeOrTesteSeriaNumbe");
            }
        }
        this.printRequest(service2EF198);
        MCDResult result2EF198 = service2EF198.executeSync();
        if (result2EF198 == null || result2EF198.hasError() || this.responseNotAcknowledged(result2EF198)) {
            this.printMCDResult(result2EF198);
            this.addDebug("Execute DiagnServi_WriteDataByIdentECUIdent failed!!");
            this.jobStatus = 9;
            this.setKnownErrors(result2EF198);
            throw new IllegalArgumentException("Write Repair Shop Code Or Tester Serial Number Failed");
        }
        this.addDebug("set FingerPrint success! ");
    }

    private void setDateParam(MCDRequestParameter param, int i) throws MCDException {
        MCDValue value = param.createValue();
        this.logger.debug(i + ":  " + new BigInteger("" + i, 16).intValue());
        value.setUint32((long)i);
        param.setValue(value);
    }

    private void addDebug(String text) {
        this.logger.debug(text);
    }

    private void setStatus(MCDResponse jobResponse, int pJobStatusCode) {
        MCDResponseParameters params = null;
        try {
            params = jobResponse.getResponseParameters();
            MCDResponseParameter param = params.getItemByName("OPA_JobStatuInfor");
            MCDValue value = this.jobApi.createValue(14);
            value.setValueAsString(this.getJobStatusInformation());
            param.setValue(value);
            try {
                param = params.getItemByName("OPA_JobStatuCode");
                value = this.jobApi.createValue(11);
                value.setUint32((long)pJobStatusCode);
                param.setValue(value);
                this.logger.debug("Set Code " + pJobStatusCode + " = " + param.getValue().getUint32());
            }
            catch (Exception e) {
                this.logger.debug("Set Status Code failed!");
                this.logger.logThrowable(e);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Status failed!");
            this.logger.logThrowable(e);
        }
        try {
            if (this.mcdError != null) {
                ((MCDResult)((MCDResponses)jobResponse.getParent()).getParent()).setError(this.mcdError);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Error Object failed!");
            this.logger.logThrowable(e);
        }
    }

    private Object[] addResponse(MCDSingleEcuJob singleEcuJob, MCDDbLocation dbLocation) {
        Object[] list = new Object[2];
        try {
            Method[] methods = MCDResponses.class.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                Class<?>[] classes = method.getParameterTypes();
                if (classes.length == 2 && classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_SubsyCodinWrite.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation) && classes[1].isAssignableFrom(Boolean.TYPE)) {
                    method.setAccessible(true);
                    MCDResult result = singleEcuJob.createResult(1794, 0, "", 0, "", 0);
                    MCDResponses responses = result.getResponses();
                    list[0] = result;
                    list[1] = method.invoke((Object)responses, dbLocation, Boolean.TRUE);
                    return list;
                }
                if (classes.length != 1 || !classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_SubsyCodinWrite.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation)) continue;
                method.setAccessible(true);
                MCDResult result = singleEcuJob.createResult(1794, 49152, "", 0, "", 0);
                MCDResponses responses = result.getResponses();
                list[0] = result;
                list[1] = method.invoke((Object)responses, dbLocation);
                return list;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            throw new IllegalArgumentException("Can not MCDResponse#add(..) method! " + e.getMessage());
        }
        throw new IllegalArgumentException("Method MCDResponse#add(..) not found!");
    }

    protected int addOutputParameters(MCDResponse pResponse) {
        return 0;
    }
}

