/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary3.jobs.impl;

import asam.d.MCDDbEcu;
import asam.d.MCDDbIdentDescription;
import asam.d.MCDDbLocation;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDExecutionState;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDStartCommunication;
import asam.d.MCDStopCommunication;
import com.audi.mcd.joblibrary3.jobs.AbstractJob;
import com.audi.mcd.joblibrary3.util.dserver.DServerVendor;
import com.audi.mcd.joblibrary3.util.dserver.VendorSpecific;
import com.audi.mcd.joblibrary3.util.logging.Logger;
import com.audi.mcd.joblibrary3.util.logging.McdObjectDumper;
import com.audi.mcd.joblibrary3.util.logging.impl.LoggerImpl;
import com.audi.mcd.joblibrary3.util.logging.impl.McdObjectDumperImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;

public abstract class AbstractJobImpl
implements AbstractJob {
    protected static SimpleDateFormat traceTimeStampFormat = null;
    protected static Runtime javaRuntime = null;
    protected static long maximumAvailableMemory = 0L;
    protected String revision = null;
    protected Logger logger = null;
    protected String logMessage = null;
    protected McdObjectDumper mcdObjectDumper = null;
    protected DServerVendor dServerVendor = DServerVendor.UNKNOWN;
    protected VendorSpecific vendorSpecific = null;
    protected boolean isPduApiUsed = false;
    protected boolean isMcd20002Interface = false;
    protected boolean isMcd300Interface = false;
    protected Method addResponseMethod = null;
    protected long jobStartTime = 0L;
    protected Date jobRuntime = new Date();
    protected AbstractJob.JobStatus jobStatus = null;
    protected MCDRequestParameters inputParameters = null;
    protected MCDJobApi jobApi = null;
    protected MCDLogicalLink logicalLink = null;
    protected MCDJob job = null;
    protected MCDDbLocation dbLocationOfLogicalLink = null;
    protected String dbEcuName = null;
    protected int dbLocationTypeOfLogicalLink = -1;
    protected String dbLocationAccessKey = null;
    protected String dbLocationAccessKeyFunctionalGroup = null;
    protected String dbLocationAccessKeyBaseVariant = null;
    protected String responseLocationAccessKey = null;
    protected String dbLocationShortNameProtocol = null;
    protected AbstractJob.ProtocolStack protocolStack = null;
    protected MCDStartCommunication startCommunication = null;
    protected MCDStopCommunication stopCommunication = null;
    protected Properties jobProperties = null;

    protected AbstractJobImpl(String pRevision) {
        this.revision = pRevision;
        this.logger = new LoggerImpl(this);
        this.mcdObjectDumper = new McdObjectDumperImpl(this.logger);
    }

    protected static String buildAccessKey(String pProtocolShortName, String pFunctionalGroupShortName, String pBaseVariantShortName, String pEcuVariantShortName) {
        String result = new String();
        result = result + "[Protocol]" + pProtocolShortName;
        if (pFunctionalGroupShortName != null && pFunctionalGroupShortName.length() > 0) {
            result = result + ".[FunctionalGroup]" + pFunctionalGroupShortName;
        }
        if (pBaseVariantShortName != null && pBaseVariantShortName.length() > 0) {
            result = result + ".[EcuBaseVariant]" + pBaseVariantShortName;
        }
        if (pEcuVariantShortName != null && pEcuVariantShortName.length() > 0) {
            result = result + ".[EcuVariant]" + pBaseVariantShortName;
        }
        return result;
    }

    public final String getRevision() {
        return this.revision;
    }

    protected AbstractJob.JobStatus prepareJobGuarded(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDJob pJob) {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        try {
            currentJobStatus = this.prepareJob(pRequestParameters, pJobApi, pLogicalLink, pJob);
        }
        catch (Exception e) {
            this.logger.debug("Caught Exception in prepareJob() method.");
            this.logger.logThrowable(e);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        catch (Throwable t) {
            this.logger.debug("Caught Throwable in prepareJob() method.");
            this.logger.logThrowable(t);
            currentJobStatus = AbstractJob.JobStatus.EXCEPTION_CAUGHT;
        }
        return currentJobStatus;
    }

    protected AbstractJob.JobStatus prepareJob(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDJob pJob) {
        block19: {
            AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
            MCDDbEcu dbEcu = null;
            this.jobStartTime = System.currentTimeMillis();
            if (pRequestParameters == null || pJobApi == null || pLogicalLink == null || pJob == null) {
                return AbstractJob.JobStatus.JOB_STARTED_WITH_NULL_ARGUMENTS;
            }
            try {
                dbEcu = pLogicalLink.getDbObject().getDbLocation().getDbECU();
                this.dbEcuName = dbEcu.getShortName();
            }
            catch (MCDException mcde) {
                this.dbEcuName = "UNKNOWN";
            }
            if (this.dbEcuName == null) {
                try {
                    this.dbEcuName = this.logicalLink.getDbObject().getShortName();
                }
                catch (MCDException mcde) {
                    this.dbEcuName = "UNKNOWN";
                }
            }
            this.logger.init(this.dbEcuName);
            this.logger.info("Running on: " + this.dbEcuName);
            this.logger.debug("Maximum available memory: " + maximumAvailableMemory / 1024L + " KiB");
            this.inputParameters = pRequestParameters;
            this.jobApi = pJobApi;
            this.logicalLink = pLogicalLink;
            this.job = pJob;
            this.setJobProgress(0L);
            this.dServerVendor = VendorSpecific.getServerVendor();
            this.vendorSpecific = VendorSpecific.getInstance(this.logger, this.logicalLink);
            this.mcdObjectDumper.setVendorSpecific(this.vendorSpecific);
            currentJobStatus = this.determineMcdVersion();
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                return currentJobStatus;
            }
            currentJobStatus = this.determineAddResponseMethod();
            if (currentJobStatus != AbstractJob.JobStatus.NO_ERROR) {
                return currentJobStatus;
            }
            try {
                this.dbLocationOfLogicalLink = this.logicalLink.getDbObject().getDbLocation();
                this.dbLocationAccessKey = this.dbLocationOfLogicalLink.getAccessKey().getString();
                this.dbLocationAccessKeyBaseVariant = this.dbLocationAccessKey.indexOf(".[EcuVariant]") != -1 ? this.dbLocationAccessKey.substring(0, this.dbLocationAccessKey.indexOf(".[EcuVariant]")) : this.dbLocationAccessKey;
                this.setJobInfo(this.job.getDbObject().getLongName() + " started on " + this.dbEcuName);
                this.dbLocationTypeOfLogicalLink = this.dbLocationOfLogicalLink.getDbECU().getObjectType();
                this.logMessage = "Running on ";
                switch (this.dbLocationTypeOfLogicalLink) {
                    case 1158: {
                        this.logMessage = this.logMessage + "ECU-VARIANT: ";
                        this.dbLocationAccessKeyBaseVariant = AbstractJobImpl.buildAccessKey(this.dbLocationOfLogicalLink.getAccessKey().getProtocol(), null, this.dbLocationOfLogicalLink.getAccessKey().getEcuBaseVariant(), null);
                        break;
                    }
                    case 1156: {
                        this.logMessage = this.logMessage + "BASE-VARIANT: ";
                        this.dbLocationAccessKeyBaseVariant = AbstractJobImpl.buildAccessKey(this.dbLocationOfLogicalLink.getAccessKey().getProtocol(), null, this.dbLocationOfLogicalLink.getAccessKey().getEcuBaseVariant(), null);
                        break;
                    }
                    case 1162: {
                        this.logMessage = this.logMessage + "FUNCTIONAL-GROUP: ";
                        this.dbLocationAccessKeyFunctionalGroup = AbstractJobImpl.buildAccessKey(this.dbLocationOfLogicalLink.getAccessKey().getProtocol(), this.dbLocationOfLogicalLink.getAccessKey().getFunctionalGroup(), null, null);
                        break;
                    }
                    default: {
                        this.logMessage = this.logMessage + "neither BV nor EV nor FG ?!?! ";
                    }
                }
                this.dbLocationShortNameProtocol = this.dbLocationOfLogicalLink.getAccessKey().getProtocol();
                this.logMessage = this.logMessage + this.dbEcuName;
                this.logger.debug(this.logMessage);
                this.logger.debug("AccessKey of LOGICAL-LINK    : " + this.dbLocationAccessKey);
                this.logger.debug("AccessKey of FUNCTIONAL-GROUP: " + this.dbLocationAccessKeyFunctionalGroup);
                this.logger.debug("AccessKey of BASE-VARIANT    : " + this.dbLocationAccessKeyBaseVariant);
            }
            catch (MCDException mcde) {
                this.logger.debug("Error determining current dbLocation.");
                if (this.dbEcuName != null) break block19;
                this.dbEcuName = "";
            }
        }
        this.protocolStack = AbstractJob.ProtocolStack.valueOfProtocolShortName(this.dbLocationShortNameProtocol);
        this.logger.info("Detected protocol stack: " + this.protocolStack.toString());
        if (this.logger.getLogLevel() >= 5) {
            try {
                if (this.inputParameters.getCount() > 0L) {
                    this.logger.debug("Dumping INPUT-PARAMs...");
                    this.mcdObjectDumper.dumpRequestParameters(pRequestParameters, 1);
                }
            }
            catch (MCDException mcde) {
                this.logger.debug("Error dumping input parameters!");
                this.logger.logThrowable(mcde);
            }
        }
        this.readJobProperties();
        this.logger.trace("Leaving prepareJob(...).");
        return AbstractJob.JobStatus.NO_ERROR;
    }

    protected void finalizeJob() {
        MCDResult finalResult = null;
        MCDResponse finalResponse = null;
        this.logger.trace("Entering finalizeJob(...).");
        if (!this.isPduApiUsed) {
            if (this.startCommunication != null) {
                this.logger.debug("Removing MCDStartCommunication from LogicalLink.");
                try {
                    this.logicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)this.startCommunication);
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error removing MCDStartCommunication from logical link.");
                    this.logger.logThrowable(mcde);
                }
            }
            if (this.stopCommunication != null) {
                this.logger.debug("Removing MCDStopCommunication from LogicalLink.");
                try {
                    this.logicalLink.removeDiagComPrimitive((MCDDiagComPrimitive)this.stopCommunication);
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error removing MCDStopCommunication from logical link.");
                    this.logger.logThrowable(mcde);
                }
            }
        }
        this.logger.debug("Creating final job result.");
        finalResult = this.createFinalResult();
        this.logger.debug("Adding response.");
        finalResponse = this.addResponse(finalResult, true);
        this.logger.debug("Adding job output parameters to response.");
        this.addOutputParameters(finalResponse);
        this.dumpAndSendFinalResult(finalResult);
        this.setJobProgress(100L);
    }

    protected MCDResult createFinalResult() {
        MCDResult result = null;
        try {
            result = this.isMcd20002Interface ? this.job.createResult(1794, 0, "", 0, "", 2049) : this.job.createResult(1794, 49152, "", 0, "", 2049);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating job result.");
            this.logger.logThrowable(mcde);
        }
        return result;
    }

    protected final AbstractJob.JobStatus determineMcdVersion() {
        int i;
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        Field[] fields = null;
        Method[] methods = null;
        this.logger.trace("Entering determineMcdVersion()...");
        fields = MCDExecutionState.class.getDeclaredFields();
        for (i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("eALL_FAILED")) continue;
            this.isMcd20002Interface = true;
            break;
        }
        if (this.isMcd20002Interface) {
            this.logger.debug("MCDExecutionState.eALL_FAILED exists => MCD version must be 2.00.02 or later.");
        } else {
            this.logger.debug("MCDExecutionState.eALL_FAILED does NOT exist => MCD version must be 2.00.01 or earlier.");
        }
        methods = MCDDbIdentDescription.class.getDeclaredMethods();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("getDbDataPrimitiveByLocation")) continue;
            this.isMcd300Interface = true;
            break;
        }
        if (this.isMcd300Interface) {
            this.logger.debug("MCDDbIdentDescription.getDbDataPrimitiveByLocation(...) exists => MCD version must be 3.0.0 or later.");
        } else {
            this.logger.debug("MCDDbIdentDescription.getDbDataPrimitiveByLocation(...) does NOT exist => MCD version must be 2.00.xx.");
        }
        this.logger.trace("Leaving determineMcdVersion()...");
        return currentJobStatus;
    }

    protected final AbstractJob.JobStatus determineAddResponseMethod() {
        AbstractJob.JobStatus currentJobStatus = AbstractJob.JobStatus.NO_ERROR;
        MCDResult result = null;
        MCDResponses responses = null;
        this.logger.trace("Entering determineAddResponseMethod()...");
        try {
            result = this.job.createResult(1795, 0, "", 0, "", 2049);
        }
        catch (MCDException mcde) {
            this.logger.debug("Error creating dummy result.");
            this.logger.logThrowable(mcde);
        }
        if (result == null) {
            currentJobStatus = AbstractJob.JobStatus.ERROR;
        } else {
            try {
                responses = result.getResponses();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting responses from dummy result.");
                this.logger.logThrowable(mcde);
            }
            if (responses == null) {
                currentJobStatus = AbstractJob.JobStatus.ERROR;
            } else {
                if (this.isMcd20002Interface) {
                    try {
                        this.addResponseMethod = responses.getClass().getMethod("add", MCDDbLocation.class, Boolean.TYPE);
                        this.logger.debug("Found MCDResponses.add( MCDDbLocation, boolean ) matching the MCD3D 2.00.02 interface.");
                    }
                    catch (NoSuchMethodException nse) {
                        this.logger.debug("MCDResponses.add( MCDDbLocation, boolean ) was not found => MCD version must be 2.00.01 or earlier.");
                        this.logger.logThrowable(nse);
                        this.logger.fatal("MCD interface is inconsistent!");
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                    }
                } else {
                    try {
                        this.addResponseMethod = responses.getClass().getMethod("add", MCDDbLocation.class);
                        this.logger.debug("Found MCDResponses.add( MCDDbLocation ) matching the MCD3D 2.00.01 (or older) interface.");
                    }
                    catch (NoSuchMethodException nse) {
                        this.logger.debug("MCDResponses.add( MCDDbLocation ) was not found => MCD version must be 2.00.02 or later.");
                        this.logger.logThrowable(nse);
                        this.logger.fatal("MCD interface is inconsistent!");
                        currentJobStatus = AbstractJob.JobStatus.ERROR;
                    }
                }
                if (!this.addResponseMethod.isAccessible()) {
                    this.logger.debug("MCDResponses.add(...) is not accessible - enabling access...");
                    this.addResponseMethod.setAccessible(true);
                }
            }
            try {
                this.job.releaseResult(result);
                result = null;
            }
            catch (MCDException mcde) {
                this.logger.debug("Error cleaning up dummy result.");
                this.logger.logThrowable(mcde);
            }
        }
        this.logger.trace("Leaving determineAddResponseMethod()...");
        return currentJobStatus;
    }

    protected final MCDResponse addResponse(MCDResponses pResponses, MCDDbLocation pDbLocation, boolean pIsPositiveResponse) {
        MCDResponse response = null;
        this.logger.trace("Entering addResponse( MCDResponses, MCDDbLocation )");
        if (this.isMcd20002Interface) {
            try {
                response = (MCDResponse)this.addResponseMethod.invoke((Object)pResponses, pDbLocation, new Boolean(pIsPositiveResponse));
            }
            catch (InvocationTargetException ite) {
                this.logger.debug("Error adding response to result.");
                this.logger.logThrowable(ite);
            }
            catch (IllegalArgumentException iare) {
                this.logger.debug("Error adding response to result.");
                this.logger.logThrowable(iare);
            }
            catch (IllegalAccessException iace) {
                this.logger.debug("Error adding response to result.");
                this.logger.logThrowable(iace);
            }
        } else {
            if (!pIsPositiveResponse) {
                this.logger.fatal("Negative responses are NOT supported with MCD 2.00.01 or earlier!");
                return null;
            }
            try {
                response = (MCDResponse)this.addResponseMethod.invoke((Object)pResponses, pDbLocation);
            }
            catch (InvocationTargetException ite) {
                this.logger.debug("Error adding response to result.");
                this.logger.logThrowable(ite);
            }
            catch (IllegalArgumentException iare) {
                this.logger.debug("Error adding response to result.");
                this.logger.logThrowable(iare);
            }
            catch (IllegalAccessException iace) {
                this.logger.debug("Error adding response to result.");
                this.logger.logThrowable(iace);
            }
        }
        this.logger.trace("Leaving addResponse( MCDResponses, MCDDbLocation )");
        return response;
    }

    protected final MCDResponse addResponse(MCDResult pResult, boolean pIsPositiveResponse) {
        MCDResponses responses = null;
        MCDResponse response = null;
        this.logger.trace("Entering addResponse(...).");
        if (pResult == null) {
            this.logger.error("addResponse() called with null argument!");
        } else {
            try {
                responses = pResult.getResponses();
            }
            catch (MCDException mcde) {
                this.logger.error("Error getting responses from result.");
                this.logger.logThrowable(mcde);
            }
            if (responses == null) {
                this.logger.error("MCDResult.getResponses() returned null!");
            } else {
                if (!this.isMcd20002Interface && !pIsPositiveResponse) {
                    this.logger.fatal("Negative responses are NOT supported with MCD 2.00.01 or earlier!");
                    return null;
                }
                response = this.addResponse(responses, this.dbLocationOfLogicalLink, pIsPositiveResponse);
            }
        }
        this.logger.trace("Leaving addResponse(...).");
        return response;
    }

    protected abstract AbstractJob.JobStatus addOutputParameters(MCDResponse var1);

    protected abstract AbstractJob.JobStatus readInputParameters(MCDRequestParameters var1);

    public final String getCurrentJobRuntimeAsString() {
        this.jobRuntime.setTime(System.currentTimeMillis() - this.jobStartTime);
        return traceTimeStampFormat.format(this.jobRuntime);
    }

    public final void setJobInfo(String pJobInfo) {
        String jobInfo = null;
        jobInfo = pJobInfo.replaceAll("[^\\p{ASCII}]", "?");
        try {
            this.jobApi.setJobInfo(this.logicalLink, (MCDDiagComPrimitive)this.job, jobInfo);
        }
        catch (MCDException mcde) {
            this.logger.warn("Error setting job info.");
            this.logger.logThrowable(mcde);
        }
    }

    public final void setJobProgress(long pJobProgress) {
        long jobProgress = 0L;
        if (pJobProgress < 0L) {
            this.logger.warn("Invalid job progress value of " + pJobProgress + "% has been reset to 0%.");
            jobProgress = 0L;
        } else if (pJobProgress > 100L) {
            this.logger.warn("Invalid job progress value of " + pJobProgress + "% has been limited to 100%.");
            jobProgress = 100L;
        } else {
            jobProgress = pJobProgress;
        }
        try {
            this.jobApi.setProgress(this.logicalLink, (MCDDiagComPrimitive)this.job, (short)jobProgress);
        }
        catch (MCDException mcde) {
            this.logger.warn("Error setting job progress.");
            this.logger.logThrowable(mcde);
        }
    }

    protected final void dumpAndSendFinalResult(MCDResult pResult) {
        this.logger.trace("Entering dumpAndSendFinalResult(...).");
        if (pResult == null) {
            this.logger.error("dumpAndSendFinalResult() called with null argument!");
            return;
        }
        if (this.logger.getLogLevel() >= 5) {
            try {
                this.mcdObjectDumper.dumpResult(pResult, 0, true);
                this.logger.flush();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error dumping result!");
                this.logger.logThrowable(mcde);
            }
        }
        try {
            this.logger.debug("Sending final result.");
            this.jobApi.sendFinalResult(pResult);
            this.logger.debug("Final result sent.");
        }
        catch (MCDException mcde) {
            this.logger.debug("Error sending final result!");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving dumpAndSendFinalResult(...).");
    }

    protected static final String getUsedMemory() {
        long totalMemory = 0L;
        long freeMemory = 0L;
        long usedMemory = 0L;
        totalMemory = javaRuntime.totalMemory();
        freeMemory = javaRuntime.freeMemory();
        usedMemory = (totalMemory - freeMemory) / 1024L;
        return usedMemory + " KiB";
    }

    protected final void logMemoryUsage() {
        this.logger.debug("Currently used memory   : " + AbstractJobImpl.getUsedMemory());
    }

    protected final void readJobProperties() {
        String logDirectoryName = null;
        File logDirectory = null;
        String logPropertyFileName = null;
        File jobPropertyFile = null;
        FileInputStream jobPropertyInputStream = null;
        this.jobProperties = new Properties();
        logDirectoryName = Logger.LOG_DIRECTORY_NAME;
        logDirectory = new File(logDirectoryName);
        if (!logDirectory.exists()) {
            if (Logger.LOG_DIRECTORY_NAME_DSA == null) {
                return;
            }
            logDirectoryName = Logger.LOG_DIRECTORY_NAME_DSA;
            logDirectory = new File(logDirectoryName);
            if (!logDirectory.exists()) {
                return;
            }
        }
        if (!(logPropertyFileName = logDirectoryName).endsWith(File.separator)) {
            logPropertyFileName = logPropertyFileName + File.separator;
        }
        if (!(jobPropertyFile = new File(logPropertyFileName = logPropertyFileName + "jobs.properties")).exists()) {
            return;
        }
        if (!jobPropertyFile.isFile()) {
            System.err.println("Job property file is not a regular file!");
            return;
        }
        if (!jobPropertyFile.canRead()) {
            System.err.println("Job property file is not readable!");
            return;
        }
        try {
            jobPropertyInputStream = new FileInputStream(jobPropertyFile);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Job property file not found!");
            return;
        }
        try {
            this.jobProperties.load(jobPropertyInputStream);
        }
        catch (IOException ioe) {
            System.err.println("Log property file is not a properties file or contains illegal characters!");
            return;
        }
    }

    static {
        traceTimeStampFormat = new SimpleDateFormat("H:mm:ss.SSS");
        traceTimeStampFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        javaRuntime = Runtime.getRuntime();
        maximumAvailableMemory = javaRuntime.maxMemory();
    }
}

