/*
 * Decompiled with CFR 0.152.
 */
package com.audi.joblibrary.uds.mcd201;

import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDException;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDResultState;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDValue;
import asam.job.SingleEcuJobTemplate;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;

public class MCD3_PreDataSetUDS
implements SingleEcuJobTemplate {
    private int m_Error = 0;
    String resultString;
    private int[] m_algorithm = new int[]{104, 9, 129, 74, 7, 135, 86, 87, 56, 82, 107, 5, 135, 169, 168, 199, 173, 73, 76};
    private PrintWriter m_outWriter = null;

    public void execute(MCDRequestParameters mCDRequestParameters, MCDJobApi mCDJobApi, MCDLogicalLink mCDLogicalLink, MCDSingleEcuJob mCDSingleEcuJob) throws MCDException {
        try {
            this.m_outWriter = new PrintWriter(new FileOutputStream(System.getProperty("user.home") + "\\" + this.getClass().getName() + ".log"));
            this.m_outWriter.print("started job \n");
            this.m_outWriter.flush();
            long l = mCDRequestParameters.getItemByName("IPA_Login").getValue().getUint32();
            long l2 = mCDRequestParameters.getItemByName("IPA_VWDevicNumbe").getValue().getUint32();
            long l3 = mCDRequestParameters.getItemByName("IPA_ImporNumbe").getValue().getUint32();
            long l4 = mCDRequestParameters.getItemByName("IPA_WorksNumbe").getValue().getUint32();
            long l5 = 0L;
            byte[] byArray = null;
            byArray = new byte[6];
            byArray[0] = (byte)((l2 <<= 3) >> 16 & 0xFFL);
            byArray[1] = (byte)(l2 >> 8 & 0xFFL);
            byArray[2] = (byte)l2;
            byArray[2] = (byte)(byArray[2] | (byte)((l3 <<= 1) >> 8) & 0xFF);
            byArray[3] = (byte)l3;
            byArray[3] = (byte)(byArray[3] | (byte)(l4 >> 16) & 0xFF);
            byArray[4] = (byte)(l4 >> 8 & 0xFFL);
            byArray[5] = (byte)l4;
            boolean bl = false;
            this.m_outWriter.print("starting StartDiagnSessi\n");
            MCDResult mCDResult = this.executeService1(mCDLogicalLink, "DiagnServi_DiagnSessiContrVWEndOfLineSessi", "Param_DiagnSessiType", "VW End Of Line (EoL)-Session");
            if (mCDResult != null) {
                this.m_outWriter.print("EOL Session abgeschickt");
            }
            this.m_outWriter.print("starting SecurAcces1-2 - send Key\n");
            bl = this.doSeedAndKey(mCDLogicalLink);
            this.resultString = bl ? "successfully done seed & key" : "error in seed & key";
            this.m_outWriter.flush();
            mCDResult = this.writeFingerprint(mCDLogicalLink, l2, l3, l4);
            this.m_Error = 0;
            this.setResult(mCDJobApi, mCDSingleEcuJob, mCDLogicalLink, 0L, this.m_Error);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_outWriter.print("catched file not found exception\n");
            this.m_outWriter.flush();
            this.m_outWriter.flush();
            this.m_Error = 2;
        }
        catch (Exception exception) {
            this.m_outWriter.print("catched exception\n");
            this.m_outWriter.flush();
            this.m_outWriter.print(exception.toString() + "\n");
            this.m_outWriter.flush();
            exception.printStackTrace(this.m_outWriter);
            MCDError mCDError = ((MCDException)((Object)exception)).getError();
            this.m_outWriter.print(mCDError.getCodeDescription() + "\n");
            this.m_outWriter.flush();
            this.m_outWriter.print(mCDError.getVendorCodeDescription() + "\n");
            this.m_outWriter.flush();
            this.m_Error = 1;
        }
        this.m_outWriter.print("end of execute\n");
        this.m_outWriter.flush();
        this.m_outWriter.close();
    }

    private void setResult(MCDJobApi mCDJobApi, MCDSingleEcuJob mCDSingleEcuJob, MCDLogicalLink mCDLogicalLink, long l, int n) {
        try {
            MCDResult mCDResult = mCDSingleEcuJob.createResult(1795, 49152, "", 0, "", 0);
            MCDResponses mCDResponses = mCDResult.getResponses();
            MCDResponse mCDResponse = mCDResponses.add(mCDLogicalLink.getDbObject().getDbLocation());
            MCDResponseParameters mCDResponseParameters = mCDResponse.getResponseParameters();
            MCDResponseParameter mCDResponseParameter = mCDResponseParameters.getItemByName("OPA_Resul");
            MCDValue mCDValue = mCDJobApi.createValue(11);
            mCDValue.setUint32((long)n);
            mCDResponseParameter.setValue(mCDValue);
            mCDJobApi.sendFinalResult(mCDResult);
        }
        catch (MCDException mCDException) {
            this.m_outWriter.print("exception\n");
        }
    }

    private MCDResult executeService0(MCDLogicalLink mCDLogicalLink, String string) {
        MCDResult mCDResult = null;
        MCDDiagComPrimitive mCDDiagComPrimitive = null;
        try {
            this.m_outWriter.print("trying to executeService " + string + "\n");
            mCDDiagComPrimitive = mCDLogicalLink.createDiagComPrimitiveByName(string);
            if (mCDDiagComPrimitive != null) {
                this.printPDUOfService(mCDDiagComPrimitive);
                mCDResult = mCDDiagComPrimitive.executeSync();
                if (mCDResult != null) {
                    this.printResponsePDU(mCDResult);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mCDResult;
    }

    private MCDResult executeService1(MCDLogicalLink mCDLogicalLink, String string, String string2, Object object) {
        if (string == null || string2 == null || object == null) {
            this.m_outWriter.print("executeService1: one of input params is null\n");
            return null;
        }
        MCDResult mCDResult = null;
        this.m_outWriter.print("trying to executeservice \"" + string + "\" with \"" + string2 + "\" set to \"" + object.toString() + "\"\n");
        MCDDiagComPrimitive mCDDiagComPrimitive = null;
        try {
            this.m_outWriter.print("trying to create diag com prim\n");
            mCDDiagComPrimitive = mCDLogicalLink.createDiagComPrimitiveByName(string);
            if (mCDDiagComPrimitive != null) {
                this.m_outWriter.print("trying to get request parameter\n");
                MCDRequestParameter mCDRequestParameter = mCDDiagComPrimitive.getRequest().getRequestParameters().getItemByName(string2);
                if (mCDRequestParameter != null) {
                    this.m_outWriter.print("trying to set parameter value\n");
                    if (this.setParameterValue(mCDRequestParameter, object)) {
                        this.printPDUOfService(mCDDiagComPrimitive);
                        this.m_outWriter.print("trying to executesync service\n");
                        mCDResult = mCDDiagComPrimitive.executeSync();
                        if (mCDResult != null) {
                            this.m_outWriter.print("execute Sync, fertig");
                            this.printResponsePDU(mCDResult);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.m_outWriter);
        }
        return mCDResult;
    }

    private MCDResult executeService3(MCDLogicalLink mCDLogicalLink, String string, String string2, Object object, String string3, Object object2, String string4, Object object3) {
        if (string == null || string2 == null || object == null || string3 == null || object2 == null || string4 == null || object3 == null) {
            this.m_outWriter.print("executeService3: one of input params is null\n");
            return null;
        }
        MCDResult mCDResult = null;
        this.m_outWriter.print("trying to executeservice \"" + string + "\" with \"" + string2 + "\" set to \"" + object.toString() + "\" , \"" + string3 + "\" set to \"" + object2.toString() + "\" , \"" + string4 + "\" set to \"" + object2.toString() + "\"\n");
        MCDDiagComPrimitive mCDDiagComPrimitive = null;
        try {
            this.m_outWriter.print("trying to create diag com prim\n");
            mCDDiagComPrimitive = mCDLogicalLink.createDiagComPrimitiveByName(string);
            if (mCDDiagComPrimitive != null) {
                this.m_outWriter.print("trying to get request parameters\n");
                MCDRequestParameters mCDRequestParameters = mCDDiagComPrimitive.getRequest().getRequestParameters();
                if (mCDRequestParameters != null) {
                    this.m_outWriter.print("trying to get request parameter1\n");
                    MCDRequestParameter mCDRequestParameter = mCDRequestParameters.getItemByName(string2);
                    if (mCDRequestParameter != null) {
                        this.m_outWriter.print("trying to set parameter1 value\n");
                        if (this.setParameterValue(mCDRequestParameter, object)) {
                            this.m_outWriter.print("trying to get request parameter2\n");
                            MCDRequestParameter mCDRequestParameter2 = mCDRequestParameters.getItemByName(string3);
                            if (mCDRequestParameter2 != null) {
                                this.m_outWriter.print("trying to set parameter2 value\n");
                                if (this.setParameterValue(mCDRequestParameter2, object2)) {
                                    this.m_outWriter.print("trying to get request parameter3\n");
                                    MCDRequestParameter mCDRequestParameter3 = mCDRequestParameters.getItemByName(string4);
                                    if (mCDRequestParameter3 != null) {
                                        this.m_outWriter.print("trying to set parameter3 value\n");
                                        if (this.setParameterValue(mCDRequestParameter3, object3)) {
                                            this.printPDUOfService(mCDDiagComPrimitive);
                                            this.m_outWriter.print("trying to executesync service\n");
                                            mCDResult = mCDDiagComPrimitive.executeSync();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.m_outWriter);
        }
        return mCDResult;
    }

    private boolean setParameterValue(MCDRequestParameter mCDRequestParameter, Object object) throws MCDException {
        this.m_outWriter.print("enter setParameterValue\n");
        boolean bl = false;
        if (mCDRequestParameter != null && object != null) {
            this.m_outWriter.print("getting mcdvalue\n");
            MCDValue mCDValue = mCDRequestParameter.getValue();
            this.m_outWriter.print("checking parameter type\n");
            if (object instanceof String) {
                this.m_outWriter.print("setting unicode value\n");
                mCDValue.setAsciistring((String)object);
                this.m_outWriter.print("setting value to parameter \n");
                mCDRequestParameter.setValue(mCDValue);
                bl = true;
            } else if (object instanceof Long) {
                this.m_outWriter.print("setting long \n");
                Long l = (Long)object;
                mCDValue.setUint32(l.longValue());
                this.m_outWriter.print("setting value to parameter \n");
                mCDRequestParameter.setValue(mCDValue);
                bl = true;
            } else if (object instanceof LinkedList) {
                this.m_outWriter.print("setting bytefield \n");
                LinkedList linkedList = (LinkedList)object;
                byte[] byArray = new byte[linkedList.size()];
                for (int i = 0; i < linkedList.size(); ++i) {
                    this.m_outWriter.print("setting byte " + Integer.toString(i) + " \n");
                    byArray[i] = ((Integer)linkedList.get(i)).byteValue();
                }
                this.m_outWriter.print("got bytefield from bytelist \n");
                mCDValue.setBytefield(byArray);
                this.m_outWriter.print("setting value to parameter \n");
                mCDRequestParameter.setValue(mCDValue);
                bl = true;
            } else {
                this.m_outWriter.print("cannot cast parameter in setParameterValue\n");
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkResult1(MCDResult mCDResult, String string, Object object) throws MCDException, Exception {
        boolean bl = false;
        if (mCDResult == null) return false;
        if (string == null) {
            return false;
        }
        this.m_outWriter.print("checkResult1, \"" + string + "\" should be \"" + object.toString() + "\"\n");
        if (mCDResult != null) {
            if (mCDResult.hasError()) {
                this.m_outWriter.print("result has Error\n");
                MCDError mCDError = mCDResult.getError();
                this.m_outWriter.print("err: " + mCDError.getCodeDescription() + " , " + mCDError.getVendorCodeDescription() + "\n");
            } else {
                MCDResultState mCDResultState = mCDResult.getResultState();
                if (mCDResultState != null && mCDResultState.getExecutionState() == 25345) {
                    Object object2 = this.getResultParameter(mCDResult, string);
                    if (object2 != null) {
                        if (object instanceof String) {
                            this.m_outWriter.print("before string comparison\n");
                            this.m_outWriter.flush();
                            if (((String)object2).equals((String)object)) {
                                bl = true;
                                this.m_outWriter.print("string comparison was successfull \n");
                                this.m_outWriter.flush();
                            } else {
                                this.m_outWriter.print("found parameter does not match expected value, it is\"" + object2.toString() + "\"\n");
                                this.m_outWriter.flush();
                            }
                        } else if (object instanceof Long) {
                            Long l = (Long)object;
                            if (l.equals(object2)) {
                                bl = true;
                            } else {
                                this.m_outWriter.print("found parameter does not match expected value, it is\"" + object2.toString() + "\"\n");
                            }
                        } else {
                            if (!(object instanceof LinkedList)) throw new Exception("internal error: no handler for " + object.getClass().getName());
                            this.m_outWriter.print("compare expected and found bytefield\n");
                            LinkedList linkedList = (LinkedList)object;
                            LinkedList linkedList2 = (LinkedList)object2;
                            if (linkedList2.equals(linkedList)) {
                                bl = true;
                            } else {
                                this.m_outWriter.print("found parameter does not match expected value, it is\"" + linkedList2.toString() + "\"\n");
                            }
                        }
                    } else {
                        this.m_outWriter.print("parameter \"" + string + "\" not found in response\n");
                    }
                } else {
                    this.m_outWriter.print("resultState is not eOK");
                }
            }
        } else {
            this.m_outWriter.print("result is null");
        }
        if (bl) {
            this.m_outWriter.print("service executed successfully\n");
        } else {
            this.m_outWriter.print("service executed NOT successfully\n");
        }
        this.m_outWriter.flush();
        return bl;
    }

    private Object getResultParameter(MCDResult mCDResult, String string) throws MCDException, Exception {
        if (mCDResult == null || string == null) {
            return null;
        }
        LinkedList<Integer> linkedList = null;
        MCDResponses mCDResponses = mCDResult.getResponses();
        int n = 0;
        while ((long)n < mCDResponses.getCount()) {
            MCDResponse mCDResponse = mCDResponses.getItemByIndex((long)n);
            MCDResponseParameters mCDResponseParameters = mCDResponse.getResponseParameters();
            int n2 = 0;
            while ((long)n2 < mCDResponseParameters.getCount()) {
                MCDResponseParameter mCDResponseParameter = mCDResponseParameters.getItemByIndex((long)n2);
                if (string.equals(mCDResponseParameter.getShortName())) {
                    Object object;
                    this.m_outWriter.print("found parameter\n");
                    int n3 = mCDResponseParameter.getType();
                    if (n3 == 1 || n3 == 14 || n3 == 18) {
                        linkedList = mCDResponseParameter.getValue().getAsciistring();
                    } else if (n3 == 3) {
                        object = mCDResponseParameter.getValue().getBytefield();
                        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
                        for (int i = 0; i < ((byte[])object).length; ++i) {
                            linkedList2.add(new Integer(object[i]));
                        }
                        linkedList = linkedList2;
                    } else if (n3 == 11) {
                        object = new Long(mCDResponseParameter.getValue().getUint32());
                        linkedList = (LinkedList<Integer>)object;
                    } else {
                        throw new Exception("cannot map datatype " + Integer.toString(n3) + " in param " + string + "\n");
                    }
                }
                ++n2;
            }
            ++n;
        }
        return linkedList;
    }

    private byte[] getSeedFromResult(MCDResult mCDResult) throws MCDException {
        this.m_outWriter.print("starting getSeedFromResult\n");
        if (mCDResult == null) {
            return null;
        }
        byte[] byArray = null;
        if (mCDResult != null && !mCDResult.hasError()) {
            MCDResponses mCDResponses = mCDResult.getResponses();
            int n = 0;
            while ((long)n < mCDResponses.getCount()) {
                this.m_outWriter.print("get response number " + Integer.toString(n) + "\n");
                MCDResponse mCDResponse = mCDResponses.getItemByIndex((long)n);
                MCDResponseParameters mCDResponseParameters = mCDResponse.getResponseParameters();
                MCDResponseParameter mCDResponseParameter = mCDResponseParameters.getItemByName("Param_SecurAccesSeed");
                if (mCDResponseParameter != null) {
                    this.m_outWriter.print("Param_SecurAccesSeed is not null\n");
                    int n2 = mCDResponseParameter.getType();
                    if (n2 == 11) {
                        this.m_outWriter.print("seed is of type uint\n");
                        MCDValue mCDValue = mCDResponseParameter.getValue();
                        if (mCDValue != null) {
                            this.m_outWriter.print("have value from seed\n");
                            long l = mCDValue.getUint32();
                            byArray = new byte[]{(byte)((l & 0xFF000000L) >> 24 & 0xFFL), (byte)((l & 0xFF0000L) >> 16 & 0xFFL), (byte)((l & 0xFF00L) >> 8 & 0xFFL), (byte)(l & 0xFFL & 0xFFL)};
                        }
                    }
                }
                ++n;
            }
        } else {
            this.m_outWriter.print("result with seed has error\n");
            MCDError mCDError = mCDResult.getError();
            if (mCDError != null) {
                this.m_outWriter.print("Error.Code = " + Integer.toString(mCDError.getCode()) + "\n");
                this.m_outWriter.print("Error.CodeDescription = " + mCDError.getCodeDescription() + "\n");
                this.m_outWriter.print("Error.VendorCodeDescription = " + mCDError.getVendorCodeDescription() + "\n");
            }
        }
        return byArray;
    }

    private byte[] getSeedFromResultLong(MCDResult mCDResult) throws MCDException {
        this.m_outWriter.print("starting getSeedFromResult\n");
        byte[] byArray = null;
        try {
            if (mCDResult != null && !mCDResult.hasError()) {
                MCDResponses mCDResponses = mCDResult.getResponses();
                int n = 0;
                while ((long)n < mCDResponses.getCount()) {
                    this.m_outWriter.print("get response number " + Long.toString(mCDResponses.getCount()) + "\n");
                    MCDResponse mCDResponse = mCDResponses.getItemByIndex((long)n);
                    MCDResponseParameters mCDResponseParameters = mCDResponse.getResponseParameters();
                    MCDResponseParameter mCDResponseParameter = mCDResponseParameters.getItemByName("Param_SecurAccesSeed");
                    MCDValue mCDValue = mCDResponseParameter.getValue();
                    byArray = mCDValue.getBytefield();
                    ++n;
                }
            } else {
                this.m_outWriter.print("result with seed has error\n");
                MCDError mCDError = mCDResult.getError();
                if (mCDError != null) {
                    this.m_outWriter.print("Error.Code = " + Integer.toString(mCDError.getCode()) + "\n");
                    this.m_outWriter.print("Error.CodeDescription = " + mCDError.getCodeDescription() + "\n");
                    this.m_outWriter.print("Error.VendorCodeDescription = " + mCDError.getVendorCodeDescription() + "\n");
                }
            }
        }
        catch (MCDException mCDException) {
            mCDException.printStackTrace(this.m_outWriter);
            this.m_outWriter.print("\n");
        }
        return byArray;
    }

    private void printPDUOfService(MCDDiagComPrimitive mCDDiagComPrimitive) {
        try {
            MCDValue mCDValue;
            MCDRequest mCDRequest;
            this.m_outWriter.print("in printPDUOfService\n");
            if (mCDDiagComPrimitive != null && (mCDRequest = mCDDiagComPrimitive.getRequest()) != null && (mCDValue = mCDRequest.getPDU()) != null) {
                this.m_outWriter.print("request pdu: ");
                byte[] byArray = mCDValue.getBytefield();
                this.m_outWriter.print("Length = " + Integer.toHexString(byArray.length));
                for (int i = 0; i < byArray.length; ++i) {
                    this.m_outWriter.print("PDU " + Integer.toHexString(byArray[i] & 0xFF));
                    if (i + 1 >= byArray.length) continue;
                    this.m_outWriter.print(", ");
                }
                this.m_outWriter.print("\n");
            }
        }
        catch (MCDException mCDException) {
            mCDException.printStackTrace(this.m_outWriter);
            this.m_outWriter.print("\n");
        }
    }

    private void printResponsePDU(MCDResult mCDResult) {
        try {
            this.m_outWriter.print("in printResponsePDU\n");
            if (mCDResult != null) {
                if (mCDResult.hasError()) {
                    this.m_outWriter.print("result has error\n");
                } else {
                    MCDValue mCDValue;
                    MCDResponse mCDResponse;
                    MCDResponses mCDResponses = mCDResult.getResponses();
                    if (mCDResponses != null && (mCDResponse = mCDResponses.getItemByIndex(0L)) != null && (mCDValue = mCDResponse.getResponseMessage()) != null) {
                        this.m_outWriter.print("response pdu: ");
                        byte[] byArray = mCDValue.getBytefield();
                        for (int i = 0; i < byArray.length; ++i) {
                            this.m_outWriter.print(Integer.toHexString(byArray[i] & 0xFF));
                            if (i + 1 >= byArray.length) continue;
                            this.m_outWriter.print(", ");
                        }
                        this.m_outWriter.print("\n");
                    }
                }
            }
        }
        catch (MCDException mCDException) {
            mCDException.printStackTrace(this.m_outWriter);
            this.m_outWriter.print("\n");
        }
    }

    private MCDResult writeFingerprint(MCDLogicalLink mCDLogicalLink, long l, long l2, long l3) throws MCDException {
        if (mCDLogicalLink == null) {
            return null;
        }
        MCDResult mCDResult = null;
        String string = "DiagnServi_WriteDataByIdentECUIdent";
        this.m_outWriter.print("trying to executeService " + string + "\n");
        MCDDiagComPrimitive mCDDiagComPrimitive = mCDLogicalLink.createDiagComPrimitiveByName(string);
        if (mCDDiagComPrimitive != null) {
            this.m_outWriter.print("created diagcomprim\n");
            MCDRequestParameters mCDRequestParameters = mCDDiagComPrimitive.getRequest().getRequestParameters();
            if (mCDRequestParameters != null) {
                this.m_outWriter.print("got request parameters\n");
                MCDRequestParameter mCDRequestParameter = mCDRequestParameters.getItemByName("Param_RecorDataIdent");
                if (mCDRequestParameter != null) {
                    this.m_outWriter.print("got fingerprint key\n");
                    boolean bl = this.setParameterValue(mCDRequestParameter, "Repair Shop Code Or Tester Serial Number");
                    if (bl) {
                        this.m_outWriter.print("Bin drin!\n");
                        MCDRequestParameter mCDRequestParameter2 = mCDRequestParameters.getItemByName("Param_DataRecor");
                        if (mCDRequestParameter2 != null) {
                            this.m_outWriter.print("2\n");
                            MCDRequestParameters mCDRequestParameters2 = mCDRequestParameter2.getParameters();
                            if (mCDRequestParameters2 != null) {
                                this.m_outWriter.print("3\n");
                                this.m_outWriter.print("successfully set fingerprint key\n");
                                MCDRequestParameter mCDRequestParameter3 = mCDRequestParameters2.getItemByName("TABROW_RepaiShopCodeOrTesteSeriaNumbe");
                                if (mCDRequestParameter3 != null) {
                                    this.m_outWriter.print("4\n");
                                    this.m_outWriter.print("got struct param\n");
                                    MCDRequestParameters mCDRequestParameters3 = mCDRequestParameter3.getParameters();
                                    if (mCDRequestParameters3 != null) {
                                        this.m_outWriter.print("5\n");
                                        this.m_outWriter.print("got inner params of struct\n");
                                        MCDRequestParameter mCDRequestParameter4 = mCDRequestParameters3.getItemByName("Param_VWDevicNumbe");
                                        if (mCDRequestParameter4 != null) {
                                            bl = this.setParameterValue(mCDRequestParameter4, new Long(l));
                                        }
                                        if ((mCDRequestParameter4 = mCDRequestParameters3.getItemByName("Param_ImporNumbe")) != null) {
                                            bl = this.setParameterValue(mCDRequestParameter4, new Long(l2));
                                        }
                                        if ((mCDRequestParameter4 = mCDRequestParameters3.getItemByName("Param_WorksNumbe")) != null) {
                                            bl = this.setParameterValue(mCDRequestParameter4, new Long(l3));
                                        }
                                        if (bl) {
                                            this.printPDUOfService(mCDDiagComPrimitive);
                                            mCDResult = mCDDiagComPrimitive.executeSync();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return mCDResult;
    }

    private boolean doSeedAndKey(MCDLogicalLink mCDLogicalLink) throws MCDException, Exception {
        boolean bl = false;
        long l = 20762L;
        this.m_outWriter.print("starting SecurAcces1 - request Seed\n");
        MCDResult mCDResult = this.executeService0(mCDLogicalLink, "DiagnServi_SecurAccesRequeSeedLogin");
        if (mCDResult != null) {
            byte[] byArray = this.getSeedFromResult(mCDResult);
            this.m_outWriter.print("nach getSeedFromResult!");
            l = this.calcKeyFromSeed(mCDLogicalLink, byArray);
            this.m_outWriter.print("calcKeyFromSeed");
            if (l != 0L) {
                LinkedList<Integer> linkedList = new LinkedList<Integer>();
                linkedList.add(new Integer((int)l >> 24 & 0xFF));
                linkedList.add(new Integer((int)l >> 16 & 0xFF));
                linkedList.add(new Integer((int)l >> 8 & 0xFF));
                linkedList.add(new Integer((int)l & 0xFF));
                this.m_outWriter.print(" " + Integer.toString((int)l >> 24 & 0xFF) + " " + Integer.toString((int)l >> 16 & 0xFF) + " " + Integer.toString((int)l >> 8 & 0xFF) + " " + Integer.toString((int)l & 0xFF));
                mCDResult = this.executeService1(mCDLogicalLink, "DiagnServi_SecurAccesSendKeyLogin", "Param_SecurAccesKey", new Long(l & 0xFFFFFFFFL));
                if (mCDResult != null) {
                    MCDResponse mCDResponse = mCDResult.getResponses().getItemByIndex(0L);
                    if (mCDResponse.getState() == 26625) {
                        bl = true;
                        this.m_outWriter.print("seed and key was successfull\n");
                    } else {
                        bl = false;
                        this.m_outWriter.print("seed and key was NOT successfull\n");
                    }
                }
            }
        }
        return bl;
    }

    private long calcKeyFromSeed(MCDLogicalLink mCDLogicalLink, byte[] byArray) throws MCDException {
        long l = 0L;
        if (byArray.length == 4) {
            this.m_outWriter.print("Starting calcKeyFromSeed with seed=" + this.ByteArrayToString(byArray) + ", algorithm=" + this.IntArrayToString(this.m_algorithm) + "\n");
            MCDDiagComPrimitive mCDDiagComPrimitive = mCDLogicalLink.createDiagComPrimitiveByName("SinglJob_SecurAccesJobDataSet");
            MCDRequest mCDRequest = mCDDiagComPrimitive.getRequest();
            MCDRequestParameters mCDRequestParameters = mCDRequest.getRequestParameters();
            MCDRequestParameter mCDRequestParameter = mCDRequestParameters.getItemByName("IPA_Seed");
            MCDValue mCDValue = mCDRequestParameter.getValue();
            mCDValue.setBytefield(byArray);
            mCDRequestParameter.setValue(mCDValue);
            MCDRequestParameter mCDRequestParameter2 = mCDRequestParameters.getItemByName("IPA_Algor");
            MCDValue mCDValue2 = mCDRequestParameter2.getValue();
            byte[] byArray2 = this.IntArrayToByteArray(this.m_algorithm);
            mCDValue2.setBytefield(byArray2);
            mCDRequestParameter2.setValue(mCDValue2);
            this.m_outWriter.print("trying to execute security access job\n");
            MCDResult mCDResult = mCDDiagComPrimitive.executeSync();
            this.m_outWriter.print("done executing security access job\n");
            if (mCDResult != null) {
                this.m_outWriter.print("trying to get the result of the securityAccessJob\n");
                MCDResponses mCDResponses = mCDResult.getResponses();
                MCDResponse mCDResponse = mCDResponses.getItemByIndex(0L);
                MCDResponseParameters mCDResponseParameters = mCDResponse.getResponseParameters();
                MCDResponseParameter mCDResponseParameter = mCDResponseParameters.getItemByName("OPA_Key");
                MCDValue mCDValue3 = mCDResponseParameter.getValue();
                l = mCDValue3.getUint32();
                this.m_outWriter.print("key = " + Long.toHexString(l) + "\n");
            } else {
                this.m_outWriter.print("result of SecAccessJob = null\n");
            }
        }
        return l;
    }

    private String ByteArrayToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(40);
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append("0x");
                stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
                if (i + 1 >= byArray.length) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    private String IntArrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(40);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append("0x");
                stringBuffer.append(Integer.toHexString(nArray[i]));
                if (i + 1 >= nArray.length) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    private byte[] IntArrayToByteArray(int[] nArray) {
        byte[] byArray = null;
        byArray = new byte[19];
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)nArray[i];
            }
        }
        return byArray;
    }
}

