/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.util.dserver.impl;

import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDiagTroubleCode;
import asam.d.MCDDbFlashJob;
import asam.d.MCDDbFlashSession;
import asam.d.MCDDbIdentDescription;
import asam.d.MCDDbLocation;
import asam.d.MCDDbParameter;
import asam.d.MCDDbRequestParameter;
import asam.d.MCDDbResponseParameter;
import asam.d.MCDException;
import asam.d.MCDInterval;
import asam.d.MCDParameter;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponseParameter;
import asam.d.MCDTextTableElement;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import com.audi.mcd.joblibrary.util.dserver.VendorSpecific;
import com.audi.mcd.joblibrary.util.logging.Logger;
import com.softing.dts.DtsDbResponseParameter;
import com.softing.dts.DtsTextTableElements;

public abstract class VendorSpecificImpl
extends VendorSpecific {
    protected Logger logger = null;

    public VendorSpecificImpl(Logger pLogger) {
        this.logger = pLogger;
    }

    public int determineResponseStateFromPdus(byte[] pRequestPdu, byte[] pResponsePdu) {
        byte requestServiceIdentifier = 0;
        byte firstByteOfResponsePdu = 0;
        byte expectedResponseServiceIdentifier = 0;
        this.logger.trace("Entering determineResponseStateFromPdus(...).");
        requestServiceIdentifier = pRequestPdu[0];
        firstByteOfResponsePdu = pResponsePdu[0];
        if (firstByteOfResponsePdu == 127) {
            this.logger.debug("Response is negative.");
            return 26626;
        }
        expectedResponseServiceIdentifier = (byte)(requestServiceIdentifier + 64);
        if (firstByteOfResponsePdu == expectedResponseServiceIdentifier) {
            this.logger.debug("Response is positive.");
            return 26625;
        }
        this.logger.error("Error determining response state of current response!");
        this.logger.trace("Leaving determineResponseStateFromPdus(...).");
        return 0;
    }

    public long getCodedValueUint32OfTextTableParameterByLongName(MCDParameter pParameter, String pLongName) throws IllegalArgumentException {
        MCDTextTableElement textTableElement = null;
        MCDInterval interval = null;
        int lowerLimitIntervalType = -1;
        int upperLimitIntervalType = -1;
        MCDValue value_lowerLimit = null;
        MCDValue value_upperLimit = null;
        int lowerLimitDataType = -1;
        int upperLimitDataType = -1;
        long lowerLimit = 0L;
        long upperLimit = 0L;
        textTableElement = this.getTextTableElementOfParameterByLongName(pParameter, pLongName);
        if (textTableElement == null) {
            throw new IllegalArgumentException("Error getting text table element for the given parameter and LONG-NAME (VT): " + pLongName);
        }
        try {
            interval = textTableElement.getInterval();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting interval of text table element (probably the COMPU-DEFAULT-VALUE).");
            if (mcde.getError().getCode() != 57362) {
                this.logger.logThrowable(mcde);
            }
            throw new IllegalArgumentException("Error getting interval of text table element (probably the COMPU-DEFAULT-VALUE).");
        }
        try {
            lowerLimitIntervalType = interval.getLowerLimitIntervalType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting INTERVAL-TYPE of LOWER-LIMIT of text table element.");
            this.logger.logThrowable(mcde);
            throw new IllegalArgumentException("Error getting INTERVAL-TYPE of LOWER-LIMIT of text table element.");
        }
        try {
            upperLimitIntervalType = interval.getUpperLimitIntervalType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting INTERVAL-TYPE of UPPER-LIMIT of text table element.");
            this.logger.logThrowable(mcde);
            throw new IllegalArgumentException("Error getting INTERVAL-TYPE of UPPER-LIMIT of text table element.");
        }
        try {
            value_lowerLimit = interval.getLowerLimit();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting value of LOWER-LIMIT of text table element.");
            this.logger.logThrowable(mcde);
            throw new IllegalArgumentException("Error getting value of LOWER-LIMIT of text table element.");
        }
        try {
            value_upperLimit = interval.getUpperLimit();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting value of UPPER-LIMIT of text table element.");
            this.logger.logThrowable(mcde);
            throw new IllegalArgumentException("Error getting value of UPPER-LIMIT of text table element.");
        }
        if (lowerLimitDataType == -1) {
            try {
                lowerLimitDataType = value_lowerLimit.getDataType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting data type of value of LOWER-LIMIT of text table element.");
                this.logger.logThrowable(mcde);
                throw new IllegalArgumentException("Error getting data type of value of LOWER-LIMIT of text table element.");
            }
            if (lowerLimitDataType != 11) {
                this.logger.error("The data type of value of LOWER-LIMIT (" + McdEnumDecoder.decodeMcdDataType(lowerLimitDataType) + ") of the text table element does not match the expected data type " + McdEnumDecoder.decodeMcdDataType(11) + "!");
                throw new IllegalArgumentException("The data type of value of LOWER-LIMIT (" + McdEnumDecoder.decodeMcdDataType(lowerLimitDataType) + ") of the text table element does not match the expected data type " + McdEnumDecoder.decodeMcdDataType(11) + "!");
            }
        }
        if (upperLimitDataType == -1) {
            try {
                upperLimitDataType = value_upperLimit.getDataType();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting data type of value of UPPER-LIMIT of text table element.");
                this.logger.logThrowable(mcde);
                throw new IllegalArgumentException("Error getting data type of value of UPPER-LIMIT of text table element.");
            }
            if (upperLimitDataType != 11) {
                this.logger.error("The data type of value of UPPER-LIMIT (" + McdEnumDecoder.decodeMcdDataType(upperLimitDataType) + ") of the text table element does not match the expected data type " + McdEnumDecoder.decodeMcdDataType(11) + "!");
                throw new IllegalArgumentException("The data type of value of UPPER-LIMIT (" + McdEnumDecoder.decodeMcdDataType(upperLimitDataType) + ") of the text table element does not match the expected data type " + McdEnumDecoder.decodeMcdDataType(11) + "!");
            }
        }
        try {
            lowerLimit = value_lowerLimit.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UINT32 value of LOWER-LIMIT of text table element.");
            this.logger.logThrowable(mcde);
            throw new IllegalArgumentException("Error getting UINT32 value of LOWER-LIMIT of text table element.");
        }
        try {
            upperLimit = value_upperLimit.getUint32();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting UINT32 value of UPPER-LIMIT of text table element.");
            this.logger.logThrowable(mcde);
            throw new IllegalArgumentException("Error getting UINT32 value of UPPER-LIMIT of text table element.");
        }
        if (lowerLimitIntervalType == 27906 && upperLimitIntervalType == 27906 && lowerLimit == upperLimit) {
            return lowerLimit;
        }
        throw new IllegalArgumentException("The values or INTERVAL-TYPEs of the LOWER- or UPPER-LIMIT of the text table element do not match the expected values!");
    }

    public MCDDbDataPrimitive getDbDataPrimitiveOfDbIdentDescription(MCDDbIdentDescription pDbIdentDescription, MCDDbLocation pDbLocation) throws MCDException {
        return pDbIdentDescription.getDbDataPrimitive();
    }

    public MCDDbFlashJob getDbFlashJobOfDbFlashSession(MCDDbFlashSession pDbFlashSession, MCDDbLocation pDbLocation) throws MCDException {
        return pDbFlashSession.getDbFlashJob();
    }

    public String getLongNameIDOfDbDiagTroubleCode(MCDDbDiagTroubleCode pDbDiagTroubleCode) {
        String ti = null;
        this.logger.trace("Entering getLongNameIDOfDbDiagTroubleCode(...).");
        try {
            ti = pDbDiagTroubleCode.getLongNameID();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting TI of TEXT of dbDiagTroubleCode!");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving getLongNameIDOfDbDiagTroubleCode(...).");
        return ti;
    }

    public String getLongNameIDOfDbUnitOfParameter(MCDParameter pParameter) {
        MCDDbRequestParameter dbRequestParameter = null;
        MCDDbResponseParameter dbResponseParameter = null;
        String longNameID = null;
        this.logger.trace("Entering getLongNameIDOfDbUnitOfParameter(...).");
        if (pParameter instanceof MCDRequestParameter) {
            try {
                dbRequestParameter = (MCDDbRequestParameter)pParameter.getDbObject();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting dbObject of dbRequestParameter!");
                this.logger.logThrowable(mcde);
            }
            this.logger.trace("getLongNameIDOfDbUnitOfDbParameter(dbRequestParameter).");
            longNameID = this.getLongNameIDOfDbUnitOfDbParameter((MCDDbParameter)dbRequestParameter);
        } else if (pParameter instanceof MCDResponseParameter) {
            try {
                dbResponseParameter = (MCDDbResponseParameter)pParameter.getDbObject();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting dbObject of dbResponseParameter!");
                this.logger.logThrowable(mcde);
            }
            this.logger.trace("getLongNameIDOfDbUnitOfDbParameter( dbResponseParameter ).");
            longNameID = this.getLongNameIDOfDbUnitOfDbParameter((MCDDbParameter)dbResponseParameter);
        }
        this.logger.trace("Leaving getLongNameIDOfDbUnitOfParameter(...).");
        return longNameID;
    }

    public String getLongNameIDOfTextTableParameterValue(MCDParameter pParameter, String pLongName) throws IllegalArgumentException {
        String longNameID;
        block3: {
            MCDTextTableElement textTableElement = null;
            longNameID = null;
            this.logger.trace("Entering getLongNameIDOfTextTableElement(...).");
            textTableElement = this.getTextTableElementOfParameterByLongName(pParameter, pLongName);
            if (textTableElement == null) {
                return null;
            }
            try {
                longNameID = textTableElement.getLongNameID();
            }
            catch (MCDException mcde) {
                if (this.logger.getLogLevel() < 6 && mcde.getError().getCode() == 57362) break block3;
                this.logger.debug("Error getting TI of text table element with VT \"" + pLongName + "\"!");
                this.logger.logThrowable(mcde);
            }
        }
        this.logger.trace("Leaving getLongNameIDOfTextTableElement(...).");
        return longNameID;
    }

    public MCDRequestParameter getTableStructParameterByTableKeyValue(MCDRequestParameters pRequestParameters, String pShortNameOfTableStructParameter, String pStringValueOfTableKey) throws MCDException {
        MCDRequestParameter requestParameterTableStruct = null;
        this.logger.trace("Entering getTableStructParameterByTableKeyValue(...).");
        requestParameterTableStruct = pRequestParameters.getItemByName(pShortNameOfTableStructParameter);
        this.logger.trace("Leaving getTableStructParameterByTableKeyValue(...).");
        return requestParameterTableStruct;
    }

    public MCDTextTableElement getTextTableElementOfDbParameterByCodedValueUint32(MCDDbParameter pDbParameter, long pCodedValueUint32) {
        MCDTextTableElements textTableElements = null;
        MCDTextTableElement textTableElement = null;
        this.logger.trace("Entering getTextTableElementOfDbParameterByCodedValueUint32(...).");
        textTableElements = this.getTextTableElementsOfDbParameter(pDbParameter);
        if (textTableElements != null) {
            textTableElement = this.getTextTableElementByCodedValueUint32(textTableElements, pCodedValueUint32);
        }
        this.logger.trace("Leaving getTextTableElementOfDbParameterByCodedValueUint32(...).");
        return textTableElement;
    }

    public MCDTextTableElement getTextTableElementOfDbParameterByLongName(MCDDbParameter pDbParameter, String pLongName) {
        MCDTextTableElements textTableElements = null;
        MCDTextTableElement textTableElement = null;
        this.logger.trace("Entering getTextTableElementOfDbParameterByLongName(...).");
        textTableElements = this.getTextTableElementsOfDbParameter(pDbParameter);
        if (textTableElements != null) {
            textTableElement = this.getTextTableElementByLongName(textTableElements, pLongName);
        }
        this.logger.trace("Leaving getTextTableElementOfDbParameterByLongName(...).");
        return textTableElement;
    }

    public MCDTextTableElement getTextTableElementOfParameterByCodedValueUint32(MCDParameter pParameter, long pCodedValueUint32) {
        MCDTextTableElements textTableElements = null;
        MCDTextTableElement textTableElement = null;
        this.logger.trace("Entering getTextTableElementOfParameterByCodedValueUint32(...).");
        textTableElements = this.getTextTableElementsOfParameter(pParameter);
        if (textTableElements != null) {
            textTableElement = this.getTextTableElementByCodedValueUint32(textTableElements, pCodedValueUint32);
        }
        this.logger.trace("Leaving getTextTableElementOfParameterByCodedValueUint32(...).");
        return textTableElement;
    }

    public MCDTextTableElement getTextTableElementOfParameterByLongName(MCDParameter pParameter, String pLongName) {
        MCDTextTableElements textTableElements = null;
        MCDTextTableElement textTableElement = null;
        this.logger.trace("Entering getTextTableElementOfParameterByLongName(...).");
        textTableElements = this.getTextTableElementsOfParameter(pParameter);
        if (textTableElements != null) {
            textTableElement = this.getTextTableElementByLongName(textTableElements, pLongName);
        }
        this.logger.trace("Leaving getTextTableElementOfParameterByLongName(...).");
        return textTableElement;
    }

    public MCDTextTableElements getTextTableElementsOfDbParameter(MCDDbParameter pDbParameter) {
        int parameterType = 0;
        MCDDbRequestParameter dbRequestParameter = null;
        MCDDbResponseParameter dbResponseParameter = null;
        MCDTextTableElements textTableElements = null;
        this.logger.trace("Entering getTextTableElementsOfDbParameter(...).");
        try {
            parameterType = pDbParameter.getParameterType();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting type of parameter.");
            this.logger.logThrowable(mcde);
            return null;
        }
        if (parameterType != 18 && parameterType != 25) {
            throw new IllegalArgumentException("getTextTableElementsOfDbParameter() may only be called for parameters of type eTEXTTABLE/eKEY... detected parameter type: " + McdEnumDecoder.decodeMcdDataType(parameterType));
        }
        if (pDbParameter instanceof MCDDbRequestParameter) {
            dbRequestParameter = (MCDDbRequestParameter)pDbParameter;
            try {
                textTableElements = dbRequestParameter.getTextTableElements();
            }
            catch (MCDException mcde) {
                this.logger.debug("Error getting text table elements of data base parameter!");
                this.logger.logMcdError(mcde.getError());
            }
        } else if (pDbParameter instanceof MCDDbResponseParameter) {
            dbResponseParameter = (MCDDbResponseParameter)pDbParameter;
            textTableElements = this.getTextTableElementsOfDbResponseParameter(dbResponseParameter);
        }
        this.logger.trace("Leaving getTextTableElementsOfDbParameter(...).");
        return textTableElements;
    }

    public MCDTextTableElements getTextTableElementsOfDbResponseParameter(MCDDbResponseParameter pDbResponseParameter) {
        DtsDbResponseParameter dbResponseParameter = null;
        DtsTextTableElements textTableElements = null;
        this.logger.trace("Entering getTextTableElementsOfDbResponseParameter(...).");
        try {
            dbResponseParameter = (DtsDbResponseParameter)pDbResponseParameter;
        }
        catch (ClassCastException cce) {
            this.logger.debug("Error casting parameter to implementation class!");
            this.logger.logThrowable(cce);
            return null;
        }
        try {
            textTableElements = dbResponseParameter.getTextTableElements();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting text table elements of data base parameter!");
            this.logger.logMcdError(mcde.getError());
        }
        this.logger.trace("Leaving getTextTableElementsOfDbResponseParameter(...).");
        return textTableElements;
    }

    public MCDTextTableElements getTextTableElementsOfParameter(MCDParameter pParameter) {
        MCDDbParameter dbParameter = null;
        MCDTextTableElements textTableElements = null;
        this.logger.trace("Entering getTextTableElementsOfParameter(...).");
        try {
            dbParameter = pParameter.getDbObject();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error getting database object of runtime parameter!");
            this.logger.logMcdError(mcde.getError());
            return null;
        }
        textTableElements = this.getTextTableElementsOfDbParameter(dbParameter);
        this.logger.trace("Leaving getTextTableElementsOfParameter(...).");
        return textTableElements;
    }

    public MCDTextTableElement getTextTableElementByCodedValueUint32(MCDTextTableElements pTextTableElements, long pCodedValueUint32) {
        long numberOfTextTableElements = 0L;
        MCDTextTableElement textTableElement = null;
        MCDTextTableElement textTableElementOfCompuDefaultValue = null;
        MCDInterval interval = null;
        int lowerLimitIntervalType = -1;
        int upperLimitIntervalType = -1;
        MCDValue value_lowerLimit = null;
        MCDValue value_upperLimit = null;
        int lowerLimitDataType = -1;
        int upperLimitDataType = -1;
        long lowerLimit = 0L;
        long upperLimit = 0L;
        boolean foundMatch = false;
        this.logger.trace("Entering getTextTableElementByCodedValueUint32(...).");
        if (pTextTableElements == null) {
            return null;
        }
        try {
            numberOfTextTableElements = pTextTableElements.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of text table elements of database parameter.");
            this.logger.logThrowable(mcde);
            return null;
        }
        int i = 0;
        while ((long)i < numberOfTextTableElements) {
            block32: {
                block34: {
                    block33: {
                        try {
                            textTableElement = pTextTableElements.getItemByIndex((long)i);
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                            break block32;
                        }
                        try {
                            interval = textTableElement.getInterval();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting interval of text table element with index " + i + " (probably the COMPU-DEFAULT-VALUE).");
                            if (mcde.getError().getCode() != 57362) {
                                this.logger.logThrowable(mcde);
                            }
                            textTableElementOfCompuDefaultValue = textTableElement;
                            break block32;
                        }
                        try {
                            lowerLimitIntervalType = interval.getLowerLimitIntervalType();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting INTERVAL-TYPE of LOWER-LIMIT of text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                            break block32;
                        }
                        try {
                            upperLimitIntervalType = interval.getUpperLimitIntervalType();
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting INTERVAL-TYPE of UPPER-LIMIT  of text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                            break block32;
                        }
                        try {
                            value_lowerLimit = interval.getLowerLimit();
                            if (lowerLimitDataType == -1) {
                                try {
                                    lowerLimitDataType = value_lowerLimit.getDataType();
                                }
                                catch (MCDException mcde) {
                                    this.logger.debug("Error getting data type of value of LOWER-LIMIT of text table element with index " + i + ".");
                                    this.logger.logThrowable(mcde);
                                    break block32;
                                }
                                if (lowerLimitDataType != 11) {
                                    this.logger.error("The data type of value of LOWER-LIMIT (" + McdEnumDecoder.decodeMcdDataType(lowerLimitDataType) + ") of the text table element with index " + i + " does not match the expected data type " + McdEnumDecoder.decodeMcdDataType(11) + "!");
                                    return null;
                                }
                            }
                            if (value_lowerLimit == null) break block33;
                            try {
                                lowerLimit = value_lowerLimit.getUint32();
                                break block33;
                            }
                            catch (MCDException mcde) {
                                this.logger.debug("Error getting UINT32 value of LOWER-LIMIT of text table element with index " + i + ".");
                                this.logger.logThrowable(mcde);
                            }
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting value of LOWER-LIMIT of text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                        }
                        break block32;
                    }
                    try {
                        value_upperLimit = interval.getUpperLimit();
                        if (upperLimitDataType == -1) {
                            try {
                                upperLimitDataType = value_upperLimit.getDataType();
                            }
                            catch (MCDException mcde) {
                                this.logger.debug("Error getting data type of value of UPPER-LIMIT of text table element with index " + i + ".");
                                this.logger.logThrowable(mcde);
                                break block32;
                            }
                            if (upperLimitDataType != 11) {
                                this.logger.error("The data type of value of UPPER-LIMIT (" + McdEnumDecoder.decodeMcdDataType(upperLimitDataType) + ") of the text table element with index " + i + " does not match the expected data type " + McdEnumDecoder.decodeMcdDataType(11) + "!");
                                return null;
                            }
                        }
                        if (value_upperLimit == null) break block34;
                        try {
                            upperLimit = value_upperLimit.getUint32();
                            break block34;
                        }
                        catch (MCDException mcde) {
                            this.logger.debug("Error getting UINT32 value of UPPER-LIMIT of text table element with index " + i + ".");
                            this.logger.logThrowable(mcde);
                        }
                    }
                    catch (MCDException mcde) {
                        this.logger.debug("Error getting value of UPPER-LIMIT of text table element with index " + i + ".");
                        this.logger.logThrowable(mcde);
                    }
                    break block32;
                }
                if ((lowerLimitIntervalType == 27907 || lowerLimitIntervalType == 27905 && pCodedValueUint32 > lowerLimit || lowerLimitIntervalType == 27906 && pCodedValueUint32 >= lowerLimit) && (upperLimitIntervalType == 27907 || upperLimitIntervalType == 27905 && pCodedValueUint32 < upperLimit || upperLimitIntervalType == 27906 && pCodedValueUint32 <= upperLimit)) {
                    foundMatch = true;
                    break;
                }
            }
            ++i;
        }
        if (!foundMatch) {
            if (textTableElementOfCompuDefaultValue != null) {
                this.logger.debug("No match found... returning COMPU-DEFAULT-VALUE.");
                return textTableElementOfCompuDefaultValue;
            }
            return null;
        }
        this.logger.trace("Leaving getTextTableElementByCodedValueUint32(...).");
        return textTableElement;
    }

    private MCDTextTableElement getTextTableElementByLongName(MCDTextTableElements pTextTableElements, String pLongName) {
        long numberOfTextTableElements = 0L;
        MCDTextTableElement textTableElement = null;
        String longName = null;
        boolean foundMatch = false;
        this.logger.trace("Entering getTextTableElementByLongName(...).");
        if (pTextTableElements == null) {
            return null;
        }
        try {
            numberOfTextTableElements = pTextTableElements.getCount();
        }
        catch (MCDException mcde) {
            this.logger.debug("Error determining number of text table elements of database parameter.");
            this.logger.logThrowable(mcde);
            return null;
        }
        int i = 0;
        while ((long)i < numberOfTextTableElements) {
            block10: {
                try {
                    textTableElement = pTextTableElements.getItemByIndex((long)i);
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting text table element with index " + i + ".");
                    this.logger.logThrowable(mcde);
                    break block10;
                }
                try {
                    longName = textTableElement.getLongName();
                }
                catch (MCDException mcde) {
                    this.logger.debug("Error getting longName (VT) of text table element with index " + i + ".");
                    this.logger.logThrowable(mcde);
                    break block10;
                }
                if (longName.equals(pLongName)) {
                    foundMatch = true;
                    break;
                }
            }
            ++i;
        }
        if (!foundMatch) {
            return null;
        }
        this.logger.trace("Leaving getTextTableElementByLongName(...).");
        return textTableElement;
    }

    public String pduValue2String(MCDValue pPduValue) throws MCDException {
        return pPduValue.getValueAsString();
    }
}

