/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDbLocation;
import asam.d.MCDDbParameter;
import asam.d.MCDDbResponseParameter;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDTextTableElement;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import com.audi.mcd.joblibrary.util.SubSystemHelper;
import com.audi.mcd.joblibrary.util.impl.SubSystemHelperImpl;
import java.lang.reflect.Method;

public class MCD3_SubsyCodinRead
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20140130";
    private boolean dedicatedSubSystemIdsSupported = false;
    private SubSystemHelper subSystemHelper = null;
    static /* synthetic */ Class class$asam$d$MCDDbLocation;

    public MCD3_SubsyCodinRead() {
        super(REVISION, OutputParameterValue.SubsyCodinRead.JobStatusCode.class, OutputParameterValue.SubsyCodinRead.JobStatusInformation.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        block27: {
            MCDResponse jobResponse;
            MCDResult jobResult;
            int slaveSystemCounter;
            block26: {
                slaveSystemCounter = 0;
                jobResult = null;
                jobResponse = null;
                this.jobStatus = 0;
                this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
                this.subSystemHelper = new SubSystemHelperImpl(this.logger, this.vendorSpecific);
                this.logger.debug("1 Init");
                Object[] resTemp = this.addResponse(pSingleEcuJob, pLogicalLink.getDbObject().getDbLocation());
                jobResult = (MCDResult)resTemp[0];
                jobResponse = (MCDResponse)resTemp[1];
                MCDDiagComPrimitive dsSlaveCoding = this.ensureService("DiagnServi_ReadDataByIdentVWSlaveCodinValue");
                MCDResponseParameters slaveCollection = this.getSlaveList();
                this.ensureValidSlaveCollection(slaveCollection);
                boolean error = false;
                int j = 0;
                while ((long)j < slaveCollection.getCount()) {
                    try {
                        this.operateSlaveEntry(jobResponse, slaveCollection.getItemByIndex((long)j), dsSlaveCoding);
                        ++slaveSystemCounter;
                    }
                    catch (Exception e) {
                        this.logger.debug("Current Slave operation canceled!");
                        this.logger.logThrowable(e);
                        error = true;
                    }
                    ++j;
                }
                this.jobStatus = error ? 9 : 0;
                this.setNumberOfSlaves(jobResponse, slaveSystemCounter);
                break block26;
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
            }
            try {
                this.setStatus(jobResponse, this.jobStatus);
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
            }
            this.dumpAndSendFinalResult(jobResult);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
            break block27;
            catch (IllegalAccessException iae) {
                try {
                    this.setNumberOfSlaves(jobResponse, slaveSystemCounter);
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
                try {
                    this.setStatus(jobResponse, this.jobStatus);
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
                this.dumpAndSendFinalResult(jobResult);
                this.logger.finalize(this.getCurrentJobRuntimeAsString());
                this.logger.exit();
                break block27;
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
                break block27;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    this.setNumberOfSlaves(jobResponse, slaveSystemCounter);
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
                try {
                    this.setStatus(jobResponse, this.jobStatus);
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
                this.dumpAndSendFinalResult(jobResult);
                this.logger.finalize(this.getCurrentJobRuntimeAsString());
                this.logger.exit();
            }
        }
    }

    protected int readInputParameters(MCDRequestParameters pRequestParameters) {
        return 0;
    }

    private MCDResponseParameters getSlaveList() throws IllegalAccessException, MCDException {
        MCDResponseParameters slaveCollection;
        this.logger.debug("2  Extract SlaveCollection");
        try {
            slaveCollection = this.getSlaveSystems("Identified SubSystem Numbers", false);
        }
        catch (Exception e) {
            this.logger.debug("DID 0608 failed (Identified SubSystem Numbers)!");
            slaveCollection = this.getSlaveSystems("Identified Slave Systems", true);
        }
        if (slaveCollection != null && slaveCollection.getCount() == 0L) {
            this.jobStatus = 0;
            throw new IllegalAccessException();
        }
        return slaveCollection;
    }

    private void operateSlaveEntry(MCDResponse jobResponse, MCDResponseParameter slave, MCDDiagComPrimitive dsSlaveCoding) throws IllegalAccessException {
        block15: {
            MCDResponseParameter subSystemNameParam = null;
            MCDResponseParameter responseParam_subSystemPresent = null;
            MCDResponseParameter responseParam_reserVw8012730 = null;
            MCDValue value_subSystemName = null;
            String subSystemName = null;
            MCDValue value_subSystemId = null;
            short subSystemId = 0;
            String subSystemPresent = null;
            byte reserVw8012730 = 0;
            boolean isVw80127V30 = false;
            MCDDbResponseParameter dbParameterSubSystemNames = null;
            long lengthOfSubSystemNameDbParameter = 0L;
            MCDTextTableElement subSystemNameFromId = null;
            try {
                this.logger.debug("Operate Slave entry.");
                MCDResponseParameters slaveParameters = slave.getParameters();
                slaveParameters = slave.getType() == 22 ? slave.getParameters().getItemByIndex(0L).getParameters() : slave.getParameters();
                this.logger.debug("Extract Param_SlaveSyste");
                subSystemNameParam = slaveParameters.getItemByName("Param_SlaveSyste");
                value_subSystemName = subSystemNameParam.getValue();
                subSystemName = value_subSystemName.getValueAsString();
                this.logger.debug("Extract Param_SlaveID");
                value_subSystemId = slaveParameters.getItemByName("Param_SlaveID").getValue();
                subSystemId = (short)value_subSystemId.getUint32();
                try {
                    responseParam_reserVw8012730 = slaveParameters.getItemByName("Param_ReserVW8012730");
                    reserVw8012730 = (byte)responseParam_reserVw8012730.getValue().getUint32();
                    if (reserVw8012730 == 1) {
                        isVw80127V30 = true;
                        this.logger.debug("isVw80127V30 = true");
                    }
                }
                catch (MCDException mcde) {
                    isVw80127V30 = false;
                    this.logger.debug("isVw80127V30 = false");
                }
                if (isVw80127V30) {
                    responseParam_subSystemPresent = slaveParameters.getItemByName("Param_SubsyPrese");
                    subSystemPresent = responseParam_subSystemPresent.getValue().getValueAsString();
                } else {
                    subSystemPresent = "unknown";
                }
                this.logger.debug("subSystem present: " + subSystemPresent);
                if (!isVw80127V30 && subSystemId != 0 && subSystemId != 65535 && subSystemId > 511) {
                    this.logger.warn("The read subsystem id 0x" + Integer.toHexString(subSystemId).toUpperCase() + " exceeds the maximum value 0x" + Integer.toHexString(511).toUpperCase() + "!");
                    subSystemId = (short)(subSystemId & 0x1FF);
                    this.logger.warn("The subsystem id has been truncated to 0x" + Integer.toHexString(subSystemId).toUpperCase() + ".");
                }
                if ((lengthOfSubSystemNameDbParameter = (dbParameterSubSystemNames = (MCDDbResponseParameter)jobResponse.getResponseParameters().getItemByName("OPA_JobResul").getDbObject().getDbParameters().getItemByIndex(0L).getDbParameters().getItemByName("Param_SlaveSysteName")).getByteLength()) == 2L) {
                    this.dedicatedSubSystemIdsSupported = true;
                }
                if (this.dedicatedSubSystemIdsSupported && (subSystemName.equals("Slave Not Present") || subSystemName.equals("unknown Slave") || this.vendorSpecific.getTextTableElementOfDbParameterByLongName((MCDDbParameter)dbParameterSubSystemNames, subSystemName) == null) && (subSystemNameFromId = this.vendorSpecific.getTextTableElementOfDbParameterByCodedValueUint32((MCDDbParameter)dbParameterSubSystemNames, subSystemId)) != null) {
                    subSystemName = subSystemNameFromId.getLongName();
                    value_subSystemName.setValueAsString(subSystemName);
                    this.logger.debug("Replacing subsystem name with \"" + subSystemName + "\" derived from subsystem id 0x" + Integer.toHexString(subSystemId).toUpperCase() + ".");
                }
                this.logger.debug("Create new ResultStructure");
                if ((isVw80127V30 || value_subSystemId.getUint32() == 0L || value_subSystemId.getUint32() == 65535L) && (!isVw80127V30 || !subSystemPresent.equals("yes"))) break block15;
                MCDResponseParameter resultStructure = jobResponse.getResponseParameters().getItemByName("OPA_JobResul").getParameters().addElement();
                MCDResponseParameters resultStructureParams = resultStructure.getType() == 22 ? resultStructure.getParameters().getItemByIndex(resultStructure.getParameters().getCount() - 1L).getParameters() : resultStructure.getParameters();
                try {
                    this.logger.debug("Extract Param_SlaveID");
                    MCDResponseParameter Param_SlaveID = resultStructureParams.getItemByName("Param_SlaveID");
                    this.logger.debug("Set ID");
                    Param_SlaveID.setValue(value_subSystemId);
                }
                catch (Exception e) {
                    this.logger.debug("Failed to set SlaveID!");
                    this.logger.logThrowable(e);
                }
                try {
                    MCDResponseParameter internalNameParam = resultStructureParams.getItemByName("Param_SlaveSysteName");
                    this.logger.debug("Set Name " + value_subSystemName.getValueAsString());
                    internalNameParam.setValue(value_subSystemName);
                }
                catch (Exception e) {
                    this.logger.debug("Failed to set internal Name!");
                    this.logger.logThrowable(e);
                }
                MCDResponseParameter targetParam = resultStructureParams.getItemByName("Param_VWSlaveCodinValue");
                this.executeSlaveIdentDS(dsSlaveCoding, subSystemName, subSystemId, targetParam);
            }
            catch (IllegalAccessException iae) {
                throw iae;
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
                this.jobStatus = 9;
                throw new IllegalAccessException();
            }
        }
    }

    private MCDResponseParameters getSlaveSystems(String did, boolean storeError) throws IllegalAccessException {
        MCDDiagComPrimitive service22060x = null;
        MCDResult result22060x = null;
        try {
            MCDResponseParameters slaveCollection;
            try {
                this.logger.debug("2 1 Create DiagnServi_ReadDataByIdentECUIdent");
                service22060x = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentECUIdent");
                MCDRequestParameter didParam = service22060x.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
                MCDValue value = didParam.createValue();
                value.setValueAsString(did);
                didParam.setValue(value);
            }
            catch (MCDException mcde) {
                this.logger.debug("2 2 Create DiagnServi_ReadDataByIdentECUIdent(" + did + ") FAILED!");
                this.logger.logThrowable(mcde);
                try {
                    service22060x = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDataByIdentIdentSlaveSyste");
                }
                catch (MCDException mcde2) {
                    this.logger.debug("2 2 Create DiagnServi_ReadDataByIdentIdentSlaveSyste FAILED!");
                    this.logger.logThrowable(mcde2);
                    if (storeError) {
                        this.jobStatus = 13;
                    }
                    throw new IllegalAccessException();
                }
            }
            this.logger.debug("2 3 Execute Service");
            this.printRequest(service22060x);
            result22060x = service22060x.executeSync();
            if (result22060x.hasError()) {
                throw new Exception();
            }
            if (this.checkNRC(result22060x, 49L)) {
                this.logger.debug("2 3b NRC 0x31 found!");
                this.printMCDResult(result22060x);
                if (storeError) {
                    this.jobStatus = 2;
                }
                throw new IllegalAccessException();
            }
            this.logger.debug("2 4 Try to get pos Response..");
            if (this.responseNotAcknowledged(result22060x)) {
                this.catchResponseInfo(result22060x, null);
                if (storeError) {
                    this.jobStatus = 9;
                }
                throw new IllegalAccessException();
            }
            MCDResponse response22060x = result22060x.getResponses().getItemByIndex(0L);
            this.mcdObjectDumper.dumpResponse(response22060x, 1, false);
            this.logger.debug("2 5 responsePDU: " + this.vendorSpecific.pduValue2String(response22060x.getResponseMessage()));
            MCDResponseParameter dataRecor = response22060x.getResponseParameters().getItemByName("Param_DataRecor");
            this.logger.debug("Data type of Data Record: " + McdEnumDecoder.decodeMcdDataType(dataRecor.getType()));
            if (dataRecor.getType() == 17) {
                this.logger.debug("Getting parameters of wrapper STRUCTURE.");
                slaveCollection = dataRecor.getParameters().getItemByIndex(0L).getParameters();
            } else {
                slaveCollection = dataRecor.getParameters();
            }
            this.logger.debug("Data type of slaveCollection: " + McdEnumDecoder.decodeMcdDataType(slaveCollection.getItemByIndex(0L).getType()));
            if (slaveCollection.getItemByIndex(0L).getType() == 22) {
                slaveCollection = slaveCollection.getItemByIndex(0L).getParameters();
            }
            this.logger.debug("2 6 Check SlaveCollection amount: " + slaveCollection.getCount());
            return slaveCollection;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.catchResponseInfo(result22060x, e);
            if (storeError) {
                this.jobStatus = 13;
            }
            throw new IllegalAccessException();
        }
    }

    private boolean checkNRC(MCDResult result, long value) {
        try {
            this.logger.debug("Check NRC " + value);
            byte[] pdu = result.getResponses().getItemByIndex(0L).getResponseMessage().getBytefield();
            return pdu.length >= 3 && pdu[0] == 127 && (long)pdu[2] == value;
        }
        catch (Exception e) {
            this.logger.debug("Check NRC " + value + " FAILED!");
            this.logger.logThrowable(e);
            return false;
        }
    }

    private void executeSlaveIdentDS(MCDDiagComPrimitive serviceRead_SysteName, String pSubSystemName, short pSubSystemId, MCDResponseParameter targetParam) throws IllegalAccessException {
        try {
            this.logger.debug("Operate Service " + serviceRead_SysteName.getDbObject().getShortName());
            this.logger.debug("Get Service inputParameter");
            MCDRequestParameter tableKeyParam = serviceRead_SysteName.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
            this.logger.debug("Set Value to Parameter");
            try {
                this.logger.debug("sub 3b: " + pSubSystemName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.subSystemHelper.findAndSetMatchingTextTableElementWithSubSystemLongName(serviceRead_SysteName.getDbObject().getShortName(), tableKeyParam, pSubSystemName)) {
                this.logger.warn("Failed to find/set matching TABLE-KEY for \"" + pSubSystemName + "\"!");
                if (!this.dedicatedSubSystemIdsSupported) {
                    this.setFailureStringToParam(targetParam, "Coding Not Supported / Incorrect Diagnostic Session");
                    throw new IllegalAccessException();
                }
                this.logger.debug("Trying to find/set matching TABLE-KEY for subsystem id 0x" + Integer.toHexString(pSubSystemId).toUpperCase() + "...");
                if (!this.subSystemHelper.findAndSetMatchingTextTableElementWithSubSystemId(serviceRead_SysteName.getDbObject().getShortName(), tableKeyParam, pSubSystemId)) {
                    this.logger.error("Failed to find/set matching TABLE-KEY for subsystem id 0x" + Integer.toHexString(pSubSystemId).toUpperCase() + "...");
                    this.setFailureStringToParam(targetParam, "Coding Not Supported / Incorrect Diagnostic Session");
                    throw new IllegalAccessException();
                }
            }
            this.logger.debug("Execute Service");
            MCDResult resultRead_SysteName = serviceRead_SysteName.executeSync();
            this.printAllResponsePDUs(resultRead_SysteName, serviceRead_SysteName.getDbObject().getShortName());
            byte[] responseByte = resultRead_SysteName.getResponses().getItemByIndex(0L).getResponseMessage().getBytefield();
            if (responseByte[0] == 127 || resultRead_SysteName.hasError()) {
                this.setFailureStringToParam(targetParam, "Coding Not Supported / Incorrect Diagnostic Session");
                throw new IllegalAccessException();
            }
            this.logger.debug("Extract Information..");
            MCDResponseParameter data = resultRead_SysteName.getResponses().getItemByIndex(0L).getResponseParameters().getItemByName("Param_DataRecor").getParameters().getItemByIndex(0L);
            try {
                if ("Request Out Of Range".equals(data.getValue().getValueAsString())) {
                    this.setFailureStringToParam(targetParam, "Coding Not Supported / Incorrect Diagnostic Session");
                    throw new IllegalAccessException();
                }
            }
            catch (IllegalAccessException iae) {
                throw iae;
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.logger.debug("sub TableCount: " + data.getParameters().getCount());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.logger.debug("sub  - " + data.getShortName() + " Datatype Source: " + data.getValue().getDataType() + " Target: " + targetParam.getValue().getDataType());
            }
            catch (Exception e) {
                // empty catch block
            }
            targetParam.setValue(data.getValue());
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.setFailureStringToParam(targetParam, "Coding Not Supported / Incorrect Diagnostic Session");
            throw new IllegalAccessException();
        }
    }

    private void setFailureStringToParam(MCDResponseParameter target, String failure) {
        try {
            if (target == null) {
                this.logger.debug("Can not set Failure string to null target parameter! " + failure);
                return;
            }
            this.logger.debug("Error getting Slave Information: Set Defaultvalue! " + (failure != null ? failure : ""));
            MCDValue value = this.jobApi.createValue(target.getType());
            if (value.getDataType() == 1) {
                value.setValueAsString(failure);
            } else if (value.getDataType() == 14) {
                value.setValueAsString(failure);
            } else if (value.getDataType() == 3) {
                value.setBytefield(new byte[]{0});
            }
            target.setValue(value);
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
        }
    }

    private void ensureValidSlaveCollection(MCDResponseParameters slaveCollection) throws IllegalAccessException {
        long numberOfCodableSlaves = 0L;
        try {
            this.logger.debug("Check Slave Collection containing correct entries!");
            numberOfCodableSlaves = slaveCollection.getCount();
            long size = slaveCollection.getCount();
            for (long i = 0L; i < size; ++i) {
                MCDResponseParameter wrapperStructure = slaveCollection.getItemByIndex(i);
                this.logger.debug("Type of wrapper: " + McdEnumDecoder.decodeMcdDataType(wrapperStructure.getType()));
                MCDResponseParameters wrapperStructureCollection = wrapperStructure.getParameters();
                for (long j = 0L; j < wrapperStructureCollection.getCount(); ++j) {
                    this.logger.debug("Parameter[" + j + "]: " + wrapperStructureCollection.getItemByIndex(j).getShortName());
                }
                String internalName = wrapperStructure.getType() == 22 ? wrapperStructure.getParameters().getItemByIndex(0L).getParameters().getItemByName("Param_SlaveSyste").getValue().getValueAsString() : wrapperStructure.getParameters().getItemByName("Param_SlaveSyste").getValue().getValueAsString();
                if ("Slave Not Present".equals(internalName)) {
                    this.logger.debug("Slave not present...decreasing number of codable slaves.");
                    --numberOfCodableSlaves;
                }
                if ("unknown Slave".equals(internalName)) {
                    this.logger.debug("Unknown slave found...decreasing number of codable slaves.");
                    --numberOfCodableSlaves;
                }
                if (!"Slave Not Coded".equals(internalName)) continue;
                this.logger.debug("Uncoded slave found...decreasing number of codable slaves.");
                --numberOfCodableSlaves;
            }
            if (numberOfCodableSlaves == 0L) {
                this.jobStatus = 13;
                this.logger.debug("None of the slaves is codable...sequence aborted!");
                throw new IllegalAccessException();
            }
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.logger.debug("Error occured while checking SlaveSystem name");
            this.logger.logThrowable(e);
            this.jobStatus = 13;
            throw new IllegalAccessException();
        }
    }

    private MCDDiagComPrimitive ensureService(String service) throws IllegalAccessException {
        try {
            this.logger.debug("Create " + service);
            return this.logicalLink.createDiagComPrimitiveByName(service);
        }
        catch (MCDException mcde) {
            this.logger.debug("Create " + service + " FAILED!");
            this.logger.logThrowable(mcde);
            this.jobStatus = 13;
            throw new IllegalAccessException();
        }
    }

    private boolean responseNotAcknowledged(MCDResult result) {
        try {
            MCDResponse response220606;
            MCDResponses responses = result.getResponses();
            return responses == null || responses.getCount() < 1L || (response220606 = responses.getItemByIndex(0L)) == null || response220606.getState() != 26625;
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
            return true;
        }
    }

    private void catchResponseInfo(MCDResult result, Exception e) {
        this.logger.logThrowable(e);
        this.printMCDResult(result);
    }

    private void setNumberOfSlaves(MCDResponse jobResponse, long count) {
        try {
            MCDResponseParameter number = jobResponse.getResponseParameters().getItemByName("OPA_NumbeOfIdentSubsy");
            MCDValue numberValue = this.jobApi.createValue(11);
            try {
                numberValue.setUint32(count);
                this.logger.debug("setNumber: " + count);
            }
            catch (MCDException mcde) {
                numberValue.setUint32(0L);
            }
            number.setValue(numberValue);
        }
        catch (MCDException mcde) {
            this.jobStatus = 2;
        }
    }

    private void setStatus(MCDResponse jobResponse, int pJobStatus) {
        MCDResponseParameters params = null;
        try {
            params = jobResponse.getResponseParameters();
            MCDResponseParameter param = params.getItemByName("OPA_JobStatuInfor");
            MCDValue value = this.jobApi.createValue(14);
            value.setValueAsString(this.getJobStatusInformation());
            param.setValue(value);
            try {
                param = params.getItemByName("OPA_JobStatuCode");
                value = this.jobApi.createValue(11);
                value.setUint32((long)pJobStatus);
                param.setValue(value);
                this.logger.debug("Set Code " + pJobStatus + " = " + param.getValue().getUint32());
            }
            catch (Exception e) {
                this.logger.debug("Set Status Code failed!");
                this.logger.logThrowable(e);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Status failed!");
            this.logger.logThrowable(e);
        }
    }

    private void printAllResponsePDUs(MCDResult result, String title) {
        try {
            MCDResponses responses = result.getResponses();
            for (long k = 0L; k < responses.getCount(); ++k) {
                this.logger.debug(title + " Response PDU: " + this.vendorSpecific.pduValue2String(responses.getItemByIndex(k).getResponseMessage()));
            }
        }
        catch (MCDException mcde) {
            mcde.printStackTrace();
        }
    }

    private Object[] addResponse(MCDSingleEcuJob singleEcuJob, MCDDbLocation dbLocation) {
        Object[] list = new Object[2];
        try {
            Method[] methods = MCDResponses.class.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                Class<?>[] classes = method.getParameterTypes();
                if (classes.length == 2 && classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_SubsyCodinRead.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation) && classes[1].isAssignableFrom(Boolean.TYPE)) {
                    method.setAccessible(true);
                    MCDResult result = singleEcuJob.createResult(1794, 0, "", 0, "", 0);
                    MCDResponses responses = result.getResponses();
                    list[0] = result;
                    list[1] = method.invoke((Object)responses, dbLocation, Boolean.TRUE);
                    return list;
                }
                if (classes.length != 1 || !classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_SubsyCodinRead.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation)) continue;
                method.setAccessible(true);
                MCDResult result = singleEcuJob.createResult(1794, 49152, "", 0, "", 0);
                MCDResponses responses = result.getResponses();
                list[0] = result;
                list[1] = method.invoke((Object)responses, dbLocation);
                return list;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            throw new IllegalArgumentException("Can not MCDResponse#add(..) method! " + e.getMessage());
        }
        throw new IllegalArgumentException("Method MCDResponse#add(..) not found!");
    }

    protected int addOutputParameters(MCDResponse pResponse) {
        return 0;
    }
}

