/*
 * Decompiled with CFR 0.152.
 */
package com.audi.joblibrary.uds.mcd201;

import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDException;
import asam.d.MCDHexService;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDValue;
import asam.job.SingleEcuJobTemplate;
import com.softing.dts.DtsHexService;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class MCD3_DataSetStandUDS_PRA01
implements SingleEcuJobTemplate {
    long m_transferBlockSize = 0L;
    int m_Error = 0;
    long m_iLengthFormatIdentifier = 4L;
    long m_iAddressFormatIdentifier = 4L;
    private PrintWriter m_outWriter = null;
    int countBlocks = 0;

    public void execute(MCDRequestParameters mCDRequestParameters, MCDJobApi mCDJobApi, MCDLogicalLink mCDLogicalLink, MCDSingleEcuJob mCDSingleEcuJob) throws MCDException {
        byte[] byArray = mCDRequestParameters.getItemByName("IPA_StartAddre").getValue().getBytefield();
        long l = mCDRequestParameters.getItemByName("IPA_Lengt").getValue().getUint32();
        byte[] byArray2 = mCDRequestParameters.getItemByName("IPA_Data").getValue().getBytefield();
        this.m_iAddressFormatIdentifier = mCDRequestParameters.getItemByName("IPA_AddreFormaIdent").getValue().getUint32();
        this.m_iLengthFormatIdentifier = mCDRequestParameters.getItemByName("IPA_LengtFormaIdent").getValue().getUint32();
        try {
            this.m_outWriter = new PrintWriter(new FileOutputStream(System.getProperty("user.home") + "\\" + this.getClass().getName() + ".log"));
            this.m_outWriter.print("started job\n");
            this.m_outWriter.flush();
            if (!this.downloadDatablock(mCDLogicalLink, mCDJobApi, byArray, l, byArray2)) {
                this.m_Error = 1;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_outWriter.print("catched file not found exception\n");
            this.m_outWriter.flush();
            this.m_Error = 3;
        }
        catch (Exception exception) {
            this.m_outWriter.print("catched exception\n");
            this.m_outWriter.flush();
            this.m_outWriter.print(exception.toString() + "\n");
            exception.printStackTrace(this.m_outWriter);
            MCDError mCDError = ((MCDException)((Object)exception)).getError();
            this.m_outWriter.print(mCDError.getCodeDescription() + "\n");
            this.m_outWriter.print(mCDError.getVendorCodeDescription() + "\n");
            this.m_Error = 2;
        }
        this.m_outWriter.print("end of execute\n");
        this.m_outWriter.flush();
        this.setResult(mCDJobApi, mCDSingleEcuJob, mCDLogicalLink, this.m_Error);
        this.m_outWriter.close();
    }

    private void setResult(MCDJobApi mCDJobApi, MCDSingleEcuJob mCDSingleEcuJob, MCDLogicalLink mCDLogicalLink, int n) {
        try {
            MCDResult mCDResult = mCDSingleEcuJob.createResult(1795, 49152, "", 0, "", 0);
            MCDResponses mCDResponses = mCDResult.getResponses();
            MCDResponse mCDResponse = mCDResponses.add(mCDLogicalLink.getDbObject().getDbLocation());
            MCDResponseParameters mCDResponseParameters = mCDResponse.getResponseParameters();
            MCDResponseParameter mCDResponseParameter = mCDResponseParameters.getItemByName("OPA_Resul");
            MCDValue mCDValue = mCDJobApi.createValue(11);
            mCDValue.setUint32((long)n);
            mCDResponseParameter.setValue(mCDValue);
            mCDJobApi.sendFinalResult(mCDResult);
        }
        catch (MCDException mCDException) {
            this.m_outWriter.print("exception\n");
        }
    }

    private boolean requestDownload(MCDLogicalLink mCDLogicalLink, byte[] byArray, long l) {
        byte[] byArray2;
        MCDValue mCDValue;
        MCDRequestParameter mCDRequestParameter;
        MCDRequestParameters mCDRequestParameters;
        MCDDiagComPrimitive mCDDiagComPrimitive;
        this.m_outWriter.print("starting requestDownload\n");
        String string = "DiagnServi_RequeDownlDynam";
        String string2 = "downloadData/" + string;
        long l2 = 0L;
        int n = 0;
        try {
            mCDDiagComPrimitive = mCDLogicalLink.createDiagComPrimitiveByName(string);
        }
        catch (MCDException mCDException) {
            this.m_outWriter.print(string2 + ": service creation failed.\n");
            mCDException.printStackTrace(this.m_outWriter);
            return false;
        }
        this.m_outWriter.print("created service\n");
        try {
            MCDRequest mCDRequest = null;
            mCDRequestParameters = null;
            mCDRequestParameter = null;
            mCDValue = null;
            mCDRequest = mCDDiagComPrimitive.getRequest();
            mCDRequestParameters = mCDRequest.getRequestParameters();
            this.m_outWriter.print("setting parameter dataFormatIdentifier\n");
            String string3 = "Param_AddreFormaIdent";
            mCDRequestParameter = mCDRequestParameters.getItemByName(string3);
            mCDValue = mCDRequestParameter.getValue();
            mCDValue.setUint32(this.m_iAddressFormatIdentifier);
            mCDRequestParameter.setValue(mCDValue);
            this.m_outWriter.print("setting parameter Param_LengtFormaIdent\n");
            string3 = "Param_LengtFormaIdent";
            mCDRequestParameter = mCDRequestParameters.getItemByName(string3);
            mCDValue = mCDRequestParameter.getValue();
            mCDValue.setUint32(this.m_iLengthFormatIdentifier);
            mCDRequestParameter.setValue(mCDValue);
            this.m_outWriter.print("done setting parameter\n");
            this.m_outWriter.print("setting parameter memoryAddress\n");
            string3 = "Param_MemorAddre";
            mCDRequestParameter = mCDRequestParameters.getItemByName(string3);
            mCDValue = mCDRequestParameter.getValue();
            mCDValue.setBytefield(byArray);
            mCDRequestParameter.setValue(mCDValue);
            this.m_outWriter.print("()lSize= " + Long.toHexString(l) + "\n");
            byArray2 = new byte[(int)this.m_iLengthFormatIdentifier];
            for (int i = (int)this.m_iLengthFormatIdentifier - 1; i >= 0; --i) {
                byArray2[i] = (byte)(l & 0xFFL);
                this.m_outWriter.print("lSize= " + Long.toHexString(l >>= 8) + "\n");
            }
            this.m_outWriter.print("setting parameter unCompressedMemorySize\n");
            string3 = "Param_MemorSize";
            mCDRequestParameter = mCDRequestParameters.getItemByName(string3);
            mCDValue = mCDRequestParameter.getValue();
            mCDValue.setBytefield(byArray2);
            mCDRequestParameter.setValue(mCDValue);
            this.m_outWriter.print("done setting parameter\n");
        }
        catch (MCDException mCDException) {
            this.m_outWriter.print(string2 + ": service configuration failed, " + mCDException.getError().getCodeDescription() + "\n");
            return false;
        }
        try {
            this.printPDUOfService(mCDDiagComPrimitive);
            MCDResult mCDResult = mCDDiagComPrimitive.executeSync();
            this.printResponsePDU(mCDResult);
            int n2 = mCDResult.getResultState().getExecutionState();
            if (n2 != 25345) {
                this.m_outWriter.print(string2 + ": service execution failed.\n");
                return false;
            }
            this.m_outWriter.print("get the response parameter\n");
            this.m_outWriter.print("try to get response parameters\n");
            mCDRequestParameters = mCDResult.getResponses().getItemByIndex(0L).getResponseParameters();
            this.m_outWriter.print("try to get response parameter transferResponseParameter\n");
            mCDRequestParameter = mCDRequestParameters.getItemByName("Param_MaxNumbeOfBlockLengt");
            this.m_outWriter.print("try to get value from response parameter\n");
            mCDValue = mCDRequestParameter.getValue();
            this.m_outWriter.print("try to get int from mcd value\n");
            byArray2 = mCDValue.getBytefield();
            this.m_outWriter.print("try to getparam length info\n");
            mCDRequestParameter = mCDRequestParameters.getItemByName("Param_LengtFormaIdent");
            this.m_outWriter.print("try to get value from response parameter Param_LengtFormaIdent\n");
            mCDValue = mCDRequestParameter.getValue();
            this.m_outWriter.print("try to get 4bits from mcd value\n");
            l2 = mCDValue.getUint32();
            this.m_outWriter.print("paramlengthInfo=" + Long.toHexString(l2) + "\n");
            n = 0;
            while ((long)n < l2) {
                this.m_transferBlockSize |= (long)byArray2[n] & 0xFFL;
                if (l2 != (long)(n + 1)) {
                    this.m_transferBlockSize <<= 8;
                }
                this.m_outWriter.print("m_transferBlockSize = " + Long.toHexString(this.m_transferBlockSize) + "\n");
                ++n;
            }
            this.m_transferBlockSize -= 2L;
            this.m_outWriter.print("block size = 0x" + Long.toHexString(this.m_transferBlockSize) + "\n");
        }
        catch (MCDException mCDException) {
            this.m_outWriter.print(string2 + ": service execution failed, " + mCDException.getError().getCodeDescription() + "\n");
            return false;
        }
        return true;
    }

    private void printPDUOfService(MCDDiagComPrimitive mCDDiagComPrimitive) {
        try {
            MCDValue mCDValue;
            MCDRequest mCDRequest;
            this.m_outWriter.print("in printPDUOfService\n");
            if (mCDDiagComPrimitive != null && (mCDRequest = mCDDiagComPrimitive.getRequest()) != null && (mCDValue = mCDRequest.getPDU()) != null) {
                this.m_outWriter.print("request pdu: ");
                byte[] byArray = mCDValue.getBytefield();
                for (int i = 0; i < byArray.length; ++i) {
                    this.m_outWriter.print(Integer.toHexString(byArray[i] & 0xFF));
                    if (i + 1 >= byArray.length) continue;
                    this.m_outWriter.print(", ");
                }
                this.m_outWriter.print("\n");
            }
        }
        catch (MCDException mCDException) {
            mCDException.printStackTrace(this.m_outWriter);
            this.m_outWriter.print("\n");
        }
    }

    private void printResponsePDU(MCDResult mCDResult) {
        try {
            this.m_outWriter.print("in printResponsePDU\n");
            if (mCDResult != null) {
                if (mCDResult.hasError()) {
                    this.m_outWriter.print("result has error\n");
                } else {
                    MCDValue mCDValue;
                    MCDResponse mCDResponse;
                    MCDResponses mCDResponses = mCDResult.getResponses();
                    if (mCDResponses != null && (mCDResponse = mCDResponses.getItemByIndex(0L)) != null && (mCDValue = mCDResponse.getResponseMessage()) != null) {
                        this.m_outWriter.print("response pdu: ");
                        byte[] byArray = mCDValue.getBytefield();
                        for (int i = 0; i < byArray.length; ++i) {
                            this.m_outWriter.print(Integer.toHexString(byArray[i] & 0xFF));
                            if (i + 1 >= byArray.length) continue;
                            this.m_outWriter.print(", ");
                        }
                        this.m_outWriter.print("\n");
                    }
                }
            }
        }
        catch (MCDException mCDException) {
            mCDException.printStackTrace(this.m_outWriter);
            this.m_outWriter.print("\n");
        }
    }

    private boolean downloadDatablock(MCDLogicalLink mCDLogicalLink, MCDJobApi mCDJobApi, byte[] byArray, long l, byte[] byArray2) {
        try {
            long l2 = 1L;
            for (long i = 0L; i < l2; ++i) {
                if (!this.requestDownload(mCDLogicalLink, byArray, l)) {
                    return false;
                }
                if (!this.transferData(mCDLogicalLink, l, byArray2)) {
                    return false;
                }
                if (!this.exitDownload(mCDLogicalLink)) {
                    return false;
                }
                byte[] byArray3 = new byte[]{1, 2, -17, 3, 1, 0};
                MCDResult mCDResult = this.sendHexService(mCDLogicalLink, mCDJobApi, (byte)49, byArray3);
                this.m_Error = mCDResult != null ? (!this.checkResult(mCDResult) ? 1 : 0) : 1;
                byte[] byArray4 = new byte[]{3, 2, -17};
                mCDResult = this.sendHexService(mCDLogicalLink, mCDJobApi, (byte)49, byArray4);
                if (mCDResult != null) {
                    MCDValue mCDValue;
                    MCDResponses mCDResponses;
                    if (!this.checkResult(mCDResult) || (mCDResponses = mCDResult.getResponses()) == null) continue;
                    this.printResponsePDU(mCDResult);
                    MCDResponse mCDResponse = mCDResponses.getItemByIndex(0L);
                    if (mCDResponse == null || (mCDValue = mCDResponse.getResponseMessage()) == null) continue;
                    this.m_outWriter.print("response pdu: ");
                    byte[] byArray5 = mCDValue.getBytefield();
                    if ((byArray5[5] & 0xFF) == 255 || (byArray5[6] & 0xFF) == 255) continue;
                    this.m_Error = 1;
                    return false;
                }
                this.m_Error = 1;
            }
        }
        catch (MCDException mCDException) {
            this.m_Error = 2;
            mCDException.printStackTrace(this.m_outWriter);
            MCDError mCDError = mCDException.getError();
            this.m_outWriter.print("vendor code description: " + mCDError.getVendorCodeDescription() + "\n");
        }
        return true;
    }

    private boolean transferData(MCDLogicalLink mCDLogicalLink, long l, byte[] byArray) {
        block17: {
            try {
                MCDDiagComPrimitive mCDDiagComPrimitive;
                String string = "DiagnServi_TransData";
                String string2 = "downloadData/" + string;
                try {
                    mCDDiagComPrimitive = mCDLogicalLink.createDiagComPrimitiveByName(string);
                }
                catch (MCDException mCDException) {
                    mCDException.printStackTrace(this.m_outWriter);
                    this.m_outWriter.print("\n" + string2 + ": service creation failed,\n");
                    return false;
                }
                try {
                    MCDRequest mCDRequest = null;
                    MCDRequestParameters mCDRequestParameters = null;
                    mCDRequest = mCDDiagComPrimitive.getRequest();
                    mCDRequestParameters = mCDRequest.getRequestParameters();
                    MCDRequestParameter mCDRequestParameter = mCDRequestParameters.getItemByName("Param_BlockSequeCount");
                    MCDValue mCDValue = mCDRequestParameter.getValue();
                    MCDRequestParameter mCDRequestParameter2 = mCDRequestParameters.getItemByName("Param_TransRequeParamRecor");
                    MCDValue mCDValue2 = mCDRequestParameter2.getValue();
                    long l2 = 0L;
                    long l3 = l2 + this.m_transferBlockSize + 1L - 2L;
                    if (l3 >= l) {
                        l3 = l - 1L;
                    }
                    boolean bl = false;
                    boolean bl2 = true;
                    bl2 = bl;
                    long l4 = l3 - l2 + 1L;
                    this.m_outWriter.print("ll=" + Integer.toString((int)l4) + "\n");
                    byte[] byArray2 = new byte[(int)l4];
                    boolean bl3 = false;
                    int n = 0;
                    while (l2 < l) {
                        if (++n > 255) {
                            n = 0;
                        }
                        mCDValue.setUint32((long)n);
                        mCDRequestParameter.setValue(mCDValue);
                        for (long i = 0L; i < l4; ++i) {
                            byArray2[(int)i] = byArray[(int)(l2 + i)];
                        }
                        if (bl3) {
                            mCDValue2.clear();
                        }
                        mCDValue2.setBytefield(byArray2);
                        mCDRequestParameter2.setValue(mCDValue2);
                        try {
                            this.printPDUOfService(mCDDiagComPrimitive);
                            MCDResult mCDResult = mCDDiagComPrimitive.executeSync();
                            if (mCDResult.hasError()) {
                                MCDError mCDError = mCDResult.getError();
                                this.m_outWriter.print("error in transferdata: " + mCDError.getVendorCodeDescription() + "\n");
                            }
                            this.printResponsePDU(mCDResult);
                            if (!this.checkResult(mCDResult)) {
                                return false;
                            }
                            int n2 = mCDResult.getResultState().getExecutionState();
                            if (n2 != 25345) {
                                this.m_outWriter.print(string2 + ": service execution failed.\n");
                                return false;
                            }
                        }
                        catch (MCDException mCDException) {
                            mCDException.printStackTrace(this.m_outWriter);
                            this.m_outWriter.print("\n" + string2 + ": service execution failed, " + mCDException.getError().getCodeDescription() + "\n");
                            return false;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(this.m_outWriter);
                        }
                        if ((l3 = (l2 = l3 + 1L) + this.m_transferBlockSize - 1L) < l) continue;
                        l3 = l - 1L;
                        l4 = l3 - l2 + 1L;
                        bl3 = true;
                        byArray2 = new byte[(int)l4];
                    }
                    if (bl2 >= bl) break block17;
                }
                catch (MCDException mCDException) {
                    mCDException.printStackTrace(this.m_outWriter);
                    this.m_outWriter.print("\n" + string2 + ", service execution failed.\n");
                    return false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(this.m_outWriter);
                this.m_outWriter.print("\n");
            }
        }
        return true;
    }

    private MCDResult sendHexService(MCDLogicalLink mCDLogicalLink, MCDJobApi mCDJobApi, byte by, byte[] byArray) throws MCDException {
        MCDHexService mCDHexService = (MCDHexService)mCDLogicalLink.createDiagComPrimitiveByType(1190);
        ((DtsHexService)mCDHexService).setServiceID((long)by);
        MCDRequest mCDRequest = mCDHexService.getRequest();
        MCDValue mCDValue = mCDJobApi.createValue(3);
        mCDValue.setBytefield(byArray);
        mCDRequest.enterPDU(mCDValue);
        MCDResult mCDResult = mCDHexService.executeSync();
        return mCDResult;
    }

    private boolean exitDownload(MCDLogicalLink mCDLogicalLink) {
        MCDDiagComPrimitive mCDDiagComPrimitive;
        this.m_outWriter.print("trying to start exit download\n");
        String string = "DiagnServi_RequeTransExit";
        String string2 = "downloadData/" + string;
        try {
            this.m_outWriter.print("creating diag com primitive " + string + "\n");
            mCDDiagComPrimitive = mCDLogicalLink.createDiagComPrimitiveByName(string);
        }
        catch (MCDException mCDException) {
            this.m_outWriter.print(string2 + ": service creation failed.\n");
            return false;
        }
        try {
            this.printPDUOfService(mCDDiagComPrimitive);
            MCDResult mCDResult = mCDDiagComPrimitive.executeSync();
            int n = mCDResult.getResultState().getExecutionState();
            if (n != 25345) {
                this.m_outWriter.print(string2 + ": service execution failed.\n");
                return false;
            }
        }
        catch (MCDException mCDException) {
            this.m_outWriter.print(string2 + ": service execution failed\n");
            return false;
        }
        return true;
    }

    private boolean checkResult(MCDResult mCDResult) {
        try {
            MCDResponses mCDResponses = mCDResult.getResponses();
            MCDResponse mCDResponse = mCDResponses.getItemByIndex(0L);
            MCDValue mCDValue = mCDResponse.getResponseMessage();
            byte[] byArray = mCDValue.getBytefield();
            if (null == byArray || byArray.length == 0) {
                return false;
            }
            byte by = byArray[0];
            if (by == 127) {
                return false;
            }
        }
        catch (MCDException mCDException) {
            this.m_outWriter.print("exception!\n");
            return false;
        }
        return true;
    }
}

