/*
 * Decompiled with CFR 0.152.
 */
package com.audi.joblibrary.uds.mcd201;

import asam.d.MCDDiagComPrimitive;
import asam.d.MCDError;
import asam.d.MCDException;
import asam.d.MCDHexService;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDValue;
import asam.job.SingleEcuJobTemplate;
import com.softing.dts.DtsHexService;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;

public class MCD3_UnLockAirba
implements SingleEcuJobTemplate {
    private PrintWriter m_outWriter = null;
    long key = 0L;
    long m_Error = 0L;
    long lKey = 0L;
    long lLogin = 98066L;

    public void execute(MCDRequestParameters mCDRequestParameters, MCDJobApi mCDJobApi, MCDLogicalLink mCDLogicalLink, MCDSingleEcuJob mCDSingleEcuJob) throws MCDException {
        try {
            this.m_outWriter = new PrintWriter(new FileOutputStream(System.getProperty("user.home") + "\\" + this.getClass().getName() + ".log"));
            this.m_outWriter.print("started job\n");
            this.m_outWriter.flush();
            MCDResult mCDResult = this.executeService1(mCDLogicalLink, "DiagnServi_SecurAccesRequeSeedLogin", "Param_SecurAccesType", "Request Seed Login");
            if (mCDResult != null) {
                this.m_outWriter.print("Execute Security Seed");
                this.m_outWriter.print("\n");
                this.m_outWriter.flush();
                long l = this.getSeedFromResult(mCDResult);
                this.m_outWriter.print("\nSeed = " + Long.toHexString(l) + "\n");
                this.m_outWriter.flush();
                if (l == -1L) {
                    this.m_Error = 1L;
                }
                this.lKey = l + this.lLogin;
            }
            this.m_outWriter.print("starting SecurAcces4 - send Key\n");
            this.m_outWriter.flush();
            mCDResult = this.executeService1(mCDLogicalLink, "DiagnServi_SecurAccesSendKeyLogin", "Param_SecurAccesKey", new Long(this.lKey));
            if (mCDResult != null) {
                this.m_outWriter.print("sendkeylogin ");
                this.m_outWriter.flush();
            } else {
                this.m_outWriter.print("ging nicht :(");
            }
            this.m_outWriter.flush();
            byte[] byArray = new byte[]{5, -2, 12, 66, 0, 0};
            mCDResult = this.sendHexService(mCDLogicalLink, mCDJobApi, (byte)46, byArray);
            this.m_Error = mCDResult != null ? (!this.checkResult(mCDResult) ? 0L : 0L) : 1L;
            this.setResult(mCDJobApi, mCDSingleEcuJob, mCDLogicalLink, this.m_Error);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_outWriter.print("catched file not found exception\n");
            this.m_outWriter.flush();
        }
        catch (Exception exception) {
            this.m_outWriter.print("catched exception\n");
            this.m_outWriter.flush();
            this.m_outWriter.print(exception.toString() + "\n");
            this.m_outWriter.flush();
            exception.printStackTrace(this.m_outWriter);
            this.m_outWriter.flush();
            MCDError mCDError = ((MCDException)((Object)exception)).getError();
            this.m_outWriter.print(mCDError.getCodeDescription() + "\n");
            this.m_outWriter.flush();
            this.m_outWriter.print(mCDError.getVendorCodeDescription() + "\n");
            this.m_outWriter.flush();
        }
        this.m_outWriter.print("key = " + Long.toHexString(this.key) + "\n");
        this.m_outWriter.print("end of execute\n");
        this.m_outWriter.flush();
        this.m_outWriter.close();
    }

    private void setResult(MCDJobApi mCDJobApi, MCDSingleEcuJob mCDSingleEcuJob, MCDLogicalLink mCDLogicalLink, long l) {
        try {
            this.m_outWriter.print("try createResult\n");
            MCDResult mCDResult = mCDSingleEcuJob.createResult(1795, 49152, "", 0, "", 0);
            this.m_outWriter.print("try getResponses\n");
            MCDResponses mCDResponses = mCDResult.getResponses();
            this.m_outWriter.print("try add responses\n");
            MCDResponse mCDResponse = mCDResponses.add(mCDLogicalLink.getDbObject().getDbLocation());
            this.m_outWriter.print("try get response param\n");
            MCDResponseParameter mCDResponseParameter = mCDResponse.getResponseParameters().getItemByName("OPA_Resul");
            this.m_outWriter.print("try get mcdvalue\n");
            MCDValue mCDValue = mCDResponseParameter.getValue();
            mCDValue.setUint32(l);
            this.m_outWriter.print("try set value \n");
            mCDResponseParameter.setValue(mCDValue);
            this.m_outWriter.print("try send final result\n");
            mCDJobApi.sendFinalResult(mCDResult);
            this.m_outWriter.print("done send final result\n");
        }
        catch (MCDException mCDException) {
            // empty catch block
        }
    }

    private void printResponsePDU(MCDResult mCDResult) {
        try {
            this.m_outWriter.print("in printResponsePDU\n");
            if (mCDResult != null) {
                if (mCDResult.hasError()) {
                    this.m_outWriter.print("result has error\n");
                } else {
                    MCDValue mCDValue;
                    MCDResponse mCDResponse;
                    MCDResponses mCDResponses = mCDResult.getResponses();
                    if (mCDResponses != null && (mCDResponse = mCDResponses.getItemByIndex(0L)) != null && (mCDValue = mCDResponse.getResponseMessage()) != null) {
                        this.m_outWriter.print("response pdu: ");
                        byte[] byArray = mCDValue.getBytefield();
                        for (int i = 0; i < byArray.length; ++i) {
                            this.m_outWriter.print(Integer.toHexString(byArray[i] & 0xFF));
                            if (i + 1 >= byArray.length) continue;
                            this.m_outWriter.print(", ");
                        }
                        this.m_outWriter.print("\n");
                    }
                }
            }
        }
        catch (MCDException mCDException) {
            mCDException.printStackTrace(this.m_outWriter);
            this.m_outWriter.print("\n");
        }
    }

    private void printPDUOfService(MCDDiagComPrimitive mCDDiagComPrimitive) {
        try {
            MCDValue mCDValue;
            MCDRequest mCDRequest;
            this.m_outWriter.print("in printPDUOfService\n");
            if (mCDDiagComPrimitive != null && (mCDRequest = mCDDiagComPrimitive.getRequest()) != null && (mCDValue = mCDRequest.getPDU()) != null) {
                this.m_outWriter.print("request pdu: ");
                byte[] byArray = mCDValue.getBytefield();
                this.m_outWriter.print("Length = " + Integer.toHexString(byArray.length));
                for (int i = 0; i < byArray.length; ++i) {
                    this.m_outWriter.print("PDU " + Integer.toHexString(byArray[i] & 0xFF));
                    if (i + 1 >= byArray.length) continue;
                    this.m_outWriter.print(", ");
                }
                this.m_outWriter.print("\n");
            }
        }
        catch (MCDException mCDException) {
            mCDException.printStackTrace(this.m_outWriter);
            this.m_outWriter.print("\n");
        }
    }

    private boolean setParameterValue(MCDRequestParameter mCDRequestParameter, Object object) throws MCDException {
        this.m_outWriter.print("enter setParameterValue\n");
        boolean bl = false;
        if (mCDRequestParameter != null && object != null) {
            this.m_outWriter.print("getting mcdvalue\n");
            MCDValue mCDValue = mCDRequestParameter.getValue();
            this.m_outWriter.print("checking parameter type\n");
            if (object instanceof String) {
                this.m_outWriter.print("setting unicode value\n");
                mCDValue.setAsciistring((String)object);
                this.m_outWriter.print("setting value to parameter \n");
                mCDRequestParameter.setValue(mCDValue);
                bl = true;
            } else if (object instanceof Long) {
                this.m_outWriter.print("setting long \n");
                Long l = (Long)object;
                mCDValue.setUint32(l.longValue());
                this.m_outWriter.print("setting value to parameter \n");
                mCDRequestParameter.setValue(mCDValue);
                bl = true;
            } else if (object instanceof LinkedList) {
                this.m_outWriter.print("setting bytefield \n");
                LinkedList linkedList = (LinkedList)object;
                byte[] byArray = new byte[linkedList.size()];
                for (int i = 0; i < linkedList.size(); ++i) {
                    this.m_outWriter.print("setting byte " + Integer.toString(i) + " \n");
                    byArray[i] = ((Integer)linkedList.get(i)).byteValue();
                }
                this.m_outWriter.print("got bytefield from bytelist \n");
                mCDValue.setBytefield(byArray);
                this.m_outWriter.print("setting value to parameter \n");
                mCDRequestParameter.setValue(mCDValue);
                bl = true;
            } else {
                this.m_outWriter.print("cannot cast parameter in setParameterValue\n");
            }
        }
        return bl;
    }

    private MCDResult executeService1(MCDLogicalLink mCDLogicalLink, String string, String string2, Object object) {
        if (string == null || string2 == null || object == null) {
            this.m_outWriter.print("executeService1: one of input params is null\n");
            return null;
        }
        MCDResult mCDResult = null;
        this.m_outWriter.print("trying to executeservice \"" + string + "\" with \"" + string2 + "\" set to \"" + object.toString() + "\"\n");
        MCDDiagComPrimitive mCDDiagComPrimitive = null;
        try {
            this.m_outWriter.print("trying to create diag com prim\n");
            mCDDiagComPrimitive = mCDLogicalLink.createDiagComPrimitiveByName(string);
            if (mCDDiagComPrimitive != null) {
                this.m_outWriter.print("trying to get request parameter\n");
                MCDRequestParameter mCDRequestParameter = mCDDiagComPrimitive.getRequest().getRequestParameters().getItemByName(string2);
                if (mCDRequestParameter != null) {
                    this.m_outWriter.print("trying to set parameter value\n");
                    if (this.setParameterValue(mCDRequestParameter, object)) {
                        this.printPDUOfService(mCDDiagComPrimitive);
                        this.m_outWriter.print("trying to executesync service\n");
                        mCDResult = mCDDiagComPrimitive.executeSync();
                        if (mCDResult != null) {
                            this.m_outWriter.print("execute Sync, fertig");
                            this.printResponsePDU(mCDResult);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.m_outWriter);
        }
        return mCDResult;
    }

    private long getSeedFromResult(MCDResult mCDResult) throws MCDException {
        this.m_outWriter.print("starting getSeedFromResult\n");
        if (mCDResult == null) {
            return -1L;
        }
        long l = -1L;
        try {
            if (mCDResult != null && !mCDResult.hasError()) {
                MCDResponses mCDResponses = mCDResult.getResponses();
                int n = 0;
                while ((long)n < mCDResponses.getCount()) {
                    this.m_outWriter.print("get response number " + Long.toString(mCDResponses.getCount()) + "\n");
                    MCDResponse mCDResponse = mCDResponses.getItemByIndex((long)n);
                    MCDResponseParameters mCDResponseParameters = mCDResponse.getResponseParameters();
                    MCDResponseParameter mCDResponseParameter = mCDResponseParameters.getItemByName("Param_SecurAccesSeed");
                    MCDValue mCDValue = mCDResponseParameter.getValue();
                    l = mCDValue.getUint32();
                    ++n;
                }
            } else {
                this.m_outWriter.print("result with seed has error\n");
                MCDError mCDError = mCDResult.getError();
                if (mCDError != null) {
                    this.m_outWriter.print("Error.Code = " + Integer.toString(mCDError.getCode()) + "\n");
                    this.m_outWriter.print("Error.CodeDescription = " + mCDError.getCodeDescription() + "\n");
                    this.m_outWriter.print("Error.VendorCodeDescription = " + mCDError.getVendorCodeDescription() + "\n");
                }
            }
        }
        catch (MCDException mCDException) {
            mCDException.printStackTrace(this.m_outWriter);
            this.m_outWriter.print("\n");
        }
        return l;
    }

    private boolean checkResult(MCDResult mCDResult) {
        try {
            MCDResponses mCDResponses = mCDResult.getResponses();
            MCDResponse mCDResponse = mCDResponses.getItemByIndex(0L);
            MCDValue mCDValue = mCDResponse.getResponseMessage();
            byte[] byArray = mCDValue.getBytefield();
            if (null == byArray || byArray.length == 0) {
                return false;
            }
            byte by = byArray[0];
            for (int i = 0; i < byArray.length; ++i) {
                this.m_outWriter.print(Integer.toHexString(byArray[i]) + ", ");
            }
            if (by == 127) {
                return false;
            }
        }
        catch (MCDException mCDException) {
            this.m_outWriter.print("exception!\n");
            return false;
        }
        this.m_outWriter.print("\n ");
        return true;
    }

    private MCDResult sendHexService(MCDLogicalLink mCDLogicalLink, MCDJobApi mCDJobApi, byte by, byte[] byArray) throws MCDException {
        MCDHexService mCDHexService = (MCDHexService)mCDLogicalLink.createDiagComPrimitiveByType(1190);
        ((DtsHexService)mCDHexService).setServiceID((long)by);
        MCDRequest mCDRequest = mCDHexService.getRequest();
        MCDValue mCDValue = mCDJobApi.createValue(3);
        mCDValue.setBytefield(byArray);
        mCDRequest.enterPDU(mCDValue);
        MCDResult mCDResult = mCDHexService.executeSync();
        return mCDResult;
    }
}

