/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary3.util.dserver;

import asam.d.MCDDbDataPrimitive;
import asam.d.MCDDbDiagTroubleCode;
import asam.d.MCDDbFlashJob;
import asam.d.MCDDbFlashSession;
import asam.d.MCDDbIdentDescription;
import asam.d.MCDDbLocation;
import asam.d.MCDDbParameter;
import asam.d.MCDDbResponseParameter;
import asam.d.MCDException;
import asam.d.MCDExecutionState;
import asam.d.MCDInterval;
import asam.d.MCDLogicalLink;
import asam.d.MCDParameter;
import asam.d.MCDTextTableElement;
import asam.d.MCDTextTableElements;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary3.util.dserver.DServerVendor;
import com.audi.mcd.joblibrary3.util.dserver.McdTextTableHelper;
import com.audi.mcd.joblibrary3.util.dserver.TableHelper;
import com.audi.mcd.joblibrary3.util.dserver.impl.VendorSpecificDsaProdisMcdImpl;
import com.audi.mcd.joblibrary3.util.dserver.impl.VendorSpecificSiemensSidisImpl;
import com.audi.mcd.joblibrary3.util.dserver.impl.VendorSpecificSoftingDtsImpl;
import com.audi.mcd.joblibrary3.util.dserver.impl.VendorSpecificSoftingDtsMCD20001Impl;
import com.audi.mcd.joblibrary3.util.logging.Logger;
import java.lang.reflect.Field;

public abstract class VendorSpecific
implements McdTextTableHelper,
TableHelper {
    private static DServerVendor serverVendor = DServerVendor.UNKNOWN;

    public abstract int determineResponseStateFromPdus(byte[] var1, byte[] var2);

    public abstract MCDDbFlashJob getDbFlashJobOfDbFlashSession(MCDDbFlashSession var1, MCDDbLocation var2) throws MCDException;

    public abstract MCDDbDataPrimitive getDbDataPrimitiveOfDbIdentDescription(MCDDbIdentDescription var1, MCDDbLocation var2) throws MCDException;

    public abstract MCDDbResponseParameter getDbResponseParameterOfDbIdentDescription(MCDDbIdentDescription var1, MCDDbLocation var2);

    public abstract String getLongNameIDOfDbDiagTroubleCode(MCDDbDiagTroubleCode var1);

    public abstract String getLongNameIDOfDbUnitOfDbParameter(MCDDbParameter var1);

    public abstract String getLongNameIDOfDbUnitOfParameter(MCDParameter var1);

    public abstract MCDValue getLowerLimitFromInterval(MCDInterval var1) throws MCDException;

    public abstract int getLowerLimitIntervalTypeFromInterval(MCDInterval var1) throws MCDException;

    public abstract MCDTextTableElement getTextTableElementByCodedValueUint32(MCDTextTableElements var1, long var2);

    public abstract MCDTextTableElements getTextTableElementsOfDbResponseParameter(MCDDbResponseParameter var1);

    public abstract MCDValue getUpperLimitFromInterval(MCDInterval var1) throws MCDException;

    public abstract int getUpperLimitIntervalTypeFromInterval(MCDInterval var1) throws MCDException;

    public abstract String pduValue2String(MCDValue var1) throws MCDException;

    private static final DServerVendor determineServerVendor(Logger pLogger, MCDLogicalLink pLogicalLink) {
        Class<?> mcdLogicalLinkClass = null;
        String mcdLogicalLinkClassName = null;
        pLogger.debug("Trying to determine D server vendor...");
        mcdLogicalLinkClass = pLogicalLink.getClass();
        mcdLogicalLinkClassName = mcdLogicalLinkClass.getName();
        pLogger.debug("Class name of MCDLogicalLink instance: " + mcdLogicalLinkClassName);
        if (mcdLogicalLinkClassName.equals(DServerVendor.SOFTING.getMcdLogicalLinkClassName())) {
            pLogger.debug("...found Softing DTS server.");
            serverVendor = DServerVendor.SOFTING;
            return serverVendor;
        }
        pLogger.debug("...NOT a Softing DTS server.");
        if (mcdLogicalLinkClassName.equals(DServerVendor.DSA.getMcdLogicalLinkClassName())) {
            pLogger.debug("...found DSA PRODIS.MCD server.");
            serverVendor = DServerVendor.DSA;
            return serverVendor;
        }
        pLogger.debug("...NOT a DSA PRODIS.MCD server.");
        if (mcdLogicalLinkClassName.indexOf(DServerVendor.SIEMENS.getMcdLogicalLinkClassName()) != -1) {
            pLogger.debug("...found Siemens SIDIS server.");
            serverVendor = DServerVendor.SIEMENS;
            return serverVendor;
        }
        pLogger.debug("...NOT a Siemens SIDIS server.");
        pLogger.fatal("...unable to determine D server vendor!");
        return serverVendor;
    }

    public static final VendorSpecific getInstance(Logger pLogger, MCDLogicalLink pLogicalLink) {
        serverVendor = VendorSpecific.determineServerVendor(pLogger, pLogicalLink);
        if (serverVendor.equals(DServerVendor.SOFTING)) {
            if (!VendorSpecific.isMcd20002Interface()) {
                pLogger.warn("Softing DTS with deprecated MCD3D 2.00.01 interface detected... you should upgrade your DTS installation!");
                return new VendorSpecificSoftingDtsMCD20001Impl(pLogger);
            }
            return new VendorSpecificSoftingDtsImpl(pLogger);
        }
        if (serverVendor.equals(DServerVendor.DSA)) {
            return new VendorSpecificDsaProdisMcdImpl(pLogger);
        }
        if (serverVendor.equals(DServerVendor.SIEMENS)) {
            return new VendorSpecificSiemensSidisImpl(pLogger);
        }
        pLogger.fatal("Unable to determine vendor specific implementation class! Returning null... this might lead to errors!");
        return null;
    }

    public static final DServerVendor getServerVendor() {
        return serverVendor;
    }

    private static final boolean isMcd20002Interface() {
        Field[] fields = null;
        fields = MCDExecutionState.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("eALL_FAILED")) continue;
            return true;
        }
        return false;
    }
}

