/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDbLocation;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.GregorianCalendar;

public class MCD3_StandECUCodinWrite
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20140130";
    static /* synthetic */ Class class$asam$d$MCDDbLocation;

    public MCD3_StandECUCodinWrite() {
        super(REVISION, OutputParameterValue.StandECUCodinWrite.JobStatusCode.class, OutputParameterValue.StandECUCodinWrite.JobStatusInformation.class);
    }

    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        try {
            this.jobStatus = 0;
            this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
            this.logger.debug("Preparing job result.");
            MCDResult jobResult = null;
            Object[] resTemp = this.addResponse(pSingleEcuJob, this.logicalLink.getDbObject().getDbLocation());
            jobResult = (MCDResult)resTemp[0];
            MCDResponse jobResponse = (MCDResponse)resTemp[1];
            try {
                this.logger.debug("Main 1: Writing date...");
                this.writeDate(pLogicalLink);
                this.logger.debug("Main 2: Writing fingerprint...");
                this.writeTesterSerialNumber(pLogicalLink, pRequestParameters);
                this.logger.debug("Main 3: Writing coding value...");
                this.writeCodingValue(pLogicalLink, pRequestParameters);
                this.logger.debug("Main 4: Resetting ECU...");
                this.ecuReset(pLogicalLink);
            }
            catch (Exception e) {
                this.setStatus(jobResponse, this.jobStatus);
                this.dumpAndSendFinalResult(jobResult);
                this.logger.finalize(this.getCurrentJobRuntimeAsString());
                this.logger.exit();
                return;
            }
            this.setStatus(jobResponse, this.jobStatus);
            this.dumpAndSendFinalResult(jobResult);
            this.logger.debug("Main end");
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
            return;
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
        }
    }

    protected int readInputParameters(MCDRequestParameters pRequestParameters) {
        return 0;
    }

    private void ecuReset(MCDLogicalLink pLogicalLink) throws Exception {
        MCDResult result1 = null;
        try {
            if ("TRUE".equals(this.inputParameters.getItemByName("IPA_SupprECUResetAfterCodin").getValue().getValueAsString())) {
                this.logger.debug("Skip ECU Reset!");
                return;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
        }
        try {
            MCDDiagComPrimitive wdbi = pLogicalLink.createDiagComPrimitiveByName("DiagnServi_ECUResetKeyOffOnReset");
            result1 = wdbi.executeSync();
        }
        catch (Exception e) {
            this.jobStatus = 1;
            this.logger.logThrowable(e);
            throw new Exception();
        }
        if (result1.hasError()) {
            this.jobStatus = 1;
            throw new Exception();
        }
        try {
            MCDResponse response = result1.getResponses().getItemByIndex(0L);
            byte[] responsePDU = response.getResponseMessage().getBytefield();
            if (responsePDU == null || responsePDU.length == 0 || responsePDU[0] == 127) {
                this.jobStatus = 1;
            } else {
                this.logger.debug("Sleeping for 2000 milliseconds...");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    this.logger.error("Sleeping thread was interrupted unexpectedly!");
                }
            }
        }
        catch (Exception e) {
            this.jobStatus = 1;
            this.logger.logThrowable(e);
            throw new Exception();
        }
    }

    private void writeCodingValue(MCDLogicalLink pLogicalLink, MCDRequestParameters pRequestParameters) throws Exception {
        MCDResult result1 = null;
        try {
            MCDDiagComPrimitive wdbi = pLogicalLink.createDiagComPrimitiveByName("DiagnServi_WriteDataByIdentVariaCodin");
            MCDRequestParameter tableKeyParam = wdbi.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
            MCDValue tableKeyParamVal = tableKeyParam.createValue();
            tableKeyParamVal.setValueAsString("VW Coding Value");
            tableKeyParam.setValue(tableKeyParamVal);
            MCDRequestParameters params = wdbi.getRequest().getRequestParameters().getItemByName("Param_DataRecor").getParameters();
            int i = 0;
            while ((long)i < params.getCount()) {
                this.logger.debug("Param[" + i + "]: " + params.getItemByIndex((long)i).getShortName());
                ++i;
            }
            MCDRequestParameter paramToWrite = params.getCount() == 1L && params.getItemByIndex(0L).getType() == 17 ? params.getItemByName("TABROW_VWCodinValue").getParameters().getItemByName("Param_RawData") : params.getItemByName("Param_RawData");
            MCDValue paramToWriteVal = paramToWrite.createValue();
            paramToWriteVal.setBytefield(pRequestParameters.getItemByName("IPA_VWCodinValue").getValue().getBytefield());
            paramToWrite.setValue(paramToWriteVal);
            this.printRequest(wdbi);
            result1 = wdbi.executeSync();
            if (result1.hasError() || this.responseNotAcknowledged(result1)) {
                this.logger.debug("Error1a");
                this.printMCDResult(result1);
                this.jobStatus = 2;
                this.setKnownErrors(result1);
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.logger.debug("Error0");
            this.logger.logThrowable(e);
            this.jobStatus = 2;
            throw e;
        }
    }

    private void writeTesterSerialNumber(MCDLogicalLink pLogicalLink, MCDRequestParameters pRequestParameters) throws Exception {
        try {
            MCDDiagComPrimitive wdbi = pLogicalLink.createDiagComPrimitiveByName("DiagnServi_WriteDataByIdentECUIdent");
            MCDRequestParameter tableKeyParam = wdbi.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
            MCDValue tableKeyParamVal = tableKeyParam.createValue();
            tableKeyParamVal.setValueAsString("Repair Shop Code Or Tester Serial Number");
            tableKeyParam.setValue(tableKeyParamVal);
            MCDRequestParameters params = wdbi.getRequest().getRequestParameters().getItemByName("Param_DataRecor").getParameters();
            int i = 0;
            while ((long)i < params.getCount()) {
                this.logger.debug("Param[" + i + "]: " + params.getItemByIndex((long)i).getShortName());
                ++i;
            }
            MCDRequestParameters testerSerialNumber = params.getCount() > 0L && params.getItemByIndex(0L).getShortName().startsWith("TABROW_") ? params.getItemByName("TABROW_RepaiShopCodeOrTesteSeriaNumbe").getParameters() : params;
            if (!this.setSerialNumberSingleValues(pRequestParameters, testerSerialNumber) && !this.setSerialNumberByteValue(pRequestParameters, testerSerialNumber)) {
                throw new Exception("Failed to set TesterSerial Number!!");
            }
            this.printRequest(wdbi);
            MCDResult result1 = wdbi.executeSync();
            if (result1.hasError() || this.responseNotAcknowledged(result1)) {
                this.logger.debug("Error1b");
                this.printMCDResult(result1);
                this.jobStatus = 3;
                this.setKnownErrors(result1);
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.jobStatus = 3;
            this.logger.logThrowable(e);
            throw e;
        }
    }

    private boolean setSerialNumberByteValue(MCDRequestParameters pRequestParameters, MCDRequestParameters pTesterSerialNumber) {
        try {
            MCDValue ipaSerialNumbe = pRequestParameters.getItemByName("IPA_Finge").getValue();
            pTesterSerialNumber.getItemByName("Param_RepaiShopCodeOrTesteSeriaNumbe").setValue(ipaSerialNumbe);
            this.logger.debug("  use Param_RepaiShopCodeOrTesteSeriaNumbe");
            return true;
        }
        catch (Exception e) {
            Object ipaSerialNumbe = null;
            this.logger.debug("Can not access ipaSerialNumbe Parameter!");
            return false;
        }
    }

    private boolean setSerialNumberSingleValues(MCDRequestParameters pRequestParameters, MCDRequestParameters pTesterSerialNumber) {
        try {
            MCDValue ipaDeviceNumbe = pRequestParameters.getItemByName("IPA_VWDevicNumbe").getValue();
            MCDValue ipaImportNumbe = pRequestParameters.getItemByName("IPA_ImporNumbe").getValue();
            MCDValue ipaWorksNumbe = pRequestParameters.getItemByName("IPA_WorksNumbe").getValue();
            if (ipaDeviceNumbe.getUint32() != 0L || ipaImportNumbe.getUint32() != 0L || ipaWorksNumbe.getUint32() != 0L) {
                pTesterSerialNumber.getItemByName("Param_VWDevicNumbe").setValue(ipaDeviceNumbe);
                pTesterSerialNumber.getItemByName("Param_ImporNumbe").setValue(ipaImportNumbe);
                pTesterSerialNumber.getItemByName("Param_WorksNumbe").setValue(ipaWorksNumbe);
                this.logger.debug("  use Param_VWDevicNumbe Param_ImporNumbe Param_WorksNumbe");
                return true;
            }
        }
        catch (Exception e) {
            this.logger.debug("Can not access ipaDeviceNumbe, ipaImportNumbe, ipaWorksNumbe Parameter!");
        }
        return false;
    }

    private void writeDate(MCDLogicalLink mCDLogicalLink) {
        boolean programmingDateSupported = true;
        MCDRequestParameters programmingDate = null;
        GregorianCalendar calender = new GregorianCalendar();
        try {
            MCDDiagComPrimitive wdbin = mCDLogicalLink.createDiagComPrimitiveByName("DiagnServi_WriteDataByIdentECUIdent");
            MCDRequestParameter tableKeyParamN = wdbin.getRequest().getRequestParameters().getItemByName("Param_RecorDataIdent");
            MCDValue value = tableKeyParamN.createValue();
            try {
                value.setValueAsString("Programming Date");
                tableKeyParamN.setValue(value);
            }
            catch (MCDException mcde) {
                this.logger.warn("\"Programming Date\" is not supported by this ECU!");
                programmingDateSupported = false;
            }
            if (programmingDateSupported) {
                this.logger.debug("Main 1.1");
                MCDRequestParameters params = wdbin.getRequest().getRequestParameters().getItemByName("Param_DataRecor").getParameters();
                programmingDate = params.getCount() > 0L && params.getItemByIndex(0L).getShortName().startsWith("TABROW_") ? params.getItemByName("TABROW_ProgrDate").getParameters() : params;
                this.logger.debug("Main 1.2");
                MCDRequestParameters dateParams = programmingDate.getItemByName("Param_Date").getParameters();
                this.setDateParam(dateParams, "Param_Year", Integer.parseInt((calender.get(1) + "").substring(2)));
                this.setDateParam(dateParams, "Param_Month", calender.get(2) + 1);
                this.setDateParam(dateParams, "Param_Day", calender.get(5));
                this.logger.debug("Main 1.3");
                this.printRequest(wdbin);
                MCDResult resultDate = wdbin.executeSync();
                if (resultDate.hasError() || this.responseNotAcknowledged(resultDate)) {
                    this.jobStatus = 4;
                    this.setKnownErrors(resultDate);
                    this.printMCDResult(resultDate);
                }
            }
        }
        catch (Exception e) {
            this.jobStatus = 4;
            this.logger.logThrowable(e);
        }
    }

    private boolean setKnownErrors(MCDResult result) {
        try {
            byte[] pdu = result.getResponses().getItemByIndex(0L).getResponseMessage().getBytefield();
            if (pdu.length < 3) {
                return false;
            }
            if (pdu[2] == 49) {
                this.jobStatus = 13;
                return true;
            }
            if (pdu[2] == 34) {
                this.jobStatus = 12;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
        }
        return false;
    }

    private void setDateParam(MCDRequestParameters dateParams, String string, int i) throws MCDException {
        MCDRequestParameter param = dateParams.getItemByName(string);
        MCDValue value = param.createValue();
        this.logger.debug(string + " " + i + ":  " + new BigInteger("" + i, 16).intValue());
        value.setUint32((long)i);
        param.setValue(value);
    }

    private void setStatus(MCDResponse jobResponse, int pJobStatus) {
        MCDResponseParameters params = null;
        try {
            params = jobResponse.getResponseParameters();
            MCDResponseParameter param = params.getItemByName("OPA_JobStatuInfor");
            MCDValue value = this.jobApi.createValue(14);
            value.setValueAsString(this.getJobStatusInformation());
            param.setValue(value);
            try {
                param = params.getItemByName("OPA_JobStatuCode");
                value = this.jobApi.createValue(11);
                value.setUint32((long)pJobStatus);
                param.setValue(value);
                this.logger.debug("Set Code " + pJobStatus + " = " + param.getValue().getUint32());
            }
            catch (Exception e) {
                this.logger.debug("Set Status Code failed!");
                this.logger.logThrowable(e);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Status failed!");
            this.logger.logThrowable(e);
        }
        try {
            if (this.mcdError != null) {
                ((MCDResult)((MCDResponses)jobResponse.getParent()).getParent()).setError(this.mcdError);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Error Object failed!");
            this.logger.logThrowable(e);
        }
    }

    private boolean responseNotAcknowledged(MCDResult result) {
        try {
            MCDResponse response;
            long numberOfResponses;
            MCDResponses responses = result.getResponses();
            if (responses != null && (numberOfResponses = responses.getCount()) >= 1L && (response = responses.getItemByIndex(0L)) != null) {
                int responseState = response.getState();
                this.logger.debug("Response state: " + McdEnumDecoder.decodeMcdResponseState(responseState));
                String responsePDU = this.vendorSpecific.pduValue2String(response.getResponseMessage());
                this.logger.debug("Response PDU: " + responsePDU);
            }
            return (responses = result.getResponses()) == null || responses.getCount() < 1L || (response = responses.getItemByIndex(0L)) == null || response.getState() != 26625;
        }
        catch (MCDException mcde) {
            this.logger.logThrowable(mcde);
            return true;
        }
    }

    private Object[] addResponse(MCDSingleEcuJob singleEcuJob, MCDDbLocation dbLocation) {
        Object[] list = new Object[2];
        try {
            Method[] methods = MCDResponses.class.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                Class<?>[] classes = method.getParameterTypes();
                if (classes.length == 2 && classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_StandECUCodinWrite.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation) && classes[1].isAssignableFrom(Boolean.TYPE)) {
                    method.setAccessible(true);
                    MCDResult result = singleEcuJob.createResult(1794, 0, "", 0, "", 0);
                    MCDResponses responses = result.getResponses();
                    list[0] = result;
                    list[1] = method.invoke((Object)responses, dbLocation, Boolean.TRUE);
                    return list;
                }
                if (classes.length != 1 || !classes[0].isAssignableFrom(class$asam$d$MCDDbLocation == null ? MCD3_StandECUCodinWrite.class$("asam.d.MCDDbLocation") : class$asam$d$MCDDbLocation)) continue;
                method.setAccessible(true);
                MCDResult result = singleEcuJob.createResult(1794, 49152, "", 0, "", 0);
                MCDResponses responses = result.getResponses();
                list[0] = result;
                list[1] = method.invoke((Object)responses, dbLocation);
                return list;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            throw new IllegalArgumentException("Can not MCDResponse#add(..) method! " + e.getMessage());
        }
        throw new IllegalArgumentException("Method MCDResponse#add(..) not found!");
    }

    protected int addOutputParameters(MCDResponse pResponse) {
        return 0;
    }
}

