/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary.util.impl;

import asam.d.MCDException;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.util.AddWithContentHelper;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import com.audi.mcd.joblibrary.util.logging.Logger;

public class AddWithContentHelperImpl
implements AddWithContentHelper {
    protected Logger logger = null;

    public AddWithContentHelperImpl(Logger pLogger) {
        this.logger = pLogger;
    }

    public MCDResponseParameter addElementWithContent(MCDResponseParameters pResponseParameters, MCDResponseParameter pResponseParameter) throws MCDException {
        MCDResponseParameter param_targetField = null;
        String shortNameOfTargetField = null;
        int typeOfTargetField = -1;
        int typeOfSourceFieldElement = -1;
        MCDResponseParameter param_targetFieldElement = null;
        this.logger.trace("Entering addElementWithContent(...).");
        param_targetField = (MCDResponseParameter)pResponseParameters.getParent();
        shortNameOfTargetField = param_targetField.getShortName();
        this.logger.debug("Adding element to FIELD '" + shortNameOfTargetField + "'.");
        typeOfTargetField = param_targetField.getType();
        if (typeOfTargetField != 22 && typeOfTargetField != 15) {
            this.logger.error("addMuxBranchByIndexWithContent(...) must NOT be called with a response parameter of type " + McdEnumDecoder.decodeMcdDataType(typeOfTargetField) + " as target!");
        }
        if ((typeOfSourceFieldElement = pResponseParameter.getType()) != 17) {
            this.logger.error("addMuxBranchByIndexWithContent(...) must NOT be called with a response parameter of type " + McdEnumDecoder.decodeMcdDataType(typeOfSourceFieldElement) + " as source!");
        }
        param_targetFieldElement = pResponseParameters.addElementWithContent(pResponseParameter);
        this.compareAndCompleteResponseParameter(pResponseParameter, param_targetFieldElement);
        this.logger.trace("Leaving addElementWithContent(...).");
        return param_targetFieldElement;
    }

    public MCDResponseParameter addMuxBranchByIndexWithContent(MCDResponseParameters pResponseParameters, short pIndexOfMuxBranch, MCDResponseParameters pMuxBranchParameters) throws MCDException {
        MCDResponseParameter param_targetMux = null;
        MCDResponseParameter param_sourceMuxBranch = null;
        String shortNameOfTargetMux = null;
        int typeOfTargetMux = -1;
        int typeOfSourceMuxBranch = -1;
        MCDResponseParameter param_targetMuxBranch = null;
        this.logger.trace("Entering addMuxBranchByIndexWithContent(...).");
        param_targetMux = (MCDResponseParameter)pResponseParameters.getParent();
        param_sourceMuxBranch = (MCDResponseParameter)pMuxBranchParameters.getParent();
        shortNameOfTargetMux = param_targetMux.getShortName();
        this.logger.debug("Adding MUX branch with index " + pIndexOfMuxBranch + " to MULTIPLEXER '" + shortNameOfTargetMux + "'.");
        typeOfTargetMux = param_targetMux.getType();
        if (typeOfTargetMux != 16) {
            this.logger.error("addMuxBranchByIndexWithContent(...) must NOT be called with a response parameter of type " + McdEnumDecoder.decodeMcdDataType(typeOfTargetMux) + " as target!");
        }
        if ((typeOfSourceMuxBranch = param_sourceMuxBranch.getType()) != 17) {
            this.logger.error("addMuxBranchByIndexWithContent(...) must NOT be called with a response parameter of type " + McdEnumDecoder.decodeMcdDataType(typeOfSourceMuxBranch) + " as source!");
        }
        param_targetMuxBranch = pResponseParameters.addMuxBranchByIndexWithContent(pIndexOfMuxBranch, pMuxBranchParameters);
        this.compareAndCompleteMuxBranch(param_sourceMuxBranch, param_targetMuxBranch);
        this.logger.trace("Leaving addMuxBranchByIndexWithContent(...).");
        return param_targetMuxBranch;
    }

    public MCDResponseParameter addMuxBranchWithContent(MCDResponseParameters pResponseParameters, String pShortNameOfMuxBranch, MCDResponseParameters pMuxBranchParameters) throws MCDException {
        MCDResponseParameter param_targetMux = null;
        MCDResponseParameter param_sourceMuxBranch = null;
        String shortNameOfTargetMux = null;
        String shortNameOfSourceMuxBranch = null;
        int typeOfTargetMux = -1;
        int typeOfSourceMuxBranch = -1;
        MCDResponseParameter param_targetMuxBranch = null;
        this.logger.trace("Entering addMuxBranchWithContent(...).");
        param_targetMux = (MCDResponseParameter)pResponseParameters.getParent();
        param_sourceMuxBranch = (MCDResponseParameter)pMuxBranchParameters.getParent();
        shortNameOfTargetMux = param_targetMux.getShortName();
        shortNameOfSourceMuxBranch = param_sourceMuxBranch.getShortName();
        this.logger.debug("Adding MUX branch '" + shortNameOfSourceMuxBranch + "' to MULTIPLEXER '" + shortNameOfTargetMux + "'.");
        typeOfTargetMux = param_targetMux.getType();
        if (typeOfTargetMux != 16) {
            this.logger.error("addMuxBranchWithContent(...) must NOT be called with a response parameter of type " + McdEnumDecoder.decodeMcdDataType(typeOfTargetMux) + " as target!");
        }
        if ((typeOfSourceMuxBranch = param_sourceMuxBranch.getType()) != 17) {
            this.logger.error("addMuxBranchWithContent(...) must NOT be called with a response parameter of type " + McdEnumDecoder.decodeMcdDataType(typeOfSourceMuxBranch) + " as source!");
        }
        if (param_sourceMuxBranch.hasError()) {
            this.logger.warn("Source MUX branch has error! Adding empty MUX branch and copying content internally...");
            try {
                param_targetMuxBranch = pResponseParameters.addMuxBranch(pShortNameOfMuxBranch);
            }
            catch (MCDException mcde) {
                this.logger.warn("Error adding MUX empty branch!");
                this.logger.logThrowable(mcde);
            }
        } else {
            try {
                param_targetMuxBranch = pResponseParameters.addMuxBranchWithContent(pShortNameOfMuxBranch, pMuxBranchParameters);
            }
            catch (MCDException mcde) {
                this.logger.warn("Error adding MUX branch with content!");
                this.logger.logThrowable(mcde);
            }
        }
        if (param_targetMuxBranch != null) {
            this.compareAndCompleteMuxBranch(param_sourceMuxBranch, param_targetMuxBranch);
        }
        this.logger.trace("Leaving addMuxBranchWithContent(...).");
        return param_targetMuxBranch;
    }

    public boolean compareAndCompleteField(MCDResponseParameter pSourceParameter, MCDResponseParameter pTargetParameter) throws MCDException {
        MCDResponseParameters sourceParameters = null;
        MCDResponseParameters targetParameters = null;
        long numberOfSourceParametersFieldValue = 0L;
        long numberOfTargetParametersFieldValue = 0L;
        long numberOfSourceParameters = 0L;
        long numberOfTargetParameters = 0L;
        MCDResponseParameter currentSourceParameter = null;
        MCDResponseParameter currentTargetParameter = null;
        this.logger.trace("Entering compareAndCompleteField(...).");
        numberOfSourceParametersFieldValue = pSourceParameter.getValue().getUint32();
        numberOfTargetParametersFieldValue = pTargetParameter.getValue().getUint32();
        this.logger.debug("Number of source parameters (FIELD)     : " + numberOfSourceParametersFieldValue);
        this.logger.debug("Number of target parameters (FIELD)     : " + numberOfTargetParametersFieldValue);
        sourceParameters = pSourceParameter.getParameters();
        targetParameters = pTargetParameter.getParameters();
        numberOfSourceParameters = sourceParameters.getCount();
        numberOfTargetParameters = targetParameters.getCount();
        this.logger.debug("Number of source parameters (collection): " + numberOfSourceParameters);
        this.logger.debug("Number of target parameters (collection): " + numberOfTargetParameters);
        if (numberOfTargetParametersFieldValue != numberOfSourceParametersFieldValue && numberOfTargetParameters != numberOfSourceParameters && numberOfTargetParametersFieldValue == 0L && numberOfTargetParameters == 0L) {
            this.logger.debug("Copying " + (numberOfSourceParameters - numberOfTargetParameters) + " missing FIELD element(s) from source to target FIELD...");
            for (long i = 0L; i < numberOfSourceParameters; ++i) {
                currentSourceParameter = sourceParameters.getItemByIndex(i);
                if (currentSourceParameter.hasError()) {
                    this.logger.error("Aborting copy of FIELD elements at parameter with index " + i + " of " + (numberOfSourceParameters - 1L) + " since it has errors (and probably all following parameters would also be erroneous)!");
                    return false;
                }
                currentTargetParameter = targetParameters.addElementWithContent(currentSourceParameter);
                this.compareAndCompleteResponseParameter(currentSourceParameter, currentTargetParameter);
            }
        }
        this.logger.trace("Leaving compareAndCompleteField(...).");
        return true;
    }

    public void compareAndCompleteMultiplexer(MCDResponseParameter pSourceMultiplexer, MCDResponseParameter pTargetMultiplexer) throws MCDException {
        String shortNameOfSourceMultiplexer = null;
        String shortNameOfTargetMultiplexer = null;
        long branchIndexOfSourceMultiplexer = 0L;
        long branchIndexOfTargetMultiplexer = 0L;
        MCDResponseParameters sourceMuxBranches = null;
        MCDResponseParameters targetMuxBranches = null;
        long numberOfSourceMuxBranches = 0L;
        long numberOfTargetMuxBranches = 0L;
        MCDResponseParameter sourceMuxBranch = null;
        String shortNameOfSourceMuxBranch = null;
        MCDResponseParameters sourceMuxBranchParameters = null;
        this.logger.trace("Entering compareAndCompleteMultiplexer(...).");
        shortNameOfSourceMultiplexer = pSourceMultiplexer.getShortName();
        shortNameOfTargetMultiplexer = pTargetMultiplexer.getShortName();
        this.logger.debug("SHORT-NAME of source MULTIPLEXER: " + shortNameOfSourceMultiplexer);
        this.logger.debug("SHORT-NAME of target MULTIPLEXER: " + shortNameOfTargetMultiplexer);
        branchIndexOfSourceMultiplexer = pSourceMultiplexer.getValue().getUint32();
        branchIndexOfTargetMultiplexer = pTargetMultiplexer.getValue().getUint32();
        this.logger.debug("Branch index of source MULTIPLEXER: " + branchIndexOfSourceMultiplexer);
        this.logger.debug("Branch index of target MULTIPLEXER: " + branchIndexOfTargetMultiplexer);
        sourceMuxBranches = pSourceMultiplexer.getParameters();
        targetMuxBranches = pTargetMultiplexer.getParameters();
        numberOfSourceMuxBranches = sourceMuxBranches.getCount();
        numberOfTargetMuxBranches = targetMuxBranches.getCount();
        this.logger.debug("Number of branches in source MULTIPLEXER: " + numberOfSourceMuxBranches);
        this.logger.debug("Number of branches in target MULTIPLEXER: " + numberOfTargetMuxBranches);
        if (numberOfSourceMuxBranches == 1L && numberOfTargetMuxBranches == 0L) {
            this.logger.debug("Target MULTIPLEXER has no MUX branch selected...copying MUX branch from source MULTIPLEXER.");
            sourceMuxBranch = sourceMuxBranches.getItemByIndex(0L);
            shortNameOfSourceMuxBranch = sourceMuxBranch.getShortName();
            sourceMuxBranchParameters = sourceMuxBranch.getParameters();
            this.logger.debug("Copying source MUX branch '" + shortNameOfSourceMuxBranch + "' from source to target MULTIPLEXER.");
            this.addMuxBranchWithContent(targetMuxBranches, shortNameOfSourceMuxBranch, sourceMuxBranchParameters);
            numberOfTargetMuxBranches = targetMuxBranches.getCount();
            if (numberOfTargetMuxBranches != 1L) {
                this.logger.error("Number of MUX branches in target MULTIPLEXER: " + numberOfTargetMuxBranches);
            }
        }
        this.logger.trace("Leaving compareAndCompleteMultiplexer(...).");
    }

    public boolean compareAndCompleteMuxBranch(MCDResponseParameter pSourceMuxBranch, MCDResponseParameter pTargetMuxBranch) {
        int typeOfSourceMuxBranch = -1;
        int typeOfTargetMuxBranch = -1;
        String shortNameOfSourceMuxBranch = null;
        String shortNameOfTargetMuxBranch = null;
        MCDResponseParameters sourceMuxBranchParameters = null;
        MCDResponseParameters targetMuxBranchParameters = null;
        long numberOfSourceMuxBranchParameters = 0L;
        long numberOfTargetMuxBranchParameters = 0L;
        MCDResponseParameter currentSourceMuxBranchParameter = null;
        MCDResponseParameter currentTargetMuxBranchParameter = null;
        this.logger.trace("Entering compareAndCompleteMuxBranch(...).");
        try {
            typeOfSourceMuxBranch = pSourceMuxBranch.getType();
            typeOfTargetMuxBranch = pTargetMuxBranch.getType();
            this.logger.debug("Type of source parameter: " + McdEnumDecoder.decodeMcdDataType(typeOfSourceMuxBranch));
            this.logger.debug("Type of target parameter: " + McdEnumDecoder.decodeMcdDataType(typeOfTargetMuxBranch));
            if (typeOfTargetMuxBranch != typeOfSourceMuxBranch) {
                this.logger.error("The type of target MUX branch (" + McdEnumDecoder.decodeMcdDataType(typeOfTargetMuxBranch) + ") does NOT match the type of the source MUX branch (" + McdEnumDecoder.decodeMcdDataType(typeOfSourceMuxBranch) + ")!");
                return false;
            }
            shortNameOfSourceMuxBranch = pSourceMuxBranch.getShortName();
            shortNameOfTargetMuxBranch = pTargetMuxBranch.getShortName();
            this.logger.debug("SHORT-NAME of source MUX branch: " + shortNameOfSourceMuxBranch);
            this.logger.debug("SHORT-NAME of target MUX branch: " + shortNameOfTargetMuxBranch);
            if (!shortNameOfTargetMuxBranch.equals(shortNameOfTargetMuxBranch)) {
                this.logger.error("The SHORT-NAME of target MUX branch (" + shortNameOfTargetMuxBranch + ") does NOT match the SHORT-NAME of the source MUX branch (" + shortNameOfSourceMuxBranch + ")!");
                return false;
            }
            sourceMuxBranchParameters = pSourceMuxBranch.getParameters();
            targetMuxBranchParameters = pTargetMuxBranch.getParameters();
            numberOfSourceMuxBranchParameters = sourceMuxBranchParameters.getCount();
            numberOfTargetMuxBranchParameters = targetMuxBranchParameters.getCount();
            this.logger.debug("Number of parameters in source MUX branch: " + numberOfSourceMuxBranchParameters);
            this.logger.debug("Number of parameters in target MUX branch: " + numberOfTargetMuxBranchParameters);
            for (long i = 0L; i < numberOfSourceMuxBranchParameters; ++i) {
                currentSourceMuxBranchParameter = sourceMuxBranchParameters.getItemByIndex(i);
                currentTargetMuxBranchParameter = targetMuxBranchParameters.getItemByName(currentSourceMuxBranchParameter.getShortName());
                this.compareAndCompleteResponseParameter(currentSourceMuxBranchParameter, currentTargetMuxBranchParameter);
            }
        }
        catch (MCDException mcde) {
            this.logger.warn("Error checking copy of MUX branch!");
            this.logger.logThrowable(mcde);
        }
        this.logger.trace("Leaving compareAndCompleteMuxBranch(...).");
        return true;
    }

    public boolean compareAndCompleteResponseParameter(MCDResponseParameter pSourceParameter, MCDResponseParameter pTargetParameter) throws MCDException {
        int typeOfSourceParameter = -1;
        int typeOfTargetParameter = -1;
        String shortNameOfSourceParameter = null;
        String shortNameOfTargetParameter = null;
        MCDValue valueOfSourceParameter = null;
        MCDValue valueOfTargetParameter = null;
        String valueOfSourceParameterAsString = null;
        String valueOfTargetParameterAsString = null;
        this.logger.trace("Entering compareAndCompleteResponseParameter(...).");
        typeOfSourceParameter = pSourceParameter.getType();
        typeOfTargetParameter = pTargetParameter.getType();
        this.logger.debug("Type of source parameter: " + McdEnumDecoder.decodeMcdDataType(typeOfSourceParameter));
        this.logger.debug("Type of target parameter: " + McdEnumDecoder.decodeMcdDataType(typeOfTargetParameter));
        if (typeOfTargetParameter != typeOfSourceParameter) {
            this.logger.error("The type of the target parameter (" + McdEnumDecoder.decodeMcdDataType(typeOfTargetParameter) + ") does NOT match the type of the source parameter (" + McdEnumDecoder.decodeMcdDataType(typeOfSourceParameter) + ")!");
            return false;
        }
        shortNameOfSourceParameter = pSourceParameter.getShortName();
        shortNameOfTargetParameter = pTargetParameter.getShortName();
        this.logger.debug("SHORT-NAME of source parameter: " + shortNameOfSourceParameter);
        this.logger.debug("SHORT-NAME of target parameter: " + shortNameOfTargetParameter);
        if (!shortNameOfTargetParameter.equals(shortNameOfTargetParameter)) {
            this.logger.error("The SHORT-NAME of target parameter (" + shortNameOfTargetParameter + ") does NOT match the SHORT-NAME of the source parameter (" + shortNameOfSourceParameter + ")!");
            return false;
        }
        switch (typeOfSourceParameter) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 255: {
                try {
                    valueOfTargetParameter = pTargetParameter.getValue();
                    valueOfSourceParameter = pSourceParameter.getValue();
                    valueOfTargetParameterAsString = valueOfTargetParameter.getValueAsString();
                    valueOfSourceParameterAsString = valueOfSourceParameter.getValueAsString();
                    if (valueOfTargetParameterAsString.equals(valueOfSourceParameterAsString)) break;
                    this.logger.debug("MCD value of " + shortNameOfTargetParameter + " does not match value of source parameter... coyping value.");
                    pTargetParameter.setValue(pSourceParameter.getValue());
                }
                catch (MCDException mcde) {
                    this.logger.debug("MCD value of " + shortNameOfTargetParameter + " is unset... coyping value.");
                    pTargetParameter.setValue(pSourceParameter.getValue());
                }
                break;
            }
            case 15: 
            case 22: {
                this.compareAndCompleteField(pSourceParameter, pTargetParameter);
                break;
            }
            case 17: 
            case 21: 
            case 24: {
                this.compareAndCompleteStructure(pSourceParameter, pTargetParameter);
                break;
            }
            case 16: {
                this.compareAndCompleteMultiplexer(pSourceParameter, pTargetParameter);
                break;
            }
        }
        this.logger.trace("Leaving compareAndCompleteResponseParameter(...).");
        return true;
    }

    public boolean compareAndCompleteStructure(MCDResponseParameter pSourceParameter, MCDResponseParameter pTargetParameter) throws MCDException {
        MCDResponseParameters sourceParameters = null;
        MCDResponseParameters targetParameters = null;
        long numberOfSourceParameters = 0L;
        long numberOfTargetParameters = 0L;
        MCDResponseParameter currentSourceParameter = null;
        MCDResponseParameter currentTargetParameter = null;
        this.logger.trace("Entering compareAndCompleteStructure(...).");
        sourceParameters = pSourceParameter.getParameters();
        targetParameters = pTargetParameter.getParameters();
        numberOfSourceParameters = sourceParameters.getCount();
        numberOfTargetParameters = targetParameters.getCount();
        this.logger.debug("Number of source parameters (value)   : " + pSourceParameter.getValue().getUint32());
        this.logger.debug("Number of target parameters (value)   : " + pTargetParameter.getValue().getUint32());
        this.logger.debug("Number of source parameters (getCount): " + numberOfSourceParameters);
        this.logger.debug("Number of target parameters (getCount): " + numberOfTargetParameters);
        if (numberOfTargetParameters != numberOfSourceParameters) {
            this.logger.error("The number of target parameters (" + numberOfTargetParameters + ") does NOT match the number of source parameters (" + numberOfSourceParameters + ")!");
            if (numberOfTargetParameters > numberOfSourceParameters) {
                this.logger.debug("Dumping target parameters (incl. " + (numberOfTargetParameters - numberOfSourceParameters) + ") superfluous parameters...");
            }
            return false;
        }
        for (long i = 0L; i < numberOfSourceParameters; ++i) {
            currentSourceParameter = sourceParameters.getItemByIndex(i);
            currentTargetParameter = targetParameters.getItemByIndex(i);
            this.compareAndCompleteResponseParameter(currentSourceParameter, currentTargetParameter);
        }
        this.logger.trace("Leaving compareAndCompleteStructure(...).");
        return true;
    }
}

