/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary2.util;

public abstract class Conversions {
    public static final int BYTE_SIZE_INT = 4;
    public static final int BYTE_SIZE_LONG = 8;
    public static final String SHORT_NAME_IGNORED_CHARACTERS = "[^A-Za-z0-9]";

    public static final byte[] asciiString2ByteArray(String pAsciiString) {
        int length = pAsciiString.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)pAsciiString.charAt(i);
        }
        return bytes;
    }

    public static final byte byte2BCD(byte pByte) {
        byte bcdValue = 0;
        bcdValue = (byte)(pByte / 10 << 4 & 0xF0);
        bcdValue = (byte)(bcdValue | (byte)(pByte % 10));
        return bcdValue;
    }

    public static final String byteArray2String(byte[] pByteArray) {
        StringBuffer stringBuffer = null;
        if (pByteArray == null) {
            return "";
        }
        if (pByteArray.length == 0) {
            return "";
        }
        stringBuffer = new StringBuffer(pByteArray.length * 3 - 1);
        for (int i = 0; i < pByteArray.length; ++i) {
            stringBuffer.append("0".substring(Integer.toHexString(pByteArray[i] & 0xFF).length() - 1) + Integer.toHexString(pByteArray[i] & 0xFF) + " ");
        }
        return stringBuffer.toString().toUpperCase().trim();
    }

    public static final byte[] int2ByteArray(int pIntValue, int pArraySize) {
        int i;
        if (pArraySize <= 0) {
            throw new IllegalArgumentException("int2ByteArray must not be called with non-positive array size of " + pArraySize + "!");
        }
        if (pArraySize > 4) {
            throw new IllegalArgumentException("int2ByteArray must not be called with arraySize set to values exceeding 4!");
        }
        byte[] retval = new byte[pArraySize];
        for (i = 0; i < pArraySize; ++i) {
            retval[i] = 0;
        }
        for (i = pArraySize; i > 0; --i) {
            retval[i - 1] = (byte)((long)(pIntValue >> 8 * (pArraySize - i)) & 0xFFL);
        }
        return retval;
    }

    public static final byte[] hexString2ByteArray(String pHexString) throws IllegalArgumentException {
        int length = pHexString.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("hexString2ByteArray(...) must NOT be called with a string of odd length!");
        }
        byte[] bytes = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            bytes[i / 2] = (byte)(Character.digit(pHexString.charAt(i), 16) << 4);
            int n = i / 2;
            bytes[n] = (byte)(bytes[n] + (byte)Character.digit(pHexString.charAt(i + 1), 16));
        }
        return bytes;
    }

    public static final byte[] long2ByteArray(long pLongValue, int pArraySize) {
        int i;
        if (pArraySize <= 0) {
            throw new IllegalArgumentException("long2ByteArray must not be called with non-positive array size of " + pArraySize + "!");
        }
        if (pArraySize > 8) {
            throw new IllegalArgumentException("long2ByteArray must not be called with arraySize set to values exceeding 8!");
        }
        byte[] retval = new byte[pArraySize];
        for (i = 0; i < pArraySize; ++i) {
            retval[i] = 0;
        }
        for (i = pArraySize; i > 0; --i) {
            retval[i - 1] = (byte)(pLongValue >> 8 * (pArraySize - i) & 0xFFL);
        }
        return retval;
    }

    public static final int byteArray2Int(byte[] pByteArray) {
        if (pByteArray.length == 0) {
            throw new IllegalArgumentException("byteArray2Int must not be called with zero byte size!");
        }
        int retval = 0;
        for (int i = pByteArray.length; i > 0; --i) {
            retval = (int)((long)retval | (long)(pByteArray[i - 1] << 8 * (pByteArray.length - i)) & 255L << 8 * (pByteArray.length - i));
        }
        retval = (int)((long)retval & 0xFFFFFFFFL);
        return retval;
    }

    public static final long byteArray2Long(byte[] pByteArray) {
        if (pByteArray.length == 0) {
            throw new IllegalArgumentException("byteArray2Long must not be called with zero byte size!");
        }
        long retval = 0L;
        for (int i = pByteArray.length; i > 0; --i) {
            retval |= (long)(pByteArray[i - 1] << 8 * (pByteArray.length - i) & 255 << 8 * (pByteArray.length - i));
        }
        return retval &= 0xFFFFFFFFL;
    }

    public static final String longName2ShortName(String pPrefix, String pLongName) {
        String expectedShortName = pPrefix;
        String longName = pLongName;
        longName = Conversions.expandUmlauts(longName);
        String[] words = longName.split(SHORT_NAME_IGNORED_CHARACTERS);
        for (int i = 0; i < words.length; ++i) {
            int wordLength = words[i].length();
            if (wordLength == 0) continue;
            expectedShortName = expectedShortName + words[i].substring(0, 1).toUpperCase();
            if (wordLength == 1) continue;
            expectedShortName = wordLength <= 5 ? expectedShortName + words[i].substring(1) : expectedShortName + words[i].substring(1, 5);
        }
        return expectedShortName;
    }

    private static final String expandUmlauts(String pString) {
        String result = pString;
        result = result.replaceAll("\u00e4", "ae");
        result = result.replaceAll("\u00fc", "ue");
        result = result.replaceAll("\u00f6", "oe");
        result = result.replaceAll("\u00c4", "Ae");
        result = result.replaceAll("\u00dc", "Ue");
        result = result.replaceAll("\u00d6", "Oe");
        result = result.replaceAll("\u00df", "ss");
        return result;
    }
}

