/*
 * Decompiled with CFR 0.152.
 */
package com.audi.mcd.joblibrary3.util.parsers.swcnt.impl;

import com.audi.mcd.joblibrary3.util.Conversions;
import com.audi.mcd.joblibrary3.util.logging.Logger;
import com.audi.mcd.joblibrary3.util.parsers.swcnt.SwCnt;
import com.audi.mcd.joblibrary3.util.parsers.swcnt.SwCntParser;
import com.audi.mcd.joblibrary3.util.parsers.swcnt.impl.SwCntImpl;
import java.io.FileNotFoundException;
import java.io.FileReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SwCntParserImpl
implements SwCntParser {
    private Logger logger = null;
    private String fileName = null;
    private SwCnt swCnt = null;
    private boolean isElementContentParsed = false;
    private StringBuffer contentOfCurrentlyParsedElement = null;

    public SwCntParserImpl(Logger pLogger) {
        this.logger = pLogger;
    }

    public final boolean readXML(String pFileName) {
        this.logger.debug("Reading XML file \"" + pFileName + "\"...");
        FileReader fileReader = null;
        InputSource inputSource = null;
        XMLReader xmlReader = null;
        this.fileName = pFileName;
        try {
            fileReader = new FileReader(this.fileName);
        }
        catch (FileNotFoundException fne) {
            this.logger.debug("Error opening file: " + this.fileName);
            this.logger.logThrowable(fne);
            return false;
        }
        inputSource = new InputSource(fileReader);
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException se) {
            this.logger.warn("Error creating XML reader using defaults! (" + se.getLocalizedMessage() + ")");
            this.logger.debug("Trying Crimson XML reader...");
            try {
                xmlReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            }
            catch (SAXException se2) {
                this.logger.fatal("Error creating Crimson XML reader!");
                this.logger.logThrowable(se2);
                return false;
            }
        }
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(this);
        this.swCnt = new SwCntImpl();
        try {
            xmlReader.parse(inputSource);
        }
        catch (Exception e) {
            this.logger.debug("Error parsing " + this.fileName + "!");
            return false;
        }
        this.logger.debug(this.fileName + " read successfully.");
        return true;
    }

    public final SwCnt getSwCnt() {
        return this.swCnt;
    }

    public void error(SAXParseException pException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SW-CNT] Exception (error) while parsing " + this.fileName);
        stringBuffer.append(" at line " + pException.getLineNumber());
        stringBuffer.append(" / column " + pException.getColumnNumber());
        this.logger.debug(stringBuffer.toString());
        this.logger.debug("[SW-CNT] " + pException.getLocalizedMessage());
    }

    public void fatalError(SAXParseException pException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SW-CNT] Exception (fatal error) while parsing " + this.fileName);
        stringBuffer.append(" at line " + pException.getLineNumber());
        stringBuffer.append(" / column " + pException.getColumnNumber());
        this.logger.debug(stringBuffer.toString());
        this.logger.debug("[SW-CNT] " + pException.getLocalizedMessage());
    }

    public void warning(SAXParseException pException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SW-CNT] Exception (warning) while parsing " + this.fileName);
        stringBuffer.append(" at line " + pException.getLineNumber());
        stringBuffer.append(" / column " + pException.getColumnNumber());
        this.logger.debug(stringBuffer.toString());
        this.logger.debug("[SW-CNT] " + pException.getLocalizedMessage());
    }

    public void characters(char[] pCh, int pStart, int pLength) {
        if (this.isElementContentParsed && pLength > 0) {
            this.contentOfCurrentlyParsedElement.append(pCh, pStart, pLength);
        }
    }

    public void endDocument() {
        this.logger.debug("[SW-CNT] EndDocument");
    }

    public void endElement(String pNamespaceURI, String pLocalName, String pName) {
        String content = null;
        if (this.isElementContentParsed) {
            content = this.contentOfCurrentlyParsedElement.toString();
            content = content.trim();
            if (pLocalName.equals("CNT-DATEI")) {
                this.logger.debug("[SW-CNT] - CNT-DATEI             : " + content);
                this.swCnt.setContainerFile(content);
                this.isElementContentParsed = false;
            } else if (pLocalName.equals("CNT-VERSION-INHALT")) {
                this.logger.debug("[SW-CNT] - CNT-VERSION-INHALT    : " + content);
                this.swCnt.setContainerVersion(content);
                this.isElementContentParsed = false;
            } else if (pLocalName.equals("CNT-VERSION-DATUM")) {
                this.logger.debug("[SW-CNT] - CNT-VERSION-DATUM     : " + content);
                this.swCnt.setContainerVersionDate(content);
                this.isElementContentParsed = false;
            } else if (pLocalName.equals("DATEN-NAME")) {
                this.logger.debug("[SW-CNT] - DATEN-NAME           : " + content);
                this.swCnt.setDataName(content);
                this.isElementContentParsed = false;
            } else if (pLocalName.equals("DATEN-FORMAT-NAME")) {
                this.logger.debug("[SW-CNT] - DATEN-FORMAT-NAME    : " + content);
                this.swCnt.setDataFormatName(content);
                this.isElementContentParsed = false;
            } else if (pLocalName.equals("START-ADR")) {
                if ((content = content.trim()).startsWith("0x")) {
                    this.logger.warn("[SW-CNT] - WARNING: Removing unexpected leading '0x' from START-ADR '" + content + "'!");
                    content = content.substring(2);
                }
                content = content.toUpperCase();
                int startAddress = Integer.parseInt(content, 16);
                this.logger.debug("[SW-CNT] - START-ADR            : 0x" + Integer.toHexString(startAddress).toUpperCase());
                this.swCnt.setStartAddress(startAddress);
                this.isElementContentParsed = false;
            } else if (pLocalName.equals("GROESSE-DEKOMPRIMIERT")) {
                if ((content = content.trim()).startsWith("0x")) {
                    this.logger.warn("[SW-CNT] - WARNING: Removing unexpected leading '0x' from GROESSE-DEKOMPRIMIERT '" + content + "'!");
                    content = content.substring(2);
                }
                content = content.toUpperCase();
                int uncompressedSize = Integer.parseInt(content, 16);
                this.logger.debug("[SW-CNT] - GROESSE-DEKOMPRIMIERT: " + uncompressedSize + " (0x" + Integer.toHexString(uncompressedSize).toUpperCase() + ")");
                this.swCnt.setUncompressedSize(uncompressedSize);
                this.isElementContentParsed = false;
            } else if (pLocalName.equals("DATEN")) {
                content = content.toUpperCase();
                content = content.replaceAll("[^A-F0-9]", "");
                byte[] bytes = Conversions.hexString2ByteArray(content);
                this.logger.debug("[SW-CNT] - data bytes            : " + bytes.length + " (0x" + Integer.toHexString(bytes.length).toUpperCase() + ")");
                this.swCnt.setData(bytes);
                this.isElementContentParsed = false;
            }
        }
        this.logger.debug("[SW-CNT] EndElement: " + pLocalName);
    }

    public void endPrefixMapping(String pPrefix) {
    }

    public void ignorableWhitespace(char[] pCh, int pStart, int pLength) {
    }

    public void processingInstruction(String pTarget, String pData) {
    }

    public void setDocumentLocator(Locator pLocator) {
    }

    public void skippedEntity(String pName) {
    }

    public void startDocument() {
        this.logger.debug("[SW-CNT] StartDocument");
    }

    public void startElement(String pNamespaceURI, String pLocalName, String pName, Attributes pAttributes) {
        this.logger.debug("[SW-CNT] StartElement: " + pLocalName);
        if (pLocalName.equals("CNT-DATEI") || pLocalName.equals("CNT-VERSION-INHALT") || pLocalName.equals("CNT-VERSION-DATUM") || pLocalName.equals("DATEN-NAME") || pLocalName.equals("DATEN-FORMAT-NAME") || pLocalName.equals("START-ADR") || pLocalName.equals("GROESSE-DEKOMPRIMIERT") || pLocalName.equals("DATEN")) {
            this.isElementContentParsed = true;
            this.contentOfCurrentlyParsedElement = new StringBuffer();
        }
    }

    public void startPrefixMapping(String pPrefix, String pUri) {
    }
}

