/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDbRequestParameter;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponses;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;
import com.audi.mcd.joblibrary.util.Conversions;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;

public class MCD3_CompoListWrite
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20140130-D4C7TNF";

    public MCD3_CompoListWrite() {
        super(REVISION, OutputParameterValue.CompoListWrite.JobStatusCode.class, OutputParameterValue.CompoListWrite.JobStatusInformation.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        this.jobStatus = 0;
        try {
            this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
            this.logger.debug("Catch Inputs..");
            boolean[] codedBits = this.getCodedBits(pRequestParameters.getItemByName("IPA_CompoListInput"));
            this.writeBits(codedBits);
            this.logger.debug("success!");
            this.jobStatus = 0;
        }
        catch (IllegalAccessException iae) {
        }
        catch (Exception e) {
            this.jobStatus = 10;
            this.logger.logThrowable(e);
        }
        finally {
            this.finalizeJob();
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
        }
    }

    protected int readInputParameters(MCDRequestParameters pRequestParameters) {
        return 0;
    }

    private void writeBits(boolean[] pCodedBitsToWrite) throws IllegalAccessException {
        MCDDiagComPrimitive writeDataByIdentifierGatewayComponentList = null;
        MCDRequestParameters requestParameters = null;
        MCDRequestParameter recordDataIdentifier = null;
        MCDValue recordDataIdentifierValue = null;
        MCDRequestParameter dataRecord = null;
        MCDRequestParameters tableRowsDts = null;
        MCDRequestParameter field = null;
        int codingBytesToWrite = 0;
        long currentNumberOfItems = 0L;
        MCDRequestParameters fieldElements = null;
        MCDRequestParameter currentFieldElement = null;
        MCDRequestParameters fieldElementParameters = null;
        String[] fieldElementParameterShortNames = new String[]{"Param_ECUCodedBit7", "Param_ECUCodedBit6", "Param_ECUCodedBit5", "Param_ECUCodedBit4", "Param_ECUCodedBit3", "Param_ECUCodedBit2", "Param_ECUCodedBit1", "Param_ECUCodedBit0"};
        int currentCodingBit = 0;
        MCDRequestParameter currentFieldElementParameter = null;
        MCDValue currentFieldElementParameterValue = null;
        MCDResult result = null;
        try {
            this.logger.debug("Write component List..");
            writeDataByIdentifierGatewayComponentList = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_WriteDataByIdentGatewCompoList");
            requestParameters = writeDataByIdentifierGatewayComponentList.getRequest().getRequestParameters();
            recordDataIdentifier = requestParameters.getItemByName("Param_RecorDataIdent");
            recordDataIdentifierValue = recordDataIdentifier.createValue();
            recordDataIdentifierValue.setValueAsString("Gateway Component List");
            recordDataIdentifier.setValue(recordDataIdentifierValue);
            dataRecord = requestParameters.getItemByName("Param_DataRecor");
            if (dataRecord.getType() == 17 && (dataRecord = (tableRowsDts = dataRecord.getParameters()).getItemByName(Conversions.longName2ShortName("TABROW_", "Gateway Component List"))) == null) {
                throw new IllegalArgumentException(Conversions.longName2ShortName("TABROW_", "Gateway Component List") + " not found");
            }
            field = dataRecord.getParameters().getItemByName("Param_ECUCoded");
            codingBytesToWrite = (int)Math.ceil((double)pCodedBitsToWrite.length / 8.0);
            this.logger.debug("bits / bytes to be written: " + pCodedBitsToWrite.length + " / " + codingBytesToWrite);
            this.logger.debug("Values of END-OF-PDU-FIELD parameter");
            this.logger.debug("- ShortName                                     : " + field.getShortName());
            this.logger.debug("- data type                                     : " + McdEnumDecoder.decodeMcdDataType(field.getType()));
            this.logger.debug("- MinLength                                     : " + field.getDbObject().getMinLength());
            this.logger.debug("- MaxLength                                     : " + field.getDbObject().getMaxLength());
            this.logger.debug("- MAX-NUMBER-OF-ITEMS                           : " + ((MCDDbRequestParameter)field.getDbObject()).getMaxNumberOfItems());
            this.logger.debug("- currentNumberOfItems (value before getCount()): " + field.getValue().getUint32());
            currentNumberOfItems = field.getParameters().getCount();
            this.logger.debug("- currentNumberOfItems (value after  getCount()): " + field.getValue().getUint32());
            this.logger.debug("- currentNumberOfItems (count)                  : " + currentNumberOfItems);
            field.addParameters((long)codingBytesToWrite - currentNumberOfItems);
            fieldElements = field.getParameters();
            this.logger.debug(" length check: " + fieldElements.getCount() + " == " + codingBytesToWrite);
            for (int currentCodingByte = 0; currentCodingByte < codingBytesToWrite; ++currentCodingByte) {
                this.logger.debug(" Do loop: " + currentCodingByte);
                currentFieldElement = fieldElements.getItemByIndex((long)currentCodingByte);
                fieldElementParameters = currentFieldElement.getParameters();
                for (int currentBit = 0; currentBit < fieldElementParameterShortNames.length; ++currentBit) {
                    if (currentCodingBit < pCodedBitsToWrite.length) {
                        this.logger.debug(" Do setParam(" + currentCodingBit + "): " + fieldElementParameterShortNames[currentBit] + " to " + pCodedBitsToWrite[currentCodingBit]);
                    } else {
                        this.logger.debug(" Do setParam(" + currentCodingBit + "): " + fieldElementParameterShortNames[currentBit] + " to default");
                    }
                    currentFieldElementParameter = fieldElementParameters.getItemByName(fieldElementParameterShortNames[currentBit]);
                    currentFieldElementParameterValue = currentFieldElementParameter.createValue();
                    if (currentCodingBit < pCodedBitsToWrite.length && pCodedBitsToWrite[currentCodingBit]) {
                        currentFieldElementParameterValue.setValueAsString("yes");
                    } else {
                        currentFieldElementParameterValue.setValueAsString("no");
                    }
                    currentFieldElementParameter.setValue(currentFieldElementParameterValue);
                    ++currentCodingBit;
                }
            }
            try {
                this.mcdObjectDumper.dumpRequest(writeDataByIdentifierGatewayComponentList.getRequest(), 1, false);
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
            }
            try {
                result = writeDataByIdentifierGatewayComponentList.executeSync();
                if (result.hasError() || this.responseNotAcknowledged(result)) {
                    this.logger.debug("DiagnServi_WriteDataByIdentGatewCompoList has negative result!");
                    this.printMCDResult(result);
                    this.jobStatus = 10;
                    throw new IllegalAccessException();
                }
            }
            catch (MCDException mcde) {
                this.logger.debug("Error executing service!");
                this.logger.logThrowable(mcde);
            }
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.logger.debug("Error writing component list! ");
            this.logger.logThrowable(e);
            this.jobStatus = 10;
            throw new IllegalAccessException();
        }
    }

    private boolean[] getCodedBits(MCDRequestParameter inputStruct) throws IllegalAccessException {
        MCDRequestParameters fieldElements = null;
        MCDRequestParameter currentFieldElementParameter = null;
        long numberOfFieldElements = 0L;
        try {
            this.logger.debug("Extract Inputs from Field..");
            fieldElements = inputStruct.getParameters().getItemByName("Param_CompoListInput").getParameters();
            numberOfFieldElements = fieldElements.getCount();
            boolean[] result = new boolean[(int)numberOfFieldElements];
            int currentFieldElement = 0;
            while ((long)currentFieldElement < numberOfFieldElements) {
                try {
                    currentFieldElementParameter = fieldElements.getItemByIndex((long)currentFieldElement).getParameters().getItemByName("Param_ECUCoded");
                    result[currentFieldElement] = "yes".equals(currentFieldElementParameter.getValue().getValueAsString());
                }
                catch (Exception e) {
                    result[currentFieldElement] = false;
                    this.logger.debug("ERROR: Failed to access InputParameter! " + currentFieldElement);
                    throw e;
                }
                this.logger.debug("  " + currentFieldElement + ": " + result[currentFieldElement]);
                ++currentFieldElement;
            }
            return result;
        }
        catch (Exception e) {
            this.logger.debug("Failed to access JobinputParameter! ");
            this.logger.logThrowable(e);
            this.jobStatus = 2;
            throw new IllegalAccessException();
        }
    }

    private boolean responseNotAcknowledged(MCDResult result) {
        try {
            MCDResponse response;
            MCDResponses responses = result.getResponses();
            return responses == null || responses.getCount() < 1L || (response = responses.getItemByIndex(0L)) == null || response.getState() != 26625;
        }
        catch (MCDException e) {
            this.logger.logThrowable(e);
            return true;
        }
    }
}

