/*
 * Decompiled with CFR 0.152.
 */
package com.in2soft.audi.b8.jobs.mcd201;

import asam.d.MCDDbDiagTroubleCode;
import asam.d.MCDDbDiagTroubleCodes;
import asam.d.MCDDbParameters;
import asam.d.MCDDbResponseParameter;
import asam.d.MCDDiagComPrimitive;
import asam.d.MCDException;
import asam.d.MCDJob;
import asam.d.MCDJobApi;
import asam.d.MCDLogicalLink;
import asam.d.MCDRequest;
import asam.d.MCDRequestParameter;
import asam.d.MCDRequestParameters;
import asam.d.MCDResponse;
import asam.d.MCDResponseParameter;
import asam.d.MCDResponseParameters;
import asam.d.MCDResult;
import asam.d.MCDSingleEcuJob;
import asam.d.MCDValue;
import com.audi.mcd.joblibrary.constants.value.OutputParameterValue;
import com.audi.mcd.joblibrary.jobs.in2soft.impl.AbstractIn2SoftSingleEcuJobImpl;
import com.audi.mcd.joblibrary.util.AddWithContentHelper;
import com.audi.mcd.joblibrary.util.McdEnumDecoder;
import com.audi.mcd.joblibrary.util.impl.AddWithContentHelperImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MCD3_ReadAllDTCFreezFrame
extends AbstractIn2SoftSingleEcuJobImpl {
    private static final String REVISION = "00.01.20140130";
    protected static final String[] SRV_EXTENDED_RESPONSE = new String[]{"Param_StatuOfDTCBit0", "Param_StatuOfDTCBit1", "Param_StatuOfDTCBit2", "Param_StatuOfDTCBit3", "Param_StatuOfDTCBit4", "Param_StatuOfDTCBit5", "Param_StatuOfDTCBit6", "Param_StatuOfDTCBit7"};
    protected static final String[] DEFAULT_VALUES = new String[]{"passive", "Test Not Failed This Operation Cycle", "Pending DTC", "Confirmed DTC", "Test Completed Since Last Clear", "Test Not Failed Since Last Clear", "Test Completed This Monitoring Cycle", "Warning Indicator Off"};
    protected static final String[][] ON_OFF_MAPPING = new String[][]{{"active", "passive"}, {"Test Failed This Operation Cycle", "Test Not Failed This Operation Cycle"}, {"Pending DTC", "Not Pending DTC"}, {"Confirmed DTC", "Not Confirmed DTC"}, {"Test Not Completed Since Last Clear", "Test Completed Since Last Clear"}, {"Test Failed Since Last Clear", "Test Not Failed Since Last Clear"}, {"Test Not Completed This Monitoring Cycle", "Test Completed This Monitoring Cycle"}, {"Warning Indicator On", "Warning Indicator Off"}};
    protected static final String[] SERVICE_BIT_NAMING = new String[]{"Param_DTCStatuMaskStatuOfDTCBit0", "Param_DTCStatuMaskStatuOfDTCBit1", "Param_DTCStatuMaskStatuOfDTCBit2", "Param_DTCStatuMaskStatuOfDTCBit3", "Param_DTCStatuMaskStatuOfDTCBit4", "Param_DTCStatuMaskStatuOfDTCBit5", "Param_DTCStatuMaskStatuOfDTCBit6", "Param_DTCStatuMaskStatuOfDTCBit7"};
    protected static final String[] JOB_INPUT_BIT_NAMING = new String[]{"Param_DTCStatuTestFaile", "Param_DTCStatuTestFaileThisOperaCycle", "Param_DTCStatuPendiDTC", "Param_DTCStatuConfiDTC", "Param_DTCStatuTestNotComplSinceLastClear", "Param_DTCStatuTestFaileSinceLastClear", "Param_DTCStatuTestNotComplThisOperaCycle", "Param_DTCStatuWarniIndicReque"};
    protected boolean isFilterActive = false;
    protected String extendedDataRecordNumbersToRead = null;
    protected long subMask;
    protected long targetState;
    protected Set filterMap = new TreeSet();
    protected Map dtcToDisplayCode = new TreeMap();
    protected Map dtcToStruct = new TreeMap();
    protected MCDValue availibilityMask = null;
    protected long numberOfDTCs = 0L;
    protected AddWithContentHelper addWithContentHelper = null;

    public MCD3_ReadAllDTCFreezFrame() {
        this(false, "All DTC Extended Data Record Numbers");
    }

    protected MCD3_ReadAllDTCFreezFrame(boolean pIsFilterActive, String pExtendedDataRecordNumbersToRead) {
        super(REVISION, OutputParameterValue.ReadAllDTCFreezFrame.JobStatusCode.class, OutputParameterValue.ReadAllDTCFreezFrame.JobStatusInformation.class);
        this.isFilterActive = pIsFilterActive;
        this.extendedDataRecordNumbersToRead = pExtendedDataRecordNumbersToRead;
        this.addWithContentHelper = new AddWithContentHelperImpl(this.logger);
    }

    protected boolean filtered(String s) {
        if (!this.isFilterActive) {
            return false;
        }
        this.logger.debug("Filter: " + this.filterMap.contains(s));
        if (this.filterMap.contains(s)) {
            return true;
        }
        this.filterMap.add(s);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(MCDRequestParameters pRequestParameters, MCDJobApi pJobApi, MCDLogicalLink pLogicalLink, MCDSingleEcuJob pSingleEcuJob) {
        block14: {
            MCDResponseParameter jobResultStructure = null;
            MCDResult jobResult = null;
            MCDResponse jobResponse = null;
            Map dtcList = null;
            this.jobStatus = 0;
            this.prepareJobGuarded(pRequestParameters, pJobApi, pLogicalLink, (MCDJob)pSingleEcuJob);
            this.logger.debug("Init..");
            jobResult = this.createFinalResult();
            jobResponse = this.addResponse(jobResult, true);
            this.logger.debug("Get JobOutput Structure..");
            jobResultStructure = jobResponse.getResponseParameters().getItemByName("OPA_JobResul");
            this.collectDTCs();
            this.logger.debug("----------------------- Read out State Mask from Input ----------------");
            this.readOutStateMasks();
            this.logger.debug("----------------------- Request DTC for every Bit   ----------------");
            dtcList = this.extractDTCAndStateMap();
            this.printDTCResult(dtcList);
            this.logger.debug("----------------------- Read extended Information   ----------------");
            this.readExtendedDTCInfo(jobResultStructure, dtcList, this.availibilityMask);
            this.logger.debug("success!");
            try {
                this.setNumberOfDTCs(jobResponse, this.numberOfDTCs);
                this.setStatus(jobResponse, this.jobStatus);
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
            }
            this.dumpAndSendFinalResult(jobResult);
            this.logger.finalize(this.getCurrentJobRuntimeAsString());
            this.logger.exit();
            break block14;
            catch (IllegalAccessException iae) {
                try {
                    this.setNumberOfDTCs(jobResponse, this.numberOfDTCs);
                    this.setStatus(jobResponse, this.jobStatus);
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
                this.dumpAndSendFinalResult(jobResult);
                this.logger.finalize(this.getCurrentJobRuntimeAsString());
                this.logger.exit();
            }
            catch (Exception e) {
                this.jobStatus = 2;
                this.logger.logThrowable(e);
                {
                    catch (Throwable throwable) {
                        try {
                            this.setNumberOfDTCs(jobResponse, this.numberOfDTCs);
                            this.setStatus(jobResponse, this.jobStatus);
                        }
                        catch (Exception e2) {
                            this.logger.logThrowable(e2);
                        }
                        this.dumpAndSendFinalResult(jobResult);
                        this.logger.finalize(this.getCurrentJobRuntimeAsString());
                        this.logger.exit();
                        throw throwable;
                    }
                }
                try {
                    this.setNumberOfDTCs(jobResponse, this.numberOfDTCs);
                    this.setStatus(jobResponse, this.jobStatus);
                }
                catch (Exception e3) {
                    this.logger.logThrowable(e3);
                }
                this.dumpAndSendFinalResult(jobResult);
                this.logger.finalize(this.getCurrentJobRuntimeAsString());
                this.logger.exit();
            }
        }
    }

    protected int readInputParameters(MCDRequestParameters pRequestParameters) {
        return 0;
    }

    protected void printDTCResult(Map dtcList) {
        if (this.logger.getLogLevel() < 5) {
            return;
        }
        try {
            this.logger.debug("---------------- Found DTC Mapping for TargetState " + Long.toBinaryString(this.targetState) + " Submask: " + Long.toBinaryString(this.subMask) + " --------");
            Iterator iter = dtcList.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.logger.debug("DTC 0x" + Long.toHexString((Long)entry.getKey()).toUpperCase() + " State " + Long.toBinaryString((Long)entry.getValue()));
            }
            this.logger.debug("---------------------------------------------------");
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
        }
    }

    protected Map extractDTCAndStateMap() throws IllegalAccessException {
        TreeMap<Long, Long> dtcList = null;
        MCDDiagComPrimitive service19020C = null;
        MCDRequestParameters srvInput = null;
        int bit = 1;
        MCDResponseParameters readDTCResultParameters = null;
        MCDResponseParameters currentDTC = null;
        Long dtcValue = null;
        long dtcState = 0L;
        this.logger.debug("Start readDTC by Status Mask");
        dtcList = new TreeMap<Long, Long>();
        try {
            service19020C = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDTCInforReporDTCByStatuMask");
            srvInput = service19020C.getRequest().getRequestParameters();
        }
        catch (Exception e) {
            this.jobStatus = 2;
            this.logger.debug("Create DiagnServi_ReadDTCInforReporDTCByStatuMask failed!");
            this.logger.logThrowable(e);
            throw new IllegalAccessException();
        }
        this.logger.debug("Iterate over all bits..");
        for (int i = 0; i < SERVICE_BIT_NAMING.length; ++i) {
            block10: {
                try {
                    this.logger.debug(Long.toBinaryString(this.targetState) + " & " + Long.toBinaryString(bit) + " = " + Long.toBinaryString(this.targetState & (long)bit));
                    if ((this.targetState & (long)bit) != (long)(1 << i)) break block10;
                    this.logger.debug("~~~~~~ Execute Request for Bitmask  " + Long.toBinaryString(bit) + " ~~~~~~~~~~~~~");
                    this.setServiceInputStateBit(srvInput, i);
                    readDTCResultParameters = this.executeReadbyStatusMask(service19020C);
                    long size = readDTCResultParameters.getCount();
                    for (long k = 0L; k < size; ++k) {
                        this.logger.debug("iterate over results..(" + k + "-" + size + ")");
                        currentDTC = readDTCResultParameters.getItemByIndex(k).getParameters();
                        dtcValue = null;
                        try {
                            dtcValue = new Long(currentDTC.getItemByName("Param_DTCUDS").getDbDTC().getTroubleCode());
                        }
                        catch (MCDException mcde) {
                            dtcValue = new Long(currentDTC.getItemByName("Param_DTCUDS").getValue().getUint32());
                        }
                        this.dtcToStruct.put(dtcValue, currentDTC);
                        dtcState = this.getDTCStatus(currentDTC);
                        if (dtcList.containsKey(dtcValue)) {
                            dtcState |= ((Long)dtcList.get(dtcValue)).longValue();
                        }
                        dtcList.put(dtcValue, new Long(dtcState));
                        this.logger.debug("Store 0x" + Long.toHexString(dtcValue) + " - " + Long.toBinaryString(dtcState) + ")");
                    }
                }
                catch (IllegalAccessException iae) {
                }
                catch (Exception e) {
                    this.logger.logThrowable(e);
                }
            }
            bit <<= 1;
        }
        return dtcList;
    }

    protected MCDResponseParameters executeReadbyStatusMask(MCDDiagComPrimitive service19020C) throws IllegalAccessException {
        MCDResult result19020C = null;
        MCDResponse response19020C = null;
        this.logger.debug("Sub 2");
        try {
            this.printRequest(service19020C);
            result19020C = service19020C.executeSync();
            try {
                this.logger.debug("ReadByStatuMask: Request:" + this.vendorSpecific.pduValue2String(service19020C.getRequest().getPDU()) + "\n\t\tResponsePDU: " + this.vendorSpecific.pduValue2String(result19020C.getResponses().getItemByIndex(0L).getResponseMessage()));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.jobApi.setProgress(this.logicalLink, (MCDDiagComPrimitive)this.job, (short)10);
            this.logger.debug("Sub 3");
            if (result19020C.hasError() && result19020C.getError().getCode() != 49192) {
                this.jobStatus = 2;
                this.logger.debug("has Error: true");
                this.logger.logMcdError(result19020C.getError());
                throw new IllegalAccessException();
            }
            response19020C = result19020C.getResponses().getItemByName("Resp_ReadDTCInforReporDTCByStatuMask");
            if (this.logger.getLogLevel() >= 6) {
                this.mcdObjectDumper.dumpResponse(response19020C, 1, false);
            }
            try {
                this.availibilityMask = response19020C.getResponseParameters().getItemByName("Param_DTCStatuAvailMask").getValue();
            }
            catch (Exception e) {
                this.logger.debug("Failed to get Availibility Mask");
                this.logger.logThrowable(e);
            }
            return response19020C.getResponseParameters().getItemByName("Param_DTCAndStatuRecor").getParameters();
        }
        catch (Exception e2) {
            try {
                this.logger.debug("RequestPDU: " + this.vendorSpecific.pduValue2String(service19020C.getRequest().getPDU()));
                if (result19020C != null) {
                    this.logger.debug(" Response:" + this.vendorSpecific.pduValue2String(result19020C.getResponses().getItemByIndex(0L).getResponseMessage()));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.logger.logThrowable(e2);
            this.jobStatus = 2;
            throw new IllegalAccessException();
        }
    }

    protected void setServiceInputStateBit(MCDRequestParameters srvInput, int pOn) throws Exception {
        MCDRequestParameter srvBitparam = null;
        MCDValue value = null;
        this.logger.debug("Set ServiceInputParameter for bit # " + pOn);
        for (int i = 0; i < SERVICE_BIT_NAMING.length; ++i) {
            srvBitparam = srvInput.getItemByName(SERVICE_BIT_NAMING[i]);
            value = srvBitparam.getValue();
            value.setValueAsString(ON_OFF_MAPPING[i][i == pOn ? 0 : 1]);
            srvBitparam.setValue(value);
        }
    }

    protected void readExtendedDTCInfo(MCDResponseParameter jobResultStructure, Map dtcList, MCDValue availMask) throws Exception {
        String filterKey = null;
        boolean envDataFilter = false;
        boolean withEnvDataFilter = false;
        Map.Entry dtcEntry = null;
        long dtcValue = 0L;
        String displayTroubleCode = null;
        MCDResponseParameter structure = null;
        this.logger.debug("Start Read Extended DTC:");
        try {
            filterKey = this.inputParameters.getItemByName("IPA_FilteByReporEnvirData").getValue().getValueAsString();
            if ("all DTCs".equals(filterKey)) {
                withEnvDataFilter = false;
                envDataFilter = false;
            } else {
                envDataFilter = true;
                withEnvDataFilter = "DTCs with environment data only".equals(filterKey);
            }
        }
        catch (MCDException mcde) {
            this.logger.debug("Failed setting EnvDataExist filter");
            this.logger.logThrowable(mcde);
            withEnvDataFilter = false;
            envDataFilter = false;
        }
        this.logger.debug("Filtermode: EnvDataFilter = " + (envDataFilter ? "On" : "Off") + " : " + (withEnvDataFilter ? "with Data" : "without Data"));
        try {
            this.setAvailibilityMask(jobResultStructure, availMask);
            this.logger.debug("Sub 5");
            Iterator iterator = dtcList.entrySet().iterator();
            while (iterator.hasNext()) {
                dtcEntry = iterator.next();
                dtcValue = (Long)dtcEntry.getKey();
                this.logger.debug("~~~~~~~~~ Extended Request for DTC 0x" + Long.toHexString(dtcValue) + " ~~~~~~~~~~~~~");
                this.logger.debug("Iter DTCs (" + dtcValue + ") 1");
                displayTroubleCode = "";
                try {
                    this.logger.debug("Looking for DTC 0x" + Long.toHexString(dtcValue).toUpperCase());
                    displayTroubleCode = ((MCDDbDiagTroubleCode)this.dtcToDisplayCode.get(new Long(dtcValue))).getDisplayTroubleCode();
                    this.logger.debug("DTC: [" + displayTroubleCode + "]");
                    if (this.filtered(displayTroubleCode)) continue;
                    this.logger.debug("Iter DTCs (" + dtcValue + ") 2");
                }
                catch (Exception e) {
                    this.jobStatus = 3;
                    displayTroubleCode = "P000000";
                }
                this.logger.debug("Iter DTCs (" + dtcValue + ") 3");
                try {
                    long dtcState;
                    MCDResponseParameters parameters = null;
                    long completeDatasCounter = 0L;
                    MCDResult result1906 = null;
                    if (this.extendedDataRecordNumbersToRead != null) {
                        result1906 = this.getExtendedResult(dtcValue);
                    }
                    if (result1906 == null && this.extendedDataRecordNumbersToRead != null && envDataFilter && withEnvDataFilter) continue;
                    if (result1906 != null) {
                        this.logger.debug("Iter DTCs (" + dtcValue + ") 3a");
                        MCDResponseParameters responseParams = result1906.getResponses().getItemByIndex(0L).getResponseParameters();
                        if (this.logger.getLogLevel() >= 6) {
                            try {
                                this.mcdObjectDumper.dumpResponseParameters(responseParams, 1);
                                this.logger.flush();
                            }
                            catch (MCDException mcde) {
                                this.logger.debug("Error dumping response parameters of 19 06!");
                                this.logger.logThrowable(mcde);
                            }
                        }
                        MCDResponseParameter param_DTCAndStatuRecor = responseParams.getItemByName("Param_DTCAndStatuRecor");
                        MCDResponseParameter param_DTCExtenDataRecorSTRUCT = responseParams.getItemByName("Param_DTCExtenDataRecor");
                        dtcState = this.getDTCStatus(param_DTCAndStatuRecor.getParameters());
                        this.logger.debug("Iter DTCs (" + dtcValue + ") 4 " + MCD3_ReadAllDTCFreezFrame.getInfo(param_DTCExtenDataRecorSTRUCT));
                        MCDResponseParameter eNVDAT_DTCExtenDataRecorFIELD = null;
                        if (param_DTCExtenDataRecorSTRUCT.getParameters().getCount() == 0L) {
                            if (envDataFilter && withEnvDataFilter) {
                                continue;
                            }
                        } else {
                            eNVDAT_DTCExtenDataRecorFIELD = param_DTCExtenDataRecorSTRUCT.getParameters().getItemByIndex(0L);
                            if (eNVDAT_DTCExtenDataRecorFIELD.getType() == 21) {
                                eNVDAT_DTCExtenDataRecorFIELD = eNVDAT_DTCExtenDataRecorFIELD.getParameters().getItemByIndex(0L);
                            }
                            this.logger.debug("Iter DTCs (" + dtcValue + ") 5 " + MCD3_ReadAllDTCFreezFrame.getInfo(eNVDAT_DTCExtenDataRecorFIELD));
                            parameters = eNVDAT_DTCExtenDataRecorFIELD.getParameters();
                            completeDatasCounter = parameters.getCount();
                            this.logger.debug("EnviromentData Exist-Filter " + (envDataFilter ? "" : "not ") + "found!");
                            if (envDataFilter && (withEnvDataFilter && completeDatasCounter <= 0L || !withEnvDataFilter && completeDatasCounter > 0L)) {
                                continue;
                            }
                        }
                    } else {
                        dtcState = (Long)dtcEntry.getValue();
                    }
                    this.logger.debug("Iter DTCs (" + dtcValue + ") 11");
                    MCDResponseParameter dtcInfoRecor = jobResultStructure.getParameters().getItemByName("Param_EOPFDTCInforParam").getParameters().addElement();
                    structure = dtcInfoRecor.getType() == 22 ? dtcInfoRecor.getParameters().getItemByIndex(dtcInfoRecor.getParameters().getCount() - 1L) : dtcInfoRecor;
                    this.setDTCSetInformation(structure, displayTroubleCode, dtcValue, dtcState);
                    this.setDTCAndSet(structure, dtcValue);
                    this.setActiveParam(dtcState, structure);
                    ++this.numberOfDTCs;
                    if (result1906 == null) {
                        if (envDataFilter) continue;
                        this.jobStatus = 4;
                        continue;
                    }
                    MCDResponseParameter Param_EnvDatasCount = structure.getParameters().getItemByName("Param_EnvDatasCount");
                    MCDResponseParameter Param_EnvDatasEOPF = structure.getParameters().getItemByName("Param_EnvDatas");
                    MCDValue datasCountValue = Param_EnvDatasCount.getValue();
                    datasCountValue.setUint32(completeDatasCounter);
                    Param_EnvDatasCount.setValue(datasCountValue);
                    if (parameters == null) continue;
                    for (long dataID = 0L; dataID < parameters.getCount(); ++dataID) {
                        this.logger.debug("Iter DTCs (" + dtcValue + ") 12 ");
                        MCDResponseParameter paramSTRUC_DTCExtenDataRecor = parameters.getItemByIndex(dataID);
                        this.logger.debug("Iter DTCs (" + dtcValue + ") 12b " + MCD3_ReadAllDTCFreezFrame.getInfo(paramSTRUC_DTCExtenDataRecor));
                        this.logger.debug("Iter DTCs (" + dtcValue + ") 13 ");
                        MCDResponseParameters param_STRUC_DTCExtenDataRecorCollection = paramSTRUC_DTCExtenDataRecor.getParameters();
                        this.logger.debug("Iter DTCs (" + dtcValue + ") 13 : Iter pages over " + param_STRUC_DTCExtenDataRecorCollection.getCount() + " Elements");
                        int envDataInd = 0;
                        while ((long)envDataInd < param_STRUC_DTCExtenDataRecorCollection.getCount()) {
                            block35: {
                                try {
                                    this.logger.debug("Iter DTCs (" + dtcValue + ") 13 : Iter pages 1");
                                    MCDResponseParameter muxParamDTCExtenDataRecor = param_STRUC_DTCExtenDataRecorCollection.getItemByIndex((long)envDataInd);
                                    this.logger.debug("Iter DTCs (" + dtcValue + ") 13 : Iter pages 3 " + MCD3_ReadAllDTCFreezFrame.getInfo(muxParamDTCExtenDataRecor));
                                    if (muxParamDTCExtenDataRecor.hasError() && !muxParamDTCExtenDataRecor.getParameters().getItemByIndex(0L).getShortName().equals("Case_StandFreezFrameDynam")) {
                                        this.logger.debug("Omitting environment data with index " + envDataInd + " (" + muxParamDTCExtenDataRecor.getParameters().getItemByIndex(0L).getShortName() + ") since it has error!");
                                        datasCountValue.setUint32(datasCountValue.getUint32() - 1L);
                                        Param_EnvDatasCount.setValue(datasCountValue);
                                        break block35;
                                    }
                                    long numberOfMuxBranches = muxParamDTCExtenDataRecor.getParameters().getCount();
                                    if (numberOfMuxBranches != 1L) {
                                        this.logger.debug("Omitting environment data with index " + envDataInd + " due to MUX with unset MUX branch!");
                                        datasCountValue.setUint32(datasCountValue.getUint32() - 1L);
                                        Param_EnvDatasCount.setValue(datasCountValue);
                                        break block35;
                                    }
                                    MCDResponseParameter caseBranch = muxParamDTCExtenDataRecor.getParameters().getItemByIndex(0L);
                                    this.logger.debug("Iter DTCs (" + dtcValue + ") 13 : Iter pages 4" + MCD3_ReadAllDTCFreezFrame.getInfo(caseBranch));
                                    this.logger.debug("SHORT-NAME of Param_EnvDatasEOPF: " + Param_EnvDatasEOPF.getShortName());
                                    this.logger.debug("Type of Param_EnvDatasEOPF: " + McdEnumDecoder.decodeMcdDataType(Param_EnvDatasEOPF.getType()));
                                    MCDResponseParameter envDataSTRUCT = Param_EnvDatasEOPF.getParameters().addElement();
                                    this.logger.debug("SHORT-NAME of envDataSTRUCT: " + envDataSTRUCT.getShortName());
                                    this.logger.debug("Type of envDataSTRUCT: " + McdEnumDecoder.decodeMcdDataType(envDataSTRUCT.getType()));
                                    if (envDataSTRUCT.getType() == 22) {
                                        envDataSTRUCT = envDataSTRUCT.getParameters().getItemByIndex(envDataSTRUCT.getParameters().getCount() - 1L);
                                    }
                                    this.logger.debug("SHORT-NAME of envDataSTRUCT: " + envDataSTRUCT.getShortName());
                                    this.logger.debug("Type of envDataSTRUCT: " + McdEnumDecoder.decodeMcdDataType(envDataSTRUCT.getType()));
                                    MCDResponseParameter param_EnvDataMUX = envDataSTRUCT.getParameters().getItemByIndex(0L);
                                    this.logger.debug("SHORT-NAME of param_EnvDataMUX: " + param_EnvDataMUX.getShortName());
                                    this.logger.debug("Type of param_EnvDataMUX: " + McdEnumDecoder.decodeMcdDataType(param_EnvDataMUX.getType()));
                                    if (param_EnvDataMUX.getType() == 17) {
                                        param_EnvDataMUX = param_EnvDataMUX.getParameters().getItemByIndex(0L);
                                    }
                                    this.logger.debug("SHORT-NAME of param_EnvDataMUX: " + envDataSTRUCT.getShortName());
                                    this.logger.debug("Type of param_EnvDataMUX: " + McdEnumDecoder.decodeMcdDataType(param_EnvDataMUX.getType()));
                                    this.logger.debug("Iter DTCs (" + dtcValue + ") 13 : Iter pages 2");
                                    try {
                                        MCDDbResponseParameter dbMux = (MCDDbResponseParameter)param_EnvDataMUX.getDbObject();
                                        MCDDbParameters cases = dbMux.getDbParameters();
                                        int i = 0;
                                        while ((long)i < cases.getCount()) {
                                            MCDDbResponseParameter currentCase = (MCDDbResponseParameter)cases.getItemByIndex((long)i);
                                            this.logger.debug("CASE[" + i + "]: " + currentCase.getShortName());
                                            MCDDbParameters caseParams = currentCase.getDbParameters();
                                            int j = 0;
                                            while ((long)j < caseParams.getCount()) {
                                                MCDDbResponseParameter currentCaseParam = (MCDDbResponseParameter)caseParams.getItemByIndex((long)j);
                                                this.logger.debug(" PARAM[" + j + "]: " + currentCaseParam.getShortName());
                                                ++j;
                                            }
                                            ++i;
                                        }
                                    }
                                    catch (MCDException mcde) {
                                        this.logger.warn("Error dumping db MUX!");
                                        this.logger.logThrowable(mcde);
                                    }
                                    this.addWithContentHelper.addMuxBranchWithContent(param_EnvDataMUX.getParameters(), caseBranch.getShortName(), caseBranch.getParameters());
                                    this.logger.debug("Iter DTCs (" + dtcValue + ") 13 : Iter pages 5");
                                }
                                catch (Exception e) {
                                    this.jobStatus = 4;
                                    this.logger.logThrowable(e);
                                }
                            }
                            ++envDataInd;
                        }
                    }
                }
                catch (Exception e) {
                    this.jobStatus = 4;
                    this.logger.logThrowable(e);
                }
            }
        }
        catch (Exception e) {
            this.jobStatus = 2;
            this.logger.logThrowable(e);
        }
    }

    protected void setAvailibilityMask(MCDResponseParameter jobResultStructure, MCDValue availMask) {
        try {
            this.logger.debug("AvailibilityMask: " + availMask.getValueAsString());
            jobResultStructure.getParameters().getItemByName("Param_DTCStatuAvailMask").setValue(availMask);
        }
        catch (Exception e) {
            this.logger.debug("Failed to set AvailibilityMask!");
            this.logger.logThrowable(e);
        }
    }

    protected void setDTCSetInformation(MCDResponseParameter dtcInfoRecor, String displayTroubleCode, long dtcValue, long dtcState) throws MCDException {
        MCDResponseParameter structure = null;
        this.logger.debug("setDTCSetInformation 4");
        int i = 0;
        while ((long)i < dtcInfoRecor.getParameters().getCount()) {
            this.logger.debug("Parameter [" + i + "]: " + dtcInfoRecor.getParameters().getItemByIndex((long)i).getShortName());
            ++i;
        }
        this.logger.debug("Type of dtcInfoRecor: " + McdEnumDecoder.decodeMcdDataType(dtcInfoRecor.getType()));
        structure = dtcInfoRecor.getType() == 22 ? dtcInfoRecor.getParameters().getItemByIndex(dtcInfoRecor.getParameters().getCount() - 1L) : (dtcInfoRecor.getParameters().getCount() == 1L && dtcInfoRecor.getParameters().getItemByIndex(0L).getType() == 17 ? dtcInfoRecor.getParameters().getItemByIndex(0L) : dtcInfoRecor);
        this.logger.debug("Type of structure: " + McdEnumDecoder.decodeMcdDataType(dtcInfoRecor.getType()));
        MCDResponseParameter param = structure.getParameters().getItemByName("Param_DisplTroubCode");
        MCDValue value = this.jobApi.createValue(14);
        value.setValueAsString(displayTroubleCode);
        param.setValue(value);
        param = structure.getParameters().getItemByName("Param_TroubCodeValue");
        value = this.jobApi.createValue(11);
        value.setUint32(dtcValue);
        param.setValue(value);
        param = structure.getParameters().getItemByName("Param_DisplTroubCodeValue");
        value = this.jobApi.createValue(11);
        value.setUint32(MCD3_ReadAllDTCFreezFrame.toSae(displayTroubleCode));
        param.setValue(value);
        this.logger.debug("setDTCSetInformation 5");
        param = structure.getParameters().getItemByName("Param_StatuOfDTC");
        value = this.jobApi.createValue(11);
        value.setUint32(dtcState);
        param.setValue(value);
        this.logger.debug("setDTCSetInformation 6");
    }

    protected void setDTCAndSet(MCDResponseParameter dtcInfoRecor, long dtcValue) {
        MCDValue value;
        MCDResponseParameter param;
        MCDResponseParameter structure = null;
        MCDResponseParameter sourceParam = null;
        this.logger.debug("set DTC and Status Record 1");
        MCDResponseParameters sourceParams = (MCDResponseParameters)this.dtcToStruct.get(new Long(dtcValue));
        try {
            structure = dtcInfoRecor.getParameters().getCount() == 1L && dtcInfoRecor.getParameters().getItemByIndex(0L).getType() == 17 ? dtcInfoRecor.getParameters().getItemByIndex(0L) : dtcInfoRecor;
            MCDResponseParameters params = structure.getParameters().getItemByName("Param_DTCAndStatuRecor").getParameters();
            long size = sourceParams.getCount();
            for (long i = 0L; i < size; ++i) {
                try {
                    sourceParam = sourceParams.getItemByIndex(i);
                    param = params.getItemByName(sourceParam.getShortName());
                    param.setValue(sourceParam.getValue());
                    this.logger.debug("set DTC and Status Record : " + sourceParam.getShortName() + " -> " + param.getValue().getValueAsString());
                    continue;
                }
                catch (Exception e) {
                    this.logger.debug("Failed to copy current DTC and Status Record! " + (sourceParam != null ? sourceParam.getShortName() : ""));
                    this.logger.logThrowable(e);
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to copy DTC and Status Record! ");
            this.logger.logThrowable(e);
        }
        if (structure != null) {
            try {
                this.logger.debug("set Param_DTCText");
                param = structure.getParameters().getItemByName("Param_DTCText");
                MCDDbDiagTroubleCode code = (MCDDbDiagTroubleCode)this.dtcToDisplayCode.get(new Long(dtcValue));
                value = this.jobApi.createValue(14);
                value.setValueAsString(code == null ? "not Available" : code.getDTCText());
                param.setValue(value);
            }
            catch (Exception e) {
                this.logger.debug("Failed to set DTC Text: ");
                this.logger.logThrowable(e);
            }
        }
        if (structure != null) {
            try {
                String ti;
                block14: {
                    this.logger.debug("set Param_DTCTextTI");
                    param = structure.getParameters().getItemByName("Param_DTCTextTI");
                    MCDResponseParameter dtcParam = sourceParams.getItemByName("Param_DTCUDS");
                    try {
                        ti = this.vendorSpecific.getLongNameIDOfDbDiagTroubleCode(dtcParam.getDbDTC());
                    }
                    catch (Exception e) {
                        ti = "not Available";
                        this.logger.debug("Failed to set DTC Text TI, missing DTC-Dop Entry!!: ");
                        if (this.logger.getLogLevel() < 6) break block14;
                        this.logger.logThrowable(e);
                    }
                }
                value = this.jobApi.createValue(param.getType());
                value.setValueAsString(ti == null ? "not Available" : ti);
                param.setValue(value);
            }
            catch (Exception e) {
                this.logger.debug("Failed to set DTC Text TI: ");
                this.logger.logThrowable(e);
            }
            catch (Throwable t) {
                this.logger.debug("Failed to set DTC Text TI: ");
                this.logger.logThrowable(t);
            }
        }
    }

    protected MCDResult getExtendedResult(long dtcValue) throws MCDException {
        MCDDiagComPrimitive service1906 = this.logicalLink.createDiagComPrimitiveByName("DiagnServi_ReadDTCInforReporDTCExtenDataRecorByDTCNumbe");
        MCDRequest request1906 = service1906.getRequest();
        MCDRequestParameter requestParam = request1906.getRequestParameters().getItemByName("Param_DTCMaskRecorGroupOfDTC");
        MCDValue value = requestParam.createValue();
        value.setUint32(dtcValue);
        requestParam.setValue(value);
        this.logger.debug("getExtendedResult DTCs 7");
        requestParam = request1906.getRequestParameters().getItemByName("Param_DTCExtenDataRecorNumbe");
        MCDValue val = requestParam.getValue();
        val.setValueAsString(this.extendedDataRecordNumbersToRead);
        requestParam.setValue(val);
        this.printRequest(service1906);
        MCDResult result1906 = service1906.executeSync();
        try {
            this.logger.debug("ExtendedDTCInfo:\nResponse PDU: " + this.vendorSpecific.pduValue2String(result1906.getResponses().getItemByIndex(0L).getResponseMessage()));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.logger.debug("getExtendedResult DTCs 8");
        if (result1906.hasError()) {
            this.printMCDResult(result1906);
        }
        this.logger.debug("getExtendedResult DTCs 9");
        MCDResponse response1906 = result1906.getResponses().getItemByIndex(0L);
        if (!response1906.getShortName().equals("Resp_ReadDTCInforReporDTCExtenDataRecorByDTCNumbe")) {
            this.logger.debug("ERROR: getExtendedResult DTCs (x) negative response on DiagnServi_ReadDTCInforReporDTCExtenDataRecorByDTCNumbe");
            this.printMCDResult(result1906);
            try {
                this.logger.debug("Error: " + response1906.getResponseParameters().getItemByName("Param_NegatRespoCode").getValue().getValueAsString());
            }
            catch (Exception e) {
                // empty catch block
            }
            return null;
        }
        return result1906;
    }

    protected void readOutStateMasks() {
        MCDRequestParameters ipaMaskParams;
        boolean oldBehaviour = false;
        int bit = 1;
        try {
            this.logger.debug("Extract StateMask from JobInputparameter");
            MCDRequestParameter ipaMask = this.inputParameters.getItemByName("IPA_DTCStatuMask");
            ipaMaskParams = ipaMask.getParameters();
            this.subMask = 0L;
            this.targetState = 0L;
        }
        catch (MCDException mcde) {
            this.logger.debug("No IPA_DTCStatuMask found! Default filtering used!");
            this.logger.logThrowable(mcde);
            ipaMaskParams = null;
            oldBehaviour = true;
            this.subMask = -1L;
            this.targetState = -1L;
        }
        for (int i = 0; i < JOB_INPUT_BIT_NAMING.length; ++i) {
            if (oldBehaviour) {
                if (DEFAULT_VALUES[i].equals(ON_OFF_MAPPING[i][0])) {
                    this.targetState |= (long)bit;
                }
                this.logger.debug("A_Bit " + i + " isSet to default with target: " + DEFAULT_VALUES[i].equals(ON_OFF_MAPPING[i][0]));
            } else {
                try {
                    if (ipaMaskParams != null) {
                        String temp = ipaMaskParams.getItemByName(JOB_INPUT_BIT_NAMING[i]).getValue().getValueAsString();
                        if ("don't care".equals(temp)) {
                            this.subMask |= (long)bit;
                            if (DEFAULT_VALUES[i].equals(ON_OFF_MAPPING[i][0])) {
                                this.targetState |= (long)bit;
                            }
                            this.logger.debug("B_Bit " + i + " isSet to " + temp + " with target: " + DEFAULT_VALUES[i].equals(ON_OFF_MAPPING[i][0]));
                        } else if ("on".equals(temp)) {
                            this.targetState |= (long)bit;
                            this.logger.debug("C_Bit " + i + " isSet to " + temp + " with target: " + true);
                        } else {
                            this.logger.debug("D_Bit " + i + " isSet to " + temp + " with target: " + false);
                        }
                    }
                }
                catch (MCDException mcde) {
                    this.logger.logThrowable(mcde);
                }
            }
            bit <<= 1;
        }
        this.logger.debug("SubMask: " + Long.toBinaryString(this.subMask) + " TargetState " + Long.toBinaryString(this.targetState));
    }

    protected long getDTCStatus(MCDResponseParameters parameters) {
        int statusOfDTC = 0;
        long mask = 1L;
        MCDResponseParameter param_currentStatusBit = null;
        MCDValue currentStatusBitValue = null;
        String currentStatusBitAsString = null;
        try {
            this.logger.debug("Extracting DTCState " + parameters.getCount());
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < SRV_EXTENDED_RESPONSE.length; ++i) {
            try {
                param_currentStatusBit = null;
                try {
                    param_currentStatusBit = parameters.getItemByName(SRV_EXTENDED_RESPONSE[i]);
                }
                catch (MCDException mcde) {
                    // empty catch block
                }
                if (param_currentStatusBit != null) {
                    currentStatusBitValue = param_currentStatusBit.getValue();
                    currentStatusBitAsString = currentStatusBitValue.getValueAsString();
                    this.logger.debug("Compare Bit " + i + ":" + ON_OFF_MAPPING[i][0] + " == " + currentStatusBitAsString);
                    if (ON_OFF_MAPPING[i][0].equals(currentStatusBitAsString)) {
                        this.logger.debug(i + " " + SRV_EXTENDED_RESPONSE[i] + ": is ON (" + ON_OFF_MAPPING[i][0] + ")");
                        statusOfDTC = (int)((long)statusOfDTC | mask);
                    }
                }
            }
            catch (Exception e) {
                this.logger.logThrowable(e);
                this.logger.debug(SRV_EXTENDED_RESPONSE[i] + " not found!");
            }
            mask <<= 1;
        }
        this.logger.debug("DTC state: " + Long.toBinaryString(statusOfDTC));
        return statusOfDTC;
    }

    protected static String getInfo(MCDResponseParameter param) {
        try {
            return " \t" + param.getShortName() + " \tHasValue:" + (param.getValue() != null) + " \tHasChilds:" + param.getParameters().getCount();
        }
        catch (Exception exception) {
            return " [--]";
        }
    }

    protected void collectDTCs() throws IllegalAccessException {
        try {
            this.logger.debug("Collect DTC List");
            MCDDbDiagTroubleCodes dtcs = this.logicalLink.getDbObject().getDbLocation().getDbDTCs(0, 0);
            int i = 0;
            while ((long)i < dtcs.getCount()) {
                MCDDbDiagTroubleCode dbDTC = dtcs.getItemByIndex((long)i);
                this.dtcToDisplayCode.put(new Long(dbDTC.getTroubleCode()), dbDTC);
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
            this.jobStatus = 1;
            throw new IllegalAccessException();
        }
    }

    static long toSae(String s) {
        if (s == null || "".equals(s)) {
            return 0L;
        }
        char[] ch = s.toCharArray();
        if (ch[0] == 'P' && ch[1] == '0') {
            ch[0] = 48;
            ch[1] = 48;
        } else if (ch[0] == 'P' && ch[1] == '1') {
            ch[0] = 48;
            ch[1] = 49;
        } else if (ch[0] == 'P' && ch[1] == '2') {
            ch[0] = 48;
            ch[1] = 50;
        } else if (ch[0] == 'P' && ch[1] == '3') {
            ch[0] = 48;
            ch[1] = 51;
        } else if (ch[0] == 'U' && ch[1] == '0') {
            ch[0] = 48;
            ch[1] = 67;
        } else if (ch[0] == 'U' && ch[1] == '1') {
            ch[0] = 48;
            ch[1] = 68;
        } else if (ch[0] == 'U' && ch[1] == '2') {
            ch[0] = 48;
            ch[1] = 69;
        } else if (ch[0] == 'U' && ch[1] == '3') {
            ch[0] = 48;
            ch[1] = 70;
        } else if (ch[0] == 'B' && ch[1] == '0') {
            ch[0] = 48;
            ch[1] = 56;
        } else if (ch[0] == 'B' && ch[1] == '1') {
            ch[0] = 48;
            ch[1] = 57;
        } else if (ch[0] == 'B' && ch[1] == '2') {
            ch[0] = 48;
            ch[1] = 65;
        } else if (ch[0] == 'C' && ch[1] == '0') {
            ch[0] = 48;
            ch[1] = 52;
        } else if (ch[0] == 'C' && ch[1] == '1') {
            ch[0] = 48;
            ch[1] = 53;
        } else if (ch[0] == 'C' && ch[1] == '2') {
            ch[0] = 48;
            ch[1] = 54;
        } else {
            return 0L;
        }
        return Long.parseLong(String.valueOf(ch), 16);
    }

    protected void setStatus(MCDResponse jobResponse, int pJobStatus) {
        MCDResponseParameters params = null;
        try {
            params = jobResponse.getResponseParameters();
            MCDResponseParameter param = params.getItemByName("OPA_JobStatuInfor");
            this.logger.debug("Type of OPA_JobStatuInfor: " + McdEnumDecoder.decodeMcdDataType(param.getType()));
            MCDValue value = this.jobApi.createValue(14);
            value.setValueAsString(this.getJobStatusInformation());
            param.setValue(value);
            try {
                param = params.getItemByName("OPA_JobStatuCode");
                value = this.jobApi.createValue(11);
                value.setUint32((long)pJobStatus);
                param.setValue(value);
            }
            catch (Exception e) {
                this.logger.debug("Set Status Code failed!");
                this.logger.logThrowable(e);
            }
        }
        catch (Exception e) {
            this.logger.debug("Set Status failed!");
            this.logger.logThrowable(e);
        }
    }

    protected void setNumberOfDTCs(MCDResponse jobResponse, long pNumberOfDTCs) {
        MCDResponseParameters params = null;
        MCDResponseParameter param_jobResult = null;
        MCDResponseParameters params_jobResult = null;
        MCDResponseParameter param_numberOfDTCs = null;
        MCDValue value_numberOfDTCs = null;
        try {
            params = jobResponse.getResponseParameters();
            param_jobResult = params.getItemByName("OPA_JobResul");
            params_jobResult = param_jobResult.getParameters();
            param_numberOfDTCs = params_jobResult.getItemByName("Param_NumbeOfDTCs");
            value_numberOfDTCs = this.jobApi.createValue(11);
            value_numberOfDTCs.setUint32(pNumberOfDTCs);
            param_numberOfDTCs.setValue(value_numberOfDTCs);
        }
        catch (Exception e) {
            this.logger.debug("Set number of DTCs failed!");
            this.logger.logThrowable(e);
        }
    }

    protected void setActiveParam(long dtcState, MCDResponseParameter dtcInfoRecor) {
        MCDResponseParameter structure = null;
        try {
            this.logger.debug("Set DTC active bit Param");
            structure = dtcInfoRecor.getParameters().getCount() == 1L && dtcInfoRecor.getParameters().getItemByIndex(0L).getType() == 17 ? dtcInfoRecor.getParameters().getItemByIndex(0L) : dtcInfoRecor;
            MCDResponseParameter param = structure.getParameters().getItemByName("Param_Activ");
            MCDValue value = this.jobApi.createValue(11);
            value.setUint32(dtcState & 1L);
            param.setValue(value);
        }
        catch (Exception e) {
            this.logger.logThrowable(e);
        }
    }

    protected int addOutputParameters(MCDResponse pResponse) {
        return 0;
    }
}

