;**
;**  This CADKEY LISP program is provided with CADKEY LISP free of charge.
;**  This and other example programs are for demonstration purposes and
;**  should be thoroughly tested and inspected prior to implementation in
;**  any CADKEY LISP application program.  BitWise Solutions does not
;**  warrant the functionality nor correctness of this or any example
;**  program.  All or portions of this example program may be included
;**  in an CADKEY LISP application program provided the following copyright
;**  line appears at the beginning of the application:
;**                 Copyright 1994, BitWise Solutions
;**
;**  Copyright 1994, BitWise Solutions.  All rights reserved.
;**
;** -----------------------------------------------------------------------
;**  Change.lsp
;**
;**  This example program shows the use of the ENTMOD function to change the
;**  attributes of entities. Type 'ch' to change the color, line type,
;**  layer or point of a line.  Type 'chgtext' to change the string of
;**  a text entity.
;** -----------------------------------------------------------------------
;**
(defun c:ch ( / ent mode ncolor )
	(setq ent (entget (car (entsel "\nSelect entity to change: "))))
	(initget 0 "Color Ltype lAyer Point")
	(setq mode (getkword "\nChange: Color/Ltype/lAyer/Point: "))
	(if (= mode "Color")
		(progn
			(setq
				ncolor (getint "\nNew color number: ")
				ent (subst (cons 62 ncolor) (assoc 62 ent) ent)
			)
			(entmod ent)
		)
	)
	(if (= mode "Ltype")
		(progn
			(setq
				nltype (getint "\nNew line type: ")
				ent (subst (cons 6 (itoa nltype)) (assoc 6 ent) ent)
			)
			(entmod ent)
		)
	)
	(if (= mode "lAyer")
		(progn
			(setq
				nltype (getint "\nNew layer name: ")
				ent (subst (cons 8 (itoa nltype)) (assoc 8 ent) ent)
			)
			(entmod ent)
		)
	)
	(if (and (= mode "Point") (= (cdr (assoc 0 ent)) "LINE"))
		(progn
			(setq
				npt (getpoint "\nSelect new point: ")
			)
			(setq
				d1 (distance (cdr (assoc 10 ent)) npt)
				d2 (distance (cdr (assoc 11 ent)) npt)
			)
			(if (< d1 d2)
				(setq ent (subst (cons 10 npt) (assoc 10 ent) ent))
				(setq ent (subst (cons 11 npt) (assoc 11 ent) ent))
			)
			(entmod ent)
		)
	)
	(princ)
)


(defun c:chgtext ( / ent string )
	(setq ent (entget (car (entsel "\nSelect text to modify: "))))
	(if (= (cdr (assoc 0 ent)) "TEXT")
		(progn
			(setq string (getstring T "\nEnter new text: "))
			(setq ent (subst (cons 1 string) (assoc 1 ent) ent))
			(entmod ent)
		)
	)
	(princ)
)
	
(defun c:fun ( / x c ent ma )
	(setq
		ent (entget (car (entsel "Select entity 'color scroll':")))
		ma (getint "\nNumber of iterations?:")
		x 0
	)
	(setq c 1)
	(while (/= x ma)
		(setq ent (subst (cons 62 c) (assoc 62 ent) ent))
		(entmod ent)
		(setq c (1+ c))
		(if (= c 7)
			(progn
				(setq c 1)
			)
		)
		(setq x (1+ x))
	)
)
	
	
