;**
;**  This CADKEY LISP program is provided with CADKEY LISP free of charge.
;**  This and other example programs are for demonstration purposes and
;**  should be thoroughly tested and inspected prior to implementation in
;**  any CADKEY LISP application program.  BitWise Solutions does not
;**  warrant the functionality nor correctness of this or any example
;**  program.  All or portions of this example program may be included
;**  in an CADKEY LISP application program provided the following copyright
;**  line appears at the beginning of the application:
;**                 Copyright 1994, BitWise Solutions
;**
;**  Copyright 1994, BitWise Solutions.  All rights reserved.
;**
;** -----------------------------------------------------------------------
;**  Complex.Lsp
;**
;**  This program creates a polyline by prompting the user for
;**  points to include as vertices on the polyline. Type 'polymake' to
;**  execute the program.  An example of the ENTMOD function is also
;**  included.  Type 'polymod' to run the modification routine.  Note
;**  that vertex numbers on polylines begin at zero.  Also included is
;**  an example of retrieving all polyline vertices using the ENTGET
;**  function.  Type 'polyget' to run this routine.
;**
;** -----------------------------------------------------------------------
;**
(defun c:polymake ( / pt )

        ;
        ;       Create the header of the polyline.
        ;
        (entmake '(     (0 . "POLYLINE")
                                        (62 . 1)                                ; color
                                        (40 . 0.0)                      ; starting width
                                        (41 . 0.0)                      ; ending width
                                        (76 . 0)                                ; display style
                                        (77 . 1)                                ; fill mode
                                )
        )

        ;
        ;       Get the starting point for the polyline.
        ;
        (setq pt (getpoint "Starting point for polyline: ") )

        ;
        ;       Give this point (vertice) to entmake.
        ;
        (entmake (list (cons 0 "VERTEX")        (cons 10 pt) ) )

        ;
        ;       Gather all remaining points from the user.
        ;
        (while (not (null pt))
                (setq pt (getpoint "Next point: ") )
                (if (not (null pt))
                        (entmake (list (cons 0 "VERTEX")        (cons 10 pt) ) )
                )
        )

        ;
        ;       Finally, complete the complex entity creation
        ;       using entmake with a SEQEND.
        ;
        (entmake        '( (0 . "SEQEND") ) )

        (princ)
)



;
;       This program retrieves a polyline from the database
;
(defun c:polyget ( / ename entity idx )
        
        ;       Get the entity to be retrieved and the data for it.

        (setq 
                ename (car (entsel "Select polyline to be retrieved: "))
                entity (entget ename)
        )

        (if (/= (cdr (assoc 0 entity)) "POLYLINE")
                (princ "Entity selected is not a polyline.")
                ; else
                (progn
                        (princ "Header information on polyline: ")
                        (setq idx 0)
                        
                        ; Print out each dotted pair in the header.
                        (repeat (length entity)
                                (princ (nth idx entity))
                                (princ "\n")
                                (setq idx (1+ idx))
                        )

                        (princ "\n")
                        (princ "Vertices follow...\n")
                        (setq
                                ename (entnext ename)
                                entity (entget ename)
                        )
                        (while (/= (cdr (assoc 0 entity)) "SEQEND")
                                (princ "Vertice at: ")
                                (princ (assoc 10 entity))
                                (princ "\n")
                                (setq 
                                        ename (entnext ename)
                                        entity (entget ename)
                                )
                        )
                )
        )
        (princ)
)




;
;       This program retrieves a polyline from the database and
;       modifies the vertice from which the segment of the polyline
;       was created.  Note: Individual vertices cannot be identified
;       using entget.
;
(defun c:polymod ( / ename entity pt )
        
        ;       Get the entity to be retrieved and the data for it.

        (setq
                ename (car (entsel "Select polyline to be modified: ") )
                entity (entget ename)
        )
        (if (/= (cdr (assoc 0 entity)) "POLYLINE")
                (princ "Entity selected is not a polyline.")
                ; else
                (progn
                        
                        (setq
                                idx (getint "Enter vertex number to modify: ")
                                pt (getpoint "Enter new vertex point: ")
                        )

                        ; Get the vertices and highlight them.
                        (setq
                                ename (entnext ename)
                                entity (entget ename)
                        )

                        (while (/= (cdr (assoc 0 entity)) "SEQEND")
                                ;
                                ; Find the vertex number 'idx'.  Use code 78.
                                (if (= (cdr (assoc 78 entity)) idx)
                                        (progn
                                                (setq entity (subst (cons 10 pt) (assoc 10 entity) entity))
                                                (entmod entity)
                                        )
                                )

                                (setq 
                                        ename (entnext ename)
                                        entity (entget ename)
                                )
                        )
                )
        )
        (princ)
)


        
